/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.File;
import java.util.Vector;
import shared.FileUtils;
import shared.b;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bytes {
    byte[] bytes;

    public boolean equalsString(String str) {
        Bytes b2 = Bytes.create(str);
        return this.isequal(b2);
    }

    public static Bytes create(Vector<Byte> bytevector) {
        Bytes result2 = new Bytes();
        int size = bytevector.size();
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = bytevector.get(i);
        }
        result2.bytes = result;
        return result2;
    }

    public static Bytes create(byte ... bytelist) {
        Bytes result = new Bytes();
        result.bytes = bytelist;
        return result;
    }

    public static Bytes create(String str) {
        int length = str.length();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(str.charAt(i) & 0xFF);
        }
        Bytes result2 = new Bytes();
        result2.bytes = result;
        return result2;
    }

    public static Bytes createFromFile(String filename) {
        return Bytes.create(FileUtils.ReadFile(filename));
    }

    public static Bytes createFromFile(File filename) {
        return Bytes.create(FileUtils.ReadFile(filename));
    }

    public static Bytes createFromArray(byte[] array, int offset, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = array[offset + i];
        }
        return new Bytes(result);
    }

    public static void copyFromArrayToArray(byte[] inArray, int inOffset, byte[] outArray, int outOffset, int length) {
        for (int i = 0; i < length; ++i) {
            outArray[outOffset + i] = inArray[inOffset + i];
        }
    }

    public static int BytesToInt32(byte[] bytes, int startpos) {
        int a = Bytes.ByteToInt32(bytes[startpos + 0]) << 0;
        int b2 = Bytes.ByteToInt32(bytes[startpos + 1]) << 8;
        int c = Bytes.ByteToInt32(bytes[startpos + 2]) << 16;
        int d = Bytes.ByteToInt32(bytes[startpos + 3]) << 24;
        int result = a | b2 | c | d;
        return result;
    }

    public static short BytesToInt16(byte[] bytes, int startpos) {
        int a = Bytes.ByteToInt32(bytes[startpos + 0]) << 0;
        int b2 = Bytes.ByteToInt32(bytes[startpos + 1]) << 8;
        short result = (short)(a | b2);
        return result;
    }

    public static long BytesToInt64(byte[] bytes, int startpos) {
        int a = Bytes.ByteToInt32(bytes[startpos + 0]) << 0;
        int b2 = Bytes.ByteToInt32(bytes[startpos + 1]) << 8;
        int c = Bytes.ByteToInt32(bytes[startpos + 2]) << 16;
        int d = Bytes.ByteToInt32(bytes[startpos + 3]) << 24;
        int e2 = Bytes.ByteToInt32(bytes[startpos + 0]) << 32;
        int f = Bytes.ByteToInt32(bytes[startpos + 1]) << 40;
        int g = Bytes.ByteToInt32(bytes[startpos + 2]) << 48;
        int h = Bytes.ByteToInt32(bytes[startpos + 3]) << 56;
        int result = a | b2 | c | d | e2 | f | g | h;
        return result;
    }

    public Bytes substr(int start, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.bytes[start + i];
        }
        return new Bytes(result);
    }

    public Bytes substr(int start) {
        return this.substr(start, this.length() - start);
    }

    public static byte[] flatten(byte[][] bytes) {
        int size = 0;
        for (int i = 0; i < bytes.length; ++i) {
            size += bytes[i].length;
        }
        byte[] result = new byte[size];
        int pos = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int l = bytes[i].length;
            Bytes.copyFromArrayToArray(bytes[i], 0, result, pos, l);
            pos += l;
        }
        return result;
    }

    public void saveAsFile(String filename) {
        FileUtils.WriteFile(filename, this.bytes);
    }

    public boolean isequal(Bytes b2) {
        if (this.bytes.length != b2.bytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == b2.bytes[i]) continue;
            return false;
        }
        return true;
    }

    private Bytes() {
    }

    public Bytes(byte[] data) {
        this.bytes = data;
    }

    public Bytes(int size) {
        this.bytes = new byte[size];
    }

    public Bytes(Vector<Byte> bytevector) {
        this.bytes = new byte[bytevector.size()];
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = bytevector.get(i);
        }
    }

    public Bytes(String string) {
        this.bytes = b.StringToBytes(string);
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    public byte getbyte(int i) {
        return this.bytes[i];
    }

    public String toString() {
        return b.BytesToString(this.bytes);
    }

    public void setWithString(String str) {
        this.bytes = b.StringToBytes(str);
    }

    public Bytes append(Bytes appendage) {
        byte[] result = new byte[this.bytes.length + appendage.length()];
        this.writeIntoBuffer(result, 0);
        appendage.writeIntoBuffer(result, this.length());
        return new Bytes(result);
    }

    public void writeIntoBuffer(byte[] buffer, int pos) {
        for (int i = 0; i < this.bytes.length; ++i) {
            buffer[pos + i] = this.bytes[i];
        }
    }

    public void appendToVector(Vector<Byte> vector) {
        for (int i = 0; i < this.bytes.length; ++i) {
            vector.add(this.bytes[i]);
        }
    }

    public boolean startsWith(Bytes startPhrase) {
        if (startPhrase.length() > this.bytes.length) {
            return false;
        }
        for (int i = 0; i < startPhrase.length(); ++i) {
            if (startPhrase.bytes[i] == this.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public Bytes remove(byte bytetoremove) {
        Vector<Byte> result = new Vector<Byte>();
        int i = 0;
        while (i < this.bytes.length) {
            byte curbyte = this.bytes[i];
            if (bytetoremove == curbyte) {
                ++i;
                continue;
            }
            result.add(curbyte);
            ++i;
        }
        return new Bytes(result);
    }

    public Bytes replace(byte oldbyte, Bytes newbytes) {
        Vector<Byte> result = new Vector<Byte>();
        int i = 0;
        while (i < this.bytes.length) {
            byte curbyte = this.bytes[i];
            if (oldbyte == curbyte) {
                newbytes.appendToVector(result);
                i += newbytes.length();
                continue;
            }
            result.add(curbyte);
            ++i;
        }
        return new Bytes(result);
    }

    public Bytes replace(Bytes oldbytes, Bytes newbytes) {
        Vector<Byte> result = new Vector<Byte>();
        int i = 0;
        while (i < this.bytes.length) {
            byte curbyte = this.bytes[i];
            if (oldbytes.bytes[0] == curbyte && oldbytes.length() < this.bytes.length - i) {
                int j;
                for (j = 0; j < oldbytes.length() && this.bytes[i + j] == oldbytes.bytes[j]; ++j) {
                }
                if (j == oldbytes.length()) {
                    newbytes.appendToVector(result);
                    i += j;
                    continue;
                }
                result.add(curbyte);
                ++i;
                continue;
            }
            result.add(curbyte);
            ++i;
        }
        return new Bytes(result);
    }

    public int length() {
        return this.bytes.length;
    }

    public Bytes[] split(byte splitter) {
        int i;
        int length = this.bytes.length;
        int splittercount = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.bytes[i2] != splitter) continue;
            ++splittercount;
        }
        Bytes[] result = new Bytes[splittercount + 1];
        int cursubset = 0;
        int posinsubset = 0;
        for (i = 0; i < length; ++i) {
            if (this.bytes[i] == splitter) {
                result[cursubset] = new Bytes(posinsubset);
                ++cursubset;
                posinsubset = 0;
                continue;
            }
            ++posinsubset;
        }
        result[cursubset] = new Bytes(posinsubset);
        cursubset = 0;
        posinsubset = 0;
        for (i = 0; i < length; ++i) {
            byte curbyte = this.bytes[i];
            if (curbyte == splitter) {
                ++cursubset;
                posinsubset = 0;
                continue;
            }
            result[cursubset].bytes[posinsubset] = curbyte;
            ++posinsubset;
        }
        return result;
    }

    public static int ByteToInt32(byte b2) {
        return b2 & 0xFF;
    }

    public static short ByteToInt16(byte b2) {
        return (short)(b2 & 0xFF);
    }

    public static int Int16ToInt32(short s) {
        return s & 0xFFFF;
    }

    public static long Int32ToInt64(int i) {
        return (long)i & 0xFFFFFFFFL;
    }
}

