/*
 * Decompiled with CFR 0.152.
 */
package mystProxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mystProxy.handlingException;
import mystProxy.packageInfo;
import mystProxy.proxySettings;
import org.eclipse.jetty.server.Request;
import shared.m;

public class fileHandler {
    public static void handle(String domain2, String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        String packageToUse = null;
        if (proxySettings.usecookies) {
            for (Cookie cookie : fileHandler.getCookies(request)) {
                if (!cookie.getName().equals("DrizzlePackage")) continue;
                packageToUse = cookie.getValue();
            }
        }
        String domain = domain2 == null ? request.getServerName() : domain2;
        packageInfo p = null;
        if (packageToUse != null) {
            p = proxySettings.packages.getPackageByName(packageToUse);
            if (p == null) {
                m.err("Package no longer exists: ", packageToUse);
                return;
            }
            if (!p.handlesDomain(domain)) {
                m.warn(p.name, " doesn't handle domain: ", domain);
                p = null;
            }
        }
        if (p == null) {
            p = proxySettings.packages.findPackageThatHandlesDomain(domain);
        }
        if (p == null) {
            m.warn("No package can be found that handles domain: ", domain);
            return;
        }
        fileHandler.handle2(p, domain, target, request, response, dispatch);
    }

    public static Cookie[] getCookies(HttpServletRequest request) {
        Cookie[] result = request.getCookies();
        if (result == null) {
            return new Cookie[0];
        }
        return result;
    }

    public static ZipEntry findEntryCaseInsensitive(ZipFile zip2, String entryname) {
        Enumeration<? extends ZipEntry> entries = zip2.entries();
        String entrynameLowercase = entryname.toLowerCase().replace("\\", "/").replace("//", "/");
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().toLowerCase().replace("\\", "/").equals(entrynameLowercase)) continue;
            return entry;
        }
        return null;
    }

    public static File findFileCaseInsensitive(File base, String filename) throws IOException {
        String[] parts = filename.toLowerCase().replace("\\", "/").split("/");
        File curbase = base;
        for (String part : parts) {
            if (part.equals("")) continue;
            File[] children = curbase.listFiles();
            boolean found = false;
            for (File f : children) {
                if (!f.getName().toLowerCase().equals(part)) continue;
                curbase = f;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        if (curbase.isFile()) {
            return curbase;
        }
        File[] children = curbase.listFiles();
        for (String defaultname : proxySettings.defaultFiles) {
            for (File f : children) {
                if (!f.getName().toLowerCase().equals(defaultname)) continue;
                return f;
            }
        }
        throw new handlingException("Can't find a default file for folder: " + filename);
    }

    public static void handleDone(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(200);
        ((Request)request).setHandled(true);
    }

    public static void handle2(packageInfo p, String domain, String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (proxySettings.usecookies) {
            Cookie c = new Cookie("DrizzlePackage", p.name);
            c.setPath("/");
            response.addCookie(c);
        }
        if (p.customSiteHandler == null) {
            fileHandler.handle3(p, domain, target, request, response, dispatch);
        } else {
            p.customSiteHandler.handle(p, domain, target, request, response, dispatch);
        }
    }

    public static void handle3(packageInfo p, String domain, String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        int actualRead;
        InputStream instream = fileHandler.readFile(p, domain, target);
        byte[] buffer = new byte[1024];
        ServletOutputStream outstream = response.getOutputStream();
        while ((actualRead = instream.read(buffer, 0, 1024)) != -1) {
            outstream.write(buffer, 0, actualRead);
        }
        fileHandler.handleDone(request, response);
        if (proxySettings.logFilesRead) {
            m.msg("Read file: ", domain + target);
        }
        instream.close();
    }

    public static void disableCaching(HttpServletResponse response) {
        response.addHeader("Progma", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Expires", "Mon, 15 Feb 1982 10:00:00 GMT");
    }

    public static InputStream readFile(packageInfo p, String domain, String filename) throws IOException {
        if (!p.isZip) {
            String fullname = "/" + p.name + "/" + domain + "/" + filename;
            File file2 = fileHandler.findFileCaseInsensitive(new File(proxySettings.basefolder), fullname);
            if (file2 == null || !file2.exists()) {
                throw new handlingException("Tried to read file that doesn't exist: " + fullname);
            }
            if (!file2.getPath().toLowerCase().startsWith(proxySettings.basefolder.toLowerCase())) {
                throw new handlingException("A file tried to access outside the basefolder: " + file2.getPath());
            }
            return new FileInputStream(file2);
        }
        String zipfilename = proxySettings.basefolder + "/" + p.name;
        ZipFile zip2 = new ZipFile(new File(zipfilename), 1);
        ZipEntry entry = fileHandler.findEntryCaseInsensitive(zip2, domain + "/" + filename);
        InputStream instream = zip2.getInputStream(entry);
        return instream;
    }
}

