/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import moulserver.AuthServer;
import moulserver.ClientNodesHelper;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.FileServer;
import moulserver.GameMainServer;
import moulserver.GateServer;
import moulserver.Node;
import moulserver.SecureDownloadManifest;
import moulserver.Server;
import moulserver.ServerType;
import moulserver.Version;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import prpobjects.Guid;
import shared.Concurrent;
import shared.CryptoBytedeque;
import shared.CryptoBytestream;
import shared.IBytedeque;
import shared.IBytestream;
import shared.LargeInteger;
import shared.RandomUtils;
import shared.Str;
import shared.StreamBytedeque;
import shared.StreamBytestream;
import shared.b;
import shared.m;
import shared.nested;
import shared.uncaughtexception;
import shared.zip;
import uru.UruCrypt;
import uru.server.MoulFileInfo;

public abstract class Client {
    AuthServer.AcctLoginReply logindetails;
    private AtomicInteger curtransid = new AtomicInteger();

    public int getNextTransid() {
        return this.curtransid.incrementAndGet();
    }

    public static class Trigger
    extends Waiter {
        private CountDownLatch latch = new CountDownLatch(1);
        private Server.ServerMsg msg;

        public Server.ServerMsg await() {
            while (true) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return this.msg;
        }

        public void trigger(Server.ServerMsg msg) {
            this.msg = msg;
            this.latch.countDown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallbackWaiter
    extends Waiter {
        Concurrent.Callback<Server.ServerMsg> callback;

        public CallbackWaiter(Concurrent.Callback<Server.ServerMsg> callback) {
            this.callback = callback;
        }

        @Override
        public void trigger(Server.ServerMsg msg) {
            this.callback.callback(msg);
        }
    }

    public static abstract class Waiter {
        public void trigger(Server.ServerMsg msg) {
            throw new uncaughtexception("Trigger is unimplemented in subclass: " + this.getClass().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ClientConnection {
        public MsgHandler msghandler = null;
        protected Version ver;
        protected ServerType type;
        protected Socket sock;
        protected InputStream _in2;
        protected OutputStream _out2;
        protected IBytestream in;
        protected IBytedeque out;
        protected ClientConnectionReadThread readthread;
        protected ClientConnectionWriteThread writethread;
        protected ConnectionState.NetworkHeader header;
        protected Boolean doEncrypt;
        protected String server_B;
        protected String server_mod;
        protected Integer server_base;
        protected byte[] dhkey;
        protected byte[] rc4key;
        protected boolean isConnected;
        public final LinkedBlockingQueue<Comm.CommItem> items = Concurrent.getConcurrentBlockingQueue();
        public final ConcurrentHashMap<Object, Waiter> waiters = Concurrent.getConcurrentHashMap();

        public void Connect() {
            this.readthread.start();
            this.writethread.start();
            this.SendMsg(this.header);
            if (this.doEncrypt.booleanValue()) {
                this.SendEncryption();
            }
            m.msg("connected!");
        }

        public void Disconnect() {
            try {
                this.sock.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this._in2.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                this._out2.close();
            }
            catch (Exception e4) {
                // empty catch block
            }
            try {
                this.readthread.join(400L);
                if (this.readthread.isAlive()) {
                    m.err("Thread hasn't died. Killing it...");
                    this.readthread.stop();
                }
            }
            catch (Exception e5) {
                // empty catch block
            }
            try {
                this.items.add(Comm.CommItem.Terminate());
                this.writethread.join(400L);
                if (this.writethread.isAlive()) {
                    m.err("Write thread hasn't died. Killing it...");
                    this.writethread.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ClientConnection(Version ver, ServerType type, String hostname) {
            try {
                int port = ver.port;
                this.ver = ver;
                this.type = type;
                this.sock = new Socket(hostname, port);
                this._in2 = this.sock.getInputStream();
                this._out2 = this.sock.getOutputStream();
                int av = this._in2.available();
                this.in = new StreamBytestream(this._in2);
                this.out = new StreamBytedeque(this._out2);
                this.readthread = new ClientConnectionReadThread();
                this.writethread = new ClientConnectionWriteThread();
            }
            catch (Exception e2) {
                Exception e22 = nested.getRootOfException(e2);
                if (e22 instanceof ConnectException && e22.getMessage().equals("Connection refused: connect")) {
                    m.err("Server refuses to connect.");
                }
                throw new nested(e2);
            }
        }

        protected void SendEncryption() {
            ConnectionState.NetCliConnectMsg msg = new ConnectionState.NetCliConnectMsg();
            LargeInteger _B = new LargeInteger(this.server_B);
            LargeInteger _mod = new LargeInteger(this.server_mod);
            LargeInteger _a = new LargeInteger(512, RandomUtils.rng);
            LargeInteger _base = new LargeInteger(this.server_base.intValue());
            LargeInteger _key = _B.modPow(_a, _mod);
            LargeInteger _A = _base.modPow(_a, _mod);
            this.dhkey = _key.toBytes(64);
            msg.A_bytes = _A.toBytes(64);
            m.msg("waiting for connection");
            ConnectionState.NetCliEncryptMsg request = (ConnectionState.NetCliEncryptMsg)this.SendMsgAndWaitForClass(msg, ConnectionState.NetCliEncryptMsg.class);
        }

        private void EncryptConnection() {
            if (this.rc4key == null) {
                throw new uncaughtexception("Empty key");
            }
            RC4Engine rc4in = new RC4Engine();
            RC4Engine rc4out = new RC4Engine();
            KeyParameter keyparams = new KeyParameter(this.rc4key);
            rc4in.init(true, keyparams);
            rc4out.init(true, keyparams);
            InputStream in_sub = this.in.getChildStreamIfExists();
            OutputStream out_sub = this.out.getChildStreamIfExists();
            this.in = new CryptoBytestream(in_sub, rc4in);
            this.out = new CryptoBytedeque(out_sub, rc4out);
            m.msg("ConnectServer: now encrypted.");
        }

        public void SendMsg(Server.ServerMsg msg) {
            this.items.add(Comm.CommItem.SendMessage(msg));
        }

        public <T extends Server.ServerMsg> T SendMsgAndWaitForClass(Server.ServerMsg msg, Class klassToWaitFor) {
            Server.ServerMsg reply;
            Trigger trigger = new Trigger();
            this.waiters.put(klassToWaitFor, trigger);
            this.SendMsg(msg);
            Server.ServerMsg r = reply = trigger.await();
            return (T)r;
        }

        public <T extends Server.ServerMsg> T SendMsgAndWaitForTransid(Server.ServerMsg msg) {
            if (msg.transid() == null) {
                m.throwUncaughtException("Class does not have a transid(): " + msg.getClass().getName());
            }
            T r = this.SendMsgAndWaitForTransid(msg, msg.transid());
            return r;
        }

        private <T extends Server.ServerMsg> T SendMsgAndWaitForTransid(Server.ServerMsg msg, int transid) {
            Server.ServerMsg reply;
            Trigger trigger = new Trigger();
            this.waiters.put(transid, trigger);
            this.SendMsg(msg);
            Server.ServerMsg r = reply = trigger.await();
            return (T)r;
        }

        public void SendMsgAndRegisterTransidCallback(Server.ServerMsg msg, Concurrent.Callback<Server.ServerMsg> callback) {
            if (msg.transid() == null) {
                m.throwUncaughtException("Class does not have a transid(): " + msg.getClass().getName());
            }
            CallbackWaiter waiter = new CallbackWaiter(callback);
            this.waiters.put(msg.transid(), waiter);
            this.SendMsg(msg);
        }

        public class ClientConnectionWriteThread
        extends Thread {
            public void run() {
                block9: {
                    try {
                        while (true) {
                            try {
                                while (true) {
                                    Comm.CommItem item = ClientConnection.this.items.take();
                                    if (item.type == Comm.CommItemType.SendMessage) {
                                        this.SendMsg2(item.msg);
                                        continue;
                                    }
                                    if (item.type != Comm.CommItemType.Terminate) {
                                        m.throwUncaughtException("Unable to handle CommItem: " + item.type.toString());
                                        continue;
                                    }
                                    break block9;
                                    break;
                                }
                            }
                            catch (InterruptedException e2) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e3) {
                        Exception e2 = nested.getRootOfException(e3);
                        if (e2 instanceof SocketException && e2.getMessage().equals("Connection reset")) {
                            m.msg("Server disconnected from us.");
                        }
                        throw new nested(e3);
                    }
                }
            }

            private void SendMsg2(Server.ServerMsg msg) {
                byte[] msgdata = msg.GetMsgBytes();
                ClientConnection.this.out.writeBytes(msgdata);
                ClientConnection.this.out.flush();
            }
        }

        public class ClientConnectionReadThread
        extends Thread {
            public void run() {
                if (ClientConnection.this.doEncrypt.booleanValue()) {
                    Server.ServerMsg encmsg = this.HandleConnectMsg();
                    if (ClientConnection.this.msghandler != null) {
                        ClientConnection.this.msghandler.HandleMsg(encmsg, ClientConnection.this);
                    }
                    this.HandleMsg2(encmsg);
                }
                try {
                    while (true) {
                        Server.ServerMsg msg = this.ReadMessage();
                        if (ClientConnection.this.msghandler != null) {
                            ClientConnection.this.msghandler.HandleMsg(msg, ClientConnection.this);
                        }
                        this.HandleMsg2(msg);
                    }
                }
                catch (Exception e2) {
                    Exception e22 = nested.getRootOfException(e2);
                    if (e22 instanceof SocketException && e22.getMessage().equals("Connection reset")) {
                        m.msg("Server disconnected from us.");
                    } else if (e22 instanceof SocketException && e22.getMessage().equals("socket closed")) {
                        m.msg("Disconnected from server.");
                    } else {
                        throw new nested(e2);
                    }
                    return;
                }
            }

            private void HandleMsg2(Server.ServerMsg msg) {
                Class<?> klass;
                Waiter klassTrigger;
                Waiter trigger;
                Integer transid;
                if (msg instanceof ConnectionState.NetCliEncryptMsg) {
                    ConnectionState.NetCliEncryptMsg request = (ConnectionState.NetCliEncryptMsg)msg.cast();
                    ClientConnection.this.rc4key = new byte[7];
                    for (int i = 0; i < 7; ++i) {
                        ClientConnection.this.rc4key[i] = (byte)(ClientConnection.this.dhkey[i] ^ request.keymsg[i]);
                    }
                    ClientConnection.this.EncryptConnection();
                }
                if ((transid = msg.transid()) != null && (trigger = ClientConnection.this.waiters.remove(transid)) != null) {
                    trigger.trigger(msg);
                }
                if ((klassTrigger = ClientConnection.this.waiters.remove(klass = msg.getClass())) != null) {
                    klassTrigger.trigger(msg);
                }
            }

            private Server.ServerMsg ReadMessage() {
                switch (ClientConnection.this.type) {
                    case GateServer: {
                        return GateServer.ReadMessage(ClientConnection.this.in, false);
                    }
                    case FileServer: {
                        return FileServer.ReadMessage(ClientConnection.this.in, false);
                    }
                    case AuthServer: {
                        return AuthServer.ReadMessage(ClientConnection.this.in, false);
                    }
                    case GameServer: {
                        return GameMainServer.ReadMessage(ClientConnection.this.in, false);
                    }
                }
                throw new uncaughtexception("Unhandled state");
            }

            private Server.ServerMsg HandleConnectMsg() {
                IBytestream c = ClientConnection.this.in;
                byte type = c.readByte();
                byte msgsize = c.readByte();
                if (type == 1) {
                    return new ConnectionState.NetCliEncryptMsg(c);
                }
                throw new uncaughtexception("Unhandled NetCliServer msg: " + Byte.toString(type));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FileConnection
    extends ClientConnection {
        public FileConnection(Version ver, String hostname) {
            super(ver, ServerType.FileServer, hostname);
            this.header = ConnectionState.NetworkHeader.createFileHeader(ver);
            this.doEncrypt = false;
            this.Connect();
        }

        public byte[] GetFile(MoulFileInfo mfi) {
            byte[] filedata = this.GetRawFile(mfi.Downloadname.toString());
            if (!mfi.Hash.toString().equals(mfi.CompressedHash.toString())) {
                filedata = zip.decompressGzip(filedata);
            }
            return filedata;
        }

        private byte[] GetRawFile(String filename) {
            FileServer.FileDownloadRequest request = new FileServer.FileDownloadRequest();
            request.transId = Client.this.getNextTransid();
            request.filename = new Str(filename);
            request.buildId = 0;
            FileServer.FileDownloadReply reply = (FileServer.FileDownloadReply)this.SendMsgAndWaitForTransid(request);
            byte[] result = new byte[reply.filesize];
            int curpos = 0;
            b.CopyBytes(reply.buffer, result, curpos);
            curpos += reply.buffer.length;
            while (curpos != result.length) {
                FileServer.FileDownloadChunkAck ack = new FileServer.FileDownloadChunkAck();
                ack.transId = Client.this.getNextTransid();
                ack.readerId = reply.readerId;
                FileServer.FileDownloadReply reply2 = (FileServer.FileDownloadReply)this.SendMsgAndWaitForTransid(ack);
                b.CopyBytes(reply2.buffer, result, curpos);
                curpos += reply2.buffer.length;
            }
            FileServer.FileDownloadChunkAck finalack = new FileServer.FileDownloadChunkAck();
            finalack.transId = Client.this.getNextTransid();
            finalack.readerId = reply.readerId;
            this.SendMsg(finalack);
            return result;
        }

        public ArrayList<MoulFileInfo> GetManifest(String group) {
            if (!(group.equals("ExternalPatcher") || group.equals("ThinExternal") || group.equals("External"))) {
                m.throwUncaughtException("invalid group");
            }
            ArrayList<MoulFileInfo> files = new ArrayList<MoulFileInfo>();
            FileServer.ManifestRequest request = new FileServer.ManifestRequest();
            request.transId = Client.this.getNextTransid();
            request.group = new Str(group);
            request.buildId = 0;
            FileServer.ManifestReply reply = (FileServer.ManifestReply)this.SendMsgAndWaitForTransid(request);
            int nummanifestparts = 1;
            files.addAll(reply.manifest.getFiles());
            if (files.size() == reply.manifest.count) {
                return files;
            }
            do {
                FileServer.ManifestEntryAck ack = new FileServer.ManifestEntryAck();
                ack.transId = Client.this.getNextTransid();
                ack.readerId = reply.readerId;
                FileServer.ManifestReply reply2 = (FileServer.ManifestReply)this.SendMsgAndWaitForTransid(ack);
                ++nummanifestparts;
                files.addAll(reply2.manifest.getFiles());
            } while (files.size() != reply.manifest.count);
            return files;
        }
    }

    public class GameConnection
    extends ClientConnection {
        public GameConnection(Version ver, String gameserveraddress, Guid accountGuid, Guid ageInstanceGuid) {
            super(ver, ServerType.GameServer, gameserveraddress);
            this.header = ConnectionState.NetworkHeader.createGameHeader(ver, accountGuid, ageInstanceGuid);
            this.doEncrypt = true;
            this.server_B = ver.gameserver_B;
            this.server_mod = ver.gameserver_mod;
            this.server_base = ver.gameserver_base;
            this.Connect();
        }
    }

    public class GateConnection
    extends ClientConnection {
        public GateConnection(Version ver) {
            super(ver, ServerType.GateServer, ver.gateserver);
            this.header = ConnectionState.NetworkHeader.createGateHeader(ver);
            this.doEncrypt = true;
            this.server_B = ver.gateserver_B;
            this.server_mod = ver.gateserver_mod;
            this.server_base = ver.gateserver_base;
            this.Connect();
        }

        public String GetFileSrvIp() {
            GateServer.FileSrvIpAddressRequest request = new GateServer.FileSrvIpAddressRequest();
            request.transId = Client.this.getNextTransid();
            request.u1 = 1;
            m.msg("waiting for filesrvip");
            GateServer.FileSrvIpAddressReply reply = (GateServer.FileSrvIpAddressReply)this.SendMsgAndWaitForTransid(request);
            return reply.address.toString();
        }

        @Deprecated
        public String GetAuthSrvIp() {
            GateServer.AuthSrvIpAddressRequest request = new GateServer.AuthSrvIpAddressRequest();
            request.transId = Client.this.getNextTransid();
            GateServer.AuthSrvIpAddressReply reply = (GateServer.AuthSrvIpAddressReply)this.SendMsgAndWaitForTransid(request);
            return reply.address.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthConnection
    extends ClientConnection {
        public List<AuthServer.AcctPlayerInfo> players;

        public AuthConnection(Version ver, String hostname) {
            super(ver, ServerType.AuthServer, hostname);
            this.players = null;
            this.msghandler = new MsgHandler(){

                public void HandleMsg(Server.ServerMsg msg, ClientConnection caller) {
                    if (msg instanceof AuthServer.AcctPlayerInfo) {
                        AuthConnection.this.players.add((AuthServer.AcctPlayerInfo)msg);
                    }
                }
            };
            this.header = ConnectionState.NetworkHeader.createAuthHeader(ver);
            this.doEncrypt = true;
            this.server_B = ver.authserver_B;
            this.server_mod = ver.authserver_mod;
            this.server_base = ver.authserver_base;
            this.Connect();
        }

        public boolean Login(String username, String password) {
            AuthServer.AcctLoginReply logreply;
            AuthServer.ClientRegisterRequest reg = new AuthServer.ClientRegisterRequest();
            reg.buildId = this.ver.buildId;
            AuthServer.ClientRegisterReply regreply = (AuthServer.ClientRegisterReply)this.SendMsgAndWaitForClass(reg, AuthServer.ClientRegisterReply.class);
            AuthServer.AcctLoginRequest request = new AuthServer.AcctLoginRequest();
            request.transId = Client.this.getNextTransid();
            request.clientchallenge = 0;
            request.accountName = new Str(username);
            request.setPassword(username, password, regreply.serverchallenge, request.clientchallenge);
            request.authToken = new Str("");
            request.OS = new Str("win");
            this.players = Concurrent.getThreadsafeList();
            Client.this.logindetails = logreply = (AuthServer.AcctLoginReply)this.SendMsgAndWaitForClass(request, AuthServer.AcctLoginReply.class);
            return logreply.result == 0;
        }

        public void GetNodeWithTransidCallback(int nodeIdx, Concurrent.Callback<Server.ServerMsg> callback) {
            AuthServer.VaultNodeFetch request = new AuthServer.VaultNodeFetch();
            request.transId = Client.this.getNextTransid();
            request.nodeId = nodeIdx;
            this.SendMsgAndRegisterTransidCallback(request, callback);
        }

        public ClientNodesHelper.NodesInfo GetNodes(int rootNodeIdx) {
            return ClientNodesHelper.GetNodes(this, rootNodeIdx);
        }

        public ArrayList<byte[]> GetRawNodes(int rootNodeIdx) {
            return ClientNodesHelper.GetRawNodes(this, rootNodeIdx);
        }

        public <T extends Node> T GetNode(int nodeIdx) {
            AuthServer.VaultNodeFetch request = new AuthServer.VaultNodeFetch();
            request.transId = Client.this.getNextTransid();
            request.nodeId = nodeIdx;
            AuthServer.VaultNodeFetched reply = (AuthServer.VaultNodeFetched)this.SendMsgAndWaitForTransid(request);
            Object node = Node.getNode(reply.data);
            return node;
        }

        public ArrayList<Node.Ref> GetNodeRefs(int nodeIdx) {
            AuthServer.VaultFetchNodeRefs req = new AuthServer.VaultFetchNodeRefs();
            req.transId = Client.this.getNextTransid();
            req.nodeId = nodeIdx;
            AuthServer.VaultNodeRefsFetched reply = (AuthServer.VaultNodeRefsFetched)this.SendMsgAndWaitForTransid(req);
            return reply.refs;
        }

        public AuthServer.AcctPlayerInfo GetPlayer(String playername) {
            playername = playername.toLowerCase();
            for (AuthServer.AcctPlayerInfo player : this.players) {
                if (!player.playerName.toString().toLowerCase().equals(playername)) continue;
                return player;
            }
            return null;
        }

        public ArrayList<SecureDownloadManifest.Entry> GetDirList(String dir, String ext) {
            AuthServer.FileListRequest request = new AuthServer.FileListRequest();
            request.transId = Client.this.getNextTransid();
            request.dir = new Str(dir);
            request.extension = new Str(ext);
            AuthServer.FileListReply reply = (AuthServer.FileListReply)this.SendMsgAndWaitForTransid(request);
            return reply.manifest.entries;
        }

        public byte[] GetFile(String filename) {
            return this.GetFile(filename, Client.this.logindetails.encryptionKey);
        }

        public byte[] GetFile(String filename, int[] encryptionKey) {
            byte[] encdata = this.GetFileRaw(filename);
            byte[] data = UruCrypt.DecryptNotthedroids(encdata, encryptionKey);
            return data;
        }

        public byte[] GetFileRaw(String filename) {
            AuthServer.FileDownloadRequest request = new AuthServer.FileDownloadRequest();
            request.transId = Client.this.getNextTransid();
            request.filename = new Str(filename);
            AuthServer.FileDownloadChunk reply = (AuthServer.FileDownloadChunk)this.SendMsgAndWaitForTransid(request);
            byte[] result = new byte[reply.filesize];
            int curpos = 0;
            b.CopyBytes(reply.buffer, result, reply.chunkOffset);
            float percentage = 100.0f * ((float)(curpos += reply.buffer.length) / (float)result.length);
            m.msg(String.format("%6.1f%% done. (%d bytes out of %d)", Float.valueOf(percentage), curpos, result.length));
            while (curpos != result.length) {
                AuthServer.FileDownloadChunkAck ack = new AuthServer.FileDownloadChunkAck();
                ack.transId = reply.transId;
                AuthServer.FileDownloadChunk reply2 = (AuthServer.FileDownloadChunk)this.SendMsgAndWaitForTransid(ack);
                b.CopyBytes(reply2.buffer, result, reply2.chunkOffset);
                percentage = 100.0f * ((float)(curpos += reply2.buffer.length) / (float)result.length);
                m.msg(String.format("%6.1f%% done. (%d bytes out of %d)", Float.valueOf(percentage), curpos, result.length));
            }
            AuthServer.FileDownloadChunkAck finalack = new AuthServer.FileDownloadChunkAck();
            finalack.transId = reply.transId;
            this.SendMsg(finalack);
            return result;
        }
    }

    public static interface MsgHandler {
        public void HandleMsg(Server.ServerMsg var1, ClientConnection var2);
    }
}

