/*
 * Decompiled with CFR 0.152.
 */
package wikispider;

import java.util.HashMap;
import java.util.Vector;
import shared.FileUtils;
import shared.HttpUtils;
import shared.b;
import shared.m;
import shared.xml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class wikispider {
    public static void start(String startingUrl, String outputFolder) {
        AllPages allpages = new AllPages();
        allpages.start(startingUrl, outputFolder);
        m.msg("Done!");
        boolean dummy = false;
    }

    public static Vector<String> getwikilinks(String source) {
        int ind;
        Vector<String> result = new Vector<String>();
        int curpos = 0;
        while ((ind = source.indexOf("[[", curpos)) != -1) {
            int indhash;
            int endpos = source.indexOf("]]", ind);
            if (endpos == -1) {
                m.msg("err, couldn't find ]].");
                break;
            }
            String link = source.substring(ind + 2, endpos);
            int indbar = link.indexOf("|");
            if (indbar != -1) {
                link = link.substring(0, indbar);
            }
            if (link.startsWith(" ")) {
                boolean dummy = false;
            }
            if ((indhash = link.indexOf("#")) != -1) {
                link = link.substring(0, indhash);
            }
            if (!link.equals("")) {
                result.add(link);
            } else {
                boolean dummy = false;
            }
            curpos = endpos;
        }
        return result;
    }

    public static class AllPages {
        static final String rootname = "Main_Page";
        static final String outputExt = ".txt";
        HashMap<String, Link> pages = new HashMap();
        String startingUrl;
        String outputFolder;
        Link root;

        public void start(String startingUrl, String outputFolder) {
            this.startingUrl = startingUrl;
            this.outputFolder = outputFolder;
            this.root = this.add(rootname);
            this.root.downloadAndParse();
        }

        public Link add(String name) {
            Link l = this.pages.get(name);
            if (l != null) {
                return l;
            }
            Link a = new Link(name);
            this.pages.put(name, a);
            return a;
        }

        public class Link {
            String name;
            LinkType type;
            boolean downloaded = false;
            boolean downloadedChildren = false;
            Vector<Link> links = new Vector();

            public Link(String name) {
                this.name = name;
                int colind = name.indexOf(":");
                String domain = colind != -1 ? name.substring(0, colind) : "";
                this.type = this.GetLinkTypeFromDomain(domain);
            }

            public LinkType GetLinkTypeFromDomain(String domain) {
                String[] ignores = new String[]{"Special"};
                String[] images = new String[]{"Image", "File", "Media"};
                for (String dom : ignores) {
                    if (!domain.equals(dom)) continue;
                    return LinkType.Ignore;
                }
                for (String dom : images) {
                    if (!domain.equals(dom)) continue;
                    return LinkType.Image;
                }
                return LinkType.Unknown;
            }

            public void downloadAndParse() {
                if (this.downloaded) {
                    return;
                }
                m.msg("Downloading: ", this.name);
                String safeinname = this.name.replace(" ", "_").replace("&", "&amp;");
                String safeoutname = this.name.replace(" ", "_").replace(":", ";");
                String sourceurl = AllPages.this.startingUrl + "/index.php?title=" + safeinname + "&action=raw";
                String outputName = AllPages.this.outputFolder + "/" + safeoutname;
                this.downloaded = true;
                switch (this.type) {
                    case Ignore: {
                        break;
                    }
                    case Unknown: 
                    case WikiPage: {
                        byte[] data = HttpUtils.geturl(sourceurl);
                        if (data == null) {
                            m.warn("Unable to download page: ", sourceurl);
                            return;
                        }
                        if (data.length == 0) {
                            m.warn("Page had zero length: ", sourceurl);
                            boolean dummy = false;
                        }
                        FileUtils.WriteFile(outputName + AllPages.outputExt, data, true);
                        String text = b.BytesToString(data);
                        Vector<String> strlinks = wikispider.getwikilinks(text);
                        for (String s : strlinks) {
                            Link child = AllPages.this.add(s);
                            this.links.add(child);
                        }
                        this.doAllChildren();
                        break;
                    }
                    case Image: {
                        String pageurl = AllPages.this.startingUrl + "/index.php?title=" + safeinname;
                        byte[] data = HttpUtils.geturl(pageurl);
                        if (data == null) {
                            m.warn("Unable to download page: ", pageurl);
                            return;
                        }
                        if (data.length == 0) {
                            m.warn("Page had zero length: ", pageurl);
                            boolean dummy = false;
                        }
                        String imgurl = null;
                        int method = 1;
                        switch (method) {
                            case 0: {
                                xml x = new xml(data);
                                imgurl = x.getString("//div[@id='file']/a/@href");
                                imgurl = AllPages.this.startingUrl + "/" + imgurl;
                                break;
                            }
                            case 1: {
                                String start = "<div class=\"fullImageLink\" id=\"file\"><a href=\"";
                                String pagestr = b.BytesToString(data);
                                int startpos = pagestr.indexOf(start) + start.length();
                                int endpos = pagestr.indexOf("\"", startpos);
                                imgurl = pagestr.substring(startpos, endpos);
                                imgurl = AllPages.this.startingUrl + "/" + imgurl;
                            }
                        }
                        byte[] data2 = HttpUtils.geturl(imgurl);
                        if (data == null) {
                            return;
                        }
                        FileUtils.WriteFile(outputName, data2, true);
                    }
                }
            }

            public void doAllChildren() {
                for (Link l : this.links) {
                    l.downloadAndParse();
                }
                this.downloadedChildren = true;
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Link)) {
                    return false;
                }
                Link l2 = (Link)o;
                return this.name.equals(l2.name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkType {
        WikiPage,
        Image,
        Ignore,
        Unknown;

    }
}

