/*
 * Decompiled with CFR 0.152.
 */
package shared;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.MyRandomAccessFile;
import SevenZipCommon.CRC;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import shared.FileUtils;
import shared.m;

public class sevenzip {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean check(String filename, String basefolder, FileIncluder includer) {
        MyRandomAccessFile istream = null;
        try {
            String root = basefolder + "/";
            istream = new MyRandomAccessFile(filename, "r");
            Handler archive = new Handler();
            int result = archive.Open(istream);
            if (result != 0 && result != 1) {
                m.err("Problem opening/reading 7z file.");
            }
            int count = archive.size();
            for (int i = 0; i < count; ++i) {
                byte[] data;
                int actualcrc;
                SevenZipEntry entry = archive.getEntry(i);
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                File fullfilename = new File(basefolder + "/" + name);
                if (entry.isDirectory() || !includer.includeFile(name)) continue;
                long correctsize = entry.getSize();
                int correctcrc = (int)entry.getCrc();
                if (!fullfilename.exists()) {
                    boolean bl = false;
                    return bl;
                }
                long actualsize = fullfilename.length();
                if (actualsize != correctsize) {
                    boolean bl = false;
                    return bl;
                }
                if (correctsize == 0L || (actualcrc = CRC.CalculateDigest(data = FileUtils.ReadFile(fullfilename), data.length)) == correctcrc) continue;
                boolean bl = false;
                return bl;
            }
            archive.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            m.err("Error during 7zip checking.");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (Exception e3) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String filename, String outputfolder) {
        MyRandomAccessFile istream = null;
        try {
            String root = outputfolder + "/";
            istream = new MyRandomAccessFile(filename, "r");
            Handler archive = new Handler();
            int result = archive.Open(istream);
            if (result != 0 && result != 1) {
                m.err("Problem opening/reading 7z file.");
            }
            int count = archive.size();
            for (int i = 0; i < count; ++i) {
                SevenZipEntry entry = archive.getEntry(i);
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                String fullfilename = outputfolder + "/" + name;
                FileUtils.DeleteFile2(fullfilename);
            }
            archive.close();
        }
        catch (Exception e2) {
            m.err("Error during 7zip deletion.");
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getTotalSize(IInArchive archive) {
        long result = 0L;
        int numentries = archive.size();
        for (int i = 0; i < numentries; ++i) {
            long entrysize = archive.getEntry(i).getSize();
            result += entrysize;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extract(String filename, String outputfolder) {
        Handler archive;
        String root;
        MyRandomAccessFile istream;
        block33: {
            block32: {
                istream = null;
                root = outputfolder + "/";
                istream = new MyRandomAccessFile(filename, "r");
                archive = new Handler();
                int result = archive.Open(istream);
                if (result == 0) break block32;
                m.err("Problem opening/reading 7z file.");
                boolean bl = false;
                try {
                    if (istream == null) return bl;
                    istream.close();
                    return bl;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return bl;
            }
            long bytesneeded = sevenzip.getTotalSize(archive);
            if (FileUtils.HasFreeSpace(root, bytesneeded)) break block33;
            m.err("It doesn't appear that there is enough free space available.");
            boolean bl = false;
            try {
                if (istream == null) return bl;
                istream.close();
                return bl;
            }
            catch (Exception e3) {
                // empty catch block
            }
            return bl;
        }
        try {
            block34: {
                break block34;
                catch (Exception e4) {
                    // empty catch block
                }
            }
            ModifiedArchiveExtractCallback callback = new ModifiedArchiveExtractCallback(root);
            callback.Init(archive);
            int result2 = archive.Extract(null, -1, 0, callback);
            if (result2 != 0) {
                m.err("Error during extraction.");
                boolean bl = false;
                return bl;
            }
            long numerrors = callback.NumErrors;
            if (numerrors != 0L) {
                m.err("Errors during extraction: ", Long.toString(numerrors));
                boolean bl = false;
                return bl;
            }
            int count = archive.size();
            for (int i = 0; i < count; ++i) {
                SevenZipEntry entry = archive.getEntry(i);
            }
            archive.close();
            return true;
        }
        catch (Exception e5) {
            if (e5 instanceof IOException && e5.getMessage().equals("There is not enough space on the disk")) {
                m.err("Not enough disk space to finish extracting.  You shouldn't link to this Age until this is resolved.  Deleting extracted files...");
                sevenzip.delete(filename, outputfolder);
                m.err("Not enough disk space.  Free up some space, then try again.");
                boolean bl = false;
                return bl;
            }
            m.err("Error during 7zip extraction.");
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (Exception e6) {}
        }
    }

    public static class ModifiedArchiveExtractCallback
    implements IArchiveExtractCallback {
        String root = "";
        java.io.OutputStream _outFileStream;
        IInArchive _archiveHandler;
        String _filePath;
        String _diskFilePath;
        public long NumErrors;
        boolean PasswordIsDefined = false;
        String Password;
        boolean _extractMode;
        boolean isDirectory;

        public int SetTotal(long size) {
            return 0;
        }

        public int SetCompleted(long completeValue) {
            return 0;
        }

        public void PrintString(String str) {
            System.out.print(str);
        }

        public void PrintNewLine() {
            System.out.println("");
        }

        public int PrepareOperation(int askExtractMode) {
            this._extractMode = false;
            switch (askExtractMode) {
                case 0: {
                    this._extractMode = true;
                }
            }
            switch (askExtractMode) {
                case 0: {
                    m.msg("Extracting ", this._filePath);
                    break;
                }
                case 1: {
                    this.PrintString("Testing     ");
                    break;
                }
                case 2: {
                    this.PrintString("Skipping    ");
                }
            }
            return 0;
        }

        public int SetOperationResult(int operationResult) throws IOException {
            block0 : switch (operationResult) {
                case 0: {
                    break;
                }
                default: {
                    ++this.NumErrors;
                    this.PrintString("     ");
                    switch (operationResult) {
                        case 1: {
                            this.PrintString("Unsupported Method");
                            break block0;
                        }
                        case 3: {
                            this.PrintString("CRC Failed");
                            break block0;
                        }
                        case 2: {
                            this.PrintString("Data Error");
                            break block0;
                        }
                    }
                    this.PrintString("Unknown Error");
                }
            }
            if (this._outFileStream != null) {
                this._outFileStream.close();
            }
            return 0;
        }

        public int GetStream(int index, java.io.OutputStream[] outStream, int askExtractMode) throws IOException {
            outStream[0] = null;
            SevenZipEntry item = this._archiveHandler.getEntry(index);
            if (item.isDirectory()) {
                return 0;
            }
            String name = item.getName().toLowerCase();
            this._filePath = name.startsWith("dat/") ? this.root + "dat/" + item.getName().substring(4) : (name.startsWith("sfx/") ? this.root + "sfx/" + item.getName().substring(4) : (name.startsWith("sdl/") ? this.root + "SDL/" + item.getName().substring(4) : (name.startsWith("avi/") ? this.root + "avi/" + item.getName().substring(4) : (name.startsWith("python/") ? this.root + "Python/" + item.getName().substring(7) : this.root + item.getName()))));
            File file = new File(this._filePath);
            switch (askExtractMode) {
                case 1: {
                    return 0;
                }
                case 0: {
                    try {
                        this.isDirectory = item.isDirectory();
                        if (this.isDirectory) {
                            if (file.isDirectory()) {
                                return 0;
                            }
                            if (file.mkdirs()) {
                                return 0;
                            }
                            return 1;
                        }
                        File dirs = file.getParentFile();
                        if (dirs != null && !dirs.isDirectory() && !dirs.mkdirs()) {
                            return 1;
                        }
                        long pos = item.getPosition();
                        if (pos == -1L) {
                            file.delete();
                        }
                        RandomAccessFile outStr = new RandomAccessFile(this._filePath, "rw");
                        if (pos != -1L) {
                            outStr.seek(pos);
                        }
                        outStream[0] = new OutputStream(outStr);
                    }
                    catch (IOException e2) {
                        return 1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        public ModifiedArchiveExtractCallback(String root) {
            this.root = root;
        }

        public void Init(IInArchive archiveHandler) {
            this.NumErrors = 0L;
            this._archiveHandler = archiveHandler;
        }

        class OutputStream
        extends java.io.OutputStream {
            RandomAccessFile file;

            public OutputStream(RandomAccessFile f) {
                this.file = f;
            }

            public void close() throws IOException {
                this.file.close();
                this.file = null;
            }

            public void write(byte[] b2) throws IOException {
                this.file.write(b2);
            }

            public void write(byte[] b2, int off, int len) throws IOException {
                this.file.write(b2, off, len);
            }

            public void write(int b2) throws IOException {
                this.file.write(b2);
            }
        }
    }

    public static interface FileIncluder {
        public boolean includeFile(String var1);
    }
}

