/*
 * Decompiled with CFR 0.152.
 */
package pythondec3;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import pythondec.pycfile;
import pythondec3.ast.Ast;
import pythondec3.stats;
import shared.ByteArrayBytestream;
import shared.Exec;
import shared.FileUtils;
import shared.State.AllStates;
import shared.b;
import shared.m;

public class decompile {
    static ArrayList<Ast> _roots = new ArrayList();

    public static boolean testallupto(String pycfile2) {
        File pydir = new File(pycfile2);
        File folder = pydir.getParentFile();
        Object[] files = folder.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            boolean aresame;
            if (((File)file).getName().endsWith(".py") && !(aresame = decompile.decompileandcompare(((File)file).getAbsolutePath()))) {
                m.msg("Not all tests passed. Failed on file: " + file);
                return false;
            }
            if (!((File)file).getName().equals(pydir.getName())) continue;
            m.msg("All tests passed!");
            return true;
        }
        m.msg("Done all files in dir.");
        return true;
    }

    public static void disassemble(String pycfile2) {
        ByteArrayBytestream bs = ByteArrayBytestream.createFromByteArray(FileUtils.ReadFile(pycfile2));
        pycfile pyc = new pycfile(bs);
        pyc.disassemble();
        pyc.printTokens();
    }

    public static boolean arePycFilesEqual(String pycfile1, String pycfile2) {
        ByteArrayBytestream bs1 = ByteArrayBytestream.createFromByteArray(FileUtils.ReadFile(pycfile1));
        ByteArrayBytestream bs2 = ByteArrayBytestream.createFromByteArray(FileUtils.ReadFile(pycfile2));
        pycfile pyc1 = new pycfile(bs1);
        pycfile pyc2 = new pycfile(bs2);
        pyc1.disassemble();
        pyc2.disassemble();
        boolean decompile2 = true;
        if (decompile2) {
            pyc1.decompile();
            pyc2.decompile();
            pyc1.generateSourceCode();
            pyc2.generateSourceCode();
        }
        boolean areequal = pyc1.compare(pyc2);
        return areequal;
    }

    public static void compileWithCpython(String infile, String debugfilename, String outfile) {
        String cmd;
        String pathtopython22 = "C:/Python22/python.exe";
        String pathtopython23 = "C:/Python23/python.exe";
        boolean usepython23 = AllStates.getStateAsBoolean("pydec23");
        String pathtopython = usepython23 ? pathtopython23 : pathtopython22;
        int errorlevel = Exec.RunAndWait(pathtopython, new String[]{"-c", cmd = "import py_compile; py_compile.compile('" + infile + "','" + outfile + "','" + debugfilename + "');"});
        if (errorlevel != 0) {
            m.cancel("Command failed: " + Integer.toString(errorlevel));
        }
        if (!FileUtils.Exists(outfile)) {
            m.cancel("Pyc file not created, perhaps because of invalid source code.");
        }
    }

    public static void compileanddisassemble(String sourcefile) {
        String origpotsfolder = "D:/a/leftoff/pythonfiles/potsorig";
        String tempoutputfolder = "D:/delme/tempdecompiletest";
        String pyname = new File(sourcefile).getName().replace(".pyc", ".py");
        String source = sourcefile.replace(".pyc", ".py");
        File f = new File(pyname);
        String filename = f.getName();
        String origpy = tempoutputfolder + "/" + filename;
        String origpyc = tempoutputfolder + "/" + filename + "c";
        String decopy = tempoutputfolder + "/" + filename + ".drizzle.py";
        String decopyc = tempoutputfolder + "/" + filename + ".drizzle.pyc";
        FileUtils.CopyFile(source, origpy, true, true);
        decompile.compileWithCpython(origpy, pyname, origpyc);
        pycfile pyc = new pycfile(ByteArrayBytestream.createFromByteArray(FileUtils.ReadFile(origpyc)));
        pyc.disassemble();
        pyc.printTokens();
    }

    public static boolean decompileandcompare(String sourcefile) {
        String origpotsfolder = "D:/a/leftoff/pythonfiles/potsorig";
        String tempoutputfolder = "D:/delme/tempdecompiletest";
        String pyname = new File(sourcefile).getName().replace(".pyc", ".py");
        String source = sourcefile.replace(".pyc", ".py");
        File f = new File(pyname);
        String filename = f.getName();
        String origpy = tempoutputfolder + "/" + filename;
        String origpyc = tempoutputfolder + "/" + filename + "c";
        String decopy = tempoutputfolder + "/" + filename + ".drizzle.py";
        String decopyc = tempoutputfolder + "/" + filename + ".drizzle.pyc";
        FileUtils.DeleteFile(origpy, true);
        FileUtils.DeleteFile(origpyc, true);
        FileUtils.DeleteFile(decopy, true);
        FileUtils.DeleteFile(decopyc, true);
        FileUtils.CopyFile(source, origpy, true, true);
        decompile.compileWithCpython(origpy, pyname, origpyc);
        pycfile pyc = new pycfile(ByteArrayBytestream.createFromByteArray(FileUtils.ReadFile(origpyc)));
        String decsource = pyc.generateSourceCode();
        FileUtils.WriteFile(decopy, b.StringToBytes(decsource));
        decompile.compileWithCpython(decopy, pyname, decopyc);
        Boolean areequal = decompile.arePycFilesEqual(origpyc, decopyc);
        if (areequal.booleanValue()) {
            m.msg("The pyc files match!  (" + sourcefile + ")");
            return true;
        }
        m.msg("The pyc files do not match.  (" + sourcefile + ")");
        return false;
    }

    public static String decompile(String infile) {
        stats.reset();
        if (stats.printTiming) {
            m.marktime("Starting reading");
        }
        ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(FileUtils.ReadFile(infile));
        pycfile pyc = new pycfile(c);
        pyc.disassemble();
        pyc.decompile();
        String r = pyc.generateSourceCode();
        m.msg(r);
        if (stats.printStatistics) {
            stats.printReport();
        }
        return r;
    }
}

