/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import shared.FixedLengthString;
import shared.Flt;
import shared.IBytestream;
import shared.b;
import shared.e;

public class p2ffile {
    FixedLengthString fontname;
    byte fontsize;
    int flags;
    int bmwidth;
    int bmheight;
    int largestLetterHeight;
    byte bpp;
    byte[][] bitmaps;
    short unknown;
    int numLetters;
    Letter[] letters;

    public static p2ffile readFromStream(IBytestream c) {
        p2ffile result = new p2ffile(c);
        return result;
    }

    public p2ffile(IBytestream c) {
        this.fontname = new FixedLengthString(c, 256);
        this.fontsize = c.readByte();
        this.flags = c.readInt();
        this.bmwidth = c.readInt();
        this.bmheight = c.readInt();
        this.largestLetterHeight = c.readInt();
        this.bpp = c.readByte();
        e.ensure(this.bpp == 8);
        this.bitmaps = new byte[this.bmheight][this.bmwidth];
        for (int i = 0; i < this.bmheight; ++i) {
            for (int j = 0; j < this.bmwidth; ++j) {
                this.bitmaps[i][j] = c.readByte();
            }
        }
        this.unknown = c.readShort();
        e.ensure(this.unknown == 0);
        this.numLetters = c.readInt();
        this.letters = c.readArray(Letter.class, this.numLetters);
    }

    public void drawStringToCanvas(Graphics g, int x, int y, String str, int colour) {
        boolean halve = false;
        BufferedImage[] imgs = new BufferedImage[this.numLetters];
        for (int i = 0; i < this.numLetters; ++i) {
            BufferedImage img;
            Letter letter = this.letters[i];
            int rowoffset = letter.offset / this.bmwidth;
            if (letter.letterHeight == 0) {
                imgs[i] = null;
                continue;
            }
            int imgwidth = halve ? this.bmwidth / 2 : this.bmwidth;
            imgs[i] = img = new BufferedImage(imgwidth, letter.letterHeight, 2);
            int lastval = 0;
            for (int k = 0; k < letter.letterHeight; ++k) {
                for (int j = 0; j < this.bmwidth; ++j) {
                    int pixel = colour;
                    if (rowoffset + k >= this.bmheight) {
                        boolean dummy = false;
                    }
                    byte a = this.bitmaps[rowoffset + k][j];
                    pixel |= a << 24;
                    if (halve) {
                        if (j % 2 == 1) {
                            int newpixel = b.bytewiseAverage(pixel, lastval);
                            img.setRGB(j / 2, k, newpixel);
                            continue;
                        }
                        lastval = pixel;
                        continue;
                    }
                    img.setRGB(j, k, pixel);
                }
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.SrcOver);
        byte[] strbytes = b.StringToBytes(str);
        int curx = x;
        int cury = y;
        for (byte by : strbytes) {
            Letter l = this.letters[b.ByteToInt32(by)];
            BufferedImage img = imgs[b.ByteToInt32(by)];
            float lpadding = l.lPadding.toJavaFloat();
            float rpadding = l.rPadding.toJavaFloat();
            int lpad = Math.round(lpadding);
            int rpad = Math.round(rpadding);
            double loff = (double)lpadding - Math.floor(lpadding);
            double roff = (double)rpadding - Math.floor(rpadding);
            if (loff > 0.1 || roff > 0.1) {
                boolean dummy = false;
            }
            int actualy = cury - l.stHeight;
            g2.drawImage((Image)img, curx += lpad, actualy, null);
            curx += rpad;
            curx += this.bmwidth;
        }
    }

    public static class Letter {
        int offset;
        int letterHeight;
        int stHeight;
        Flt lPadding;
        Flt rPadding;

        public Letter(IBytestream c) {
            this.offset = c.readInt();
            this.letterHeight = c.readInt();
            this.stHeight = c.readInt();
            this.lPadding = new Flt(c);
            this.rPadding = new Flt(c);
        }
    }
}

