/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.util.Vector;
import prpobjects.Double64;
import prpobjects.HsBitVector;
import prpobjects.PrpTaggedObject;
import prpobjects.Uruobjectref;
import prpobjects.Urustring;
import prpobjects.Wpstr;
import prpobjects.plMessage;
import prpobjects.uruobj;
import shared.Flt;
import shared.Vertex;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import shared.readwarningexception;
import uru.Bytedeque;
import uru.context;

public abstract class PrpMessage
extends PrpTaggedObject {
    public PrpMessage(context c) throws readexception {
        super(c);
    }

    public static class PlSoundMsg
    extends uruobj {
        PlMessageWithCallbacks parent;
        HsBitVector cmd;
        Double64 begin;
        Double64 end;
        byte loop;
        byte playing;
        Flt speed;
        Double64 time;
        int index;
        int repeats;
        int namestr;
        Flt volume;
        byte fadetype;

        public PlSoundMsg(context c) throws readexception {
            this.parent = new PlMessageWithCallbacks(c);
            this.cmd = new HsBitVector(c);
            this.begin = new Double64(c);
            this.end = new Double64(c);
            this.loop = c.readByte();
            this.playing = c.readByte();
            this.speed = new Flt(c);
            this.time = new Double64(c);
            this.index = c.readInt();
            this.repeats = c.readInt();
            this.namestr = c.readInt();
            this.volume = new Flt(c);
            this.fadetype = c.readByte();
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.cmd.compile(c);
            this.begin.compile(c);
            this.end.compile(c);
            c.writeByte(this.loop);
            c.writeByte(this.playing);
            this.speed.compile(c);
            this.time.compile(c);
            c.writeInt(this.index);
            c.writeInt(this.repeats);
            c.writeInt(this.namestr);
            this.volume.compile(c);
            c.writeByte(this.fadetype);
        }
    }

    public static class PlMessageWithCallbacks
    extends uruobj {
        public plMessage parent;
        public int count;
        public Vector<PrpTaggedObject> callbacks;

        public PlMessageWithCallbacks(context c) throws readexception {
            this.parent = new plMessage(c);
            this.count = c.readInt();
            this.callbacks = c.readVector(PrpTaggedObject.class, this.count);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.callbacks.size());
            c.writeVector2(this.callbacks);
        }
    }

    public static class PlExcludeRegionMsg
    extends uruobj {
        plMessage parent;
        byte u1;
        int u2;

        public PlExcludeRegionMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.u1 = c.readByte();
            if (c.readversion == 3 || c.readversion == 6) {
                this.u2 = c.readInt();
            } else if (c.readversion == 4) {
                this.u2 = 0;
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeByte(this.u1);
            c.writeInt(this.u2);
        }
    }

    public static class PlArmatureEffectStateMsg
    extends uruobj {
        public plMessage parent;
        public byte surface;
        public byte addsurface;

        public PlArmatureEffectStateMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.surface = c.readByte();
            this.addsurface = c.readByte();
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeByte(this.surface);
            c.writeByte(this.addsurface);
        }
    }

    public static class PlActivatorMsg
    extends uruobj {
        plMessage parent;
        int u1;
        Vertex u2;

        public PlActivatorMsg(context c) throws readexception {
            m.warn("untested");
            this.parent = new plMessage(c);
            this.u1 = c.readInt();
            this.u2 = new Vertex(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.u1);
            this.u2.compile(c);
        }
    }

    public static class PlEnableMsg
    extends uruobj {
        public static final int kDisable = 0;
        public static final int kEnable = 1;
        public static final int kDrawable = 2;
        public static final int kPhysical = 3;
        public static final int kAudible = 4;
        public static final int kAll = 5;
        public static final int kByType = 6;
        plMessage parent;
        HsBitVector cmd;
        HsBitVector types;

        public PlEnableMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.cmd = new HsBitVector(c);
            this.types = new HsBitVector(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.cmd.compile(c);
            this.types.compile(c);
        }
    }

    public static class PlNotifyMsg
    extends uruobj {
        public plMessage parent;
        int type;
        Flt state;
        int id;
        int count;
        proEventData[] events;

        public PlNotifyMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.type = c.readInt();
            this.state = new Flt(c);
            if (c.readversion == 3 || c.readversion == 6) {
                this.id = c.readInt();
            } else if (c.readversion == 4 || c.readversion == 7) {
                byte idb = c.readByte();
                this.id = b.ByteToInt32(idb);
            }
            this.count = c.readInt();
            this.events = new proEventData[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.events[i] = new proEventData(c);
            }
        }

        private PlNotifyMsg() {
        }

        public static PlNotifyMsg createWithRef(Uruobjectref ref) {
            PlNotifyMsg result = new PlNotifyMsg();
            result.parent = plMessage.createWithRef(ref);
            result.state = Flt.zero();
            result.count = 0;
            result.events = new proEventData[0];
            return result;
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.type);
            this.state.compile(c);
            c.writeInt(this.id);
            c.writeInt(this.count);
            for (int i = 0; i < this.count; ++i) {
                this.events[i].compile(c);
            }
        }

        public static class Collision
        extends uruobj {
            byte enter;
            Uruobjectref hitter;
            Uruobjectref hittee;

            public Collision(context c) throws readexception {
                this.enter = c.readByte();
                this.hitter = new Uruobjectref(c);
                this.hittee = new Uruobjectref(c);
            }

            public void compile(Bytedeque c) {
                c.writeByte(this.enter);
                this.hitter.compile(c);
                this.hittee.compile(c);
            }
        }

        public static class Callback
        extends uruobj {
            int eventTypeCb;

            public Callback(context c) {
                this.eventTypeCb = c.readInt();
            }

            public void compile(Bytedeque c) {
                c.writeInt(this.eventTypeCb);
            }
        }

        public static class Activate
        extends uruobj {
            byte active;
            byte activate;

            public Activate(context c) {
                this.active = c.readByte();
                this.activate = c.readByte();
            }

            public void compile(Bytedeque c) {
                c.writeByte(this.active);
                c.writeByte(this.activate);
            }
        }

        public static class Spawned
        extends uruobj {
            Uruobjectref spawner;
            Uruobjectref spawnee;

            public Spawned(context c) throws readexception {
                this.spawner = new Uruobjectref(c);
                this.spawnee = new Uruobjectref(c);
            }

            public void compile(Bytedeque c) {
                this.spawner.compile(c);
                this.spawnee.compile(c);
            }
        }

        public static class Variable
        extends uruobj {
            Urustring name;
            int dataType;
            float number;
            Uruobjectref key;

            public Variable(context c) throws readexception {
                this.name = new Urustring(c);
                this.dataType = c.readInt();
                this.number = c.readFloat();
                this.key = new Uruobjectref(c);
            }

            public void compile(Bytedeque c) {
                this.name.compile(c);
                c.writeInt(this.dataType);
                c.writeFloat(this.number);
                this.key.compile(c);
            }
        }

        public static class Contained
        extends uruobj {
            Uruobjectref contained;
            Uruobjectref container;
            byte entering;

            public Contained(context c) throws readexception {
                this.contained = new Uruobjectref(c);
                this.container = new Uruobjectref(c);
                this.entering = c.readByte();
            }

            public void compile(Bytedeque c) {
                this.contained.compile(c);
                this.container.compile(c);
                c.writeByte(this.entering);
            }
        }

        public static class Facing
        extends uruobj {
            Uruobjectref facer;
            Uruobjectref facing;
            float dot;
            byte enabled;

            public Facing(context c) throws readexception {
                this.facer = new Uruobjectref(c);
                this.facing = new Uruobjectref(c);
                this.dot = c.readFloat();
                this.enabled = c.readByte();
            }

            public void compile(Bytedeque c) {
                this.facer.compile(c);
                this.facing.compile(c);
                c.writeFloat(this.dot);
                c.writeByte(this.enabled);
            }
        }

        public static class Picked
        extends uruobj {
            Uruobjectref picker;
            Uruobjectref picked;
            byte enabled;
            Vertex hitpoint;

            public Picked(context c) throws readexception {
                this.picker = new Uruobjectref(c);
                this.picked = new Uruobjectref(c);
                this.enabled = c.readByte();
                this.hitpoint = new Vertex(c);
            }

            public void compile(Bytedeque c) {
                this.picker.compile(c);
                this.picked.compile(c);
                c.writeByte(this.enabled);
                this.hitpoint.compile(c);
            }
        }

        public static class ResponderState
        extends uruobj {
            int state;

            public ResponderState(context c) throws readexception {
                this.state = c.readInt();
            }

            public void compile(Bytedeque c) {
                c.writeInt(this.state);
            }
        }

        public static class proEventData
        extends uruobj {
            public static final int kCollision = 1;
            public static final int kPicked = 2;
            public static final int kControlKey = 3;
            public static final int kVariable = 4;
            public static final int kFacing = 5;
            public static final int kContained = 6;
            public static final int kActivate = 7;
            public static final int kCallback = 8;
            public static final int kResponderState = 9;
            public static final int kMultiStage = 10;
            public static final int kSpawned = 11;
            public static final int kClickDrag = 12;
            public static final int kCoop = 13;
            public static final int kOfferLinkBook = 14;
            public static final int kBook = 15;
            public static final int kClimbingBlockerHit = 16;
            public static final int kNone = 17;
            int type;
            uruobj event;

            public proEventData(context c) throws readexception {
                this.type = c.readInt();
                switch (this.type) {
                    case 1: {
                        this.event = new Collision(c);
                        break;
                    }
                    case 2: {
                        this.event = new Picked(c);
                        break;
                    }
                    case 4: {
                        this.event = new Variable(c);
                        break;
                    }
                    case 5: {
                        this.event = new Facing(c);
                        break;
                    }
                    case 6: {
                        this.event = new Contained(c);
                        break;
                    }
                    case 7: {
                        this.event = new Activate(c);
                        break;
                    }
                    case 8: {
                        this.event = new Callback(c);
                        break;
                    }
                    case 9: {
                        this.event = new ResponderState(c);
                        break;
                    }
                    case 11: {
                        this.event = new Spawned(c);
                        break;
                    }
                    default: {
                        throw new readexception("proeventdata: unhandled type:" + Integer.toString(this.type));
                    }
                }
            }

            public void compile(Bytedeque c) {
                c.writeInt(this.type);
                this.event.compile(c);
            }
        }
    }

    public static class PlOneShotMsg
    extends uruobj {
        plMessage parent;
        int count;
        PlOneShotCallback[] callbacks;

        public PlOneShotMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            if (c.readversion == 7) {
                plEventCallbackSetupMsg msg = new plEventCallbackSetupMsg(c);
                this.count = msg.count;
                this.callbacks = msg.callbacks;
                boolean bl = false;
            } else {
                this.count = c.readInt();
                this.callbacks = (PlOneShotCallback[])c.readArray(PlOneShotCallback.class, this.count);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.count);
            c.writeArray2(this.callbacks);
        }

        public static class PlOneShotCallback
        extends uruobj {
            Urustring marker;
            Uruobjectref receiver;
            short user;

            public PlOneShotCallback(context c) throws readexception {
                this.marker = new Urustring(c);
                this.receiver = new Uruobjectref(c);
                this.user = c.readShort();
            }

            public void compile(Bytedeque c) {
                this.marker.compile(c);
                this.receiver.compile(c);
                c.writeShort(this.user);
            }
        }
    }

    public static class plEventCallbackSetupMsg
    extends uruobj {
        plMessage parent;
        int count;
        PlOneShotMsg.PlOneShotCallback[] callbacks;

        public plEventCallbackSetupMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.count = c.readInt();
            this.callbacks = new PlOneShotMsg.PlOneShotCallback[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.callbacks[i] = new PlOneShotMsg.PlOneShotCallback(c);
            }
        }
    }

    public static class PlLinkToAgeMsg
    extends uruobj {
        public plMessage parent;
        public byte u1;
        public PlAgeLinkStruct ageLinkStruct;
        public Urustring ustr;
        HsBitVector xbv;
        Wpstr xs1;
        Wpstr xs2;
        HsBitVector xbv2;
        Wpstr xs3;
        Wpstr xs4;
        Wpstr xs5;
        HsBitVector xbv3;
        Wpstr xs6;
        int xi1;
        int xi2;
        int xi3;
        int xi4;
        byte xb;

        public PlLinkToAgeMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            if (c.readversion == 6 || c.readversion == 3) {
                this.u1 = c.readByte();
                this.ageLinkStruct = new PlAgeLinkStruct(c);
                this.ustr = new Urustring(c);
            } else if (c.readversion == 4) {
                this.xbv = new HsBitVector(c);
                int flag = this.xbv.get(0);
                if ((flag & 1) != 0) {
                    this.xs1 = new Wpstr(c);
                }
                if ((flag & 2) != 0) {
                    this.xs2 = new Wpstr(c);
                }
                if ((flag & 4) != 0) {
                    this.xbv2 = new HsBitVector(c);
                    int flag2 = this.xbv2.get(0);
                    if ((flag2 & 1) != 0) {
                        this.xs3 = new Wpstr(c);
                    }
                    if ((flag2 & 2) != 0) {
                        this.xs4 = new Wpstr(c);
                    }
                    if ((flag2 & 4) != 0) {
                        this.xs5 = new Wpstr(c);
                    }
                }
                this.xbv3 = new HsBitVector(c);
                int flag3 = this.xbv3.get(0);
                if ((flag3 & 1) != 0) {
                    this.xs6 = new Wpstr(c);
                }
                if ((flag3 & 2) != 0) {
                    this.xi1 = c.readInt();
                }
                if ((flag3 & 4) != 0) {
                    this.xi1 = c.readInt();
                }
                if ((flag3 & 8) != 0) {
                    this.xi1 = c.readInt();
                }
                if ((flag3 & 0x10) != 0) {
                    this.xi1 = c.readInt();
                }
                this.xb = c.readByte();
                throw new readwarningexception("PlLinkToAgeMsg: can read okay but failing in order to ignore.");
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeByte(this.u1);
            this.ageLinkStruct.compile(c);
            this.ustr.compile(c);
        }

        public static class PlAgeInfoStruct
        extends uruobj {
            public byte flags;
            public Wpstr ageFilename;
            public Wpstr ageInstanceName;
            public byte[] ageInstanceGuid;
            public Wpstr ageUserDefinedName;
            public int ageSequenceNumber;
            public Wpstr ageDescription;
            public int ageLanguage;

            public PlAgeInfoStruct(context c) {
                this.flags = c.readByte();
                int test2 = b.ByteToInt32(this.flags);
                if ((test2 & 1) != 0) {
                    this.ageFilename = new Wpstr(c);
                }
                if ((test2 & 2) != 0) {
                    this.ageInstanceName = new Wpstr(c);
                }
                if ((test2 & 4) != 0) {
                    this.ageInstanceGuid = c.readBytes(16);
                }
                if ((test2 & 8) != 0) {
                    this.ageUserDefinedName = new Wpstr(c);
                }
                if ((test2 & 0x10) != 0) {
                    this.ageSequenceNumber = c.readInt();
                }
                if ((test2 & 0x20) != 0) {
                    this.ageDescription = new Wpstr(c);
                }
                if ((test2 & 0x40) != 0) {
                    this.ageLanguage = c.readInt();
                }
            }

            public void compile(Bytedeque c) {
                c.writeByte(this.flags);
                int test2 = b.ByteToInt32(this.flags);
                if ((test2 & 1) != 0) {
                    this.ageFilename.compile(c);
                }
                if ((test2 & 2) != 0) {
                    this.ageInstanceName.compile(c);
                }
                if ((test2 & 4) != 0) {
                    c.writeBytes(this.ageInstanceGuid);
                }
                if ((test2 & 8) != 0) {
                    this.ageUserDefinedName.compile(c);
                }
                if ((test2 & 0x10) != 0) {
                    c.writeInt(this.ageSequenceNumber);
                }
                if ((test2 & 0x20) != 0) {
                    this.ageDescription.compile(c);
                }
                if ((test2 & 0x40) != 0) {
                    c.writeInt(this.ageLanguage);
                }
            }
        }

        public static class PlAgeLinkStruct
        extends uruobj {
            public short flags;
            public PlAgeInfoStruct xageinfo;
            byte xu1;
            Wpstr xu2;
            Wpstr xu3;
            Wpstr xu4;
            HsBitVector xu5;
            Wpstr xu5a;
            Wpstr xu5b;
            Wpstr xu5c;
            byte xu6;
            Wpstr xu7;

            public PlAgeLinkStruct(context c) throws readexception {
                this.flags = c.readShort();
                int test2 = b.Int16ToInt32(this.flags);
                if ((test2 & 1) != 0) {
                    this.xageinfo = new PlAgeInfoStruct(c);
                }
                if ((test2 & 2) != 0) {
                    this.xu1 = c.readByte();
                }
                if ((test2 & 4) != 0) {
                    this.xu2 = new Wpstr(c);
                    test2 = test2 & 0xFFFB | 0x20;
                }
                if ((test2 & 8) != 0) {
                    this.xu3 = new Wpstr(c);
                    this.xu4 = new Wpstr(c);
                    test2 = test2 & 0xFFF7 | 0x20;
                } else if ((test2 & 0x20) != 0) {
                    this.xu5 = new HsBitVector(c);
                    int test22 = this.xu5.get(0);
                    if ((test22 & 1) != 0) {
                        this.xu5a = new Wpstr(c);
                    }
                    if ((test22 & 2) != 0) {
                        this.xu5b = new Wpstr(c);
                    }
                    if ((test22 & 4) != 0) {
                        this.xu5c = new Wpstr(c);
                    }
                }
                if ((test2 & 0x10) != 0) {
                    this.xu6 = c.readByte();
                }
                if ((test2 & 0x40) != 0) {
                    this.xu7 = new Wpstr(c);
                }
            }

            public void compile(Bytedeque c) {
                c.writeShort(this.flags);
                int test2 = b.Int16ToInt32(this.flags);
                if ((test2 & 1) != 0) {
                    this.xageinfo.compile(c);
                }
                if ((test2 & 2) != 0) {
                    c.writeByte(this.xu1);
                }
                if ((test2 & 4) != 0) {
                    this.xu2.compile(c);
                    test2 = test2 & 0xFFFB | 0x20;
                }
                if ((test2 & 8) != 0) {
                    this.xu3.compile(c);
                    this.xu4.compile(c);
                    test2 = test2 & 0xFFF7 | 0x20;
                } else if ((test2 & 0x20) != 0) {
                    this.xu5.compile(c);
                    int test22 = this.xu5.get(0);
                    if ((test22 & 1) != 0) {
                        this.xu5a.compile(c);
                    }
                    if ((test22 & 2) != 0) {
                        this.xu5b.compile(c);
                    }
                    if ((test22 & 4) != 0) {
                        this.xu5c.compile(c);
                    }
                }
                if ((test2 & 0x10) != 0) {
                    c.writeByte(this.xu6);
                }
                if ((test2 & 0x40) != 0) {
                    this.xu7.compile(c);
                }
            }
        }
    }

    public static class PlAnimCmdMsg
    extends uruobj {
        public PlMessageWithCallbacks parent;
        public HsBitVector u1;
        public Flt[] u2;
        public Urustring u3;
        public Urustring u4;

        public PlAnimCmdMsg(context c) throws readexception {
            this.parent = new PlMessageWithCallbacks(c);
            this.u1 = new HsBitVector(c);
            if (c.readversion == 3 || c.readversion == 6) {
                this.u2 = (Flt[])c.readArray(Flt.class, 7);
            } else if (c.readversion == 4 || c.readversion == 7) {
                this.u2 = new Flt[7];
                if (this.u1.count > 0) {
                    int flags = this.u1.values[0];
                    for (int i = 0; i < 7; ++i) {
                        this.u2[i] = new Flt(0);
                    }
                }
            }
            this.u3 = new Urustring(c);
            this.u4 = new Urustring(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.u1.compile(c);
            c.writeArray(this.u2);
            this.u3.compile(c);
            this.u4.compile(c);
        }
    }

    public static class PlTimerCallbackMsg
    extends uruobj {
        plMessage parent;
        int u1;
        Flt u2;

        public PlTimerCallbackMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.u1 = c.readInt();
            this.u2 = new Flt(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.u1);
            this.u2.compile(c);
        }
    }

    public static class PlEventCallbackMsg
    extends uruobj {
        public plMessage parent;
        public Flt eventTime;
        public short event;
        public short index;
        public short repeats;
        public short user;

        public PlEventCallbackMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.eventTime = new Flt(c);
            this.event = c.readShort();
            this.index = c.readShort();
            this.repeats = c.readShort();
            this.user = c.readShort();
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.eventTime.compile(c);
            c.writeShort(this.event);
            c.writeShort(this.index);
            c.writeShort(this.repeats);
            c.writeShort(this.user);
        }

        private PlEventCallbackMsg() {
        }

        public static PlEventCallbackMsg createWithSenderAndReceiver(Uruobjectref sender, Uruobjectref receiver) {
            PlEventCallbackMsg r = new PlEventCallbackMsg();
            r.eventTime = Flt.createFromJavaFloat(0.0f);
            r.parent = plMessage.createWithSenderAndReceiver(sender, receiver);
            return r;
        }
    }

    public static class PlCameraMsg
    extends uruobj {
        plMessage parent;
        HsBitVector cmd;
        Double64 transtime;
        byte activated;
        Uruobjectref newcam;
        Uruobjectref triggerer;
        PlCameraConfig cameraConfig;
        Vertex xvertex;

        public PlCameraMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.cmd = new HsBitVector(c);
            this.transtime = new Double64(c);
            this.activated = c.readByte();
            this.newcam = new Uruobjectref(c);
            this.triggerer = new Uruobjectref(c);
            this.cameraConfig = new PlCameraConfig(c);
            if (c.realreadversion == 8) {
                this.xvertex = new Vertex(c);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.cmd.compile(c);
            this.transtime.compile(c);
            c.writeByte(this.activated);
            this.newcam.compile(c);
            this.triggerer.compile(c);
            this.cameraConfig.compile(c);
        }

        public static class PlCameraConfig
        extends uruobj {
            Flt accel;
            Flt decel;
            Flt vel;
            Flt FPaccel;
            Flt FPdecel;
            Flt FPvel;
            Flt FOVw;
            Flt FOVh;
            Vertex offset;
            byte worldspace;

            public PlCameraConfig(context c) throws readexception {
                this.accel = new Flt(c);
                this.decel = new Flt(c);
                this.vel = new Flt(c);
                this.FPaccel = new Flt(c);
                this.FPdecel = new Flt(c);
                this.FPvel = new Flt(c);
                this.FOVw = new Flt(c);
                this.FOVh = new Flt(c);
                this.offset = new Vertex(c);
                this.worldspace = c.readByte();
            }

            public void compile(Bytedeque c) {
                this.accel.compile(c);
                this.decel.compile(c);
                this.vel.compile(c);
                this.FPaccel.compile(c);
                this.FPdecel.compile(c);
                this.FPvel.compile(c);
                this.FOVw.compile(c);
                this.FOVh.compile(c);
                this.offset.compile(c);
                c.writeByte(this.worldspace);
            }
        }
    }

    public static class PlRideAnimatedPhysMsg
    extends uruobj {
        plMessage parent;
        byte u1;
        Uruobjectref u2;

        public PlRideAnimatedPhysMsg(context c) throws readexception {
            e.ensure(c.readversion == 6);
            this.parent = new plMessage(c);
            this.u1 = c.readByte();
            this.u2 = new Uruobjectref(c);
        }
    }

    public static class PlDampMsg
    extends uruobj {
        plMessage parent;
        int u1;

        public PlDampMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.u1 = c.readInt();
        }

        public void compile(Bytedeque c) {
            m.warn("compile not implemented.");
            m.warn("compile: not tested with pots.");
        }
    }

    public static class PlSimSuppressMsg
    extends uruobj {
        plMessage parent;
        byte b1;

        public PlSimSuppressMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.b1 = c.readByte();
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeByte(this.b1);
        }
    }

    public static class PlResponderEnableMsg
    extends uruobj {
        plMessage parent;
        byte b1;

        public PlResponderEnableMsg(context c) throws readexception {
            this.parent = new plMessage(c);
            this.b1 = c.readByte();
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeByte(this.b1);
        }
    }
}

