/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public class Alias
extends Expression {
    private final String alias;
    private Expression expr;
    private boolean aliasColumnName;

    public Alias(Expression expression, String string, boolean bl) {
        this.expr = expression;
        this.alias = string;
        this.aliasColumnName = bl;
    }

    public Expression getNonAliasExpression() {
        return this.expr;
    }

    public Value getValue(Session session) {
        return this.expr.getValue(session);
    }

    public int getType() {
        return this.expr.getType();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.expr.mapColumns(columnResolver, n);
    }

    public Expression optimize(Session session) {
        this.expr = this.expr.optimize(session);
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.expr.setEvaluatable(tableFilter, bl);
    }

    public int getScale() {
        return this.expr.getScale();
    }

    public long getPrecision() {
        return this.expr.getPrecision();
    }

    public int getDisplaySize() {
        return this.expr.getDisplaySize();
    }

    public boolean isAutoIncrement() {
        return this.expr.isAutoIncrement();
    }

    public String getSQL() {
        return this.expr.getSQL() + " AS " + Parser.quoteIdentifier(this.alias);
    }

    public void updateAggregate(Session session) {
        this.expr.updateAggregate(session);
    }

    public String getAlias() {
        return this.alias;
    }

    public int getNullable() {
        return this.expr.getNullable();
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.expr.getCost();
    }

    public String getTableName() {
        if (this.aliasColumnName) {
            return super.getTableName();
        }
        return this.expr.getTableName();
    }

    public String getColumnName() {
        if (!(this.expr instanceof ExpressionColumn) || this.aliasColumnName) {
            return super.getColumnName();
        }
        return this.expr.getColumnName();
    }
}

