/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import moulserver.AbstractManager;
import moulserver.AuthServer;
import moulserver.ChunkSendHandler;
import moulserver.Comm;
import moulserver.Database;
import moulserver.FileServer;
import moulserver.GameMainServer;
import moulserver.GameServer;
import moulserver.GateServer;
import moulserver.Node;
import moulserver.NodeManager;
import moulserver.Server;
import moulserver.ServerType;
import moulserver.Version;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import prpobjects.Guid;
import prpobjects.uruobj;
import shared.Concurrent;
import shared.CryptoBytedeque;
import shared.CryptoBytestream;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.LargeInteger;
import shared.StreamBytedeque;
import shared.StreamBytestream;
import shared.b;
import shared.m;
import shared.nested;
import shared.uncaughtexception;
import uru.Bytedeque;

public class ConnectionState
extends Thread {
    AbstractManager manager;
    Socket sock;
    ServerType serverType;
    byte[] ipAddress;
    int port;
    InputStream _in2;
    OutputStream _out2;
    IBytestream in;
    IBytedeque out;
    final LinkedBlockingQueue<Comm.CommItem> items = Concurrent.getConcurrentBlockingQueue();
    public final WeakReference<Queue<Comm.CommItem>> weakitems = new WeakReference<LinkedBlockingQueue<Comm.CommItem>>(this.items);
    NetworkHeader header;
    WorkerThread worker;
    ChunkSendHandler chunksendhandler = new ChunkSendHandler();
    Integer serverchallenge = null;
    Database.accountinfo account = null;
    Integer playerId = null;
    Integer playerInfoIdx = null;
    Node.PlayerNode player = null;
    Comm.Listener listener = null;
    NodeManager nodemgr = null;
    WeakReference<GameServer> currentGameServer;

    public void terminate() {
        try {
            this.sock.close();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
    }

    public ConnectionState(Socket sck, AbstractManager manager) {
        this.manager = manager;
        this.sock = sck;
        this.serverType = ServerType.Connect;
        try {
            this._in2 = this.sock.getInputStream();
            this._out2 = this.sock.getOutputStream();
            this.in = new StreamBytestream(this._in2);
            this.out = new StreamBytedeque(this._out2);
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
        this.ipAddress = sck.getInetAddress().getAddress();
        this.port = sck.getPort();
        this.worker = new WorkerThread();
        this.worker.start();
    }

    private ConnectionState() {
    }

    public static ConnectionState dummy() {
        return new ConnectionState();
    }

    public void startReader() {
        this.start();
    }

    public void setAccount(Database.accountinfo acct) {
        this.account = acct;
    }

    public void setPlayerIdx(int playerIdx2) {
        this.playerId = playerIdx2;
    }

    public synchronized void sendMsgBytes(byte[] msgBytes) {
        try {
            this.out.writeBytes(msgBytes);
            this.out.flush();
        }
        catch (Exception e2) {
            Exception root = nested.getRootOfException(e2);
            if (root instanceof SocketException && root.getMessage().equals("Connection reset")) {
                this.manager.removeConnectionState(this);
                try {
                    this.sock.close();
                }
                catch (Exception e22) {
                    m.msg("Error while closing connection.");
                    e22.printStackTrace();
                }
                m.msg("Client disconnected.");
            }
            e2.printStackTrace();
        }
    }

    public void run() {
        try {
            this.HandleConnect();
            while (true) {
                Server.ServerMsg msg = this.ReadMsg();
                this.manager.HandleMessage(this.serverType, msg, this);
            }
        }
        catch (Exception e2) {
            Exception root = nested.getRootOfException(e2);
            if (root instanceof SocketException && root.getMessage().equals("Connection reset")) {
                this.manager.removeConnectionState(this);
                try {
                    this.sock.close();
                }
                catch (Exception e22) {
                    m.msg("Error while closing connection.");
                    e22.printStackTrace();
                }
                m.msg("Client disconnected.");
            } else if (root instanceof SocketException && root.getMessage().equals("socket closed")) {
                this.manager.removeConnectionState(this);
                try {
                    this.sock.close();
                }
                catch (Exception e23) {
                    m.msg("Error while closing connection.");
                    e23.printStackTrace();
                }
                m.msg("Server disconnected.");
            } else {
                e2.printStackTrace();
            }
            return;
        }
    }

    private Server.ServerMsg ReadMsg() {
        switch (this.serverType) {
            case GateServer: {
                return GateServer.ReadMessage(this.in, true);
            }
            case FileServer: {
                return FileServer.ReadMessage(this.in, true);
            }
            case AuthServer: {
                return AuthServer.ReadMessage(this.in, true);
            }
            case GameServer: {
                return GameMainServer.ReadMessage(this.in, true);
            }
        }
        throw new uncaughtexception("Unhandled state");
    }

    private void HandleConnect() {
        this.header = new NetworkHeader(this.in);
        if (this.header.type == 16) {
            this.serverType = ServerType.FileServer;
        } else if (this.header.type == 22) {
            this.HandleNetCliPacket(this.in, Version.talcum.gateserver_B);
            this.serverType = ServerType.GateServer;
        } else if (this.header.type == 10) {
            this.HandleNetCliPacket(this.in, Version.talcum.authserver_B);
            this.serverType = ServerType.AuthServer;
        } else if (this.header.type == 11) {
            this.HandleNetCliPacket(this.in, Version.talcum.gameserver_B);
            this.serverType = ServerType.GameServer;
        } else {
            m.throwUncaughtException("unhandled server type: ", Byte.toString(this.header.type));
        }
    }

    public void HandleNetCliPacket(IBytestream c, String B) {
        byte type = c.readByte();
        byte msgsize = c.readByte();
        if (type == 0) {
            NetCliConnectMsg request = new NetCliConnectMsg(c);
            LargeInteger _mod = new LargeInteger(Version.talcum.gateserver_mod);
            LargeInteger _A = new LargeInteger(request.A_bytes);
            LargeInteger _b = new LargeInteger("b4573c3b62cb002b15e5501d1de44c65d25caced0f87753ab424ebf2a3db2979ded97782b15f655f7abac3b2030792f103b2369acde7e7d98675352057d421fb");
            LargeInteger _key = _A.modPow(_b, _mod);
            byte[] dhkey = _key.toBytes(64);
            byte[] rc4key = new byte[]{0, 0, 0, 0, 0, 0, 0};
            byte[] keymsg = new byte[7];
            for (int i = 0; i < 7; ++i) {
                keymsg[i] = (byte)(rc4key[i] ^ dhkey[i]);
            }
            NetCliEncryptMsg reply = new NetCliEncryptMsg();
            reply.keymsg = keymsg;
            reply.SendNetCliMsg(this.out);
            RC4Engine rc4in = new RC4Engine();
            RC4Engine rc4out = new RC4Engine();
            KeyParameter keyparams = new KeyParameter(rc4key);
            rc4in.init(true, keyparams);
            rc4out.init(true, keyparams);
            InputStream in_sub = this.in.getChildStreamIfExists();
            OutputStream out_sub = this.out.getChildStreamIfExists();
            this.in = new CryptoBytestream(in_sub, rc4in);
            this.out = new CryptoBytedeque(out_sub, rc4out);
            m.msg("ConnectServer: now encrypted with rc4key: " + b.BytesToHexString(rc4key));
        } else {
            m.err("Unhandled NetCliServer msg: ", Byte.toString(type));
        }
    }

    public static class NetCliEncryptMsg
    extends CliNetServerMsg {
        byte[] keymsg;

        public NetCliEncryptMsg(IBytestream c) {
            this.keymsg = c.readBytes(7);
        }

        public NetCliEncryptMsg() {
        }

        public void write(IBytedeque c) {
            c.writeBytes(this.keymsg);
        }

        public byte type() {
            return 1;
        }
    }

    public static class NetCliConnectMsg
    extends CliNetServerMsg {
        byte[] A_bytes;

        public NetCliConnectMsg() {
        }

        public NetCliConnectMsg(IBytestream c) {
            this.A_bytes = c.readBytes(64);
        }

        public void write(IBytedeque c) {
            if (this.A_bytes.length != 64) {
                m.throwUncaughtException("unexpected");
            }
            c.writeBytes(this.A_bytes);
        }

        public byte type() {
            return 0;
        }
    }

    static abstract class CliNetServerMsg
    extends Server.ServerMsg {
        CliNetServerMsg() {
        }

        abstract byte type();

        public void SendNetCliMsg(IBytedeque out) {
            boolean allatonce = true;
            Bytedeque c = new Bytedeque(Format.moul);
            c.writeByte(this.type());
            c.writeByte((byte)0);
            this.write(c);
            byte[] data = c.getAllBytes();
            data[1] = (byte)data.length;
            out.writeBytes(data);
            out.flush();
        }

        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            c.writeByte(this.type());
            c.writeByte((byte)0);
            this.write(c);
            byte[] r = c.getAllBytes();
            r[1] = (byte)r.length;
            return r;
        }
    }

    public static class NetworkHeader
    extends Server.ServerMsg {
        static final byte kConnTypeNil = 0;
        static final byte kConnTypeDebug = 1;
        static final byte kConnTypeCliToAuth = 10;
        static final byte kConnTypeCliToGame = 11;
        static final byte kConnTypeCliToFile = 16;
        static final byte kConnTypeCliToGate = 22;
        static final byte kConnTypeSrvToVault = 100;
        static final byte kConnTypeSrvToLookup = 101;
        static final byte kConnTypeCliToAdmin = 102;
        byte type;
        short sockHeaderSize;
        int buildID;
        int buildType;
        int branchId;
        Guid productID;
        ConnHeader subheader;

        public NetworkHeader(IBytestream c) {
            this.type = c.readByte();
            this.sockHeaderSize = c.readShort();
            this.buildID = c.readInt();
            this.buildType = c.readInt();
            this.branchId = c.readInt();
            this.productID = new Guid(c);
            if (this.type == 22) {
                int size = c.readInt();
                this.subheader = new GateConnHeader(c);
            } else if (this.type == 16) {
                int size = c.readInt();
                this.subheader = new FileConnHeader(c);
            } else if (this.type == 10) {
                int size = c.readInt();
                this.subheader = new AuthConnHeader(c);
            } else if (this.type == 11) {
                int size = c.readInt();
                this.subheader = new GameConnHeader(c);
            } else {
                m.throwUncaughtException("unhandled");
            }
        }

        public static NetworkHeader createGateHeader(Version ver) {
            NetworkHeader r = new NetworkHeader();
            r.type = (byte)22;
            r.buildID = ver.buildId;
            r.buildType = ver.buildType;
            r.branchId = ver.branchId;
            r.productID = ver.productId;
            r.subheader = GateConnHeader.createDefault();
            return r;
        }

        public static NetworkHeader createFileHeader(Version ver) {
            NetworkHeader r = new NetworkHeader();
            r.type = (byte)16;
            r.buildID = ver.buildId;
            r.buildType = ver.buildType;
            r.branchId = ver.branchId;
            r.productID = ver.productId;
            r.subheader = FileConnHeader.createDefault();
            return r;
        }

        public static NetworkHeader createAuthHeader(Version ver) {
            NetworkHeader r = new NetworkHeader();
            r.type = (byte)10;
            r.buildID = ver.buildId;
            r.buildType = ver.buildType;
            r.branchId = ver.branchId;
            r.productID = ver.productId;
            r.subheader = AuthConnHeader.createDefault();
            return r;
        }

        public static NetworkHeader createGameHeader(Version ver, Guid accountGuid, Guid ageInstanceGuid) {
            NetworkHeader r = new NetworkHeader();
            r.type = (byte)11;
            r.buildID = ver.buildId;
            r.buildType = ver.buildType;
            r.branchId = ver.branchId;
            r.productID = ver.productId;
            r.subheader = GameConnHeader.createWithInfo(accountGuid, ageInstanceGuid);
            return r;
        }

        public void write(IBytedeque c) {
            int size = 31;
            c.writeByte(this.type);
            c.writeShort((short)31);
            c.writeInt(this.buildID);
            c.writeInt(this.buildType);
            c.writeInt(this.branchId);
            this.productID.write(c);
            byte[] subheaderbs = this.subheader.getbytes();
            int size2 = subheaderbs.length + 4;
            c.writeInt(size2);
            c.writeBytes(subheaderbs);
        }

        public NetworkHeader() {
        }

        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            this.write(c);
            return c.getAllBytes();
        }
    }

    public static class GateConnHeader
    extends ConnHeader {
        public Guid nullguid;

        public GateConnHeader(IBytestream c) {
            this.nullguid = new Guid(c);
        }

        private GateConnHeader() {
        }

        public static GateConnHeader createDefault() {
            GateConnHeader r = new GateConnHeader();
            r.nullguid = Guid.none2();
            return r;
        }

        public void write(IBytedeque c) {
            this.nullguid.write(c);
        }
    }

    public static class FileConnHeader
    extends ConnHeader {
        int u2;
        int u3;

        public FileConnHeader(IBytestream c) {
            this.u2 = c.readInt();
            this.u3 = c.readInt();
        }

        public void write(IBytedeque c) {
            c.writeInt(this.u2);
            c.writeInt(this.u3);
        }

        private FileConnHeader() {
        }

        public static FileConnHeader createDefault() {
            FileConnHeader r = new FileConnHeader();
            r.u2 = 0;
            r.u3 = 0;
            return r;
        }

        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            this.write(c);
            return c.getAllBytes();
        }
    }

    public static class AuthConnHeader
    extends ConnHeader {
        byte[] nullguid;

        public AuthConnHeader(IBytestream c) {
            this.nullguid = c.readBytes(16);
        }

        public AuthConnHeader() {
        }

        public static AuthConnHeader createDefault() {
            AuthConnHeader r = new AuthConnHeader();
            r.nullguid = Guid.none();
            return r;
        }

        public void write(IBytedeque c) {
            if (this.nullguid.length != 16) {
                m.throwUncaughtException("unexpected");
            }
            c.writeBytes(this.nullguid);
        }
    }

    public static class GameConnHeader
    extends ConnHeader {
        Guid accountGuid;
        Guid ageGuid;

        public GameConnHeader(IBytestream c) {
            this.accountGuid = new Guid(c);
            this.ageGuid = new Guid(c);
        }

        public GameConnHeader() {
        }

        public static GameConnHeader createWithInfo(Guid accountGuid, Guid ageInstanceGuid) {
            GameConnHeader r = new GameConnHeader();
            r.accountGuid = accountGuid;
            r.ageGuid = ageInstanceGuid;
            return r;
        }

        public void write(IBytedeque c) {
            this.accountGuid.write(c);
            this.ageGuid.write(c);
        }
    }

    public static abstract class ConnHeader
    extends uruobj {
        public byte[] getbytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            this.write(c);
            byte[] data = c.getAllBytes();
            return data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImmediateQueue
    extends ArrayDeque<Comm.CommItem> {
        @Override
        public boolean add(Comm.CommItem e2) {
            if (e2.type == Comm.CommItemType.NodeChange) {
                AuthServer.AuthMsg msg = (AuthServer.AuthMsg)e2.msg;
                AuthServer.SendMsg(ConnectionState.this, msg);
            }
            ConnectionState.this.sendMsgBytes(new byte[0]);
            return true;
        }
    }

    public class WorkerThread
    extends Thread {
        public void run() {
            block2: while (true) {
                try {
                    while (true) {
                        Comm.CommItem item = ConnectionState.this.items.take();
                        if (item.type == Comm.CommItemType.SendMessage) {
                            m.msg("WorkerThread sending message: " + item.msg.dump());
                            ConnectionState.this.sendMsgBytes(item.msg.GetMsgBytes());
                            continue;
                        }
                        if (item.type == Comm.CommItemType.Terminate) {
                            m.throwUncaughtException("Unhandled terminate command.");
                            break block2;
                        }
                        m.throwUncaughtException("Unable to handle CommItem: " + item.type.toString());
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

