/*
 * Decompiled with CFR 0.152.
 */
package auto;

import java.io.File;
import java.util.HashSet;
import shared.ExceptionUtils;
import shared.Exec;
import shared.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleIntermediary {
    private static String ururoot;

    public static void DoWork(String[] args) {
        ururoot = FileUtils.GetInitialWorkingDirectory();
        DrizzleIntermediary.resetlog();
        DrizzleIntermediary.log("drizzleintermediary!");
        try {
            DrizzleIntermediary.CleanFiles();
            DrizzleIntermediary.PatchResolution();
            DrizzleIntermediary.LaunchUruExplorer(args);
            DrizzleIntermediary.log("All done!");
        }
        catch (Exception e2) {
            DrizzleIntermediary.log(ExceptionUtils.ExceptionToString(e2));
        }
    }

    private static void LaunchUruExplorer(String[] args) {
        String[] argsToPassOn = new String[args.length - 1];
        for (int i = 0; i < argsToPassOn.length; ++i) {
            argsToPassOn[i] = args[i + 1];
        }
        Exec.RunAndReturnImmediately(true, ururoot + "/UruExplorer.exe", argsToPassOn);
    }

    private static void PatchResolution() {
    }

    private static void CleanFiles() {
        if (FileUtils.Exists(ururoot + "/DrizzleIntermediaryWhitelist.txt")) {
            String whiteliststr = FileUtils.ReadFileAsString(ururoot + "/DrizzleIntermediaryWhitelist.txt");
            HashSet<String> whitelist = new HashSet<String>();
            for (String s : whiteliststr.split("\n")) {
                whitelist.add(s);
            }
            DrizzleIntermediary.CleanFolder("/python", whitelist);
        } else {
            DrizzleIntermediary.log("Whitelist not found; skipping.");
        }
    }

    private static void CleanFolder(String folder, HashSet<String> whitelist) {
        File dir = new File(ururoot + folder);
        for (File f : dir.listFiles()) {
            String relpath = (folder + "/" + f.getName()).toLowerCase();
            if (f.isFile()) {
                if (whitelist.contains(relpath)) continue;
                DrizzleIntermediary.log("Deleting file: " + relpath);
                FileUtils.DeleteFile(f.getAbsolutePath(), true);
                continue;
            }
            DrizzleIntermediary.CleanFolder(relpath, whitelist);
        }
    }

    private static void resetlog() {
        FileUtils.ZeroFile(ururoot + "/DrizzleIntermediary.log");
    }

    private static void log(String msg) {
        FileUtils.AppendText(ururoot + "/DrizzleIntermediary.log", msg + "\n");
    }
}

