//
//  Controller.h
//  Cosmic Debris
//
//  Created by John Schilling on 11/22/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Downloader.h"
#import "SSWindow.h"
#import "Alerter.h"
#import "EmailThread.h"

#define	SharedController [Controller sharedInstance]

@interface Controller : NSWindowController {

        Downloader                          *_STDDownloader;
        Downloader                          *_PCAFDownloader;
        Downloader                          *_ovalDownloader;
        Downloader                          *_KPDownloader;

        IBOutlet Alerter                    *_alerter;

        NSStatusItem                        *_statusItem;
        IBOutlet NSMenu                     *_cosmicMenu;
        IBOutlet NSMenuItem                 *_latStatHighMenuItem;
        IBOutlet NSMenuItem                 *_latStatMidMenuItem;
        IBOutlet NSMenuItem                 *_latStatLowMenuItem;
        IBOutlet NSMenuItem                 *_pcafMenuItem;
        IBOutlet NSMenuItem                 *_displayOvalImageMenuItem;
        IBOutlet NSMenuItem                 *_displayKPImageMenuItem;
        IBOutlet NSMenuItem                 *_lastUpdatedMenuItem;
        IBOutlet NSMenuItem                 *_nextUpdateMenuItem;
        IBOutlet NSMenuItem                 *_cancelOrUpdateMenuItem;
        
        NSTimer                             *_updateTimer;
        NSTimer                             *_animationTimer;
        
        NSMutableArray                      *_statusDLIcons;
        int                                 _statusItemIconIndex;
        
        NSArray                             *_soundNames;
        
        int                                 _currentHighLat;
        int                                 _currentMidLat;
        int                                 _currentLowLat;
        int                                 _previousHighLat;
        int                                 _previousMidLat;
        int                                 _previousLowLat;
        
        int                                 _currentPCAFlevel;
        int                                 _previousPCAFlevel;
        
        int                                 _currentAEItem;
        
        NSMutableString                     *_lastUpdatedString;
        NSCalendarDate                      *_lastUpdatedDate;
        NSMutableString                     *_nextUpdateString;
        NSCalendarDate                      *_nextUpdateDate;
        
        NSString                            *_cacheFolderPath;
        
        IBOutlet SSWindow                   *_ovalWindow;
        NSString                            *_ovalFileName;
        NSMutableString                     *_lastOvalImageUpdate;
        BOOL                                _ovalWindowOpen;
        BOOL                                _ovalWindowDocked;
        IBOutlet SSWindow                   *_KPWindow;
        NSString                            *_KPFileName;
        NSMutableString                     *_lastKPImageUpdate;
        BOOL                                _KPWindowOpen;
        BOOL                                _KPWindowDocked;
        BOOL                                _restoreWindowPositions;
    
        BOOL                                _downloadAtStartup;
        BOOL                                _autoUpdates;
        int                                 _autoUpdateRate;
        BOOL                                _downloadOvalImage;
        BOOL                                _downloadKPImage;
        BOOL                                _alertOnChange;
        BOOL                                _alertOnAllItemChanges;
        int                                 _alertThreshold;
        BOOL                                _alertWithSound;
        NSMutableString                     *_alertSoundName;
        BOOL                                _alertWithMessage;
        BOOL                                _autoCloseAlertWindow;
        BOOL                                _alertWithEmail;
        BOOL                                _emailShortMessages;
        NSMutableString                     *_emailAddress;
        float                               _timeout;
        int                                 _statusItemStyle;
        
        IBOutlet NSWindow                   *_prefsWindow;
        IBOutlet NSButton                   *_downloadAtStartupButton;
        IBOutlet NSButton                   *_autoUpdatesButton;
        IBOutlet NSPopUpButton              *_autoUpdateRateMenu;
        IBOutlet NSButton                   *_downloadOvalImageButton;
        IBOutlet NSButton                   *_downloadKPImageButton;
        IBOutlet NSButton                   *_restoreWindowPositionsButton;
        IBOutlet NSPopUpButton              *_currentAEItemMenu;
        IBOutlet NSButton                   *_alertOnChangeButton;
        IBOutlet NSButton                   *_alertOnAllChangesButton;
        IBOutlet NSPopUpButton              *_alertThresholdMenu;
        IBOutlet NSButton                   *_alertWithSoundButton;
        IBOutlet NSPopUpButton              *_alertSoundsMenu;
        IBOutlet NSButton                   *_alertWithMessageButton;
        IBOutlet NSButton                   *_autoCloseAlertWindowButton;
        IBOutlet NSButton                   *_alertWithEmailButton;
        IBOutlet NSButton                   *_emailShortMessagesButton;
        IBOutlet NSTextField                *_emailAddressField;
        IBOutlet NSTextField                *_timeoutTextField;
        IBOutlet NSStepper                  *_timeoutStepper;
        IBOutlet NSPopUpButton              *_statusItemStyleMenu;
        IBOutlet NSButton                   *_isLoginItemButton;
        IBOutlet NSTextField                *_prefsWindowVersionNumberField;
        
        
        IBOutlet NSWindow                   *_aboutBoxen;
        IBOutlet NSTextField                *_aboutBoxenVersionNumberField;
        
        NSString                            *_appNameString;
        NSString                            *_versionString;
        
        NSMutableString                     *_lastAppPath;
}

+ (Controller *)sharedInstance;

// Prefs Methods
- (void)loadPreferences;
- (void)savePreferences;
- (void)setupPreferencesPanel;
- (IBAction)openPreferencesWindow:(id)sender;
- (IBAction)setDownloadsAtStartup:(id)sender;
- (IBAction)setAutoUpdates:(id)sender;
- (IBAction)setAutoUpdateRate:(id)sender;
- (IBAction)setDownloadsOvalImage:(id)sender;
- (IBAction)setDownloadsKPImage:(id)sender;
- (IBAction)setRestoreWindowPositions:(id)sender;
- (IBAction)setCurrentAEItemFromPrefs:(id)sender;
- (IBAction)setAlertOnChange:(id)sender;
- (IBAction)setAlertOnAllChanges:(id)sender;
- (IBAction)setAlertThreshold:(id)sender;
- (IBAction)setAlertWithSound:(id)sender;
- (IBAction)setAlertSoundName:(id)sender;
- (IBAction)setAlertWithMessage:(id)sender;
- (IBAction)setAutoCloseAlertWindow:(id)sender;
- (IBAction)setAlertWithEmail:(id)sender;
- (IBAction)setEmailShortMessages:(id)sender;
- (void)turnOffAlertWithMessage:(BOOL)state;
- (IBAction)changeTimeoutValue:(id)sender;
- (IBAction)setStatusItemStyle:(id)sender;
- (IBAction)addOrRemoveToLoginItems:(id)sender;

// setup & state methods
- (void)loadDownloadingIcons;
- (void)compileSystemSoundsMenu;
- (void)initStatusItem;
- (void)setLastUpdate;
- (int)nextUpdateInMinutes;
- (void)calculateNextUpdate;
- (IBAction)doNothing:(id)sender;

// Interface Updating methods
- (void)updateCosmicMenu;
- (void)checkProbabilityChange:(int)current previous:(int)previous;
- (void)checkForAnyProbabilityChange;
- (IBAction)setCurrentAEItemFromMenu:(id)sender;

// Parsing methods
- (void)parseData:(NSData *)data forType:(int)type;
- (int)getHighLatitudeProbabilityLevelFromString:(NSString *)htmlString;
- (int)getMiddleLatitudeProbabilityLevelFromString:(NSString *)htmlString;
- (int)getLowLatitudeProbabilityLevelFromString:(NSString *)htmlString;
- (int)getPCAFProbabilityLevelFromString:(NSString *)htmlString;
- (NSString *)stringForProbabilityLevel:(int)level;
- (NSString *)stringForAEItemIndex:(int)index;

- (void)setupCacheFolder;
 
// Aurora Oval Image Settings
- (void)loadCachedOvalImage;
- (void)updateOvalImageFromData:(NSData *)data;
- (void)clearOvalImage;
- (void)setOvalImageView:(NSImage *)image;
// KP Index Image Settings
- (void)loadCachedKPImage;
- (void)updateKPImageFromData:(NSData *)data;
- (void)clearKPImage;
- (void)setKPImageView:(NSImage *)image;

// Downloading methods
- (IBAction)updateOrCancel:(id)sender;
- (IBAction)update:(id)sender;
- (IBAction)cancel:(id)sender;
- (BOOL)checkAutoUpdate;
- (void)checkDownloadAtStartup;
- (BOOL)isDownloading;

// Timer methods
- (void)startUpdateTimer;
- (void)stopUpdateTimer;
- (void)updateTimer:(NSTimer *)timer;
- (void)startAnimationTimer;
- (void)stopAnimationTimer;
- (void)animationTimer:(NSTimer *)timer;

// Foo Methods
- (IBAction)openAboutBoxen:(id)sender;
- (IBAction)linkClicked:(id)sender;
- (IBAction)mailLinkClicked:(id)sender;
- (IBAction)donateLinkClicked:(id)sender;
- (IBAction)openMoreInfoLink:(id)sender;
- (void)sendEmailAlertForLat:(int)latNum value:(int)value;
- (NSString *)createEmailAllMessageFromFile;
- (NSString *)createEmailMessageFromFileForLat:(int)latNum value:(int)value;
- (BOOL)isLoginItem;
- (void)setLoginItem;
- (void)removeLoginItem;

// Data Folder methods
- (BOOL)checkCreateDataFolder:(NSString *)path;
- (BOOL)ifFolderExists:(NSString *)path;
- (NSString *)pathFromUserLibraryPath:(NSString *)inSubPath;


- (void)setLastApplicationPath;
- (void)returnFocusToLastApplication;

@end
