//
//  Alerter.h
//  Cosmic Debris
//
//  Created by John Schilling on 11/23/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface Alerter : NSWindowController {
        IBOutlet NSWindow       *_singleAlertWindow;
        IBOutlet NSWindow       *_multiAlertWindow;
        
        IBOutlet NSTextField    *_singleAlertMessageText;
        IBOutlet NSTextField    *_multiAlertHighText;
        IBOutlet NSTextField    *_multiAlertMidText;
        IBOutlet NSTextField    *_multiAlertLowText;
        IBOutlet NSTextField    *_multiAlertPCAFText;
        
        IBOutlet NSImageView    *_singleAlertIconView;
        IBOutlet NSImageView    *_multiAlertIconView;
        
        NSTimer                 *_closeTimer;
        BOOL                    _isSingleAlertMessage;
        
        NSMutableString         *_lastAppPath;
}

- (void)runSingleAlertWindowForLevel:(int)level description:(NSString *)description autoClose:(BOOL)autoClose;
- (void)runMultiAlertWindowWithHighLat:(NSString *)highLat 
                                midLat:(NSString *)midLat 
                                lowLat:(NSString *)lowLat 
                                PCAF:(NSString *)PCAF 
                                autoClose:(BOOL)autoClose;
                                
- (IBAction)toggleAlertWithMessage:(id)sender;

- (void)startCloseTimer;
- (void)stopCloseTimer;
- (void)closeTimerFired:(NSTimer *)timer;

- (void)setLastApplicationPath;
- (void)returnFocusToLastApplication;

@end
