//
//  WANController.h
//  BwanaDik
//
//  Created by John Schilling on 9/8/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BwanaHeaders.h"

@class Downloader;

@interface WANController : NSObject
{
        IBOutlet id                 _delegate;
        
        Downloader                  *_downloader;
        float                       _downloadTimeout;
        
        NSMutableString             *_currentAddress;
        NSMutableString             *_previousAddress;
        
        BDConnectionState           _currentStatus;
        BDConnectionState           _previousStatus;
        
        int                         _IPsourceTag;
        NSMutableString             *_IPURL;
        NSMutableString             *_IPTagStart;
        NSMutableString             *_IPTagEnd;
        
        BOOL                        _checking;
}

- (void)cleanup;
- (void)setDelegate:(id)delegate;

- (void)setLastKnownIPAddress:(NSString *)address
                downloadTimeout:(float)timeout
                IPSourceTag:(int)tag;
                
- (void)setDownloadTimeout:(float)timeout;
- (void)setIPSourceTag:(int)tag;
- (void)setLastKnownIPAddress:(NSString *)address;
- (void)setIPSourceStrings;
- (void)initDownloader;
- (void)resetDownloader;

- (NSString *)currentWANAddress;
- (NSString *)previousWANAddress;
- (BDConnectionState)currentOnlineStatus;
- (BDConnectionState)previousOnlineStatus;

- (void)parseAddressData:(NSData *)data;
- (void)downloadDidBegin;
- (void)downloadDidFail;
- (void)downloadDidCancel;
- (void)downloadDidFinish;
- (void)checkStatusChanged;
- (void)checkAddressChanged;

- (IBAction)beginChecking:(id)sender;
- (IBAction)cancelChecking:(id)sender;
- (IBAction)checkOrCancel:(id)sender;
- (BOOL)isChecking;
- (BOOL)isDownloading;

@end


@interface NSObject (WANControllerDelegate)
- (void)WANCheckBegun;
- (void)WANCheckCanceled;
- (void)WANCheckFinished;
- (void)WANWentOnline;
- (void)WANWentOffline;
- (void)WANAddressChangedFrom:(NSString *)previousAddress to:(NSString *)currentAddress;
- (void)WANCheckFinishedWithAddress:(NSString *)currentAddress onlineStatus:(BDConnectionState)currentOnlineStatus;
@end


