//
//  Controller.h
//  BwanaDik
//
//  Created by John Schilling on 11/28/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Downloader.h"
#import "AlertPanelUp.h"
#import "AlertPanelDown.h"
#import "AlertPanelChange.h"
#import "EmailThread.h"

#import "BwanaHeaders.h"

@class WANController, LANController;

@interface Controller : NSWindowController {
    
        IBOutlet WANController      *_WAN;
        IBOutlet LANController      *_LAN;

        NSMutableString             *_lastKnownWANIPAddress;
        
        NSDictionary                *_appStrings;
        NSDictionary                *_emailStrings;
        
        NSStatusItem                *_statusItem;
        IBOutlet NSMenu             *_bwanaMenu;
        IBOutlet NSMenuItem         *_networkStatusMenuItem;
        IBOutlet NSMenuItem         *_currentLANaddressMenuItem;
        IBOutlet NSMenuItem         *_currentWANaddressMenuItem;
        IBOutlet NSMenuItem         *_refreshOrCancelMenuItem;
        IBOutlet NSMenuItem         *_autoUpdatesMenuItem;
        IBOutlet NSMenuItem         *_networkLocationsMenuItem;
        
        IBOutlet NSMenu             *_interfaceMenu;
        IBOutlet NSMenuItem         *_interface0MenuItem;
        IBOutlet NSMenuItem         *_interface1MenuItem;
        IBOutlet NSMenuItem         *_interface2MenuItem;
        IBOutlet NSMenuItem         *_interface3MenuItem;
        IBOutlet NSMenuItem         *_interface4MenuItem;
        IBOutlet NSMenuItem         *_interface5MenuItem;
        IBOutlet NSMenuItem         *_interface6MenuItem;
        IBOutlet NSMenuItem         *_interface7MenuItem;
        
        NSMutableArray              *_interfaceMenuItems;
        
        NSTimer                     *_updateTimer;
        NSCalendarDate              *_lastUpdatedDate;
        NSMutableString             *_lastUpdatedString;
        NSCalendarDate              *_nextUpdateDate;
        NSMutableString             *_nextUpdateString;
        
        int                         _WANIPsourceTag;
        int                         _timeoutInterval;
        BOOL                        _superWANCheck;
        BOOL                        _autoUpdates;
        BOOL                        _updateOnLocalChange;
        int                         _updateRate;
        BOOL                        _alertOnAvailable;
        BOOL                        _alertOnDisconnect;
        BOOL                        _alertOnLANChange;
        BOOL                        _alertOnWANChange;
        BOOL                        _alertPanelAutoCloses;
        
        IBOutlet NSButton           *_alertChangeToggleButton;
        
        BOOL                        _emailOnAvailable;
        BOOL                        _emailOnLANChange;
        BOOL                        _emailOnWANChange;
        NSMutableString             *_emailToAddress;

        int                         _iconStyleID;
		
        IBOutlet NSWindow           *_prefsPanel;
        IBOutlet NSPopUpButton      *_IPSourceTagMenu;
        IBOutlet NSButton           *_autoUpdatesButton;
        IBOutlet NSButton           *_superWANCheckButton;
        IBOutlet NSButton           *_updateOnLocalChangeButton;
        IBOutlet NSPopUpButton      *_updateRateMenu;
        IBOutlet NSTextField        *_timeoutTextField;
        IBOutlet NSStepper          *_timeoutStepper;
        IBOutlet NSButton           *_alertOnAvailableButton;
        IBOutlet NSButton           *_alertOnDisconnectButton;
        IBOutlet NSButton           *_alertOnLANChangeButton;
        IBOutlet NSButton           *_alertOnWANChangeButton;
        IBOutlet NSButton           *_emailOnAvailableButton;
        IBOutlet NSButton           *_emailOnLANChangeButton;
        IBOutlet NSButton           *_emailOnWANChangeButton;
        IBOutlet NSButton           *_alertPanelAutoClosesButton;
        IBOutlet NSTextField        *_emailToAddressField;
        IBOutlet NSPopUpButton      *_menuIconStyleMenu;
        IBOutlet NSButton           *_loginItemButton;
        
        IBOutlet AlertPanelUp       *_alerterUp;
        IBOutlet AlertPanelDown     *_alerterDown;
        IBOutlet AlertPanelChange   *_alerterChange;
        
        NSString                    *_appNameString;
        NSString                    *_versionString;
        
        IBOutlet NSWindow           *_aboutBoxen;
        IBOutlet NSTextField        *_aboutBoxenVersionNumberField;
        
        NSMutableString             *_lastAppPath;
}

// Misc Init Methods
- (void)loadStringsFromNib;
- (void)initStatusItem;
- (void)initInterface;

// Preferences Methods
- (void)loadPreferences;
- (void)savePreferences;
- (void)setupPrefsPanel;
- (IBAction)openPrefsPanel:(id)sender;
- (IBAction)setWANIPSource:(id)sender;
- (IBAction)setTimeoutInterval:(id)sender;
- (IBAction)setAutoUpdates:(id)sender;
- (IBAction)setSuperWANCheck:(id)sender;
- (IBAction)setUpdateOnLocalChange:(id)sender;
- (IBAction)toggleAutoUpdates:(id)sender;
- (IBAction)setUpdateRate:(id)sender;
- (IBAction)setAlertOnAvailable:(id)sender;
- (IBAction)setAlertOnDisconnect:(id)sender;
- (IBAction)setAlertOnWANChange:(id)sender;
- (IBAction)setAlertOnLANChange:(id)sender;
- (IBAction)setEmailOnAvailable:(id)sender;
- (IBAction)setEmailOnLANChange:(id)sender;
- (IBAction)setEmailOnWANChange:(id)sender;
- (IBAction)reverseAlertOnAvailable:(id)sender;
- (IBAction)reverseAlertOnDisconnect:(id)sender;
- (IBAction)reverseAlertOnWANChange:(id)sender;
- (IBAction)reverseAlertOnLANChange:(id)sender;
- (IBAction)setAutoCloseAlertPanel:(id)sender;
- (IBAction)setEmailToAddress:(id)sender;
- (IBAction)setMenuIconStyle:(id)sender;
- (IBAction)addOrRemoveToLoginItems:(id)sender;
- (void)setAutoUpdateItems;


- (IBAction)refreshOrCancelUpdate:(id)sender;

// WAN methods
- (IBAction)beginCheckingWANaddress:(id)sender;
- (IBAction)cancelCheckingWANaddress:(id)sender;
- (void)setWANInterfaceItems;
- (void)setRefreshOrCancelMenuItem;
- (void)setNetworkStatusMenuItemTitle;
- (void)setNetworkStatusIcon;
- (void)setWANaddressMenuItem;
- (int)nextWANUpdateInSeconds;
- (void)calculateNextWANUpdate;
- (void)setLastWANUpdate;

// LAN methods
- (IBAction)beginCheckingLANaddress:(id)sender;
- (void)setLANInterfaceItems;
- (void)setLANaddressMenuItemTitle;
- (void)setInterfacesMenuItemTitles;

// Locations
- (NSDictionary *)getLocationNames;
- (NSString *)getCurrentLocationName;
- (void)updateNetworkLocationsMenu;

// User action methods
- (IBAction)copyWANAddressToClipboard:(id)sender;
- (IBAction)copyLANAddressToClipboard:(id)sender;
- (IBAction)copyInterfaceToClipboard:(id)sender;
- (IBAction)setLocation:(id)sender;
- (IBAction)openNetworkPrefPane:(id)sender;

// Timer methods
- (void)stopUpdateTimer;
- (void)startUpdateTimer;
- (void)updateTimerFired:(NSTimer *)timer;
- (void)checkWANAutoUpdate;

// Alerts
- (void)runAlertUp;
- (void)runAlertDown;
- (void)runAlertChange:(NSString *)oldIP new:(NSString *)newIP type:(int)type;

// Emailing methods
- (void)sendEmailForAvailable;
- (void)sendEmailForLANAddressChange:(NSString *)newIP oldIP:(NSString *)oldIP;
- (void)sendEmailForWANAddressChange:(NSString *)newIP oldIP:(NSString *)oldIP;
- (NSString *)formatEmailMessage:(NSString *)message 
                currentLAN:(NSString *)currentLAN 
                currentWAN:(NSString *)currentWAN 
               previousLAN:(NSString *)previousLAN 
               previousWAN:(NSString *)previousWAN;

// About Box Methods
- (IBAction)openAboutBoxen:(id)sender;
- (IBAction)linkClicked:(id)sender;
- (IBAction)mailLinkClicked:(id)sender;
- (IBAction)donateLinkClicked:(id)sender;

// Foo Methods
- (NSString *)appStringForKey:(NSString *)key;

- (BOOL)isLoginItem;
- (void)setLoginItem;
- (void)removeLoginItem;

- (void)setLastApplicationPath;
- (void)returnFocusToLastApplication;

@end

