/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayFormatter {
    private static final String NULL = "null";

    ArrayFormatter() {
    }

    String format(Object o) {
        if (!this.isArray(o)) {
            return null;
        }
        if (this.isObjectArray(o)) {
            return this.formatObjectArray(o);
        }
        return this.formatPrimitiveArray(o);
    }

    private boolean isArray(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().isArray();
    }

    private boolean isObjectArray(Object o) {
        Class<?> type = o.getClass();
        return type.isArray() && !type.getComponentType().isPrimitive();
    }

    private String formatObjectArray(Object o) {
        Object[] array = (Object[])o;
        int arrayLength = Array.getLength(o);
        if (arrayLength == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(20 * (arrayLength - 1));
        this.deepToString(array, buffer, new HashSet<Object[]>());
        return buffer.toString();
    }

    private void deepToString(Object[] array, StringBuilder buffer, Set<Object[]> alreadyFormatted) {
        if (array == null) {
            buffer.append(NULL);
            return;
        }
        alreadyFormatted.add(array);
        buffer.append('[');
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            Object element;
            if (i != 0) {
                buffer.append(", ");
            }
            if (!this.isArray(element = array[i])) {
                buffer.append(element == null ? NULL : Strings.quote(element));
                continue;
            }
            if (!this.isObjectArray(element)) {
                buffer.append(this.formatPrimitiveArray(element));
                continue;
            }
            if (alreadyFormatted.contains(element)) {
                buffer.append("[...]");
                continue;
            }
            this.deepToString((Object[])element, buffer, alreadyFormatted);
        }
        buffer.append(']');
        alreadyFormatted.remove(array);
    }

    private String formatPrimitiveArray(Object o) {
        if (!this.isArray(o)) {
            return null;
        }
        Class<?> elementType = o.getClass().getComponentType();
        if (elementType.equals(Boolean.TYPE)) {
            return this.format((boolean[])o);
        }
        if (elementType.equals(Character.TYPE)) {
            return this.format((char[])o);
        }
        if (elementType.equals(Byte.TYPE)) {
            return this.format((byte[])o);
        }
        if (elementType.equals(Short.TYPE)) {
            return this.format((short[])o);
        }
        if (elementType.equals(Integer.TYPE)) {
            return this.format((int[])o);
        }
        if (elementType.equals(Long.TYPE)) {
            return this.format((long[])o);
        }
        if (elementType.equals(Float.TYPE)) {
            return this.format((float[])o);
        }
        if (elementType.equals(Double.TYPE)) {
            return this.format((double[])o);
        }
        throw new IllegalArgumentException(Strings.concat("<", o, "> is not an array of primitives"));
    }

    private String format(boolean[] array) {
        return Arrays.toString(array);
    }

    private String format(char[] array) {
        return Arrays.toString(array);
    }

    private String format(byte[] array) {
        return Arrays.toString(array);
    }

    private String format(short[] array) {
        return Arrays.toString(array);
    }

    private String format(int[] array) {
        return Arrays.toString(array);
    }

    private String format(long[] array) {
        return Arrays.toString(array);
    }

    private String format(float[] array) {
        return Arrays.toString(array);
    }

    private String format(double[] array) {
        return Arrays.toString(array);
    }
}

