/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.fest.util.Closeables;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileContentComparator {
    private static final String EOF = "EOF";

    FileContentComparator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineDiff[] compareContents(File actual, File expected) throws IOException {
        LineDiff[] lineDiffArray;
        FileInputStream ais = null;
        FileInputStream eis = null;
        try {
            ais = new FileInputStream(actual);
            eis = new FileInputStream(expected);
            List<LineDiff> diffs = this.verifyEqualContent(this.readerFor(ais), this.readerFor(eis));
            lineDiffArray = diffs.toArray(new LineDiff[diffs.size()]);
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{eis});
            Closeables.close((Closeable[])new Closeable[]{ais});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{eis});
        Closeables.close((Closeable[])new Closeable[]{ais});
        return lineDiffArray;
    }

    private LineNumberReader readerFor(InputStream inputStream) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
    }

    private List<LineDiff> verifyEqualContent(LineNumberReader actual, LineNumberReader expected) throws IOException {
        String actualLine;
        int lineNumber;
        ArrayList<LineDiff> diffs = new ArrayList<LineDiff>();
        while (true) {
            String expectedLine;
            if (!expected.ready() && !actual.ready()) {
                return diffs;
            }
            lineNumber = expected.getLineNumber();
            actualLine = actual.readLine();
            if (Objects.areEqual((Object)actualLine, (Object)(expectedLine = expected.readLine()))) continue;
            diffs.add(LineDiff.lineDiff(lineNumber, actualLine, expectedLine));
            if (!actual.ready() && expected.ready()) {
                diffs.add(LineDiff.lineDiff(lineNumber, EOF, expectedLine));
                return diffs;
            }
            if (actual.ready() && !expected.ready()) break;
        }
        diffs.add(LineDiff.lineDiff(lineNumber, actualLine, EOF));
        return diffs;
    }

    static class LineDiff {
        final int lineNumber;
        final String actual;
        final String expected;

        static LineDiff lineDiff(int lineNumber, String actual, String expected) {
            return new LineDiff(lineNumber, actual, expected);
        }

        private LineDiff(int lineNumber, String actual, String expected) {
            this.lineNumber = lineNumber;
            this.actual = actual;
            this.expected = expected;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCodeFor((Object)this.actual);
            result = 31 * result + Objects.hashCodeFor((Object)this.expected);
            result = 31 * result + this.lineNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineDiff other = (LineDiff)obj;
            if (!Objects.areEqual((Object)this.actual, (Object)other.actual)) {
                return false;
            }
            if (!Objects.areEqual((Object)this.expected, (Object)other.expected)) {
                return false;
            }
            return this.lineNumber == other.lineNumber;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("LineDiff [actual=").append(Strings.quote((String)this.actual)).append(", expected=").append(Strings.quote((String)this.expected)).append(", lineNumber=").append(this.lineNumber).append("]");
            return b.toString();
        }
    }
}

