/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;

public class FileNameDerivingClassNameConverter
implements SourceFileClassNameConverter {
    private final SourceFileClassNameConverter delegate;
    private final Set<String> fileExtensions;

    public FileNameDerivingClassNameConverter(SourceFileClassNameConverter delegate, Set<String> fileExtensions) {
        this.delegate = delegate;
        this.fileExtensions = fileExtensions;
    }

    @Override
    public Set<String> getClassNames(String sourceFileRelativePath) {
        Set<String> classNames = this.delegate.getClassNames(sourceFileRelativePath);
        if (!classNames.isEmpty()) {
            return classNames;
        }
        for (String fileExtension : this.fileExtensions) {
            if (!sourceFileRelativePath.endsWith(fileExtension)) continue;
            return Collections.singleton(StringUtils.removeEnd((String)sourceFileRelativePath.replace('/', '.'), (String)fileExtension));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getRelativeSourcePaths(String className) {
        Set<String> sourcePaths = this.delegate.getRelativeSourcePaths(className);
        if (!sourcePaths.isEmpty()) {
            return sourcePaths;
        }
        int innerClassIdx = className.indexOf("$");
        String baseName = innerClassIdx > 0 ? className.substring(0, innerClassIdx) : className;
        return this.fileExtensions.stream().map(fileExtension -> baseName.replace('.', '/') + fileExtension).collect(Collectors.toSet());
    }
}

