/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmRecordApplicabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JvmRecordApplicabilityChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public JvmRecordApplicabilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        List<KtParameter> list2;
        Object reportSupertypeOn;
        Iterator<Object> modifierOrName;
        KtElementImplStub reportOn;
        Object v0;
        Object object;
        Object object2;
        KtElementImplStub supertypeEntry22;
        block21: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(descriptor2 instanceof ClassDescriptor) || !(declaration2 instanceof KtClassOrObject)) {
                return;
            }
            for (KtElementImplStub supertypeEntry22 : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
                KotlinType kotlinType = (KotlinType)context2.getTrace().get(BindingContext.TYPE, supertypeEntry22.getTypeReference());
                KotlinType kotlinType2 = kotlinType;
                if (!Intrinsics.areEqual(kotlinType2 == null ? null : ((object2 = kotlinType2.getConstructor()) == null ? null : ((object = object2.getDeclarationDescriptor()) == null ? null : DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object))), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
                context2.getTrace().report(ErrorsJvm.ILLEGAL_JAVA_LANG_RECORD_SUPERTYPE.on(supertypeEntry22));
                return;
            }
            if (!JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)descriptor2)) {
                return;
            }
            List<KtAnnotationEntry> list3 = ((KtClassOrObject)declaration2).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"declaration.annotationEntries");
            Iterable iterable = list3;
            boolean $i$f$firstOrNull = false;
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)JvmAnnotationUtilKt.getJVM_RECORD_ANNOTATION_FQ_NAME().shortName())) continue;
                v0 = element$iv;
                break block21;
            }
            v0 = null;
        }
        supertypeEntry22 = v0;
        KtElementImplStub ktElementImplStub = reportOn = supertypeEntry22 == null ? (KtElementImplStub)((Object)declaration2) : (KtElementImplStub)supertypeEntry22;
        if (DescriptorUtilsKt.resolveTopLevelClass(context2.getModuleDescriptor(), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FOR_DEFAULT_IMPORTS) == null) {
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_REQUIRES_JDK15.on(reportOn));
            return;
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmRecordSupport)) {
            context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)context2.getLanguageVersionSettings())));
            return;
        }
        if (!JvmRecordApplicabilityCheckerKt.access$areRecordsAllowed(this.jvmTarget, context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview()))) {
            context2.getTrace().report(ErrorsJvm.JVM_RECORDS_ILLEGAL_BYTECODE_TARGET.on(reportOn));
            return;
        }
        if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
            PsiElement $i$f$firstOrNull;
            object2 = ((KtClassOrObject)declaration2).getModifierList();
            PsiElement psiElement = $i$f$firstOrNull = object2 == null ? null : ((KtModifierList)object2).getModifier(KtTokens.ENUM_KEYWORD);
            PsiElement psiElement2 = $i$f$firstOrNull == null ? ((object2 = ((KtClassOrObject)declaration2).getNameIdentifier()) == null ? (PsiElement)declaration2 : object2) : $i$f$firstOrNull;
            modifierOrName = psiElement2;
            context2.getTrace().report(ErrorsJvm.ENUM_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (!ModalityUtilsKt.isFinalClass((ClassDescriptor)descriptor2)) {
            PsiElement psiElement;
            PsiElement psiElement3;
            PsiElement $i$f$firstOrNull = ((KtClassOrObject)declaration2).getModifierList();
            if ($i$f$firstOrNull == null) {
                psiElement3 = null;
            } else {
                object2 = new KtModifierKeywordToken[3];
                object = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ABSTRACT_KEYWORD");
                object2[0] = object;
                object = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPEN_KEYWORD");
                object2[1] = object;
                object = KtTokens.SEALED_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SEALED_KEYWORD");
                object2[2] = object;
                psiElement3 = psiElement = JvmRecordApplicabilityCheckerKt.access$findOneOfModifiers($i$f$firstOrNull, (KtModifierKeywordToken[])object2);
            }
            modifierOrName = psiElement == null ? (($i$f$firstOrNull = ((KtClassOrObject)declaration2).getNameIdentifier()) == null ? (PsiElement)declaration2 : $i$f$firstOrNull) : psiElement;
            context2.getTrace().report(ErrorsJvm.NON_FINAL_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (((ClassDescriptor)descriptor2).isInner()) {
            PsiElement $i$f$firstOrNull;
            object2 = ((KtClassOrObject)declaration2).getModifierList();
            PsiElement psiElement = $i$f$firstOrNull = object2 == null ? null : ((KtModifierList)object2).getModifier(KtTokens.INNER_KEYWORD);
            PsiElement psiElement4 = $i$f$firstOrNull == null ? ((object2 = ((KtClassOrObject)declaration2).getNameIdentifier()) == null ? (PsiElement)declaration2 : object2) : $i$f$firstOrNull;
            modifierOrName = psiElement4;
            context2.getTrace().report(ErrorsJvm.INNER_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (DescriptorUtils.isLocal(descriptor2)) {
            context2.getTrace().report(ErrorsJvm.LOCAL_JVM_RECORD.on(reportOn));
            return;
        }
        for (KtDeclaration ktDeclaration : ((KtClassOrObject)declaration2).getDeclarations()) {
            if (!(ktDeclaration instanceof KtProperty)) continue;
            object = context2.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, ktDeclaration);
            Object object3 = object2 = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            if (object2 == null) continue;
            Object propertyDescriptor = object2;
            if (!Intrinsics.areEqual(context2.getTrace().getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor), (Object)true) && ((KtProperty)ktDeclaration).getDelegate() == null) continue;
            context2.getTrace().report(ErrorsJvm.FIELD_IN_JVM_RECORD.on(ktDeclaration));
            return;
        }
        for (KtSuperTypeListEntry ktSuperTypeListEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            if (!(ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry)) continue;
            context2.getTrace().report(ErrorsJvm.DELEGATION_BY_IN_JVM_RECORD.on(ktSuperTypeListEntry));
            return;
        }
        for (KotlinType kotlinType : ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes()) {
            Object classDescriptor;
            object = kotlinType.getConstructor().getDeclarationDescriptor();
            object2 = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (object2 == null || (classDescriptor = object2).getKind() == ClassKind.INTERFACE || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)classDescriptor), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
            PsiElement psiElement = ((KtClassOrObject)declaration2).getNameIdentifier();
            reportSupertypeOn = object = psiElement == null ? (PsiElement)declaration2 : psiElement;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_EXTENDS_CLASS.on((PsiElement)reportSupertypeOn, kotlinType));
            return;
        }
        if (!((ClassDescriptor)descriptor2).isData()) {
            context2.getTrace().report(ErrorsJvm.NON_DATA_CLASS_JVM_RECORD.on(reportOn));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClassOrObject)declaration2).getPrimaryConstructor();
        reportSupertypeOn = primaryConstructor2;
        Object object4 = reportSupertypeOn == null ? null : ((KtConstructor)reportSupertypeOn).getValueParameters();
        List<KtParameter> list4 = list2 = object4 == null ? CollectionsKt.emptyList() : object4;
        if (list2.isEmpty()) {
            object = primaryConstructor2;
            reportSupertypeOn = object == null ? null : ((KtConstructor)object).getValueParameterList();
            Object object5 = object4 = reportSupertypeOn == null ? ((KtClassOrObject)declaration2).getNameIdentifier() : (PsiElement)reportSupertypeOn;
            if (object4 != null) {
                reportSupertypeOn = object4;
                boolean bl = false;
                boolean bl2 = false;
                Object it = reportSupertypeOn;
                boolean bl3 = false;
                context2.getTrace().report(ErrorsJvm.JVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS.on((PsiElement)it));
                return;
            }
        }
        for (KtParameter parameter : list2) {
            if (parameter.hasValOrVar() && !parameter.isMutable()) continue;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_VAL_PARAMETER.on(parameter));
            return;
        }
        for (KtParameter parameter : CollectionsKt.dropLast(list2, (int)1)) {
            if (!parameter.isVarArg()) continue;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_LAST_VARARG_PARAMETER.on(parameter));
            return;
        }
    }
}

