/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static String[] replaceWildcards(String[] confs, ModuleDescriptor md) {
        if (confs == null) {
            return md.getConfigurationsNames();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LinkedHashSet<String> excluded = new LinkedHashSet<String>();
        for (int i = 0; i < confs.length; ++i) {
            int j;
            Configuration[] all;
            if ("*".equals(confs[i])) {
                result.addAll(Arrays.asList(md.getConfigurationsNames()));
                continue;
            }
            if ("*(public)".equals(confs[i])) {
                all = md.getConfigurations();
                for (j = 0; j < all.length; ++j) {
                    if (!all[j].getVisibility().equals(Configuration.Visibility.PUBLIC)) continue;
                    result.add(all[j].getName());
                }
                continue;
            }
            if ("*(private)".equals(confs[i])) {
                all = md.getConfigurations();
                for (j = 0; j < all.length; ++j) {
                    if (!all[j].getVisibility().equals(Configuration.Visibility.PRIVATE)) continue;
                    result.add(all[j].getName());
                }
                continue;
            }
            if (confs[i].startsWith("!")) {
                excluded.add(confs[i].substring(1));
                continue;
            }
            result.add(confs[i]);
        }
        Iterator iter = excluded.iterator();
        while (iter.hasNext()) {
            result.remove(iter.next());
        }
        return result.toArray(new String[result.size()]);
    }
}

