/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.BitSet;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public class PsiRawStringLiteralUtil {
    public static String getAdditionalTicks(String text2, String tics) {
        int quotesLength = tics.length();
        int textLength = text2.length();
        int idx = 0;
        int maxQuotesNumber = -1;
        boolean hasToReplace = false;
        while ((idx = text2.indexOf(tics, idx)) >= 0 && idx < textLength) {
            int additionalQuotesLength = PsiRawStringLiteralUtil.getTicksSequence(text2, textLength, idx + quotesLength);
            if (additionalQuotesLength == 0) {
                hasToReplace = true;
            }
            maxQuotesNumber = Math.max(maxQuotesNumber, additionalQuotesLength);
            idx += additionalQuotesLength + quotesLength;
        }
        return hasToReplace ? StringUtil.repeat("`", maxQuotesNumber + 1) : "";
    }

    public static int getLeadingTicksSequence(CharSequence text2) {
        return PsiRawStringLiteralUtil.getTicksSequence(text2, text2.length(), 0);
    }

    public static int getTrailingTicksSequence(CharSequence text2) {
        int length;
        for (length = text2.length(); length > 0 && text2.charAt(length - 1) == '`'; --length) {
        }
        return text2.length() - length;
    }

    private static int getTicksSequence(CharSequence literalText, int length, int startIndex) {
        int quotesLength;
        for (quotesLength = startIndex; quotesLength < length && literalText.charAt(quotesLength) == '`'; ++quotesLength) {
        }
        return quotesLength - startIndex;
    }

    public static int getReducedNumberOfBackticks(String text2) {
        int trailingTicsSequence;
        int leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence(text2);
        if (leadingTicsSequence == (trailingTicsSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence(text2)) && leadingTicsSequence > 1) {
            int ticsSequence;
            int length = text2.length() - trailingTicsSequence;
            BitSet usedTicSequences = new BitSet();
            usedTicSequences.set(leadingTicsSequence);
            for (int idx = leadingTicsSequence; idx < length && (idx = text2.indexOf("`", idx)) >= 0; idx += ticsSequence) {
                ticsSequence = PsiRawStringLiteralUtil.getTicksSequence(text2, length, idx);
                usedTicSequences.set(ticsSequence);
            }
            for (int i = 1; i < leadingTicsSequence; ++i) {
                if (usedTicSequences.get(i)) continue;
                return i;
            }
        }
        return -1;
    }
}

