/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.orfjackal.retrolambda.Agent;
import net.orfjackal.retrolambda.ClassAnalyzer;
import net.orfjackal.retrolambda.Config;
import net.orfjackal.retrolambda.NonDelegatingClassLoader;
import net.orfjackal.retrolambda.SystemPropertiesConfig;
import net.orfjackal.retrolambda.Transformers;
import net.orfjackal.retrolambda.files.ClasspathVisitor;
import net.orfjackal.retrolambda.files.FilteringFileVisitor;
import net.orfjackal.retrolambda.files.OutputDirectory;
import net.orfjackal.retrolambda.interfaces.ClassInfo;
import net.orfjackal.retrolambda.lambdas.LambdaClassDumper;
import net.orfjackal.retrolambda.lambdas.LambdaClassSaver;
import net.orfjackal.retrolambda.minlog.Log;
import net.orfjackal.retrolambda.util.Bytecode;

public class Retrolambda {
    public static void run(Properties systemProperties) throws Throwable {
        SystemPropertiesConfig config = new SystemPropertiesConfig(systemProperties);
        if (!config.isFullyConfigured()) {
            throw new IllegalArgumentException("not fully configured");
        }
        Retrolambda.run(config);
    }

    public static void run(Config config) throws Throwable {
        int bytecodeVersion = config.getBytecodeVersion();
        boolean defaultMethodsEnabled = config.isDefaultMethodsEnabled();
        Path inputDir = config.getInputDir();
        Path outputDir = config.getOutputDir();
        List<Path> classpath = config.getClasspath();
        List<Path> includedFiles = config.getIncludedFiles();
        final boolean isJavacHacksEnabled = config.isJavacHacksEnabled();
        if (config.isQuiet()) {
            Log.WARN();
        } else {
            Log.INFO();
        }
        Log.info("Bytecode version: " + bytecodeVersion + " (" + Bytecode.getJavaVersion(bytecodeVersion) + ")");
        Log.info("Default methods:  " + defaultMethodsEnabled);
        Log.info("Input directory:  " + inputDir);
        Log.info("Output directory: " + outputDir);
        Log.info("Classpath:        " + classpath);
        Log.info("Included files:   " + (includedFiles != null ? Integer.valueOf(includedFiles.size()) : "all"));
        Log.info("JVM version:      " + System.getProperty("java.version"));
        Log.info("Agent enabled:    " + Agent.isEnabled());
        Log.info("javac hacks:      " + isJavacHacksEnabled);
        if (!Files.isDirectory(inputDir, new LinkOption[0])) {
            Log.info("Nothing to do; not a directory: " + inputDir);
            return;
        }
        Thread.currentThread().setContextClassLoader(new NonDelegatingClassLoader(Retrolambda.asUrls(classpath)));
        final ClassAnalyzer analyzer = new ClassAnalyzer();
        final OutputDirectory outputDirectory = new OutputDirectory(outputDir);
        Transformers transformers = new Transformers(bytecodeVersion, defaultMethodsEnabled, analyzer);
        LambdaClassSaver lambdaClassSaver = new LambdaClassSaver(outputDirectory, transformers, isJavacHacksEnabled);
        try (LambdaClassDumper dumper = new LambdaClassDumper(lambdaClassSaver);){
            if (Agent.isEnabled()) {
                Agent.setLambdaClassSaver(lambdaClassSaver, isJavacHacksEnabled);
            } else {
                dumper.install();
            }
            Retrolambda.visitFiles(inputDir, includedFiles, new ClasspathVisitor(){

                @Override
                protected void visitClass(byte[] bytecode) {
                    analyzer.analyze(bytecode, isJavacHacksEnabled);
                }

                @Override
                protected void visitResource(Path relativePath, byte[] content) throws IOException {
                    outputDirectory.writeFile(relativePath, content);
                }
            });
            List<ClassInfo> interfaces = analyzer.getInterfaces();
            List<ClassInfo> classes = analyzer.getClasses();
            ArrayList<byte[]> transformed = new ArrayList<byte[]>();
            for (ClassInfo c : interfaces) {
                transformed.addAll(transformers.backportInterface(c.reader));
            }
            for (ClassInfo c : classes) {
                transformed.add(transformers.backportClass(c.reader));
            }
            for (byte[] bytecode : transformed) {
                outputDirectory.writeClass(bytecode, isJavacHacksEnabled);
            }
        }
    }

    static void visitFiles(Path inputDir, List<Path> includedFiles, FileVisitor<Path> visitor) throws IOException {
        if (includedFiles != null) {
            visitor = new FilteringFileVisitor(includedFiles, visitor);
        }
        Files.walkFileTree(inputDir, visitor);
    }

    private static URL[] asUrls(List<Path> classpath) {
        return (URL[])classpath.stream().map(Path::toUri).map(Retrolambda::uriToUrl).toArray(URL[]::new);
    }

    private static URL uriToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

