/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.orfjackal.retrolambda.Retrolambda;
import net.orfjackal.retrolambda.SystemPropertiesConfig;
import net.orfjackal.retrolambda.minlog.Log;

public class Main {
    public static void main(String[] args) {
        SystemPropertiesConfig config;
        System.out.println("Retrolambda " + Main.getVersion());
        if (!Main.isRunningJava8()) {
            Log.error("Not running under Java 8");
            System.exit(1);
        }
        if (!(config = new SystemPropertiesConfig(System.getProperties())).isFullyConfigured()) {
            System.out.print(config.getHelp());
            return;
        }
        try {
            Retrolambda.run(config);
        }
        catch (Throwable t) {
            Log.error("Failed to run Retrolambda", t);
            System.exit(1);
        }
    }

    public static boolean isRunningJava8() {
        try {
            Class.forName("java.util.stream.Stream");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String getVersion() {
        Properties p = new Properties();
        try (InputStream in = Main.class.getResourceAsStream("/META-INF/maven/net.orfjackal.retrolambda/retrolambda/pom.properties");){
            if (in != null) {
                p.load(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return p.getProperty("version", "DEVELOPMENT-VERSION");
    }
}

