-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Similarity.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY Sim IS

CURSOR Sim_c (
		Sim_OID	IN SG_SIMILARITY.OID%TYPE)
RETURN SG_SIMILARITY%ROWTYPE IS
	SELECT t.* FROM SG_SIMILARITY t
	WHERE
		OID = Sim_OID
	;

FUNCTION get_oid(
		Sim_OID	IN SG_SIMILARITY.OID%TYPE DEFAULT NULL,
		Sim_SCORE	IN SG_SIMILARITY.SCORE%TYPE DEFAULT NULL,
		Sim_EXPECT_MANTISSA	IN SG_SIMILARITY.EXPECT_MANTISSA%TYPE DEFAULT NULL,
		Sim_EXPECT_EXPONENT	IN SG_SIMILARITY.EXPECT_EXPONENT%TYPE DEFAULT NULL,
		Sim_PCT_IDENTITY	IN SG_SIMILARITY.PCT_IDENTITY%TYPE DEFAULT NULL,
		Sim_PCT_COVERAGE	IN SG_SIMILARITY.PCT_COVERAGE%TYPE DEFAULT NULL,
		Sim_SUBJ_START_POS	IN SG_SIMILARITY.SUBJ_START_POS%TYPE DEFAULT NULL,
		Sim_SUBJ_END_POS	IN SG_SIMILARITY.SUBJ_END_POS%TYPE DEFAULT NULL,
		Sim_SUBJ_STRAND	IN SG_SIMILARITY.SUBJ_STRAND%TYPE DEFAULT NULL,
		Sim_SUBJ_FRAME	IN SG_SIMILARITY.SUBJ_FRAME%TYPE DEFAULT NULL,
		Sim_OBJ_START_POS	IN SG_SIMILARITY.OBJ_START_POS%TYPE DEFAULT NULL,
		Sim_OBJ_END_POS	IN SG_SIMILARITY.OBJ_END_POS%TYPE DEFAULT NULL,
		Sim_OBJ_STRAND	IN SG_SIMILARITY.OBJ_STRAND%TYPE DEFAULT NULL,
		Sim_OBJ_FRAME	IN SG_SIMILARITY.OBJ_FRAME%TYPE DEFAULT NULL,
		SUBJ_ENT_OID	IN SG_BIOENTRY_ASSOC.SUBJ_ENT_OID%TYPE DEFAULT NULL,
		OBJ_ENT_OID	IN SG_BIOENTRY_ASSOC.OBJ_ENT_OID%TYPE DEFAULT NULL,
		TRM_OID	IN SG_BIOENTRY_ASSOC.TRM_OID%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN SG_SIMILARITY.OID%TYPE
IS
	pk	SG_SIMILARITY.OID%TYPE DEFAULT NULL;
	Sim_row Sim_c%ROWTYPE;
	OID_	SG_BIOENTRY_ASSOC.OID%TYPE DEFAULT Sim_OID;
BEGIN
	-- look up
	IF OID_ IS NOT NULL THEN
		FOR Sim_row IN Sim_c (OID_) LOOP
		        pk := Sim_row.OID;
		END LOOP;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_BIOENTRY_ASSOC (this is essentially the
		-- base class)
		IF (OID_ IS NULL) THEN
			OID_ := EntA.get_oid(
				SUBJ_ENT_OID => SUBJ_ENT_OID,
				OBJ_ENT_OID => OBJ_ENT_OID,
				TRM_OID => TRM_OID);
		END IF;
		IF (OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up EntA <' || SUBJ_ENT_OID || '|' || OBJ_ENT_OID || '|' || TRM_OID || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
			OID => OID_,
		        SCORE => Sim_SCORE,
			EXPECT_MANTISSA => Sim_EXPECT_MANTISSA,
			EXPECT_EXPONENT => Sim_EXPECT_EXPONENT,
			PCT_IDENTITY => Sim_PCT_IDENTITY,
			PCT_COVERAGE => Sim_PCT_COVERAGE,
			SUBJ_START_POS => Sim_SUBJ_START_POS,
			SUBJ_END_POS => Sim_SUBJ_END_POS,
			SUBJ_STRAND => Sim_SUBJ_STRAND,
			SUBJ_FRAME => Sim_SUBJ_FRAME,
			OBJ_START_POS => Sim_OBJ_START_POS,
			OBJ_END_POS => Sim_OBJ_END_POS,
			OBJ_STRAND => Sim_OBJ_STRAND,
			OBJ_FRAME => Sim_OBJ_FRAME);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			Sim_OID	=> pk,
		        Sim_SCORE => Sim_SCORE,
			Sim_EXPECT_MANTISSA => Sim_EXPECT_MANTISSA,
			Sim_EXPECT_EXPONENT => Sim_EXPECT_EXPONENT,
			Sim_PCT_IDENTITY => Sim_PCT_IDENTITY,
			Sim_PCT_COVERAGE => Sim_PCT_COVERAGE,
			Sim_SUBJ_START_POS => Sim_SUBJ_START_POS,
			Sim_SUBJ_END_POS => Sim_SUBJ_END_POS,
			Sim_SUBJ_STRAND => Sim_SUBJ_STRAND,
			Sim_SUBJ_FRAME => Sim_SUBJ_FRAME,
			Sim_OBJ_START_POS => Sim_OBJ_START_POS,
			Sim_OBJ_END_POS => Sim_OBJ_END_POS,
			Sim_OBJ_STRAND => Sim_OBJ_STRAND,
			Sim_OBJ_FRAME => Sim_OBJ_FRAME);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		OID	IN SG_SIMILARITY.OID%TYPE,
		SCORE	IN SG_SIMILARITY.SCORE%TYPE,
		EXPECT_MANTISSA	IN SG_SIMILARITY.EXPECT_MANTISSA%TYPE,
		EXPECT_EXPONENT	IN SG_SIMILARITY.EXPECT_EXPONENT%TYPE,
		PCT_IDENTITY	IN SG_SIMILARITY.PCT_IDENTITY%TYPE,
		PCT_COVERAGE	IN SG_SIMILARITY.PCT_COVERAGE%TYPE,
		SUBJ_START_POS	IN SG_SIMILARITY.SUBJ_START_POS%TYPE,
		SUBJ_END_POS	IN SG_SIMILARITY.SUBJ_END_POS%TYPE,
		SUBJ_STRAND	IN SG_SIMILARITY.SUBJ_STRAND%TYPE,
		SUBJ_FRAME	IN SG_SIMILARITY.SUBJ_FRAME%TYPE,
		OBJ_START_POS	IN SG_SIMILARITY.OBJ_START_POS%TYPE,
		OBJ_END_POS	IN SG_SIMILARITY.OBJ_END_POS%TYPE,
		OBJ_STRAND	IN SG_SIMILARITY.OBJ_STRAND%TYPE,
		OBJ_FRAME	IN SG_SIMILARITY.OBJ_FRAME%TYPE)
RETURN SG_SIMILARITY.OID%TYPE 
IS
BEGIN
	-- insert the record
	INSERT INTO SG_SIMILARITY (
		OID,
		SCORE,
		EXPECT_MANTISSA,
		EXPECT_EXPONENT,
		PCT_IDENTITY,
		PCT_COVERAGE,
		SUBJ_START_POS,
		SUBJ_END_POS,
		SUBJ_STRAND,
		SUBJ_FRAME,
		OBJ_START_POS,
		OBJ_END_POS,
		OBJ_STRAND,
		OBJ_FRAME)
	VALUES (OID,
		SCORE,
		EXPECT_MANTISSA,
		EXPECT_EXPONENT,
		PCT_IDENTITY,
		PCT_COVERAGE,
		SUBJ_START_POS,
		SUBJ_END_POS,
		SUBJ_STRAND,
		SUBJ_FRAME,
		OBJ_START_POS,
		OBJ_END_POS,
		OBJ_STRAND,
		OBJ_FRAME)
	;
	-- return the new pk value
	RETURN OID;
END;

PROCEDURE do_update(
		Sim_OID	IN SG_SIMILARITY.OID%TYPE,
		Sim_SCORE	IN SG_SIMILARITY.SCORE%TYPE,
		Sim_EXPECT_MANTISSA	IN SG_SIMILARITY.EXPECT_MANTISSA%TYPE,
		Sim_EXPECT_EXPONENT	IN SG_SIMILARITY.EXPECT_EXPONENT%TYPE,
		Sim_PCT_IDENTITY	IN SG_SIMILARITY.PCT_IDENTITY%TYPE,
		Sim_PCT_COVERAGE	IN SG_SIMILARITY.PCT_COVERAGE%TYPE,
		Sim_SUBJ_START_POS	IN SG_SIMILARITY.SUBJ_START_POS%TYPE,
		Sim_SUBJ_END_POS	IN SG_SIMILARITY.SUBJ_END_POS%TYPE,
		Sim_SUBJ_STRAND	IN SG_SIMILARITY.SUBJ_STRAND%TYPE,
		Sim_SUBJ_FRAME	IN SG_SIMILARITY.SUBJ_FRAME%TYPE,
		Sim_OBJ_START_POS	IN SG_SIMILARITY.OBJ_START_POS%TYPE,
		Sim_OBJ_END_POS	IN SG_SIMILARITY.OBJ_END_POS%TYPE,
		Sim_OBJ_STRAND	IN SG_SIMILARITY.OBJ_STRAND%TYPE,
		Sim_OBJ_FRAME	IN SG_SIMILARITY.OBJ_FRAME%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_SIMILARITY
	SET
		SCORE = NVL(Sim_SCORE, SCORE),
		EXPECT_MANTISSA = NVL(Sim_EXPECT_MANTISSA, EXPECT_MANTISSA),
		EXPECT_EXPONENT = NVL(Sim_EXPECT_EXPONENT, EXPECT_EXPONENT),
		PCT_IDENTITY = NVL(Sim_PCT_IDENTITY, PCT_IDENTITY),
		PCT_COVERAGE = NVL(Sim_PCT_COVERAGE, PCT_COVERAGE),
		SUBJ_START_POS = NVL(Sim_SUBJ_START_POS, SUBJ_START_POS),
		SUBJ_END_POS = NVL(Sim_SUBJ_END_POS, SUBJ_END_POS),
		SUBJ_STRAND = NVL(Sim_SUBJ_STRAND, SUBJ_STRAND),
		SUBJ_FRAME = NVL(Sim_SUBJ_FRAME, SUBJ_FRAME),
		OBJ_START_POS = NVL(Sim_OBJ_START_POS, OBJ_START_POS),
		OBJ_END_POS = NVL(Sim_OBJ_END_POS, OBJ_END_POS),
		OBJ_STRAND = NVL(Sim_OBJ_STRAND, OBJ_STRAND),
		OBJ_FRAME = NVL(Sim_OBJ_FRAME, OBJ_FRAME)
	WHERE OID = Sim_OID
	;
END;

END Sim;
/

