// Color values taken from https://github.com/matplotlib/matplotlib/blob/main/lib/matplotlib/_cm_listed.py

use crate::options::PaletteType;

pub const MAGMA: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 255., 0.001462, 0.000466, 0.013866),
	(1. / 255., 0.002258, 0.001295, 0.018331),
	(2. / 255., 0.003279, 0.002305, 0.023708),
	(3. / 255., 0.004512, 0.00349, 0.029965),
	(4. / 255., 0.00595, 0.004843, 0.03713),
	(5. / 255., 0.007588, 0.006356, 0.044973),
	(6. / 255., 0.009426, 0.008022, 0.052844),
	(7. / 255., 0.011465, 0.009828, 0.06075),
	(8. / 255., 0.013708, 0.011771, 0.068667),
	(9. / 255., 0.016156, 0.01384, 0.076603),
	(10. / 255., 0.018815, 0.016026, 0.084584),
	(11. / 255., 0.021692, 0.01832, 0.09261),
	(12. / 255., 0.024792, 0.020715, 0.100676),
	(13. / 255., 0.028123, 0.023201, 0.108787),
	(14. / 255., 0.031696, 0.025765, 0.116965),
	(15. / 255., 0.03552, 0.028397, 0.125209),
	(16. / 255., 0.039608, 0.03109, 0.133515),
	(17. / 255., 0.04383, 0.03383, 0.141886),
	(18. / 255., 0.048062, 0.036607, 0.150327),
	(19. / 255., 0.05232, 0.039407, 0.158841),
	(20. / 255., 0.056615, 0.04216, 0.167446),
	(21. / 255., 0.060949, 0.044794, 0.176129),
	(22. / 255., 0.06533, 0.047318, 0.184892),
	(23. / 255., 0.069764, 0.049726, 0.193735),
	(24. / 255., 0.074257, 0.052017, 0.20266),
	(25. / 255., 0.078815, 0.054184, 0.211667),
	(26. / 255., 0.083446, 0.056225, 0.220755),
	(27. / 255., 0.088155, 0.058133, 0.229922),
	(28. / 255., 0.092949, 0.059904, 0.239164),
	(29. / 255., 0.097833, 0.061531, 0.248477),
	(30. / 255., 0.102815, 0.06301, 0.257854),
	(31. / 255., 0.107899, 0.064335, 0.267289),
	(32. / 255., 0.113094, 0.065492, 0.276784),
	(33. / 255., 0.118405, 0.066479, 0.286321),
	(34. / 255., 0.123833, 0.067295, 0.295879),
	(35. / 255., 0.12938, 0.067935, 0.305443),
	(36. / 255., 0.135053, 0.068391, 0.315),
	(37. / 255., 0.140858, 0.068654, 0.324538),
	(38. / 255., 0.146785, 0.068738, 0.334011),
	(39. / 255., 0.152839, 0.068637, 0.343404),
	(40. / 255., 0.159018, 0.068354, 0.352688),
	(41. / 255., 0.165308, 0.067911, 0.361816),
	(42. / 255., 0.171713, 0.067305, 0.370771),
	(43. / 255., 0.178212, 0.066576, 0.379497),
	(44. / 255., 0.184801, 0.065732, 0.387973),
	(45. / 255., 0.19146, 0.064818, 0.396152),
	(46. / 255., 0.198177, 0.063862, 0.404009),
	(47. / 255., 0.204935, 0.062907, 0.411514),
	(48. / 255., 0.211718, 0.061992, 0.418647),
	(49. / 255., 0.218512, 0.061158, 0.425392),
	(50. / 255., 0.225302, 0.060445, 0.431742),
	(51. / 255., 0.232077, 0.059889, 0.437695),
	(52. / 255., 0.238826, 0.059517, 0.443256),
	(53. / 255., 0.245543, 0.059352, 0.448436),
	(54. / 255., 0.25222, 0.059415, 0.453248),
	(55. / 255., 0.258857, 0.059706, 0.45771),
	(56. / 255., 0.265447, 0.060237, 0.46184),
	(57. / 255., 0.271994, 0.060994, 0.46566),
	(58. / 255., 0.278493, 0.061978, 0.46919),
	(59. / 255., 0.284951, 0.063168, 0.472451),
	(60. / 255., 0.291366, 0.064553, 0.475462),
	(61. / 255., 0.29774, 0.066117, 0.478243),
	(62. / 255., 0.304081, 0.067835, 0.480812),
	(63. / 255., 0.310382, 0.069702, 0.483186),
	(64. / 255., 0.316654, 0.07169, 0.48538),
	(65. / 255., 0.322899, 0.073782, 0.487408),
	(66. / 255., 0.329114, 0.075972, 0.489287),
	(67. / 255., 0.335308, 0.078236, 0.491024),
	(68. / 255., 0.341482, 0.080564, 0.492631),
	(69. / 255., 0.347636, 0.082946, 0.494121),
	(70. / 255., 0.353773, 0.085373, 0.495501),
	(71. / 255., 0.359898, 0.087831, 0.496778),
	(72. / 255., 0.366012, 0.090314, 0.49796),
	(73. / 255., 0.372116, 0.092816, 0.499053),
	(74. / 255., 0.378211, 0.095332, 0.500067),
	(75. / 255., 0.384299, 0.097855, 0.501002),
	(76. / 255., 0.390384, 0.100379, 0.501864),
	(77. / 255., 0.396467, 0.102902, 0.502658),
	(78. / 255., 0.402548, 0.10542, 0.503386),
	(79. / 255., 0.408629, 0.10793, 0.504052),
	(80. / 255., 0.414709, 0.110431, 0.504662),
	(81. / 255., 0.420791, 0.11292, 0.505215),
	(82. / 255., 0.426877, 0.115395, 0.505714),
	(83. / 255., 0.432967, 0.117855, 0.50616),
	(84. / 255., 0.439062, 0.120298, 0.506555),
	(85. / 255., 0.445163, 0.122724, 0.506901),
	(86. / 255., 0.451271, 0.125132, 0.507198),
	(87. / 255., 0.457386, 0.127522, 0.507448),
	(88. / 255., 0.463508, 0.129893, 0.507652),
	(89. / 255., 0.46964, 0.132245, 0.507809),
	(90. / 255., 0.47578, 0.134577, 0.507921),
	(91. / 255., 0.481929, 0.136891, 0.507989),
	(92. / 255., 0.488088, 0.139186, 0.508011),
	(93. / 255., 0.494258, 0.141462, 0.507988),
	(94. / 255., 0.500438, 0.143719, 0.50792),
	(95. / 255., 0.506629, 0.145958, 0.507806),
	(96. / 255., 0.512831, 0.148179, 0.507648),
	(97. / 255., 0.519045, 0.150383, 0.507443),
	(98. / 255., 0.52527, 0.152569, 0.507192),
	(99. / 255., 0.531507, 0.154739, 0.506895),
	(100. / 255., 0.537755, 0.156894, 0.506551),
	(101. / 255., 0.544015, 0.159033, 0.506159),
	(102. / 255., 0.550287, 0.161158, 0.505719),
	(103. / 255., 0.556571, 0.163269, 0.50523),
	(104. / 255., 0.562866, 0.165368, 0.504692),
	(105. / 255., 0.569172, 0.167454, 0.504105),
	(106. / 255., 0.57549, 0.16953, 0.503466),
	(107. / 255., 0.581819, 0.171596, 0.502777),
	(108. / 255., 0.588158, 0.173652, 0.502035),
	(109. / 255., 0.594508, 0.175701, 0.501241),
	(110. / 255., 0.600868, 0.177743, 0.500394),
	(111. / 255., 0.607238, 0.179779, 0.499492),
	(112. / 255., 0.613617, 0.181811, 0.498536),
	(113. / 255., 0.620005, 0.18384, 0.497524),
	(114. / 255., 0.626401, 0.185867, 0.496456),
	(115. / 255., 0.632805, 0.187893, 0.495332),
	(116. / 255., 0.639216, 0.189921, 0.49415),
	(117. / 255., 0.645633, 0.191952, 0.49291),
	(118. / 255., 0.652056, 0.193986, 0.491611),
	(119. / 255., 0.658483, 0.196027, 0.490253),
	(120. / 255., 0.664915, 0.198075, 0.488836),
	(121. / 255., 0.671349, 0.200133, 0.487358),
	(122. / 255., 0.677786, 0.202203, 0.485819),
	(123. / 255., 0.684224, 0.204286, 0.484219),
	(124. / 255., 0.690661, 0.206384, 0.482558),
	(125. / 255., 0.697098, 0.208501, 0.480835),
	(126. / 255., 0.703532, 0.210638, 0.479049),
	(127. / 255., 0.709962, 0.212797, 0.477201),
	(128. / 255., 0.716387, 0.214982, 0.47529),
	(129. / 255., 0.722805, 0.217194, 0.473316),
	(130. / 255., 0.729216, 0.219437, 0.471279),
	(131. / 255., 0.735616, 0.221713, 0.46918),
	(132. / 255., 0.742004, 0.224025, 0.467018),
	(133. / 255., 0.748378, 0.226377, 0.464794),
	(134. / 255., 0.754737, 0.228772, 0.462509),
	(135. / 255., 0.761077, 0.231214, 0.460162),
	(136. / 255., 0.767398, 0.233705, 0.457755),
	(137. / 255., 0.773695, 0.236249, 0.455289),
	(138. / 255., 0.779968, 0.238851, 0.452765),
	(139. / 255., 0.786212, 0.241514, 0.450184),
	(140. / 255., 0.792427, 0.244242, 0.447543),
	(141. / 255., 0.798608, 0.24704, 0.444848),
	(142. / 255., 0.804752, 0.249911, 0.442102),
	(143. / 255., 0.810855, 0.252861, 0.439305),
	(144. / 255., 0.816914, 0.255895, 0.436461),
	(145. / 255., 0.822926, 0.259016, 0.433573),
	(146. / 255., 0.828886, 0.262229, 0.430644),
	(147. / 255., 0.834791, 0.26554, 0.427671),
	(148. / 255., 0.840636, 0.268953, 0.424666),
	(149. / 255., 0.846416, 0.272473, 0.421631),
	(150. / 255., 0.852126, 0.276106, 0.418573),
	(151. / 255., 0.857763, 0.279857, 0.415496),
	(152. / 255., 0.86332, 0.283729, 0.412403),
	(153. / 255., 0.868793, 0.287728, 0.409303),
	(154. / 255., 0.874176, 0.291859, 0.406205),
	(155. / 255., 0.879464, 0.296125, 0.403118),
	(156. / 255., 0.884651, 0.30053, 0.400047),
	(157. / 255., 0.889731, 0.305079, 0.397002),
	(158. / 255., 0.8947, 0.309773, 0.393995),
	(159. / 255., 0.899552, 0.314616, 0.391037),
	(160. / 255., 0.904281, 0.31961, 0.388137),
	(161. / 255., 0.908884, 0.324755, 0.385308),
	(162. / 255., 0.913354, 0.330052, 0.382563),
	(163. / 255., 0.917689, 0.3355, 0.379915),
	(164. / 255., 0.921884, 0.341098, 0.377376),
	(165. / 255., 0.925937, 0.346844, 0.374959),
	(166. / 255., 0.929845, 0.352734, 0.372677),
	(167. / 255., 0.933606, 0.358764, 0.370541),
	(168. / 255., 0.937221, 0.364929, 0.368567),
	(169. / 255., 0.940687, 0.371224, 0.366762),
	(170. / 255., 0.944006, 0.377643, 0.365136),
	(171. / 255., 0.94718, 0.384178, 0.363701),
	(172. / 255., 0.95021, 0.39082, 0.362468),
	(173. / 255., 0.953099, 0.397563, 0.361438),
	(174. / 255., 0.955849, 0.4044, 0.360619),
	(175. / 255., 0.958464, 0.411324, 0.360014),
	(176. / 255., 0.960949, 0.418323, 0.35963),
	(177. / 255., 0.96331, 0.42539, 0.359469),
	(178. / 255., 0.965549, 0.432519, 0.359529),
	(179. / 255., 0.967671, 0.439703, 0.35981),
	(180. / 255., 0.96968, 0.446936, 0.360311),
	(181. / 255., 0.971582, 0.45421, 0.36103),
	(182. / 255., 0.973381, 0.46152, 0.361965),
	(183. / 255., 0.975082, 0.468861, 0.363111),
	(184. / 255., 0.97669, 0.476226, 0.364466),
	(185. / 255., 0.97821, 0.483612, 0.366025),
	(186. / 255., 0.979645, 0.491014, 0.367783),
	(187. / 255., 0.981, 0.498428, 0.369734),
	(188. / 255., 0.982279, 0.505851, 0.371874),
	(189. / 255., 0.983485, 0.51328, 0.374198),
	(190. / 255., 0.984622, 0.520713, 0.376698),
	(191. / 255., 0.985693, 0.528148, 0.379371),
	(192. / 255., 0.9867, 0.535582, 0.38221),
	(193. / 255., 0.987646, 0.543015, 0.38521),
	(194. / 255., 0.988533, 0.550446, 0.388365),
	(195. / 255., 0.989363, 0.557873, 0.391671),
	(196. / 255., 0.990138, 0.565296, 0.395122),
	(197. / 255., 0.990871, 0.572706, 0.398714),
	(198. / 255., 0.991558, 0.580107, 0.402441),
	(199. / 255., 0.992196, 0.587502, 0.406299),
	(200. / 255., 0.992785, 0.594891, 0.410283),
	(201. / 255., 0.993326, 0.602275, 0.41439),
	(202. / 255., 0.993834, 0.609644, 0.418613),
	(203. / 255., 0.994309, 0.616999, 0.42295),
	(204. / 255., 0.994738, 0.62435, 0.427397),
	(205. / 255., 0.995122, 0.631696, 0.431951),
	(206. / 255., 0.99548, 0.639027, 0.436607),
	(207. / 255., 0.99581, 0.646344, 0.441361),
	(208. / 255., 0.996096, 0.653659, 0.446213),
	(209. / 255., 0.996341, 0.660969, 0.45116),
	(210. / 255., 0.99658, 0.668256, 0.456192),
	(211. / 255., 0.996775, 0.675541, 0.461314),
	(212. / 255., 0.996925, 0.682828, 0.466526),
	(213. / 255., 0.997077, 0.690088, 0.471811),
	(214. / 255., 0.997186, 0.697349, 0.477182),
	(215. / 255., 0.997254, 0.704611, 0.482635),
	(216. / 255., 0.997325, 0.711848, 0.488154),
	(217. / 255., 0.997351, 0.719089, 0.493755),
	(218. / 255., 0.997351, 0.726324, 0.499428),
	(219. / 255., 0.997341, 0.733545, 0.505167),
	(220. / 255., 0.997285, 0.740772, 0.510983),
	(221. / 255., 0.997228, 0.747981, 0.516859),
	(222. / 255., 0.997138, 0.75519, 0.522806),
	(223. / 255., 0.997019, 0.762398, 0.528821),
	(224. / 255., 0.996898, 0.769591, 0.534892),
	(225. / 255., 0.996727, 0.776795, 0.541039),
	(226. / 255., 0.996571, 0.783977, 0.547233),
	(227. / 255., 0.996369, 0.791167, 0.553499),
	(228. / 255., 0.996162, 0.798348, 0.55982),
	(229. / 255., 0.995932, 0.805527, 0.566202),
	(230. / 255., 0.99568, 0.812706, 0.572645),
	(231. / 255., 0.995424, 0.819875, 0.57914),
	(232. / 255., 0.995131, 0.827052, 0.585701),
	(233. / 255., 0.994851, 0.834213, 0.592307),
	(234. / 255., 0.994524, 0.841387, 0.598983),
	(235. / 255., 0.994222, 0.84854, 0.605696),
	(236. / 255., 0.993866, 0.855711, 0.612482),
	(237. / 255., 0.993545, 0.862859, 0.619299),
	(238. / 255., 0.99317, 0.870024, 0.626189),
	(239. / 255., 0.992831, 0.877168, 0.633109),
	(240. / 255., 0.99244, 0.88433, 0.640099),
	(241. / 255., 0.992089, 0.89147, 0.647116),
	(242. / 255., 0.991688, 0.898627, 0.654202),
	(243. / 255., 0.991332, 0.905763, 0.661309),
	(244. / 255., 0.99093, 0.912915, 0.668481),
	(245. / 255., 0.99057, 0.920049, 0.675675),
	(246. / 255., 0.990175, 0.927196, 0.682926),
	(247. / 255., 0.989815, 0.934329, 0.690198),
	(248. / 255., 0.989434, 0.94147, 0.697519),
	(249. / 255., 0.989077, 0.948604, 0.704863),
	(250. / 255., 0.988717, 0.955742, 0.712242),
	(251. / 255., 0.988367, 0.962878, 0.719649),
	(252. / 255., 0.988033, 0.970012, 0.727077),
	(253. / 255., 0.987691, 0.977154, 0.734536),
	(254. / 255., 0.987387, 0.984288, 0.742002),
	(1., 0.987053, 0.991438, 0.749504),
]);

pub const INFERNO: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 255., 0.001462, 0.000466, 0.013866),
	(1. / 255., 0.002267, 0.00127, 0.01857),
	(2. / 255., 0.003299, 0.002249, 0.024239),
	(3. / 255., 0.004547, 0.003392, 0.030909),
	(4. / 255., 0.006006, 0.004692, 0.038558),
	(5. / 255., 0.007676, 0.006136, 0.046836),
	(6. / 255., 0.009561, 0.007713, 0.055143),
	(7. / 255., 0.011663, 0.009417, 0.06346),
	(8. / 255., 0.013995, 0.011225, 0.071862),
	(9. / 255., 0.016561, 0.013136, 0.080282),
	(10. / 255., 0.019373, 0.015133, 0.088767),
	(11. / 255., 0.022447, 0.017199, 0.097327),
	(12. / 255., 0.025793, 0.019331, 0.10593),
	(13. / 255., 0.029432, 0.021503, 0.114621),
	(14. / 255., 0.033385, 0.023702, 0.123397),
	(15. / 255., 0.037668, 0.025921, 0.132232),
	(16. / 255., 0.042253, 0.028139, 0.141141),
	(17. / 255., 0.046915, 0.030324, 0.150164),
	(18. / 255., 0.051644, 0.032474, 0.159254),
	(19. / 255., 0.056449, 0.034569, 0.168414),
	(20. / 255., 0.06134, 0.03659, 0.177642),
	(21. / 255., 0.066331, 0.038504, 0.186962),
	(22. / 255., 0.071429, 0.040294, 0.196354),
	(23. / 255., 0.076637, 0.041905, 0.205799),
	(24. / 255., 0.081962, 0.043328, 0.215289),
	(25. / 255., 0.087411, 0.044556, 0.224813),
	(26. / 255., 0.09299, 0.045583, 0.234358),
	(27. / 255., 0.098702, 0.046402, 0.243904),
	(28. / 255., 0.104551, 0.047008, 0.25343),
	(29. / 255., 0.110536, 0.047399, 0.262912),
	(30. / 255., 0.116656, 0.047574, 0.272321),
	(31. / 255., 0.122908, 0.047536, 0.281624),
	(32. / 255., 0.129285, 0.047293, 0.290788),
	(33. / 255., 0.135778, 0.046856, 0.299776),
	(34. / 255., 0.142378, 0.046242, 0.308553),
	(35. / 255., 0.149073, 0.045468, 0.317085),
	(36. / 255., 0.15585, 0.044559, 0.325338),
	(37. / 255., 0.162689, 0.043554, 0.333277),
	(38. / 255., 0.169575, 0.042489, 0.340874),
	(39. / 255., 0.176493, 0.041402, 0.348111),
	(40. / 255., 0.183429, 0.040329, 0.354971),
	(41. / 255., 0.190367, 0.039309, 0.361447),
	(42. / 255., 0.197297, 0.0384, 0.367535),
	(43. / 255., 0.204209, 0.037632, 0.373238),
	(44. / 255., 0.211095, 0.03703, 0.378563),
	(45. / 255., 0.217949, 0.036615, 0.383522),
	(46. / 255., 0.224763, 0.036405, 0.388129),
	(47. / 255., 0.231538, 0.036405, 0.3924),
	(48. / 255., 0.238273, 0.036621, 0.396353),
	(49. / 255., 0.244967, 0.037055, 0.400007),
	(50. / 255., 0.25162, 0.037705, 0.403378),
	(51. / 255., 0.258234, 0.038571, 0.406485),
	(52. / 255., 0.26481, 0.039647, 0.409345),
	(53. / 255., 0.271347, 0.040922, 0.411976),
	(54. / 255., 0.27785, 0.042353, 0.414392),
	(55. / 255., 0.284321, 0.043933, 0.416608),
	(56. / 255., 0.290763, 0.045644, 0.418637),
	(57. / 255., 0.297178, 0.04747, 0.420491),
	(58. / 255., 0.303568, 0.049396, 0.422182),
	(59. / 255., 0.309935, 0.051407, 0.423721),
	(60. / 255., 0.316282, 0.05349, 0.425116),
	(61. / 255., 0.32261, 0.055634, 0.426377),
	(62. / 255., 0.328921, 0.057827, 0.427511),
	(63. / 255., 0.335217, 0.06006, 0.428524),
	(64. / 255., 0.3415, 0.062325, 0.429425),
	(65. / 255., 0.347771, 0.064616, 0.430217),
	(66. / 255., 0.354032, 0.066925, 0.430906),
	(67. / 255., 0.360284, 0.069247, 0.431497),
	(68. / 255., 0.366529, 0.071579, 0.431994),
	(69. / 255., 0.372768, 0.073915, 0.4324),
	(70. / 255., 0.379001, 0.076253, 0.432719),
	(71. / 255., 0.385228, 0.078591, 0.432955),
	(72. / 255., 0.391453, 0.080927, 0.433109),
	(73. / 255., 0.397674, 0.083257, 0.433183),
	(74. / 255., 0.403894, 0.08558, 0.433179),
	(75. / 255., 0.410113, 0.087896, 0.433098),
	(76. / 255., 0.416331, 0.090203, 0.432943),
	(77. / 255., 0.422549, 0.092501, 0.432714),
	(78. / 255., 0.428768, 0.09479, 0.432412),
	(79. / 255., 0.434987, 0.097069, 0.432039),
	(80. / 255., 0.441207, 0.099338, 0.431594),
	(81. / 255., 0.447428, 0.101597, 0.43108),
	(82. / 255., 0.453651, 0.103848, 0.430498),
	(83. / 255., 0.459875, 0.106089, 0.429846),
	(84. / 255., 0.4661, 0.108322, 0.429125),
	(85. / 255., 0.472328, 0.110547, 0.428334),
	(86. / 255., 0.478558, 0.112764, 0.427475),
	(87. / 255., 0.484789, 0.114974, 0.426548),
	(88. / 255., 0.491022, 0.117179, 0.425552),
	(89. / 255., 0.497257, 0.119379, 0.424488),
	(90. / 255., 0.503493, 0.121575, 0.423356),
	(91. / 255., 0.50973, 0.123769, 0.422156),
	(92. / 255., 0.515967, 0.12596, 0.420887),
	(93. / 255., 0.522206, 0.12815, 0.419549),
	(94. / 255., 0.528444, 0.130341, 0.418142),
	(95. / 255., 0.534683, 0.132534, 0.416667),
	(96. / 255., 0.54092, 0.134729, 0.415123),
	(97. / 255., 0.547157, 0.136929, 0.413511),
	(98. / 255., 0.553392, 0.139134, 0.411829),
	(99. / 255., 0.559624, 0.141346, 0.410078),
	(100. / 255., 0.565854, 0.143567, 0.408258),
	(101. / 255., 0.572081, 0.145797, 0.406369),
	(102. / 255., 0.578304, 0.148039, 0.404411),
	(103. / 255., 0.584521, 0.150294, 0.402385),
	(104. / 255., 0.590734, 0.152563, 0.40029),
	(105. / 255., 0.59694, 0.154848, 0.398125),
	(106. / 255., 0.603139, 0.157151, 0.395891),
	(107. / 255., 0.60933, 0.159474, 0.393589),
	(108. / 255., 0.615513, 0.161817, 0.391219),
	(109. / 255., 0.621685, 0.164184, 0.388781),
	(110. / 255., 0.627847, 0.166575, 0.386276),
	(111. / 255., 0.633998, 0.168992, 0.383704),
	(112. / 255., 0.640135, 0.171438, 0.381065),
	(113. / 255., 0.64626, 0.173914, 0.378359),
	(114. / 255., 0.652369, 0.176421, 0.375586),
	(115. / 255., 0.658463, 0.178962, 0.372748),
	(116. / 255., 0.66454, 0.181539, 0.369846),
	(117. / 255., 0.670599, 0.184153, 0.366879),
	(118. / 255., 0.676638, 0.186807, 0.363849),
	(119. / 255., 0.682656, 0.189501, 0.360757),
	(120. / 255., 0.688653, 0.192239, 0.357603),
	(121. / 255., 0.694627, 0.195021, 0.354388),
	(122. / 255., 0.700576, 0.197851, 0.351113),
	(123. / 255., 0.7065, 0.200728, 0.347777),
	(124. / 255., 0.712396, 0.203656, 0.344383),
	(125. / 255., 0.718264, 0.206636, 0.340931),
	(126. / 255., 0.724103, 0.20967, 0.337424),
	(127. / 255., 0.729909, 0.212759, 0.333861),
	(128. / 255., 0.735683, 0.215906, 0.330245),
	(129. / 255., 0.741423, 0.219112, 0.326576),
	(130. / 255., 0.747127, 0.222378, 0.322856),
	(131. / 255., 0.752794, 0.225706, 0.319085),
	(132. / 255., 0.758422, 0.229097, 0.315266),
	(133. / 255., 0.76401, 0.232554, 0.311399),
	(134. / 255., 0.769556, 0.236077, 0.307485),
	(135. / 255., 0.775059, 0.239667, 0.303526),
	(136. / 255., 0.780517, 0.243327, 0.299523),
	(137. / 255., 0.785929, 0.247056, 0.295477),
	(138. / 255., 0.791293, 0.250856, 0.29139),
	(139. / 255., 0.796607, 0.254728, 0.287264),
	(140. / 255., 0.801871, 0.258674, 0.283099),
	(141. / 255., 0.807082, 0.262692, 0.278898),
	(142. / 255., 0.812239, 0.266786, 0.274661),
	(143. / 255., 0.817341, 0.270954, 0.27039),
	(144. / 255., 0.822386, 0.275197, 0.266085),
	(145. / 255., 0.827372, 0.279517, 0.26175),
	(146. / 255., 0.832299, 0.283913, 0.257383),
	(147. / 255., 0.837165, 0.288385, 0.252988),
	(148. / 255., 0.841969, 0.292933, 0.248564),
	(149. / 255., 0.846709, 0.297559, 0.244113),
	(150. / 255., 0.851384, 0.30226, 0.239636),
	(151. / 255., 0.855992, 0.307038, 0.235133),
	(152. / 255., 0.860533, 0.311892, 0.230606),
	(153. / 255., 0.865006, 0.316822, 0.226055),
	(154. / 255., 0.869409, 0.321827, 0.221482),
	(155. / 255., 0.873741, 0.326906, 0.216886),
	(156. / 255., 0.878001, 0.33206, 0.212268),
	(157. / 255., 0.882188, 0.337287, 0.207628),
	(158. / 255., 0.886302, 0.342586, 0.202968),
	(159. / 255., 0.890341, 0.347957, 0.198286),
	(160. / 255., 0.894305, 0.353399, 0.193584),
	(161. / 255., 0.898192, 0.358911, 0.18886),
	(162. / 255., 0.902003, 0.364492, 0.184116),
	(163. / 255., 0.905735, 0.37014, 0.17935),
	(164. / 255., 0.90939, 0.375856, 0.174563),
	(165. / 255., 0.912966, 0.381636, 0.169755),
	(166. / 255., 0.916462, 0.387481, 0.164924),
	(167. / 255., 0.919879, 0.393389, 0.16007),
	(168. / 255., 0.923215, 0.399359, 0.155193),
	(169. / 255., 0.92647, 0.405389, 0.150292),
	(170. / 255., 0.929644, 0.411479, 0.145367),
	(171. / 255., 0.932737, 0.417627, 0.140417),
	(172. / 255., 0.935747, 0.423831, 0.13544),
	(173. / 255., 0.938675, 0.430091, 0.130438),
	(174. / 255., 0.941521, 0.436405, 0.125409),
	(175. / 255., 0.944285, 0.442772, 0.120354),
	(176. / 255., 0.946965, 0.449191, 0.115272),
	(177. / 255., 0.949562, 0.45566, 0.110164),
	(178. / 255., 0.952075, 0.462178, 0.105031),
	(179. / 255., 0.954506, 0.468744, 0.099874),
	(180. / 255., 0.956852, 0.475356, 0.094695),
	(181. / 255., 0.959114, 0.482014, 0.089499),
	(182. / 255., 0.961293, 0.488716, 0.084289),
	(183. / 255., 0.963387, 0.495462, 0.079073),
	(184. / 255., 0.965397, 0.502249, 0.073859),
	(185. / 255., 0.967322, 0.509078, 0.068659),
	(186. / 255., 0.969163, 0.515946, 0.063488),
	(187. / 255., 0.970919, 0.522853, 0.058367),
	(188. / 255., 0.97259, 0.529798, 0.053324),
	(189. / 255., 0.974176, 0.53678, 0.048392),
	(190. / 255., 0.975677, 0.543798, 0.043618),
	(191. / 255., 0.977092, 0.55085, 0.03905),
	(192. / 255., 0.978422, 0.557937, 0.034931),
	(193. / 255., 0.979666, 0.565057, 0.031409),
	(194. / 255., 0.980824, 0.572209, 0.028508),
	(195. / 255., 0.981895, 0.579392, 0.02625),
	(196. / 255., 0.982881, 0.586606, 0.024661),
	(197. / 255., 0.983779, 0.593849, 0.02377),
	(198. / 255., 0.984591, 0.601122, 0.023606),
	(199. / 255., 0.985315, 0.608422, 0.024202),
	(200. / 255., 0.985952, 0.61575, 0.025592),
	(201. / 255., 0.986502, 0.623105, 0.027814),
	(202. / 255., 0.986964, 0.630485, 0.030908),
	(203. / 255., 0.987337, 0.63789, 0.034916),
	(204. / 255., 0.987622, 0.64532, 0.039886),
	(205. / 255., 0.987819, 0.652773, 0.045581),
	(206. / 255., 0.987926, 0.66025, 0.05175),
	(207. / 255., 0.987945, 0.667748, 0.058329),
	(208. / 255., 0.987874, 0.675267, 0.065257),
	(209. / 255., 0.987714, 0.682807, 0.072489),
	(210. / 255., 0.987464, 0.690366, 0.07999),
	(211. / 255., 0.987124, 0.697944, 0.087731),
	(212. / 255., 0.986694, 0.70554, 0.095694),
	(213. / 255., 0.986175, 0.713153, 0.103863),
	(214. / 255., 0.985566, 0.720782, 0.112229),
	(215. / 255., 0.984865, 0.728427, 0.120785),
	(216. / 255., 0.984075, 0.736087, 0.129527),
	(217. / 255., 0.983196, 0.743758, 0.138453),
	(218. / 255., 0.982228, 0.751442, 0.147565),
	(219. / 255., 0.981173, 0.759135, 0.156863),
	(220. / 255., 0.980032, 0.766837, 0.166353),
	(221. / 255., 0.978806, 0.774545, 0.176037),
	(222. / 255., 0.977497, 0.782258, 0.185923),
	(223. / 255., 0.976108, 0.789974, 0.196018),
	(224. / 255., 0.974638, 0.797692, 0.206332),
	(225. / 255., 0.973088, 0.805409, 0.216877),
	(226. / 255., 0.971468, 0.813122, 0.227658),
	(227. / 255., 0.969783, 0.820825, 0.238686),
	(228. / 255., 0.968041, 0.828515, 0.249972),
	(229. / 255., 0.966243, 0.836191, 0.261534),
	(230. / 255., 0.964394, 0.843848, 0.273391),
	(231. / 255., 0.962517, 0.851476, 0.285546),
	(232. / 255., 0.960626, 0.859069, 0.29801),
	(233. / 255., 0.95872, 0.866624, 0.31082),
	(234. / 255., 0.956834, 0.874129, 0.323974),
	(235. / 255., 0.954997, 0.881569, 0.337475),
	(236. / 255., 0.953215, 0.888942, 0.351369),
	(237. / 255., 0.951546, 0.896226, 0.365627),
	(238. / 255., 0.950018, 0.903409, 0.380271),
	(239. / 255., 0.948683, 0.910473, 0.395289),
	(240. / 255., 0.947594, 0.917399, 0.410665),
	(241. / 255., 0.946809, 0.924168, 0.426373),
	(242. / 255., 0.946392, 0.930761, 0.442367),
	(243. / 255., 0.946403, 0.937159, 0.458592),
	(244. / 255., 0.946903, 0.943348, 0.47497),
	(245. / 255., 0.947937, 0.949318, 0.491426),
	(246. / 255., 0.949545, 0.955063, 0.50786),
	(247. / 255., 0.95174, 0.960587, 0.524203),
	(248. / 255., 0.954529, 0.965896, 0.540361),
	(249. / 255., 0.957896, 0.971003, 0.556275),
	(250. / 255., 0.961812, 0.975924, 0.571925),
	(251. / 255., 0.966249, 0.980678, 0.587206),
	(252. / 255., 0.971162, 0.985282, 0.602154),
	(253. / 255., 0.976511, 0.989753, 0.61676),
	(254. / 255., 0.982257, 0.994109, 0.631017),
	(1., 0.988362, 0.998364, 0.644924),
]);

pub const PLASMA: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 255., 0.050383, 0.029803, 0.527975),
	(1. / 255., 0.063536, 0.028426, 0.533124),
	(2. / 255., 0.075353, 0.027206, 0.538007),
	(3. / 255., 0.086222, 0.026125, 0.542658),
	(4. / 255., 0.096379, 0.025165, 0.547103),
	(5. / 255., 0.10598, 0.024309, 0.551368),
	(6. / 255., 0.115124, 0.023556, 0.555468),
	(7. / 255., 0.123903, 0.022878, 0.559423),
	(8. / 255., 0.132381, 0.022258, 0.56325),
	(9. / 255., 0.140603, 0.021687, 0.566959),
	(10. / 255., 0.148607, 0.021154, 0.570562),
	(11. / 255., 0.156421, 0.020651, 0.574065),
	(12. / 255., 0.16407, 0.020171, 0.577478),
	(13. / 255., 0.171574, 0.019706, 0.580806),
	(14. / 255., 0.17895, 0.019252, 0.584054),
	(15. / 255., 0.186213, 0.018803, 0.587228),
	(16. / 255., 0.193374, 0.018354, 0.59033),
	(17. / 255., 0.200445, 0.017902, 0.593364),
	(18. / 255., 0.207435, 0.017442, 0.596333),
	(19. / 255., 0.21435, 0.016973, 0.599239),
	(20. / 255., 0.221197, 0.016497, 0.602083),
	(21. / 255., 0.227983, 0.016007, 0.604867),
	(22. / 255., 0.234715, 0.015502, 0.607592),
	(23. / 255., 0.241396, 0.014979, 0.610259),
	(24. / 255., 0.248032, 0.014439, 0.612868),
	(25. / 255., 0.254627, 0.013882, 0.615419),
	(26. / 255., 0.261183, 0.013308, 0.617911),
	(27. / 255., 0.267703, 0.012716, 0.620346),
	(28. / 255., 0.274191, 0.012109, 0.622722),
	(29. / 255., 0.280648, 0.011488, 0.625038),
	(30. / 255., 0.287076, 0.010855, 0.627295),
	(31. / 255., 0.293478, 0.010213, 0.62949),
	(32. / 255., 0.299855, 0.009561, 0.631624),
	(33. / 255., 0.30621, 0.008902, 0.633694),
	(34. / 255., 0.312543, 0.008239, 0.6357),
	(35. / 255., 0.318856, 0.007576, 0.63764),
	(36. / 255., 0.32515, 0.006915, 0.639512),
	(37. / 255., 0.331426, 0.006261, 0.641316),
	(38. / 255., 0.337683, 0.005618, 0.643049),
	(39. / 255., 0.343925, 0.004991, 0.64471),
	(40. / 255., 0.35015, 0.004382, 0.646298),
	(41. / 255., 0.356359, 0.003798, 0.64781),
	(42. / 255., 0.362553, 0.003243, 0.649245),
	(43. / 255., 0.368733, 0.002724, 0.650601),
	(44. / 255., 0.374897, 0.002245, 0.651876),
	(45. / 255., 0.381047, 0.001814, 0.653068),
	(46. / 255., 0.387183, 0.001434, 0.654177),
	(47. / 255., 0.393304, 0.001114, 0.655199),
	(48. / 255., 0.399411, 0.000859, 0.656133),
	(49. / 255., 0.405503, 0.000678, 0.656977),
	(50. / 255., 0.41158, 0.000577, 0.65773),
	(51. / 255., 0.417642, 0.000564, 0.65839),
	(52. / 255., 0.423689, 0.000646, 0.658956),
	(53. / 255., 0.429719, 0.000831, 0.659425),
	(54. / 255., 0.435734, 0.001127, 0.659797),
	(55. / 255., 0.441732, 0.00154, 0.660069),
	(56. / 255., 0.447714, 0.00208, 0.66024),
	(57. / 255., 0.453677, 0.002755, 0.66031),
	(58. / 255., 0.459623, 0.003574, 0.660277),
	(59. / 255., 0.46555, 0.004545, 0.660139),
	(60. / 255., 0.471457, 0.005678, 0.659897),
	(61. / 255., 0.477344, 0.00698, 0.659549),
	(62. / 255., 0.48321, 0.00846, 0.659095),
	(63. / 255., 0.489055, 0.010127, 0.658534),
	(64. / 255., 0.494877, 0.01199, 0.657865),
	(65. / 255., 0.500678, 0.014055, 0.657088),
	(66. / 255., 0.506454, 0.016333, 0.656202),
	(67. / 255., 0.512206, 0.018833, 0.655209),
	(68. / 255., 0.517933, 0.021563, 0.654109),
	(69. / 255., 0.523633, 0.024532, 0.652901),
	(70. / 255., 0.529306, 0.027747, 0.651586),
	(71. / 255., 0.534952, 0.031217, 0.650165),
	(72. / 255., 0.54057, 0.03495, 0.64864),
	(73. / 255., 0.546157, 0.038954, 0.64701),
	(74. / 255., 0.551715, 0.043136, 0.645277),
	(75. / 255., 0.557243, 0.047331, 0.643443),
	(76. / 255., 0.562738, 0.051545, 0.641509),
	(77. / 255., 0.568201, 0.055778, 0.639477),
	(78. / 255., 0.573632, 0.060028, 0.637349),
	(79. / 255., 0.579029, 0.064296, 0.635126),
	(80. / 255., 0.584391, 0.068579, 0.632812),
	(81. / 255., 0.589719, 0.072878, 0.630408),
	(82. / 255., 0.595011, 0.07719, 0.627917),
	(83. / 255., 0.600266, 0.081516, 0.625342),
	(84. / 255., 0.605485, 0.085854, 0.622686),
	(85. / 255., 0.610667, 0.090204, 0.619951),
	(86. / 255., 0.615812, 0.094564, 0.61714),
	(87. / 255., 0.620919, 0.098934, 0.614257),
	(88. / 255., 0.625987, 0.103312, 0.611305),
	(89. / 255., 0.631017, 0.107699, 0.608287),
	(90. / 255., 0.636008, 0.112092, 0.605205),
	(91. / 255., 0.640959, 0.116492, 0.602065),
	(92. / 255., 0.645872, 0.120898, 0.598867),
	(93. / 255., 0.650746, 0.125309, 0.595617),
	(94. / 255., 0.65558, 0.129725, 0.592317),
	(95. / 255., 0.660374, 0.134144, 0.588971),
	(96. / 255., 0.665129, 0.138566, 0.585582),
	(97. / 255., 0.669845, 0.142992, 0.582154),
	(98. / 255., 0.674522, 0.147419, 0.578688),
	(99. / 255., 0.67916, 0.151848, 0.575189),
	(100. / 255., 0.683758, 0.156278, 0.57166),
	(101. / 255., 0.688318, 0.160709, 0.568103),
	(102. / 255., 0.69284, 0.165141, 0.564522),
	(103. / 255., 0.697324, 0.169573, 0.560919),
	(104. / 255., 0.701769, 0.174005, 0.557296),
	(105. / 255., 0.706178, 0.178437, 0.553657),
	(106. / 255., 0.710549, 0.182868, 0.550004),
	(107. / 255., 0.714883, 0.187299, 0.546338),
	(108. / 255., 0.719181, 0.191729, 0.542663),
	(109. / 255., 0.723444, 0.196158, 0.538981),
	(110. / 255., 0.72767, 0.200586, 0.535293),
	(111. / 255., 0.731862, 0.205013, 0.531601),
	(112. / 255., 0.736019, 0.209439, 0.527908),
	(113. / 255., 0.740143, 0.213864, 0.524216),
	(114. / 255., 0.744232, 0.218288, 0.520524),
	(115. / 255., 0.748289, 0.222711, 0.516834),
	(116. / 255., 0.752312, 0.227133, 0.513149),
	(117. / 255., 0.756304, 0.231555, 0.509468),
	(118. / 255., 0.760264, 0.235976, 0.505794),
	(119. / 255., 0.764193, 0.240396, 0.502126),
	(120. / 255., 0.76809, 0.244817, 0.498465),
	(121. / 255., 0.771958, 0.249237, 0.494813),
	(122. / 255., 0.775796, 0.253658, 0.491171),
	(123. / 255., 0.779604, 0.258078, 0.487539),
	(124. / 255., 0.783383, 0.2625, 0.483918),
	(125. / 255., 0.787133, 0.266922, 0.480307),
	(126. / 255., 0.790855, 0.271345, 0.476706),
	(127. / 255., 0.794549, 0.27577, 0.473117),
	(128. / 255., 0.798216, 0.280197, 0.469538),
	(129. / 255., 0.801855, 0.284626, 0.465971),
	(130. / 255., 0.805467, 0.289057, 0.462415),
	(131. / 255., 0.809052, 0.293491, 0.45887),
	(132. / 255., 0.812612, 0.297928, 0.455338),
	(133. / 255., 0.816144, 0.302368, 0.451816),
	(134. / 255., 0.819651, 0.306812, 0.448306),
	(135. / 255., 0.823132, 0.311261, 0.444806),
	(136. / 255., 0.826588, 0.315714, 0.441316),
	(137. / 255., 0.830018, 0.320172, 0.437836),
	(138. / 255., 0.833422, 0.324635, 0.434366),
	(139. / 255., 0.836801, 0.329105, 0.430905),
	(140. / 255., 0.840155, 0.33358, 0.427455),
	(141. / 255., 0.843484, 0.338062, 0.424013),
	(142. / 255., 0.846788, 0.342551, 0.420579),
	(143. / 255., 0.850066, 0.347048, 0.417153),
	(144. / 255., 0.853319, 0.351553, 0.413734),
	(145. / 255., 0.856547, 0.356066, 0.410322),
	(146. / 255., 0.85975, 0.360588, 0.406917),
	(147. / 255., 0.862927, 0.365119, 0.403519),
	(148. / 255., 0.866078, 0.36966, 0.400126),
	(149. / 255., 0.869203, 0.374212, 0.396738),
	(150. / 255., 0.872303, 0.378774, 0.393355),
	(151. / 255., 0.875376, 0.383347, 0.389976),
	(152. / 255., 0.878423, 0.387932, 0.3866),
	(153. / 255., 0.881443, 0.392529, 0.383229),
	(154. / 255., 0.884436, 0.397139, 0.37986),
	(155. / 255., 0.887402, 0.401762, 0.376494),
	(156. / 255., 0.89034, 0.406398, 0.37313),
	(157. / 255., 0.89325, 0.411048, 0.369768),
	(158. / 255., 0.896131, 0.415712, 0.366407),
	(159. / 255., 0.898984, 0.420392, 0.363047),
	(160. / 255., 0.901807, 0.425087, 0.359688),
	(161. / 255., 0.904601, 0.429797, 0.356329),
	(162. / 255., 0.907365, 0.434524, 0.35297),
	(163. / 255., 0.910098, 0.439268, 0.34961),
	(164. / 255., 0.9128, 0.444029, 0.346251),
	(165. / 255., 0.915471, 0.448807, 0.34289),
	(166. / 255., 0.918109, 0.453603, 0.339529),
	(167. / 255., 0.920714, 0.458417, 0.336166),
	(168. / 255., 0.923287, 0.463251, 0.332801),
	(169. / 255., 0.925825, 0.468103, 0.329435),
	(170. / 255., 0.928329, 0.472975, 0.326067),
	(171. / 255., 0.930798, 0.477867, 0.322697),
	(172. / 255., 0.933232, 0.48278, 0.319325),
	(173. / 255., 0.93563, 0.487712, 0.315952),
	(174. / 255., 0.93799, 0.492667, 0.312575),
	(175. / 255., 0.940313, 0.497642, 0.309197),
	(176. / 255., 0.942598, 0.502639, 0.305816),
	(177. / 255., 0.944844, 0.507658, 0.302433),
	(178. / 255., 0.947051, 0.512699, 0.299049),
	(179. / 255., 0.949217, 0.517763, 0.295662),
	(180. / 255., 0.951344, 0.52285, 0.292275),
	(181. / 255., 0.953428, 0.52796, 0.288883),
	(182. / 255., 0.95547, 0.533093, 0.28549),
	(183. / 255., 0.957469, 0.53825, 0.282096),
	(184. / 255., 0.959424, 0.543431, 0.278701),
	(185. / 255., 0.961336, 0.548636, 0.275305),
	(186. / 255., 0.963203, 0.553865, 0.271909),
	(187. / 255., 0.965024, 0.559118, 0.268513),
	(188. / 255., 0.966798, 0.564396, 0.265118),
	(189. / 255., 0.968526, 0.5697, 0.261721),
	(190. / 255., 0.970205, 0.575028, 0.258325),
	(191. / 255., 0.971835, 0.580382, 0.254931),
	(192. / 255., 0.973416, 0.585761, 0.25154),
	(193. / 255., 0.974947, 0.591165, 0.248151),
	(194. / 255., 0.976428, 0.596595, 0.244767),
	(195. / 255., 0.977856, 0.602051, 0.241387),
	(196. / 255., 0.979233, 0.607532, 0.238013),
	(197. / 255., 0.980556, 0.613039, 0.234646),
	(198. / 255., 0.981826, 0.618572, 0.231287),
	(199. / 255., 0.983041, 0.624131, 0.227937),
	(200. / 255., 0.984199, 0.629718, 0.224595),
	(201. / 255., 0.985301, 0.63533, 0.221265),
	(202. / 255., 0.986345, 0.640969, 0.217948),
	(203. / 255., 0.987332, 0.646633, 0.214648),
	(204. / 255., 0.98826, 0.652325, 0.211364),
	(205. / 255., 0.989128, 0.658043, 0.2081),
	(206. / 255., 0.989935, 0.663787, 0.204859),
	(207. / 255., 0.990681, 0.669558, 0.201642),
	(208. / 255., 0.991365, 0.675355, 0.198453),
	(209. / 255., 0.991985, 0.681179, 0.195295),
	(210. / 255., 0.992541, 0.68703, 0.19217),
	(211. / 255., 0.993032, 0.692907, 0.189084),
	(212. / 255., 0.993456, 0.69881, 0.186041),
	(213. / 255., 0.993814, 0.704741, 0.183043),
	(214. / 255., 0.994103, 0.710698, 0.180097),
	(215. / 255., 0.994324, 0.716681, 0.177208),
	(216. / 255., 0.994474, 0.722691, 0.174381),
	(217. / 255., 0.994553, 0.728728, 0.171622),
	(218. / 255., 0.994561, 0.734791, 0.168938),
	(219. / 255., 0.994495, 0.74088, 0.166335),
	(220. / 255., 0.994355, 0.746995, 0.163821),
	(221. / 255., 0.994141, 0.753137, 0.161404),
	(222. / 255., 0.993851, 0.759304, 0.159092),
	(223. / 255., 0.993482, 0.765499, 0.156891),
	(224. / 255., 0.993033, 0.77172, 0.154808),
	(225. / 255., 0.992505, 0.777967, 0.152855),
	(226. / 255., 0.991897, 0.784239, 0.151042),
	(227. / 255., 0.991209, 0.790537, 0.149377),
	(228. / 255., 0.990439, 0.796859, 0.14787),
	(229. / 255., 0.989587, 0.803205, 0.146529),
	(230. / 255., 0.988648, 0.809579, 0.145357),
	(231. / 255., 0.987621, 0.815978, 0.144363),
	(232. / 255., 0.986509, 0.822401, 0.143557),
	(233. / 255., 0.985314, 0.828846, 0.142945),
	(234. / 255., 0.984031, 0.835315, 0.142528),
	(235. / 255., 0.982653, 0.841812, 0.142303),
	(236. / 255., 0.98119, 0.848329, 0.142279),
	(237. / 255., 0.979644, 0.854866, 0.142453),
	(238. / 255., 0.977995, 0.861432, 0.142808),
	(239. / 255., 0.976265, 0.868016, 0.143351),
	(240. / 255., 0.974443, 0.874622, 0.144061),
	(241. / 255., 0.97253, 0.88125, 0.144923),
	(242. / 255., 0.970533, 0.887896, 0.145919),
	(243. / 255., 0.968443, 0.894564, 0.147014),
	(244. / 255., 0.966271, 0.901249, 0.14818),
	(245. / 255., 0.964021, 0.90795, 0.14937),
	(246. / 255., 0.961681, 0.914672, 0.15052),
	(247. / 255., 0.959276, 0.921407, 0.151566),
	(248. / 255., 0.956808, 0.928152, 0.152409),
	(249. / 255., 0.954287, 0.934908, 0.152921),
	(250. / 255., 0.951726, 0.941671, 0.152925),
	(251. / 255., 0.949151, 0.948435, 0.152178),
	(252. / 255., 0.946602, 0.95519, 0.150328),
	(253. / 255., 0.944152, 0.961916, 0.146861),
	(254. / 255., 0.941896, 0.96859, 0.140956),
	(1., 0.940015, 0.975158, 0.131326),
]);

pub const VIRIDIS: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 255., 0.267004, 0.004874, 0.329415),
	(1. / 255., 0.26851, 0.009605, 0.335427),
	(2. / 255., 0.269944, 0.014625, 0.341379),
	(3. / 255., 0.271305, 0.019942, 0.347269),
	(4. / 255., 0.272594, 0.025563, 0.353093),
	(5. / 255., 0.273809, 0.031497, 0.358853),
	(6. / 255., 0.274952, 0.037752, 0.364543),
	(7. / 255., 0.276022, 0.044167, 0.370164),
	(8. / 255., 0.277018, 0.050344, 0.375715),
	(9. / 255., 0.277941, 0.056324, 0.381191),
	(10. / 255., 0.278791, 0.062145, 0.386592),
	(11. / 255., 0.279566, 0.067836, 0.391917),
	(12. / 255., 0.280267, 0.073417, 0.397163),
	(13. / 255., 0.280894, 0.078907, 0.402329),
	(14. / 255., 0.281446, 0.08432, 0.407414),
	(15. / 255., 0.281924, 0.089666, 0.412415),
	(16. / 255., 0.282327, 0.094955, 0.417331),
	(17. / 255., 0.282656, 0.100196, 0.42216),
	(18. / 255., 0.28291, 0.105393, 0.426902),
	(19. / 255., 0.283091, 0.110553, 0.431554),
	(20. / 255., 0.283197, 0.11568, 0.436115),
	(21. / 255., 0.283229, 0.120777, 0.440584),
	(22. / 255., 0.283187, 0.125848, 0.44496),
	(23. / 255., 0.283072, 0.130895, 0.449241),
	(24. / 255., 0.282884, 0.13592, 0.453427),
	(25. / 255., 0.282623, 0.140926, 0.457517),
	(26. / 255., 0.28229, 0.145912, 0.46151),
	(27. / 255., 0.281887, 0.150881, 0.465405),
	(28. / 255., 0.281412, 0.155834, 0.469201),
	(29. / 255., 0.280868, 0.160771, 0.472899),
	(30. / 255., 0.280255, 0.165693, 0.476498),
	(31. / 255., 0.279574, 0.170599, 0.479997),
	(32. / 255., 0.278826, 0.17549, 0.483397),
	(33. / 255., 0.278012, 0.180367, 0.486697),
	(34. / 255., 0.277134, 0.185228, 0.489898),
	(35. / 255., 0.276194, 0.190074, 0.493001),
	(36. / 255., 0.275191, 0.194905, 0.496005),
	(37. / 255., 0.274128, 0.199721, 0.498911),
	(38. / 255., 0.273006, 0.20452, 0.501721),
	(39. / 255., 0.271828, 0.209303, 0.504434),
	(40. / 255., 0.270595, 0.214069, 0.507052),
	(41. / 255., 0.269308, 0.218818, 0.509577),
	(42. / 255., 0.267968, 0.223549, 0.512008),
	(43. / 255., 0.26658, 0.228262, 0.514349),
	(44. / 255., 0.265145, 0.232956, 0.516599),
	(45. / 255., 0.263663, 0.237631, 0.518762),
	(46. / 255., 0.262138, 0.242286, 0.520837),
	(47. / 255., 0.260571, 0.246922, 0.522828),
	(48. / 255., 0.258965, 0.251537, 0.524736),
	(49. / 255., 0.257322, 0.25613, 0.526563),
	(50. / 255., 0.255645, 0.260703, 0.528312),
	(51. / 255., 0.253935, 0.265254, 0.529983),
	(52. / 255., 0.252194, 0.269783, 0.531579),
	(53. / 255., 0.250425, 0.27429, 0.533103),
	(54. / 255., 0.248629, 0.278775, 0.534556),
	(55. / 255., 0.246811, 0.283237, 0.535941),
	(56. / 255., 0.244972, 0.287675, 0.53726),
	(57. / 255., 0.243113, 0.292092, 0.538516),
	(58. / 255., 0.241237, 0.296485, 0.539709),
	(59. / 255., 0.239346, 0.300855, 0.540844),
	(60. / 255., 0.237441, 0.305202, 0.541921),
	(61. / 255., 0.235526, 0.309527, 0.542944),
	(62. / 255., 0.233603, 0.313828, 0.543914),
	(63. / 255., 0.231674, 0.318106, 0.544834),
	(64. / 255., 0.229739, 0.322361, 0.545706),
	(65. / 255., 0.227802, 0.326594, 0.546532),
	(66. / 255., 0.225863, 0.330805, 0.547314),
	(67. / 255., 0.223925, 0.334994, 0.548053),
	(68. / 255., 0.221989, 0.339161, 0.548752),
	(69. / 255., 0.220057, 0.343307, 0.549413),
	(70. / 255., 0.21813, 0.347432, 0.550038),
	(71. / 255., 0.21621, 0.351535, 0.550627),
	(72. / 255., 0.214298, 0.355619, 0.551184),
	(73. / 255., 0.212395, 0.359683, 0.55171),
	(74. / 255., 0.210503, 0.363727, 0.552206),
	(75. / 255., 0.208623, 0.367752, 0.552675),
	(76. / 255., 0.206756, 0.371758, 0.553117),
	(77. / 255., 0.204903, 0.375746, 0.553533),
	(78. / 255., 0.203063, 0.379716, 0.553925),
	(79. / 255., 0.201239, 0.38367, 0.554294),
	(80. / 255., 0.19943, 0.387607, 0.554642),
	(81. / 255., 0.197636, 0.391528, 0.554969),
	(82. / 255., 0.19586, 0.395433, 0.555276),
	(83. / 255., 0.1941, 0.399323, 0.555565),
	(84. / 255., 0.192357, 0.403199, 0.555836),
	(85. / 255., 0.190631, 0.407061, 0.556089),
	(86. / 255., 0.188923, 0.41091, 0.556326),
	(87. / 255., 0.187231, 0.414746, 0.556547),
	(88. / 255., 0.185556, 0.41857, 0.556753),
	(89. / 255., 0.183898, 0.422383, 0.556944),
	(90. / 255., 0.182256, 0.426184, 0.55712),
	(91. / 255., 0.180629, 0.429975, 0.557282),
	(92. / 255., 0.179019, 0.433756, 0.55743),
	(93. / 255., 0.177423, 0.437527, 0.557565),
	(94. / 255., 0.175841, 0.44129, 0.557685),
	(95. / 255., 0.174274, 0.445044, 0.557792),
	(96. / 255., 0.172719, 0.448791, 0.557885),
	(97. / 255., 0.171176, 0.45253, 0.557965),
	(98. / 255., 0.169646, 0.456262, 0.55803),
	(99. / 255., 0.168126, 0.459988, 0.558082),
	(100. / 255., 0.166617, 0.463708, 0.558119),
	(101. / 255., 0.165117, 0.467423, 0.558141),
	(102. / 255., 0.163625, 0.471133, 0.558148),
	(103. / 255., 0.162142, 0.474838, 0.55814),
	(104. / 255., 0.160665, 0.47854, 0.558115),
	(105. / 255., 0.159194, 0.482237, 0.558073),
	(106. / 255., 0.157729, 0.485932, 0.558013),
	(107. / 255., 0.15627, 0.489624, 0.557936),
	(108. / 255., 0.154815, 0.493313, 0.55784),
	(109. / 255., 0.153364, 0.497, 0.557724),
	(110. / 255., 0.151918, 0.500685, 0.557587),
	(111. / 255., 0.150476, 0.504369, 0.55743),
	(112. / 255., 0.149039, 0.508051, 0.55725),
	(113. / 255., 0.147607, 0.511733, 0.557049),
	(114. / 255., 0.14618, 0.515413, 0.556823),
	(115. / 255., 0.144759, 0.519093, 0.556572),
	(116. / 255., 0.143343, 0.522773, 0.556295),
	(117. / 255., 0.141935, 0.526453, 0.555991),
	(118. / 255., 0.140536, 0.530132, 0.555659),
	(119. / 255., 0.139147, 0.533812, 0.555298),
	(120. / 255., 0.13777, 0.537492, 0.554906),
	(121. / 255., 0.136408, 0.541173, 0.554483),
	(122. / 255., 0.135066, 0.544853, 0.554029),
	(123. / 255., 0.133743, 0.548535, 0.553541),
	(124. / 255., 0.132444, 0.552216, 0.553018),
	(125. / 255., 0.131172, 0.555899, 0.552459),
	(126. / 255., 0.129933, 0.559582, 0.551864),
	(127. / 255., 0.128729, 0.563265, 0.551229),
	(128. / 255., 0.127568, 0.566949, 0.550556),
	(129. / 255., 0.126453, 0.570633, 0.549841),
	(130. / 255., 0.125394, 0.574318, 0.549086),
	(131. / 255., 0.124395, 0.578002, 0.548287),
	(132. / 255., 0.123463, 0.581687, 0.547445),
	(133. / 255., 0.122606, 0.585371, 0.546557),
	(134. / 255., 0.121831, 0.589055, 0.545623),
	(135. / 255., 0.121148, 0.592739, 0.544641),
	(136. / 255., 0.120565, 0.596422, 0.543611),
	(137. / 255., 0.120092, 0.600104, 0.54253),
	(138. / 255., 0.119738, 0.603785, 0.5414),
	(139. / 255., 0.119512, 0.607464, 0.540218),
	(140. / 255., 0.119423, 0.611141, 0.538982),
	(141. / 255., 0.119483, 0.614817, 0.537692),
	(142. / 255., 0.119699, 0.61849, 0.536347),
	(143. / 255., 0.120081, 0.622161, 0.534946),
	(144. / 255., 0.120638, 0.625828, 0.533488),
	(145. / 255., 0.12138, 0.629492, 0.531973),
	(146. / 255., 0.122312, 0.633153, 0.530398),
	(147. / 255., 0.123444, 0.636809, 0.528763),
	(148. / 255., 0.12478, 0.640461, 0.527068),
	(149. / 255., 0.126326, 0.644107, 0.525311),
	(150. / 255., 0.128087, 0.647749, 0.523491),
	(151. / 255., 0.130067, 0.651384, 0.521608),
	(152. / 255., 0.132268, 0.655014, 0.519661),
	(153. / 255., 0.134692, 0.658636, 0.517649),
	(154. / 255., 0.137339, 0.662252, 0.515571),
	(155. / 255., 0.14021, 0.665859, 0.513427),
	(156. / 255., 0.143303, 0.669459, 0.511215),
	(157. / 255., 0.146616, 0.67305, 0.508936),
	(158. / 255., 0.150148, 0.676631, 0.506589),
	(159. / 255., 0.153894, 0.680203, 0.504172),
	(160. / 255., 0.157851, 0.683765, 0.501686),
	(161. / 255., 0.162016, 0.687316, 0.499129),
	(162. / 255., 0.166383, 0.690856, 0.496502),
	(163. / 255., 0.170948, 0.694384, 0.493803),
	(164. / 255., 0.175707, 0.6979, 0.491033),
	(165. / 255., 0.180653, 0.701402, 0.488189),
	(166. / 255., 0.185783, 0.704891, 0.485273),
	(167. / 255., 0.19109, 0.708366, 0.482284),
	(168. / 255., 0.196571, 0.711827, 0.479221),
	(169. / 255., 0.202219, 0.715272, 0.476084),
	(170. / 255., 0.20803, 0.718701, 0.472873),
	(171. / 255., 0.214, 0.722114, 0.469588),
	(172. / 255., 0.220124, 0.725509, 0.466226),
	(173. / 255., 0.226397, 0.728888, 0.462789),
	(174. / 255., 0.232815, 0.732247, 0.459277),
	(175. / 255., 0.239374, 0.735588, 0.455688),
	(176. / 255., 0.24607, 0.73891, 0.452024),
	(177. / 255., 0.252899, 0.742211, 0.448284),
	(178. / 255., 0.259857, 0.745492, 0.444467),
	(179. / 255., 0.266941, 0.748751, 0.440573),
	(180. / 255., 0.274149, 0.751988, 0.436601),
	(181. / 255., 0.281477, 0.755203, 0.432552),
	(182. / 255., 0.288921, 0.758394, 0.428426),
	(183. / 255., 0.296479, 0.761561, 0.424223),
	(184. / 255., 0.304148, 0.764704, 0.419943),
	(185. / 255., 0.311925, 0.767822, 0.415586),
	(186. / 255., 0.319809, 0.770914, 0.411152),
	(187. / 255., 0.327796, 0.77398, 0.40664),
	(188. / 255., 0.335885, 0.777018, 0.402049),
	(189. / 255., 0.344074, 0.780029, 0.397381),
	(190. / 255., 0.35236, 0.783011, 0.392636),
	(191. / 255., 0.360741, 0.785964, 0.387814),
	(192. / 255., 0.369214, 0.788888, 0.382914),
	(193. / 255., 0.377779, 0.791781, 0.377939),
	(194. / 255., 0.386433, 0.794644, 0.372886),
	(195. / 255., 0.395174, 0.797475, 0.367757),
	(196. / 255., 0.404001, 0.800275, 0.362552),
	(197. / 255., 0.412913, 0.803041, 0.357269),
	(198. / 255., 0.421908, 0.805774, 0.35191),
	(199. / 255., 0.430983, 0.808473, 0.346476),
	(200. / 255., 0.440137, 0.811138, 0.340967),
	(201. / 255., 0.449368, 0.813768, 0.335384),
	(202. / 255., 0.458674, 0.816363, 0.329727),
	(203. / 255., 0.468053, 0.818921, 0.323998),
	(204. / 255., 0.477504, 0.821444, 0.318195),
	(205. / 255., 0.487026, 0.823929, 0.312321),
	(206. / 255., 0.496615, 0.826376, 0.306377),
	(207. / 255., 0.506271, 0.828786, 0.300362),
	(208. / 255., 0.515992, 0.831158, 0.294279),
	(209. / 255., 0.525776, 0.833491, 0.288127),
	(210. / 255., 0.535621, 0.835785, 0.281908),
	(211. / 255., 0.545524, 0.838039, 0.275626),
	(212. / 255., 0.555484, 0.840254, 0.269281),
	(213. / 255., 0.565498, 0.84243, 0.262877),
	(214. / 255., 0.575563, 0.844566, 0.256415),
	(215. / 255., 0.585678, 0.846661, 0.249897),
	(216. / 255., 0.595839, 0.848717, 0.243329),
	(217. / 255., 0.606045, 0.850733, 0.236712),
	(218. / 255., 0.616293, 0.852709, 0.230052),
	(219. / 255., 0.626579, 0.854645, 0.223353),
	(220. / 255., 0.636902, 0.856542, 0.21662),
	(221. / 255., 0.647257, 0.8584, 0.209861),
	(222. / 255., 0.657642, 0.860219, 0.203082),
	(223. / 255., 0.668054, 0.861999, 0.196293),
	(224. / 255., 0.678489, 0.863742, 0.189503),
	(225. / 255., 0.688944, 0.865448, 0.182725),
	(226. / 255., 0.699415, 0.867117, 0.175971),
	(227. / 255., 0.709898, 0.868751, 0.169257),
	(228. / 255., 0.720391, 0.87035, 0.162603),
	(229. / 255., 0.730889, 0.871916, 0.156029),
	(230. / 255., 0.741388, 0.873449, 0.149561),
	(231. / 255., 0.751884, 0.874951, 0.143228),
	(232. / 255., 0.762373, 0.876424, 0.137064),
	(233. / 255., 0.772852, 0.877868, 0.131109),
	(234. / 255., 0.783315, 0.879285, 0.125405),
	(235. / 255., 0.79376, 0.880678, 0.120005),
	(236. / 255., 0.804182, 0.882046, 0.114965),
	(237. / 255., 0.814576, 0.883393, 0.110347),
	(238. / 255., 0.82494, 0.88472, 0.106217),
	(239. / 255., 0.83527, 0.886029, 0.102646),
	(240. / 255., 0.845561, 0.887322, 0.099702),
	(241. / 255., 0.85581, 0.888601, 0.097452),
	(242. / 255., 0.866013, 0.889868, 0.095953),
	(243. / 255., 0.876168, 0.891125, 0.09525),
	(244. / 255., 0.886271, 0.892374, 0.095374),
	(245. / 255., 0.89632, 0.893616, 0.096335),
	(246. / 255., 0.906311, 0.894855, 0.098125),
	(247. / 255., 0.916242, 0.896091, 0.100717),
	(248. / 255., 0.926106, 0.89733, 0.104071),
	(249. / 255., 0.935904, 0.89857, 0.108131),
	(250. / 255., 0.945636, 0.899815, 0.112838),
	(251. / 255., 0.9553, 0.901065, 0.118128),
	(252. / 255., 0.964894, 0.902323, 0.123941),
	(253. / 255., 0.974417, 0.90359, 0.130215),
	(254. / 255., 0.983868, 0.904867, 0.136897),
	(1., 0.993248, 0.906157, 0.143936),
]);

pub const CIVIDIS: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 255., 0.0, 0.135112, 0.304751),
	(1. / 255., 0.0, 0.138068, 0.311105),
	(2. / 255., 0.0, 0.141013, 0.317579),
	(3. / 255., 0.0, 0.143951, 0.323982),
	(4. / 255., 0.0, 0.146877, 0.330479),
	(5. / 255., 0.0, 0.149791, 0.337065),
	(6. / 255., 0.0, 0.152673, 0.343704),
	(7. / 255., 0.0, 0.155377, 0.3505),
	(8. / 255., 0.0, 0.157932, 0.357521),
	(9. / 255., 0.0, 0.160495, 0.364534),
	(10. / 255., 0.0, 0.163058, 0.371608),
	(11. / 255., 0.0, 0.165621, 0.378769),
	(12. / 255., 0.0, 0.168204, 0.385902),
	(13. / 255., 0.0, 0.1708, 0.3931),
	(14. / 255., 0.0, 0.17342, 0.400353),
	(15. / 255., 0.0, 0.176082, 0.407577),
	(16. / 255., 0.0, 0.178802, 0.414764),
	(17. / 255., 0.0, 0.18161, 0.421859),
	(18. / 255., 0.0, 0.18455, 0.428802),
	(19. / 255., 0.0, 0.186915, 0.435532),
	(20. / 255., 0.0, 0.188769, 0.439563),
	(21. / 255., 0.0, 0.19095, 0.441085),
	(22. / 255., 0.0, 0.193366, 0.441561),
	(23. / 255., 0.003602, 0.195911, 0.441564),
	(24. / 255., 0.017852, 0.198528, 0.441248),
	(25. / 255., 0.03211, 0.201199, 0.440785),
	(26. / 255., 0.046205, 0.203903, 0.440196),
	(27. / 255., 0.058378, 0.206629, 0.439531),
	(28. / 255., 0.068968, 0.209372, 0.438863),
	(29. / 255., 0.078624, 0.212122, 0.438105),
	(30. / 255., 0.087465, 0.214879, 0.437342),
	(31. / 255., 0.095645, 0.217643, 0.436593),
	(32. / 255., 0.103401, 0.220406, 0.43579),
	(33. / 255., 0.110658, 0.22317, 0.435067),
	(34. / 255., 0.117612, 0.225935, 0.434308),
	(35. / 255., 0.124291, 0.228697, 0.433547),
	(36. / 255., 0.130669, 0.231458, 0.43284),
	(37. / 255., 0.13683, 0.234216, 0.432148),
	(38. / 255., 0.142852, 0.236972, 0.431404),
	(39. / 255., 0.148638, 0.239724, 0.430752),
	(40. / 255., 0.154261, 0.242475, 0.43012),
	(41. / 255., 0.159733, 0.245221, 0.429528),
	(42. / 255., 0.165113, 0.247965, 0.428908),
	(43. / 255., 0.170362, 0.250707, 0.428325),
	(44. / 255., 0.17549, 0.253444, 0.42779),
	(45. / 255., 0.180503, 0.25618, 0.427299),
	(46. / 255., 0.185453, 0.258914, 0.426788),
	(47. / 255., 0.190303, 0.261644, 0.426329),
	(48. / 255., 0.195057, 0.264372, 0.425924),
	(49. / 255., 0.199764, 0.267099, 0.425497),
	(50. / 255., 0.204385, 0.269823, 0.425126),
	(51. / 255., 0.208926, 0.272546, 0.424809),
	(52. / 255., 0.213431, 0.275266, 0.42448),
	(53. / 255., 0.217863, 0.277985, 0.424206),
	(54. / 255., 0.222264, 0.280702, 0.423914),
	(55. / 255., 0.226598, 0.283419, 0.423678),
	(56. / 255., 0.230871, 0.286134, 0.423498),
	(57. / 255., 0.23512, 0.288848, 0.423304),
	(58. / 255., 0.239312, 0.291562, 0.423167),
	(59. / 255., 0.243485, 0.294274, 0.423014),
	(60. / 255., 0.247605, 0.296986, 0.422917),
	(61. / 255., 0.251675, 0.299698, 0.422873),
	(62. / 255., 0.255731, 0.302409, 0.422814),
	(63. / 255., 0.25974, 0.30512, 0.42281),
	(64. / 255., 0.263738, 0.307831, 0.422789),
	(65. / 255., 0.267693, 0.310542, 0.422821),
	(66. / 255., 0.271639, 0.313253, 0.422837),
	(67. / 255., 0.275513, 0.315965, 0.422979),
	(68. / 255., 0.279411, 0.318677, 0.423031),
	(69. / 255., 0.28324, 0.32139, 0.423211),
	(70. / 255., 0.287065, 0.324103, 0.423373),
	(71. / 255., 0.290884, 0.326816, 0.423517),
	(72. / 255., 0.294669, 0.329531, 0.423716),
	(73. / 255., 0.298421, 0.332247, 0.423973),
	(74. / 255., 0.302169, 0.334963, 0.424213),
	(75. / 255., 0.305886, 0.337681, 0.424512),
	(76. / 255., 0.309601, 0.340399, 0.42479),
	(77. / 255., 0.313287, 0.34312, 0.42512),
	(78. / 255., 0.316941, 0.345842, 0.425512),
	(79. / 255., 0.320595, 0.348565, 0.425889),
	(80. / 255., 0.32425, 0.351289, 0.42625),
	(81. / 255., 0.327875, 0.354016, 0.42667),
	(82. / 255., 0.331474, 0.356744, 0.427144),
	(83. / 255., 0.335073, 0.359474, 0.427605),
	(84. / 255., 0.338673, 0.362206, 0.428053),
	(85. / 255., 0.342246, 0.364939, 0.428559),
	(86. / 255., 0.345793, 0.367676, 0.429127),
	(87. / 255., 0.349341, 0.370414, 0.429685),
	(88. / 255., 0.352892, 0.373153, 0.430226),
	(89. / 255., 0.356418, 0.375896, 0.430823),
	(90. / 255., 0.359916, 0.378641, 0.431501),
	(91. / 255., 0.363446, 0.381388, 0.432075),
	(92. / 255., 0.366923, 0.384139, 0.432796),
	(93. / 255., 0.37043, 0.38689, 0.433428),
	(94. / 255., 0.373884, 0.389646, 0.434209),
	(95. / 255., 0.377371, 0.392404, 0.43489),
	(96. / 255., 0.38083, 0.395164, 0.435653),
	(97. / 255., 0.384268, 0.397928, 0.436475),
	(98. / 255., 0.387705, 0.400694, 0.437305),
	(99. / 255., 0.391151, 0.403464, 0.438096),
	(100. / 255., 0.394568, 0.406236, 0.438986),
	(101. / 255., 0.397991, 0.409011, 0.439848),
	(102. / 255., 0.401418, 0.41179, 0.440708),
	(103. / 255., 0.40482, 0.414572, 0.441642),
	(104. / 255., 0.408226, 0.417357, 0.44257),
	(105. / 255., 0.411607, 0.420145, 0.443577),
	(106. / 255., 0.414992, 0.422937, 0.444578),
	(107. / 255., 0.418383, 0.425733, 0.44556),
	(108. / 255., 0.421748, 0.428531, 0.44664),
	(109. / 255., 0.42512, 0.431334, 0.447692),
	(110. / 255., 0.428462, 0.43414, 0.448864),
	(111. / 255., 0.431817, 0.43695, 0.449982),
	(112. / 255., 0.435168, 0.439763, 0.451134),
	(113. / 255., 0.438504, 0.44258, 0.452341),
	(114. / 255., 0.44181, 0.445402, 0.453659),
	(115. / 255., 0.445148, 0.448226, 0.454885),
	(116. / 255., 0.448447, 0.451053, 0.456264),
	(117. / 255., 0.451759, 0.453887, 0.457582),
	(118. / 255., 0.455072, 0.456718, 0.458976),
	(119. / 255., 0.458366, 0.459552, 0.460457),
	(120. / 255., 0.461616, 0.462405, 0.461969),
	(121. / 255., 0.464947, 0.465241, 0.463395),
	(122. / 255., 0.468254, 0.468083, 0.464908),
	(123. / 255., 0.471501, 0.47096, 0.466357),
	(124. / 255., 0.474812, 0.473832, 0.467681),
	(125. / 255., 0.478186, 0.476699, 0.468845),
	(126. / 255., 0.481622, 0.479573, 0.469767),
	(127. / 255., 0.485141, 0.482451, 0.470384),
	(128. / 255., 0.488697, 0.485318, 0.471008),
	(129. / 255., 0.492278, 0.488198, 0.471453),
	(130. / 255., 0.495913, 0.491076, 0.471751),
	(131. / 255., 0.499552, 0.49396, 0.472032),
	(132. / 255., 0.503185, 0.496851, 0.472305),
	(133. / 255., 0.506866, 0.499743, 0.472432),
	(134. / 255., 0.51054, 0.502643, 0.47255),
	(135. / 255., 0.514226, 0.505546, 0.47264),
	(136. / 255., 0.51792, 0.508454, 0.472707),
	(137. / 255., 0.521643, 0.511367, 0.472639),
	(138. / 255., 0.525348, 0.514285, 0.47266),
	(139. / 255., 0.529086, 0.517207, 0.472543),
	(140. / 255., 0.532829, 0.520135, 0.472401),
	(141. / 255., 0.536553, 0.523067, 0.472352),
	(142. / 255., 0.540307, 0.526005, 0.472163),
	(143. / 255., 0.544069, 0.528948, 0.471947),
	(144. / 255., 0.54784, 0.531895, 0.471704),
	(145. / 255., 0.551612, 0.534849, 0.471439),
	(146. / 255., 0.555393, 0.537807, 0.471147),
	(147. / 255., 0.559181, 0.540771, 0.470829),
	(148. / 255., 0.562972, 0.543741, 0.470488),
	(149. / 255., 0.566802, 0.546715, 0.469988),
	(150. / 255., 0.570607, 0.549695, 0.469593),
	(151. / 255., 0.574417, 0.552682, 0.469172),
	(152. / 255., 0.578236, 0.555673, 0.468724),
	(153. / 255., 0.582087, 0.55867, 0.468118),
	(154. / 255., 0.585916, 0.561674, 0.467618),
	(155. / 255., 0.589753, 0.564682, 0.46709),
	(156. / 255., 0.593622, 0.567697, 0.466401),
	(157. / 255., 0.597469, 0.570718, 0.465821),
	(158. / 255., 0.601354, 0.573743, 0.465074),
	(159. / 255., 0.605211, 0.576777, 0.464441),
	(160. / 255., 0.609105, 0.579816, 0.463638),
	(161. / 255., 0.612977, 0.582861, 0.46295),
	(162. / 255., 0.616852, 0.585913, 0.462237),
	(163. / 255., 0.620765, 0.58897, 0.461351),
	(164. / 255., 0.624654, 0.592034, 0.460583),
	(165. / 255., 0.628576, 0.595104, 0.459641),
	(166. / 255., 0.632506, 0.59818, 0.458668),
	(167. / 255., 0.636412, 0.601264, 0.457818),
	(168. / 255., 0.640352, 0.604354, 0.456791),
	(169. / 255., 0.64427, 0.60745, 0.455886),
	(170. / 255., 0.648222, 0.610553, 0.454801),
	(171. / 255., 0.652178, 0.613664, 0.453689),
	(172. / 255., 0.656114, 0.61678, 0.452702),
	(173. / 255., 0.660082, 0.619904, 0.451534),
	(174. / 255., 0.664055, 0.623034, 0.450338),
	(175. / 255., 0.668008, 0.626171, 0.44927),
	(176. / 255., 0.671991, 0.629316, 0.448018),
	(177. / 255., 0.675981, 0.632468, 0.446736),
	(178. / 255., 0.679979, 0.635626, 0.445424),
	(179. / 255., 0.68395, 0.638793, 0.444251),
	(180. / 255., 0.687957, 0.641966, 0.442886),
	(181. / 255., 0.691971, 0.645145, 0.441491),
	(182. / 255., 0.695985, 0.648334, 0.440072),
	(183. / 255., 0.700008, 0.651529, 0.438624),
	(184. / 255., 0.704037, 0.654731, 0.437147),
	(185. / 255., 0.708067, 0.657942, 0.435647),
	(186. / 255., 0.712105, 0.66116, 0.434117),
	(187. / 255., 0.716177, 0.664384, 0.432386),
	(188. / 255., 0.720222, 0.667618, 0.430805),
	(189. / 255., 0.724274, 0.670859, 0.429194),
	(190. / 255., 0.728334, 0.674107, 0.427554),
	(191. / 255., 0.732422, 0.677364, 0.425717),
	(192. / 255., 0.736488, 0.680629, 0.424028),
	(193. / 255., 0.740589, 0.6839, 0.422131),
	(194. / 255., 0.744664, 0.687181, 0.420393),
	(195. / 255., 0.748772, 0.69047, 0.418448),
	(196. / 255., 0.752886, 0.693766, 0.416472),
	(197. / 255., 0.756975, 0.697071, 0.414659),
	(198. / 255., 0.761096, 0.700384, 0.412638),
	(199. / 255., 0.765223, 0.703705, 0.410587),
	(200. / 255., 0.769353, 0.707035, 0.408516),
	(201. / 255., 0.773486, 0.710373, 0.406422),
	(202. / 255., 0.777651, 0.713719, 0.404112),
	(203. / 255., 0.781795, 0.717074, 0.401966),
	(204. / 255., 0.785965, 0.720438, 0.399613),
	(205. / 255., 0.790116, 0.72381, 0.397423),
	(206. / 255., 0.794298, 0.72719, 0.395016),
	(207. / 255., 0.79848, 0.73058, 0.392597),
	(208. / 255., 0.802667, 0.733978, 0.390153),
	(209. / 255., 0.806859, 0.737385, 0.387684),
	(210. / 255., 0.811054, 0.740801, 0.385198),
	(211. / 255., 0.815274, 0.744226, 0.382504),
	(212. / 255., 0.819499, 0.747659, 0.379785),
	(213. / 255., 0.823729, 0.751101, 0.377043),
	(214. / 255., 0.827959, 0.754553, 0.374292),
	(215. / 255., 0.832192, 0.758014, 0.371529),
	(216. / 255., 0.836429, 0.761483, 0.368747),
	(217. / 255., 0.840693, 0.764962, 0.365746),
	(218. / 255., 0.844957, 0.76845, 0.362741),
	(219. / 255., 0.849223, 0.771947, 0.359729),
	(220. / 255., 0.853515, 0.775454, 0.3565),
	(221. / 255., 0.857809, 0.778969, 0.353259),
	(222. / 255., 0.862105, 0.782494, 0.350011),
	(223. / 255., 0.866421, 0.786028, 0.346571),
	(224. / 255., 0.870717, 0.789572, 0.343333),
	(225. / 255., 0.875057, 0.793125, 0.339685),
	(226. / 255., 0.879378, 0.796687, 0.336241),
	(227. / 255., 0.88372, 0.800258, 0.332599),
	(228. / 255., 0.888081, 0.803839, 0.32877),
	(229. / 255., 0.89244, 0.80743, 0.324968),
	(230. / 255., 0.896818, 0.81103, 0.320982),
	(231. / 255., 0.901195, 0.814639, 0.317021),
	(232. / 255., 0.905589, 0.818257, 0.312889),
	(233. / 255., 0.91, 0.821885, 0.308594),
	(234. / 255., 0.914407, 0.825522, 0.304348),
	(235. / 255., 0.918828, 0.829168, 0.29996),
	(236. / 255., 0.923279, 0.832822, 0.295244),
	(237. / 255., 0.927724, 0.836486, 0.290611),
	(238. / 255., 0.93218, 0.840159, 0.28588),
	(239. / 255., 0.93666, 0.843841, 0.280876),
	(240. / 255., 0.941147, 0.84753, 0.275815),
	(241. / 255., 0.945654, 0.851228, 0.270532),
	(242. / 255., 0.950178, 0.854933, 0.265085),
	(243. / 255., 0.954725, 0.858646, 0.259365),
	(244. / 255., 0.959284, 0.862365, 0.253563),
	(245. / 255., 0.963872, 0.866089, 0.247445),
	(246. / 255., 0.968469, 0.869819, 0.24131),
	(247. / 255., 0.973114, 0.87355, 0.234677),
	(248. / 255., 0.97778, 0.877281, 0.227954),
	(249. / 255., 0.982497, 0.881008, 0.220878),
	(250. / 255., 0.987293, 0.884718, 0.213336),
	(251. / 255., 0.992218, 0.888385, 0.205468),
	(252. / 255., 0.994847, 0.892954, 0.203445),
	(253. / 255., 0.995249, 0.898384, 0.207561),
	(254. / 255., 0.995503, 0.903866, 0.21237),
	(1., 0.995737, 0.909344, 0.217772),
]);

pub const TWILIGHT: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 509., 0.885_750_2, 0.850_009_26, 0.887_973_67),
	(1. / 509., 0.883_785_2, 0.850_729_4, 0.887_232_24),
	(2. / 509., 0.881_722_33, 0.851_275_9, 0.886_380_55),
	(3. / 509., 0.879_541_04, 0.851_656_73, 0.885_414_36),
	(4. / 509., 0.877_248_8, 0.851_870_3, 0.884_341_2),
	(5. / 509., 0.874_853_5, 0.851_915_24, 0.883_169_3),
	(6. / 509., 0.872_331_3, 0.851_801_63, 0.881_897_03),
	(7. / 509., 0.869_704_7, 0.851_524_06, 0.880_538_8),
	(8. / 509., 0.866_960_17, 0.851_089_6, 0.879_097_64),
	(9. / 509., 0.864_089_85, 0.850_503_9, 0.877_579_3),
	(10. / 509., 0.861_102_46, 0.849_767_57, 0.875_992_4),
	(11. / 509., 0.857_982_6, 0.848_889_35, 0.874_340_4),
	(12. / 509., 0.854_725_96, 0.847_874_9, 0.872_628_3),
	(13. / 509., 0.851_337_13, 0.846_727_4, 0.870_860_8),
	(14. / 509., 0.847_807_1, 0.845_454_63, 0.869_040_37),
	(15. / 509., 0.844_126_16, 0.844_064_83, 0.867_169_74),
	(16. / 509., 0.840_304_2, 0.842_560_6, 0.865_250_9),
	(17. / 509., 0.836_340_3, 0.840_948, 0.863_285_3),
	(18. / 509., 0.832_227_05, 0.839_234_9, 0.861_275_6),
	(19. / 509., 0.827_968_96, 0.837_426, 0.859_224),
	(20. / 509., 0.823_574_3, 0.835_524_86, 0.857_131_9),
	(21. / 509., 0.819_046_56, 0.833_536_5, 0.855_002_05),
	(22. / 509., 0.814_389_8, 0.831_465_6, 0.852_837_56),
	(23. / 509., 0.809_6, 0.829_318_94, 0.850_644_4),
	(24. / 509., 0.804_691_7, 0.827_098_37, 0.848_424_5),
	(25. / 509., 0.799_670_76, 0.824_807_8, 0.846_182_1),
	(26. / 509., 0.794_543, 0.822_451_2, 0.843_921_84),
	(27. / 509., 0.789_314_45, 0.820_032_1, 0.841_648_64),
	(28. / 509., 0.783_991_04, 0.817_554_24, 0.839_367_45),
	(29. / 509., 0.778_578_94, 0.815_020_9, 0.837_083_46),
	(30. / 509., 0.773_084_16, 0.812_435_27, 0.834_801_73),
	(31. / 509., 0.767_511_07, 0.809_800_74, 0.832_528_2),
	(32. / 509., 0.761_869_1, 0.807_119_5, 0.830_266_5),
	(33. / 509., 0.756_164_43, 0.804_394_07, 0.828_021_4),
	(34. / 509., 0.750_403_46, 0.801_627, 0.825_797_4),
	(35. / 509., 0.744_592_5, 0.798_820_5, 0.823_598_7),
	(36. / 509., 0.738_737_7, 0.795_976_64, 0.821_429_25),
	(37. / 509., 0.732_845_4, 0.793_097_44, 0.819_292_6),
	(38. / 509., 0.726_921_8, 0.790_184_7, 0.817_192_2),
	(39. / 509., 0.720_972_84, 0.787_239_97, 0.815_130_7),
	(40. / 509., 0.715_004, 0.784_264_86, 0.813_111_2),
	(41. / 509., 0.709_020_8, 0.781_260_9, 0.811_135_95),
	(42. / 509., 0.703_029_75, 0.778_229_06, 0.809_206_2),
	(43. / 509., 0.697_036_56, 0.775_170_5, 0.807_323_34),
	(44. / 509., 0.691_046_4, 0.772_086_3, 0.805_488_4),
	(45. / 509., 0.685_064_44, 0.768_977_4, 0.803_702_06),
	(46. / 509., 0.679_095_57, 0.765_844_7, 0.801_964_64),
	(47. / 509., 0.673_144_2, 0.762_689_1, 0.800_276_3),
	(48. / 509., 0.667_214_8, 0.759_511_3, 0.798_636_73),
	(49. / 509., 0.661_311_27, 0.756_312, 0.797_045_6),
	(50. / 509., 0.655_436_93, 0.753_092_1, 0.795_502_7),
	(51. / 509., 0.649_595_74, 0.749_852, 0.794_006_76),
	(52. / 509., 0.643_791_1, 0.746_592_4, 0.792_556_5),
	(53. / 509., 0.638_025_9, 0.743_313_8, 0.791_151),
	(54. / 509., 0.632_302_7, 0.740_016_7, 0.789_788_9),
	(55. / 509., 0.626_624_05, 0.736_701_7, 0.788_469),
	(56. / 509., 0.620_991_95, 0.733_369_35, 0.787_189_96),
	(57. / 509., 0.615_408_5, 0.730_019_9, 0.785_950_24),
	(58. / 509., 0.609_875_44, 0.726_654, 0.784_748_4),
	(59. / 509., 0.604_394_3, 0.723_271_85, 0.783_583),
	(60. / 509., 0.598_966_6, 0.719_873_96, 0.782_452_6),
	(61. / 509., 0.593_593_36, 0.716_460_6, 0.781_355_86),
	(62. / 509., 0.588_275_8, 0.713_032_1, 0.780_291_44),
	(63. / 509., 0.583_014_85, 0.709_588_9, 0.779_257_83),
	(64. / 509., 0.577_811_66, 0.706_131_04, 0.778_253_44),
	(65. / 509., 0.572_666_9, 0.702_658_95, 0.777_277_05),
	(66. / 509., 0.567_581_2, 0.699_172_8, 0.776_327_5),
	(67. / 509., 0.562_555_13, 0.695_672_8, 0.775_403_6),
	(68. / 509., 0.557_589_4, 0.692_159_1, 0.774_504_1),
	(69. / 509., 0.552_684_5, 0.688_631_95, 0.773_627_94),
	(70. / 509., 0.547_840_95, 0.685_091_44, 0.772_773_86),
	(71. / 509., 0.543_059_35, 0.681_537_7, 0.771_940_77),
	(72. / 509., 0.538_340_15, 0.677_970_8, 0.771_127_34),
	(73. / 509., 0.533_683_9, 0.674_390_9, 0.770_332_5),
	(74. / 509., 0.529_090_9, 0.670_798_1, 0.769_555_5),
	(75. / 509., 0.524_561_5, 0.667_192_46, 0.768_795_43),
	(76. / 509., 0.520_096_3, 0.663_573_9, 0.768_051_2),
	(77. / 509., 0.515_695_6, 0.659_942_6, 0.767_321_94),
	(78. / 509., 0.511_359_93, 0.656_298_5, 0.766_606_6),
	(79. / 509., 0.507_089_7, 0.652_641_7, 0.765_904_5),
	(80. / 509., 0.502_885_34, 0.648_972_15, 0.765_214_44),
	(81. / 509., 0.498_747_35, 0.645_289_9, 0.764_535_8),
	(82. / 509., 0.494_676_17, 0.641_594_8, 0.763_867_2),
	(83. / 509., 0.490_672_26, 0.637_887_06, 0.763_208_15),
	(84. / 509., 0.486_735_97, 0.634_166_5, 0.762_557_8),
	(85. / 509., 0.482_867_78, 0.630_433, 0.761_915_4),
	(86. / 509., 0.479_068_16, 0.626_686_75, 0.761_28),
	(87. / 509., 0.475_337_54, 0.622_927_55, 0.760_650_9),
	(88. / 509., 0.471_676_3, 0.619_155_4, 0.760_027_1),
	(89. / 509., 0.468_084_9, 0.615_370_3, 0.759_407_9),
	(90. / 509., 0.464_563_76, 0.611_572_1, 0.758_792_4),
	(91. / 509., 0.461_113_27, 0.607_760_8, 0.758_179_84),
	(92. / 509., 0.457_733_78, 0.603_936_3, 0.757_569_4),
	(93. / 509., 0.454_425_63, 0.600_098_6, 0.756_960_15),
	(94. / 509., 0.451_189_2, 0.596_247_6, 0.756_351_23),
	(95. / 509., 0.448_024_72, 0.592_383_3, 0.755_741_8),
	(96. / 509., 0.444_932_46, 0.588_505_6, 0.755_131_1),
	(97. / 509., 0.441_912_7, 0.584_614_4, 0.754_518_4),
	(98. / 509., 0.438_965_65, 0.580_709_7, 0.753_902_73),
	(99. / 509., 0.436_091_4, 0.576_791_4, 0.753_283_4),
	(100. / 509., 0.433_290_1, 0.572_859_4, 0.752_659_44),
	(101. / 509., 0.430_561_78, 0.568_913_76, 0.752_030_1),
	(102. / 509., 0.427_906_5, 0.564_954_3, 0.751_394_45),
	(103. / 509., 0.425_324_23, 0.560_981_04, 0.750_751_7),
	(104. / 509., 0.422_814_85, 0.556_993_9, 0.750_100_85),
	(105. / 509., 0.420_378_24, 0.552_992_9, 0.749_441_27),
	(106. / 509., 0.418_014_14, 0.548_977_85, 0.748_771_9),
	(107. / 509., 0.415_722_34, 0.544_948_8, 0.748_092_06),
	(108. / 509., 0.413_502_45, 0.540_905_8, 0.747_400_76),
	(109. / 509., 0.411_354_15, 0.536_848_6, 0.746_697_1),
	(110. / 509., 0.409_276_9, 0.532_777_3, 0.745_980_3),
	(111. / 509., 0.407_270_2, 0.528_691_9, 0.745_249_45),
	(112. / 509., 0.405_333_43, 0.524_592_3, 0.744_503_7),
	(113. / 509., 0.403_466_02, 0.520_478_5, 0.743_742_17),
	(114. / 509., 0.401_667_15, 0.516_350_45, 0.742_964),
	(115. / 509., 0.399_936_08, 0.512_208_16, 0.742_168_4),
	(116. / 509., 0.398_271_92, 0.508_051_7, 0.741_354_5),
	(117. / 509., 0.396_673_74, 0.503_880_9, 0.740_521_4),
	(118. / 509., 0.395_140_6, 0.499_695_87, 0.739_668_2),
	(119. / 509., 0.393_671_36, 0.495_496_57, 0.738_794_1),
	(120. / 509., 0.392_264_96, 0.491_283, 0.737_898_23),
	(121. / 509., 0.390_920_16, 0.487_055_2, 0.736_979_8),
	(122. / 509., 0.389_635_8, 0.482_813_18, 0.736_037_85),
	(123. / 509., 0.388_410_54, 0.478_556_9, 0.735_071_6),
	(124. / 509., 0.387_243, 0.474_286_47, 0.734_080_2),
	(125. / 509., 0.386_131_85, 0.470_001_85, 0.733_062_8),
	(126. / 509., 0.385_075_57, 0.465_703_07, 0.732_018_53),
	(127. / 509., 0.384_072_7, 0.461_390_2, 0.730_946_66),
	(128. / 509., 0.383_121_67, 0.457_063_23, 0.729_846_24),
	(129. / 509., 0.382_220_95, 0.452_722_25, 0.728_716_55),
	(130. / 509., 0.381_368_88, 0.448_367_27, 0.727_556_7),
	(131. / 509., 0.380_563_8, 0.443_998_37, 0.726_365_86),
	(132. / 509., 0.379_804_04, 0.439_615_58, 0.725_143_25),
	(133. / 509., 0.379_087_9, 0.435_219, 0.723_888),
	(134. / 509., 0.378_413_65, 0.430_808_6, 0.722_599_3),
	(135. / 509., 0.377_779_48, 0.426_384_5, 0.721_276_4),
	(136. / 509., 0.377_183_7, 0.421_946_8, 0.719_918_43),
	(137. / 509., 0.376_624_5, 0.417_495_55, 0.718_524_6),
	(138. / 509., 0.376_1, 0.413_030_8, 0.717_093_94),
	(139. / 509., 0.375_608_47, 0.408_552_68, 0.715_625_8),
	(140. / 509., 0.375_148_03, 0.404_061_26, 0.714_119_4),
	(141. / 509., 0.374_716_85, 0.399_556_64, 0.712_573_7),
	(142. / 509., 0.374_313_15, 0.395_038_96, 0.710_988),
	(143. / 509., 0.373_934_98, 0.390_508_26, 0.709_361_3),
	(144. / 509., 0.373_580_63, 0.385_964_75, 0.707_693),
	(145. / 509., 0.373_248_16, 0.381_408_48, 0.705_982),
	(146. / 509., 0.372_935_77, 0.376_839_64, 0.704_227_57),
	(147. / 509., 0.372_641_65, 0.372_258_34, 0.702_428_76),
	(148. / 509., 0.372_363_98, 0.367_664_78, 0.700_584_65),
	(149. / 509., 0.372_100_9, 0.363_059_1, 0.698_694_35),
	(150. / 509., 0.371_850_6, 0.358_441_47, 0.696_756_96),
	(151. / 509., 0.371_611_33, 0.353_812_13, 0.694_771_5),
	(152. / 509., 0.371_381_25, 0.349_171_28, 0.692_737_04),
	(153. / 509., 0.371_158_57, 0.344_519_1, 0.690_652_55),
	(154. / 509., 0.370_941_52, 0.339_855_9, 0.688_517_03),
	(155. / 509., 0.370_728_34, 0.335_181_95, 0.686_329_5),
	(156. / 509., 0.370_517_37, 0.330_497_4, 0.684_088_9),
	(157. / 509., 0.370_306_82, 0.325_802_68, 0.681_794_1),
	(158. / 509., 0.370_094_87, 0.321_098_15, 0.679_444_1),
	(159. / 509., 0.369_879_8, 0.316_384_1, 0.677_037_54),
	(160. / 509., 0.369_659_87, 0.311_660_98, 0.674_573_4),
	(161. / 509., 0.369_433_34, 0.306_929_23, 0.672_050_54),
	(162. / 509., 0.369_198_47, 0.302_189_32, 0.669_467_57),
	(163. / 509., 0.368_953_56, 0.297_441_75, 0.666_823_2),
	(164. / 509., 0.368_696_8, 0.292_687_1, 0.664_116_26),
	(165. / 509., 0.368_426_56, 0.287_925_96, 0.661_345_24),
	(166. / 509., 0.368_141_03, 0.283_159_02, 0.658_508_9),
	(167. / 509., 0.367_838_44, 0.278_386_98, 0.655_605_7),
	(168. / 509., 0.367_517_08, 0.273_610_62, 0.652_634_14),
	(169. / 509., 0.367_175_13, 0.268_830_87, 0.649_592_7),
	(170. / 509., 0.366_810_86, 0.264_048_58, 0.646_479_9),
	(171. / 509., 0.366_422_44, 0.259_264_8, 0.643_294_1),
	(172. / 509., 0.366_008_55, 0.254_480_45, 0.640_033_6),
	(173. / 509., 0.365_566_97, 0.249_696_84, 0.636_696_76),
	(174. / 509., 0.365_095_8, 0.244_915_37, 0.633_281_7),
	(175. / 509., 0.364_593_1, 0.240_137_47, 0.629_786_8),
	(176. / 509., 0.364_056_94, 0.235_364_7, 0.626_210_15),
	(177. / 509., 0.363_485_37, 0.230_598_76, 0.622_549_9),
	(178. / 509., 0.362_876_45, 0.225_841_49, 0.618_804_16),
	(179. / 509., 0.362_228_1, 0.221_094_89, 0.614_971_1),
	(180. / 509., 0.361_538_3, 0.216_361_12, 0.611_048_8),
	(181. / 509., 0.360_804_95, 0.211_642_52, 0.607_035_34),
	(182. / 509., 0.360_026_8, 0.206_941_23, 0.602_928_46),
	(183. / 509., 0.359_200_9, 0.202_260_38, 0.598_726_5),
	(184. / 509., 0.358_324_9, 0.197_602_94, 0.594_427_7),
	(185. / 509., 0.357_396_63, 0.192_972_08, 0.590_030_13),
	(186. / 509., 0.356_413_8, 0.188_371_2, 0.585_532_07),
	(187. / 509., 0.355_374_16, 0.183_803_93, 0.580_931_9),
	(188. / 509., 0.354_275_35, 0.179_274_13, 0.576_228_1),
	(189. / 509., 0.353_115_74, 0.174_785_7, 0.571_418_7),
	(190. / 509., 0.351_892_47, 0.170_343_2, 0.566_502_87),
	(191. / 509., 0.350_603_04, 0.165_951_3, 0.561_479_6),
	(192. / 509., 0.349_245_13, 0.161_614_78, 0.556_348_4),
	(193. / 509., 0.347_816_53, 0.157_338_63, 0.551_108_54),
	(194. / 509., 0.346_315_1, 0.153_128_03, 0.545_76),
	(195. / 509., 0.344_739_02, 0.148_988_2, 0.540_302_46),
	(196. / 509., 0.343_086, 0.144_924_66, 0.534_737_05),
	(197. / 509., 0.341_354_1, 0.140_942_8, 0.529_065),
	(198. / 509., 0.339_541_67, 0.137_048_02, 0.523_287_95),
	(199. / 509., 0.337_647_32, 0.133_245_62, 0.517_408_1),
	(200. / 509., 0.335_669_8, 0.129_540_74, 0.511_428_06),
	(201. / 509., 0.333_608_06, 0.125_938_18, 0.505_351_66),
	(202. / 509., 0.331_461_55, 0.122_442_454, 0.499_182_76),
	(203. / 509., 0.329_230_04, 0.119_057_64, 0.492_925_94),
	(204. / 509., 0.326_913_7, 0.115_787_35, 0.486_586_45),
	(205. / 509., 0.324_513_08, 0.112_634_6, 0.480_170_07),
	(206. / 509., 0.322_028_82, 0.109_601_14, 0.473_684_94),
	(207. / 509., 0.319_462_63, 0.106_688_8, 0.467_137_28),
	(208. / 509., 0.316_816_48, 0.103_898_615, 0.460_534_16),
	(209. / 509., 0.314_092_8, 0.101_230_78, 0.453_883_35),
	(210. / 509., 0.311_294_35, 0.098_684_77, 0.447_193_15),
	(211. / 509., 0.308_424_44, 0.096_259_385, 0.440_471_95),
	(212. / 509., 0.305_486_77, 0.093_952_77, 0.433_728_5),
	(213. / 509., 0.302_485_38, 0.091_761_19, 0.426_974_03),
	(214. / 509., 0.299_424_83, 0.089_682_25, 0.420_216_2),
	(215. / 509., 0.296_31, 0.087_713_25, 0.413_462_58),
	(216. / 509., 0.293_145_92, 0.085_850_656, 0.406_721_77),
	(217. / 509., 0.289_937_9, 0.084_090_79, 0.400_002_15),
	(218. / 509., 0.286_691_52, 0.082_429_87, 0.393_311_83),
	(219. / 509., 0.283_412_4, 0.080_864_154, 0.386_658_7),
	(220. / 509., 0.280_106_4, 0.079_39, 0.380_050_27),
	(221. / 509., 0.276_779_38, 0.078_003_94, 0.373_493_82),
	(222. / 509., 0.273_437_38, 0.076_702_8, 0.366_996_17),
	(223. / 509., 0.270_086_38, 0.075_483_67, 0.360_563_76),
	(224. / 509., 0.266_732_34, 0.074_344_02, 0.354_202_75),
	(225. / 509., 0.263_381_2, 0.073_281_66, 0.347_918_9),
	(226. / 509., 0.260_038_94, 0.072_294_78, 0.341_717_57),
	(227. / 509., 0.256_711_93, 0.071_380_11, 0.335_606_5),
	(228. / 509., 0.253_406_85, 0.070_533_58, 0.329_594_58),
	(229. / 509., 0.250_128_45, 0.069_758_21, 0.323_681),
	(230. / 509., 0.246_882_26, 0.069_053_64, 0.317_869_93),
	(231. / 509., 0.243_673_73, 0.068_419_86, 0.312_165_23),
	(232. / 509., 0.240_508_14, 0.067_857_1, 0.306_570_56),
	(233. / 509., 0.237_390_62, 0.067_365_885, 0.301_089_23),
	(234. / 509., 0.234_330_55, 0.066_935_6, 0.295_740_1),
	(235. / 509., 0.231_329_55, 0.066_576_19, 0.290_513_6),
	(236. / 509., 0.228_391_77, 0.066_289_976, 0.285_410_73),
	(237. / 509., 0.225_521_64, 0.066_078_17, 0.280_433_98),
	(238. / 509., 0.222_727_06, 0.065_933_794, 0.275_597_16),
	(239. / 509., 0.220_012_52, 0.065_857_92, 0.270_902_8),
	(240. / 509., 0.217_378_45, 0.065_859_66, 0.266_342_1),
	(241. / 509., 0.214_828_43, 0.065_940_39, 0.261_916_76),
	(242. / 509., 0.212_374_1, 0.066_085_026, 0.257_651_66),
	(243. / 509., 0.210_012_14, 0.066_308_57, 0.253_528_9),
	(244. / 509., 0.207_744_24, 0.066_614_53, 0.249_546_44),
	(245. / 509., 0.205_580_52, 0.066_990_465, 0.245_724_98),
	(246. / 509., 0.203_520_07, 0.067_444_18, 0.242_055_76),
	(247. / 509., 0.201_561_33, 0.067_983_27, 0.238_529_74),
	(248. / 509., 0.199_715_72, 0.068_592_71, 0.235_170_95),
	(249. / 509., 0.197_948_34, 0.069_314_06, 0.231_946_47),
	(250. / 509., 0.196_082_6, 0.070_321_225, 0.228_746_73),
	(251. / 509., 0.194_103_51, 0.071_608_305, 0.225_587_28),
	(252. / 509., 0.191_994_49, 0.073_182_83, 0.222_433_85),
	(253. / 509., 0.189_758_54, 0.075_019_86, 0.219_300_51),
	(254. / 509., 0.187_392_28, 0.077_102_095, 0.216_188_76),
	(255. / 509., 0.184_880_36, 0.079_425_73, 0.213_076_52),
	(256. / 509., 0.187_744_83, 0.077_251_59, 0.213_874_49),
	(257. / 509., 0.190_495_79, 0.075_311_28, 0.214_656_23),
	(258. / 509., 0.193_154_86, 0.073_606_82, 0.215_423_63),
	(259. / 509., 0.195_718_54, 0.072_157_78, 0.216_174_99),
	(260. / 509., 0.198_193_43, 0.070_974_626, 0.216_909_75),
	(261. / 509., 0.200_587_6, 0.070_064_574, 0.217_627_21),
	(262. / 509., 0.202_903_66, 0.069_435_25, 0.218_331_68),
	(263. / 509., 0.205_317_26, 0.068_919_59, 0.219_115_17),
	(264. / 509., 0.207_857_04, 0.068_484_396, 0.220_001_34),
	(265. / 509., 0.210_528_84, 0.068_121_955, 0.220_987_59),
	(266. / 509., 0.213_331_39, 0.067_830_145, 0.222_070_43),
	(267. / 509., 0.216_252_8, 0.067_616_33, 0.223_245_68),
	(268. / 509., 0.219_305_04, 0.067_465_79, 0.224_510_24),
	(269. / 509., 0.222_473_08, 0.067_388_214, 0.225_859_6),
	(270. / 509., 0.225_753_96, 0.067_382_134, 0.227_289_84),
	(271. / 509., 0.229_156_2, 0.067_434_73, 0.228_796_81),
	(272. / 509., 0.232_663, 0.067_557_104, 0.230_376_17),
	(273. / 509., 0.236_274_96, 0.067_743_6, 0.232_023_61),
	(274. / 509., 0.239_995_87, 0.067_985_03, 0.233_734_34),
	(275. / 509., 0.243_811_5, 0.068_289_85, 0.235_504_27),
	(276. / 509., 0.247_720_93, 0.068_653_34, 0.237_328_8),
	(277. / 509., 0.251_729, 0.069_064_63, 0.239_202_6),
	(278. / 509., 0.255_821_35, 0.069_532_31, 0.241_121_9),
	(279. / 509., 0.259_994_63, 0.070_053_85, 0.243_082_2),
	(280. / 509., 0.264_255_14, 0.070_616_595, 0.245_077_6),
	(281. / 509., 0.268_590_96, 0.071_226_716, 0.247_104_44),
	(282. / 509., 0.272_997_02, 0.071_883_55, 0.249_158_47),
	(283. / 509., 0.277_471_5, 0.072_582_97, 0.251_234_95),
	(284. / 509., 0.282_017_47, 0.073_315_695, 0.253_328),
	(285. / 509., 0.286_623_1, 0.074_088_46, 0.255_434_78),
	(286. / 509., 0.291_285_16, 0.074_899_05, 0.257_551),
	(287. / 509., 0.296_000_48, 0.075_745_34, 0.259_672_46),
	(288. / 509., 0.300_772_76, 0.076_617_82, 0.261_792_93),
	(289. / 509., 0.305_592_27, 0.077_521_965, 0.263_910_06),
	(290. / 509., 0.310_455_2, 0.078_456_87, 0.266_020_06),
	(291. / 509., 0.315_358_7, 0.079_421, 0.268_119_04),
	(292. / 509., 0.320_299_86, 0.080_412_99, 0.270_203_23),
	(293. / 509., 0.325_278_88, 0.081_428_39, 0.272_267_73),
	(294. / 509., 0.330_291_75, 0.082_467_63, 0.274_309_3),
	(295. / 509., 0.335_333_53, 0.083_532_44, 0.276_325_35),
	(296. / 509., 0.340_401_65, 0.084_622_234, 0.278_312_53),
	(297. / 509., 0.345_493_56, 0.085_736_655, 0.280_267_7),
	(298. / 509., 0.350_606_77, 0.086_875_55, 0.282_187_7),
	(299. / 509., 0.355_738_9, 0.088_038_97, 0.284_069_6),
	(300. / 509., 0.360_887_53, 0.089_227_19, 0.285_910_52),
	(301. / 509., 0.366_050_3, 0.090_440_68, 0.287_707_75),
	(302. / 509., 0.371_225_1, 0.091_68, 0.289_458_66),
	(303. / 509., 0.376_410_3, 0.092_945_196, 0.291_160_26),
	(304. / 509., 0.381_602_47, 0.094_238_73, 0.292_811_07),
	(305. / 509., 0.386_799_4, 0.095_561_82, 0.294_409),
	(306. / 509., 0.391_998_9, 0.096_915_83, 0.295_952_1),
	(307. / 509., 0.397_198_77, 0.098_302_32, 0.297_438_56),
	(308. / 509., 0.402_396_92, 0.099_722_93, 0.298_866_75),
	(309. / 509., 0.407_591_2, 0.101_179_46, 0.300_235_18),
	(310. / 509., 0.412_779_87, 0.102_673_404, 0.301_542_25),
	(311. / 509., 0.417_961_06, 0.104_206_45, 0.302_786_53),
	(312. / 509., 0.423_132_15, 0.105_781_21, 0.303_967_6),
	(313. / 509., 0.428_291_02, 0.107_399_78, 0.305_084_8),
	(314. / 509., 0.433_435_6, 0.109_064_24, 0.306_137_68),
	(315. / 509., 0.438_563_8, 0.110_776_68, 0.307_126_02),
	(316. / 509., 0.443_673_58, 0.112_539_13, 0.308_049_74),
	(317. / 509., 0.448_762_98, 0.114_353_55, 0.308_909_06),
	(318. / 509., 0.453_830_06, 0.116_221_84, 0.309_704_42),
	(319. / 509., 0.458_872_88, 0.118_145_71, 0.310_436_37),
	(320. / 509., 0.463_891_03, 0.120_125_614, 0.311_103_43),
	(321. / 509., 0.468_881_1, 0.122_164_46, 0.311_709_1),
	(322. / 509., 0.473_841_43, 0.124_263_54, 0.312_254_7),
	(323. / 509., 0.478_770_35, 0.126_424_01, 0.312_741_73),
	(324. / 509., 0.483_666_3, 0.128_646_79, 0.313_171_9),
	(325. / 509., 0.488_528_46, 0.130_932_11, 0.313_545_53),
	(326. / 509., 0.493_355_04, 0.133_280_92, 0.313_865_63),
	(327. / 509., 0.498_144_36, 0.135_693_8, 0.314_135_2),
	(328. / 509., 0.502_895_24, 0.138_170_87, 0.314_356_63),
	(329. / 509., 0.507_606_8, 0.140_711_93, 0.314_532),
	(330. / 509., 0.512_278_4, 0.143_316_57, 0.314_663_08),
	(331. / 509., 0.516_908_47, 0.145_984_63, 0.314_754_07),
	(332. / 509., 0.521_496_53, 0.148_715_45, 0.314_807_68),
	(333. / 509., 0.526_041_9, 0.151_508_18, 0.314_826_55),
	(334. / 509., 0.530_544_2, 0.154_361_83, 0.314_813),
	(335. / 509., 0.535_002_77, 0.157_275_41, 0.314_770_85),
	(336. / 509., 0.539_417_4, 0.160_247_7, 0.314_702_96),
	(337. / 509., 0.543_787_7, 0.163_277_39, 0.314_612_03),
	(338. / 509., 0.548_113_7, 0.166_363_09, 0.314_501_02),
	(339. / 509., 0.552_395_2, 0.169_503_39, 0.314_372_93),
	(340. / 509., 0.556_632_3, 0.172_696_77, 0.314_230_44),
	(341. / 509., 0.560_825, 0.175_941_7, 0.314_076_4),
	(342. / 509., 0.564_973_4, 0.179_236_65, 0.313_913_6),
	(343. / 509., 0.569_077_85, 0.182_580_04, 0.313_744_4),
	(344. / 509., 0.573_138_5, 0.185_970_37, 0.313_571_27),
	(345. / 509., 0.577_155_53, 0.189_406_01, 0.313_397_05),
	(346. / 509., 0.581_129_3, 0.192_885_49, 0.313_224),
	(347. / 509., 0.585_060_24, 0.196_407_38, 0.313_054_03),
	(348. / 509., 0.588_948_6, 0.199_970_22, 0.312_889_22),
	(349. / 509., 0.592_794_8, 0.203_572_51, 0.312_732_34),
	(350. / 509., 0.596_599_16, 0.207_212_95, 0.312_585_23),
	(351. / 509., 0.600_362_1, 0.210_890_31, 0.312_449_34),
	(352. / 509., 0.604_084, 0.214_603_32, 0.312_326_52),
	(353. / 509., 0.607_765_26, 0.218_350_71, 0.312_219_02),
	(354. / 509., 0.611_406_2, 0.222_131_25, 0.312_128_8),
	(355. / 509., 0.615_007_2, 0.225_944_03, 0.312_056_8),
	(356. / 509., 0.618_568_66, 0.229_787_99, 0.312_004_63),
	(357. / 509., 0.622_090_8, 0.233_662_19, 0.311_973_84),
	(358. / 509., 0.625_574_2, 0.237_565_35, 0.311_967),
	(359. / 509., 0.629_018_9, 0.241_496_89, 0.311_984_48),
	(360. / 509., 0.632_425_37, 0.245_456, 0.312_027_66),
	(361. / 509., 0.635_793_7, 0.249_441_86, 0.312_097_94),
	(362. / 509., 0.639_124_33, 0.253_453_64, 0.312_196_9),
	(363. / 509., 0.642_417_55, 0.257_490_52, 0.312_326_3),
	(364. / 509., 0.645_673_5, 0.261_552_04, 0.312_486_74),
	(365. / 509., 0.648_892_3, 0.265_637_55, 0.312_679_4),
	(366. / 509., 0.652_074_16, 0.269_746_5, 0.312_905_6),
	(367. / 509., 0.655_219_3, 0.273_878_28, 0.313_166_68),
	(368. / 509., 0.658_328_06, 0.278_032_12, 0.313_464_34),
	(369. / 509., 0.661_400_4, 0.282_207_8, 0.313_799_14),
	(370. / 509., 0.664_436_34, 0.286_404_85, 0.314_172_24),
	(371. / 509., 0.667_436_06, 0.290_622_8, 0.314_584_85),
	(372. / 509., 0.670_399_6, 0.294_861_26, 0.315_038_14),
	(373. / 509., 0.673_327_27, 0.299_119_62, 0.315_533_73),
	(374. / 509., 0.676_219, 0.303_397_63, 0.316_072_5),
	(375. / 509., 0.679_074_76, 0.307_694_97, 0.316_655_46),
	(376. / 509., 0.681_894_6, 0.312_011_33, 0.317_283_8),
	(377. / 509., 0.684_678_5, 0.316_346_35, 0.317_958_7),
	(378. / 509., 0.687_426_57, 0.320_699_7, 0.318_681_4),
	(379. / 509., 0.690_138_94, 0.325_070_92, 0.319_453_33),
	(380. / 509., 0.692_815_4, 0.329_459_85, 0.320_275_43),
	(381. / 509., 0.695_456_1, 0.333_866_2, 0.321_148_84),
	(382. / 509., 0.698_060_8, 0.338_289_77, 0.322_074_8),
	(383. / 509., 0.700_629_65, 0.342_730_2, 0.323_054_5),
	(384. / 509., 0.703_162_5, 0.347_187_25, 0.324_089_14),
	(385. / 509., 0.705_659_5, 0.351_660_52, 0.325_180_14),
	(386. / 509., 0.708_120_6, 0.356_149_85, 0.326_328_6),
	(387. / 509., 0.710_545_66, 0.360_655, 0.327_535_75),
	(388. / 509., 0.712_934_7, 0.365_175_7, 0.328_802_73),
	(389. / 509., 0.715_287_6, 0.369_711_7, 0.330_130_88),
	(390. / 509., 0.717_604_46, 0.374_262_72, 0.331_521_4),
	(391. / 509., 0.719_885_23, 0.378_828_5, 0.332_975_57),
	(392. / 509., 0.722_13, 0.383_408_64, 0.334_494_7),
	(393. / 509., 0.724_338_65, 0.388_003_02, 0.336_079_96),
	(394. / 509., 0.726_511_24, 0.392_611_32, 0.337_732_58),
	(395. / 509., 0.728_647_7, 0.397_233_25, 0.339_453_85),
	(396. / 509., 0.730_748_24, 0.401_868_52, 0.341_244_97),
	(397. / 509., 0.732_812_7, 0.406_516_85, 0.343_107_16),
	(398. / 509., 0.734_841_35, 0.411_177_87, 0.345_041_7),
	(399. / 509., 0.736_834_2, 0.415_851_27, 0.347_049_77),
	(400. / 509., 0.738_791_4, 0.420_536_73, 0.349_132_6),
	(401. / 509., 0.740_713, 0.425_233_93, 0.351_291_3),
	(402. / 509., 0.742_599_2, 0.429_942_55, 0.353_527_1),
	(403. / 509., 0.744_450_2, 0.434_662_16, 0.355_841_07),
	(404. / 509., 0.746_266_2, 0.439_392_45, 0.358_234_4),
	(405. / 509., 0.748_047_4, 0.444_132_98, 0.360_708_15),
	(406. / 509., 0.749_794_2, 0.448_883_32, 0.363_263_37),
	(407. / 509., 0.751_506_87, 0.453_643_14, 0.365_901_1),
	(408. / 509., 0.753_185_7, 0.458_412, 0.368_622_36),
	(409. / 509., 0.754_831_1, 0.463_189_42, 0.371_428_04),
	(410. / 509., 0.756_443_44, 0.467_975_02, 0.374_319_08),
	(411. / 509., 0.758_023_26, 0.472_768_28, 0.377_296_36),
	(412. / 509., 0.759_571_14, 0.477_568_72, 0.380_360_66),
	(413. / 509., 0.761_087_66, 0.482_375_8, 0.383_512_77),
	(414. / 509., 0.762_573_36, 0.487_189_05, 0.386_753_35),
	(415. / 509., 0.764_028_85, 0.492_008_03, 0.390_083_07),
	(416. / 509., 0.765_454_95, 0.496_832_13, 0.393_502_53),
	(417. / 509., 0.766_852_3, 0.501_660_8, 0.397_012_2),
	(418. / 509., 0.768_221_8, 0.506_493_6, 0.400_612_56),
	(419. / 509., 0.769_564_2, 0.511_329_9, 0.404_303_97),
	(420. / 509., 0.770_880_94, 0.516_168_95, 0.408_086_7),
	(421. / 509., 0.772_172_6, 0.521_010_3, 0.411_960_9),
	(422. / 509., 0.773_440_24, 0.525_853_34, 0.415_926_78),
	(423. / 509., 0.774_684_97, 0.530_697_46, 0.419_984_4),
	(424. / 509., 0.775_907_93, 0.535_542_2, 0.424_133_7),
	(425. / 509., 0.777_110_34, 0.540_386_74, 0.428_374_5),
	(426. / 509., 0.778_293_43, 0.545_230_57, 0.432_706_65),
	(427. / 509., 0.779_458_64, 0.550_073_1, 0.437_129_8),
	(428. / 509., 0.780_607_76, 0.554_913_34, 0.441_643_33),
	(429. / 509., 0.781_741_8, 0.559_751, 0.446_246_86),
	(430. / 509., 0.782_862_25, 0.564_585_3, 0.450_939_86),
	(431. / 509., 0.783_970_6, 0.569_415_8, 0.455_721_56),
	(432. / 509., 0.785_068_45, 0.574_241_7, 0.460_591_17),
	(433. / 509., 0.786_157_37, 0.579_062_46, 0.465_547_77),
	(434. / 509., 0.787_239, 0.583_877_44, 0.470_590_38),
	(435. / 509., 0.788_315_1, 0.588_686, 0.475_717_93),
	(436. / 509., 0.789_387_4, 0.593_487_56, 0.480_929_14),
	(437. / 509., 0.790_457_8, 0.598_281_3, 0.486_222_57),
	(438. / 509., 0.791_528_34, 0.603_066_7, 0.491_596_67),
	(439. / 509., 0.792_600_33, 0.607_843_2, 0.497_050_2),
	(440. / 509., 0.793_675_6, 0.612_610_3, 0.502_581_6),
	(441. / 509., 0.794_755_9, 0.617_367_3, 0.508_189_2),
	(442. / 509., 0.795_842_95, 0.622_113_76, 0.513_871_25),
	(443. / 509., 0.796_938_54, 0.626_849_06, 0.519_625_84),
	(444. / 509., 0.798_044_5, 0.631_572_6, 0.525_451_06),
	(445. / 509., 0.799_162_45, 0.636_283_8, 0.531_344_95),
	(446. / 509., 0.800_294_16, 0.640_982_15, 0.537_305_36),
	(447. / 509., 0.801_441_25, 0.645_667, 0.543_330_1),
	(448. / 509., 0.802_605_33, 0.650_337_93, 0.549_416_9),
	(449. / 509., 0.803_787_95, 0.654_994_25, 0.555_563_5),
	(450. / 509., 0.804_990_53, 0.659_635_4, 0.561_767_46),
	(451. / 509., 0.806_214_63, 0.664_260_9, 0.568_026_3),
	(452. / 509., 0.807_461_4, 0.668_870_03, 0.574_337_5),
	(453. / 509., 0.808_732_2, 0.673_462_15, 0.580_698_4),
	(454. / 509., 0.810_028_1, 0.678_036_75, 0.587_106_3),
	(455. / 509., 0.811_350_17, 0.682_593, 0.593_558_5),
	(456. / 509., 0.812_699_2, 0.687_130_33, 0.600_052_2),
	(457. / 509., 0.814_076_1, 0.691_647_95, 0.606_584_37),
	(458. / 509., 0.815_481_5, 0.696_145_06, 0.613_152_2),
	(459. / 509., 0.816_915_75, 0.700_620_83, 0.619_752_6),
	(460. / 509., 0.818_379_3, 0.705_074_37, 0.626_382_47),
	(461. / 509., 0.819_872_3, 0.709_504_7, 0.633_038_6),
	(462. / 509., 0.821_394_74, 0.713_910_94, 0.639_717_64),
	(463. / 509., 0.822_946_37, 0.718_291_76, 0.646_416_4),
	(464. / 509., 0.824_526_8, 0.722_646_1, 0.653_131_37),
	(465. / 509., 0.826_135_5, 0.726_972_76, 0.659_859),
	(466. / 509., 0.827_771_6, 0.731_270_25, 0.666_595_7),
	(467. / 509., 0.829_434_1, 0.735_537_1, 0.673_337_7),
	(468. / 509., 0.831_121_6, 0.739_771_84, 0.680_081_25),
	(469. / 509., 0.832_832_75, 0.743_972_7, 0.686_822_35),
	(470. / 509., 0.834_565_7, 0.748_137_95, 0.693_556_96),
	(471. / 509., 0.836_318_97, 0.752_265_5, 0.700_28),
	(472. / 509., 0.838_091_25, 0.756_353_14, 0.706_985_6),
	(473. / 509., 0.839_878_4, 0.760_399_04, 0.713_671_5),
	(474. / 509., 0.841_677_5, 0.764_401, 0.720_333),
	(475. / 509., 0.843_485_3, 0.768_356_6, 0.726_965_37),
	(476. / 509., 0.845_298_1, 0.772_263_4, 0.733_563_66),
	(477. / 509., 0.847_111_94, 0.776_118_8, 0.740_122_74),
	(478. / 509., 0.848_922_43, 0.779_920_2, 0.746_637_17),
	(479. / 509., 0.850_726_96, 0.783_664_6, 0.753_097_5),
	(480. / 509., 0.852_519_1, 0.787_349_34, 0.759_499_43),
	(481. / 509., 0.854_292_2, 0.790_972, 0.765_838),
	(482. / 509., 0.856_040_24, 0.794_529_6, 0.772_106_1),
	(483. / 509., 0.857_756_6, 0.798_019_65, 0.778_295_7),
	(484. / 509., 0.859_434_66, 0.801_439_2, 0.784_397_9),
	(485. / 509., 0.861_071_17, 0.804_785_2, 0.790_395_3),
	(486. / 509., 0.862_656, 0.808_055_2, 0.796_282_65),
	(487. / 509., 0.864_183_4, 0.811_246_45, 0.802_046_1),
	(488. / 509., 0.865_649_34, 0.814_355_43, 0.807_669_7),
	(489. / 509., 0.867_053_15, 0.817_378_04, 0.813_134_2),
	(490. / 509., 0.868_399_56, 0.820_308_74, 0.818_416_4),
	(491. / 509., 0.869_691_3, 0.823_141_6, 0.823_504_75),
	(492. / 509., 0.870_938_5, 0.825_868_6, 0.828_385),
	(493. / 509., 0.872_153_34, 0.828_480_54, 0.833_048_64),
	(494. / 509., 0.873_351_7, 0.830_967_1, 0.837_488_53),
	(495. / 509., 0.874_537_94, 0.833_319_7, 0.841_719_27),
	(496. / 509., 0.875_714_6, 0.835_530_2, 0.845_755_4),
	(497. / 509., 0.876_878_5, 0.837_592_36, 0.849_613_7),
	(498. / 509., 0.878_022_97, 0.839_501_7, 0.853_306_5),
	(499. / 509., 0.879_132_45, 0.841_255_55, 0.856_855_75),
	(500. / 509., 0.880_192_94, 0.842_852_23, 0.860_274),
	(501. / 509., 0.881_191_7, 0.844_290_7, 0.863_566),
	(502. / 509., 0.882_115_4, 0.845_570_1, 0.866_737_66),
	(503. / 509., 0.882_951_7, 0.846_689_7, 0.869_796_16),
	(504. / 509., 0.883_691_25, 0.847_648_9, 0.872_741_46),
	(505. / 509., 0.884_327_1, 0.848_447_44, 0.875_567_85),
	(506. / 509., 0.884_851_4, 0.849_084_26, 0.878_282_37),
	(507. / 509., 0.885_259, 0.849_558_95, 0.880_884_2),
	(508. / 509., 0.885_547_16, 0.849_871_75, 0.883_362_05),
	(1., 0.885_711_55, 0.850_021_84, 0.885_725_4),
]);

pub const TWILIGHT_SHIFTED: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 509., 0.187_392_28, 0.077_102_095, 0.216_188_76),
	(1. / 509., 0.189_758_54, 0.075_019_86, 0.219_300_51),
	(2. / 509., 0.191_994_49, 0.073_182_83, 0.222_433_85),
	(3. / 509., 0.194_103_51, 0.071_608_305, 0.225_587_28),
	(4. / 509., 0.196_082_6, 0.070_321_225, 0.228_746_73),
	(5. / 509., 0.197_948_34, 0.069_314_06, 0.231_946_47),
	(6. / 509., 0.199_715_72, 0.068_592_71, 0.235_170_95),
	(7. / 509., 0.201_561_33, 0.067_983_27, 0.238_529_74),
	(8. / 509., 0.203_520_07, 0.067_444_18, 0.242_055_76),
	(9. / 509., 0.205_580_52, 0.066_990_465, 0.245_724_98),
	(10. / 509., 0.207_744_24, 0.066_614_53, 0.249_546_44),
	(11. / 509., 0.210_012_14, 0.066_308_57, 0.253_528_9),
	(12. / 509., 0.212_374_1, 0.066_085_026, 0.257_651_66),
	(13. / 509., 0.214_828_43, 0.065_940_39, 0.261_916_76),
	(14. / 509., 0.217_378_45, 0.065_859_66, 0.266_342_1),
	(15. / 509., 0.220_012_52, 0.065_857_92, 0.270_902_8),
	(16. / 509., 0.222_727_06, 0.065_933_794, 0.275_597_16),
	(17. / 509., 0.225_521_64, 0.066_078_17, 0.280_433_98),
	(18. / 509., 0.228_391_77, 0.066_289_976, 0.285_410_73),
	(19. / 509., 0.231_329_55, 0.066_576_19, 0.290_513_6),
	(20. / 509., 0.234_330_55, 0.066_935_6, 0.295_740_1),
	(21. / 509., 0.237_390_62, 0.067_365_885, 0.301_089_23),
	(22. / 509., 0.240_508_14, 0.067_857_1, 0.306_570_56),
	(23. / 509., 0.243_673_73, 0.068_419_86, 0.312_165_23),
	(24. / 509., 0.246_882_26, 0.069_053_64, 0.317_869_93),
	(25. / 509., 0.250_128_45, 0.069_758_21, 0.323_681),
	(26. / 509., 0.253_406_85, 0.070_533_58, 0.329_594_58),
	(27. / 509., 0.256_711_93, 0.071_380_11, 0.335_606_5),
	(28. / 509., 0.260_038_94, 0.072_294_78, 0.341_717_57),
	(29. / 509., 0.263_381_2, 0.073_281_66, 0.347_918_9),
	(30. / 509., 0.266_732_34, 0.074_344_02, 0.354_202_75),
	(31. / 509., 0.270_086_38, 0.075_483_67, 0.360_563_76),
	(32. / 509., 0.273_437_38, 0.076_702_8, 0.366_996_17),
	(33. / 509., 0.276_779_38, 0.078_003_94, 0.373_493_82),
	(34. / 509., 0.280_106_4, 0.079_39, 0.380_050_27),
	(35. / 509., 0.283_412_4, 0.080_864_154, 0.386_658_7),
	(36. / 509., 0.286_691_52, 0.082_429_87, 0.393_311_83),
	(37. / 509., 0.289_937_9, 0.084_090_79, 0.400_002_15),
	(38. / 509., 0.293_145_92, 0.085_850_656, 0.406_721_77),
	(39. / 509., 0.296_31, 0.087_713_25, 0.413_462_58),
	(40. / 509., 0.299_424_83, 0.089_682_25, 0.420_216_2),
	(41. / 509., 0.302_485_38, 0.091_761_19, 0.426_974_03),
	(42. / 509., 0.305_486_77, 0.093_952_77, 0.433_728_5),
	(43. / 509., 0.308_424_44, 0.096_259_385, 0.440_471_95),
	(44. / 509., 0.311_294_35, 0.098_684_77, 0.447_193_15),
	(45. / 509., 0.314_092_8, 0.101_230_78, 0.453_883_35),
	(46. / 509., 0.316_816_48, 0.103_898_615, 0.460_534_16),
	(47. / 509., 0.319_462_63, 0.106_688_8, 0.467_137_28),
	(48. / 509., 0.322_028_82, 0.109_601_14, 0.473_684_94),
	(49. / 509., 0.324_513_08, 0.112_634_6, 0.480_170_07),
	(50. / 509., 0.326_913_7, 0.115_787_35, 0.486_586_45),
	(51. / 509., 0.329_230_04, 0.119_057_64, 0.492_925_94),
	(52. / 509., 0.331_461_55, 0.122_442_454, 0.499_182_76),
	(53. / 509., 0.333_608_06, 0.125_938_18, 0.505_351_66),
	(54. / 509., 0.335_669_8, 0.129_540_74, 0.511_428_06),
	(55. / 509., 0.337_647_32, 0.133_245_62, 0.517_408_1),
	(56. / 509., 0.339_541_67, 0.137_048_02, 0.523_287_95),
	(57. / 509., 0.341_354_1, 0.140_942_8, 0.529_065),
	(58. / 509., 0.343_086, 0.144_924_66, 0.534_737_05),
	(59. / 509., 0.344_739_02, 0.148_988_2, 0.540_302_46),
	(60. / 509., 0.346_315_1, 0.153_128_03, 0.545_76),
	(61. / 509., 0.347_816_53, 0.157_338_63, 0.551_108_54),
	(62. / 509., 0.349_245_13, 0.161_614_78, 0.556_348_4),
	(63. / 509., 0.350_603_04, 0.165_951_3, 0.561_479_6),
	(64. / 509., 0.351_892_47, 0.170_343_2, 0.566_502_87),
	(65. / 509., 0.353_115_74, 0.174_785_7, 0.571_418_7),
	(66. / 509., 0.354_275_35, 0.179_274_13, 0.576_228_1),
	(67. / 509., 0.355_374_16, 0.183_803_93, 0.580_931_9),
	(68. / 509., 0.356_413_8, 0.188_371_2, 0.585_532_07),
	(69. / 509., 0.357_396_63, 0.192_972_08, 0.590_030_13),
	(70. / 509., 0.358_324_9, 0.197_602_94, 0.594_427_7),
	(71. / 509., 0.359_200_9, 0.202_260_38, 0.598_726_5),
	(72. / 509., 0.360_026_8, 0.206_941_23, 0.602_928_46),
	(73. / 509., 0.360_804_95, 0.211_642_52, 0.607_035_34),
	(74. / 509., 0.361_538_3, 0.216_361_12, 0.611_048_8),
	(75. / 509., 0.362_228_1, 0.221_094_89, 0.614_971_1),
	(76. / 509., 0.362_876_45, 0.225_841_49, 0.618_804_16),
	(77. / 509., 0.363_485_37, 0.230_598_76, 0.622_549_9),
	(78. / 509., 0.364_056_94, 0.235_364_7, 0.626_210_15),
	(79. / 509., 0.364_593_1, 0.240_137_47, 0.629_786_8),
	(80. / 509., 0.365_095_8, 0.244_915_37, 0.633_281_7),
	(81. / 509., 0.365_566_97, 0.249_696_84, 0.636_696_76),
	(82. / 509., 0.366_008_55, 0.254_480_45, 0.640_033_6),
	(83. / 509., 0.366_422_44, 0.259_264_8, 0.643_294_1),
	(84. / 509., 0.366_810_86, 0.264_048_58, 0.646_479_9),
	(85. / 509., 0.367_175_13, 0.268_830_87, 0.649_592_7),
	(86. / 509., 0.367_517_08, 0.273_610_62, 0.652_634_14),
	(87. / 509., 0.367_838_44, 0.278_386_98, 0.655_605_7),
	(88. / 509., 0.368_141_03, 0.283_159_02, 0.658_508_9),
	(89. / 509., 0.368_426_56, 0.287_925_96, 0.661_345_24),
	(90. / 509., 0.368_696_8, 0.292_687_1, 0.664_116_26),
	(91. / 509., 0.368_953_56, 0.297_441_75, 0.666_823_2),
	(92. / 509., 0.369_198_47, 0.302_189_32, 0.669_467_57),
	(93. / 509., 0.369_433_34, 0.306_929_23, 0.672_050_54),
	(94. / 509., 0.369_659_87, 0.311_660_98, 0.674_573_4),
	(95. / 509., 0.369_879_8, 0.316_384_1, 0.677_037_54),
	(96. / 509., 0.370_094_87, 0.321_098_15, 0.679_444_1),
	(97. / 509., 0.370_306_82, 0.325_802_68, 0.681_794_1),
	(98. / 509., 0.370_517_37, 0.330_497_4, 0.684_088_9),
	(99. / 509., 0.370_728_34, 0.335_181_95, 0.686_329_5),
	(100. / 509., 0.370_941_52, 0.339_855_9, 0.688_517_03),
	(101. / 509., 0.371_158_57, 0.344_519_1, 0.690_652_55),
	(102. / 509., 0.371_381_25, 0.349_171_28, 0.692_737_04),
	(103. / 509., 0.371_611_33, 0.353_812_13, 0.694_771_5),
	(104. / 509., 0.371_850_6, 0.358_441_47, 0.696_756_96),
	(105. / 509., 0.372_100_9, 0.363_059_1, 0.698_694_35),
	(106. / 509., 0.372_363_98, 0.367_664_78, 0.700_584_65),
	(107. / 509., 0.372_641_65, 0.372_258_34, 0.702_428_76),
	(108. / 509., 0.372_935_77, 0.376_839_64, 0.704_227_57),
	(109. / 509., 0.373_248_16, 0.381_408_48, 0.705_982),
	(110. / 509., 0.373_580_63, 0.385_964_75, 0.707_693),
	(111. / 509., 0.373_934_98, 0.390_508_26, 0.709_361_3),
	(112. / 509., 0.374_313_15, 0.395_038_96, 0.710_988),
	(113. / 509., 0.374_716_85, 0.399_556_64, 0.712_573_7),
	(114. / 509., 0.375_148_03, 0.404_061_26, 0.714_119_4),
	(115. / 509., 0.375_608_47, 0.408_552_68, 0.715_625_8),
	(116. / 509., 0.376_1, 0.413_030_8, 0.717_093_94),
	(117. / 509., 0.376_624_5, 0.417_495_55, 0.718_524_6),
	(118. / 509., 0.377_183_7, 0.421_946_8, 0.719_918_43),
	(119. / 509., 0.377_779_48, 0.426_384_5, 0.721_276_4),
	(120. / 509., 0.378_413_65, 0.430_808_6, 0.722_599_3),
	(121. / 509., 0.379_087_9, 0.435_219, 0.723_888),
	(122. / 509., 0.379_804_04, 0.439_615_58, 0.725_143_25),
	(123. / 509., 0.380_563_8, 0.443_998_37, 0.726_365_86),
	(124. / 509., 0.381_368_88, 0.448_367_27, 0.727_556_7),
	(125. / 509., 0.382_220_95, 0.452_722_25, 0.728_716_55),
	(126. / 509., 0.383_121_67, 0.457_063_23, 0.729_846_24),
	(127. / 509., 0.384_072_7, 0.461_390_2, 0.730_946_66),
	(128. / 509., 0.385_075_57, 0.465_703_07, 0.732_018_53),
	(129. / 509., 0.386_131_85, 0.470_001_85, 0.733_062_8),
	(130. / 509., 0.387_243, 0.474_286_47, 0.734_080_2),
	(131. / 509., 0.388_410_54, 0.478_556_9, 0.735_071_6),
	(132. / 509., 0.389_635_8, 0.482_813_18, 0.736_037_85),
	(133. / 509., 0.390_920_16, 0.487_055_2, 0.736_979_8),
	(134. / 509., 0.392_264_96, 0.491_283, 0.737_898_23),
	(135. / 509., 0.393_671_36, 0.495_496_57, 0.738_794_1),
	(136. / 509., 0.395_140_6, 0.499_695_87, 0.739_668_2),
	(137. / 509., 0.396_673_74, 0.503_880_9, 0.740_521_4),
	(138. / 509., 0.398_271_92, 0.508_051_7, 0.741_354_5),
	(139. / 509., 0.399_936_08, 0.512_208_16, 0.742_168_4),
	(140. / 509., 0.401_667_15, 0.516_350_45, 0.742_964),
	(141. / 509., 0.403_466_02, 0.520_478_5, 0.743_742_17),
	(142. / 509., 0.405_333_43, 0.524_592_3, 0.744_503_7),
	(143. / 509., 0.407_270_2, 0.528_691_9, 0.745_249_45),
	(144. / 509., 0.409_276_9, 0.532_777_3, 0.745_980_3),
	(145. / 509., 0.411_354_15, 0.536_848_6, 0.746_697_1),
	(146. / 509., 0.413_502_45, 0.540_905_8, 0.747_400_76),
	(147. / 509., 0.415_722_34, 0.544_948_8, 0.748_092_06),
	(148. / 509., 0.418_014_14, 0.548_977_85, 0.748_771_9),
	(149. / 509., 0.420_378_24, 0.552_992_9, 0.749_441_27),
	(150. / 509., 0.422_814_85, 0.556_993_9, 0.750_100_85),
	(151. / 509., 0.425_324_23, 0.560_981_04, 0.750_751_7),
	(152. / 509., 0.427_906_5, 0.564_954_3, 0.751_394_45),
	(153. / 509., 0.430_561_78, 0.568_913_76, 0.752_030_1),
	(154. / 509., 0.433_290_1, 0.572_859_4, 0.752_659_44),
	(155. / 509., 0.436_091_4, 0.576_791_4, 0.753_283_4),
	(156. / 509., 0.438_965_65, 0.580_709_7, 0.753_902_73),
	(157. / 509., 0.441_912_7, 0.584_614_4, 0.754_518_4),
	(158. / 509., 0.444_932_46, 0.588_505_6, 0.755_131_1),
	(159. / 509., 0.448_024_72, 0.592_383_3, 0.755_741_8),
	(160. / 509., 0.451_189_2, 0.596_247_6, 0.756_351_23),
	(161. / 509., 0.454_425_63, 0.600_098_6, 0.756_960_15),
	(162. / 509., 0.457_733_78, 0.603_936_3, 0.757_569_4),
	(163. / 509., 0.461_113_27, 0.607_760_8, 0.758_179_84),
	(164. / 509., 0.464_563_76, 0.611_572_1, 0.758_792_4),
	(165. / 509., 0.468_084_9, 0.615_370_3, 0.759_407_9),
	(166. / 509., 0.471_676_3, 0.619_155_4, 0.760_027_1),
	(167. / 509., 0.475_337_54, 0.622_927_55, 0.760_650_9),
	(168. / 509., 0.479_068_16, 0.626_686_75, 0.761_28),
	(169. / 509., 0.482_867_78, 0.630_433, 0.761_915_4),
	(170. / 509., 0.486_735_97, 0.634_166_5, 0.762_557_8),
	(171. / 509., 0.490_672_26, 0.637_887_06, 0.763_208_15),
	(172. / 509., 0.494_676_17, 0.641_594_8, 0.763_867_2),
	(173. / 509., 0.498_747_35, 0.645_289_9, 0.764_535_8),
	(174. / 509., 0.502_885_34, 0.648_972_15, 0.765_214_44),
	(175. / 509., 0.507_089_7, 0.652_641_7, 0.765_904_5),
	(176. / 509., 0.511_359_93, 0.656_298_5, 0.766_606_6),
	(177. / 509., 0.515_695_6, 0.659_942_6, 0.767_321_94),
	(178. / 509., 0.520_096_3, 0.663_573_9, 0.768_051_2),
	(179. / 509., 0.524_561_5, 0.667_192_46, 0.768_795_43),
	(180. / 509., 0.529_090_9, 0.670_798_1, 0.769_555_5),
	(181. / 509., 0.533_683_9, 0.674_390_9, 0.770_332_5),
	(182. / 509., 0.538_340_15, 0.677_970_8, 0.771_127_34),
	(183. / 509., 0.543_059_35, 0.681_537_7, 0.771_940_77),
	(184. / 509., 0.547_840_95, 0.685_091_44, 0.772_773_86),
	(185. / 509., 0.552_684_5, 0.688_631_95, 0.773_627_94),
	(186. / 509., 0.557_589_4, 0.692_159_1, 0.774_504_1),
	(187. / 509., 0.562_555_13, 0.695_672_8, 0.775_403_6),
	(188. / 509., 0.567_581_2, 0.699_172_8, 0.776_327_5),
	(189. / 509., 0.572_666_9, 0.702_658_95, 0.777_277_05),
	(190. / 509., 0.577_811_66, 0.706_131_04, 0.778_253_44),
	(191. / 509., 0.583_014_85, 0.709_588_9, 0.779_257_83),
	(192. / 509., 0.588_275_8, 0.713_032_1, 0.780_291_44),
	(193. / 509., 0.593_593_36, 0.716_460_6, 0.781_355_86),
	(194. / 509., 0.598_966_6, 0.719_873_96, 0.782_452_6),
	(195. / 509., 0.604_394_3, 0.723_271_85, 0.783_583),
	(196. / 509., 0.609_875_44, 0.726_654, 0.784_748_4),
	(197. / 509., 0.615_408_5, 0.730_019_9, 0.785_950_24),
	(198. / 509., 0.620_991_95, 0.733_369_35, 0.787_189_96),
	(199. / 509., 0.626_624_05, 0.736_701_7, 0.788_469),
	(200. / 509., 0.632_302_7, 0.740_016_7, 0.789_788_9),
	(201. / 509., 0.638_025_9, 0.743_313_8, 0.791_151),
	(202. / 509., 0.643_791_1, 0.746_592_4, 0.792_556_5),
	(203. / 509., 0.649_595_74, 0.749_852, 0.794_006_76),
	(204. / 509., 0.655_436_93, 0.753_092_1, 0.795_502_7),
	(205. / 509., 0.661_311_27, 0.756_312, 0.797_045_6),
	(206. / 509., 0.667_214_8, 0.759_511_3, 0.798_636_73),
	(207. / 509., 0.673_144_2, 0.762_689_1, 0.800_276_3),
	(208. / 509., 0.679_095_57, 0.765_844_7, 0.801_964_64),
	(209. / 509., 0.685_064_44, 0.768_977_4, 0.803_702_06),
	(210. / 509., 0.691_046_4, 0.772_086_3, 0.805_488_4),
	(211. / 509., 0.697_036_56, 0.775_170_5, 0.807_323_34),
	(212. / 509., 0.703_029_75, 0.778_229_06, 0.809_206_2),
	(213. / 509., 0.709_020_8, 0.781_260_9, 0.811_135_95),
	(214. / 509., 0.715_004, 0.784_264_86, 0.813_111_2),
	(215. / 509., 0.720_972_84, 0.787_239_97, 0.815_130_7),
	(216. / 509., 0.726_921_8, 0.790_184_7, 0.817_192_2),
	(217. / 509., 0.732_845_4, 0.793_097_44, 0.819_292_6),
	(218. / 509., 0.738_737_7, 0.795_976_64, 0.821_429_25),
	(219. / 509., 0.744_592_5, 0.798_820_5, 0.823_598_7),
	(220. / 509., 0.750_403_46, 0.801_627, 0.825_797_4),
	(221. / 509., 0.756_164_43, 0.804_394_07, 0.828_021_4),
	(222. / 509., 0.761_869_1, 0.807_119_5, 0.830_266_5),
	(223. / 509., 0.767_511_07, 0.809_800_74, 0.832_528_2),
	(224. / 509., 0.773_084_16, 0.812_435_27, 0.834_801_73),
	(225. / 509., 0.778_578_94, 0.815_020_9, 0.837_083_46),
	(226. / 509., 0.783_991_04, 0.817_554_24, 0.839_367_45),
	(227. / 509., 0.789_314_45, 0.820_032_1, 0.841_648_64),
	(228. / 509., 0.794_543, 0.822_451_2, 0.843_921_84),
	(229. / 509., 0.799_670_76, 0.824_807_8, 0.846_182_1),
	(230. / 509., 0.804_691_7, 0.827_098_37, 0.848_424_5),
	(231. / 509., 0.809_6, 0.829_318_94, 0.850_644_4),
	(232. / 509., 0.814_389_8, 0.831_465_6, 0.852_837_56),
	(233. / 509., 0.819_046_56, 0.833_536_5, 0.855_002_05),
	(234. / 509., 0.823_574_3, 0.835_524_86, 0.857_131_9),
	(235. / 509., 0.827_968_96, 0.837_426, 0.859_224),
	(236. / 509., 0.832_227_05, 0.839_234_9, 0.861_275_6),
	(237. / 509., 0.836_340_3, 0.840_948, 0.863_285_3),
	(238. / 509., 0.840_304_2, 0.842_560_6, 0.865_250_9),
	(239. / 509., 0.844_126_16, 0.844_064_83, 0.867_169_74),
	(240. / 509., 0.847_807_1, 0.845_454_63, 0.869_040_37),
	(241. / 509., 0.851_337_13, 0.846_727_4, 0.870_860_8),
	(242. / 509., 0.854_725_96, 0.847_874_9, 0.872_628_3),
	(243. / 509., 0.857_982_6, 0.848_889_35, 0.874_340_4),
	(244. / 509., 0.861_102_46, 0.849_767_57, 0.875_992_4),
	(245. / 509., 0.864_089_85, 0.850_503_9, 0.877_579_3),
	(246. / 509., 0.866_960_17, 0.851_089_6, 0.879_097_64),
	(247. / 509., 0.869_704_7, 0.851_524_06, 0.880_538_8),
	(248. / 509., 0.872_331_3, 0.851_801_63, 0.881_897_03),
	(249. / 509., 0.874_853_5, 0.851_915_24, 0.883_169_3),
	(250. / 509., 0.877_248_8, 0.851_870_3, 0.884_341_2),
	(251. / 509., 0.879_541_04, 0.851_656_73, 0.885_414_36),
	(252. / 509., 0.881_722_33, 0.851_275_9, 0.886_380_55),
	(253. / 509., 0.883_785_2, 0.850_729_4, 0.887_232_24),
	(254. / 509., 0.885_750_2, 0.850_009_26, 0.887_973_67),
	(255. / 509., 0.885_711_55, 0.850_021_84, 0.885_725_4),
	(256. / 509., 0.885_547_16, 0.849_871_75, 0.883_362_05),
	(257. / 509., 0.885_259, 0.849_558_95, 0.880_884_2),
	(258. / 509., 0.884_851_4, 0.849_084_26, 0.878_282_37),
	(259. / 509., 0.884_327_1, 0.848_447_44, 0.875_567_85),
	(260. / 509., 0.883_691_25, 0.847_648_9, 0.872_741_46),
	(261. / 509., 0.882_951_7, 0.846_689_7, 0.869_796_16),
	(262. / 509., 0.882_115_4, 0.845_570_1, 0.866_737_66),
	(263. / 509., 0.881_191_7, 0.844_290_7, 0.863_566),
	(264. / 509., 0.880_192_94, 0.842_852_23, 0.860_274),
	(265. / 509., 0.879_132_45, 0.841_255_55, 0.856_855_75),
	(266. / 509., 0.878_022_97, 0.839_501_7, 0.853_306_5),
	(267. / 509., 0.876_878_5, 0.837_592_36, 0.849_613_7),
	(268. / 509., 0.875_714_6, 0.835_530_2, 0.845_755_4),
	(269. / 509., 0.874_537_94, 0.833_319_7, 0.841_719_27),
	(270. / 509., 0.873_351_7, 0.830_967_1, 0.837_488_53),
	(271. / 509., 0.872_153_34, 0.828_480_54, 0.833_048_64),
	(272. / 509., 0.870_938_5, 0.825_868_6, 0.828_385),
	(273. / 509., 0.869_691_3, 0.823_141_6, 0.823_504_75),
	(274. / 509., 0.868_399_56, 0.820_308_74, 0.818_416_4),
	(275. / 509., 0.867_053_15, 0.817_378_04, 0.813_134_2),
	(276. / 509., 0.865_649_34, 0.814_355_43, 0.807_669_7),
	(277. / 509., 0.864_183_4, 0.811_246_45, 0.802_046_1),
	(278. / 509., 0.862_656, 0.808_055_2, 0.796_282_65),
	(279. / 509., 0.861_071_17, 0.804_785_2, 0.790_395_3),
	(280. / 509., 0.859_434_66, 0.801_439_2, 0.784_397_9),
	(281. / 509., 0.857_756_6, 0.798_019_65, 0.778_295_7),
	(282. / 509., 0.856_040_24, 0.794_529_6, 0.772_106_1),
	(283. / 509., 0.854_292_2, 0.790_972, 0.765_838),
	(284. / 509., 0.852_519_1, 0.787_349_34, 0.759_499_43),
	(285. / 509., 0.850_726_96, 0.783_664_6, 0.753_097_5),
	(286. / 509., 0.848_922_43, 0.779_920_2, 0.746_637_17),
	(287. / 509., 0.847_111_94, 0.776_118_8, 0.740_122_74),
	(288. / 509., 0.845_298_1, 0.772_263_4, 0.733_563_66),
	(289. / 509., 0.843_485_3, 0.768_356_6, 0.726_965_37),
	(290. / 509., 0.841_677_5, 0.764_401, 0.720_333),
	(291. / 509., 0.839_878_4, 0.760_399_04, 0.713_671_5),
	(292. / 509., 0.838_091_25, 0.756_353_14, 0.706_985_6),
	(293. / 509., 0.836_318_97, 0.752_265_5, 0.700_28),
	(294. / 509., 0.834_565_7, 0.748_137_95, 0.693_556_96),
	(295. / 509., 0.832_832_75, 0.743_972_7, 0.686_822_35),
	(296. / 509., 0.831_121_6, 0.739_771_84, 0.680_081_25),
	(297. / 509., 0.829_434_1, 0.735_537_1, 0.673_337_7),
	(298. / 509., 0.827_771_6, 0.731_270_25, 0.666_595_7),
	(299. / 509., 0.826_135_5, 0.726_972_76, 0.659_859),
	(300. / 509., 0.824_526_8, 0.722_646_1, 0.653_131_37),
	(301. / 509., 0.822_946_37, 0.718_291_76, 0.646_416_4),
	(302. / 509., 0.821_394_74, 0.713_910_94, 0.639_717_64),
	(303. / 509., 0.819_872_3, 0.709_504_7, 0.633_038_6),
	(304. / 509., 0.818_379_3, 0.705_074_37, 0.626_382_47),
	(305. / 509., 0.816_915_75, 0.700_620_83, 0.619_752_6),
	(306. / 509., 0.815_481_5, 0.696_145_06, 0.613_152_2),
	(307. / 509., 0.814_076_1, 0.691_647_95, 0.606_584_37),
	(308. / 509., 0.812_699_2, 0.687_130_33, 0.600_052_2),
	(309. / 509., 0.811_350_17, 0.682_593, 0.593_558_5),
	(310. / 509., 0.810_028_1, 0.678_036_75, 0.587_106_3),
	(311. / 509., 0.808_732_2, 0.673_462_15, 0.580_698_4),
	(312. / 509., 0.807_461_4, 0.668_870_03, 0.574_337_5),
	(313. / 509., 0.806_214_63, 0.664_260_9, 0.568_026_3),
	(314. / 509., 0.804_990_53, 0.659_635_4, 0.561_767_46),
	(315. / 509., 0.803_787_95, 0.654_994_25, 0.555_563_5),
	(316. / 509., 0.802_605_33, 0.650_337_93, 0.549_416_9),
	(317. / 509., 0.801_441_25, 0.645_667, 0.543_330_1),
	(318. / 509., 0.800_294_16, 0.640_982_15, 0.537_305_36),
	(319. / 509., 0.799_162_45, 0.636_283_8, 0.531_344_95),
	(320. / 509., 0.798_044_5, 0.631_572_6, 0.525_451_06),
	(321. / 509., 0.796_938_54, 0.626_849_06, 0.519_625_84),
	(322. / 509., 0.795_842_95, 0.622_113_76, 0.513_871_25),
	(323. / 509., 0.794_755_9, 0.617_367_3, 0.508_189_2),
	(324. / 509., 0.793_675_6, 0.612_610_3, 0.502_581_6),
	(325. / 509., 0.792_600_33, 0.607_843_2, 0.497_050_2),
	(326. / 509., 0.791_528_34, 0.603_066_7, 0.491_596_67),
	(327. / 509., 0.790_457_8, 0.598_281_3, 0.486_222_57),
	(328. / 509., 0.789_387_4, 0.593_487_56, 0.480_929_14),
	(329. / 509., 0.788_315_1, 0.588_686, 0.475_717_93),
	(330. / 509., 0.787_239, 0.583_877_44, 0.470_590_38),
	(331. / 509., 0.786_157_37, 0.579_062_46, 0.465_547_77),
	(332. / 509., 0.785_068_45, 0.574_241_7, 0.460_591_17),
	(333. / 509., 0.783_970_6, 0.569_415_8, 0.455_721_56),
	(334. / 509., 0.782_862_25, 0.564_585_3, 0.450_939_86),
	(335. / 509., 0.781_741_8, 0.559_751, 0.446_246_86),
	(336. / 509., 0.780_607_76, 0.554_913_34, 0.441_643_33),
	(337. / 509., 0.779_458_64, 0.550_073_1, 0.437_129_8),
	(338. / 509., 0.778_293_43, 0.545_230_57, 0.432_706_65),
	(339. / 509., 0.777_110_34, 0.540_386_74, 0.428_374_5),
	(340. / 509., 0.775_907_93, 0.535_542_2, 0.424_133_7),
	(341. / 509., 0.774_684_97, 0.530_697_46, 0.419_984_4),
	(342. / 509., 0.773_440_24, 0.525_853_34, 0.415_926_78),
	(343. / 509., 0.772_172_6, 0.521_010_3, 0.411_960_9),
	(344. / 509., 0.770_880_94, 0.516_168_95, 0.408_086_7),
	(345. / 509., 0.769_564_2, 0.511_329_9, 0.404_303_97),
	(346. / 509., 0.768_221_8, 0.506_493_6, 0.400_612_56),
	(347. / 509., 0.766_852_3, 0.501_660_8, 0.397_012_2),
	(348. / 509., 0.765_454_95, 0.496_832_13, 0.393_502_53),
	(349. / 509., 0.764_028_85, 0.492_008_03, 0.390_083_07),
	(350. / 509., 0.762_573_36, 0.487_189_05, 0.386_753_35),
	(351. / 509., 0.761_087_66, 0.482_375_8, 0.383_512_77),
	(352. / 509., 0.759_571_14, 0.477_568_72, 0.380_360_66),
	(353. / 509., 0.758_023_26, 0.472_768_28, 0.377_296_36),
	(354. / 509., 0.756_443_44, 0.467_975_02, 0.374_319_08),
	(355. / 509., 0.754_831_1, 0.463_189_42, 0.371_428_04),
	(356. / 509., 0.753_185_7, 0.458_412, 0.368_622_36),
	(357. / 509., 0.751_506_87, 0.453_643_14, 0.365_901_1),
	(358. / 509., 0.749_794_2, 0.448_883_32, 0.363_263_37),
	(359. / 509., 0.748_047_4, 0.444_132_98, 0.360_708_15),
	(360. / 509., 0.746_266_2, 0.439_392_45, 0.358_234_4),
	(361. / 509., 0.744_450_2, 0.434_662_16, 0.355_841_07),
	(362. / 509., 0.742_599_2, 0.429_942_55, 0.353_527_1),
	(363. / 509., 0.740_713, 0.425_233_93, 0.351_291_3),
	(364. / 509., 0.738_791_4, 0.420_536_73, 0.349_132_6),
	(365. / 509., 0.736_834_2, 0.415_851_27, 0.347_049_77),
	(366. / 509., 0.734_841_35, 0.411_177_87, 0.345_041_7),
	(367. / 509., 0.732_812_7, 0.406_516_85, 0.343_107_16),
	(368. / 509., 0.730_748_24, 0.401_868_52, 0.341_244_97),
	(369. / 509., 0.728_647_7, 0.397_233_25, 0.339_453_85),
	(370. / 509., 0.726_511_24, 0.392_611_32, 0.337_732_58),
	(371. / 509., 0.724_338_65, 0.388_003_02, 0.336_079_96),
	(372. / 509., 0.722_13, 0.383_408_64, 0.334_494_7),
	(373. / 509., 0.719_885_23, 0.378_828_5, 0.332_975_57),
	(374. / 509., 0.717_604_46, 0.374_262_72, 0.331_521_4),
	(375. / 509., 0.715_287_6, 0.369_711_7, 0.330_130_88),
	(376. / 509., 0.712_934_7, 0.365_175_7, 0.328_802_73),
	(377. / 509., 0.710_545_66, 0.360_655, 0.327_535_75),
	(378. / 509., 0.708_120_6, 0.356_149_85, 0.326_328_6),
	(379. / 509., 0.705_659_5, 0.351_660_52, 0.325_180_14),
	(380. / 509., 0.703_162_5, 0.347_187_25, 0.324_089_14),
	(381. / 509., 0.700_629_65, 0.342_730_2, 0.323_054_5),
	(382. / 509., 0.698_060_8, 0.338_289_77, 0.322_074_8),
	(383. / 509., 0.695_456_1, 0.333_866_2, 0.321_148_84),
	(384. / 509., 0.692_815_4, 0.329_459_85, 0.320_275_43),
	(385. / 509., 0.690_138_94, 0.325_070_92, 0.319_453_33),
	(386. / 509., 0.687_426_57, 0.320_699_7, 0.318_681_4),
	(387. / 509., 0.684_678_5, 0.316_346_35, 0.317_958_7),
	(388. / 509., 0.681_894_6, 0.312_011_33, 0.317_283_8),
	(389. / 509., 0.679_074_76, 0.307_694_97, 0.316_655_46),
	(390. / 509., 0.676_219, 0.303_397_63, 0.316_072_5),
	(391. / 509., 0.673_327_27, 0.299_119_62, 0.315_533_73),
	(392. / 509., 0.670_399_6, 0.294_861_26, 0.315_038_14),
	(393. / 509., 0.667_436_06, 0.290_622_8, 0.314_584_85),
	(394. / 509., 0.664_436_34, 0.286_404_85, 0.314_172_24),
	(395. / 509., 0.661_400_4, 0.282_207_8, 0.313_799_14),
	(396. / 509., 0.658_328_06, 0.278_032_12, 0.313_464_34),
	(397. / 509., 0.655_219_3, 0.273_878_28, 0.313_166_68),
	(398. / 509., 0.652_074_16, 0.269_746_5, 0.312_905_6),
	(399. / 509., 0.648_892_3, 0.265_637_55, 0.312_679_4),
	(400. / 509., 0.645_673_5, 0.261_552_04, 0.312_486_74),
	(401. / 509., 0.642_417_55, 0.257_490_52, 0.312_326_3),
	(402. / 509., 0.639_124_33, 0.253_453_64, 0.312_196_9),
	(403. / 509., 0.635_793_7, 0.249_441_86, 0.312_097_94),
	(404. / 509., 0.632_425_37, 0.245_456, 0.312_027_66),
	(405. / 509., 0.629_018_9, 0.241_496_89, 0.311_984_48),
	(406. / 509., 0.625_574_2, 0.237_565_35, 0.311_967),
	(407. / 509., 0.622_090_8, 0.233_662_19, 0.311_973_84),
	(408. / 509., 0.618_568_66, 0.229_787_99, 0.312_004_63),
	(409. / 509., 0.615_007_2, 0.225_944_03, 0.312_056_8),
	(410. / 509., 0.611_406_2, 0.222_131_25, 0.312_128_8),
	(411. / 509., 0.607_765_26, 0.218_350_71, 0.312_219_02),
	(412. / 509., 0.604_084, 0.214_603_32, 0.312_326_52),
	(413. / 509., 0.600_362_1, 0.210_890_31, 0.312_449_34),
	(414. / 509., 0.596_599_16, 0.207_212_95, 0.312_585_23),
	(415. / 509., 0.592_794_8, 0.203_572_51, 0.312_732_34),
	(416. / 509., 0.588_948_6, 0.199_970_22, 0.312_889_22),
	(417. / 509., 0.585_060_24, 0.196_407_38, 0.313_054_03),
	(418. / 509., 0.581_129_3, 0.192_885_49, 0.313_224),
	(419. / 509., 0.577_155_53, 0.189_406_01, 0.313_397_05),
	(420. / 509., 0.573_138_5, 0.185_970_37, 0.313_571_27),
	(421. / 509., 0.569_077_85, 0.182_580_04, 0.313_744_4),
	(422. / 509., 0.564_973_4, 0.179_236_65, 0.313_913_6),
	(423. / 509., 0.560_825, 0.175_941_7, 0.314_076_4),
	(424. / 509., 0.556_632_3, 0.172_696_77, 0.314_230_44),
	(425. / 509., 0.552_395_2, 0.169_503_39, 0.314_372_93),
	(426. / 509., 0.548_113_7, 0.166_363_09, 0.314_501_02),
	(427. / 509., 0.543_787_7, 0.163_277_39, 0.314_612_03),
	(428. / 509., 0.539_417_4, 0.160_247_7, 0.314_702_96),
	(429. / 509., 0.535_002_77, 0.157_275_41, 0.314_770_85),
	(430. / 509., 0.530_544_2, 0.154_361_83, 0.314_813),
	(431. / 509., 0.526_041_9, 0.151_508_18, 0.314_826_55),
	(432. / 509., 0.521_496_53, 0.148_715_45, 0.314_807_68),
	(433. / 509., 0.516_908_47, 0.145_984_63, 0.314_754_07),
	(434. / 509., 0.512_278_4, 0.143_316_57, 0.314_663_08),
	(435. / 509., 0.507_606_8, 0.140_711_93, 0.314_532),
	(436. / 509., 0.502_895_24, 0.138_170_87, 0.314_356_63),
	(437. / 509., 0.498_144_36, 0.135_693_8, 0.314_135_2),
	(438. / 509., 0.493_355_04, 0.133_280_92, 0.313_865_63),
	(439. / 509., 0.488_528_46, 0.130_932_11, 0.313_545_53),
	(440. / 509., 0.483_666_3, 0.128_646_79, 0.313_171_9),
	(441. / 509., 0.478_770_35, 0.126_424_01, 0.312_741_73),
	(442. / 509., 0.473_841_43, 0.124_263_54, 0.312_254_7),
	(443. / 509., 0.468_881_1, 0.122_164_46, 0.311_709_1),
	(444. / 509., 0.463_891_03, 0.120_125_614, 0.311_103_43),
	(445. / 509., 0.458_872_88, 0.118_145_71, 0.310_436_37),
	(446. / 509., 0.453_830_06, 0.116_221_84, 0.309_704_42),
	(447. / 509., 0.448_762_98, 0.114_353_55, 0.308_909_06),
	(448. / 509., 0.443_673_58, 0.112_539_13, 0.308_049_74),
	(449. / 509., 0.438_563_8, 0.110_776_68, 0.307_126_02),
	(450. / 509., 0.433_435_6, 0.109_064_24, 0.306_137_68),
	(451. / 509., 0.428_291_02, 0.107_399_78, 0.305_084_8),
	(452. / 509., 0.423_132_15, 0.105_781_21, 0.303_967_6),
	(453. / 509., 0.417_961_06, 0.104_206_45, 0.302_786_53),
	(454. / 509., 0.412_779_87, 0.102_673_404, 0.301_542_25),
	(455. / 509., 0.407_591_2, 0.101_179_46, 0.300_235_18),
	(456. / 509., 0.402_396_92, 0.099_722_93, 0.298_866_75),
	(457. / 509., 0.397_198_77, 0.098_302_32, 0.297_438_56),
	(458. / 509., 0.391_998_9, 0.096_915_83, 0.295_952_1),
	(459. / 509., 0.386_799_4, 0.095_561_82, 0.294_409),
	(460. / 509., 0.381_602_47, 0.094_238_73, 0.292_811_07),
	(461. / 509., 0.376_410_3, 0.092_945_196, 0.291_160_26),
	(462. / 509., 0.371_225_1, 0.091_68, 0.289_458_66),
	(463. / 509., 0.366_050_3, 0.090_440_68, 0.287_707_75),
	(464. / 509., 0.360_887_53, 0.089_227_19, 0.285_910_52),
	(465. / 509., 0.355_738_9, 0.088_038_97, 0.284_069_6),
	(466. / 509., 0.350_606_77, 0.086_875_55, 0.282_187_7),
	(467. / 509., 0.345_493_56, 0.085_736_655, 0.280_267_7),
	(468. / 509., 0.340_401_65, 0.084_622_234, 0.278_312_53),
	(469. / 509., 0.335_333_53, 0.083_532_44, 0.276_325_35),
	(470. / 509., 0.330_291_75, 0.082_467_63, 0.274_309_3),
	(471. / 509., 0.325_278_88, 0.081_428_39, 0.272_267_73),
	(472. / 509., 0.320_299_86, 0.080_412_99, 0.270_203_23),
	(473. / 509., 0.315_358_7, 0.079_421, 0.268_119_04),
	(474. / 509., 0.310_455_2, 0.078_456_87, 0.266_020_06),
	(475. / 509., 0.305_592_27, 0.077_521_965, 0.263_910_06),
	(476. / 509., 0.300_772_76, 0.076_617_82, 0.261_792_93),
	(477. / 509., 0.296_000_48, 0.075_745_34, 0.259_672_46),
	(478. / 509., 0.291_285_16, 0.074_899_05, 0.257_551),
	(479. / 509., 0.286_623_1, 0.074_088_46, 0.255_434_78),
	(480. / 509., 0.282_017_47, 0.073_315_695, 0.253_328),
	(481. / 509., 0.277_471_5, 0.072_582_97, 0.251_234_95),
	(482. / 509., 0.272_997_02, 0.071_883_55, 0.249_158_47),
	(483. / 509., 0.268_590_96, 0.071_226_716, 0.247_104_44),
	(484. / 509., 0.264_255_14, 0.070_616_595, 0.245_077_6),
	(485. / 509., 0.259_994_63, 0.070_053_85, 0.243_082_2),
	(486. / 509., 0.255_821_35, 0.069_532_31, 0.241_121_9),
	(487. / 509., 0.251_729, 0.069_064_63, 0.239_202_6),
	(488. / 509., 0.247_720_93, 0.068_653_34, 0.237_328_8),
	(489. / 509., 0.243_811_5, 0.068_289_85, 0.235_504_27),
	(490. / 509., 0.239_995_87, 0.067_985_03, 0.233_734_34),
	(491. / 509., 0.236_274_96, 0.067_743_6, 0.232_023_61),
	(492. / 509., 0.232_663, 0.067_557_104, 0.230_376_17),
	(493. / 509., 0.229_156_2, 0.067_434_73, 0.228_796_81),
	(494. / 509., 0.225_753_96, 0.067_382_134, 0.227_289_84),
	(495. / 509., 0.222_473_08, 0.067_388_214, 0.225_859_6),
	(496. / 509., 0.219_305_04, 0.067_465_79, 0.224_510_24),
	(497. / 509., 0.216_252_8, 0.067_616_33, 0.223_245_68),
	(498. / 509., 0.213_331_39, 0.067_830_145, 0.222_070_43),
	(499. / 509., 0.210_528_84, 0.068_121_955, 0.220_987_59),
	(500. / 509., 0.207_857_04, 0.068_484_396, 0.220_001_34),
	(501. / 509., 0.205_317_26, 0.068_919_59, 0.219_115_17),
	(502. / 509., 0.202_903_66, 0.069_435_25, 0.218_331_68),
	(503. / 509., 0.200_587_6, 0.070_064_574, 0.217_627_21),
	(504. / 509., 0.198_193_43, 0.070_974_626, 0.216_909_75),
	(505. / 509., 0.195_718_54, 0.072_157_78, 0.216_174_99),
	(506. / 509., 0.193_154_86, 0.073_606_82, 0.215_423_63),
	(507. / 509., 0.190_495_79, 0.075_311_28, 0.214_656_23),
	(508. / 509., 0.187_744_83, 0.077_251_59, 0.213_874_49),
	(1., 0.184_880_36, 0.079_425_73, 0.213_076_52),
]);

pub const TURBO: PaletteType<&'static [(f32, f32, f32, f32)]> = PaletteType::Custom(&[
	(0. / 255., 0.18995, 0.07176, 0.23217),
	(1. / 255., 0.19483, 0.08339, 0.26149),
	(2. / 255., 0.19956, 0.09498, 0.29024),
	(3. / 255., 0.20415, 0.10652, 0.31844),
	(4. / 255., 0.2086, 0.11802, 0.34607),
	(5. / 255., 0.21291, 0.12947, 0.37314),
	(6. / 255., 0.21708, 0.14087, 0.39964),
	(7. / 255., 0.22111, 0.15223, 0.42558),
	(8. / 255., 0.225, 0.16354, 0.45096),
	(9. / 255., 0.22875, 0.17481, 0.47578),
	(10. / 255., 0.23236, 0.18603, 0.50004),
	(11. / 255., 0.23582, 0.1972, 0.52373),
	(12. / 255., 0.23915, 0.20833, 0.54686),
	(13. / 255., 0.24234, 0.21941, 0.56942),
	(14. / 255., 0.24539, 0.23044, 0.59142),
	(15. / 255., 0.2483, 0.24143, 0.61286),
	(16. / 255., 0.25107, 0.25237, 0.63374),
	(17. / 255., 0.25369, 0.26327, 0.65406),
	(18. / 255., 0.25618, 0.27412, 0.67381),
	(19. / 255., 0.25853, 0.28492, 0.693),
	(20. / 255., 0.26074, 0.29568, 0.71162),
	(21. / 255., 0.2628, 0.30639, 0.72968),
	(22. / 255., 0.26473, 0.31706, 0.74718),
	(23. / 255., 0.26652, 0.32768, 0.76412),
	(24. / 255., 0.26816, 0.33825, 0.7805),
	(25. / 255., 0.26967, 0.34878, 0.79631),
	(26. / 255., 0.27103, 0.35926, 0.81156),
	(27. / 255., 0.27226, 0.3697, 0.82624),
	(28. / 255., 0.27334, 0.38008, 0.84037),
	(29. / 255., 0.27429, 0.39043, 0.85393),
	(30. / 255., 0.27509, 0.40072, 0.86692),
	(31. / 255., 0.27576, 0.41097, 0.87936),
	(32. / 255., 0.27628, 0.42118, 0.89123),
	(33. / 255., 0.27667, 0.43134, 0.90254),
	(34. / 255., 0.27691, 0.44145, 0.91328),
	(35. / 255., 0.27701, 0.45152, 0.92347),
	(36. / 255., 0.27698, 0.46153, 0.93309),
	(37. / 255., 0.2768, 0.47151, 0.94214),
	(38. / 255., 0.27648, 0.48144, 0.95064),
	(39. / 255., 0.27603, 0.49132, 0.95857),
	(40. / 255., 0.27543, 0.50115, 0.96594),
	(41. / 255., 0.27469, 0.51094, 0.97275),
	(42. / 255., 0.27381, 0.52069, 0.97899),
	(43. / 255., 0.27273, 0.5304, 0.98461),
	(44. / 255., 0.27106, 0.54015, 0.9893),
	(45. / 255., 0.26878, 0.54995, 0.99303),
	(46. / 255., 0.26592, 0.55979, 0.99583),
	(47. / 255., 0.26252, 0.56967, 0.99773),
	(48. / 255., 0.25862, 0.57958, 0.99876),
	(49. / 255., 0.25425, 0.5895, 0.99896),
	(50. / 255., 0.24946, 0.59943, 0.99835),
	(51. / 255., 0.24427, 0.60937, 0.99697),
	(52. / 255., 0.23874, 0.61931, 0.99485),
	(53. / 255., 0.23288, 0.62923, 0.99202),
	(54. / 255., 0.22676, 0.63913, 0.98851),
	(55. / 255., 0.22039, 0.64901, 0.98436),
	(56. / 255., 0.21382, 0.65886, 0.97959),
	(57. / 255., 0.20708, 0.66866, 0.97423),
	(58. / 255., 0.20021, 0.67842, 0.96833),
	(59. / 255., 0.19326, 0.68812, 0.9619),
	(60. / 255., 0.18625, 0.69775, 0.95498),
	(61. / 255., 0.17923, 0.70732, 0.94761),
	(62. / 255., 0.17223, 0.7168, 0.93981),
	(63. / 255., 0.16529, 0.7262, 0.93161),
	(64. / 255., 0.15844, 0.73551, 0.92305),
	(65. / 255., 0.15173, 0.74472, 0.91416),
	(66. / 255., 0.14519, 0.75381, 0.90496),
	(67. / 255., 0.13886, 0.76279, 0.8955),
	(68. / 255., 0.13278, 0.77165, 0.8858),
	(69. / 255., 0.12698, 0.78037, 0.8759),
	(70. / 255., 0.12151, 0.78896, 0.86581),
	(71. / 255., 0.11639, 0.7974, 0.85559),
	(72. / 255., 0.11167, 0.80569, 0.84525),
	(73. / 255., 0.10738, 0.81381, 0.83484),
	(74. / 255., 0.10357, 0.82177, 0.82437),
	(75. / 255., 0.10026, 0.82955, 0.81389),
	(76. / 255., 0.0975, 0.83714, 0.80342),
	(77. / 255., 0.09532, 0.84455, 0.79299),
	(78. / 255., 0.09377, 0.85175, 0.78264),
	(79. / 255., 0.09287, 0.85875, 0.7724),
	(80. / 255., 0.09267, 0.86554, 0.7623),
	(81. / 255., 0.0932, 0.87211, 0.75237),
	(82. / 255., 0.09451, 0.87844, 0.74265),
	(83. / 255., 0.09662, 0.88454, 0.73316),
	(84. / 255., 0.09958, 0.8904, 0.72393),
	(85. / 255., 0.10342, 0.896, 0.715),
	(86. / 255., 0.10815, 0.90142, 0.70599),
	(87. / 255., 0.11374, 0.90673, 0.69651),
	(88. / 255., 0.12014, 0.91193, 0.6866),
	(89. / 255., 0.12733, 0.91701, 0.67627),
	(90. / 255., 0.13526, 0.92197, 0.66556),
	(91. / 255., 0.14391, 0.9268, 0.65448),
	(92. / 255., 0.15323, 0.93151, 0.64308),
	(93. / 255., 0.16319, 0.93609, 0.63137),
	(94. / 255., 0.17377, 0.94053, 0.61938),
	(95. / 255., 0.18491, 0.94484, 0.60713),
	(96. / 255., 0.19659, 0.94901, 0.59466),
	(97. / 255., 0.20877, 0.95304, 0.58199),
	(98. / 255., 0.22142, 0.95692, 0.56914),
	(99. / 255., 0.23449, 0.96065, 0.55614),
	(100. / 255., 0.24797, 0.96423, 0.54303),
	(101. / 255., 0.2618, 0.96765, 0.52981),
	(102. / 255., 0.27597, 0.97092, 0.51653),
	(103. / 255., 0.29042, 0.97403, 0.50321),
	(104. / 255., 0.30513, 0.97697, 0.48987),
	(105. / 255., 0.32006, 0.97974, 0.47654),
	(106. / 255., 0.33517, 0.98234, 0.46325),
	(107. / 255., 0.35043, 0.98477, 0.45002),
	(108. / 255., 0.36581, 0.98702, 0.43688),
	(109. / 255., 0.38127, 0.98909, 0.42386),
	(110. / 255., 0.39678, 0.99098, 0.41098),
	(111. / 255., 0.41229, 0.99268, 0.39826),
	(112. / 255., 0.42778, 0.99419, 0.38575),
	(113. / 255., 0.44321, 0.99551, 0.37345),
	(114. / 255., 0.45854, 0.99663, 0.3614),
	(115. / 255., 0.47375, 0.99755, 0.34963),
	(116. / 255., 0.48879, 0.99828, 0.33816),
	(117. / 255., 0.50362, 0.99879, 0.32701),
	(118. / 255., 0.51822, 0.9991, 0.31622),
	(119. / 255., 0.53255, 0.99919, 0.30581),
	(120. / 255., 0.54658, 0.99907, 0.29581),
	(121. / 255., 0.56026, 0.99873, 0.28623),
	(122. / 255., 0.57357, 0.99817, 0.27712),
	(123. / 255., 0.58646, 0.99739, 0.26849),
	(124. / 255., 0.59891, 0.99638, 0.26038),
	(125. / 255., 0.61088, 0.99514, 0.2528),
	(126. / 255., 0.62233, 0.99366, 0.24579),
	(127. / 255., 0.63323, 0.99195, 0.23937),
	(128. / 255., 0.64362, 0.98999, 0.23356),
	(129. / 255., 0.65394, 0.98775, 0.22835),
	(130. / 255., 0.66428, 0.98524, 0.2237),
	(131. / 255., 0.67462, 0.98246, 0.2196),
	(132. / 255., 0.68494, 0.97941, 0.21602),
	(133. / 255., 0.69525, 0.9761, 0.21294),
	(134. / 255., 0.70553, 0.97255, 0.21032),
	(135. / 255., 0.71577, 0.96875, 0.20815),
	(136. / 255., 0.72596, 0.9647, 0.2064),
	(137. / 255., 0.7361, 0.96043, 0.20504),
	(138. / 255., 0.74617, 0.95593, 0.20406),
	(139. / 255., 0.75617, 0.95121, 0.20343),
	(140. / 255., 0.76608, 0.94627, 0.20311),
	(141. / 255., 0.77591, 0.94113, 0.2031),
	(142. / 255., 0.78563, 0.93579, 0.20336),
	(143. / 255., 0.79524, 0.93025, 0.20386),
	(144. / 255., 0.80473, 0.92452, 0.20459),
	(145. / 255., 0.8141, 0.91861, 0.20552),
	(146. / 255., 0.82333, 0.91253, 0.20663),
	(147. / 255., 0.83241, 0.90627, 0.20788),
	(148. / 255., 0.84133, 0.89986, 0.20926),
	(149. / 255., 0.8501, 0.89328, 0.21074),
	(150. / 255., 0.85868, 0.88655, 0.2123),
	(151. / 255., 0.86709, 0.87968, 0.21391),
	(152. / 255., 0.8753, 0.87267, 0.21555),
	(153. / 255., 0.88331, 0.86553, 0.21719),
	(154. / 255., 0.89112, 0.85826, 0.2188),
	(155. / 255., 0.8987, 0.85087, 0.22038),
	(156. / 255., 0.90605, 0.84337, 0.22188),
	(157. / 255., 0.91317, 0.83576, 0.22328),
	(158. / 255., 0.92004, 0.82806, 0.22456),
	(159. / 255., 0.92666, 0.82025, 0.2257),
	(160. / 255., 0.93301, 0.81236, 0.22667),
	(161. / 255., 0.93909, 0.80439, 0.22744),
	(162. / 255., 0.94489, 0.79634, 0.228),
	(163. / 255., 0.95039, 0.78823, 0.22831),
	(164. / 255., 0.9556, 0.78005, 0.22836),
	(165. / 255., 0.96049, 0.77181, 0.22811),
	(166. / 255., 0.96507, 0.76352, 0.22754),
	(167. / 255., 0.96931, 0.75519, 0.22663),
	(168. / 255., 0.97323, 0.74682, 0.22536),
	(169. / 255., 0.97679, 0.73842, 0.22369),
	(170. / 255., 0.98, 0.73, 0.22161),
	(171. / 255., 0.98289, 0.7214, 0.21918),
	(172. / 255., 0.98549, 0.7125, 0.2165),
	(173. / 255., 0.98781, 0.7033, 0.21358),
	(174. / 255., 0.98986, 0.69382, 0.21043),
	(175. / 255., 0.99163, 0.68408, 0.20706),
	(176. / 255., 0.99314, 0.67408, 0.20348),
	(177. / 255., 0.99438, 0.66386, 0.19971),
	(178. / 255., 0.99535, 0.65341, 0.19577),
	(179. / 255., 0.99607, 0.64277, 0.19165),
	(180. / 255., 0.99654, 0.63193, 0.18738),
	(181. / 255., 0.99675, 0.62093, 0.18297),
	(182. / 255., 0.99672, 0.60977, 0.17842),
	(183. / 255., 0.99644, 0.59846, 0.17376),
	(184. / 255., 0.99593, 0.58703, 0.16899),
	(185. / 255., 0.99517, 0.57549, 0.16412),
	(186. / 255., 0.99419, 0.56386, 0.15918),
	(187. / 255., 0.99297, 0.55214, 0.15417),
	(188. / 255., 0.99153, 0.54036, 0.1491),
	(189. / 255., 0.98987, 0.52854, 0.14398),
	(190. / 255., 0.98799, 0.51667, 0.13883),
	(191. / 255., 0.9859, 0.50479, 0.13367),
	(192. / 255., 0.9836, 0.49291, 0.12849),
	(193. / 255., 0.98108, 0.48104, 0.12332),
	(194. / 255., 0.97837, 0.4692, 0.11817),
	(195. / 255., 0.97545, 0.4574, 0.11305),
	(196. / 255., 0.97234, 0.44565, 0.10797),
	(197. / 255., 0.96904, 0.43399, 0.10294),
	(198. / 255., 0.96555, 0.42241, 0.09798),
	(199. / 255., 0.96187, 0.41093, 0.0931),
	(200. / 255., 0.95801, 0.39958, 0.08831),
	(201. / 255., 0.95398, 0.38836, 0.08362),
	(202. / 255., 0.94977, 0.37729, 0.07905),
	(203. / 255., 0.94538, 0.36638, 0.07461),
	(204. / 255., 0.94084, 0.35566, 0.07031),
	(205. / 255., 0.93612, 0.34513, 0.06616),
	(206. / 255., 0.93125, 0.33482, 0.06218),
	(207. / 255., 0.92623, 0.32473, 0.05837),
	(208. / 255., 0.92105, 0.31489, 0.05475),
	(209. / 255., 0.91572, 0.3053, 0.05134),
	(210. / 255., 0.91024, 0.29599, 0.04814),
	(211. / 255., 0.90463, 0.28696, 0.04516),
	(212. / 255., 0.89888, 0.27824, 0.04243),
	(213. / 255., 0.89298, 0.26981, 0.03993),
	(214. / 255., 0.88691, 0.26152, 0.03753),
	(215. / 255., 0.88066, 0.25334, 0.03521),
	(216. / 255., 0.87422, 0.24526, 0.03297),
	(217. / 255., 0.8676, 0.2373, 0.03082),
	(218. / 255., 0.86079, 0.22945, 0.02875),
	(219. / 255., 0.8538, 0.2217, 0.02677),
	(220. / 255., 0.84662, 0.21407, 0.02487),
	(221. / 255., 0.83926, 0.20654, 0.02305),
	(222. / 255., 0.83172, 0.19912, 0.02131),
	(223. / 255., 0.82399, 0.19182, 0.01966),
	(224. / 255., 0.81608, 0.18462, 0.01809),
	(225. / 255., 0.80799, 0.17753, 0.0166),
	(226. / 255., 0.79971, 0.17055, 0.0152),
	(227. / 255., 0.79125, 0.16368, 0.01387),
	(228. / 255., 0.7826, 0.15693, 0.01264),
	(229. / 255., 0.77377, 0.15028, 0.01148),
	(230. / 255., 0.76476, 0.14374, 0.01041),
	(231. / 255., 0.75556, 0.13731, 0.00942),
	(232. / 255., 0.74617, 0.13098, 0.00851),
	(233. / 255., 0.73661, 0.12477, 0.00769),
	(234. / 255., 0.72686, 0.11867, 0.00695),
	(235. / 255., 0.71692, 0.11268, 0.00629),
	(236. / 255., 0.7068, 0.1068, 0.00571),
	(237. / 255., 0.6965, 0.10102, 0.00522),
	(238. / 255., 0.68602, 0.09536, 0.00481),
	(239. / 255., 0.67535, 0.0898, 0.00449),
	(240. / 255., 0.66449, 0.08436, 0.00424),
	(241. / 255., 0.65345, 0.07902, 0.00408),
	(242. / 255., 0.64223, 0.0738, 0.00401),
	(243. / 255., 0.63082, 0.06868, 0.00401),
	(244. / 255., 0.61923, 0.06367, 0.0041),
	(245. / 255., 0.60746, 0.05878, 0.00427),
	(246. / 255., 0.5955, 0.05399, 0.00453),
	(247. / 255., 0.58336, 0.04931, 0.00486),
	(248. / 255., 0.57103, 0.04474, 0.00529),
	(249. / 255., 0.55852, 0.04028, 0.00579),
	(250. / 255., 0.54583, 0.03593, 0.00638),
	(251. / 255., 0.53295, 0.03169, 0.00705),
	(252. / 255., 0.51989, 0.02756, 0.0078),
	(253. / 255., 0.50664, 0.02354, 0.00863),
	(254. / 255., 0.49321, 0.01963, 0.00955),
	(1., 0.4796, 0.01583, 0.01055),
]);
