$LOAD_PATH.delete_if do |path|
  path.split('/').include?('vendor_ruby')
end

require 'etc'
require 'rubygems'

class << Gem
  alias :orig_default_bindir :default_bindir
  def default_bindir
    Etc.getpwuid.name == 'root' && '/usr/local/bin' || File.join(user_dir, 'bin')
  end

  alias :orig_default_dir :default_dir
  def default_dir
    Etc.getpwuid.name == 'root' && File.join('/var/lib/gems', Gem::ConfigMap[:ruby_version]) || user_dir
  end

  alias :orig_default_path :default_path
  def default_path
    [user_dir, File.join('/var/lib/gems', Gem::ConfigMap[:ruby_version])]
  end

  def user_dir
    File.join(Gem.user_home, '.ruby-standalone/gems', Gem.ruby_engine, Gem::ConfigMap[:ruby_version])
  end
end

class << Gem::Specification
  alias :orig_default_specifications_dir :default_specifications_dir
  def default_specifications_dir
    File.join(Gem.orig_default_dir, "specifications", "default")
  end
end

require_relative 'debian_ruby_standalone_config'
