# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Iterable, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import AuthoringClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_authoring_list_projects_request(
    *, top: Optional[int] = None, skip: Optional[int] = None, maxpagesize: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_get_project_details_request(  # pylint: disable=name-too-long
    project_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_create_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_delete_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_export_request(
    project_name: str, *, file_format: str = "json", asset_kind: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/:export"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if file_format is not None:
        _params["format"] = _SERIALIZER.query("file_format", file_format, "str")
    if asset_kind is not None:
        _params["assetKind"] = _SERIALIZER.query("asset_kind", asset_kind, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_import_assets_request(
    project_name: str, *, file_format: str = "json", asset_kind: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/:import"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if file_format is not None:
        _params["format"] = _SERIALIZER.query("file_format", file_format, "str")
    if asset_kind is not None:
        _params["assetKind"] = _SERIALIZER.query("asset_kind", asset_kind, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_deploy_project_request(project_name: str, deployment_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/deployments/{deploymentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "deploymentName": _SERIALIZER.url("deployment_name", deployment_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_list_deployments_request(
    project_name: str,
    *,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    maxpagesize: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/deployments"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_list_synonyms_request(
    project_name: str,
    *,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    maxpagesize: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/synonyms"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_update_synonyms_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/synonyms"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_list_sources_request(
    project_name: str,
    *,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    maxpagesize: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/sources"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_update_sources_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/sources"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_list_qnas_request(
    project_name: str,
    *,
    source: Optional[str] = None,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    maxpagesize: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/qnas"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if source is not None:
        _params["source"] = _SERIALIZER.query("source", source, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_update_qnas_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/qnas"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_authoring_add_feedback_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/feedback"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class AuthoringClientOperationsMixin(AuthoringClientMixinABC):  # pylint: disable=too-many-public-methods
    @distributed_trace
    def list_projects(self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any) -> Iterable[JSON]:
        # pylint: disable=line-too-long
        """Gets all projects for a user.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/list-projects
        for more information.

        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_list_projects_request(
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_project_details(self, project_name: str, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get the requested project metadata.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/get-project-details
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_authoring_get_project_details_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create_project(
        self, project_name: str, options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create or update a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/create-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param options: Parameters needed to create the project. Required.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "language": "str",  # Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default. Required.
                    "description": "str",  # Optional. Description of the project.
                    "multilingualResource": bool,  # Optional. Set to true to enable creating
                      knowledgebases in different languages for the same resource.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """

    @overload
    def create_project(
        self, project_name: str, options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create or update a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/create-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param options: Parameters needed to create the project. Required.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """

    @distributed_trace
    def create_project(self, project_name: str, options: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create or update a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/create-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param options: Parameters needed to create the project. Is either a JSON type or a IO[bytes]
         type. Required.
        :type options: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "language": "str",  # Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default. Required.
                    "description": "str",  # Optional. Description of the project.
                    "multilingualResource": bool,  # Optional. Set to true to enable creating
                      knowledgebases in different languages for the same resource.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            _json = options

        _request = build_authoring_create_project_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    def _delete_project_initial(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_authoring_delete_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def begin_delete_project(self, project_name: str, **kwargs: Any) -> LROPoller[None]:
        """Delete the project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/delete-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_project_initial(  # type: ignore
                project_name=project_name, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    def _export_initial(
        self, project_name: str, *, file_format: str = "json", asset_kind: Optional[str] = None, **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        _request = build_authoring_export_request(
            project_name=project_name,
            file_format=file_format,
            asset_kind=asset_kind,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def begin_export(
        self, project_name: str, *, file_format: str = "json", asset_kind: Optional[str] = None, **kwargs: Any
    ) -> LROPoller[JSON]:
        # pylint: disable=line-too-long
        """Export project metadata and assets.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/export
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is "json".
        :paramtype file_format: str
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Required.
                    "jobId": "str",  # Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Required.
                    "resultUrl": "str",  # URL to download the result of the Export Job.
                      Required.
                    "status": "str",  # Job Status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError", and
                              "ServiceUnavailable".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", and
                                  "ExtractionFailure".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00"  # Optional.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._export_initial(
                project_name=project_name,
                file_format=file_format,
                asset_kind=asset_kind,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    def _import_assets_initial(
        self,
        project_name: str,
        options: Optional[Union[JSON, IO[bytes]]] = None,
        *,
        file_format: str = "json",
        asset_kind: Optional[str] = None,
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _json = options
            else:
                _json = None

        _request = build_authoring_import_assets_request(
            project_name=project_name,
            file_format=file_format,
            asset_kind=asset_kind,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_import_assets(
        self,
        project_name: str,
        options: Optional[JSON] = None,
        *,
        file_format: str = "json",
        asset_kind: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        # pylint: disable=line-too-long
        """Import project assets.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/import
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param options: Project assets the needs to be imported. Default value is None.
        :type options: JSON
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is "json".
        :paramtype file_format: str
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "assets": {
                        "qnas": [
                            {
                                "activeLearningSuggestions": [
                                    {
                                        "clusterHead": "str",  # Optional.
                                          Question chosen as the head of suggested questions cluster by
                                          Active Learning clustering algorithm.
                                        "suggestedQuestions": [
                                            {
                                                "autoSuggestedCount":
                                                  0,  # Optional. The number of times the question was
                                                  suggested automatically by the Active Learning
                                                  algorithm.
                                                "question": "str",  #
                                                  Optional. Question suggested by the Active Learning
                                                  feature.
                                                "userSuggestedCount":
                                                  0  # Optional. The number of times the question was
                                                  suggested explicitly by the user.
                                            }
                                        ]
                                    }
                                ],
                                "answer": "str",  # Optional. Answer text.
                                "dialog": {
                                    "isContextOnly": bool,  # Optional. To mark
                                      if a prompt is relevant only with a previous question or not. If
                                      true, do not include this QnA as answer for queries without
                                      context; otherwise, ignores context and includes this QnA in
                                      answers.
                                    "prompts": [
                                        {
                                            "displayOrder": 0,  #
                                              Optional. Index of the prompt. It is used for ordering of
                                              the prompts.
                                            "displayText": "str",  #
                                              Optional. Text displayed to represent a follow up
                                              question prompt.
                                            "qna": {
                "activeLearningSuggestions": [
                                                    {
                "clusterHead": "str",  # Optional. Question
                                                          chosen as the head of suggested questions
                                                          cluster by Active Learning clustering
                                                          algorithm.
                "suggestedQuestions": [
                {
                "autoSuggestedCount": 0,  # Optional.
                                                                  The number of times the question was
                                                                  suggested automatically by the Active
                                                                  Learning algorithm.
                "question": "str",  # Optional.
                                                                  Question suggested by the Active
                                                                  Learning feature.
                "userSuggestedCount": 0  # Optional.
                                                                  The number of times the question was
                                                                  suggested explicitly by the user.
                }
                                                        ]
                                                    }
                                                ],
                                                "answer": "str",  #
                                                  Optional. Answer text.
                                                "dialog": ...,
                                                "id": 0,  # Optional.
                                                  Unique ID for the QnA.
                                                "metadata": {
                                                    "str": "str"
                                                      # Optional. Metadata associated with the answer,
                                                      useful to categorize or filter question answers.
                                                },
                                                "questions": [
                                                    "str"  #
                                                      Optional. List of questions associated with the
                                                      answer.
                                                ],
                                                "source": "str"  #
                                                  Optional. Source from which QnA was indexed e.g.
                                                  https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                                  .
                                            },
                                            "qnaId": 0  # Optional. ID of
                                              the QnA corresponding to the prompt.
                                        }
                                    ]
                                },
                                "id": 0,  # Optional. Unique ID for the QnA.
                                "lastUpdatedDateTime": "2020-02-20 00:00:00",  #
                                  Optional. Date-time when the QnA was last updated.
                                "metadata": {
                                    "str": "str"  # Optional. Metadata associated
                                      with the answer, useful to categorize or filter question answers.
                                },
                                "questions": [
                                    "str"  # Optional. List of questions
                                      associated with the answer.
                                ],
                                "source": "str",  # Optional. Source from which QnA
                                  was indexed e.g.
                                  https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                  .
                                "sourceDisplayName": "str"  # Optional. Friendly name
                                  of the Source.
                            }
                        ],
                        "synonyms": [
                            {
                                "alterations": [
                                    "str"  # Collection of word alterations.
                                      Required.
                                ]
                            }
                        ]
                    },
                    "fileUri": "str",  # Optional. Import data File URI.
                    "metadata": {
                        "language": "str",  # Language of the text records. This is BCP-47
                          representation of a language. For example, use "en" for English; "es" for
                          Spanish etc. If not set, use "en" for English as default. Required.
                        "description": "str",  # Optional. Description of the project.
                        "multilingualResource": bool,  # Optional. Set to true to enable
                          creating knowledgebases in different languages for the same resource.
                        "settings": {
                            "defaultAnswer": "str"  # Optional. Default Answer response
                              when no good match is found in the knowledge base.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Required.
                    "jobId": "str",  # Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Required.
                    "status": "str",  # Job Status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError", and
                              "ServiceUnavailable".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", and
                                  "ExtractionFailure".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00"  # Optional.
                }
        """

    @overload
    def begin_import_assets(
        self,
        project_name: str,
        options: Optional[IO[bytes]] = None,
        *,
        file_format: str = "json",
        asset_kind: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        # pylint: disable=line-too-long
        """Import project assets.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/import
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param options: Project assets the needs to be imported. Default value is None.
        :type options: IO[bytes]
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is "json".
        :paramtype file_format: str
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Required.
                    "jobId": "str",  # Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Required.
                    "status": "str",  # Job Status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError", and
                              "ServiceUnavailable".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", and
                                  "ExtractionFailure".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00"  # Optional.
                }
        """

    @distributed_trace
    def begin_import_assets(
        self,
        project_name: str,
        options: Optional[Union[JSON, IO[bytes]]] = None,
        *,
        file_format: str = "json",
        asset_kind: Optional[str] = None,
        **kwargs: Any
    ) -> LROPoller[JSON]:
        # pylint: disable=line-too-long
        """Import project assets.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/import
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param options: Project assets the needs to be imported. Is either a JSON type or a IO[bytes]
         type. Default value is None.
        :type options: JSON or IO[bytes]
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is "json".
        :paramtype file_format: str
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "assets": {
                        "qnas": [
                            {
                                "activeLearningSuggestions": [
                                    {
                                        "clusterHead": "str",  # Optional.
                                          Question chosen as the head of suggested questions cluster by
                                          Active Learning clustering algorithm.
                                        "suggestedQuestions": [
                                            {
                                                "autoSuggestedCount":
                                                  0,  # Optional. The number of times the question was
                                                  suggested automatically by the Active Learning
                                                  algorithm.
                                                "question": "str",  #
                                                  Optional. Question suggested by the Active Learning
                                                  feature.
                                                "userSuggestedCount":
                                                  0  # Optional. The number of times the question was
                                                  suggested explicitly by the user.
                                            }
                                        ]
                                    }
                                ],
                                "answer": "str",  # Optional. Answer text.
                                "dialog": {
                                    "isContextOnly": bool,  # Optional. To mark
                                      if a prompt is relevant only with a previous question or not. If
                                      true, do not include this QnA as answer for queries without
                                      context; otherwise, ignores context and includes this QnA in
                                      answers.
                                    "prompts": [
                                        {
                                            "displayOrder": 0,  #
                                              Optional. Index of the prompt. It is used for ordering of
                                              the prompts.
                                            "displayText": "str",  #
                                              Optional. Text displayed to represent a follow up
                                              question prompt.
                                            "qna": {
                "activeLearningSuggestions": [
                                                    {
                "clusterHead": "str",  # Optional. Question
                                                          chosen as the head of suggested questions
                                                          cluster by Active Learning clustering
                                                          algorithm.
                "suggestedQuestions": [
                {
                "autoSuggestedCount": 0,  # Optional.
                                                                  The number of times the question was
                                                                  suggested automatically by the Active
                                                                  Learning algorithm.
                "question": "str",  # Optional.
                                                                  Question suggested by the Active
                                                                  Learning feature.
                "userSuggestedCount": 0  # Optional.
                                                                  The number of times the question was
                                                                  suggested explicitly by the user.
                }
                                                        ]
                                                    }
                                                ],
                                                "answer": "str",  #
                                                  Optional. Answer text.
                                                "dialog": ...,
                                                "id": 0,  # Optional.
                                                  Unique ID for the QnA.
                                                "metadata": {
                                                    "str": "str"
                                                      # Optional. Metadata associated with the answer,
                                                      useful to categorize or filter question answers.
                                                },
                                                "questions": [
                                                    "str"  #
                                                      Optional. List of questions associated with the
                                                      answer.
                                                ],
                                                "source": "str"  #
                                                  Optional. Source from which QnA was indexed e.g.
                                                  https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                                  .
                                            },
                                            "qnaId": 0  # Optional. ID of
                                              the QnA corresponding to the prompt.
                                        }
                                    ]
                                },
                                "id": 0,  # Optional. Unique ID for the QnA.
                                "lastUpdatedDateTime": "2020-02-20 00:00:00",  #
                                  Optional. Date-time when the QnA was last updated.
                                "metadata": {
                                    "str": "str"  # Optional. Metadata associated
                                      with the answer, useful to categorize or filter question answers.
                                },
                                "questions": [
                                    "str"  # Optional. List of questions
                                      associated with the answer.
                                ],
                                "source": "str",  # Optional. Source from which QnA
                                  was indexed e.g.
                                  https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                  .
                                "sourceDisplayName": "str"  # Optional. Friendly name
                                  of the Source.
                            }
                        ],
                        "synonyms": [
                            {
                                "alterations": [
                                    "str"  # Collection of word alterations.
                                      Required.
                                ]
                            }
                        ]
                    },
                    "fileUri": "str",  # Optional. Import data File URI.
                    "metadata": {
                        "language": "str",  # Language of the text records. This is BCP-47
                          representation of a language. For example, use "en" for English; "es" for
                          Spanish etc. If not set, use "en" for English as default. Required.
                        "description": "str",  # Optional. Description of the project.
                        "multilingualResource": bool,  # Optional. Set to true to enable
                          creating knowledgebases in different languages for the same resource.
                        "settings": {
                            "defaultAnswer": "str"  # Optional. Default Answer response
                              when no good match is found in the knowledge base.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Required.
                    "jobId": "str",  # Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Required.
                    "status": "str",  # Job Status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError", and
                              "ServiceUnavailable".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", and
                                  "ExtractionFailure".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00"  # Optional.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._import_assets_initial(
                project_name=project_name,
                options=options,
                file_format=file_format,
                asset_kind=asset_kind,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    def _deploy_project_initial(self, project_name: str, deployment_name: str, **kwargs: Any) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        _request = build_authoring_deploy_project_request(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def begin_deploy_project(self, project_name: str, deployment_name: str, **kwargs: Any) -> LROPoller[JSON]:
        """Deploy project to production.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/deploy-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentName": "str",  # Optional. Name of the deployment.
                    "lastDeployedDateTime": "2020-02-20 00:00:00"  # Optional. Represents the
                      project last deployment date-time.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._deploy_project_initial(
                project_name=project_name,
                deployment_name=deployment_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_deployments(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """List all deployments of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/list-deployments
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentName": "str",  # Optional. Name of the deployment.
                    "lastDeployedDateTime": "2020-02-20 00:00:00"  # Optional. Represents the
                      project last deployment date-time.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_list_deployments_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_synonyms(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Gets all the synonyms of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/get-synonyms
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "alterations": [
                        "str"  # Collection of word alterations. Required.
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_list_synonyms_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @overload
    def update_synonyms(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, synonyms: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-synonyms
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param synonyms: All the synonyms of a project. Required.
        :type synonyms: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                synonyms = {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "alterations": [
                                "str"  # Collection of word alterations. Required.
                            ]
                        }
                    ]
                }
        """

    @overload
    def update_synonyms(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, synonyms: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-synonyms
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param synonyms: All the synonyms of a project. Required.
        :type synonyms: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_synonyms(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, synonyms: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-synonyms
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param synonyms: All the synonyms of a project. Is either a JSON type or a IO[bytes] type.
         Required.
        :type synonyms: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                synonyms = {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "alterations": [
                                "str"  # Collection of word alterations. Required.
                            ]
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(synonyms, (IOBase, bytes)):
            _content = synonyms
        else:
            _json = synonyms

        _request = build_authoring_update_synonyms_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_sources(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        # pylint: disable=line-too-long
        """Gets all the sources of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/get-sources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "sourceKind": "str",  # Supported source types. Required. Known values are:
                      "file" and "url".
                    "sourceUri": "str",  # URI location for the file or url. Required.
                    "contentStructureKind": "str",  # Optional. Content structure type for
                      sources. "unstructured"
                    "displayName": "str",  # Optional. Friendly name of the Source.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "source": "str"  # Optional. Unique source identifier. Name of the file if
                      it's a 'file' source; otherwise, the complete URL if it's a 'url' source.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_list_sources_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    def _update_sources_initial(
        self, project_name: str, sources: Union[List[JSON], IO[bytes]], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(sources, (IOBase, bytes)):
            _content = sources
        else:
            _json = sources

        _request = build_authoring_update_sources_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update_sources(
        self, project_name: str, sources: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[Iterable[JSON]]:
        # pylint: disable=line-too-long
        """Updates the sources of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-sources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param sources: Update sources parameters of a project. Required.
        :type sources: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns an iterator like instance of JSON object
        :rtype: ~azure.core.polling.LROPoller[~azure.core.paging.ItemPaged[JSON]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                sources = [
                    {
                        "op": "str",  # Update operation type for assets. Required. Known
                          values are: "add", "delete", and "replace".
                        "value": {
                            "sourceKind": "str",  # Supported source types. Required.
                              Known values are: "file" and "url".
                            "sourceUri": "str",  # URI location for the file or url.
                              Required.
                            "contentStructureKind": "str",  # Optional. Content structure
                              type for sources. "unstructured"
                            "displayName": "str",  # Optional. Friendly name of the
                              Source.
                            "refresh": bool,  # Optional. Boolean flag used to refresh
                              data from the Source.
                            "source": "str"  # Optional. Unique source identifier. Name
                              of the file if it's a 'file' source; otherwise, the complete URL if it's
                              a 'url' source.
                        }
                    }
                ]

                # response body for status code(s): 200, 202
                response == {
                    "sourceKind": "str",  # Supported source types. Required. Known values are:
                      "file" and "url".
                    "sourceUri": "str",  # URI location for the file or url. Required.
                    "contentStructureKind": "str",  # Optional. Content structure type for
                      sources. "unstructured"
                    "displayName": "str",  # Optional. Friendly name of the Source.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "source": "str"  # Optional. Unique source identifier. Name of the file if
                      it's a 'file' source; otherwise, the complete URL if it's a 'url' source.
                }
        """

    @overload
    def begin_update_sources(
        self, project_name: str, sources: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[Iterable[JSON]]:
        # pylint: disable=line-too-long
        """Updates the sources of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-sources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param sources: Update sources parameters of a project. Required.
        :type sources: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns an iterator like instance of JSON object
        :rtype: ~azure.core.polling.LROPoller[~azure.core.paging.ItemPaged[JSON]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 202
                response == {
                    "sourceKind": "str",  # Supported source types. Required. Known values are:
                      "file" and "url".
                    "sourceUri": "str",  # URI location for the file or url. Required.
                    "contentStructureKind": "str",  # Optional. Content structure type for
                      sources. "unstructured"
                    "displayName": "str",  # Optional. Friendly name of the Source.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "source": "str"  # Optional. Unique source identifier. Name of the file if
                      it's a 'file' source; otherwise, the complete URL if it's a 'url' source.
                }
        """

    @distributed_trace
    def begin_update_sources(
        self, project_name: str, sources: Union[List[JSON], IO[bytes]], **kwargs: Any
    ) -> LROPoller[Iterable[JSON]]:
        # pylint: disable=line-too-long
        """Updates the sources of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-sources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param sources: Update sources parameters of a project. Is either a [JSON] type or a IO[bytes]
         type. Required.
        :type sources: list[JSON] or IO[bytes]
        :return: An instance of LROPoller that returns an iterator like instance of JSON object
        :rtype: ~azure.core.polling.LROPoller[~azure.core.paging.ItemPaged[JSON]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 202
                response == {
                    "sourceKind": "str",  # Supported source types. Required. Known values are:
                      "file" and "url".
                    "sourceUri": "str",  # URI location for the file or url. Required.
                    "contentStructureKind": "str",  # Optional. Content structure type for
                      sources. "unstructured"
                    "displayName": "str",  # Optional. Friendly name of the Source.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "source": "str"  # Optional. Unique source identifier. Name of the file if
                      it's a 'file' source; otherwise, the complete URL if it's a 'url' source.
                }
        """

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(sources, (IOBase, bytes)):
            _content = sources
        else:
            _json = sources

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_update_sources_request(
                    project_name=project_name,
                    content_type=content_type,
                    api_version=self._config.api_version,
                    json=_json,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_sources_initial(
                project_name=project_name,
                sources=sources,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            def internal_get_next(next_link=None):
                if next_link is None:
                    return pipeline_response
                return get_next(next_link)

            return ItemPaged(internal_get_next, extract_data)

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[Iterable[JSON]].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[Iterable[JSON]](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_qnas(
        self,
        project_name: str,
        *,
        source: Optional[str] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        # pylint: disable=line-too-long
        """Gets all the QnAs of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/get-qnas
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword source: Source of the QnA. Default value is None.
        :paramtype source: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "activeLearningSuggestions": [
                        {
                            "clusterHead": "str",  # Optional. Question chosen as the
                              head of suggested questions cluster by Active Learning clustering
                              algorithm.
                            "suggestedQuestions": [
                                {
                                    "autoSuggestedCount": 0,  # Optional. The
                                      number of times the question was suggested automatically by the
                                      Active Learning algorithm.
                                    "question": "str",  # Optional. Question
                                      suggested by the Active Learning feature.
                                    "userSuggestedCount": 0  # Optional. The
                                      number of times the question was suggested explicitly by the
                                      user.
                                }
                            ]
                        }
                    ],
                    "answer": "str",  # Optional. Answer text.
                    "dialog": {
                        "isContextOnly": bool,  # Optional. To mark if a prompt is relevant
                          only with a previous question or not. If true, do not include this QnA as
                          answer for queries without context; otherwise, ignores context and includes
                          this QnA in answers.
                        "prompts": [
                            {
                                "displayOrder": 0,  # Optional. Index of the prompt.
                                  It is used for ordering of the prompts.
                                "displayText": "str",  # Optional. Text displayed to
                                  represent a follow up question prompt.
                                "qna": {
                                    "activeLearningSuggestions": [
                                        {
                                            "clusterHead": "str",  #
                                              Optional. Question chosen as the head of suggested
                                              questions cluster by Active Learning clustering
                                              algorithm.
                                            "suggestedQuestions": [
                                                {
                "autoSuggestedCount": 0,  # Optional. The number
                                                      of times the question was suggested automatically
                                                      by the Active Learning algorithm.
                                                    "question":
                                                      "str",  # Optional. Question suggested by the
                                                      Active Learning feature.
                "userSuggestedCount": 0  # Optional. The number
                                                      of times the question was suggested explicitly by
                                                      the user.
                                                }
                                            ]
                                        }
                                    ],
                                    "answer": "str",  # Optional. Answer text.
                                    "dialog": ...,
                                    "id": 0,  # Optional. Unique ID for the QnA.
                                    "metadata": {
                                        "str": "str"  # Optional. Metadata
                                          associated with the answer, useful to categorize or filter
                                          question answers.
                                    },
                                    "questions": [
                                        "str"  # Optional. List of questions
                                          associated with the answer.
                                    ],
                                    "source": "str"  # Optional. Source from
                                      which QnA was indexed e.g.
                                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                      .
                                },
                                "qnaId": 0  # Optional. ID of the QnA corresponding
                                  to the prompt.
                            }
                        ]
                    },
                    "id": 0,  # Optional. Unique ID for the QnA.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "metadata": {
                        "str": "str"  # Optional. Metadata associated with the answer, useful
                          to categorize or filter question answers.
                    },
                    "questions": [
                        "str"  # Optional. List of questions associated with the answer.
                    ],
                    "source": "str"  # Optional. Source from which QnA was indexed e.g.
                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs .
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_list_qnas_request(
                    project_name=project_name,
                    source=source,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    def _update_qnas_initial(
        self, project_name: str, qnas: Union[List[JSON], IO[bytes]], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(qnas, (IOBase, bytes)):
            _content = qnas
        else:
            _json = qnas

        _request = build_authoring_update_qnas_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update_qnas(
        self, project_name: str, qnas: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[Iterable[JSON]]:
        # pylint: disable=line-too-long
        """Updates the QnAs of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-qnas
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param qnas: Update QnAs parameters of a project. Required.
        :type qnas: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns an iterator like instance of JSON object
        :rtype: ~azure.core.polling.LROPoller[~azure.core.paging.ItemPaged[JSON]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                qnas = [
                    {
                        "op": "str",  # Update operation type for assets. Required. Known
                          values are: "add", "delete", and "replace".
                        "value": {
                            "activeLearningSuggestions": [
                                {
                                    "clusterHead": "str",  # Optional. Question
                                      chosen as the head of suggested questions cluster by Active
                                      Learning clustering algorithm.
                                    "suggestedQuestions": [
                                        {
                                            "autoSuggestedCount": 0,  #
                                              Optional. The number of times the question was suggested
                                              automatically by the Active Learning algorithm.
                                            "question": "str",  #
                                              Optional. Question suggested by the Active Learning
                                              feature.
                                            "userSuggestedCount": 0  #
                                              Optional. The number of times the question was suggested
                                              explicitly by the user.
                                        }
                                    ]
                                }
                            ],
                            "answer": "str",  # Optional. Answer text.
                            "dialog": {
                                "isContextOnly": bool,  # Optional. To mark if a
                                  prompt is relevant only with a previous question or not. If true, do
                                  not include this QnA as answer for queries without context;
                                  otherwise, ignores context and includes this QnA in answers.
                                "prompts": [
                                    {
                                        "displayOrder": 0,  # Optional. Index
                                          of the prompt. It is used for ordering of the prompts.
                                        "displayText": "str",  # Optional.
                                          Text displayed to represent a follow up question prompt.
                                        "qna": ...,
                                        "qnaId": 0  # Optional. ID of the QnA
                                          corresponding to the prompt.
                                    }
                                ]
                            },
                            "id": 0,  # Optional. Unique ID for the QnA.
                            "metadata": {
                                "str": "str"  # Optional. Metadata associated with
                                  the answer, useful to categorize or filter question answers.
                            },
                            "questions": [
                                "str"  # Optional. List of questions associated with
                                  the answer.
                            ],
                            "source": "str"  # Optional. Source from which QnA was
                              indexed e.g.
                              https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs .
                        }
                    }
                ]

                # response body for status code(s): 200, 202
                response == {
                    "activeLearningSuggestions": [
                        {
                            "clusterHead": "str",  # Optional. Question chosen as the
                              head of suggested questions cluster by Active Learning clustering
                              algorithm.
                            "suggestedQuestions": [
                                {
                                    "autoSuggestedCount": 0,  # Optional. The
                                      number of times the question was suggested automatically by the
                                      Active Learning algorithm.
                                    "question": "str",  # Optional. Question
                                      suggested by the Active Learning feature.
                                    "userSuggestedCount": 0  # Optional. The
                                      number of times the question was suggested explicitly by the
                                      user.
                                }
                            ]
                        }
                    ],
                    "answer": "str",  # Optional. Answer text.
                    "dialog": {
                        "isContextOnly": bool,  # Optional. To mark if a prompt is relevant
                          only with a previous question or not. If true, do not include this QnA as
                          answer for queries without context; otherwise, ignores context and includes
                          this QnA in answers.
                        "prompts": [
                            {
                                "displayOrder": 0,  # Optional. Index of the prompt.
                                  It is used for ordering of the prompts.
                                "displayText": "str",  # Optional. Text displayed to
                                  represent a follow up question prompt.
                                "qna": {
                                    "activeLearningSuggestions": [
                                        {
                                            "clusterHead": "str",  #
                                              Optional. Question chosen as the head of suggested
                                              questions cluster by Active Learning clustering
                                              algorithm.
                                            "suggestedQuestions": [
                                                {
                "autoSuggestedCount": 0,  # Optional. The number
                                                      of times the question was suggested automatically
                                                      by the Active Learning algorithm.
                                                    "question":
                                                      "str",  # Optional. Question suggested by the
                                                      Active Learning feature.
                "userSuggestedCount": 0  # Optional. The number
                                                      of times the question was suggested explicitly by
                                                      the user.
                                                }
                                            ]
                                        }
                                    ],
                                    "answer": "str",  # Optional. Answer text.
                                    "dialog": ...,
                                    "id": 0,  # Optional. Unique ID for the QnA.
                                    "metadata": {
                                        "str": "str"  # Optional. Metadata
                                          associated with the answer, useful to categorize or filter
                                          question answers.
                                    },
                                    "questions": [
                                        "str"  # Optional. List of questions
                                          associated with the answer.
                                    ],
                                    "source": "str"  # Optional. Source from
                                      which QnA was indexed e.g.
                                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                      .
                                },
                                "qnaId": 0  # Optional. ID of the QnA corresponding
                                  to the prompt.
                            }
                        ]
                    },
                    "id": 0,  # Optional. Unique ID for the QnA.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "metadata": {
                        "str": "str"  # Optional. Metadata associated with the answer, useful
                          to categorize or filter question answers.
                    },
                    "questions": [
                        "str"  # Optional. List of questions associated with the answer.
                    ],
                    "source": "str"  # Optional. Source from which QnA was indexed e.g.
                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs .
                }
        """

    @overload
    def begin_update_qnas(
        self, project_name: str, qnas: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[Iterable[JSON]]:
        # pylint: disable=line-too-long
        """Updates the QnAs of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-qnas
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param qnas: Update QnAs parameters of a project. Required.
        :type qnas: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns an iterator like instance of JSON object
        :rtype: ~azure.core.polling.LROPoller[~azure.core.paging.ItemPaged[JSON]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 202
                response == {
                    "activeLearningSuggestions": [
                        {
                            "clusterHead": "str",  # Optional. Question chosen as the
                              head of suggested questions cluster by Active Learning clustering
                              algorithm.
                            "suggestedQuestions": [
                                {
                                    "autoSuggestedCount": 0,  # Optional. The
                                      number of times the question was suggested automatically by the
                                      Active Learning algorithm.
                                    "question": "str",  # Optional. Question
                                      suggested by the Active Learning feature.
                                    "userSuggestedCount": 0  # Optional. The
                                      number of times the question was suggested explicitly by the
                                      user.
                                }
                            ]
                        }
                    ],
                    "answer": "str",  # Optional. Answer text.
                    "dialog": {
                        "isContextOnly": bool,  # Optional. To mark if a prompt is relevant
                          only with a previous question or not. If true, do not include this QnA as
                          answer for queries without context; otherwise, ignores context and includes
                          this QnA in answers.
                        "prompts": [
                            {
                                "displayOrder": 0,  # Optional. Index of the prompt.
                                  It is used for ordering of the prompts.
                                "displayText": "str",  # Optional. Text displayed to
                                  represent a follow up question prompt.
                                "qna": {
                                    "activeLearningSuggestions": [
                                        {
                                            "clusterHead": "str",  #
                                              Optional. Question chosen as the head of suggested
                                              questions cluster by Active Learning clustering
                                              algorithm.
                                            "suggestedQuestions": [
                                                {
                "autoSuggestedCount": 0,  # Optional. The number
                                                      of times the question was suggested automatically
                                                      by the Active Learning algorithm.
                                                    "question":
                                                      "str",  # Optional. Question suggested by the
                                                      Active Learning feature.
                "userSuggestedCount": 0  # Optional. The number
                                                      of times the question was suggested explicitly by
                                                      the user.
                                                }
                                            ]
                                        }
                                    ],
                                    "answer": "str",  # Optional. Answer text.
                                    "dialog": ...,
                                    "id": 0,  # Optional. Unique ID for the QnA.
                                    "metadata": {
                                        "str": "str"  # Optional. Metadata
                                          associated with the answer, useful to categorize or filter
                                          question answers.
                                    },
                                    "questions": [
                                        "str"  # Optional. List of questions
                                          associated with the answer.
                                    ],
                                    "source": "str"  # Optional. Source from
                                      which QnA was indexed e.g.
                                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                      .
                                },
                                "qnaId": 0  # Optional. ID of the QnA corresponding
                                  to the prompt.
                            }
                        ]
                    },
                    "id": 0,  # Optional. Unique ID for the QnA.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "metadata": {
                        "str": "str"  # Optional. Metadata associated with the answer, useful
                          to categorize or filter question answers.
                    },
                    "questions": [
                        "str"  # Optional. List of questions associated with the answer.
                    ],
                    "source": "str"  # Optional. Source from which QnA was indexed e.g.
                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs .
                }
        """

    @distributed_trace
    def begin_update_qnas(
        self, project_name: str, qnas: Union[List[JSON], IO[bytes]], **kwargs: Any
    ) -> LROPoller[Iterable[JSON]]:
        # pylint: disable=line-too-long
        """Updates the QnAs of a project.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/update-qnas
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param qnas: Update QnAs parameters of a project. Is either a [JSON] type or a IO[bytes] type.
         Required.
        :type qnas: list[JSON] or IO[bytes]
        :return: An instance of LROPoller that returns an iterator like instance of JSON object
        :rtype: ~azure.core.polling.LROPoller[~azure.core.paging.ItemPaged[JSON]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 202
                response == {
                    "activeLearningSuggestions": [
                        {
                            "clusterHead": "str",  # Optional. Question chosen as the
                              head of suggested questions cluster by Active Learning clustering
                              algorithm.
                            "suggestedQuestions": [
                                {
                                    "autoSuggestedCount": 0,  # Optional. The
                                      number of times the question was suggested automatically by the
                                      Active Learning algorithm.
                                    "question": "str",  # Optional. Question
                                      suggested by the Active Learning feature.
                                    "userSuggestedCount": 0  # Optional. The
                                      number of times the question was suggested explicitly by the
                                      user.
                                }
                            ]
                        }
                    ],
                    "answer": "str",  # Optional. Answer text.
                    "dialog": {
                        "isContextOnly": bool,  # Optional. To mark if a prompt is relevant
                          only with a previous question or not. If true, do not include this QnA as
                          answer for queries without context; otherwise, ignores context and includes
                          this QnA in answers.
                        "prompts": [
                            {
                                "displayOrder": 0,  # Optional. Index of the prompt.
                                  It is used for ordering of the prompts.
                                "displayText": "str",  # Optional. Text displayed to
                                  represent a follow up question prompt.
                                "qna": {
                                    "activeLearningSuggestions": [
                                        {
                                            "clusterHead": "str",  #
                                              Optional. Question chosen as the head of suggested
                                              questions cluster by Active Learning clustering
                                              algorithm.
                                            "suggestedQuestions": [
                                                {
                "autoSuggestedCount": 0,  # Optional. The number
                                                      of times the question was suggested automatically
                                                      by the Active Learning algorithm.
                                                    "question":
                                                      "str",  # Optional. Question suggested by the
                                                      Active Learning feature.
                "userSuggestedCount": 0  # Optional. The number
                                                      of times the question was suggested explicitly by
                                                      the user.
                                                }
                                            ]
                                        }
                                    ],
                                    "answer": "str",  # Optional. Answer text.
                                    "dialog": ...,
                                    "id": 0,  # Optional. Unique ID for the QnA.
                                    "metadata": {
                                        "str": "str"  # Optional. Metadata
                                          associated with the answer, useful to categorize or filter
                                          question answers.
                                    },
                                    "questions": [
                                        "str"  # Optional. List of questions
                                          associated with the answer.
                                    ],
                                    "source": "str"  # Optional. Source from
                                      which QnA was indexed e.g.
                                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs
                                      .
                                },
                                "qnaId": 0  # Optional. ID of the QnA corresponding
                                  to the prompt.
                            }
                        ]
                    },
                    "id": 0,  # Optional. Unique ID for the QnA.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when the
                      QnA was last updated.
                    "metadata": {
                        "str": "str"  # Optional. Metadata associated with the answer, useful
                          to categorize or filter question answers.
                    },
                    "questions": [
                        "str"  # Optional. List of questions associated with the answer.
                    ],
                    "source": "str"  # Optional. Source from which QnA was indexed e.g.
                      https://learn.microsoft.com/azure/cognitive-services/QnAMaker/FAQs .
                }
        """

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(qnas, (IOBase, bytes)):
            _content = qnas
        else:
            _json = qnas

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_authoring_update_qnas_request(
                    project_name=project_name,
                    content_type=content_type,
                    api_version=self._config.api_version,
                    json=_json,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_qnas_initial(
                project_name=project_name,
                qnas=qnas,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            def internal_get_next(next_link=None):
                if next_link is None:
                    return pipeline_response
                return get_next(next_link)

            return ItemPaged(internal_get_next, extract_data)

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[Iterable[JSON]].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[Iterable[JSON]](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    def add_feedback(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, feedback: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/add-feedback
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param feedback: Feedback for Active Learning. Required.
        :type feedback: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                feedback = {
                    "records": [
                        {
                            "qnaId": 0,  # Optional. Unique ID of the QnA.
                            "userId": "str",  # Optional. Unique identifier of the user.
                            "userQuestion": "str"  # Optional. User suggested question
                              for the QnA.
                        }
                    ]
                }
        """

    @overload
    def add_feedback(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, feedback: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/add-feedback
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param feedback: Feedback for Active Learning. Required.
        :type feedback: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def add_feedback(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, feedback: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        See
        https://learn.microsoft.com/rest/api/cognitiveservices/questionanswering/question-answering-projects/add-feedback
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param feedback: Feedback for Active Learning. Is either a JSON type or a IO[bytes] type.
         Required.
        :type feedback: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                feedback = {
                    "records": [
                        {
                            "qnaId": 0,  # Optional. Unique ID of the QnA.
                            "userId": "str",  # Optional. Unique identifier of the user.
                            "userQuestion": "str"  # Optional. User suggested question
                              for the QnA.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(feedback, (IOBase, bytes)):
            _content = feedback
        else:
            _json = feedback

        _request = build_authoring_add_feedback_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
