/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import moveProperty = require( './index' );


// TESTS //

// The function returns a boolean...
{
	moveProperty( { 'a': 'b' }, 'a', {} ); // $ExpectType boolean
	moveProperty( { 'a': 'b' }, 'a', {} ); // $ExpectType boolean
}

// The compiler throws an error if the function is not provided a string as its second argument...
{
	moveProperty( { 'a': 'b' }, true, {} ); // $ExpectError
	moveProperty( { 'a': 'b' }, 3.12, {} ); // $ExpectError
	moveProperty( { 'a': 'b' }, false, {} ); // $ExpectError
	moveProperty( { 'a': 'b' }, ( x: number ): number => x, {} ); // $ExpectError
	moveProperty( { 'a': 'b' }, [], {} ); // $ExpectError
	moveProperty( { 'a': 'b' }, {}, {} ); // $ExpectError
}

// The compiler throws an error if the function is provided an incorrect number of arguments...
{
	moveProperty(); // $ExpectError
	moveProperty( { 'a': 'b' } ); // $ExpectError
	moveProperty( { 'a': 'b' }, 'a' ); // $ExpectError
	moveProperty( { 'a': 'b' }, 'a', {}, 3.12 ); // $ExpectError
}
