/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.RoleUpdateAssumePolicyRequest;
import com.amazonaws.services.auth.identity.cli.policy.PolicyBuilder;
import com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMRoleUpdateAssumePolicyDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMRoleUpdateAssumePolicyDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof RoleUpdateAssumePolicyRequest) {
            RoleUpdateAssumePolicyRequest req = (RoleUpdateAssumePolicyRequest)request;
            String policy = null;
            if (req.getPolicyFile() == null && req.getService() == null) {
                Utils.exit(1, "must specify a service or a policy document to upload", null);
            } else if (!(req.getPolicyFile() == null ^ req.getService() == null)) {
                Utils.exit(1, "can specify only one of -f -s", null);
            }
            UpdateAssumeRolePolicyRequest updateAssumeRolePolicyRequest = new UpdateAssumeRolePolicyRequest();
            updateAssumeRolePolicyRequest.setRoleName(req.getRoleName());
            if (req.getService() != null) {
                policy = PolicyBuilder.buildAssumeRolePolicy(req.getService());
            } else {
                policy = Utils.readFile(req.getPolicyFile());
                LOG.debug((Object)("Policy document from file is: " + policy));
            }
            updateAssumeRolePolicyRequest.setPolicyDocument(policy);
            LOG.debug((Object)("Updating assume role policy with request: " + request));
            this.getClient().updateAssumeRolePolicy(updateAssumeRolePolicyRequest);
            if (req.isVerbose()) {
                LOG.info((Object)policy);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

