
state lang_html
{
  BEGIN {
    /* RGB -> HTML color mapper function. */
    sub map_color (r, g, b)
      {
	return sprintf ("#%02X%02X%02X", r, g, b);
      }

    LANGUAGE_SPECIALS = /[<>\&\"]/;

    sub language_print (str)
      {
	str = regsuball (str, /\&/, "&amp;");
	str = regsuball (str, /</, "&lt;");
	str = regsuball (str, />/, "&gt;");
	str = regsuball (str, /\"/, "&quot;");
	print (str);
      }

    sub language_symbol (symbol)
      {
	return false;
      }

    sub header ()
      {
	local i;

	if (current_input_file == 1)
	  {
	    print ("<!DOCTYPE html PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n");
	    print ("<HTML>\n<HEAD>\n<TITLE>");
	    language_print (document_title);
	    print ("</TITLE>\n</HEAD>\n",
		   color
		   ? "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#1F00FF\" ALINK=\"#FF0000\" VLINK=\"#9900DD\">"
		   : "<BODY>",
		   "\n<A NAME=\"top\">\n");

	    if (need_version (1, 5, 1) && int (toc) == 1)
	      {
		if (length (argv) == 0)
		  argv[0] = "(stdin)";

		print ("<H1>Contents</H1>\n<OL>\n");
		for (i = 0; i < length (argv); i = i + 1)
		  print ("  <LI><A HREF=\"#file", i + 1, "\">", argv[i],
			 "</A>\n");
		print ("</OL>\n<HR>\n");
	      }
	  }

	print ("<A NAME=\"file", current_input_file, "\">\n<H1>");
	language_print (filename);

	if (int (num_input_files) > 1)
	  print (" ", current_input_file, "/", num_input_files);

	print ("</H1>\n");

	/* Navigation bar. */
	if (need_version (1, 5, 1))
	  {
	    if (length (argv) >= 2 )
	      {
		print ("[<A HREF=\"#top\">top</A>]");

		if (current_input_file == 1)
		  print ("[prev]");
		else
		  print ("[<A HREF=\"\#file", current_input_file - 1,
			 "\">prev</A>]");

		if (current_input_file == length (argv))
		  print ("[next]");
		else
		  print ("[<A HREF=\"#file", current_input_file + 1,
			 "\">next</A>]");
	      }
	  }
	else
	  print ("[<A HREF=\"#top\">top</A>]");
	print ("\n<PRE>\n");
      }

    sub trailer ()
      {
	print ("</PRE>
<HR>\n");
	if (current_input_file == int (num_input_files))
	  print ("<ADDRESS>Generated by ",
		 "<A HREF=\"http://www.iki.fi/~mtr/genscript/\">",
		 substring (version, strchr (version, 'G'), length (version)),
		 "</A>.</ADDRESS>
</BODY>
</HTML>\n");
      }

    sub face_on (face)
      {
	if (face[boldp])
	  print ("<B>");
	if (face[italicp])
	  print ("<I>");

	if (face[fg_color])
	  print ("<FONT COLOR=\"", face[fg_color], "\">");
	/* The background color is not supported in HTML. */
      }

    sub face_off (face)
      {
	if (face[fg_color])
	  print ("</FONT>");

	if (face[italicp])
	  print ("</I>");
	if (face[boldp])
	  print ("</B>");
      }

    return;
  }
}


/*
Local variables:
mode: c
End:
*/
