# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cognitiveservices import CognitiveServicesManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCognitiveServicesManagementAccountCapabilityHostsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CognitiveServicesManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_account_capability_hosts_begin_delete(self, resource_group):
        response = self.client.account_capability_hosts.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            capability_host_name="str",
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_account_capability_hosts_get(self, resource_group):
        response = self.client.account_capability_hosts.get(
            resource_group_name=resource_group.name,
            account_name="str",
            capability_host_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_account_capability_hosts_begin_create_or_update(self, resource_group):
        response = self.client.account_capability_hosts.begin_create_or_update(
            resource_group_name=resource_group.name,
            account_name="str",
            capability_host_name="str",
            body={
                "properties": {
                    "aiServicesConnections": ["str"],
                    "capabilityHostKind": "str",
                    "customerSubnet": "str",
                    "description": "str",
                    "provisioningState": "str",
                    "storageConnections": ["str"],
                    "tags": {"str": "str"},
                    "threadStorageConnections": ["str"],
                    "vectorStoreConnections": ["str"],
                },
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
