/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import pow = require( './index' );


// TESTS //

// The function returns a number...
{
	pow( 8, 2 ); // $ExpectType number
}

// The function does not compile if provided values other than two numbers...
{
	pow( true, 3 ); // $ExpectError
	pow( false, 2 ); // $ExpectError
	pow( '5', 1 ); // $ExpectError
	pow( [], 1 ); // $ExpectError
	pow( {}, 2 ); // $ExpectError
	pow( ( x: number ): number => x, 2 ); // $ExpectError

	pow( 9, true ); // $ExpectError
	pow( 9, false ); // $ExpectError
	pow( 5, '5' ); // $ExpectError
	pow( 8, [] ); // $ExpectError
	pow( 9, {} ); // $ExpectError
	pow( 8, ( x: number ): number => x ); // $ExpectError

	pow( [], true ); // $ExpectError
	pow( {}, false ); // $ExpectError
	pow( false, '5' ); // $ExpectError
	pow( {}, [] ); // $ExpectError
	pow( '5', ( x: number ): number => x ); // $ExpectError
}

// The function does not compile if provided insufficient arguments...
{
	pow(); // $ExpectError
	pow( 3 ); // $ExpectError
}
