<!--

@license Apache-2.0

Copyright (c) 2021 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Constants

> 32-bit unsigned integer mathematical constants.

<section class="usage">

## Usage

```javascript
var constants = require( '@stdlib/constants/uint32' );
```

#### constants

32-bit unsigned integer mathematical constants.

```javascript
var c = constants;
// returns {...}
```

<!-- <toc pattern="*" > -->

<div class="namespace-toc">

-   <span class="signature">[`MAX`][@stdlib/constants/uint32/max]</span><span class="delimiter">: </span><span class="description">maximum unsigned 32-bit integer.</span>
-   <span class="signature">[`NUM_BYTES`][@stdlib/constants/uint32/num-bytes]</span><span class="delimiter">: </span><span class="description">size (in bytes) of a 32-bit unsigned integer.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var constants = require( '@stdlib/constants/uint32' );

console.log( objectKeys( constants ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/constants/uint32/max]: https://github.com/stdlib-js/constants/tree/main/uint32/max

[@stdlib/constants/uint32/num-bytes]: https://github.com/stdlib-js/constants/tree/main/uint32/num-bytes

<!-- </toc-links> -->

</section>

<!-- /.links -->
