/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.digest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.logging.Logger;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.digest.DigestMD5Base;

public final class DigestMD5Server
extends DigestMD5Base
implements SaslServer {
    private static final String MY_CLASS_NAME = DigestMD5Server.class.getName();
    private static final String UTF8_DIRECTIVE = "charset=utf-8,";
    private static final String ALGORITHM_DIRECTIVE = "algorithm=md5-sess";
    private static final Logger log = Logger.getLogger((String)"org.jboss.sasl.digest.server");
    private static final int NONCE_COUNT_VALUE = 1;
    private static final String UTF8_PROPERTY = "com.sun.security.sasl.digest.utf8";
    private static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    private static final String[] DIRECTIVE_KEY = new String[]{"username", "realm", "nonce", "cnonce", "nonce-count", "qop", "digest-uri", "response", "maxbuf", "charset", "cipher", "authzid", "auth-param"};
    private static final int USERNAME = 0;
    private static final int REALM = 1;
    private static final int NONCE = 2;
    private static final int CNONCE = 3;
    private static final int NONCE_COUNT = 4;
    private static final int QOP = 5;
    private static final int DIGEST_URI = 6;
    private static final int RESPONSE = 7;
    private static final int MAXBUF = 8;
    private static final int CHARSET = 9;
    private static final int CIPHER = 10;
    private static final int AUTHZID = 11;
    private String specifiedQops;
    private byte[] myCiphers;
    private List<String> serverRealms = new ArrayList<String>();
    private boolean preDigestedPasswords;

    DigestMD5Server(String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        super(props, MY_CLASS_NAME, 1, protocol + "/" + serverName, cbh);
        this.useUTF8 = true;
        this.preDigestedPasswords = false;
        if (props != null) {
            String realms;
            this.specifiedQops = (String)props.get("javax.security.sasl.qop");
            if ("false".equals((String)props.get(UTF8_PROPERTY))) {
                this.useUTF8 = false;
                log.trace((Object)"Server supports ISO-Latin-1");
            }
            if ((realms = (String)props.get(REALM_PROPERTY)) != null) {
                StringTokenizer parser = new StringTokenizer(realms, ", \t\n");
                int tokenCount = parser.countTokens();
                String token = null;
                for (int i = 0; i < tokenCount; ++i) {
                    token = parser.nextToken();
                    log.tracef("Server supports realm %s", (Object)token);
                    this.serverRealms.add(token);
                }
            }
            if (props.containsKey("org.jboss.sasl.digest.pre_digested")) {
                this.preDigestedPasswords = Boolean.parseBoolean(String.valueOf(props.get("org.jboss.sasl.digest.pre_digested")));
                log.tracef("Server using pre-digested hashes (%B)", (Object)this.preDigestedPasswords);
            }
        }
        String string = this.encoding = this.useUTF8 ? "UTF8" : "8859_1";
        if (this.serverRealms.size() == 0) {
            this.serverRealms.add(serverName);
        }
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response.length > 4096) {
            throw new SaslException("DIGEST-MD5: Invalid digest response length. Got:  " + response.length + " Expected < " + 4096);
        }
        switch (this.step) {
            case 1: {
                if (response.length != 0) {
                    throw new SaslException("DIGEST-MD5 must not have an initial response");
                }
                String supportedCiphers = null;
                if ((this.allQop & 4) != 0) {
                    this.myCiphers = DigestMD5Server.getPlatformCiphers();
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < CIPHER_TOKENS.length; ++i) {
                        if (this.myCiphers[i] == 0) continue;
                        if (buf.length() > 0) {
                            buf.append(',');
                        }
                        buf.append(CIPHER_TOKENS[i]);
                    }
                    supportedCiphers = buf.toString();
                }
                try {
                    byte[] challenge = this.generateChallenge(this.serverRealms, this.specifiedQops, supportedCiphers);
                    this.step = 3;
                    return challenge;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SaslException("DIGEST-MD5: Error encoding challenge", e);
                }
                catch (IOException e) {
                    throw new SaslException("DIGEST-MD5: Error generating challenge", e);
                }
            }
            case 3: {
                byte[] challenge;
                try {
                    byte[][] responseVal = DigestMD5Server.parseDirectives(response, DIRECTIVE_KEY, null, 1);
                    challenge = this.validateClientResponse(responseVal);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SaslException("DIGEST-MD5: Error validating client response", e);
                }
                finally {
                    this.step = 0;
                }
                this.completed = true;
                if (this.integrity && this.privacy) {
                    this.secCtx = new DigestMD5Base.DigestPrivacy(false);
                } else if (this.integrity) {
                    this.secCtx = new DigestMD5Base.DigestIntegrity(false);
                }
                return challenge;
            }
        }
        throw new SaslException("DIGEST-MD5: Server at illegal state");
    }

    private byte[] generateChallenge(List<String> realms, String qopStr, String cipherStr) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; realms != null && i < realms.size(); ++i) {
            out.write("realm=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(out, realms.get(i).getBytes(this.encoding));
            out.write(34);
            out.write(44);
        }
        out.write("nonce=\"".getBytes(this.encoding));
        this.nonce = DigestMD5Server.generateNonce();
        DigestMD5Server.writeQuotedStringValue(out, this.nonce);
        out.write(34);
        out.write(44);
        if (qopStr != null) {
            out.write("qop=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(out, qopStr.getBytes(this.encoding));
            out.write(34);
            out.write(44);
        }
        if (this.recvMaxBufSize != 65536) {
            out.write(("maxbuf=\"" + this.recvMaxBufSize + "\",").getBytes(this.encoding));
        }
        if (this.useUTF8) {
            out.write(UTF8_DIRECTIVE.getBytes(this.encoding));
        }
        if (cipherStr != null) {
            out.write("cipher=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(out, cipherStr.getBytes(this.encoding));
            out.write(34);
            out.write(44);
        }
        out.write(ALGORITHM_DIRECTIVE.getBytes(this.encoding));
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] validateClientResponse(byte[][] responseVal) throws SaslException, UnsupportedEncodingException {
        byte[] byArray;
        block53: {
            byte[] userRealmPasswd;
            block51: {
                char[] passwd;
                byte[] authzidBytes;
                byte[] cnonce;
                String username;
                block49: {
                    block52: {
                        block50: {
                            byte[] expectedResponse;
                            String authzidFromClient;
                            String digestUriFromResponse;
                            int cQop;
                            if (!(responseVal[9] == null || this.useUTF8 && "utf-8".equals(new String(responseVal[9], this.encoding)))) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Incompatible charset value: " + new String(responseVal[9]));
                            }
                            int clntMaxBufSize = responseVal[8] == null ? 65536 : Integer.parseInt(new String(responseVal[8], this.encoding));
                            int n = this.sendMaxBufSize = this.sendMaxBufSize == 0 ? clntMaxBufSize : Math.min(this.sendMaxBufSize, clntMaxBufSize);
                            if (responseVal[0] == null) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Missing username.");
                            }
                            username = new String(responseVal[0], this.encoding);
                            log.tracef("Username: %s", (Object)username);
                            this.negotiatedRealm = responseVal[1] != null ? new String(responseVal[1], this.encoding) : "";
                            log.tracef("Client negotiated realm: %s", (Object)this.negotiatedRealm);
                            if (!this.serverRealms.contains(this.negotiatedRealm)) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Nonexistent realm: " + this.negotiatedRealm);
                            }
                            if (responseVal[2] == null) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Missing nonce.");
                            }
                            byte[] nonceFromClient = responseVal[2];
                            if (!Arrays.equals(nonceFromClient, this.nonce)) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched nonce.");
                            }
                            if (responseVal[3] == null) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Missing cnonce.");
                            }
                            cnonce = responseVal[3];
                            if (responseVal[4] != null && 1 != Integer.parseInt(new String(responseVal[4], this.encoding), 16)) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Nonce count does not match: " + new String(responseVal[4]));
                            }
                            this.negotiatedQop = responseVal[5] != null ? new String(responseVal[5], this.encoding) : "auth";
                            log.tracef("Client negotiated qop: %s", (Object)this.negotiatedQop);
                            if (this.negotiatedQop.equals("auth")) {
                                cQop = 1;
                            } else if (this.negotiatedQop.equals("auth-int")) {
                                cQop = 2;
                                this.integrity = true;
                                this.rawSendSize = this.sendMaxBufSize - 16;
                            } else if (this.negotiatedQop.equals("auth-conf")) {
                                cQop = 4;
                                this.privacy = true;
                                this.integrity = true;
                                this.rawSendSize = this.sendMaxBufSize - 26;
                            } else {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Invalid QOP: " + this.negotiatedQop);
                            }
                            if ((cQop & this.allQop) == 0) {
                                throw new SaslException("DIGEST-MD5: server does not support  qop: " + this.negotiatedQop);
                            }
                            if (this.privacy) {
                                String string = this.negotiatedCipher = responseVal[10] != null ? new String(responseVal[10], this.encoding) : null;
                                if (this.negotiatedCipher == null) {
                                    throw new SaslException("DIGEST-MD5: digest response format violation. No cipher specified.");
                                }
                                int foundCipher = -1;
                                log.tracef("Client negotiated cipher: %s", (Object)this.negotiatedCipher);
                                for (int j = 0; j < CIPHER_TOKENS.length; ++j) {
                                    if (!this.negotiatedCipher.equals(CIPHER_TOKENS[j]) || this.myCiphers[j] == 0) continue;
                                    foundCipher = j;
                                    break;
                                }
                                if (foundCipher == -1) {
                                    throw new SaslException("DIGEST-MD5: server does not support cipher: " + this.negotiatedCipher);
                                }
                                this.negotiatedStrength = (CIPHER_MASKS[foundCipher] & 4) != 0 ? "high" : ((CIPHER_MASKS[foundCipher] & 2) != 0 ? "medium" : "low");
                                log.tracef("Negotiated strength: %s", (Object)this.negotiatedStrength);
                            }
                            String string = digestUriFromResponse = responseVal[6] != null ? new String(responseVal[6], this.encoding) : null;
                            if (digestUriFromResponse != null) {
                                log.tracef("DIGEST87:digest URI: %s", (Object)digestUriFromResponse);
                            }
                            if (!this.digestUri.equalsIgnoreCase(digestUriFromResponse)) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched URI: " + digestUriFromResponse + "; expecting: " + this.digestUri);
                            }
                            this.digestUri = digestUriFromResponse;
                            byte[] responseFromClient = responseVal[7];
                            if (responseFromClient == null) {
                                throw new SaslException("DIGEST-MD5: digest response format  violation. Missing response.");
                            }
                            authzidBytes = responseVal[11];
                            String string2 = authzidFromClient = authzidBytes != null ? new String(authzidBytes, this.encoding) : username;
                            if (authzidBytes != null) {
                                log.tracef("Authzid: %s", (Object)new String(authzidBytes));
                            }
                            passwd = null;
                            userRealmPasswd = null;
                            try {
                                RealmCallback rcb = new RealmCallback("DIGEST-MD5 realm: ", this.negotiatedRealm);
                                NameCallback ncb = new NameCallback("DIGEST-MD5 authentication ID: ", username);
                                if (this.preDigestedPasswords) {
                                    DigestHashCallback dcb = new DigestHashCallback("DIGEST-MD5 { username : realm : password } hash.");
                                    this.cbh.handle(new Callback[]{rcb, ncb, dcb});
                                    userRealmPasswd = dcb.getHash();
                                    dcb.setHash(null);
                                } else {
                                    PasswordCallback pcb = new PasswordCallback("DIGEST-MD5 password: ", false);
                                    this.cbh.handle(new Callback[]{rcb, ncb, pcb});
                                    passwd = pcb.getPassword();
                                    pcb.clearPassword();
                                }
                            }
                            catch (UnsupportedCallbackException e) {
                                throw new SaslException("DIGEST-MD5: Cannot perform callback to acquire password", e);
                            }
                            catch (IOException e) {
                                throw new SaslException("DIGEST-MD5: IO error acquiring password", e);
                            }
                            if (!this.preDigestedPasswords && passwd == null) {
                                throw new SaslException("DIGEST-MD5: cannot acquire password for " + username + " in realm : " + this.negotiatedRealm);
                            }
                            if (this.preDigestedPasswords && userRealmPasswd == null) {
                                throw new SaslException("DIGEST-MD5: cannot acquire hash for " + username + " in realm : " + this.negotiatedRealm);
                            }
                            try {
                                expectedResponse = this.preDigestedPasswords ? this.generateResponseValue("AUTHENTICATE", this.digestUri, this.negotiatedQop, userRealmPasswd, this.nonce, cnonce, 1, authzidBytes) : this.generateResponseValue("AUTHENTICATE", this.digestUri, this.negotiatedQop, username, this.negotiatedRealm, passwd, this.nonce, cnonce, 1, authzidBytes);
                            }
                            catch (NoSuchAlgorithmException e) {
                                throw new SaslException("DIGEST-MD5: problem duplicating client response", e);
                            }
                            catch (IOException e) {
                                throw new SaslException("DIGEST-MD5: problem duplicating client response", e);
                            }
                            if (!Arrays.equals(responseFromClient, expectedResponse)) {
                                throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched response.");
                            }
                            try {
                                AuthorizeCallback acb = new AuthorizeCallback(username, authzidFromClient);
                                this.cbh.handle(new Callback[]{acb});
                                if (!acb.isAuthorized()) {
                                    throw new SaslException("DIGEST-MD5: " + username + " is not authorized to act as " + authzidFromClient);
                                }
                                this.authzid = acb.getAuthorizedID();
                            }
                            catch (SaslException e) {
                                throw e;
                            }
                            catch (UnsupportedCallbackException e) {
                                throw new SaslException("DIGEST-MD5: Cannot perform callback to check authzid", e);
                            }
                            catch (IOException e) {
                                throw new SaslException("DIGEST-MD5: IO error checking authzid", e);
                            }
                            if (!this.preDigestedPasswords) break block49;
                            byArray = this.generateResponseAuth(userRealmPasswd, cnonce, 1, authzidBytes);
                            if (passwd == null) break block50;
                            for (int i = 0; i < passwd.length; ++i) {
                                passwd[i] = '\u0000';
                            }
                            break block52;
                        }
                        if (userRealmPasswd != null) {
                            for (int i = 0; i < userRealmPasswd.length; ++i) {
                                userRealmPasswd[i] = 0;
                            }
                        }
                    }
                    return byArray;
                }
                try {
                    byArray = this.generateResponseAuth(username, passwd, cnonce, 1, authzidBytes);
                    if (passwd == null) break block51;
                }
                catch (Throwable throwable) {
                    block55: {
                        block54: {
                            if (passwd == null) break block54;
                            for (int i = 0; i < passwd.length; ++i) {
                                passwd[i] = '\u0000';
                            }
                            break block55;
                        }
                        if (userRealmPasswd == null) break block55;
                        for (int i = 0; i < userRealmPasswd.length; ++i) {
                            userRealmPasswd[i] = 0;
                        }
                    }
                    throw throwable;
                }
                for (int i = 0; i < passwd.length; ++i) {
                    passwd[i] = '\u0000';
                }
                break block53;
            }
            if (userRealmPasswd != null) {
                for (int i = 0; i < userRealmPasswd.length; ++i) {
                    userRealmPasswd[i] = 0;
                }
            }
        }
        return byArray;
    }

    private byte[] generateResponseAuth(String username, char[] passwd, byte[] cnonce, int nonceCount, byte[] authzidBytes) throws SaslException {
        try {
            byte[] responseValue = this.generateResponseValue("", this.digestUri, this.negotiatedQop, username, this.negotiatedRealm, passwd, this.nonce, cnonce, nonceCount, authzidBytes);
            return this.generateChallenge(responseValue);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("DIGEST-MD5: problem generating response", e);
        }
        catch (IOException e) {
            throw new SaslException("DIGEST-MD5: problem generating response", e);
        }
    }

    private byte[] generateResponseAuth(byte[] urpHash, byte[] cnonce, int nonceCount, byte[] authzidBytes) throws SaslException {
        try {
            byte[] responseValue = this.generateResponseValue("", this.digestUri, this.negotiatedQop, urpHash, this.nonce, cnonce, nonceCount, authzidBytes);
            return this.generateChallenge(responseValue);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("DIGEST-MD5: problem generating response", e);
        }
        catch (IOException e) {
            throw new SaslException("DIGEST-MD5: problem generating response", e);
        }
    }

    private byte[] generateChallenge(byte[] responseValue) throws UnsupportedEncodingException {
        byte[] challenge = new byte[responseValue.length + 8];
        System.arraycopy("rspauth=".getBytes(this.encoding), 0, challenge, 0, 8);
        System.arraycopy(responseValue, 0, challenge, 8, responseValue.length);
        return challenge;
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("DIGEST-MD5 server negotiation not complete");
    }
}

