/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class PackedInteger {
    public static int readPackedInteger(DataInput input) throws IOException {
        byte b = input.readByte();
        if ((b & 0x80) == 128) {
            return PackedInteger.readPackedInteger(input) << 7 | b & 0x7F;
        }
        return b;
    }

    public static void writePackedInteger(DataOutput output, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("Only unsigned integer can be packed");
        }
        if (value > 127) {
            output.writeByte(value & 0x7F | 0x80);
            PackedInteger.writePackedInteger(output, value >> 7);
        } else {
            output.writeByte(value & 0xFF);
        }
    }

    public static byte[] toPackedInteger(int value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        PackedInteger.writePackedInteger(dos, value);
        dos.flush();
        return bos.toByteArray();
    }
}

