// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Extended date/time patterns.
 *
 * This file is autogenerated by script.  See
 * http://go/generate_datetime_pattern.cc
 *
 * This file is generated using ICU's implementation of
 * DateTimePatternGenerator. The whole set has two files:
 * datetimepatterns.js and datetimepatternsext.js. The former covers
 * frequently used locales, the latter covers the rest. There won't be any
 * difference in compiled code, but some developing environments have
 * difficulty in dealing large js files. So we do the separation.

 * Only locales that can be enumerated in ICU are supported. For the rest
 * of the locales, it will fallback to 'en'.
 * The code is designed to work with Closure compiler using
 * ADVANCED_OPTIMIZATIONS. We will continue to add popular date/time
 * patterns over time. There is no intention cover all possible
 * usages. If simple pattern works fine, it won't be covered here either.
 * For example, pattern 'MMM' will work well to get short month name for
 * almost all locales thus won't be included here.
 */

/* File generated from CLDR ver. 25.0 */

goog.provide('goog.i18n.DateTimePatternsExt');

goog.provide('goog.i18n.DateTimePatterns_af_NA');
goog.provide('goog.i18n.DateTimePatterns_af_ZA');
goog.provide('goog.i18n.DateTimePatterns_agq');
goog.provide('goog.i18n.DateTimePatterns_agq_CM');
goog.provide('goog.i18n.DateTimePatterns_ak');
goog.provide('goog.i18n.DateTimePatterns_ak_GH');
goog.provide('goog.i18n.DateTimePatterns_am_ET');
goog.provide('goog.i18n.DateTimePatterns_ar_001');
goog.provide('goog.i18n.DateTimePatterns_ar_AE');
goog.provide('goog.i18n.DateTimePatterns_ar_BH');
goog.provide('goog.i18n.DateTimePatterns_ar_DJ');
goog.provide('goog.i18n.DateTimePatterns_ar_DZ');
goog.provide('goog.i18n.DateTimePatterns_ar_EG');
goog.provide('goog.i18n.DateTimePatterns_ar_EH');
goog.provide('goog.i18n.DateTimePatterns_ar_ER');
goog.provide('goog.i18n.DateTimePatterns_ar_IL');
goog.provide('goog.i18n.DateTimePatterns_ar_IQ');
goog.provide('goog.i18n.DateTimePatterns_ar_JO');
goog.provide('goog.i18n.DateTimePatterns_ar_KM');
goog.provide('goog.i18n.DateTimePatterns_ar_KW');
goog.provide('goog.i18n.DateTimePatterns_ar_LB');
goog.provide('goog.i18n.DateTimePatterns_ar_LY');
goog.provide('goog.i18n.DateTimePatterns_ar_MA');
goog.provide('goog.i18n.DateTimePatterns_ar_MR');
goog.provide('goog.i18n.DateTimePatterns_ar_OM');
goog.provide('goog.i18n.DateTimePatterns_ar_PS');
goog.provide('goog.i18n.DateTimePatterns_ar_QA');
goog.provide('goog.i18n.DateTimePatterns_ar_SA');
goog.provide('goog.i18n.DateTimePatterns_ar_SD');
goog.provide('goog.i18n.DateTimePatterns_ar_SO');
goog.provide('goog.i18n.DateTimePatterns_ar_SS');
goog.provide('goog.i18n.DateTimePatterns_ar_SY');
goog.provide('goog.i18n.DateTimePatterns_ar_TD');
goog.provide('goog.i18n.DateTimePatterns_ar_TN');
goog.provide('goog.i18n.DateTimePatterns_ar_YE');
goog.provide('goog.i18n.DateTimePatterns_as');
goog.provide('goog.i18n.DateTimePatterns_as_IN');
goog.provide('goog.i18n.DateTimePatterns_asa');
goog.provide('goog.i18n.DateTimePatterns_asa_TZ');
goog.provide('goog.i18n.DateTimePatterns_az_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_az_Cyrl_AZ');
goog.provide('goog.i18n.DateTimePatterns_az_Latn');
goog.provide('goog.i18n.DateTimePatterns_az_Latn_AZ');
goog.provide('goog.i18n.DateTimePatterns_bas');
goog.provide('goog.i18n.DateTimePatterns_bas_CM');
goog.provide('goog.i18n.DateTimePatterns_be');
goog.provide('goog.i18n.DateTimePatterns_be_BY');
goog.provide('goog.i18n.DateTimePatterns_bem');
goog.provide('goog.i18n.DateTimePatterns_bem_ZM');
goog.provide('goog.i18n.DateTimePatterns_bez');
goog.provide('goog.i18n.DateTimePatterns_bez_TZ');
goog.provide('goog.i18n.DateTimePatterns_bg_BG');
goog.provide('goog.i18n.DateTimePatterns_bm');
goog.provide('goog.i18n.DateTimePatterns_bm_ML');
goog.provide('goog.i18n.DateTimePatterns_bn_BD');
goog.provide('goog.i18n.DateTimePatterns_bn_IN');
goog.provide('goog.i18n.DateTimePatterns_bo');
goog.provide('goog.i18n.DateTimePatterns_bo_CN');
goog.provide('goog.i18n.DateTimePatterns_bo_IN');
goog.provide('goog.i18n.DateTimePatterns_br_FR');
goog.provide('goog.i18n.DateTimePatterns_brx');
goog.provide('goog.i18n.DateTimePatterns_brx_IN');
goog.provide('goog.i18n.DateTimePatterns_bs');
goog.provide('goog.i18n.DateTimePatterns_bs_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_bs_Cyrl_BA');
goog.provide('goog.i18n.DateTimePatterns_bs_Latn');
goog.provide('goog.i18n.DateTimePatterns_bs_Latn_BA');
goog.provide('goog.i18n.DateTimePatterns_ca_AD');
goog.provide('goog.i18n.DateTimePatterns_ca_ES');
goog.provide('goog.i18n.DateTimePatterns_ca_FR');
goog.provide('goog.i18n.DateTimePatterns_ca_IT');
goog.provide('goog.i18n.DateTimePatterns_cgg');
goog.provide('goog.i18n.DateTimePatterns_cgg_UG');
goog.provide('goog.i18n.DateTimePatterns_chr_US');
goog.provide('goog.i18n.DateTimePatterns_cs_CZ');
goog.provide('goog.i18n.DateTimePatterns_cy_GB');
goog.provide('goog.i18n.DateTimePatterns_da_DK');
goog.provide('goog.i18n.DateTimePatterns_da_GL');
goog.provide('goog.i18n.DateTimePatterns_dav');
goog.provide('goog.i18n.DateTimePatterns_dav_KE');
goog.provide('goog.i18n.DateTimePatterns_de_BE');
goog.provide('goog.i18n.DateTimePatterns_de_DE');
goog.provide('goog.i18n.DateTimePatterns_de_LI');
goog.provide('goog.i18n.DateTimePatterns_de_LU');
goog.provide('goog.i18n.DateTimePatterns_dje');
goog.provide('goog.i18n.DateTimePatterns_dje_NE');
goog.provide('goog.i18n.DateTimePatterns_dua');
goog.provide('goog.i18n.DateTimePatterns_dua_CM');
goog.provide('goog.i18n.DateTimePatterns_dyo');
goog.provide('goog.i18n.DateTimePatterns_dyo_SN');
goog.provide('goog.i18n.DateTimePatterns_dz');
goog.provide('goog.i18n.DateTimePatterns_dz_BT');
goog.provide('goog.i18n.DateTimePatterns_ebu');
goog.provide('goog.i18n.DateTimePatterns_ebu_KE');
goog.provide('goog.i18n.DateTimePatterns_ee');
goog.provide('goog.i18n.DateTimePatterns_ee_GH');
goog.provide('goog.i18n.DateTimePatterns_ee_TG');
goog.provide('goog.i18n.DateTimePatterns_el_CY');
goog.provide('goog.i18n.DateTimePatterns_el_GR');
goog.provide('goog.i18n.DateTimePatterns_en_001');
goog.provide('goog.i18n.DateTimePatterns_en_150');
goog.provide('goog.i18n.DateTimePatterns_en_AG');
goog.provide('goog.i18n.DateTimePatterns_en_AI');
goog.provide('goog.i18n.DateTimePatterns_en_AS');
goog.provide('goog.i18n.DateTimePatterns_en_BB');
goog.provide('goog.i18n.DateTimePatterns_en_BE');
goog.provide('goog.i18n.DateTimePatterns_en_BM');
goog.provide('goog.i18n.DateTimePatterns_en_BS');
goog.provide('goog.i18n.DateTimePatterns_en_BW');
goog.provide('goog.i18n.DateTimePatterns_en_BZ');
goog.provide('goog.i18n.DateTimePatterns_en_CA');
goog.provide('goog.i18n.DateTimePatterns_en_CC');
goog.provide('goog.i18n.DateTimePatterns_en_CK');
goog.provide('goog.i18n.DateTimePatterns_en_CM');
goog.provide('goog.i18n.DateTimePatterns_en_CX');
goog.provide('goog.i18n.DateTimePatterns_en_DG');
goog.provide('goog.i18n.DateTimePatterns_en_DM');
goog.provide('goog.i18n.DateTimePatterns_en_ER');
goog.provide('goog.i18n.DateTimePatterns_en_FJ');
goog.provide('goog.i18n.DateTimePatterns_en_FK');
goog.provide('goog.i18n.DateTimePatterns_en_FM');
goog.provide('goog.i18n.DateTimePatterns_en_GD');
goog.provide('goog.i18n.DateTimePatterns_en_GG');
goog.provide('goog.i18n.DateTimePatterns_en_GH');
goog.provide('goog.i18n.DateTimePatterns_en_GI');
goog.provide('goog.i18n.DateTimePatterns_en_GM');
goog.provide('goog.i18n.DateTimePatterns_en_GU');
goog.provide('goog.i18n.DateTimePatterns_en_GY');
goog.provide('goog.i18n.DateTimePatterns_en_HK');
goog.provide('goog.i18n.DateTimePatterns_en_IM');
goog.provide('goog.i18n.DateTimePatterns_en_IO');
goog.provide('goog.i18n.DateTimePatterns_en_JE');
goog.provide('goog.i18n.DateTimePatterns_en_JM');
goog.provide('goog.i18n.DateTimePatterns_en_KE');
goog.provide('goog.i18n.DateTimePatterns_en_KI');
goog.provide('goog.i18n.DateTimePatterns_en_KN');
goog.provide('goog.i18n.DateTimePatterns_en_KY');
goog.provide('goog.i18n.DateTimePatterns_en_LC');
goog.provide('goog.i18n.DateTimePatterns_en_LR');
goog.provide('goog.i18n.DateTimePatterns_en_LS');
goog.provide('goog.i18n.DateTimePatterns_en_MG');
goog.provide('goog.i18n.DateTimePatterns_en_MH');
goog.provide('goog.i18n.DateTimePatterns_en_MO');
goog.provide('goog.i18n.DateTimePatterns_en_MP');
goog.provide('goog.i18n.DateTimePatterns_en_MS');
goog.provide('goog.i18n.DateTimePatterns_en_MT');
goog.provide('goog.i18n.DateTimePatterns_en_MU');
goog.provide('goog.i18n.DateTimePatterns_en_MW');
goog.provide('goog.i18n.DateTimePatterns_en_NA');
goog.provide('goog.i18n.DateTimePatterns_en_NF');
goog.provide('goog.i18n.DateTimePatterns_en_NG');
goog.provide('goog.i18n.DateTimePatterns_en_NR');
goog.provide('goog.i18n.DateTimePatterns_en_NU');
goog.provide('goog.i18n.DateTimePatterns_en_NZ');
goog.provide('goog.i18n.DateTimePatterns_en_PG');
goog.provide('goog.i18n.DateTimePatterns_en_PH');
goog.provide('goog.i18n.DateTimePatterns_en_PK');
goog.provide('goog.i18n.DateTimePatterns_en_PN');
goog.provide('goog.i18n.DateTimePatterns_en_PR');
goog.provide('goog.i18n.DateTimePatterns_en_PW');
goog.provide('goog.i18n.DateTimePatterns_en_RW');
goog.provide('goog.i18n.DateTimePatterns_en_SB');
goog.provide('goog.i18n.DateTimePatterns_en_SC');
goog.provide('goog.i18n.DateTimePatterns_en_SD');
goog.provide('goog.i18n.DateTimePatterns_en_SH');
goog.provide('goog.i18n.DateTimePatterns_en_SL');
goog.provide('goog.i18n.DateTimePatterns_en_SS');
goog.provide('goog.i18n.DateTimePatterns_en_SX');
goog.provide('goog.i18n.DateTimePatterns_en_SZ');
goog.provide('goog.i18n.DateTimePatterns_en_TC');
goog.provide('goog.i18n.DateTimePatterns_en_TK');
goog.provide('goog.i18n.DateTimePatterns_en_TO');
goog.provide('goog.i18n.DateTimePatterns_en_TT');
goog.provide('goog.i18n.DateTimePatterns_en_TV');
goog.provide('goog.i18n.DateTimePatterns_en_TZ');
goog.provide('goog.i18n.DateTimePatterns_en_UG');
goog.provide('goog.i18n.DateTimePatterns_en_UM');
goog.provide('goog.i18n.DateTimePatterns_en_US_POSIX');
goog.provide('goog.i18n.DateTimePatterns_en_VC');
goog.provide('goog.i18n.DateTimePatterns_en_VG');
goog.provide('goog.i18n.DateTimePatterns_en_VI');
goog.provide('goog.i18n.DateTimePatterns_en_VU');
goog.provide('goog.i18n.DateTimePatterns_en_WS');
goog.provide('goog.i18n.DateTimePatterns_en_ZM');
goog.provide('goog.i18n.DateTimePatterns_en_ZW');
goog.provide('goog.i18n.DateTimePatterns_eo');
goog.provide('goog.i18n.DateTimePatterns_es_AR');
goog.provide('goog.i18n.DateTimePatterns_es_BO');
goog.provide('goog.i18n.DateTimePatterns_es_CL');
goog.provide('goog.i18n.DateTimePatterns_es_CO');
goog.provide('goog.i18n.DateTimePatterns_es_CR');
goog.provide('goog.i18n.DateTimePatterns_es_CU');
goog.provide('goog.i18n.DateTimePatterns_es_DO');
goog.provide('goog.i18n.DateTimePatterns_es_EA');
goog.provide('goog.i18n.DateTimePatterns_es_EC');
goog.provide('goog.i18n.DateTimePatterns_es_GQ');
goog.provide('goog.i18n.DateTimePatterns_es_GT');
goog.provide('goog.i18n.DateTimePatterns_es_HN');
goog.provide('goog.i18n.DateTimePatterns_es_IC');
goog.provide('goog.i18n.DateTimePatterns_es_MX');
goog.provide('goog.i18n.DateTimePatterns_es_NI');
goog.provide('goog.i18n.DateTimePatterns_es_PA');
goog.provide('goog.i18n.DateTimePatterns_es_PE');
goog.provide('goog.i18n.DateTimePatterns_es_PH');
goog.provide('goog.i18n.DateTimePatterns_es_PR');
goog.provide('goog.i18n.DateTimePatterns_es_PY');
goog.provide('goog.i18n.DateTimePatterns_es_SV');
goog.provide('goog.i18n.DateTimePatterns_es_US');
goog.provide('goog.i18n.DateTimePatterns_es_UY');
goog.provide('goog.i18n.DateTimePatterns_es_VE');
goog.provide('goog.i18n.DateTimePatterns_et_EE');
goog.provide('goog.i18n.DateTimePatterns_eu_ES');
goog.provide('goog.i18n.DateTimePatterns_ewo');
goog.provide('goog.i18n.DateTimePatterns_ewo_CM');
goog.provide('goog.i18n.DateTimePatterns_fa_AF');
goog.provide('goog.i18n.DateTimePatterns_fa_IR');
goog.provide('goog.i18n.DateTimePatterns_ff');
goog.provide('goog.i18n.DateTimePatterns_ff_SN');
goog.provide('goog.i18n.DateTimePatterns_fi_FI');
goog.provide('goog.i18n.DateTimePatterns_fil_PH');
goog.provide('goog.i18n.DateTimePatterns_fo');
goog.provide('goog.i18n.DateTimePatterns_fo_FO');
goog.provide('goog.i18n.DateTimePatterns_fr_BE');
goog.provide('goog.i18n.DateTimePatterns_fr_BF');
goog.provide('goog.i18n.DateTimePatterns_fr_BI');
goog.provide('goog.i18n.DateTimePatterns_fr_BJ');
goog.provide('goog.i18n.DateTimePatterns_fr_BL');
goog.provide('goog.i18n.DateTimePatterns_fr_CD');
goog.provide('goog.i18n.DateTimePatterns_fr_CF');
goog.provide('goog.i18n.DateTimePatterns_fr_CG');
goog.provide('goog.i18n.DateTimePatterns_fr_CH');
goog.provide('goog.i18n.DateTimePatterns_fr_CI');
goog.provide('goog.i18n.DateTimePatterns_fr_CM');
goog.provide('goog.i18n.DateTimePatterns_fr_DJ');
goog.provide('goog.i18n.DateTimePatterns_fr_DZ');
goog.provide('goog.i18n.DateTimePatterns_fr_FR');
goog.provide('goog.i18n.DateTimePatterns_fr_GA');
goog.provide('goog.i18n.DateTimePatterns_fr_GF');
goog.provide('goog.i18n.DateTimePatterns_fr_GN');
goog.provide('goog.i18n.DateTimePatterns_fr_GP');
goog.provide('goog.i18n.DateTimePatterns_fr_GQ');
goog.provide('goog.i18n.DateTimePatterns_fr_HT');
goog.provide('goog.i18n.DateTimePatterns_fr_KM');
goog.provide('goog.i18n.DateTimePatterns_fr_LU');
goog.provide('goog.i18n.DateTimePatterns_fr_MA');
goog.provide('goog.i18n.DateTimePatterns_fr_MC');
goog.provide('goog.i18n.DateTimePatterns_fr_MF');
goog.provide('goog.i18n.DateTimePatterns_fr_MG');
goog.provide('goog.i18n.DateTimePatterns_fr_ML');
goog.provide('goog.i18n.DateTimePatterns_fr_MQ');
goog.provide('goog.i18n.DateTimePatterns_fr_MR');
goog.provide('goog.i18n.DateTimePatterns_fr_MU');
goog.provide('goog.i18n.DateTimePatterns_fr_NC');
goog.provide('goog.i18n.DateTimePatterns_fr_NE');
goog.provide('goog.i18n.DateTimePatterns_fr_PF');
goog.provide('goog.i18n.DateTimePatterns_fr_PM');
goog.provide('goog.i18n.DateTimePatterns_fr_RE');
goog.provide('goog.i18n.DateTimePatterns_fr_RW');
goog.provide('goog.i18n.DateTimePatterns_fr_SC');
goog.provide('goog.i18n.DateTimePatterns_fr_SN');
goog.provide('goog.i18n.DateTimePatterns_fr_SY');
goog.provide('goog.i18n.DateTimePatterns_fr_TD');
goog.provide('goog.i18n.DateTimePatterns_fr_TG');
goog.provide('goog.i18n.DateTimePatterns_fr_TN');
goog.provide('goog.i18n.DateTimePatterns_fr_VU');
goog.provide('goog.i18n.DateTimePatterns_fr_WF');
goog.provide('goog.i18n.DateTimePatterns_fr_YT');
goog.provide('goog.i18n.DateTimePatterns_ga');
goog.provide('goog.i18n.DateTimePatterns_ga_IE');
goog.provide('goog.i18n.DateTimePatterns_gl_ES');
goog.provide('goog.i18n.DateTimePatterns_gsw_CH');
goog.provide('goog.i18n.DateTimePatterns_gsw_LI');
goog.provide('goog.i18n.DateTimePatterns_gu_IN');
goog.provide('goog.i18n.DateTimePatterns_guz');
goog.provide('goog.i18n.DateTimePatterns_guz_KE');
goog.provide('goog.i18n.DateTimePatterns_gv');
goog.provide('goog.i18n.DateTimePatterns_gv_IM');
goog.provide('goog.i18n.DateTimePatterns_ha');
goog.provide('goog.i18n.DateTimePatterns_ha_Latn');
goog.provide('goog.i18n.DateTimePatterns_ha_Latn_GH');
goog.provide('goog.i18n.DateTimePatterns_ha_Latn_NE');
goog.provide('goog.i18n.DateTimePatterns_ha_Latn_NG');
goog.provide('goog.i18n.DateTimePatterns_haw_US');
goog.provide('goog.i18n.DateTimePatterns_he_IL');
goog.provide('goog.i18n.DateTimePatterns_hi_IN');
goog.provide('goog.i18n.DateTimePatterns_hr_BA');
goog.provide('goog.i18n.DateTimePatterns_hr_HR');
goog.provide('goog.i18n.DateTimePatterns_hu_HU');
goog.provide('goog.i18n.DateTimePatterns_hy_AM');
goog.provide('goog.i18n.DateTimePatterns_id_ID');
goog.provide('goog.i18n.DateTimePatterns_ig');
goog.provide('goog.i18n.DateTimePatterns_ig_NG');
goog.provide('goog.i18n.DateTimePatterns_ii');
goog.provide('goog.i18n.DateTimePatterns_ii_CN');
goog.provide('goog.i18n.DateTimePatterns_is_IS');
goog.provide('goog.i18n.DateTimePatterns_it_CH');
goog.provide('goog.i18n.DateTimePatterns_it_IT');
goog.provide('goog.i18n.DateTimePatterns_it_SM');
goog.provide('goog.i18n.DateTimePatterns_ja_JP');
goog.provide('goog.i18n.DateTimePatterns_jgo');
goog.provide('goog.i18n.DateTimePatterns_jgo_CM');
goog.provide('goog.i18n.DateTimePatterns_jmc');
goog.provide('goog.i18n.DateTimePatterns_jmc_TZ');
goog.provide('goog.i18n.DateTimePatterns_ka_GE');
goog.provide('goog.i18n.DateTimePatterns_kab');
goog.provide('goog.i18n.DateTimePatterns_kab_DZ');
goog.provide('goog.i18n.DateTimePatterns_kam');
goog.provide('goog.i18n.DateTimePatterns_kam_KE');
goog.provide('goog.i18n.DateTimePatterns_kde');
goog.provide('goog.i18n.DateTimePatterns_kde_TZ');
goog.provide('goog.i18n.DateTimePatterns_kea');
goog.provide('goog.i18n.DateTimePatterns_kea_CV');
goog.provide('goog.i18n.DateTimePatterns_khq');
goog.provide('goog.i18n.DateTimePatterns_khq_ML');
goog.provide('goog.i18n.DateTimePatterns_ki');
goog.provide('goog.i18n.DateTimePatterns_ki_KE');
goog.provide('goog.i18n.DateTimePatterns_kk_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_kk_Cyrl_KZ');
goog.provide('goog.i18n.DateTimePatterns_kkj');
goog.provide('goog.i18n.DateTimePatterns_kkj_CM');
goog.provide('goog.i18n.DateTimePatterns_kl');
goog.provide('goog.i18n.DateTimePatterns_kl_GL');
goog.provide('goog.i18n.DateTimePatterns_kln');
goog.provide('goog.i18n.DateTimePatterns_kln_KE');
goog.provide('goog.i18n.DateTimePatterns_km_KH');
goog.provide('goog.i18n.DateTimePatterns_kn_IN');
goog.provide('goog.i18n.DateTimePatterns_ko_KP');
goog.provide('goog.i18n.DateTimePatterns_ko_KR');
goog.provide('goog.i18n.DateTimePatterns_kok');
goog.provide('goog.i18n.DateTimePatterns_kok_IN');
goog.provide('goog.i18n.DateTimePatterns_ks');
goog.provide('goog.i18n.DateTimePatterns_ks_Arab');
goog.provide('goog.i18n.DateTimePatterns_ks_Arab_IN');
goog.provide('goog.i18n.DateTimePatterns_ksb');
goog.provide('goog.i18n.DateTimePatterns_ksb_TZ');
goog.provide('goog.i18n.DateTimePatterns_ksf');
goog.provide('goog.i18n.DateTimePatterns_ksf_CM');
goog.provide('goog.i18n.DateTimePatterns_kw');
goog.provide('goog.i18n.DateTimePatterns_kw_GB');
goog.provide('goog.i18n.DateTimePatterns_ky_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_ky_Cyrl_KG');
goog.provide('goog.i18n.DateTimePatterns_lag');
goog.provide('goog.i18n.DateTimePatterns_lag_TZ');
goog.provide('goog.i18n.DateTimePatterns_lg');
goog.provide('goog.i18n.DateTimePatterns_lg_UG');
goog.provide('goog.i18n.DateTimePatterns_lkt');
goog.provide('goog.i18n.DateTimePatterns_lkt_US');
goog.provide('goog.i18n.DateTimePatterns_ln_AO');
goog.provide('goog.i18n.DateTimePatterns_ln_CD');
goog.provide('goog.i18n.DateTimePatterns_ln_CF');
goog.provide('goog.i18n.DateTimePatterns_ln_CG');
goog.provide('goog.i18n.DateTimePatterns_lo_LA');
goog.provide('goog.i18n.DateTimePatterns_lt_LT');
goog.provide('goog.i18n.DateTimePatterns_lu');
goog.provide('goog.i18n.DateTimePatterns_lu_CD');
goog.provide('goog.i18n.DateTimePatterns_luo');
goog.provide('goog.i18n.DateTimePatterns_luo_KE');
goog.provide('goog.i18n.DateTimePatterns_luy');
goog.provide('goog.i18n.DateTimePatterns_luy_KE');
goog.provide('goog.i18n.DateTimePatterns_lv_LV');
goog.provide('goog.i18n.DateTimePatterns_mas');
goog.provide('goog.i18n.DateTimePatterns_mas_KE');
goog.provide('goog.i18n.DateTimePatterns_mas_TZ');
goog.provide('goog.i18n.DateTimePatterns_mer');
goog.provide('goog.i18n.DateTimePatterns_mer_KE');
goog.provide('goog.i18n.DateTimePatterns_mfe');
goog.provide('goog.i18n.DateTimePatterns_mfe_MU');
goog.provide('goog.i18n.DateTimePatterns_mg');
goog.provide('goog.i18n.DateTimePatterns_mg_MG');
goog.provide('goog.i18n.DateTimePatterns_mgh');
goog.provide('goog.i18n.DateTimePatterns_mgh_MZ');
goog.provide('goog.i18n.DateTimePatterns_mgo');
goog.provide('goog.i18n.DateTimePatterns_mgo_CM');
goog.provide('goog.i18n.DateTimePatterns_mk_MK');
goog.provide('goog.i18n.DateTimePatterns_ml_IN');
goog.provide('goog.i18n.DateTimePatterns_mn_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_mn_Cyrl_MN');
goog.provide('goog.i18n.DateTimePatterns_mr_IN');
goog.provide('goog.i18n.DateTimePatterns_ms_Latn');
goog.provide('goog.i18n.DateTimePatterns_ms_Latn_BN');
goog.provide('goog.i18n.DateTimePatterns_ms_Latn_MY');
goog.provide('goog.i18n.DateTimePatterns_ms_Latn_SG');
goog.provide('goog.i18n.DateTimePatterns_mt_MT');
goog.provide('goog.i18n.DateTimePatterns_mua');
goog.provide('goog.i18n.DateTimePatterns_mua_CM');
goog.provide('goog.i18n.DateTimePatterns_my_MM');
goog.provide('goog.i18n.DateTimePatterns_naq');
goog.provide('goog.i18n.DateTimePatterns_naq_NA');
goog.provide('goog.i18n.DateTimePatterns_nb_NO');
goog.provide('goog.i18n.DateTimePatterns_nb_SJ');
goog.provide('goog.i18n.DateTimePatterns_nd');
goog.provide('goog.i18n.DateTimePatterns_nd_ZW');
goog.provide('goog.i18n.DateTimePatterns_ne_IN');
goog.provide('goog.i18n.DateTimePatterns_ne_NP');
goog.provide('goog.i18n.DateTimePatterns_nl_AW');
goog.provide('goog.i18n.DateTimePatterns_nl_BE');
goog.provide('goog.i18n.DateTimePatterns_nl_BQ');
goog.provide('goog.i18n.DateTimePatterns_nl_CW');
goog.provide('goog.i18n.DateTimePatterns_nl_NL');
goog.provide('goog.i18n.DateTimePatterns_nl_SR');
goog.provide('goog.i18n.DateTimePatterns_nl_SX');
goog.provide('goog.i18n.DateTimePatterns_nmg');
goog.provide('goog.i18n.DateTimePatterns_nmg_CM');
goog.provide('goog.i18n.DateTimePatterns_nn');
goog.provide('goog.i18n.DateTimePatterns_nn_NO');
goog.provide('goog.i18n.DateTimePatterns_nnh');
goog.provide('goog.i18n.DateTimePatterns_nnh_CM');
goog.provide('goog.i18n.DateTimePatterns_nus');
goog.provide('goog.i18n.DateTimePatterns_nus_SD');
goog.provide('goog.i18n.DateTimePatterns_nyn');
goog.provide('goog.i18n.DateTimePatterns_nyn_UG');
goog.provide('goog.i18n.DateTimePatterns_om');
goog.provide('goog.i18n.DateTimePatterns_om_ET');
goog.provide('goog.i18n.DateTimePatterns_om_KE');
goog.provide('goog.i18n.DateTimePatterns_or_IN');
goog.provide('goog.i18n.DateTimePatterns_pa_Arab');
goog.provide('goog.i18n.DateTimePatterns_pa_Arab_PK');
goog.provide('goog.i18n.DateTimePatterns_pa_Guru');
goog.provide('goog.i18n.DateTimePatterns_pa_Guru_IN');
goog.provide('goog.i18n.DateTimePatterns_pl_PL');
goog.provide('goog.i18n.DateTimePatterns_ps');
goog.provide('goog.i18n.DateTimePatterns_ps_AF');
goog.provide('goog.i18n.DateTimePatterns_pt_AO');
goog.provide('goog.i18n.DateTimePatterns_pt_CV');
goog.provide('goog.i18n.DateTimePatterns_pt_GW');
goog.provide('goog.i18n.DateTimePatterns_pt_MO');
goog.provide('goog.i18n.DateTimePatterns_pt_MZ');
goog.provide('goog.i18n.DateTimePatterns_pt_ST');
goog.provide('goog.i18n.DateTimePatterns_pt_TL');
goog.provide('goog.i18n.DateTimePatterns_rm');
goog.provide('goog.i18n.DateTimePatterns_rm_CH');
goog.provide('goog.i18n.DateTimePatterns_rn');
goog.provide('goog.i18n.DateTimePatterns_rn_BI');
goog.provide('goog.i18n.DateTimePatterns_ro_MD');
goog.provide('goog.i18n.DateTimePatterns_ro_RO');
goog.provide('goog.i18n.DateTimePatterns_rof');
goog.provide('goog.i18n.DateTimePatterns_rof_TZ');
goog.provide('goog.i18n.DateTimePatterns_ru_BY');
goog.provide('goog.i18n.DateTimePatterns_ru_KG');
goog.provide('goog.i18n.DateTimePatterns_ru_KZ');
goog.provide('goog.i18n.DateTimePatterns_ru_MD');
goog.provide('goog.i18n.DateTimePatterns_ru_RU');
goog.provide('goog.i18n.DateTimePatterns_ru_UA');
goog.provide('goog.i18n.DateTimePatterns_rw');
goog.provide('goog.i18n.DateTimePatterns_rw_RW');
goog.provide('goog.i18n.DateTimePatterns_rwk');
goog.provide('goog.i18n.DateTimePatterns_rwk_TZ');
goog.provide('goog.i18n.DateTimePatterns_saq');
goog.provide('goog.i18n.DateTimePatterns_saq_KE');
goog.provide('goog.i18n.DateTimePatterns_sbp');
goog.provide('goog.i18n.DateTimePatterns_sbp_TZ');
goog.provide('goog.i18n.DateTimePatterns_seh');
goog.provide('goog.i18n.DateTimePatterns_seh_MZ');
goog.provide('goog.i18n.DateTimePatterns_ses');
goog.provide('goog.i18n.DateTimePatterns_ses_ML');
goog.provide('goog.i18n.DateTimePatterns_sg');
goog.provide('goog.i18n.DateTimePatterns_sg_CF');
goog.provide('goog.i18n.DateTimePatterns_shi');
goog.provide('goog.i18n.DateTimePatterns_shi_Latn');
goog.provide('goog.i18n.DateTimePatterns_shi_Latn_MA');
goog.provide('goog.i18n.DateTimePatterns_shi_Tfng');
goog.provide('goog.i18n.DateTimePatterns_shi_Tfng_MA');
goog.provide('goog.i18n.DateTimePatterns_si_LK');
goog.provide('goog.i18n.DateTimePatterns_sk_SK');
goog.provide('goog.i18n.DateTimePatterns_sl_SI');
goog.provide('goog.i18n.DateTimePatterns_sn');
goog.provide('goog.i18n.DateTimePatterns_sn_ZW');
goog.provide('goog.i18n.DateTimePatterns_so');
goog.provide('goog.i18n.DateTimePatterns_so_DJ');
goog.provide('goog.i18n.DateTimePatterns_so_ET');
goog.provide('goog.i18n.DateTimePatterns_so_KE');
goog.provide('goog.i18n.DateTimePatterns_so_SO');
goog.provide('goog.i18n.DateTimePatterns_sq_AL');
goog.provide('goog.i18n.DateTimePatterns_sq_MK');
goog.provide('goog.i18n.DateTimePatterns_sq_XK');
goog.provide('goog.i18n.DateTimePatterns_sr_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_sr_Cyrl_BA');
goog.provide('goog.i18n.DateTimePatterns_sr_Cyrl_ME');
goog.provide('goog.i18n.DateTimePatterns_sr_Cyrl_RS');
goog.provide('goog.i18n.DateTimePatterns_sr_Cyrl_XK');
goog.provide('goog.i18n.DateTimePatterns_sr_Latn');
goog.provide('goog.i18n.DateTimePatterns_sr_Latn_BA');
goog.provide('goog.i18n.DateTimePatterns_sr_Latn_ME');
goog.provide('goog.i18n.DateTimePatterns_sr_Latn_RS');
goog.provide('goog.i18n.DateTimePatterns_sr_Latn_XK');
goog.provide('goog.i18n.DateTimePatterns_sv_AX');
goog.provide('goog.i18n.DateTimePatterns_sv_FI');
goog.provide('goog.i18n.DateTimePatterns_sv_SE');
goog.provide('goog.i18n.DateTimePatterns_sw_KE');
goog.provide('goog.i18n.DateTimePatterns_sw_TZ');
goog.provide('goog.i18n.DateTimePatterns_sw_UG');
goog.provide('goog.i18n.DateTimePatterns_swc');
goog.provide('goog.i18n.DateTimePatterns_swc_CD');
goog.provide('goog.i18n.DateTimePatterns_ta_IN');
goog.provide('goog.i18n.DateTimePatterns_ta_LK');
goog.provide('goog.i18n.DateTimePatterns_ta_MY');
goog.provide('goog.i18n.DateTimePatterns_ta_SG');
goog.provide('goog.i18n.DateTimePatterns_te_IN');
goog.provide('goog.i18n.DateTimePatterns_teo');
goog.provide('goog.i18n.DateTimePatterns_teo_KE');
goog.provide('goog.i18n.DateTimePatterns_teo_UG');
goog.provide('goog.i18n.DateTimePatterns_th_TH');
goog.provide('goog.i18n.DateTimePatterns_ti');
goog.provide('goog.i18n.DateTimePatterns_ti_ER');
goog.provide('goog.i18n.DateTimePatterns_ti_ET');
goog.provide('goog.i18n.DateTimePatterns_to');
goog.provide('goog.i18n.DateTimePatterns_to_TO');
goog.provide('goog.i18n.DateTimePatterns_tr_CY');
goog.provide('goog.i18n.DateTimePatterns_tr_TR');
goog.provide('goog.i18n.DateTimePatterns_twq');
goog.provide('goog.i18n.DateTimePatterns_twq_NE');
goog.provide('goog.i18n.DateTimePatterns_tzm');
goog.provide('goog.i18n.DateTimePatterns_tzm_Latn');
goog.provide('goog.i18n.DateTimePatterns_tzm_Latn_MA');
goog.provide('goog.i18n.DateTimePatterns_ug');
goog.provide('goog.i18n.DateTimePatterns_ug_Arab');
goog.provide('goog.i18n.DateTimePatterns_ug_Arab_CN');
goog.provide('goog.i18n.DateTimePatterns_uk_UA');
goog.provide('goog.i18n.DateTimePatterns_ur_IN');
goog.provide('goog.i18n.DateTimePatterns_ur_PK');
goog.provide('goog.i18n.DateTimePatterns_uz_Arab');
goog.provide('goog.i18n.DateTimePatterns_uz_Arab_AF');
goog.provide('goog.i18n.DateTimePatterns_uz_Cyrl');
goog.provide('goog.i18n.DateTimePatterns_uz_Cyrl_UZ');
goog.provide('goog.i18n.DateTimePatterns_uz_Latn');
goog.provide('goog.i18n.DateTimePatterns_uz_Latn_UZ');
goog.provide('goog.i18n.DateTimePatterns_vai');
goog.provide('goog.i18n.DateTimePatterns_vai_Latn');
goog.provide('goog.i18n.DateTimePatterns_vai_Latn_LR');
goog.provide('goog.i18n.DateTimePatterns_vai_Vaii');
goog.provide('goog.i18n.DateTimePatterns_vai_Vaii_LR');
goog.provide('goog.i18n.DateTimePatterns_vi_VN');
goog.provide('goog.i18n.DateTimePatterns_vun');
goog.provide('goog.i18n.DateTimePatterns_vun_TZ');
goog.provide('goog.i18n.DateTimePatterns_xog');
goog.provide('goog.i18n.DateTimePatterns_xog_UG');
goog.provide('goog.i18n.DateTimePatterns_yav');
goog.provide('goog.i18n.DateTimePatterns_yav_CM');
goog.provide('goog.i18n.DateTimePatterns_yo');
goog.provide('goog.i18n.DateTimePatterns_yo_BJ');
goog.provide('goog.i18n.DateTimePatterns_yo_NG');
goog.provide('goog.i18n.DateTimePatterns_zgh');
goog.provide('goog.i18n.DateTimePatterns_zgh_MA');
goog.provide('goog.i18n.DateTimePatterns_zh_Hans');
goog.provide('goog.i18n.DateTimePatterns_zh_Hans_CN');
goog.provide('goog.i18n.DateTimePatterns_zh_Hans_HK');
goog.provide('goog.i18n.DateTimePatterns_zh_Hans_MO');
goog.provide('goog.i18n.DateTimePatterns_zh_Hans_SG');
goog.provide('goog.i18n.DateTimePatterns_zh_Hant');
goog.provide('goog.i18n.DateTimePatterns_zh_Hant_HK');
goog.provide('goog.i18n.DateTimePatterns_zh_Hant_MO');
goog.provide('goog.i18n.DateTimePatterns_zh_Hant_TW');
goog.provide('goog.i18n.DateTimePatterns_zu_ZA');

goog.require('goog.i18n.DateTimePatterns');


/**
 * Extended set of localized date/time patterns for locale af_NA.
 */
goog.i18n.DateTimePatterns_af_NA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale af_ZA.
 */
goog.i18n.DateTimePatterns_af_ZA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale agq.
 */
goog.i18n.DateTimePatterns_agq = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale agq_CM.
 */
goog.i18n.DateTimePatterns_agq_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ak.
 */
goog.i18n.DateTimePatterns_ak = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ak_GH.
 */
goog.i18n.DateTimePatterns_ak_GH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale am_ET.
 */
goog.i18n.DateTimePatterns_am_ET = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE፣ MMM d y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_001.
 */
goog.i18n.DateTimePatterns_ar_001 = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_AE.
 */
goog.i18n.DateTimePatterns_ar_AE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_BH.
 */
goog.i18n.DateTimePatterns_ar_BH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_DJ.
 */
goog.i18n.DateTimePatterns_ar_DJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_DZ.
 */
goog.i18n.DateTimePatterns_ar_DZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_EG.
 */
goog.i18n.DateTimePatterns_ar_EG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_EH.
 */
goog.i18n.DateTimePatterns_ar_EH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_ER.
 */
goog.i18n.DateTimePatterns_ar_ER = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_IL.
 */
goog.i18n.DateTimePatterns_ar_IL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_IQ.
 */
goog.i18n.DateTimePatterns_ar_IQ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_JO.
 */
goog.i18n.DateTimePatterns_ar_JO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_KM.
 */
goog.i18n.DateTimePatterns_ar_KM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_KW.
 */
goog.i18n.DateTimePatterns_ar_KW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_LB.
 */
goog.i18n.DateTimePatterns_ar_LB = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_LY.
 */
goog.i18n.DateTimePatterns_ar_LY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_MA.
 */
goog.i18n.DateTimePatterns_ar_MA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_MR.
 */
goog.i18n.DateTimePatterns_ar_MR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_OM.
 */
goog.i18n.DateTimePatterns_ar_OM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_PS.
 */
goog.i18n.DateTimePatterns_ar_PS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_QA.
 */
goog.i18n.DateTimePatterns_ar_QA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_SA.
 */
goog.i18n.DateTimePatterns_ar_SA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_SD.
 */
goog.i18n.DateTimePatterns_ar_SD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_SO.
 */
goog.i18n.DateTimePatterns_ar_SO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_SS.
 */
goog.i18n.DateTimePatterns_ar_SS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_SY.
 */
goog.i18n.DateTimePatterns_ar_SY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_TD.
 */
goog.i18n.DateTimePatterns_ar_TD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_TN.
 */
goog.i18n.DateTimePatterns_ar_TN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ar_YE.
 */
goog.i18n.DateTimePatterns_ar_YE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/‏M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale as.
 */
goog.i18n.DateTimePatterns_as = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale as_IN.
 */
goog.i18n.DateTimePatterns_as_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale asa.
 */
goog.i18n.DateTimePatterns_asa = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale asa_TZ.
 */
goog.i18n.DateTimePatterns_asa_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale az_Cyrl.
 */
goog.i18n.DateTimePatterns_az_Cyrl = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM, y',
  YEAR_MONTH_FULL: 'MMMM, y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d, MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d, MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale az_Cyrl_AZ.
 */
goog.i18n.DateTimePatterns_az_Cyrl_AZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM, y',
  YEAR_MONTH_FULL: 'MMMM, y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d, MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d, MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale az_Latn.
 */
goog.i18n.DateTimePatterns_az_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd MMM, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'd MMM y, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale az_Latn_AZ.
 */
goog.i18n.DateTimePatterns_az_Latn_AZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd MMM, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'd MMM y, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bas.
 */
goog.i18n.DateTimePatterns_bas = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bas_CM.
 */
goog.i18n.DateTimePatterns_bas_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale be.
 */
goog.i18n.DateTimePatterns_be = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale be_BY.
 */
goog.i18n.DateTimePatterns_be_BY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bem.
 */
goog.i18n.DateTimePatterns_bem = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bem_ZM.
 */
goog.i18n.DateTimePatterns_bem_ZM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bez.
 */
goog.i18n.DateTimePatterns_bez = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bez_TZ.
 */
goog.i18n.DateTimePatterns_bez_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bg_BG.
 */
goog.i18n.DateTimePatterns_bg_BG = {
  YEAR_FULL: 'y \'г\'.',
  YEAR_FULL_WITH_ERA: 'y \'г\'. G',
  YEAR_MONTH_ABBR: 'MM.y \'г\'.',
  YEAR_MONTH_FULL: 'MMMM y \'г\'.',
  MONTH_DAY_ABBR: 'd.MM',
  MONTH_DAY_FULL: 'd MMMM',
  MONTH_DAY_SHORT: 'd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd.MM.y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d.MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d.MM.y \'г\'.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bm.
 */
goog.i18n.DateTimePatterns_bm = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bm_ML.
 */
goog.i18n.DateTimePatterns_bm_ML = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bn_BD.
 */
goog.i18n.DateTimePatterns_bn_BD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bn_IN.
 */
goog.i18n.DateTimePatterns_bn_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bo.
 */
goog.i18n.DateTimePatterns_bo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y ལོ་འི་MMMཙེས་d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bo_CN.
 */
goog.i18n.DateTimePatterns_bo_CN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y ལོ་འི་MMMཙེས་d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bo_IN.
 */
goog.i18n.DateTimePatterns_bo_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y ལོ་འི་MMMཙེས་d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale br_FR.
 */
goog.i18n.DateTimePatterns_br_FR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale brx.
 */
goog.i18n.DateTimePatterns_brx = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale brx_IN.
 */
goog.i18n.DateTimePatterns_brx_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bs.
 */
goog.i18n.DateTimePatterns_bs = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'dd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'dd.MM.',
  MONTH_DAY_MEDIUM: 'dd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, dd. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bs_Cyrl.
 */
goog.i18n.DateTimePatterns_bs_Cyrl = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'dd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'dd.MM.',
  MONTH_DAY_MEDIUM: 'dd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, dd. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bs_Cyrl_BA.
 */
goog.i18n.DateTimePatterns_bs_Cyrl_BA = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'dd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'dd.MM.',
  MONTH_DAY_MEDIUM: 'dd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, dd. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bs_Latn.
 */
goog.i18n.DateTimePatterns_bs_Latn = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'dd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'dd.MM.',
  MONTH_DAY_MEDIUM: 'dd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, dd. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale bs_Latn_BA.
 */
goog.i18n.DateTimePatterns_bs_Latn_BA = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'dd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'dd.MM.',
  MONTH_DAY_MEDIUM: 'dd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, dd. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ca_AD.
 */
goog.i18n.DateTimePatterns_ca_AD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL \'de\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ca_ES.
 */
goog.i18n.DateTimePatterns_ca_ES = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL \'de\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ca_FR.
 */
goog.i18n.DateTimePatterns_ca_FR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL \'de\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ca_IT.
 */
goog.i18n.DateTimePatterns_ca_IT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL \'de\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale cgg.
 */
goog.i18n.DateTimePatterns_cgg = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale cgg_UG.
 */
goog.i18n.DateTimePatterns_cgg_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale chr_US.
 */
goog.i18n.DateTimePatterns_chr_US = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale cs_CZ.
 */
goog.i18n.DateTimePatterns_cs_CZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd. M.',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd. M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. M. y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. M.',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. M. y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale cy_GB.
 */
goog.i18n.DateTimePatterns_cy_GB = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale da_DK.
 */
goog.i18n.DateTimePatterns_da_DK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale da_GL.
 */
goog.i18n.DateTimePatterns_da_GL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale dav.
 */
goog.i18n.DateTimePatterns_dav = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dav_KE.
 */
goog.i18n.DateTimePatterns_dav_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale de_BE.
 */
goog.i18n.DateTimePatterns_de_BE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale de_DE.
 */
goog.i18n.DateTimePatterns_de_DE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale de_LI.
 */
goog.i18n.DateTimePatterns_de_LI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale de_LU.
 */
goog.i18n.DateTimePatterns_de_LU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dje.
 */
goog.i18n.DateTimePatterns_dje = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dje_NE.
 */
goog.i18n.DateTimePatterns_dje_NE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dua.
 */
goog.i18n.DateTimePatterns_dua = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dua_CM.
 */
goog.i18n.DateTimePatterns_dua_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dyo.
 */
goog.i18n.DateTimePatterns_dyo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dyo_SN.
 */
goog.i18n.DateTimePatterns_dyo_SN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dz.
 */
goog.i18n.DateTimePatterns_dz = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y སྤྱི་ཟླ་MMM',
  YEAR_MONTH_FULL: 'y སྤྱི་ཟླ་MMMM',
  MONTH_DAY_ABBR: 'སྤྱི་LLL ཚེ་d',
  MONTH_DAY_FULL: 'སྤྱི་LLLL ཚེ་dd',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'སྤྱི་LLLL ཚེ་d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, སྤྱི་LLL ཚེ་d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'གཟའ་EEE, ལོy ཟླ་MMM ཚེ་d',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale dz_BT.
 */
goog.i18n.DateTimePatterns_dz_BT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y སྤྱི་ཟླ་MMM',
  YEAR_MONTH_FULL: 'y སྤྱི་ཟླ་MMMM',
  MONTH_DAY_ABBR: 'སྤྱི་LLL ཚེ་d',
  MONTH_DAY_FULL: 'སྤྱི་LLLL ཚེ་dd',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'སྤྱི་LLLL ཚེ་d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, སྤྱི་LLL ཚེ་d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'གཟའ་EEE, ལོy ཟླ་MMM ཚེ་d',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ebu.
 */
goog.i18n.DateTimePatterns_ebu = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ebu_KE.
 */
goog.i18n.DateTimePatterns_ebu_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ee.
 */
goog.i18n.DateTimePatterns_ee = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d \'lia\'',
  MONTH_DAY_FULL: 'MMMM dd \'lia\'',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d \'lia\'',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d \'lia\', y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d \'lia\'',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ee_GH.
 */
goog.i18n.DateTimePatterns_ee_GH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d \'lia\'',
  MONTH_DAY_FULL: 'MMMM dd \'lia\'',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d \'lia\'',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d \'lia\', y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d \'lia\'',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ee_TG.
 */
goog.i18n.DateTimePatterns_ee_TG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d \'lia\'',
  MONTH_DAY_FULL: 'MMMM dd \'lia\'',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d \'lia\'',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d \'lia\', y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d \'lia\'',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale el_CY.
 */
goog.i18n.DateTimePatterns_el_CY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale el_GR.
 */
goog.i18n.DateTimePatterns_el_GR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_001.
 */
goog.i18n.DateTimePatterns_en_001 = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_150.
 */
goog.i18n.DateTimePatterns_en_150 = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_AG.
 */
goog.i18n.DateTimePatterns_en_AG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_AI.
 */
goog.i18n.DateTimePatterns_en_AI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_AS.
 */
goog.i18n.DateTimePatterns_en_AS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_BB.
 */
goog.i18n.DateTimePatterns_en_BB = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_BE.
 */
goog.i18n.DateTimePatterns_en_BE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_BM.
 */
goog.i18n.DateTimePatterns_en_BM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_BS.
 */
goog.i18n.DateTimePatterns_en_BS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_BW.
 */
goog.i18n.DateTimePatterns_en_BW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'dd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'dd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE dd MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE dd MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_BZ.
 */
goog.i18n.DateTimePatterns_en_BZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'dd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'dd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE dd MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE dd MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_CA.
 */
goog.i18n.DateTimePatterns_en_CA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_CC.
 */
goog.i18n.DateTimePatterns_en_CC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_CK.
 */
goog.i18n.DateTimePatterns_en_CK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_CM.
 */
goog.i18n.DateTimePatterns_en_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_CX.
 */
goog.i18n.DateTimePatterns_en_CX = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_DG.
 */
goog.i18n.DateTimePatterns_en_DG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_DM.
 */
goog.i18n.DateTimePatterns_en_DM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_ER.
 */
goog.i18n.DateTimePatterns_en_ER = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_FJ.
 */
goog.i18n.DateTimePatterns_en_FJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_FK.
 */
goog.i18n.DateTimePatterns_en_FK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_FM.
 */
goog.i18n.DateTimePatterns_en_FM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GD.
 */
goog.i18n.DateTimePatterns_en_GD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GG.
 */
goog.i18n.DateTimePatterns_en_GG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GH.
 */
goog.i18n.DateTimePatterns_en_GH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GI.
 */
goog.i18n.DateTimePatterns_en_GI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GM.
 */
goog.i18n.DateTimePatterns_en_GM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GU.
 */
goog.i18n.DateTimePatterns_en_GU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_GY.
 */
goog.i18n.DateTimePatterns_en_GY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_HK.
 */
goog.i18n.DateTimePatterns_en_HK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_IM.
 */
goog.i18n.DateTimePatterns_en_IM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_IO.
 */
goog.i18n.DateTimePatterns_en_IO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_JE.
 */
goog.i18n.DateTimePatterns_en_JE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_JM.
 */
goog.i18n.DateTimePatterns_en_JM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_KE.
 */
goog.i18n.DateTimePatterns_en_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_KI.
 */
goog.i18n.DateTimePatterns_en_KI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_KN.
 */
goog.i18n.DateTimePatterns_en_KN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_KY.
 */
goog.i18n.DateTimePatterns_en_KY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_LC.
 */
goog.i18n.DateTimePatterns_en_LC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_LR.
 */
goog.i18n.DateTimePatterns_en_LR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_LS.
 */
goog.i18n.DateTimePatterns_en_LS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MG.
 */
goog.i18n.DateTimePatterns_en_MG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MH.
 */
goog.i18n.DateTimePatterns_en_MH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MO.
 */
goog.i18n.DateTimePatterns_en_MO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MP.
 */
goog.i18n.DateTimePatterns_en_MP = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MS.
 */
goog.i18n.DateTimePatterns_en_MS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MT.
 */
goog.i18n.DateTimePatterns_en_MT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'dd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MU.
 */
goog.i18n.DateTimePatterns_en_MU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_MW.
 */
goog.i18n.DateTimePatterns_en_MW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_NA.
 */
goog.i18n.DateTimePatterns_en_NA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_NF.
 */
goog.i18n.DateTimePatterns_en_NF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_NG.
 */
goog.i18n.DateTimePatterns_en_NG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_NR.
 */
goog.i18n.DateTimePatterns_en_NR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_NU.
 */
goog.i18n.DateTimePatterns_en_NU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_NZ.
 */
goog.i18n.DateTimePatterns_en_NZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_PG.
 */
goog.i18n.DateTimePatterns_en_PG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_PH.
 */
goog.i18n.DateTimePatterns_en_PH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_PK.
 */
goog.i18n.DateTimePatterns_en_PK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_PN.
 */
goog.i18n.DateTimePatterns_en_PN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_PR.
 */
goog.i18n.DateTimePatterns_en_PR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_PW.
 */
goog.i18n.DateTimePatterns_en_PW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_RW.
 */
goog.i18n.DateTimePatterns_en_RW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SB.
 */
goog.i18n.DateTimePatterns_en_SB = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SC.
 */
goog.i18n.DateTimePatterns_en_SC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SD.
 */
goog.i18n.DateTimePatterns_en_SD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SH.
 */
goog.i18n.DateTimePatterns_en_SH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SL.
 */
goog.i18n.DateTimePatterns_en_SL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SS.
 */
goog.i18n.DateTimePatterns_en_SS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SX.
 */
goog.i18n.DateTimePatterns_en_SX = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_SZ.
 */
goog.i18n.DateTimePatterns_en_SZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_TC.
 */
goog.i18n.DateTimePatterns_en_TC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_TK.
 */
goog.i18n.DateTimePatterns_en_TK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_TO.
 */
goog.i18n.DateTimePatterns_en_TO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_TT.
 */
goog.i18n.DateTimePatterns_en_TT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_TV.
 */
goog.i18n.DateTimePatterns_en_TV = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_TZ.
 */
goog.i18n.DateTimePatterns_en_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_UG.
 */
goog.i18n.DateTimePatterns_en_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_UM.
 */
goog.i18n.DateTimePatterns_en_UM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_US_POSIX.
 */
goog.i18n.DateTimePatterns_en_US_POSIX = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_VC.
 */
goog.i18n.DateTimePatterns_en_VC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_VG.
 */
goog.i18n.DateTimePatterns_en_VG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_VI.
 */
goog.i18n.DateTimePatterns_en_VI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_VU.
 */
goog.i18n.DateTimePatterns_en_VU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_WS.
 */
goog.i18n.DateTimePatterns_en_WS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_ZM.
 */
goog.i18n.DateTimePatterns_en_ZM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale en_ZW.
 */
goog.i18n.DateTimePatterns_en_ZW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'dd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'dd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE dd MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale eo.
 */
goog.i18n.DateTimePatterns_eo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_AR.
 */
goog.i18n.DateTimePatterns_es_AR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_BO.
 */
goog.i18n.DateTimePatterns_es_BO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_CL.
 */
goog.i18n.DateTimePatterns_es_CL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'dd-MM',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_CO.
 */
goog.i18n.DateTimePatterns_es_CO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_CR.
 */
goog.i18n.DateTimePatterns_es_CR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_CU.
 */
goog.i18n.DateTimePatterns_es_CU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_DO.
 */
goog.i18n.DateTimePatterns_es_DO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_EA.
 */
goog.i18n.DateTimePatterns_es_EA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_EC.
 */
goog.i18n.DateTimePatterns_es_EC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_GQ.
 */
goog.i18n.DateTimePatterns_es_GQ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_GT.
 */
goog.i18n.DateTimePatterns_es_GT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_HN.
 */
goog.i18n.DateTimePatterns_es_HN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_IC.
 */
goog.i18n.DateTimePatterns_es_IC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_MX.
 */
goog.i18n.DateTimePatterns_es_MX = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_NI.
 */
goog.i18n.DateTimePatterns_es_NI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_PA.
 */
goog.i18n.DateTimePatterns_es_PA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'MM/dd',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_PE.
 */
goog.i18n.DateTimePatterns_es_PE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_PH.
 */
goog.i18n.DateTimePatterns_es_PH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_PR.
 */
goog.i18n.DateTimePatterns_es_PR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'MM/dd',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_PY.
 */
goog.i18n.DateTimePatterns_es_PY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_SV.
 */
goog.i18n.DateTimePatterns_es_SV = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_US.
 */
goog.i18n.DateTimePatterns_es_US = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_UY.
 */
goog.i18n.DateTimePatterns_es_UY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale es_VE.
 */
goog.i18n.DateTimePatterns_es_VE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd \'de\' MMM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d \'de\' MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale et_EE.
 */
goog.i18n.DateTimePatterns_et_EE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale eu_ES.
 */
goog.i18n.DateTimePatterns_eu_ES = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y(\'e\')\'ko\' MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ewo.
 */
goog.i18n.DateTimePatterns_ewo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ewo_CM.
 */
goog.i18n.DateTimePatterns_ewo_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fa_AF.
 */
goog.i18n.DateTimePatterns_fa_AF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd LLL',
  MONTH_DAY_FULL: 'dd LLLL',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'd LLLL',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d LLL',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fa_IR.
 */
goog.i18n.DateTimePatterns_fa_IR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd LLL',
  MONTH_DAY_FULL: 'dd LLLL',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'd LLLL',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d LLL',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ff.
 */
goog.i18n.DateTimePatterns_ff = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ff_SN.
 */
goog.i18n.DateTimePatterns_ff_SN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fi_FI.
 */
goog.i18n.DateTimePatterns_fi_FI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fil_PH.
 */
goog.i18n.DateTimePatterns_fil_PH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fo.
 */
goog.i18n.DateTimePatterns_fo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fo_FO.
 */
goog.i18n.DateTimePatterns_fo_FO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_BE.
 */
goog.i18n.DateTimePatterns_fr_BE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_BF.
 */
goog.i18n.DateTimePatterns_fr_BF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_BI.
 */
goog.i18n.DateTimePatterns_fr_BI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_BJ.
 */
goog.i18n.DateTimePatterns_fr_BJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_BL.
 */
goog.i18n.DateTimePatterns_fr_BL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_CD.
 */
goog.i18n.DateTimePatterns_fr_CD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_CF.
 */
goog.i18n.DateTimePatterns_fr_CF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_CG.
 */
goog.i18n.DateTimePatterns_fr_CG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_CH.
 */
goog.i18n.DateTimePatterns_fr_CH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_CI.
 */
goog.i18n.DateTimePatterns_fr_CI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_CM.
 */
goog.i18n.DateTimePatterns_fr_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_DJ.
 */
goog.i18n.DateTimePatterns_fr_DJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_DZ.
 */
goog.i18n.DateTimePatterns_fr_DZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_FR.
 */
goog.i18n.DateTimePatterns_fr_FR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_GA.
 */
goog.i18n.DateTimePatterns_fr_GA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_GF.
 */
goog.i18n.DateTimePatterns_fr_GF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_GN.
 */
goog.i18n.DateTimePatterns_fr_GN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_GP.
 */
goog.i18n.DateTimePatterns_fr_GP = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_GQ.
 */
goog.i18n.DateTimePatterns_fr_GQ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_HT.
 */
goog.i18n.DateTimePatterns_fr_HT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_KM.
 */
goog.i18n.DateTimePatterns_fr_KM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_LU.
 */
goog.i18n.DateTimePatterns_fr_LU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MA.
 */
goog.i18n.DateTimePatterns_fr_MA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MC.
 */
goog.i18n.DateTimePatterns_fr_MC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MF.
 */
goog.i18n.DateTimePatterns_fr_MF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MG.
 */
goog.i18n.DateTimePatterns_fr_MG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_ML.
 */
goog.i18n.DateTimePatterns_fr_ML = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MQ.
 */
goog.i18n.DateTimePatterns_fr_MQ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MR.
 */
goog.i18n.DateTimePatterns_fr_MR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_MU.
 */
goog.i18n.DateTimePatterns_fr_MU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_NC.
 */
goog.i18n.DateTimePatterns_fr_NC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_NE.
 */
goog.i18n.DateTimePatterns_fr_NE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_PF.
 */
goog.i18n.DateTimePatterns_fr_PF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_PM.
 */
goog.i18n.DateTimePatterns_fr_PM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_RE.
 */
goog.i18n.DateTimePatterns_fr_RE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_RW.
 */
goog.i18n.DateTimePatterns_fr_RW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_SC.
 */
goog.i18n.DateTimePatterns_fr_SC = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_SN.
 */
goog.i18n.DateTimePatterns_fr_SN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_SY.
 */
goog.i18n.DateTimePatterns_fr_SY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_TD.
 */
goog.i18n.DateTimePatterns_fr_TD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_TG.
 */
goog.i18n.DateTimePatterns_fr_TG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_TN.
 */
goog.i18n.DateTimePatterns_fr_TN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_VU.
 */
goog.i18n.DateTimePatterns_fr_VU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_WF.
 */
goog.i18n.DateTimePatterns_fr_WF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale fr_YT.
 */
goog.i18n.DateTimePatterns_fr_YT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ga.
 */
goog.i18n.DateTimePatterns_ga = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ga_IE.
 */
goog.i18n.DateTimePatterns_ga_IE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale gl_ES.
 */
goog.i18n.DateTimePatterns_gl_ES = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale gsw_CH.
 */
goog.i18n.DateTimePatterns_gsw_CH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale gsw_LI.
 */
goog.i18n.DateTimePatterns_gsw_LI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale gu_IN.
 */
goog.i18n.DateTimePatterns_gu_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale guz.
 */
goog.i18n.DateTimePatterns_guz = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale guz_KE.
 */
goog.i18n.DateTimePatterns_guz_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale gv.
 */
goog.i18n.DateTimePatterns_gv = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale gv_IM.
 */
goog.i18n.DateTimePatterns_gv_IM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ha.
 */
goog.i18n.DateTimePatterns_ha = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ha_Latn.
 */
goog.i18n.DateTimePatterns_ha_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ha_Latn_GH.
 */
goog.i18n.DateTimePatterns_ha_Latn_GH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ha_Latn_NE.
 */
goog.i18n.DateTimePatterns_ha_Latn_NE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ha_Latn_NG.
 */
goog.i18n.DateTimePatterns_ha_Latn_NG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale haw_US.
 */
goog.i18n.DateTimePatterns_haw_US = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale he_IL.
 */
goog.i18n.DateTimePatterns_he_IL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd בMMM',
  MONTH_DAY_FULL: 'dd בMMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd בMMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd בMMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d בMMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d בMMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale hi_IN.
 */
goog.i18n.DateTimePatterns_hi_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale hr_BA.
 */
goog.i18n.DateTimePatterns_hr_BA = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'LLL y.',
  YEAR_MONTH_FULL: 'LLLL y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd. M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale hr_HR.
 */
goog.i18n.DateTimePatterns_hr_HR = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'LLL y.',
  YEAR_MONTH_FULL: 'LLLL y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd. M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale hu_HU.
 */
goog.i18n.DateTimePatterns_hu_HU = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'G y.',
  YEAR_MONTH_ABBR: 'y. MMM',
  YEAR_MONTH_FULL: 'y. MMMM',
  MONTH_DAY_ABBR: 'MMM d.',
  MONTH_DAY_FULL: 'MMMM dd.',
  MONTH_DAY_SHORT: 'M. d.',
  MONTH_DAY_MEDIUM: 'MMMM d.',
  MONTH_DAY_YEAR_MEDIUM: 'y. MMM d.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d., EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y. MMM d., EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale hy_AM.
 */
goog.i18n.DateTimePatterns_hy_AM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G yթ.',
  YEAR_MONTH_ABBR: 'yթ. LLL',
  YEAR_MONTH_FULL: 'yթ. LLLL',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, yթ.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd MMM, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'yթ. MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale id_ID.
 */
goog.i18n.DateTimePatterns_id_ID = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ig.
 */
goog.i18n.DateTimePatterns_ig = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ig_NG.
 */
goog.i18n.DateTimePatterns_ig_NG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ii.
 */
goog.i18n.DateTimePatterns_ii = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ii_CN.
 */
goog.i18n.DateTimePatterns_ii_CN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale is_IS.
 */
goog.i18n.DateTimePatterns_is_IS = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale it_CH.
 */
goog.i18n.DateTimePatterns_it_CH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale it_IT.
 */
goog.i18n.DateTimePatterns_it_IT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale it_SM.
 */
goog.i18n.DateTimePatterns_it_SM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ja_JP.
 */
goog.i18n.DateTimePatterns_ja_JP = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'Gy年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日(EEE)',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日(EEE)',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale jgo.
 */
goog.i18n.DateTimePatterns_jgo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale jgo_CM.
 */
goog.i18n.DateTimePatterns_jgo_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale jmc.
 */
goog.i18n.DateTimePatterns_jmc = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale jmc_TZ.
 */
goog.i18n.DateTimePatterns_jmc_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ka_GE.
 */
goog.i18n.DateTimePatterns_ka_GE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM, y',
  YEAR_MONTH_FULL: 'MMMM, y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kab.
 */
goog.i18n.DateTimePatterns_kab = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kab_DZ.
 */
goog.i18n.DateTimePatterns_kab_DZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kam.
 */
goog.i18n.DateTimePatterns_kam = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kam_KE.
 */
goog.i18n.DateTimePatterns_kam_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kde.
 */
goog.i18n.DateTimePatterns_kde = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kde_TZ.
 */
goog.i18n.DateTimePatterns_kde_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kea.
 */
goog.i18n.DateTimePatterns_kea = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM \'di\' y',
  YEAR_MONTH_FULL: 'MMMM \'di\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd \'di\' MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd \'di\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'di\' MMM \'di\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kea_CV.
 */
goog.i18n.DateTimePatterns_kea_CV = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM \'di\' y',
  YEAR_MONTH_FULL: 'MMMM \'di\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd \'di\' MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd \'di\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'di\' MMM \'di\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale khq.
 */
goog.i18n.DateTimePatterns_khq = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale khq_ML.
 */
goog.i18n.DateTimePatterns_khq_ML = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ki.
 */
goog.i18n.DateTimePatterns_ki = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ki_KE.
 */
goog.i18n.DateTimePatterns_ki_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kk_Cyrl.
 */
goog.i18n.DateTimePatterns_kk_Cyrl = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd-MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kk_Cyrl_KZ.
 */
goog.i18n.DateTimePatterns_kk_Cyrl_KZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd-MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kkj.
 */
goog.i18n.DateTimePatterns_kkj = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kkj_CM.
 */
goog.i18n.DateTimePatterns_kkj_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kl.
 */
goog.i18n.DateTimePatterns_kl = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kl_GL.
 */
goog.i18n.DateTimePatterns_kl_GL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kln.
 */
goog.i18n.DateTimePatterns_kln = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kln_KE.
 */
goog.i18n.DateTimePatterns_kln_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale km_KH.
 */
goog.i18n.DateTimePatterns_km_KH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y នៃ G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kn_IN.
 */
goog.i18n.DateTimePatterns_kn_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd, MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'd MMM, y EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ko_KP.
 */
goog.i18n.DateTimePatterns_ko_KP = {
  YEAR_FULL: 'y년',
  YEAR_FULL_WITH_ERA: 'G y년',
  YEAR_MONTH_ABBR: 'y년 MMM',
  YEAR_MONTH_FULL: 'y년 MMMM',
  MONTH_DAY_ABBR: 'MMM d일',
  MONTH_DAY_FULL: 'MMMM dd일',
  MONTH_DAY_SHORT: 'M. d.',
  MONTH_DAY_MEDIUM: 'MMMM d일',
  MONTH_DAY_YEAR_MEDIUM: 'y년 MMM d일',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d일 (EEE)',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y년 MMM d일 (EEE)',
  DAY_ABBR: 'd일'
};


/**
 * Extended set of localized date/time patterns for locale ko_KR.
 */
goog.i18n.DateTimePatterns_ko_KR = {
  YEAR_FULL: 'y년',
  YEAR_FULL_WITH_ERA: 'G y년',
  YEAR_MONTH_ABBR: 'y년 MMM',
  YEAR_MONTH_FULL: 'y년 MMMM',
  MONTH_DAY_ABBR: 'MMM d일',
  MONTH_DAY_FULL: 'MMMM dd일',
  MONTH_DAY_SHORT: 'M. d.',
  MONTH_DAY_MEDIUM: 'MMMM d일',
  MONTH_DAY_YEAR_MEDIUM: 'y년 MMM d일',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d일 (EEE)',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y년 MMM d일 (EEE)',
  DAY_ABBR: 'd일'
};


/**
 * Extended set of localized date/time patterns for locale kok.
 */
goog.i18n.DateTimePatterns_kok = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kok_IN.
 */
goog.i18n.DateTimePatterns_kok_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ks.
 */
goog.i18n.DateTimePatterns_ks = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'Gy',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ks_Arab.
 */
goog.i18n.DateTimePatterns_ks_Arab = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'Gy',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ks_Arab_IN.
 */
goog.i18n.DateTimePatterns_ks_Arab_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'Gy',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ksb.
 */
goog.i18n.DateTimePatterns_ksb = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ksb_TZ.
 */
goog.i18n.DateTimePatterns_ksb_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ksf.
 */
goog.i18n.DateTimePatterns_ksf = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ksf_CM.
 */
goog.i18n.DateTimePatterns_ksf_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kw.
 */
goog.i18n.DateTimePatterns_kw = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale kw_GB.
 */
goog.i18n.DateTimePatterns_kw_GB = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ky_Cyrl.
 */
goog.i18n.DateTimePatterns_ky_Cyrl = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y-\'ж\'.',
  YEAR_MONTH_ABBR: 'y-\'ж\'. MMM',
  YEAR_MONTH_FULL: 'y-\'ж\'. MMMM',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'dd-MMMM',
  MONTH_DAY_SHORT: 'dd-MM',
  MONTH_DAY_MEDIUM: 'd-MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y-\'ж\'. d-MMM',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd-MMM, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y-\'ж\'. d-MMM, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ky_Cyrl_KG.
 */
goog.i18n.DateTimePatterns_ky_Cyrl_KG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y-\'ж\'.',
  YEAR_MONTH_ABBR: 'y-\'ж\'. MMM',
  YEAR_MONTH_FULL: 'y-\'ж\'. MMMM',
  MONTH_DAY_ABBR: 'd-MMM',
  MONTH_DAY_FULL: 'dd-MMMM',
  MONTH_DAY_SHORT: 'dd-MM',
  MONTH_DAY_MEDIUM: 'd-MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y-\'ж\'. d-MMM',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd-MMM, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y-\'ж\'. d-MMM, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lag.
 */
goog.i18n.DateTimePatterns_lag = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lag_TZ.
 */
goog.i18n.DateTimePatterns_lag_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lg.
 */
goog.i18n.DateTimePatterns_lg = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lg_UG.
 */
goog.i18n.DateTimePatterns_lg_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lkt.
 */
goog.i18n.DateTimePatterns_lkt = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lkt_US.
 */
goog.i18n.DateTimePatterns_lkt_US = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ln_AO.
 */
goog.i18n.DateTimePatterns_ln_AO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ln_CD.
 */
goog.i18n.DateTimePatterns_ln_CD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ln_CF.
 */
goog.i18n.DateTimePatterns_ln_CF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ln_CG.
 */
goog.i18n.DateTimePatterns_ln_CG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lo_LA.
 */
goog.i18n.DateTimePatterns_lo_LA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lt_LT.
 */
goog.i18n.DateTimePatterns_lt_LT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'dd'
};


/**
 * Extended set of localized date/time patterns for locale lu.
 */
goog.i18n.DateTimePatterns_lu = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lu_CD.
 */
goog.i18n.DateTimePatterns_lu_CD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale luo.
 */
goog.i18n.DateTimePatterns_luo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale luo_KE.
 */
goog.i18n.DateTimePatterns_luo_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale luy.
 */
goog.i18n.DateTimePatterns_luy = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale luy_KE.
 */
goog.i18n.DateTimePatterns_luy_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale lv_LV.
 */
goog.i18n.DateTimePatterns_lv_LV = {
  YEAR_FULL: 'y. \'g\'.',
  YEAR_FULL_WITH_ERA: 'G y. \'g\'.',
  YEAR_MONTH_ABBR: 'y. \'g\'. MMM',
  YEAR_MONTH_FULL: 'y. \'g\'. MMMM',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'dd.MM.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y. \'g\'. d. MMM',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, y. \'g\'. d. MMM',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mas.
 */
goog.i18n.DateTimePatterns_mas = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mas_KE.
 */
goog.i18n.DateTimePatterns_mas_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mas_TZ.
 */
goog.i18n.DateTimePatterns_mas_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mer.
 */
goog.i18n.DateTimePatterns_mer = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mer_KE.
 */
goog.i18n.DateTimePatterns_mer_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mfe.
 */
goog.i18n.DateTimePatterns_mfe = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mfe_MU.
 */
goog.i18n.DateTimePatterns_mfe_MU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mg.
 */
goog.i18n.DateTimePatterns_mg = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mg_MG.
 */
goog.i18n.DateTimePatterns_mg_MG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mgh.
 */
goog.i18n.DateTimePatterns_mgh = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mgh_MZ.
 */
goog.i18n.DateTimePatterns_mgh_MZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mgo.
 */
goog.i18n.DateTimePatterns_mgo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mgo_CM.
 */
goog.i18n.DateTimePatterns_mgo_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mk_MK.
 */
goog.i18n.DateTimePatterns_mk_MK = {
  YEAR_FULL: 'y \'г\'.',
  YEAR_FULL_WITH_ERA: 'y \'г\'. G',
  YEAR_MONTH_ABBR: 'MMM y \'г\'.',
  YEAR_MONTH_FULL: 'MMMM y \'г\'.',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd.M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y \'г\'.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ml_IN.
 */
goog.i18n.DateTimePatterns_ml_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mn_Cyrl.
 */
goog.i18n.DateTimePatterns_mn_Cyrl = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, y MMM d',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mn_Cyrl_MN.
 */
goog.i18n.DateTimePatterns_mn_Cyrl_MN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, y MMM d',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mr_IN.
 */
goog.i18n.DateTimePatterns_mr_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d, MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ms_Latn.
 */
goog.i18n.DateTimePatterns_ms_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ms_Latn_BN.
 */
goog.i18n.DateTimePatterns_ms_Latn_BN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ms_Latn_MY.
 */
goog.i18n.DateTimePatterns_ms_Latn_MY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ms_Latn_SG.
 */
goog.i18n.DateTimePatterns_ms_Latn_SG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mt_MT.
 */
goog.i18n.DateTimePatterns_mt_MT = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mua.
 */
goog.i18n.DateTimePatterns_mua = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale mua_CM.
 */
goog.i18n.DateTimePatterns_mua_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale my_MM.
 */
goog.i18n.DateTimePatterns_my_MM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, y MMM d',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale naq.
 */
goog.i18n.DateTimePatterns_naq = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale naq_NA.
 */
goog.i18n.DateTimePatterns_naq_NA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nb_NO.
 */
goog.i18n.DateTimePatterns_nb_NO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale nb_SJ.
 */
goog.i18n.DateTimePatterns_nb_SJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale nd.
 */
goog.i18n.DateTimePatterns_nd = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nd_ZW.
 */
goog.i18n.DateTimePatterns_nd_ZW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ne_IN.
 */
goog.i18n.DateTimePatterns_ne_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ne_NP.
 */
goog.i18n.DateTimePatterns_ne_NP = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_AW.
 */
goog.i18n.DateTimePatterns_nl_AW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_BE.
 */
goog.i18n.DateTimePatterns_nl_BE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_BQ.
 */
goog.i18n.DateTimePatterns_nl_BQ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_CW.
 */
goog.i18n.DateTimePatterns_nl_CW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_NL.
 */
goog.i18n.DateTimePatterns_nl_NL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_SR.
 */
goog.i18n.DateTimePatterns_nl_SR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nl_SX.
 */
goog.i18n.DateTimePatterns_nl_SX = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nmg.
 */
goog.i18n.DateTimePatterns_nmg = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nmg_CM.
 */
goog.i18n.DateTimePatterns_nmg_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nn.
 */
goog.i18n.DateTimePatterns_nn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale nn_NO.
 */
goog.i18n.DateTimePatterns_nn_NO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale nnh.
 */
goog.i18n.DateTimePatterns_nnh = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: '\'lyɛ\'̌ʼ d \'na\' MMMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE , \'lyɛ\'̌ʼ d \'na\' MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nnh_CM.
 */
goog.i18n.DateTimePatterns_nnh_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: '\'lyɛ\'̌ʼ d \'na\' MMMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE , \'lyɛ\'̌ʼ d \'na\' MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nus.
 */
goog.i18n.DateTimePatterns_nus = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nus_SD.
 */
goog.i18n.DateTimePatterns_nus_SD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nyn.
 */
goog.i18n.DateTimePatterns_nyn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale nyn_UG.
 */
goog.i18n.DateTimePatterns_nyn_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale om.
 */
goog.i18n.DateTimePatterns_om = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale om_ET.
 */
goog.i18n.DateTimePatterns_om_ET = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale om_KE.
 */
goog.i18n.DateTimePatterns_om_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale or_IN.
 */
goog.i18n.DateTimePatterns_or_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pa_Arab.
 */
goog.i18n.DateTimePatterns_pa_Arab = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pa_Arab_PK.
 */
goog.i18n.DateTimePatterns_pa_Arab_PK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pa_Guru.
 */
goog.i18n.DateTimePatterns_pa_Guru = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pa_Guru_IN.
 */
goog.i18n.DateTimePatterns_pa_Guru_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pl_PL.
 */
goog.i18n.DateTimePatterns_pl_PL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ps.
 */
goog.i18n.DateTimePatterns_ps = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ps_AF.
 */
goog.i18n.DateTimePatterns_ps_AF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_AO.
 */
goog.i18n.DateTimePatterns_pt_AO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_CV.
 */
goog.i18n.DateTimePatterns_pt_CV = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_GW.
 */
goog.i18n.DateTimePatterns_pt_GW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_MO.
 */
goog.i18n.DateTimePatterns_pt_MO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_MZ.
 */
goog.i18n.DateTimePatterns_pt_MZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_ST.
 */
goog.i18n.DateTimePatterns_pt_ST = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale pt_TL.
 */
goog.i18n.DateTimePatterns_pt_TL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MM/y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd/MM',
  MONTH_DAY_FULL: 'dd \'de\' MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd \'de\' MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd/MM/y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d/MM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d/MM/y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rm.
 */
goog.i18n.DateTimePatterns_rm = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rm_CH.
 */
goog.i18n.DateTimePatterns_rm_CH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rn.
 */
goog.i18n.DateTimePatterns_rn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rn_BI.
 */
goog.i18n.DateTimePatterns_rn_BI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ro_MD.
 */
goog.i18n.DateTimePatterns_ro_MD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ro_RO.
 */
goog.i18n.DateTimePatterns_ro_RO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rof.
 */
goog.i18n.DateTimePatterns_rof = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rof_TZ.
 */
goog.i18n.DateTimePatterns_rof_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ru_BY.
 */
goog.i18n.DateTimePatterns_ru_BY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ru_KG.
 */
goog.i18n.DateTimePatterns_ru_KG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ru_KZ.
 */
goog.i18n.DateTimePatterns_ru_KZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ru_MD.
 */
goog.i18n.DateTimePatterns_ru_MD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ru_RU.
 */
goog.i18n.DateTimePatterns_ru_RU = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y \'г\'.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ru_UA.
 */
goog.i18n.DateTimePatterns_ru_UA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'ccc, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rw.
 */
goog.i18n.DateTimePatterns_rw = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rw_RW.
 */
goog.i18n.DateTimePatterns_rw_RW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rwk.
 */
goog.i18n.DateTimePatterns_rwk = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale rwk_TZ.
 */
goog.i18n.DateTimePatterns_rwk_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale saq.
 */
goog.i18n.DateTimePatterns_saq = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale saq_KE.
 */
goog.i18n.DateTimePatterns_saq_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sbp.
 */
goog.i18n.DateTimePatterns_sbp = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sbp_TZ.
 */
goog.i18n.DateTimePatterns_sbp_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale seh.
 */
goog.i18n.DateTimePatterns_seh = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale seh_MZ.
 */
goog.i18n.DateTimePatterns_seh_MZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM \'de\' y',
  YEAR_MONTH_FULL: 'MMMM \'de\' y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd \'de\' MMM \'de\' y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d \'de\' MMM \'de\' y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ses.
 */
goog.i18n.DateTimePatterns_ses = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ses_ML.
 */
goog.i18n.DateTimePatterns_ses_ML = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sg.
 */
goog.i18n.DateTimePatterns_sg = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sg_CF.
 */
goog.i18n.DateTimePatterns_sg_CF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale shi.
 */
goog.i18n.DateTimePatterns_shi = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale shi_Latn.
 */
goog.i18n.DateTimePatterns_shi_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale shi_Latn_MA.
 */
goog.i18n.DateTimePatterns_shi_Latn_MA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale shi_Tfng.
 */
goog.i18n.DateTimePatterns_shi_Tfng = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale shi_Tfng_MA.
 */
goog.i18n.DateTimePatterns_shi_Tfng_MA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale si_LK.
 */
goog.i18n.DateTimePatterns_si_LK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sk_SK.
 */
goog.i18n.DateTimePatterns_sk_SK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd. MMM.',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd.M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd.M.y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM.',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd.'
};


/**
 * Extended set of localized date/time patterns for locale sl_SI.
 */
goog.i18n.DateTimePatterns_sl_SI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd. M.',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sn.
 */
goog.i18n.DateTimePatterns_sn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sn_ZW.
 */
goog.i18n.DateTimePatterns_sn_ZW = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale so.
 */
goog.i18n.DateTimePatterns_so = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale so_DJ.
 */
goog.i18n.DateTimePatterns_so_DJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale so_ET.
 */
goog.i18n.DateTimePatterns_so_ET = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale so_KE.
 */
goog.i18n.DateTimePatterns_so_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale so_SO.
 */
goog.i18n.DateTimePatterns_so_SO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sq_AL.
 */
goog.i18n.DateTimePatterns_sq_AL = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sq_MK.
 */
goog.i18n.DateTimePatterns_sq_MK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sq_XK.
 */
goog.i18n.DateTimePatterns_sq_XK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Cyrl.
 */
goog.i18n.DateTimePatterns_sr_Cyrl = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Cyrl_BA.
 */
goog.i18n.DateTimePatterns_sr_Cyrl_BA = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Cyrl_ME.
 */
goog.i18n.DateTimePatterns_sr_Cyrl_ME = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Cyrl_RS.
 */
goog.i18n.DateTimePatterns_sr_Cyrl_RS = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Cyrl_XK.
 */
goog.i18n.DateTimePatterns_sr_Cyrl_XK = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Latn.
 */
goog.i18n.DateTimePatterns_sr_Latn = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Latn_BA.
 */
goog.i18n.DateTimePatterns_sr_Latn_BA = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Latn_ME.
 */
goog.i18n.DateTimePatterns_sr_Latn_ME = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Latn_RS.
 */
goog.i18n.DateTimePatterns_sr_Latn_RS = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sr_Latn_XK.
 */
goog.i18n.DateTimePatterns_sr_Latn_XK = {
  YEAR_FULL: 'y.',
  YEAR_FULL_WITH_ERA: 'y. G',
  YEAR_MONTH_ABBR: 'MMM y.',
  YEAR_MONTH_FULL: 'MMMM y.',
  MONTH_DAY_ABBR: 'd. MMM',
  MONTH_DAY_FULL: 'dd. MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd. MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd. MMM y.',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d. MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d. MMM y.',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sv_AX.
 */
goog.i18n.DateTimePatterns_sv_AX = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sv_FI.
 */
goog.i18n.DateTimePatterns_sv_FI = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sv_SE.
 */
goog.i18n.DateTimePatterns_sv_SE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sw_KE.
 */
goog.i18n.DateTimePatterns_sw_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sw_TZ.
 */
goog.i18n.DateTimePatterns_sw_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale sw_UG.
 */
goog.i18n.DateTimePatterns_sw_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd-M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale swc.
 */
goog.i18n.DateTimePatterns_swc = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale swc_CD.
 */
goog.i18n.DateTimePatterns_swc_CD = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ta_IN.
 */
goog.i18n.DateTimePatterns_ta_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ta_LK.
 */
goog.i18n.DateTimePatterns_ta_LK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ta_MY.
 */
goog.i18n.DateTimePatterns_ta_MY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ta_SG.
 */
goog.i18n.DateTimePatterns_ta_SG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale te_IN.
 */
goog.i18n.DateTimePatterns_te_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd, MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d, MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale teo.
 */
goog.i18n.DateTimePatterns_teo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale teo_KE.
 */
goog.i18n.DateTimePatterns_teo_KE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale teo_UG.
 */
goog.i18n.DateTimePatterns_teo_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale th_TH.
 */
goog.i18n.DateTimePatterns_th_TH = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ti.
 */
goog.i18n.DateTimePatterns_ti = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ti_ER.
 */
goog.i18n.DateTimePatterns_ti_ER = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ti_ET.
 */
goog.i18n.DateTimePatterns_ti_ET = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd-MMM-y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale to.
 */
goog.i18n.DateTimePatterns_to = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale to_TO.
 */
goog.i18n.DateTimePatterns_to_TO = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale tr_CY.
 */
goog.i18n.DateTimePatterns_tr_CY = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'dd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd MMMM EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'd MMM y EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale tr_TR.
 */
goog.i18n.DateTimePatterns_tr_TR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd/MM',
  MONTH_DAY_MEDIUM: 'dd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'd MMMM EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'd MMM y EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale twq.
 */
goog.i18n.DateTimePatterns_twq = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale twq_NE.
 */
goog.i18n.DateTimePatterns_twq_NE = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale tzm.
 */
goog.i18n.DateTimePatterns_tzm = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale tzm_Latn.
 */
goog.i18n.DateTimePatterns_tzm_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale tzm_Latn_MA.
 */
goog.i18n.DateTimePatterns_tzm_Latn_MA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ug.
 */
goog.i18n.DateTimePatterns_ug = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، MMM d، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ug_Arab.
 */
goog.i18n.DateTimePatterns_ug_Arab = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، MMM d، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ug_Arab_CN.
 */
goog.i18n.DateTimePatterns_ug_Arab_CN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، MMM d، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uk_UA.
 */
goog.i18n.DateTimePatterns_uk_UA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'LLL y',
  YEAR_MONTH_FULL: 'LLLL y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd.MM',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ur_IN.
 */
goog.i18n.DateTimePatterns_ur_IN = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale ur_PK.
 */
goog.i18n.DateTimePatterns_ur_PK = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM، y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE، d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE، d MMM، y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uz_Arab.
 */
goog.i18n.DateTimePatterns_uz_Arab = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uz_Arab_AF.
 */
goog.i18n.DateTimePatterns_uz_Arab_AF = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uz_Cyrl.
 */
goog.i18n.DateTimePatterns_uz_Cyrl = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uz_Cyrl_UZ.
 */
goog.i18n.DateTimePatterns_uz_Cyrl_UZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uz_Latn.
 */
goog.i18n.DateTimePatterns_uz_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale uz_Latn_UZ.
 */
goog.i18n.DateTimePatterns_uz_Latn_UZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'y MMM',
  YEAR_MONTH_FULL: 'y MMMM',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'MM-dd',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'y MMM d',
  WEEKDAY_MONTH_DAY_MEDIUM: 'MMM d, EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y MMM d, EEE',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vai.
 */
goog.i18n.DateTimePatterns_vai = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vai_Latn.
 */
goog.i18n.DateTimePatterns_vai_Latn = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vai_Latn_LR.
 */
goog.i18n.DateTimePatterns_vai_Latn_LR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vai_Vaii.
 */
goog.i18n.DateTimePatterns_vai_Vaii = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vai_Vaii_LR.
 */
goog.i18n.DateTimePatterns_vai_Vaii_LR = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vi_VN.
 */
goog.i18n.DateTimePatterns_vi_VN = {
  YEAR_FULL: '\'Năm\' y',
  YEAR_FULL_WITH_ERA: '\'Năm\' y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'dd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'dd-M',
  MONTH_DAY_MEDIUM: 'dd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'dd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, dd MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, dd MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vun.
 */
goog.i18n.DateTimePatterns_vun = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale vun_TZ.
 */
goog.i18n.DateTimePatterns_vun_TZ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale xog.
 */
goog.i18n.DateTimePatterns_xog = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale xog_UG.
 */
goog.i18n.DateTimePatterns_xog_UG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale yav.
 */
goog.i18n.DateTimePatterns_yav = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale yav_CM.
 */
goog.i18n.DateTimePatterns_yav_CM = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale yo.
 */
goog.i18n.DateTimePatterns_yo = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale yo_BJ.
 */
goog.i18n.DateTimePatterns_yo_BJ = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale yo_NG.
 */
goog.i18n.DateTimePatterns_yo_NG = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale zgh.
 */
goog.i18n.DateTimePatterns_zgh = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale zgh_MA.
 */
goog.i18n.DateTimePatterns_zgh_MA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'G y',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'd MMM',
  MONTH_DAY_FULL: 'dd MMMM',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'd MMMM',
  MONTH_DAY_YEAR_MEDIUM: 'd MMM, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE d MMM',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE d MMM y',
  DAY_ABBR: 'd'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hans.
 */
goog.i18n.DateTimePatterns_zh_Hans = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'Gy年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hans_CN.
 */
goog.i18n.DateTimePatterns_zh_Hans_CN = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'Gy年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hans_HK.
 */
goog.i18n.DateTimePatterns_zh_Hans_HK = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'Gy年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月d日',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hans_MO.
 */
goog.i18n.DateTimePatterns_zh_Hans_MO = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'Gy年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月d日',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hans_SG.
 */
goog.i18n.DateTimePatterns_zh_Hans_SG = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'Gy年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月d日',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hant.
 */
goog.i18n.DateTimePatterns_zh_Hant = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'G y 年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hant_HK.
 */
goog.i18n.DateTimePatterns_zh_Hant_HK = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'G y 年',
  YEAR_MONTH_ABBR: 'y 年 M 月',
  YEAR_MONTH_FULL: 'y 年 M 月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'd/M',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y 年 M 月 d 日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日 (EEE)',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y 年 M 月 d 日 (EEE)',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hant_MO.
 */
goog.i18n.DateTimePatterns_zh_Hant_MO = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'G y 年',
  YEAR_MONTH_ABBR: 'y 年 M 月',
  YEAR_MONTH_FULL: 'y 年 M 月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'M-d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y 年 M 月 d 日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日 (EEE)',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y 年 M 月 d 日 (EEE)',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zh_Hant_TW.
 */
goog.i18n.DateTimePatterns_zh_Hant_TW = {
  YEAR_FULL: 'y年',
  YEAR_FULL_WITH_ERA: 'G y 年',
  YEAR_MONTH_ABBR: 'y年M月',
  YEAR_MONTH_FULL: 'y年M月',
  MONTH_DAY_ABBR: 'M月d日',
  MONTH_DAY_FULL: 'M月dd日',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'M月d日',
  MONTH_DAY_YEAR_MEDIUM: 'y年M月d日',
  WEEKDAY_MONTH_DAY_MEDIUM: 'M月d日EEE',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'y年M月d日EEE',
  DAY_ABBR: 'd日'
};


/**
 * Extended set of localized date/time patterns for locale zu_ZA.
 */
goog.i18n.DateTimePatterns_zu_ZA = {
  YEAR_FULL: 'y',
  YEAR_FULL_WITH_ERA: 'y G',
  YEAR_MONTH_ABBR: 'MMM y',
  YEAR_MONTH_FULL: 'MMMM y',
  MONTH_DAY_ABBR: 'MMM d',
  MONTH_DAY_FULL: 'MMMM dd',
  MONTH_DAY_SHORT: 'M/d',
  MONTH_DAY_MEDIUM: 'MMMM d',
  MONTH_DAY_YEAR_MEDIUM: 'MMM d, y',
  WEEKDAY_MONTH_DAY_MEDIUM: 'EEE, MMM d',
  WEEKDAY_MONTH_DAY_YEAR_MEDIUM: 'EEE, MMM d, y',
  DAY_ABBR: 'd'
};


/**
/* Select date/time pattern by locale.
 */
if (goog.LOCALE == 'af_NA' || goog.LOCALE == 'af-NA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_af_NA;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_af_ZA;
}

if (goog.LOCALE == 'agq') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_agq;
}

if (goog.LOCALE == 'agq_CM' || goog.LOCALE == 'agq-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_agq_CM;
}

if (goog.LOCALE == 'ak') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ak;
}

if (goog.LOCALE == 'ak_GH' || goog.LOCALE == 'ak-GH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ak_GH;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_am_ET;
}

if (goog.LOCALE == 'ar_001' || goog.LOCALE == 'ar-001') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_001;
}

if (goog.LOCALE == 'ar_AE' || goog.LOCALE == 'ar-AE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_AE;
}

if (goog.LOCALE == 'ar_BH' || goog.LOCALE == 'ar-BH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_BH;
}

if (goog.LOCALE == 'ar_DJ' || goog.LOCALE == 'ar-DJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_DJ;
}

if (goog.LOCALE == 'ar_DZ' || goog.LOCALE == 'ar-DZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_DZ;
}

if (goog.LOCALE == 'ar_EG' || goog.LOCALE == 'ar-EG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_EG;
}

if (goog.LOCALE == 'ar_EH' || goog.LOCALE == 'ar-EH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_EH;
}

if (goog.LOCALE == 'ar_ER' || goog.LOCALE == 'ar-ER') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_ER;
}

if (goog.LOCALE == 'ar_IL' || goog.LOCALE == 'ar-IL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_IL;
}

if (goog.LOCALE == 'ar_IQ' || goog.LOCALE == 'ar-IQ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_IQ;
}

if (goog.LOCALE == 'ar_JO' || goog.LOCALE == 'ar-JO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_JO;
}

if (goog.LOCALE == 'ar_KM' || goog.LOCALE == 'ar-KM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_KM;
}

if (goog.LOCALE == 'ar_KW' || goog.LOCALE == 'ar-KW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_KW;
}

if (goog.LOCALE == 'ar_LB' || goog.LOCALE == 'ar-LB') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_LB;
}

if (goog.LOCALE == 'ar_LY' || goog.LOCALE == 'ar-LY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_LY;
}

if (goog.LOCALE == 'ar_MA' || goog.LOCALE == 'ar-MA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_MA;
}

if (goog.LOCALE == 'ar_MR' || goog.LOCALE == 'ar-MR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_MR;
}

if (goog.LOCALE == 'ar_OM' || goog.LOCALE == 'ar-OM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_OM;
}

if (goog.LOCALE == 'ar_PS' || goog.LOCALE == 'ar-PS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_PS;
}

if (goog.LOCALE == 'ar_QA' || goog.LOCALE == 'ar-QA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_QA;
}

if (goog.LOCALE == 'ar_SA' || goog.LOCALE == 'ar-SA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_SA;
}

if (goog.LOCALE == 'ar_SD' || goog.LOCALE == 'ar-SD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_SD;
}

if (goog.LOCALE == 'ar_SO' || goog.LOCALE == 'ar-SO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_SO;
}

if (goog.LOCALE == 'ar_SS' || goog.LOCALE == 'ar-SS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_SS;
}

if (goog.LOCALE == 'ar_SY' || goog.LOCALE == 'ar-SY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_SY;
}

if (goog.LOCALE == 'ar_TD' || goog.LOCALE == 'ar-TD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_TD;
}

if (goog.LOCALE == 'ar_TN' || goog.LOCALE == 'ar-TN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_TN;
}

if (goog.LOCALE == 'ar_YE' || goog.LOCALE == 'ar-YE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ar_YE;
}

if (goog.LOCALE == 'as') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_as;
}

if (goog.LOCALE == 'as_IN' || goog.LOCALE == 'as-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_as_IN;
}

if (goog.LOCALE == 'asa') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_asa;
}

if (goog.LOCALE == 'asa_TZ' || goog.LOCALE == 'asa-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_asa_TZ;
}

if (goog.LOCALE == 'az_Cyrl' || goog.LOCALE == 'az-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_az_Cyrl;
}

if (goog.LOCALE == 'az_Cyrl_AZ' || goog.LOCALE == 'az-Cyrl-AZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_az_Cyrl_AZ;
}

if (goog.LOCALE == 'az_Latn' || goog.LOCALE == 'az-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_az_Latn;
}

if (goog.LOCALE == 'az_Latn_AZ' || goog.LOCALE == 'az-Latn-AZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_az_Latn_AZ;
}

if (goog.LOCALE == 'bas') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bas;
}

if (goog.LOCALE == 'bas_CM' || goog.LOCALE == 'bas-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bas_CM;
}

if (goog.LOCALE == 'be') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_be;
}

if (goog.LOCALE == 'be_BY' || goog.LOCALE == 'be-BY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_be_BY;
}

if (goog.LOCALE == 'bem') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bem;
}

if (goog.LOCALE == 'bem_ZM' || goog.LOCALE == 'bem-ZM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bem_ZM;
}

if (goog.LOCALE == 'bez') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bez;
}

if (goog.LOCALE == 'bez_TZ' || goog.LOCALE == 'bez-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bez_TZ;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bg_BG;
}

if (goog.LOCALE == 'bm') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bm;
}

if (goog.LOCALE == 'bm_ML' || goog.LOCALE == 'bm-ML') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bm_ML;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bn_BD;
}

if (goog.LOCALE == 'bn_IN' || goog.LOCALE == 'bn-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bn_IN;
}

if (goog.LOCALE == 'bo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bo;
}

if (goog.LOCALE == 'bo_CN' || goog.LOCALE == 'bo-CN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bo_CN;
}

if (goog.LOCALE == 'bo_IN' || goog.LOCALE == 'bo-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bo_IN;
}

if (goog.LOCALE == 'br_FR' || goog.LOCALE == 'br-FR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_br_FR;
}

if (goog.LOCALE == 'brx') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_brx;
}

if (goog.LOCALE == 'brx_IN' || goog.LOCALE == 'brx-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_brx_IN;
}

if (goog.LOCALE == 'bs') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bs;
}

if (goog.LOCALE == 'bs_Cyrl' || goog.LOCALE == 'bs-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bs_Cyrl;
}

if (goog.LOCALE == 'bs_Cyrl_BA' || goog.LOCALE == 'bs-Cyrl-BA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bs_Cyrl_BA;
}

if (goog.LOCALE == 'bs_Latn' || goog.LOCALE == 'bs-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bs_Latn;
}

if (goog.LOCALE == 'bs_Latn_BA' || goog.LOCALE == 'bs-Latn-BA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_bs_Latn_BA;
}

if (goog.LOCALE == 'ca_AD' || goog.LOCALE == 'ca-AD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ca_AD;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ca_ES;
}

if (goog.LOCALE == 'ca_FR' || goog.LOCALE == 'ca-FR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ca_FR;
}

if (goog.LOCALE == 'ca_IT' || goog.LOCALE == 'ca-IT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ca_IT;
}

if (goog.LOCALE == 'cgg') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_cgg;
}

if (goog.LOCALE == 'cgg_UG' || goog.LOCALE == 'cgg-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_cgg_UG;
}

if (goog.LOCALE == 'chr_US' || goog.LOCALE == 'chr-US') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_chr_US;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_cs_CZ;
}

if (goog.LOCALE == 'cy_GB' || goog.LOCALE == 'cy-GB') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_cy_GB;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_da_DK;
}

if (goog.LOCALE == 'da_GL' || goog.LOCALE == 'da-GL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_da_GL;
}

if (goog.LOCALE == 'dav') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dav;
}

if (goog.LOCALE == 'dav_KE' || goog.LOCALE == 'dav-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dav_KE;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_de_BE;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_de_DE;
}

if (goog.LOCALE == 'de_LI' || goog.LOCALE == 'de-LI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_de_LI;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_de_LU;
}

if (goog.LOCALE == 'dje') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dje;
}

if (goog.LOCALE == 'dje_NE' || goog.LOCALE == 'dje-NE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dje_NE;
}

if (goog.LOCALE == 'dua') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dua;
}

if (goog.LOCALE == 'dua_CM' || goog.LOCALE == 'dua-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dua_CM;
}

if (goog.LOCALE == 'dyo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dyo;
}

if (goog.LOCALE == 'dyo_SN' || goog.LOCALE == 'dyo-SN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dyo_SN;
}

if (goog.LOCALE == 'dz') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dz;
}

if (goog.LOCALE == 'dz_BT' || goog.LOCALE == 'dz-BT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_dz_BT;
}

if (goog.LOCALE == 'ebu') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ebu;
}

if (goog.LOCALE == 'ebu_KE' || goog.LOCALE == 'ebu-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ebu_KE;
}

if (goog.LOCALE == 'ee') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ee;
}

if (goog.LOCALE == 'ee_GH' || goog.LOCALE == 'ee-GH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ee_GH;
}

if (goog.LOCALE == 'ee_TG' || goog.LOCALE == 'ee-TG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ee_TG;
}

if (goog.LOCALE == 'el_CY' || goog.LOCALE == 'el-CY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_el_CY;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_el_GR;
}

if (goog.LOCALE == 'en_001' || goog.LOCALE == 'en-001') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_001;
}

if (goog.LOCALE == 'en_150' || goog.LOCALE == 'en-150') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_150;
}

if (goog.LOCALE == 'en_AG' || goog.LOCALE == 'en-AG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_AG;
}

if (goog.LOCALE == 'en_AI' || goog.LOCALE == 'en-AI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_AI;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_AS;
}

if (goog.LOCALE == 'en_BB' || goog.LOCALE == 'en-BB') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_BB;
}

if (goog.LOCALE == 'en_BE' || goog.LOCALE == 'en-BE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_BE;
}

if (goog.LOCALE == 'en_BM' || goog.LOCALE == 'en-BM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_BM;
}

if (goog.LOCALE == 'en_BS' || goog.LOCALE == 'en-BS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_BS;
}

if (goog.LOCALE == 'en_BW' || goog.LOCALE == 'en-BW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_BW;
}

if (goog.LOCALE == 'en_BZ' || goog.LOCALE == 'en-BZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_BZ;
}

if (goog.LOCALE == 'en_CA' || goog.LOCALE == 'en-CA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_CA;
}

if (goog.LOCALE == 'en_CC' || goog.LOCALE == 'en-CC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_CC;
}

if (goog.LOCALE == 'en_CK' || goog.LOCALE == 'en-CK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_CK;
}

if (goog.LOCALE == 'en_CM' || goog.LOCALE == 'en-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_CM;
}

if (goog.LOCALE == 'en_CX' || goog.LOCALE == 'en-CX') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_CX;
}

if (goog.LOCALE == 'en_DG' || goog.LOCALE == 'en-DG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_DG;
}

if (goog.LOCALE == 'en_DM' || goog.LOCALE == 'en-DM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_DM;
}

if (goog.LOCALE == 'en_ER' || goog.LOCALE == 'en-ER') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_ER;
}

if (goog.LOCALE == 'en_FJ' || goog.LOCALE == 'en-FJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_FJ;
}

if (goog.LOCALE == 'en_FK' || goog.LOCALE == 'en-FK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_FK;
}

if (goog.LOCALE == 'en_FM' || goog.LOCALE == 'en-FM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_FM;
}

if (goog.LOCALE == 'en_GD' || goog.LOCALE == 'en-GD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GD;
}

if (goog.LOCALE == 'en_GG' || goog.LOCALE == 'en-GG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GG;
}

if (goog.LOCALE == 'en_GH' || goog.LOCALE == 'en-GH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GH;
}

if (goog.LOCALE == 'en_GI' || goog.LOCALE == 'en-GI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GI;
}

if (goog.LOCALE == 'en_GM' || goog.LOCALE == 'en-GM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GM;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GU;
}

if (goog.LOCALE == 'en_GY' || goog.LOCALE == 'en-GY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_GY;
}

if (goog.LOCALE == 'en_HK' || goog.LOCALE == 'en-HK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_HK;
}

if (goog.LOCALE == 'en_IM' || goog.LOCALE == 'en-IM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_IM;
}

if (goog.LOCALE == 'en_IO' || goog.LOCALE == 'en-IO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_IO;
}

if (goog.LOCALE == 'en_JE' || goog.LOCALE == 'en-JE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_JE;
}

if (goog.LOCALE == 'en_JM' || goog.LOCALE == 'en-JM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_JM;
}

if (goog.LOCALE == 'en_KE' || goog.LOCALE == 'en-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_KE;
}

if (goog.LOCALE == 'en_KI' || goog.LOCALE == 'en-KI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_KI;
}

if (goog.LOCALE == 'en_KN' || goog.LOCALE == 'en-KN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_KN;
}

if (goog.LOCALE == 'en_KY' || goog.LOCALE == 'en-KY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_KY;
}

if (goog.LOCALE == 'en_LC' || goog.LOCALE == 'en-LC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_LC;
}

if (goog.LOCALE == 'en_LR' || goog.LOCALE == 'en-LR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_LR;
}

if (goog.LOCALE == 'en_LS' || goog.LOCALE == 'en-LS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_LS;
}

if (goog.LOCALE == 'en_MG' || goog.LOCALE == 'en-MG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MG;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MH;
}

if (goog.LOCALE == 'en_MO' || goog.LOCALE == 'en-MO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MO;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MP;
}

if (goog.LOCALE == 'en_MS' || goog.LOCALE == 'en-MS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MS;
}

if (goog.LOCALE == 'en_MT' || goog.LOCALE == 'en-MT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MT;
}

if (goog.LOCALE == 'en_MU' || goog.LOCALE == 'en-MU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MU;
}

if (goog.LOCALE == 'en_MW' || goog.LOCALE == 'en-MW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_MW;
}

if (goog.LOCALE == 'en_NA' || goog.LOCALE == 'en-NA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_NA;
}

if (goog.LOCALE == 'en_NF' || goog.LOCALE == 'en-NF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_NF;
}

if (goog.LOCALE == 'en_NG' || goog.LOCALE == 'en-NG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_NG;
}

if (goog.LOCALE == 'en_NR' || goog.LOCALE == 'en-NR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_NR;
}

if (goog.LOCALE == 'en_NU' || goog.LOCALE == 'en-NU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_NU;
}

if (goog.LOCALE == 'en_NZ' || goog.LOCALE == 'en-NZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_NZ;
}

if (goog.LOCALE == 'en_PG' || goog.LOCALE == 'en-PG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_PG;
}

if (goog.LOCALE == 'en_PH' || goog.LOCALE == 'en-PH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_PH;
}

if (goog.LOCALE == 'en_PK' || goog.LOCALE == 'en-PK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_PK;
}

if (goog.LOCALE == 'en_PN' || goog.LOCALE == 'en-PN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_PN;
}

if (goog.LOCALE == 'en_PR' || goog.LOCALE == 'en-PR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_PR;
}

if (goog.LOCALE == 'en_PW' || goog.LOCALE == 'en-PW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_PW;
}

if (goog.LOCALE == 'en_RW' || goog.LOCALE == 'en-RW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_RW;
}

if (goog.LOCALE == 'en_SB' || goog.LOCALE == 'en-SB') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SB;
}

if (goog.LOCALE == 'en_SC' || goog.LOCALE == 'en-SC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SC;
}

if (goog.LOCALE == 'en_SD' || goog.LOCALE == 'en-SD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SD;
}

if (goog.LOCALE == 'en_SH' || goog.LOCALE == 'en-SH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SH;
}

if (goog.LOCALE == 'en_SL' || goog.LOCALE == 'en-SL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SL;
}

if (goog.LOCALE == 'en_SS' || goog.LOCALE == 'en-SS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SS;
}

if (goog.LOCALE == 'en_SX' || goog.LOCALE == 'en-SX') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SX;
}

if (goog.LOCALE == 'en_SZ' || goog.LOCALE == 'en-SZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_SZ;
}

if (goog.LOCALE == 'en_TC' || goog.LOCALE == 'en-TC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_TC;
}

if (goog.LOCALE == 'en_TK' || goog.LOCALE == 'en-TK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_TK;
}

if (goog.LOCALE == 'en_TO' || goog.LOCALE == 'en-TO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_TO;
}

if (goog.LOCALE == 'en_TT' || goog.LOCALE == 'en-TT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_TT;
}

if (goog.LOCALE == 'en_TV' || goog.LOCALE == 'en-TV') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_TV;
}

if (goog.LOCALE == 'en_TZ' || goog.LOCALE == 'en-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_TZ;
}

if (goog.LOCALE == 'en_UG' || goog.LOCALE == 'en-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_UG;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_UM;
}

if (goog.LOCALE == 'en_US_POSIX' || goog.LOCALE == 'en-US-POSIX') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_US_POSIX;
}

if (goog.LOCALE == 'en_VC' || goog.LOCALE == 'en-VC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_VC;
}

if (goog.LOCALE == 'en_VG' || goog.LOCALE == 'en-VG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_VG;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_VI;
}

if (goog.LOCALE == 'en_VU' || goog.LOCALE == 'en-VU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_VU;
}

if (goog.LOCALE == 'en_WS' || goog.LOCALE == 'en-WS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_WS;
}

if (goog.LOCALE == 'en_ZM' || goog.LOCALE == 'en-ZM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_ZM;
}

if (goog.LOCALE == 'en_ZW' || goog.LOCALE == 'en-ZW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_en_ZW;
}

if (goog.LOCALE == 'eo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_eo;
}

if (goog.LOCALE == 'es_AR' || goog.LOCALE == 'es-AR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_AR;
}

if (goog.LOCALE == 'es_BO' || goog.LOCALE == 'es-BO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_BO;
}

if (goog.LOCALE == 'es_CL' || goog.LOCALE == 'es-CL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_CL;
}

if (goog.LOCALE == 'es_CO' || goog.LOCALE == 'es-CO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_CO;
}

if (goog.LOCALE == 'es_CR' || goog.LOCALE == 'es-CR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_CR;
}

if (goog.LOCALE == 'es_CU' || goog.LOCALE == 'es-CU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_CU;
}

if (goog.LOCALE == 'es_DO' || goog.LOCALE == 'es-DO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_DO;
}

if (goog.LOCALE == 'es_EA' || goog.LOCALE == 'es-EA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_EA;
}

if (goog.LOCALE == 'es_EC' || goog.LOCALE == 'es-EC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_EC;
}

if (goog.LOCALE == 'es_GQ' || goog.LOCALE == 'es-GQ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_GQ;
}

if (goog.LOCALE == 'es_GT' || goog.LOCALE == 'es-GT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_GT;
}

if (goog.LOCALE == 'es_HN' || goog.LOCALE == 'es-HN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_HN;
}

if (goog.LOCALE == 'es_IC' || goog.LOCALE == 'es-IC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_IC;
}

if (goog.LOCALE == 'es_MX' || goog.LOCALE == 'es-MX') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_MX;
}

if (goog.LOCALE == 'es_NI' || goog.LOCALE == 'es-NI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_NI;
}

if (goog.LOCALE == 'es_PA' || goog.LOCALE == 'es-PA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_PA;
}

if (goog.LOCALE == 'es_PE' || goog.LOCALE == 'es-PE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_PE;
}

if (goog.LOCALE == 'es_PH' || goog.LOCALE == 'es-PH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_PH;
}

if (goog.LOCALE == 'es_PR' || goog.LOCALE == 'es-PR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_PR;
}

if (goog.LOCALE == 'es_PY' || goog.LOCALE == 'es-PY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_PY;
}

if (goog.LOCALE == 'es_SV' || goog.LOCALE == 'es-SV') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_SV;
}

if (goog.LOCALE == 'es_US' || goog.LOCALE == 'es-US') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_US;
}

if (goog.LOCALE == 'es_UY' || goog.LOCALE == 'es-UY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_UY;
}

if (goog.LOCALE == 'es_VE' || goog.LOCALE == 'es-VE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_es_VE;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_et_EE;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_eu_ES;
}

if (goog.LOCALE == 'ewo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ewo;
}

if (goog.LOCALE == 'ewo_CM' || goog.LOCALE == 'ewo-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ewo_CM;
}

if (goog.LOCALE == 'fa_AF' || goog.LOCALE == 'fa-AF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fa_AF;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fa_IR;
}

if (goog.LOCALE == 'ff') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ff;
}

if (goog.LOCALE == 'ff_SN' || goog.LOCALE == 'ff-SN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ff_SN;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fi_FI;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fil_PH;
}

if (goog.LOCALE == 'fo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fo;
}

if (goog.LOCALE == 'fo_FO' || goog.LOCALE == 'fo-FO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fo_FO;
}

if (goog.LOCALE == 'fr_BE' || goog.LOCALE == 'fr-BE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_BE;
}

if (goog.LOCALE == 'fr_BF' || goog.LOCALE == 'fr-BF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_BF;
}

if (goog.LOCALE == 'fr_BI' || goog.LOCALE == 'fr-BI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_BI;
}

if (goog.LOCALE == 'fr_BJ' || goog.LOCALE == 'fr-BJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_BJ;
}

if (goog.LOCALE == 'fr_BL' || goog.LOCALE == 'fr-BL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_BL;
}

if (goog.LOCALE == 'fr_CD' || goog.LOCALE == 'fr-CD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_CD;
}

if (goog.LOCALE == 'fr_CF' || goog.LOCALE == 'fr-CF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_CF;
}

if (goog.LOCALE == 'fr_CG' || goog.LOCALE == 'fr-CG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_CG;
}

if (goog.LOCALE == 'fr_CH' || goog.LOCALE == 'fr-CH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_CH;
}

if (goog.LOCALE == 'fr_CI' || goog.LOCALE == 'fr-CI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_CI;
}

if (goog.LOCALE == 'fr_CM' || goog.LOCALE == 'fr-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_CM;
}

if (goog.LOCALE == 'fr_DJ' || goog.LOCALE == 'fr-DJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_DJ;
}

if (goog.LOCALE == 'fr_DZ' || goog.LOCALE == 'fr-DZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_DZ;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_FR;
}

if (goog.LOCALE == 'fr_GA' || goog.LOCALE == 'fr-GA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_GA;
}

if (goog.LOCALE == 'fr_GF' || goog.LOCALE == 'fr-GF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_GF;
}

if (goog.LOCALE == 'fr_GN' || goog.LOCALE == 'fr-GN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_GN;
}

if (goog.LOCALE == 'fr_GP' || goog.LOCALE == 'fr-GP') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_GP;
}

if (goog.LOCALE == 'fr_GQ' || goog.LOCALE == 'fr-GQ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_GQ;
}

if (goog.LOCALE == 'fr_HT' || goog.LOCALE == 'fr-HT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_HT;
}

if (goog.LOCALE == 'fr_KM' || goog.LOCALE == 'fr-KM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_KM;
}

if (goog.LOCALE == 'fr_LU' || goog.LOCALE == 'fr-LU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_LU;
}

if (goog.LOCALE == 'fr_MA' || goog.LOCALE == 'fr-MA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MA;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MC;
}

if (goog.LOCALE == 'fr_MF' || goog.LOCALE == 'fr-MF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MF;
}

if (goog.LOCALE == 'fr_MG' || goog.LOCALE == 'fr-MG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MG;
}

if (goog.LOCALE == 'fr_ML' || goog.LOCALE == 'fr-ML') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_ML;
}

if (goog.LOCALE == 'fr_MQ' || goog.LOCALE == 'fr-MQ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MQ;
}

if (goog.LOCALE == 'fr_MR' || goog.LOCALE == 'fr-MR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MR;
}

if (goog.LOCALE == 'fr_MU' || goog.LOCALE == 'fr-MU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_MU;
}

if (goog.LOCALE == 'fr_NC' || goog.LOCALE == 'fr-NC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_NC;
}

if (goog.LOCALE == 'fr_NE' || goog.LOCALE == 'fr-NE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_NE;
}

if (goog.LOCALE == 'fr_PF' || goog.LOCALE == 'fr-PF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_PF;
}

if (goog.LOCALE == 'fr_PM' || goog.LOCALE == 'fr-PM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_PM;
}

if (goog.LOCALE == 'fr_RE' || goog.LOCALE == 'fr-RE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_RE;
}

if (goog.LOCALE == 'fr_RW' || goog.LOCALE == 'fr-RW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_RW;
}

if (goog.LOCALE == 'fr_SC' || goog.LOCALE == 'fr-SC') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_SC;
}

if (goog.LOCALE == 'fr_SN' || goog.LOCALE == 'fr-SN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_SN;
}

if (goog.LOCALE == 'fr_SY' || goog.LOCALE == 'fr-SY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_SY;
}

if (goog.LOCALE == 'fr_TD' || goog.LOCALE == 'fr-TD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_TD;
}

if (goog.LOCALE == 'fr_TG' || goog.LOCALE == 'fr-TG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_TG;
}

if (goog.LOCALE == 'fr_TN' || goog.LOCALE == 'fr-TN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_TN;
}

if (goog.LOCALE == 'fr_VU' || goog.LOCALE == 'fr-VU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_VU;
}

if (goog.LOCALE == 'fr_WF' || goog.LOCALE == 'fr-WF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_WF;
}

if (goog.LOCALE == 'fr_YT' || goog.LOCALE == 'fr-YT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_fr_YT;
}

if (goog.LOCALE == 'ga') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ga;
}

if (goog.LOCALE == 'ga_IE' || goog.LOCALE == 'ga-IE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ga_IE;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_gl_ES;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_gsw_CH;
}

if (goog.LOCALE == 'gsw_LI' || goog.LOCALE == 'gsw-LI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_gsw_LI;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_gu_IN;
}

if (goog.LOCALE == 'guz') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_guz;
}

if (goog.LOCALE == 'guz_KE' || goog.LOCALE == 'guz-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_guz_KE;
}

if (goog.LOCALE == 'gv') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_gv;
}

if (goog.LOCALE == 'gv_IM' || goog.LOCALE == 'gv-IM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_gv_IM;
}

if (goog.LOCALE == 'ha') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ha;
}

if (goog.LOCALE == 'ha_Latn' || goog.LOCALE == 'ha-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ha_Latn;
}

if (goog.LOCALE == 'ha_Latn_GH' || goog.LOCALE == 'ha-Latn-GH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ha_Latn_GH;
}

if (goog.LOCALE == 'ha_Latn_NE' || goog.LOCALE == 'ha-Latn-NE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ha_Latn_NE;
}

if (goog.LOCALE == 'ha_Latn_NG' || goog.LOCALE == 'ha-Latn-NG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ha_Latn_NG;
}

if (goog.LOCALE == 'haw_US' || goog.LOCALE == 'haw-US') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_haw_US;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_he_IL;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_hi_IN;
}

if (goog.LOCALE == 'hr_BA' || goog.LOCALE == 'hr-BA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_hr_BA;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_hr_HR;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_hu_HU;
}

if (goog.LOCALE == 'hy_AM' || goog.LOCALE == 'hy-AM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_hy_AM;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_id_ID;
}

if (goog.LOCALE == 'ig') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ig;
}

if (goog.LOCALE == 'ig_NG' || goog.LOCALE == 'ig-NG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ig_NG;
}

if (goog.LOCALE == 'ii') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ii;
}

if (goog.LOCALE == 'ii_CN' || goog.LOCALE == 'ii-CN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ii_CN;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_is_IS;
}

if (goog.LOCALE == 'it_CH' || goog.LOCALE == 'it-CH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_it_CH;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_it_IT;
}

if (goog.LOCALE == 'it_SM' || goog.LOCALE == 'it-SM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_it_SM;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ja_JP;
}

if (goog.LOCALE == 'jgo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_jgo;
}

if (goog.LOCALE == 'jgo_CM' || goog.LOCALE == 'jgo-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_jgo_CM;
}

if (goog.LOCALE == 'jmc') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_jmc;
}

if (goog.LOCALE == 'jmc_TZ' || goog.LOCALE == 'jmc-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_jmc_TZ;
}

if (goog.LOCALE == 'ka_GE' || goog.LOCALE == 'ka-GE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ka_GE;
}

if (goog.LOCALE == 'kab') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kab;
}

if (goog.LOCALE == 'kab_DZ' || goog.LOCALE == 'kab-DZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kab_DZ;
}

if (goog.LOCALE == 'kam') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kam;
}

if (goog.LOCALE == 'kam_KE' || goog.LOCALE == 'kam-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kam_KE;
}

if (goog.LOCALE == 'kde') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kde;
}

if (goog.LOCALE == 'kde_TZ' || goog.LOCALE == 'kde-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kde_TZ;
}

if (goog.LOCALE == 'kea') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kea;
}

if (goog.LOCALE == 'kea_CV' || goog.LOCALE == 'kea-CV') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kea_CV;
}

if (goog.LOCALE == 'khq') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_khq;
}

if (goog.LOCALE == 'khq_ML' || goog.LOCALE == 'khq-ML') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_khq_ML;
}

if (goog.LOCALE == 'ki') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ki;
}

if (goog.LOCALE == 'ki_KE' || goog.LOCALE == 'ki-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ki_KE;
}

if (goog.LOCALE == 'kk_Cyrl' || goog.LOCALE == 'kk-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kk_Cyrl;
}

if (goog.LOCALE == 'kk_Cyrl_KZ' || goog.LOCALE == 'kk-Cyrl-KZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kk_Cyrl_KZ;
}

if (goog.LOCALE == 'kkj') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kkj;
}

if (goog.LOCALE == 'kkj_CM' || goog.LOCALE == 'kkj-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kkj_CM;
}

if (goog.LOCALE == 'kl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kl;
}

if (goog.LOCALE == 'kl_GL' || goog.LOCALE == 'kl-GL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kl_GL;
}

if (goog.LOCALE == 'kln') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kln;
}

if (goog.LOCALE == 'kln_KE' || goog.LOCALE == 'kln-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kln_KE;
}

if (goog.LOCALE == 'km_KH' || goog.LOCALE == 'km-KH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_km_KH;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kn_IN;
}

if (goog.LOCALE == 'ko_KP' || goog.LOCALE == 'ko-KP') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ko_KP;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ko_KR;
}

if (goog.LOCALE == 'kok') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kok;
}

if (goog.LOCALE == 'kok_IN' || goog.LOCALE == 'kok-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kok_IN;
}

if (goog.LOCALE == 'ks') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ks;
}

if (goog.LOCALE == 'ks_Arab' || goog.LOCALE == 'ks-Arab') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ks_Arab;
}

if (goog.LOCALE == 'ks_Arab_IN' || goog.LOCALE == 'ks-Arab-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ks_Arab_IN;
}

if (goog.LOCALE == 'ksb') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ksb;
}

if (goog.LOCALE == 'ksb_TZ' || goog.LOCALE == 'ksb-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ksb_TZ;
}

if (goog.LOCALE == 'ksf') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ksf;
}

if (goog.LOCALE == 'ksf_CM' || goog.LOCALE == 'ksf-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ksf_CM;
}

if (goog.LOCALE == 'kw') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kw;
}

if (goog.LOCALE == 'kw_GB' || goog.LOCALE == 'kw-GB') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_kw_GB;
}

if (goog.LOCALE == 'ky_Cyrl' || goog.LOCALE == 'ky-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ky_Cyrl;
}

if (goog.LOCALE == 'ky_Cyrl_KG' || goog.LOCALE == 'ky-Cyrl-KG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ky_Cyrl_KG;
}

if (goog.LOCALE == 'lag') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lag;
}

if (goog.LOCALE == 'lag_TZ' || goog.LOCALE == 'lag-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lag_TZ;
}

if (goog.LOCALE == 'lg') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lg;
}

if (goog.LOCALE == 'lg_UG' || goog.LOCALE == 'lg-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lg_UG;
}

if (goog.LOCALE == 'lkt') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lkt;
}

if (goog.LOCALE == 'lkt_US' || goog.LOCALE == 'lkt-US') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lkt_US;
}

if (goog.LOCALE == 'ln_AO' || goog.LOCALE == 'ln-AO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ln_AO;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ln_CD;
}

if (goog.LOCALE == 'ln_CF' || goog.LOCALE == 'ln-CF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ln_CF;
}

if (goog.LOCALE == 'ln_CG' || goog.LOCALE == 'ln-CG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ln_CG;
}

if (goog.LOCALE == 'lo_LA' || goog.LOCALE == 'lo-LA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lo_LA;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lt_LT;
}

if (goog.LOCALE == 'lu') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lu;
}

if (goog.LOCALE == 'lu_CD' || goog.LOCALE == 'lu-CD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lu_CD;
}

if (goog.LOCALE == 'luo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_luo;
}

if (goog.LOCALE == 'luo_KE' || goog.LOCALE == 'luo-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_luo_KE;
}

if (goog.LOCALE == 'luy') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_luy;
}

if (goog.LOCALE == 'luy_KE' || goog.LOCALE == 'luy-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_luy_KE;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_lv_LV;
}

if (goog.LOCALE == 'mas') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mas;
}

if (goog.LOCALE == 'mas_KE' || goog.LOCALE == 'mas-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mas_KE;
}

if (goog.LOCALE == 'mas_TZ' || goog.LOCALE == 'mas-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mas_TZ;
}

if (goog.LOCALE == 'mer') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mer;
}

if (goog.LOCALE == 'mer_KE' || goog.LOCALE == 'mer-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mer_KE;
}

if (goog.LOCALE == 'mfe') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mfe;
}

if (goog.LOCALE == 'mfe_MU' || goog.LOCALE == 'mfe-MU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mfe_MU;
}

if (goog.LOCALE == 'mg') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mg;
}

if (goog.LOCALE == 'mg_MG' || goog.LOCALE == 'mg-MG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mg_MG;
}

if (goog.LOCALE == 'mgh') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mgh;
}

if (goog.LOCALE == 'mgh_MZ' || goog.LOCALE == 'mgh-MZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mgh_MZ;
}

if (goog.LOCALE == 'mgo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mgo;
}

if (goog.LOCALE == 'mgo_CM' || goog.LOCALE == 'mgo-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mgo_CM;
}

if (goog.LOCALE == 'mk_MK' || goog.LOCALE == 'mk-MK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mk_MK;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ml_IN;
}

if (goog.LOCALE == 'mn_Cyrl' || goog.LOCALE == 'mn-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mn_Cyrl;
}

if (goog.LOCALE == 'mn_Cyrl_MN' || goog.LOCALE == 'mn-Cyrl-MN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mn_Cyrl_MN;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mr_IN;
}

if (goog.LOCALE == 'ms_Latn' || goog.LOCALE == 'ms-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ms_Latn;
}

if (goog.LOCALE == 'ms_Latn_BN' || goog.LOCALE == 'ms-Latn-BN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ms_Latn_BN;
}

if (goog.LOCALE == 'ms_Latn_MY' || goog.LOCALE == 'ms-Latn-MY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ms_Latn_MY;
}

if (goog.LOCALE == 'ms_Latn_SG' || goog.LOCALE == 'ms-Latn-SG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ms_Latn_SG;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mt_MT;
}

if (goog.LOCALE == 'mua') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mua;
}

if (goog.LOCALE == 'mua_CM' || goog.LOCALE == 'mua-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_mua_CM;
}

if (goog.LOCALE == 'my_MM' || goog.LOCALE == 'my-MM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_my_MM;
}

if (goog.LOCALE == 'naq') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_naq;
}

if (goog.LOCALE == 'naq_NA' || goog.LOCALE == 'naq-NA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_naq_NA;
}

if (goog.LOCALE == 'nb_NO' || goog.LOCALE == 'nb-NO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nb_NO;
}

if (goog.LOCALE == 'nb_SJ' || goog.LOCALE == 'nb-SJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nb_SJ;
}

if (goog.LOCALE == 'nd') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nd;
}

if (goog.LOCALE == 'nd_ZW' || goog.LOCALE == 'nd-ZW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nd_ZW;
}

if (goog.LOCALE == 'ne_IN' || goog.LOCALE == 'ne-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ne_IN;
}

if (goog.LOCALE == 'ne_NP' || goog.LOCALE == 'ne-NP') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ne_NP;
}

if (goog.LOCALE == 'nl_AW' || goog.LOCALE == 'nl-AW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_AW;
}

if (goog.LOCALE == 'nl_BE' || goog.LOCALE == 'nl-BE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_BE;
}

if (goog.LOCALE == 'nl_BQ' || goog.LOCALE == 'nl-BQ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_BQ;
}

if (goog.LOCALE == 'nl_CW' || goog.LOCALE == 'nl-CW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_CW;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_NL;
}

if (goog.LOCALE == 'nl_SR' || goog.LOCALE == 'nl-SR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_SR;
}

if (goog.LOCALE == 'nl_SX' || goog.LOCALE == 'nl-SX') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nl_SX;
}

if (goog.LOCALE == 'nmg') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nmg;
}

if (goog.LOCALE == 'nmg_CM' || goog.LOCALE == 'nmg-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nmg_CM;
}

if (goog.LOCALE == 'nn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nn;
}

if (goog.LOCALE == 'nn_NO' || goog.LOCALE == 'nn-NO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nn_NO;
}

if (goog.LOCALE == 'nnh') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nnh;
}

if (goog.LOCALE == 'nnh_CM' || goog.LOCALE == 'nnh-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nnh_CM;
}

if (goog.LOCALE == 'nus') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nus;
}

if (goog.LOCALE == 'nus_SD' || goog.LOCALE == 'nus-SD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nus_SD;
}

if (goog.LOCALE == 'nyn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nyn;
}

if (goog.LOCALE == 'nyn_UG' || goog.LOCALE == 'nyn-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_nyn_UG;
}

if (goog.LOCALE == 'om') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_om;
}

if (goog.LOCALE == 'om_ET' || goog.LOCALE == 'om-ET') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_om_ET;
}

if (goog.LOCALE == 'om_KE' || goog.LOCALE == 'om-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_om_KE;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_or_IN;
}

if (goog.LOCALE == 'pa_Arab' || goog.LOCALE == 'pa-Arab') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pa_Arab;
}

if (goog.LOCALE == 'pa_Arab_PK' || goog.LOCALE == 'pa-Arab-PK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pa_Arab_PK;
}

if (goog.LOCALE == 'pa_Guru' || goog.LOCALE == 'pa-Guru') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pa_Guru;
}

if (goog.LOCALE == 'pa_Guru_IN' || goog.LOCALE == 'pa-Guru-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pa_Guru_IN;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pl_PL;
}

if (goog.LOCALE == 'ps') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ps;
}

if (goog.LOCALE == 'ps_AF' || goog.LOCALE == 'ps-AF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ps_AF;
}

if (goog.LOCALE == 'pt_AO' || goog.LOCALE == 'pt-AO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_AO;
}

if (goog.LOCALE == 'pt_CV' || goog.LOCALE == 'pt-CV') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_CV;
}

if (goog.LOCALE == 'pt_GW' || goog.LOCALE == 'pt-GW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_GW;
}

if (goog.LOCALE == 'pt_MO' || goog.LOCALE == 'pt-MO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_MO;
}

if (goog.LOCALE == 'pt_MZ' || goog.LOCALE == 'pt-MZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_MZ;
}

if (goog.LOCALE == 'pt_ST' || goog.LOCALE == 'pt-ST') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_ST;
}

if (goog.LOCALE == 'pt_TL' || goog.LOCALE == 'pt-TL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_pt_TL;
}

if (goog.LOCALE == 'rm') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rm;
}

if (goog.LOCALE == 'rm_CH' || goog.LOCALE == 'rm-CH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rm_CH;
}

if (goog.LOCALE == 'rn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rn;
}

if (goog.LOCALE == 'rn_BI' || goog.LOCALE == 'rn-BI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rn_BI;
}

if (goog.LOCALE == 'ro_MD' || goog.LOCALE == 'ro-MD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ro_MD;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ro_RO;
}

if (goog.LOCALE == 'rof') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rof;
}

if (goog.LOCALE == 'rof_TZ' || goog.LOCALE == 'rof-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rof_TZ;
}

if (goog.LOCALE == 'ru_BY' || goog.LOCALE == 'ru-BY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ru_BY;
}

if (goog.LOCALE == 'ru_KG' || goog.LOCALE == 'ru-KG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ru_KG;
}

if (goog.LOCALE == 'ru_KZ' || goog.LOCALE == 'ru-KZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ru_KZ;
}

if (goog.LOCALE == 'ru_MD' || goog.LOCALE == 'ru-MD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ru_MD;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ru_RU;
}

if (goog.LOCALE == 'ru_UA' || goog.LOCALE == 'ru-UA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ru_UA;
}

if (goog.LOCALE == 'rw') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rw;
}

if (goog.LOCALE == 'rw_RW' || goog.LOCALE == 'rw-RW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rw_RW;
}

if (goog.LOCALE == 'rwk') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rwk;
}

if (goog.LOCALE == 'rwk_TZ' || goog.LOCALE == 'rwk-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_rwk_TZ;
}

if (goog.LOCALE == 'saq') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_saq;
}

if (goog.LOCALE == 'saq_KE' || goog.LOCALE == 'saq-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_saq_KE;
}

if (goog.LOCALE == 'sbp') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sbp;
}

if (goog.LOCALE == 'sbp_TZ' || goog.LOCALE == 'sbp-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sbp_TZ;
}

if (goog.LOCALE == 'seh') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_seh;
}

if (goog.LOCALE == 'seh_MZ' || goog.LOCALE == 'seh-MZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_seh_MZ;
}

if (goog.LOCALE == 'ses') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ses;
}

if (goog.LOCALE == 'ses_ML' || goog.LOCALE == 'ses-ML') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ses_ML;
}

if (goog.LOCALE == 'sg') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sg;
}

if (goog.LOCALE == 'sg_CF' || goog.LOCALE == 'sg-CF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sg_CF;
}

if (goog.LOCALE == 'shi') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_shi;
}

if (goog.LOCALE == 'shi_Latn' || goog.LOCALE == 'shi-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_shi_Latn;
}

if (goog.LOCALE == 'shi_Latn_MA' || goog.LOCALE == 'shi-Latn-MA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_shi_Latn_MA;
}

if (goog.LOCALE == 'shi_Tfng' || goog.LOCALE == 'shi-Tfng') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_shi_Tfng;
}

if (goog.LOCALE == 'shi_Tfng_MA' || goog.LOCALE == 'shi-Tfng-MA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_shi_Tfng_MA;
}

if (goog.LOCALE == 'si_LK' || goog.LOCALE == 'si-LK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_si_LK;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sk_SK;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sl_SI;
}

if (goog.LOCALE == 'sn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sn;
}

if (goog.LOCALE == 'sn_ZW' || goog.LOCALE == 'sn-ZW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sn_ZW;
}

if (goog.LOCALE == 'so') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_so;
}

if (goog.LOCALE == 'so_DJ' || goog.LOCALE == 'so-DJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_so_DJ;
}

if (goog.LOCALE == 'so_ET' || goog.LOCALE == 'so-ET') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_so_ET;
}

if (goog.LOCALE == 'so_KE' || goog.LOCALE == 'so-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_so_KE;
}

if (goog.LOCALE == 'so_SO' || goog.LOCALE == 'so-SO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_so_SO;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sq_AL;
}

if (goog.LOCALE == 'sq_MK' || goog.LOCALE == 'sq-MK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sq_MK;
}

if (goog.LOCALE == 'sq_XK' || goog.LOCALE == 'sq-XK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sq_XK;
}

if (goog.LOCALE == 'sr_Cyrl' || goog.LOCALE == 'sr-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_BA' || goog.LOCALE == 'sr-Cyrl-BA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Cyrl_BA;
}

if (goog.LOCALE == 'sr_Cyrl_ME' || goog.LOCALE == 'sr-Cyrl-ME') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Cyrl_ME;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Cyrl_RS;
}

if (goog.LOCALE == 'sr_Cyrl_XK' || goog.LOCALE == 'sr-Cyrl-XK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Cyrl_XK;
}

if (goog.LOCALE == 'sr_Latn' || goog.LOCALE == 'sr-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Latn;
}

if (goog.LOCALE == 'sr_Latn_BA' || goog.LOCALE == 'sr-Latn-BA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Latn_BA;
}

if (goog.LOCALE == 'sr_Latn_ME' || goog.LOCALE == 'sr-Latn-ME') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Latn_ME;
}

if (goog.LOCALE == 'sr_Latn_RS' || goog.LOCALE == 'sr-Latn-RS') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Latn_RS;
}

if (goog.LOCALE == 'sr_Latn_XK' || goog.LOCALE == 'sr-Latn-XK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sr_Latn_XK;
}

if (goog.LOCALE == 'sv_AX' || goog.LOCALE == 'sv-AX') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sv_AX;
}

if (goog.LOCALE == 'sv_FI' || goog.LOCALE == 'sv-FI') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sv_FI;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sv_SE;
}

if (goog.LOCALE == 'sw_KE' || goog.LOCALE == 'sw-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sw_KE;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sw_TZ;
}

if (goog.LOCALE == 'sw_UG' || goog.LOCALE == 'sw-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_sw_UG;
}

if (goog.LOCALE == 'swc') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_swc;
}

if (goog.LOCALE == 'swc_CD' || goog.LOCALE == 'swc-CD') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_swc_CD;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ta_IN;
}

if (goog.LOCALE == 'ta_LK' || goog.LOCALE == 'ta-LK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ta_LK;
}

if (goog.LOCALE == 'ta_MY' || goog.LOCALE == 'ta-MY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ta_MY;
}

if (goog.LOCALE == 'ta_SG' || goog.LOCALE == 'ta-SG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ta_SG;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_te_IN;
}

if (goog.LOCALE == 'teo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_teo;
}

if (goog.LOCALE == 'teo_KE' || goog.LOCALE == 'teo-KE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_teo_KE;
}

if (goog.LOCALE == 'teo_UG' || goog.LOCALE == 'teo-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_teo_UG;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_th_TH;
}

if (goog.LOCALE == 'ti') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ti;
}

if (goog.LOCALE == 'ti_ER' || goog.LOCALE == 'ti-ER') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ti_ER;
}

if (goog.LOCALE == 'ti_ET' || goog.LOCALE == 'ti-ET') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ti_ET;
}

if (goog.LOCALE == 'to') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_to;
}

if (goog.LOCALE == 'to_TO' || goog.LOCALE == 'to-TO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_to_TO;
}

if (goog.LOCALE == 'tr_CY' || goog.LOCALE == 'tr-CY') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_tr_CY;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_tr_TR;
}

if (goog.LOCALE == 'twq') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_twq;
}

if (goog.LOCALE == 'twq_NE' || goog.LOCALE == 'twq-NE') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_twq_NE;
}

if (goog.LOCALE == 'tzm') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_tzm;
}

if (goog.LOCALE == 'tzm_Latn' || goog.LOCALE == 'tzm-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_tzm_Latn;
}

if (goog.LOCALE == 'tzm_Latn_MA' || goog.LOCALE == 'tzm-Latn-MA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_tzm_Latn_MA;
}

if (goog.LOCALE == 'ug') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ug;
}

if (goog.LOCALE == 'ug_Arab' || goog.LOCALE == 'ug-Arab') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ug_Arab;
}

if (goog.LOCALE == 'ug_Arab_CN' || goog.LOCALE == 'ug-Arab-CN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ug_Arab_CN;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uk_UA;
}

if (goog.LOCALE == 'ur_IN' || goog.LOCALE == 'ur-IN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ur_IN;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_ur_PK;
}

if (goog.LOCALE == 'uz_Arab' || goog.LOCALE == 'uz-Arab') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uz_Arab;
}

if (goog.LOCALE == 'uz_Arab_AF' || goog.LOCALE == 'uz-Arab-AF') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uz_Arab_AF;
}

if (goog.LOCALE == 'uz_Cyrl' || goog.LOCALE == 'uz-Cyrl') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uz_Cyrl;
}

if (goog.LOCALE == 'uz_Cyrl_UZ' || goog.LOCALE == 'uz-Cyrl-UZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uz_Cyrl_UZ;
}

if (goog.LOCALE == 'uz_Latn' || goog.LOCALE == 'uz-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uz_Latn;
}

if (goog.LOCALE == 'uz_Latn_UZ' || goog.LOCALE == 'uz-Latn-UZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_uz_Latn_UZ;
}

if (goog.LOCALE == 'vai') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vai;
}

if (goog.LOCALE == 'vai_Latn' || goog.LOCALE == 'vai-Latn') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vai_Latn;
}

if (goog.LOCALE == 'vai_Latn_LR' || goog.LOCALE == 'vai-Latn-LR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vai_Latn_LR;
}

if (goog.LOCALE == 'vai_Vaii' || goog.LOCALE == 'vai-Vaii') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vai_Vaii;
}

if (goog.LOCALE == 'vai_Vaii_LR' || goog.LOCALE == 'vai-Vaii-LR') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vai_Vaii_LR;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vi_VN;
}

if (goog.LOCALE == 'vun') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vun;
}

if (goog.LOCALE == 'vun_TZ' || goog.LOCALE == 'vun-TZ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_vun_TZ;
}

if (goog.LOCALE == 'xog') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_xog;
}

if (goog.LOCALE == 'xog_UG' || goog.LOCALE == 'xog-UG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_xog_UG;
}

if (goog.LOCALE == 'yav') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_yav;
}

if (goog.LOCALE == 'yav_CM' || goog.LOCALE == 'yav-CM') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_yav_CM;
}

if (goog.LOCALE == 'yo') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_yo;
}

if (goog.LOCALE == 'yo_BJ' || goog.LOCALE == 'yo-BJ') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_yo_BJ;
}

if (goog.LOCALE == 'yo_NG' || goog.LOCALE == 'yo-NG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_yo_NG;
}

if (goog.LOCALE == 'zgh') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zgh;
}

if (goog.LOCALE == 'zgh_MA' || goog.LOCALE == 'zgh-MA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zgh_MA;
}

if (goog.LOCALE == 'zh_Hans' || goog.LOCALE == 'zh-Hans') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hans_CN;
}

if (goog.LOCALE == 'zh_Hans_HK' || goog.LOCALE == 'zh-Hans-HK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hans_HK;
}

if (goog.LOCALE == 'zh_Hans_MO' || goog.LOCALE == 'zh-Hans-MO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hans_MO;
}

if (goog.LOCALE == 'zh_Hans_SG' || goog.LOCALE == 'zh-Hans-SG') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hans_SG;
}

if (goog.LOCALE == 'zh_Hant' || goog.LOCALE == 'zh-Hant') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hant;
}

if (goog.LOCALE == 'zh_Hant_HK' || goog.LOCALE == 'zh-Hant-HK') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hant_HK;
}

if (goog.LOCALE == 'zh_Hant_MO' || goog.LOCALE == 'zh-Hant-MO') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hant_MO;
}

if (goog.LOCALE == 'zh_Hant_TW' || goog.LOCALE == 'zh-Hant-TW') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zh_Hant_TW;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.i18n.DateTimePatterns = goog.i18n.DateTimePatterns_zu_ZA;
}

