/* main.c generated by valac 0.50.1.44-10688, the Vala compiler
 * generated from main.vala, do not modify */

/* Program invocation, startup and shutdown

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <getopt.h>
#include <unistd.h>
#include <errno.h>
#include <locale.h>

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_HELP_ELEMENT (help_element_get_type ())
#define HELP_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP_ELEMENT, HelpElement))
#define HELP_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP_ELEMENT, HelpElementClass))
#define IS_HELP_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP_ELEMENT))
#define IS_HELP_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP_ELEMENT))
#define HELP_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP_ELEMENT, HelpElementClass))

typedef struct _HelpElement HelpElement;
typedef struct _HelpElementClass HelpElementClass;

#define TYPE_OPT (opt_get_type ())
#define OPT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPT, Opt))
#define OPT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPT, OptClass))
#define IS_OPT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPT))
#define IS_OPT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPT))
#define OPT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPT, OptClass))

typedef struct _Opt Opt;
typedef struct _OptClass OptClass;
typedef struct _HelpElementPrivate HelpElementPrivate;
typedef struct _OptPrivate OptPrivate;
#define _help_element_unref0(var) ((var == NULL) ? NULL : (var = (help_element_unref (var), NULL)))
typedef enum  {
	ARG_TYPE_function = 1,
	ARG_TYPE_loadfile,
	ARG_TYPE_file
} ArgType;

#define TYPE_ARG_TYPE (arg_type_get_type ())

#define TYPE_DOC (doc_get_type ())
#define DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOC, Doc))
#define DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOC, DocClass))
#define IS_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOC))
#define IS_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOC))
#define DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOC, DocClass))

typedef struct _Doc Doc;
typedef struct _DocClass DocClass;
typedef struct _DocPrivate DocPrivate;

#define TYPE_ARG (arg_get_type ())
#define ARG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARG, Arg))
#define ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARG, ArgClass))
#define IS_ARG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARG))
#define IS_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARG))
#define ARG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARG, ArgClass))

typedef struct _Arg Arg;
typedef struct _ArgClass ArgClass;
typedef struct _ArgPrivate ArgPrivate;

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _HelpElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HelpElementPrivate * priv;
};

struct _HelpElementClass {
	GTypeClass parent_class;
	void (*finalize) (HelpElement *self);
};

struct _Opt {
	HelpElement parent_instance;
	OptPrivate * priv;
	gchar* longname;
	gchar shortname;
	gint arg;
	gchar* argstring;
	gchar* docstring;
};

struct _OptClass {
	HelpElementClass parent_class;
};

struct _Doc {
	HelpElement parent_instance;
	DocPrivate * priv;
	gchar* text;
};

struct _DocClass {
	HelpElementClass parent_class;
};

struct _Arg {
	HelpElement parent_instance;
	ArgPrivate * priv;
	gchar* argstring;
	gchar* docstring;
};

struct _ArgClass {
	HelpElementClass parent_class;
};

extern gchar* program_name;
gchar* program_name = NULL;
extern gchar* ZILE_VERSION_STRING;
gchar* ZILE_VERSION_STRING = NULL;
extern gchar* ZILE_COPYRIGHT_STRING;
gchar* ZILE_COPYRIGHT_STRING = NULL;
extern Buffer* cur_bp;
Buffer* cur_bp = NULL;
extern Buffer* head_bp;
Buffer* head_bp = NULL;
extern Flags thisflag;
Flags thisflag = 0;
extern Flags lastflag;
Flags lastflag = 0;
extern gint last_uniarg;
gint last_uniarg = 1;
extern HelpElement** opts;
extern gint opts_length1;
extern Window* cur_wp;

gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
GType flags_get_type (void) G_GNUC_CONST ;
#define EXIT_SIGNAL 2
#define EXIT_COREDUMP 3
void zile_exit (gint reason);
void term_finish (void);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
gchar* buffer_get_filename_or_name (Buffer* self);
gint write_to_disk (Buffer* bp,
                    const gchar* filename,
                    mode_t mode);
void segv_sig_handler (gint signo);
void other_sig_handler (gint signo);
void signal_init (void);
static void _segv_sig_handler_sighandler_t (gint signal);
static void _other_sig_handler_sighandler_t (gint signal);
gint _vala_main (gchar** args,
                 gint args_length1);
void init_cmdline (void);
gpointer help_element_ref (gpointer instance);
void help_element_unref (gpointer instance);
GParamSpec* param_spec_help_element (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_help_element (GValue* value,
                             gpointer v_object);
void value_take_help_element (GValue* value,
                              gpointer v_object);
gpointer value_get_help_element (const GValue* value);
GType help_element_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HelpElement, help_element_unref)
GType opt_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Opt, help_element_unref)
void lisp_init (void);
void init_variables (void);
void basic_init (void);
void buffer_init_lisp (void);
void bind_init (void);
void eval_init (void);
void file_init (void);
void funcs_init (void);
void help_init (void);
void killring_init (void);
void line_init (void);
void macro_init (void);
void redisplay_init (void);
void registers_init (void);
void search_init (void);
void shell_init (void);
void undo_init (void);
void variables_init (void);
void window_init (void);
GType arg_type_get_type (void) G_GNUC_CONST ;
void minibuf_error (const gchar* fmt,
                    ...);
static gsize* _size_t_dup (gsize* self);
gchar* expand_path (const gchar* path);
GType doc_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Doc, help_element_unref)
GType arg_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Arg, help_element_unref)
void term_init (void);
void minibuf_init (void);
void create_scratch_window (void);
void bprintf (const gchar* fmt,
              ...);
void init_default_bindings (void);
gboolean lisp_loadfile (const gchar* file);
gboolean minibuf_no_error (void);
gboolean get_variable_bool (const gchar* name);
Buffer* create_auto_buffer (const gchar* name);
void buffer_switch_to (Buffer* self);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg);
gboolean execute_function (const gchar* name,
                           glong uniarg,
                           gboolean is_uniarg);
gboolean find_file (const gchar* filename);
void buffer_init (Buffer* self);
void minibuf_refresh (void);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
void window_resync (Window* self);
void get_and_run_command (void);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);

static GType
flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{FLAGS_NEED_RESYNC, "FLAGS_NEED_RESYNC", "need-resync"}, {FLAGS_SET_UNIARG, "FLAGS_SET_UNIARG", "set-uniarg"}, {FLAGS_UNIARG_EMPTY, "FLAGS_UNIARG_EMPTY", "uniarg-empty"}, {FLAGS_DEFINING_MACRO, "FLAGS_DEFINING_MACRO", "defining-macro"}, {0, NULL, NULL}};
	GType flags_type_id;
	flags_type_id = g_flags_register_static ("Flags", values);
	return flags_type_id;
}

GType
flags_get_type (void)
{
	static volatile gsize flags_type_id__volatile = 0;
	if (g_once_init_enter (&flags_type_id__volatile)) {
		GType flags_type_id;
		flags_type_id = flags_get_type_once ();
		g_once_init_leave (&flags_type_id__volatile, flags_type_id);
	}
	return flags_type_id__volatile;
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 59 "src/main.vala"
	return self ? buffer_ref (self) : NULL;
#line 431 "main.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 444 "main.c"
}

void
zile_exit (gint reason)
{
#line 55 "src/main.vala"
	if (reason == EXIT_SUCCESS) {
#line 56 "src/main.vala"
		term_finish ();
#line 454 "main.c"
	} else {
		FILE* _tmp0_;
#line 58 "src/main.vala"
		_tmp0_ = stderr;
#line 58 "src/main.vala"
		fprintf (_tmp0_, "Trying to save modified buffers (if any)...\r\n");
#line 461 "main.c"
		{
			Buffer* bp = NULL;
			Buffer* _tmp1_;
			Buffer* _tmp2_;
#line 59 "src/main.vala"
			_tmp1_ = head_bp;
#line 59 "src/main.vala"
			_tmp2_ = _buffer_ref0 (_tmp1_);
#line 59 "src/main.vala"
			bp = _tmp2_;
#line 472 "main.c"
			{
				gboolean _tmp3_ = FALSE;
#line 59 "src/main.vala"
				_tmp3_ = TRUE;
#line 59 "src/main.vala"
				while (TRUE) {
#line 479 "main.c"
					Buffer* _tmp7_;
					gboolean _tmp8_ = FALSE;
					Buffer* _tmp9_;
#line 59 "src/main.vala"
					if (!_tmp3_) {
#line 485 "main.c"
						Buffer* _tmp4_;
						Buffer* _tmp5_;
						Buffer* _tmp6_;
#line 59 "src/main.vala"
						_tmp4_ = bp;
#line 59 "src/main.vala"
						_tmp5_ = _tmp4_->next;
#line 59 "src/main.vala"
						_tmp6_ = _buffer_ref0 (_tmp5_);
#line 59 "src/main.vala"
						_buffer_unref0 (bp);
#line 59 "src/main.vala"
						bp = _tmp6_;
#line 499 "main.c"
					}
#line 59 "src/main.vala"
					_tmp3_ = FALSE;
#line 59 "src/main.vala"
					_tmp7_ = bp;
#line 59 "src/main.vala"
					if (!(_tmp7_ != NULL)) {
#line 59 "src/main.vala"
						break;
#line 509 "main.c"
					}
#line 60 "src/main.vala"
					_tmp9_ = bp;
#line 60 "src/main.vala"
					if (_tmp9_->modified) {
#line 515 "main.c"
						Buffer* _tmp10_;
#line 60 "src/main.vala"
						_tmp10_ = bp;
#line 60 "src/main.vala"
						_tmp8_ = !_tmp10_->nosave;
#line 521 "main.c"
					} else {
#line 60 "src/main.vala"
						_tmp8_ = FALSE;
#line 525 "main.c"
					}
#line 60 "src/main.vala"
					if (_tmp8_) {
#line 529 "main.c"
						gchar* name = NULL;
						Buffer* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						FILE* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						Buffer* _tmp23_;
						const gchar* _tmp24_;
#line 61 "src/main.vala"
						_tmp11_ = bp;
#line 61 "src/main.vala"
						_tmp12_ = buffer_get_filename_or_name (_tmp11_);
#line 61 "src/main.vala"
						_tmp13_ = _tmp12_;
#line 61 "src/main.vala"
						_tmp14_ = g_utf8_strup (PACKAGE, (gssize) -1);
#line 61 "src/main.vala"
						_tmp15_ = _tmp14_;
#line 61 "src/main.vala"
						_tmp16_ = g_strdup_printf ("%s.%sSAVE", _tmp13_, _tmp15_);
#line 61 "src/main.vala"
						_tmp17_ = _tmp16_;
#line 61 "src/main.vala"
						_g_free0 (_tmp15_);
#line 61 "src/main.vala"
						_g_free0 (_tmp13_);
#line 61 "src/main.vala"
						name = _tmp17_;
#line 62 "src/main.vala"
						_tmp18_ = stderr;
#line 62 "src/main.vala"
						_tmp19_ = name;
#line 62 "src/main.vala"
						_tmp20_ = string_to_string (_tmp19_);
#line 62 "src/main.vala"
						_tmp21_ = g_strconcat ("Saving ", _tmp20_, "...\r\n", NULL);
#line 62 "src/main.vala"
						_tmp22_ = _tmp21_;
#line 62 "src/main.vala"
						fprintf (_tmp18_, "%s", _tmp22_);
#line 62 "src/main.vala"
						_g_free0 (_tmp22_);
#line 63 "src/main.vala"
						_tmp23_ = bp;
#line 63 "src/main.vala"
						_tmp24_ = name;
#line 63 "src/main.vala"
						write_to_disk (_tmp23_, _tmp24_, S_IRUSR | S_IWUSR);
#line 60 "src/main.vala"
						_g_free0 (name);
#line 587 "main.c"
					}
				}
			}
#line 59 "src/main.vala"
			_buffer_unref0 (bp);
#line 593 "main.c"
		}
#line 65 "src/main.vala"
		if (reason == EXIT_COREDUMP) {
#line 66 "src/main.vala"
			abort ();
#line 599 "main.c"
		}
	}
#line 69 "src/main.vala"
	exit (reason);
#line 604 "main.c"
}

void
segv_sig_handler (gint signo)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
#line 76 "src/main.vala"
	_tmp0_ = stderr;
#line 76 "src/main.vala"
	_tmp1_ = program_name;
#line 76 "src/main.vala"
	_tmp2_ = string_to_string (_tmp1_);
#line 76 "src/main.vala"
	_tmp3_ = string_to_string (PACKAGE_NAME);
#line 76 "src/main.vala"
	_tmp4_ = g_strconcat (_tmp2_, ": ", _tmp3_, " crashed.  Please send a bug report to ", NULL);
#line 76 "src/main.vala"
	_tmp5_ = _tmp4_;
#line 76 "src/main.vala"
	_tmp6_ = string_to_string (PACKAGE_BUGREPORT);
#line 76 "src/main.vala"
	_tmp7_ = g_strconcat ("<", _tmp6_, ">.\r\n", NULL);
#line 76 "src/main.vala"
	_tmp8_ = _tmp7_;
#line 76 "src/main.vala"
	_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
#line 76 "src/main.vala"
	_tmp10_ = _tmp9_;
#line 76 "src/main.vala"
	fprintf (_tmp0_, "%s", _tmp10_);
#line 76 "src/main.vala"
	_g_free0 (_tmp10_);
#line 76 "src/main.vala"
	_g_free0 (_tmp8_);
#line 76 "src/main.vala"
	_g_free0 (_tmp5_);
#line 78 "src/main.vala"
	zile_exit (EXIT_COREDUMP);
#line 653 "main.c"
}

void
other_sig_handler (gint signo)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 82 "src/main.vala"
	_tmp0_ = stderr;
#line 82 "src/main.vala"
	_tmp1_ = program_name;
#line 82 "src/main.vala"
	_tmp2_ = string_to_string (_tmp1_);
#line 82 "src/main.vala"
	_tmp3_ = g_strdup_printf ("%i", signo);
#line 82 "src/main.vala"
	_tmp4_ = _tmp3_;
#line 82 "src/main.vala"
	_tmp5_ = g_strconcat (_tmp2_, ": terminated with signal ", _tmp4_, ".\r\n", NULL);
#line 82 "src/main.vala"
	_tmp6_ = _tmp5_;
#line 82 "src/main.vala"
	fprintf (_tmp0_, "%s", _tmp6_);
#line 82 "src/main.vala"
	_g_free0 (_tmp6_);
#line 82 "src/main.vala"
	_g_free0 (_tmp4_);
#line 83 "src/main.vala"
	zile_exit (EXIT_SIGNAL);
#line 688 "main.c"
}

static void
_segv_sig_handler_sighandler_t (gint signal)
{
#line 88 "src/main.vala"
	segv_sig_handler (signal);
#line 696 "main.c"
}

static void
_other_sig_handler_sighandler_t (gint signal)
{
#line 90 "src/main.vala"
	other_sig_handler (signal);
#line 704 "main.c"
}

void
signal_init (void)
{
#line 88 "src/main.vala"
	signal ((gint) SIGSEGV, _segv_sig_handler_sighandler_t);
#line 89 "src/main.vala"
	signal ((gint) SIGBUS, _segv_sig_handler_sighandler_t);
#line 90 "src/main.vala"
	signal ((gint) SIGHUP, _other_sig_handler_sighandler_t);
#line 91 "src/main.vala"
	signal ((gint) SIGINT, _other_sig_handler_sighandler_t);
#line 92 "src/main.vala"
	signal ((gint) SIGTERM, _other_sig_handler_sighandler_t);
#line 720 "main.c"
}

static gpointer
_help_element_ref0 (gpointer self)
{
#line 103 "src/main.vala"
	return self ? help_element_ref (self) : NULL;
#line 728 "main.c"
}

static gsize*
_size_t_dup (gsize* self)
{
	gsize* dup;
#line 197 "src/main.vala"
	dup = g_new0 (gsize, 1);
#line 197 "src/main.vala"
	memcpy (dup, self, sizeof (gsize));
#line 197 "src/main.vala"
	return dup;
#line 741 "main.c"
}

static gpointer
__size_t_dup0 (gpointer self)
{
#line 197 "src/main.vala"
	return self ? _size_t_dup (self) : NULL;
#line 749 "main.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 766 "main.c"
}

static gboolean
long_try_parse (const gchar* str,
                glong* _result_,
                const gchar* * unparsed,
                guint _base)
{
	glong _vala__result_ = 0L;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result = FALSE;
#line 319 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 321 "glib-2.0.vapi"
	errno = 0;
#line 322 "glib-2.0.vapi"
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
#line 322 "glib-2.0.vapi"
	endptr = _tmp0_;
#line 322 "glib-2.0.vapi"
	_vala__result_ = _tmp1_;
#line 323 "glib-2.0.vapi"
	_tmp2_ = endptr;
#line 323 "glib-2.0.vapi"
	_tmp3_ = strlen (str);
#line 323 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 323 "glib-2.0.vapi"
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
#line 802 "main.c"
		gboolean _tmp5_ = FALSE;
#line 324 "glib-2.0.vapi"
		_vala_unparsed = "";
#line 325 "glib-2.0.vapi"
		if (errno != ERANGE) {
#line 325 "glib-2.0.vapi"
			_tmp5_ = errno != EINVAL;
#line 810 "main.c"
		} else {
#line 325 "glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 814 "main.c"
		}
#line 325 "glib-2.0.vapi"
		result = _tmp5_;
#line 325 "glib-2.0.vapi"
		if (_result_) {
#line 325 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 822 "main.c"
		}
#line 325 "glib-2.0.vapi"
		if (unparsed) {
#line 325 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 828 "main.c"
		}
#line 325 "glib-2.0.vapi"
		return result;
#line 832 "main.c"
	} else {
		gchar* _tmp6_;
#line 327 "glib-2.0.vapi"
		_tmp6_ = endptr;
#line 327 "glib-2.0.vapi"
		_vala_unparsed = (const gchar*) _tmp6_;
#line 328 "glib-2.0.vapi"
		result = FALSE;
#line 328 "glib-2.0.vapi"
		if (_result_) {
#line 328 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 845 "main.c"
		}
#line 328 "glib-2.0.vapi"
		if (unparsed) {
#line 328 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 851 "main.c"
		}
#line 328 "glib-2.0.vapi"
		return result;
#line 855 "main.c"
	}
#line 319 "glib-2.0.vapi"
	if (_result_) {
#line 319 "glib-2.0.vapi"
		*_result_ = _vala__result_;
#line 861 "main.c"
	}
#line 319 "glib-2.0.vapi"
	if (unparsed) {
#line 319 "glib-2.0.vapi"
		*unparsed = _vala_unparsed;
#line 867 "main.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 891 "main.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 900 "main.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 919 "main.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 923 "main.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 929 "main.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 939 "main.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 947 "main.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 951 "main.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 957 "main.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 967 "main.c"
}

static void
_g_free0_ (gpointer var)
{
#line 95 "src/main.vala"
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
#line 975 "main.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 95 "src/main.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 983 "main.c"
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	struct option* longopts = NULL;
	HelpElement** _tmp2_;
	gint _tmp2__length1;
	struct option* _tmp3_;
	gint longopts_length1;
	gint _longopts_size_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* splash_str = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gboolean qflag = FALSE;
	GList* arg_type = NULL;
	GList* arg_arg = NULL;
	GList* arg_line = NULL;
	gsize line = 0UL;
	Buffer* scratch_bp = NULL;
	Buffer* _tmp138_;
	Buffer* _tmp139_;
	Buffer* _tmp140_;
	gboolean _tmp144_ = FALSE;
	gboolean _tmp145_ = FALSE;
	GList* _tmp146_;
	gboolean ok = FALSE;
	Flags _tmp168_;
	Buffer* last_bp = NULL;
	gint files = 0;
	Buffer* _tmp186_;
#line 97 "src/main.vala"
	g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);
#line 98 "src/main.vala"
	_tmp0_ = args[0];
#line 98 "src/main.vala"
	_tmp1_ = g_path_get_basename (_tmp0_);
#line 98 "src/main.vala"
	_g_free0 (program_name);
#line 98 "src/main.vala"
	program_name = _tmp1_;
#line 99 "src/main.vala"
	init_cmdline ();
#line 101 "src/main.vala"
	_tmp2_ = opts;
#line 101 "src/main.vala"
	_tmp2__length1 = opts_length1;
#line 101 "src/main.vala"
	_tmp3_ = g_new0 (struct option, _tmp2__length1);
#line 101 "src/main.vala"
	longopts = _tmp3_;
#line 101 "src/main.vala"
	longopts_length1 = _tmp2__length1;
#line 101 "src/main.vala"
	_longopts_size_ = longopts_length1;
#line 1072 "main.c"
	{
		guint i = 0U;
		guint nextopt = 0U;
#line 102 "src/main.vala"
		i = (guint) 0;
#line 102 "src/main.vala"
		nextopt = (guint) 0;
#line 1080 "main.c"
		{
			gboolean _tmp4_ = FALSE;
#line 102 "src/main.vala"
			_tmp4_ = TRUE;
#line 102 "src/main.vala"
			while (TRUE) {
#line 1087 "main.c"
				HelpElement** _tmp6_;
				gint _tmp6__length1;
				HelpElement* opt = NULL;
				HelpElement** _tmp7_;
				gint _tmp7__length1;
				HelpElement* _tmp8_;
				HelpElement* _tmp9_;
				HelpElement* _tmp10_;
#line 102 "src/main.vala"
				if (!_tmp4_) {
#line 1098 "main.c"
					guint _tmp5_;
#line 102 "src/main.vala"
					_tmp5_ = i;
#line 102 "src/main.vala"
					i = _tmp5_ + 1;
#line 1104 "main.c"
				}
#line 102 "src/main.vala"
				_tmp4_ = FALSE;
#line 102 "src/main.vala"
				_tmp6_ = opts;
#line 102 "src/main.vala"
				_tmp6__length1 = opts_length1;
#line 102 "src/main.vala"
				if (!(i < ((guint) _tmp6__length1))) {
#line 102 "src/main.vala"
					break;
#line 1116 "main.c"
				}
#line 103 "src/main.vala"
				_tmp7_ = opts;
#line 103 "src/main.vala"
				_tmp7__length1 = opts_length1;
#line 103 "src/main.vala"
				_tmp8_ = _tmp7_[i];
#line 103 "src/main.vala"
				_tmp9_ = _help_element_ref0 (_tmp8_);
#line 103 "src/main.vala"
				opt = _tmp9_;
#line 104 "src/main.vala"
				_tmp10_ = opt;
#line 104 "src/main.vala"
				if (IS_OPT (_tmp10_)) {
#line 1132 "main.c"
					struct option* _tmp11_;
					gint _tmp11__length1;
					guint _tmp12_;
					HelpElement* _tmp13_;
					const gchar* _tmp14_;
					HelpElement* _tmp15_;
					HelpElement* _tmp16_;
					struct option _tmp17_ = {0};
#line 105 "src/main.vala"
					_tmp11_ = longopts;
#line 105 "src/main.vala"
					_tmp11__length1 = longopts_length1;
#line 105 "src/main.vala"
					_tmp12_ = nextopt;
#line 105 "src/main.vala"
					nextopt = _tmp12_ + 1;
#line 105 "src/main.vala"
					_tmp13_ = opt;
#line 105 "src/main.vala"
					_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_OPT, Opt)->longname;
#line 105 "src/main.vala"
					_tmp15_ = opt;
#line 105 "src/main.vala"
					_tmp16_ = opt;
#line 105 "src/main.vala"
					memset (&_tmp17_, 0, sizeof (struct option));
#line 105 "src/main.vala"
					_tmp17_.name = _tmp14_;
#line 105 "src/main.vala"
					_tmp17_.has_arg = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_OPT, Opt)->arg;
#line 105 "src/main.vala"
					_tmp17_.flag = NULL;
#line 105 "src/main.vala"
					_tmp17_.val = (gint) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_OPT, Opt)->shortname;
#line 105 "src/main.vala"
					_tmp11_[_tmp12_] = _tmp17_;
#line 1169 "main.c"
				}
#line 102 "src/main.vala"
				_help_element_unref0 (opt);
#line 1173 "main.c"
			}
		}
	}
#line 114 "src/main.vala"
	_tmp18_ = g_strdup ("GNU " PACKAGE_NAME " " VERSION);
#line 114 "src/main.vala"
	_g_free0 (ZILE_VERSION_STRING);
#line 114 "src/main.vala"
	ZILE_VERSION_STRING = _tmp18_;
#line 115 "src/main.vala"
	_tmp19_ = g_strdup ("Copyright (C) 2020 Free Software Foundation, Inc.");
#line 115 "src/main.vala"
	_g_free0 (ZILE_COPYRIGHT_STRING);
#line 115 "src/main.vala"
	ZILE_COPYRIGHT_STRING = _tmp19_;
#line 118 "src/main.vala"
	_tmp20_ = ZILE_VERSION_STRING;
#line 118 "src/main.vala"
	_tmp21_ = g_strconcat ("\n" "Welcome to GNU " PACKAGE_NAME ".\n" "\n" "Undo changes       C-x u        Exit " PACKAGE_NAME "         C-x C-c\n" "(`C-' means use the CTRL key.  `M-' means hold the Meta (or Alt) key.\n" "If you have no Meta key, you may type ESC followed by the character.)\n" "Combinations like `C-x u' mean first press `C-x', then `u'.\n" "\n" "Keys not working properly?  See file://" PATH_DOCDIR "/FAQ\n" "\n", _tmp20_, NULL);
#line 118 "src/main.vala"
	_tmp22_ = _tmp21_;
#line 118 "src/main.vala"
	_tmp23_ = g_strconcat (_tmp22_, "\n", NULL);
#line 118 "src/main.vala"
	_tmp24_ = _tmp23_;
#line 118 "src/main.vala"
	_tmp25_ = ZILE_COPYRIGHT_STRING;
#line 118 "src/main.vala"
	_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
#line 118 "src/main.vala"
	_tmp27_ = _tmp26_;
#line 118 "src/main.vala"
	_tmp28_ = g_strconcat (_tmp27_, "\n", NULL);
#line 118 "src/main.vala"
	_tmp29_ = _tmp28_;
#line 118 "src/main.vala"
	_tmp30_ = g_strconcat (_tmp29_, "\n", NULL);
#line 118 "src/main.vala"
	_tmp31_ = _tmp30_;
#line 118 "src/main.vala"
	_tmp32_ = g_strconcat (_tmp31_, "GNU ", NULL);
#line 118 "src/main.vala"
	_tmp33_ = _tmp32_;
#line 118 "src/main.vala"
	_tmp34_ = g_strconcat (_tmp33_, PACKAGE_NAME, NULL);
#line 118 "src/main.vala"
	_tmp35_ = _tmp34_;
#line 118 "src/main.vala"
	_tmp36_ = g_strconcat (_tmp35_, " comes with ABSOLUTELY NO WARRANTY.\n", NULL);
#line 118 "src/main.vala"
	_tmp37_ = _tmp36_;
#line 118 "src/main.vala"
	_tmp38_ = g_strconcat (_tmp37_, PACKAGE_NAME, NULL);
#line 118 "src/main.vala"
	_tmp39_ = _tmp38_;
#line 118 "src/main.vala"
	_tmp40_ = g_strconcat (_tmp39_, " is Free Software--Free as in Freedom--so you can redistribute copies\n", NULL);
#line 118 "src/main.vala"
	_tmp41_ = _tmp40_;
#line 118 "src/main.vala"
	_tmp42_ = g_strconcat (_tmp41_, "of ", NULL);
#line 118 "src/main.vala"
	_tmp43_ = _tmp42_;
#line 118 "src/main.vala"
	_tmp44_ = g_strconcat (_tmp43_, PACKAGE_NAME, NULL);
#line 118 "src/main.vala"
	_tmp45_ = _tmp44_;
#line 118 "src/main.vala"
	_tmp46_ = g_strconcat (_tmp45_, " and modify it; see the file COPYING.  Otherwise, a copy can be\n", NULL);
#line 118 "src/main.vala"
	_tmp47_ = _tmp46_;
#line 118 "src/main.vala"
	_tmp48_ = g_strconcat (_tmp47_, "downloaded from https://www.gnu.org/licenses/gpl.html.\n", NULL);
#line 118 "src/main.vala"
	_tmp49_ = _tmp48_;
#line 118 "src/main.vala"
	_g_free0 (_tmp47_);
#line 118 "src/main.vala"
	_g_free0 (_tmp45_);
#line 118 "src/main.vala"
	_g_free0 (_tmp43_);
#line 118 "src/main.vala"
	_g_free0 (_tmp41_);
#line 118 "src/main.vala"
	_g_free0 (_tmp39_);
#line 118 "src/main.vala"
	_g_free0 (_tmp37_);
#line 118 "src/main.vala"
	_g_free0 (_tmp35_);
#line 118 "src/main.vala"
	_g_free0 (_tmp33_);
#line 118 "src/main.vala"
	_g_free0 (_tmp31_);
#line 118 "src/main.vala"
	_g_free0 (_tmp29_);
#line 118 "src/main.vala"
	_g_free0 (_tmp27_);
#line 118 "src/main.vala"
	_g_free0 (_tmp24_);
#line 118 "src/main.vala"
	_g_free0 (_tmp22_);
#line 118 "src/main.vala"
	splash_str = _tmp49_;
#line 138 "src/main.vala"
	lisp_init ();
#line 139 "src/main.vala"
	init_variables ();
#line 140 "src/main.vala"
	basic_init ();
#line 141 "src/main.vala"
	buffer_init_lisp ();
#line 142 "src/main.vala"
	bind_init ();
#line 143 "src/main.vala"
	eval_init ();
#line 144 "src/main.vala"
	file_init ();
#line 145 "src/main.vala"
	funcs_init ();
#line 146 "src/main.vala"
	help_init ();
#line 147 "src/main.vala"
	killring_init ();
#line 148 "src/main.vala"
	line_init ();
#line 149 "src/main.vala"
	macro_init ();
#line 150 "src/main.vala"
	redisplay_init ();
#line 151 "src/main.vala"
	registers_init ();
#line 152 "src/main.vala"
	search_init ();
#line 153 "src/main.vala"
	shell_init ();
#line 154 "src/main.vala"
	undo_init ();
#line 155 "src/main.vala"
	variables_init ();
#line 156 "src/main.vala"
	window_init ();
#line 158 "src/main.vala"
	qflag = FALSE;
#line 159 "src/main.vala"
	arg_type = NULL;
#line 160 "src/main.vala"
	arg_arg = NULL;
#line 161 "src/main.vala"
	arg_line = NULL;
#line 162 "src/main.vala"
	line = (gsize) 1;
#line 164 "src/main.vala"
	opterr = 0;
#line 1327 "main.c"
	{
		gboolean _tmp50_ = FALSE;
#line 165 "src/main.vala"
		_tmp50_ = TRUE;
#line 165 "src/main.vala"
		while (TRUE) {
#line 1334 "main.c"
			gint _tmp51_ = 0;
			gint this_optind = 0;
			gint longindex = 0;
			gint c = 0;
			struct option* _tmp52_;
			gint _tmp52__length1;
			gint _tmp53_ = 0;
			gint _tmp54_;
#line 165 "src/main.vala"
			if (!_tmp50_) {
#line 1345 "main.c"
			}
#line 165 "src/main.vala"
			_tmp50_ = FALSE;
#line 166 "src/main.vala"
			if (optind != 0) {
#line 166 "src/main.vala"
				_tmp51_ = optind;
#line 1353 "main.c"
			} else {
#line 166 "src/main.vala"
				_tmp51_ = 1;
#line 1357 "main.c"
			}
#line 166 "src/main.vala"
			this_optind = _tmp51_;
#line 167 "src/main.vala"
			longindex = -1;
#line 172 "src/main.vala"
			_tmp52_ = longopts;
#line 172 "src/main.vala"
			_tmp52__length1 = longopts_length1;
#line 172 "src/main.vala"
			_tmp54_ = getopt_long ((gint) args_length1, args, "-:f:l:q", _tmp52_, &_tmp53_);
#line 172 "src/main.vala"
			longindex = _tmp53_;
#line 172 "src/main.vala"
			c = _tmp54_;
#line 174 "src/main.vala"
			if (c == -1) {
#line 175 "src/main.vala"
				break;
#line 1377 "main.c"
			} else {
#line 176 "src/main.vala"
				if (c == 1) {
#line 177 "src/main.vala"
					longindex = 5;
#line 1383 "main.c"
				} else {
#line 178 "src/main.vala"
					if (c == ((gint) '?')) {
#line 1387 "main.c"
						const gchar* _tmp55_;
#line 179 "src/main.vala"
						_tmp55_ = args[this_optind];
#line 179 "src/main.vala"
						minibuf_error ("Unknown option `%s'", _tmp55_, NULL);
#line 1393 "main.c"
					} else {
#line 180 "src/main.vala"
						if (c == ((gint) ':')) {
#line 1397 "main.c"
							FILE* _tmp56_;
							const gchar* _tmp57_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							gchar* _tmp61_;
							gchar* _tmp62_;
#line 181 "src/main.vala"
							_tmp56_ = stderr;
#line 181 "src/main.vala"
							_tmp57_ = program_name;
#line 181 "src/main.vala"
							_tmp58_ = string_to_string (_tmp57_);
#line 181 "src/main.vala"
							_tmp59_ = args[this_optind];
#line 181 "src/main.vala"
							_tmp60_ = string_to_string (_tmp59_);
#line 181 "src/main.vala"
							_tmp61_ = g_strconcat (_tmp58_, ": Option `", _tmp60_, "' requires an argument\n", NULL);
#line 181 "src/main.vala"
							_tmp62_ = _tmp61_;
#line 181 "src/main.vala"
							fprintf (_tmp56_, "%s", _tmp62_);
#line 181 "src/main.vala"
							_g_free0 (_tmp62_);
#line 182 "src/main.vala"
							exit (EXIT_FAILURE);
#line 1425 "main.c"
						} else {
#line 183 "src/main.vala"
							if (c == ((gint) 'q')) {
#line 184 "src/main.vala"
								longindex = 0;
#line 1431 "main.c"
							} else {
#line 185 "src/main.vala"
								if (c == ((gint) 'f')) {
#line 186 "src/main.vala"
									longindex = 1;
#line 1437 "main.c"
								} else {
#line 187 "src/main.vala"
									if (c == ((gint) 'l')) {
#line 188 "src/main.vala"
										longindex = 2;
#line 1443 "main.c"
									}
								}
							}
						}
					}
				}
			}
#line 190 "src/main.vala"
			switch (longindex) {
#line 190 "src/main.vala"
				case 0:
#line 1455 "main.c"
				{
#line 192 "src/main.vala"
					qflag = TRUE;
#line 193 "src/main.vala"
					break;
#line 1461 "main.c"
				}
#line 190 "src/main.vala"
				case 1:
#line 1465 "main.c"
				{
					const gchar* _tmp63_;
					gchar* _tmp64_;
					gsize _tmp65_;
					gsize* _tmp66_;
#line 195 "src/main.vala"
					arg_type = g_list_append (arg_type, (gpointer) ((gintptr) ARG_TYPE_function));
#line 196 "src/main.vala"
					_tmp63_ = optarg;
#line 196 "src/main.vala"
					_tmp64_ = g_strdup (_tmp63_);
#line 196 "src/main.vala"
					arg_arg = g_list_append (arg_arg, _tmp64_);
#line 197 "src/main.vala"
					_tmp65_ = (gsize) 0;
#line 197 "src/main.vala"
					_tmp66_ = __size_t_dup0 (&_tmp65_);
#line 197 "src/main.vala"
					arg_line = g_list_append (arg_line, _tmp66_);
#line 198 "src/main.vala"
					break;
#line 1487 "main.c"
				}
#line 190 "src/main.vala"
				case 2:
#line 1491 "main.c"
				{
					{
						gchar* a = NULL;
						const gchar* _tmp67_;
						gchar* _tmp68_;
						const gchar* _tmp69_;
						gchar* _tmp70_;
						gsize _tmp71_;
						gsize* _tmp72_;
#line 200 "src/main.vala"
						arg_type = g_list_append (arg_type, (gpointer) ((gintptr) ARG_TYPE_loadfile));
#line 201 "src/main.vala"
						_tmp67_ = optarg;
#line 201 "src/main.vala"
						_tmp68_ = expand_path (_tmp67_);
#line 201 "src/main.vala"
						a = _tmp68_;
#line 202 "src/main.vala"
						_tmp69_ = a;
#line 202 "src/main.vala"
						_tmp70_ = g_strdup (_tmp69_);
#line 202 "src/main.vala"
						arg_arg = g_list_append (arg_arg, _tmp70_);
#line 203 "src/main.vala"
						_tmp71_ = (gsize) 0;
#line 203 "src/main.vala"
						_tmp72_ = __size_t_dup0 (&_tmp71_);
#line 203 "src/main.vala"
						arg_line = g_list_append (arg_line, _tmp72_);
#line 204 "src/main.vala"
						_g_free0 (a);
#line 204 "src/main.vala"
						break;
#line 1525 "main.c"
					}
				}
#line 190 "src/main.vala"
				case 3:
#line 1530 "main.c"
				{
					const gchar* _tmp73_;
#line 207 "src/main.vala"
					_tmp73_ = args[0];
#line 207 "src/main.vala"
					printf ("Usage: %s [OPTION-OR-FILENAME]...\n" "\n" "Run " PACKAGE_NAME ", the lightweight Emacs clone.\n" "\n", _tmp73_);
#line 1537 "main.c"
					{
						guint i = 0U;
#line 212 "src/main.vala"
						i = (guint) 0;
#line 1542 "main.c"
						{
							gboolean _tmp74_ = FALSE;
#line 212 "src/main.vala"
							_tmp74_ = TRUE;
#line 212 "src/main.vala"
							while (TRUE) {
#line 1549 "main.c"
								HelpElement** _tmp76_;
								gint _tmp76__length1;
								HelpElement* opt = NULL;
								HelpElement** _tmp77_;
								gint _tmp77__length1;
								HelpElement* _tmp78_;
								HelpElement* _tmp79_;
								HelpElement* _tmp80_;
#line 212 "src/main.vala"
								if (!_tmp74_) {
#line 1560 "main.c"
									guint _tmp75_;
#line 212 "src/main.vala"
									_tmp75_ = i;
#line 212 "src/main.vala"
									i = _tmp75_ + 1;
#line 1566 "main.c"
								}
#line 212 "src/main.vala"
								_tmp74_ = FALSE;
#line 212 "src/main.vala"
								_tmp76_ = opts;
#line 212 "src/main.vala"
								_tmp76__length1 = opts_length1;
#line 212 "src/main.vala"
								if (!(i < ((guint) _tmp76__length1))) {
#line 212 "src/main.vala"
									break;
#line 1578 "main.c"
								}
#line 213 "src/main.vala"
								_tmp77_ = opts;
#line 213 "src/main.vala"
								_tmp77__length1 = opts_length1;
#line 213 "src/main.vala"
								_tmp78_ = _tmp77_[i];
#line 213 "src/main.vala"
								_tmp79_ = _help_element_ref0 (_tmp78_);
#line 213 "src/main.vala"
								opt = _tmp79_;
#line 214 "src/main.vala"
								_tmp80_ = opt;
#line 214 "src/main.vala"
								if (IS_DOC (_tmp80_)) {
#line 1594 "main.c"
									HelpElement* _tmp81_;
									const gchar* _tmp82_;
									gchar* _tmp83_;
									gchar* _tmp84_;
#line 215 "src/main.vala"
									_tmp81_ = opt;
#line 215 "src/main.vala"
									_tmp82_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, TYPE_DOC, Doc)->text;
#line 215 "src/main.vala"
									_tmp83_ = g_strconcat (_tmp82_, "\n", NULL);
#line 215 "src/main.vala"
									_tmp84_ = _tmp83_;
#line 215 "src/main.vala"
									g_print ("%s", _tmp84_);
#line 215 "src/main.vala"
									_g_free0 (_tmp84_);
#line 1611 "main.c"
								} else {
									HelpElement* _tmp85_;
#line 216 "src/main.vala"
									_tmp85_ = opt;
#line 216 "src/main.vala"
									if (IS_OPT (_tmp85_)) {
#line 1618 "main.c"
										gchar* shortopt = NULL;
										HelpElement* _tmp86_;
										gchar* _tmp87_;
										const gchar* _tmp88_ = NULL;
										HelpElement* _tmp89_;
										gchar* optstring = NULL;
										HelpElement* _tmp91_;
										const gchar* _tmp92_;
										HelpElement* _tmp93_;
										const gchar* _tmp94_;
										gchar* _tmp95_;
										const gchar* _tmp96_;
										HelpElement* _tmp97_;
										const gchar* _tmp98_;
#line 217 "src/main.vala"
										_tmp86_ = opt;
#line 217 "src/main.vala"
										_tmp87_ = g_strdup_printf (", -%c", (gint) G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, TYPE_OPT, Opt)->shortname);
#line 217 "src/main.vala"
										shortopt = _tmp87_;
#line 220 "src/main.vala"
										_tmp89_ = opt;
#line 220 "src/main.vala"
										if (((gint) G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, TYPE_OPT, Opt)->shortname) != 0) {
#line 1643 "main.c"
											const gchar* _tmp90_;
#line 220 "src/main.vala"
											_tmp90_ = shortopt;
#line 220 "src/main.vala"
											_tmp88_ = _tmp90_;
#line 1649 "main.c"
										} else {
#line 220 "src/main.vala"
											_tmp88_ = "";
#line 1653 "main.c"
										}
#line 218 "src/main.vala"
										_tmp91_ = opt;
#line 218 "src/main.vala"
										_tmp92_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, TYPE_OPT, Opt)->longname;
#line 218 "src/main.vala"
										_tmp93_ = opt;
#line 218 "src/main.vala"
										_tmp94_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, TYPE_OPT, Opt)->argstring;
#line 218 "src/main.vala"
										_tmp95_ = g_strdup_printf ("--%s%s %s", _tmp92_, _tmp88_, _tmp94_);
#line 218 "src/main.vala"
										optstring = _tmp95_;
#line 222 "src/main.vala"
										_tmp96_ = optstring;
#line 222 "src/main.vala"
										_tmp97_ = opt;
#line 222 "src/main.vala"
										_tmp98_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, TYPE_OPT, Opt)->docstring;
#line 222 "src/main.vala"
										g_print ("%-24s%s\n", _tmp96_, _tmp98_);
#line 216 "src/main.vala"
										_g_free0 (optstring);
#line 216 "src/main.vala"
										_g_free0 (shortopt);
#line 1679 "main.c"
									} else {
										HelpElement* _tmp99_;
#line 223 "src/main.vala"
										_tmp99_ = opt;
#line 223 "src/main.vala"
										if (IS_ARG (_tmp99_)) {
#line 1686 "main.c"
											HelpElement* _tmp100_;
											const gchar* _tmp101_;
											HelpElement* _tmp102_;
											const gchar* _tmp103_;
#line 224 "src/main.vala"
											_tmp100_ = opt;
#line 224 "src/main.vala"
											_tmp101_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, TYPE_ARG, Arg)->argstring;
#line 224 "src/main.vala"
											_tmp102_ = opt;
#line 224 "src/main.vala"
											_tmp103_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, TYPE_ARG, Arg)->docstring;
#line 224 "src/main.vala"
											g_print ("%-24s%s\n", _tmp101_, _tmp103_);
#line 1701 "main.c"
										} else {
#line 226 "src/main.vala"
											abort ();
#line 1705 "main.c"
										}
									}
								}
#line 212 "src/main.vala"
								_help_element_unref0 (opt);
#line 1711 "main.c"
							}
						}
					}
#line 229 "src/main.vala"
					g_print ("%s", "\n" "Report bugs to " PACKAGE_BUGREPORT ".\n");
#line 231 "src/main.vala"
					exit (EXIT_SUCCESS);
#line 232 "src/main.vala"
					break;
#line 1721 "main.c"
				}
#line 190 "src/main.vala"
				case 4:
#line 1725 "main.c"
				{
					const gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					const gchar* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					gchar* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					gchar* _tmp123_;
					gchar* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
#line 234 "src/main.vala"
					_tmp104_ = ZILE_VERSION_STRING;
#line 234 "src/main.vala"
					_tmp105_ = g_strconcat (_tmp104_, "\n", NULL);
#line 234 "src/main.vala"
					_tmp106_ = _tmp105_;
#line 234 "src/main.vala"
					_tmp107_ = ZILE_COPYRIGHT_STRING;
#line 234 "src/main.vala"
					_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
#line 234 "src/main.vala"
					_tmp109_ = _tmp108_;
#line 234 "src/main.vala"
					_tmp110_ = g_strconcat (_tmp109_, "\n", NULL);
#line 234 "src/main.vala"
					_tmp111_ = _tmp110_;
#line 234 "src/main.vala"
					_tmp112_ = g_strconcat (_tmp111_, "GNU ", NULL);
#line 234 "src/main.vala"
					_tmp113_ = _tmp112_;
#line 234 "src/main.vala"
					_tmp114_ = g_strconcat (_tmp113_, PACKAGE_NAME, NULL);
#line 234 "src/main.vala"
					_tmp115_ = _tmp114_;
#line 234 "src/main.vala"
					_tmp116_ = g_strconcat (_tmp115_, " comes with ABSOLUTELY NO WARRANTY.\n", NULL);
#line 234 "src/main.vala"
					_tmp117_ = _tmp116_;
#line 234 "src/main.vala"
					_tmp118_ = g_strconcat (_tmp117_, "You may redistribute copies of ", NULL);
#line 234 "src/main.vala"
					_tmp119_ = _tmp118_;
#line 234 "src/main.vala"
					_tmp120_ = g_strconcat (_tmp119_, PACKAGE_NAME, NULL);
#line 234 "src/main.vala"
					_tmp121_ = _tmp120_;
#line 234 "src/main.vala"
					_tmp122_ = g_strconcat (_tmp121_, "\n", NULL);
#line 234 "src/main.vala"
					_tmp123_ = _tmp122_;
#line 234 "src/main.vala"
					_tmp124_ = g_strconcat (_tmp123_, "under the terms of the GNU General Public License.\n", NULL);
#line 234 "src/main.vala"
					_tmp125_ = _tmp124_;
#line 234 "src/main.vala"
					_tmp126_ = g_strconcat (_tmp125_, "For more information about these matters, see the file named COPYING.\n", NULL);
#line 234 "src/main.vala"
					_tmp127_ = _tmp126_;
#line 234 "src/main.vala"
					g_print ("%s", _tmp127_);
#line 234 "src/main.vala"
					_g_free0 (_tmp127_);
#line 234 "src/main.vala"
					_g_free0 (_tmp125_);
#line 234 "src/main.vala"
					_g_free0 (_tmp123_);
#line 234 "src/main.vala"
					_g_free0 (_tmp121_);
#line 234 "src/main.vala"
					_g_free0 (_tmp119_);
#line 234 "src/main.vala"
					_g_free0 (_tmp117_);
#line 234 "src/main.vala"
					_g_free0 (_tmp115_);
#line 234 "src/main.vala"
					_g_free0 (_tmp113_);
#line 234 "src/main.vala"
					_g_free0 (_tmp111_);
#line 234 "src/main.vala"
					_g_free0 (_tmp109_);
#line 234 "src/main.vala"
					_g_free0 (_tmp106_);
#line 240 "src/main.vala"
					exit (EXIT_SUCCESS);
#line 241 "src/main.vala"
					break;
#line 1827 "main.c"
				}
#line 190 "src/main.vala"
				case 5:
#line 1831 "main.c"
				{
					const gchar* _tmp128_;
#line 243 "src/main.vala"
					_tmp128_ = optarg;
#line 243 "src/main.vala"
					if (string_get (_tmp128_, (glong) 0) == '+') {
#line 1838 "main.c"
						const gchar* _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						glong _tmp132_ = 0L;
#line 244 "src/main.vala"
						_tmp129_ = optarg;
#line 244 "src/main.vala"
						_tmp130_ = string_substring (_tmp129_, (glong) 1, (glong) -1);
#line 244 "src/main.vala"
						_tmp131_ = _tmp130_;
#line 244 "src/main.vala"
						long_try_parse (_tmp131_, &_tmp132_, NULL, (guint) 10);
#line 244 "src/main.vala"
						line = (gsize) _tmp132_;
#line 244 "src/main.vala"
						_g_free0 (_tmp131_);
#line 1855 "main.c"
					} else {
						gchar* a = NULL;
						const gchar* _tmp133_;
						gchar* _tmp134_;
						const gchar* _tmp135_;
						gchar* _tmp136_;
						gsize* _tmp137_;
#line 246 "src/main.vala"
						arg_type = g_list_append (arg_type, (gpointer) ((gintptr) ARG_TYPE_file));
#line 247 "src/main.vala"
						_tmp133_ = optarg;
#line 247 "src/main.vala"
						_tmp134_ = expand_path (_tmp133_);
#line 247 "src/main.vala"
						a = _tmp134_;
#line 248 "src/main.vala"
						_tmp135_ = a;
#line 248 "src/main.vala"
						_tmp136_ = g_strdup (_tmp135_);
#line 248 "src/main.vala"
						arg_arg = g_list_append (arg_arg, _tmp136_);
#line 249 "src/main.vala"
						_tmp137_ = __size_t_dup0 (&line);
#line 249 "src/main.vala"
						arg_line = g_list_append (arg_line, _tmp137_);
#line 250 "src/main.vala"
						line = (gsize) 1;
#line 243 "src/main.vala"
						_g_free0 (a);
#line 1885 "main.c"
					}
#line 252 "src/main.vala"
					break;
#line 1889 "main.c"
				}
				default:
				{
#line 254 "src/main.vala"
					break;
#line 1895 "main.c"
				}
			}
		}
	}
#line 258 "src/main.vala"
	signal_init ();
#line 260 "src/main.vala"
	setlocale (LC_ALL, "");
#line 262 "src/main.vala"
	term_init ();
#line 266 "src/main.vala"
	minibuf_init ();
#line 267 "src/main.vala"
	create_scratch_window ();
#line 268 "src/main.vala"
	_tmp138_ = cur_bp;
#line 268 "src/main.vala"
	_tmp139_ = _buffer_ref0 (_tmp138_);
#line 268 "src/main.vala"
	scratch_bp = _tmp139_;
#line 269 "src/main.vala"
	bprintf ("%s", ";; This buffer is for notes you don't want to save.\n" ";; If you want to create a file, visit that file with C-x C-f,\n" ";; then enter the text in that file's own buffer.\n" "\n", NULL);
#line 274 "src/main.vala"
	_tmp140_ = cur_bp;
#line 274 "src/main.vala"
	_tmp140_->modified = FALSE;
#line 276 "src/main.vala"
	init_default_bindings ();
#line 278 "src/main.vala"
	if (!qflag) {
#line 1926 "main.c"
		const gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
#line 279 "src/main.vala"
		_tmp141_ = g_get_home_dir ();
#line 279 "src/main.vala"
		_tmp142_ = g_build_filename (_tmp141_, "." PACKAGE, NULL);
#line 279 "src/main.vala"
		_tmp143_ = _tmp142_;
#line 279 "src/main.vala"
		lisp_loadfile (_tmp143_);
#line 279 "src/main.vala"
		_g_free0 (_tmp143_);
#line 1940 "main.c"
	}
#line 284 "src/main.vala"
	_tmp146_ = arg_arg;
#line 284 "src/main.vala"
	if (g_list_length (_tmp146_) == ((guint) 0)) {
#line 284 "src/main.vala"
		_tmp145_ = minibuf_no_error ();
#line 1948 "main.c"
	} else {
#line 284 "src/main.vala"
		_tmp145_ = FALSE;
#line 1952 "main.c"
	}
#line 284 "src/main.vala"
	if (_tmp145_) {
#line 285 "src/main.vala"
		_tmp144_ = !get_variable_bool ("inhibit-splash-screen");
#line 1958 "main.c"
	} else {
#line 284 "src/main.vala"
		_tmp144_ = FALSE;
#line 1962 "main.c"
	}
#line 284 "src/main.vala"
	if (_tmp144_) {
#line 1966 "main.c"
		Buffer* bp = NULL;
		Buffer* _tmp147_;
		Buffer* _tmp148_;
		const gchar* _tmp149_;
		Buffer* _tmp150_;
#line 286 "src/main.vala"
		_tmp147_ = create_auto_buffer ("*GNU " PACKAGE_NAME "*");
#line 286 "src/main.vala"
		bp = _tmp147_;
#line 287 "src/main.vala"
		_tmp148_ = bp;
#line 287 "src/main.vala"
		buffer_switch_to (_tmp148_);
#line 288 "src/main.vala"
		_tmp149_ = splash_str;
#line 288 "src/main.vala"
		bprintf ("%s", _tmp149_, NULL);
#line 289 "src/main.vala"
		_tmp150_ = bp;
#line 289 "src/main.vala"
		_tmp150_->readonly = TRUE;
#line 290 "src/main.vala"
		funcall ("beginning-of-buffer", NULL);
#line 284 "src/main.vala"
		_buffer_unref0 (bp);
#line 1992 "main.c"
	}
#line 295 "src/main.vala"
	ok = TRUE;
#line 1996 "main.c"
	{
		guint i = 0U;
#line 296 "src/main.vala"
		i = (guint) 0;
#line 2001 "main.c"
		{
			gboolean _tmp151_ = FALSE;
#line 296 "src/main.vala"
			_tmp151_ = TRUE;
#line 296 "src/main.vala"
			while (TRUE) {
#line 2008 "main.c"
				gboolean _tmp153_ = FALSE;
				gchar* arg = NULL;
				GList* _tmp155_;
				gconstpointer _tmp156_;
				gchar* _tmp157_;
				GList* _tmp158_;
				gconstpointer _tmp159_;
#line 296 "src/main.vala"
				if (!_tmp151_) {
#line 2018 "main.c"
					guint _tmp152_;
#line 296 "src/main.vala"
					_tmp152_ = i;
#line 296 "src/main.vala"
					i = _tmp152_ + 1;
#line 2024 "main.c"
				}
#line 296 "src/main.vala"
				_tmp151_ = FALSE;
#line 296 "src/main.vala"
				if (ok) {
#line 2030 "main.c"
					GList* _tmp154_;
#line 296 "src/main.vala"
					_tmp154_ = arg_arg;
#line 296 "src/main.vala"
					_tmp153_ = i < g_list_length (_tmp154_);
#line 2036 "main.c"
				} else {
#line 296 "src/main.vala"
					_tmp153_ = FALSE;
#line 2040 "main.c"
				}
#line 296 "src/main.vala"
				if (!_tmp153_) {
#line 296 "src/main.vala"
					break;
#line 2046 "main.c"
				}
#line 297 "src/main.vala"
				_tmp155_ = arg_arg;
#line 297 "src/main.vala"
				_tmp156_ = g_list_nth_data (_tmp155_, i);
#line 297 "src/main.vala"
				_tmp157_ = g_strdup ((const gchar*) _tmp156_);
#line 297 "src/main.vala"
				arg = _tmp157_;
#line 299 "src/main.vala"
				_tmp158_ = arg_type;
#line 299 "src/main.vala"
				_tmp159_ = g_list_nth_data (_tmp158_, i);
#line 299 "src/main.vala"
				switch ((ArgType) ((gintptr) _tmp159_)) {
#line 299 "src/main.vala"
					case ARG_TYPE_function:
#line 2064 "main.c"
					{
						{
							const gchar* _tmp160_;
#line 302 "src/main.vala"
							_tmp160_ = arg;
#line 302 "src/main.vala"
							ok = execute_function (_tmp160_, (glong) 1, FALSE);
#line 303 "src/main.vala"
							if (!ok) {
#line 2074 "main.c"
								const gchar* _tmp161_;
#line 304 "src/main.vala"
								_tmp161_ = arg;
#line 304 "src/main.vala"
								minibuf_error ("Function `%s' not defined", _tmp161_, NULL);
#line 2080 "main.c"
							}
#line 305 "src/main.vala"
							break;
#line 2084 "main.c"
						}
					}
#line 299 "src/main.vala"
					case ARG_TYPE_loadfile:
#line 2089 "main.c"
					{
						const gchar* _tmp162_;
#line 308 "src/main.vala"
						_tmp162_ = arg;
#line 308 "src/main.vala"
						ok = lisp_loadfile (_tmp162_);
#line 309 "src/main.vala"
						if (!ok) {
#line 2098 "main.c"
							const gchar* _tmp163_;
#line 310 "src/main.vala"
							_tmp163_ = arg;
#line 310 "src/main.vala"
							minibuf_error ("Cannot open load file: %s\n", _tmp163_, NULL);
#line 2104 "main.c"
						}
#line 311 "src/main.vala"
						break;
#line 2108 "main.c"
					}
#line 299 "src/main.vala"
					case ARG_TYPE_file:
#line 2112 "main.c"
					{
						{
							const gchar* _tmp164_;
#line 314 "src/main.vala"
							_tmp164_ = arg;
#line 314 "src/main.vala"
							ok = find_file (_tmp164_);
#line 315 "src/main.vala"
							if (ok) {
#line 2122 "main.c"
								GList* _tmp165_;
								gconstpointer _tmp166_;
								glong _tmp167_;
#line 316 "src/main.vala"
								_tmp165_ = arg_line;
#line 316 "src/main.vala"
								_tmp166_ = g_list_nth_data (_tmp165_, i);
#line 316 "src/main.vala"
								_tmp167_ = (glong) (*((gsize*) _tmp166_));
#line 316 "src/main.vala"
								funcall ("goto-line", &_tmp167_);
#line 2134 "main.c"
							}
#line 317 "src/main.vala"
							break;
#line 2138 "main.c"
						}
					}
					default:
					{
#line 320 "src/main.vala"
						break;
#line 2145 "main.c"
					}
				}
#line 296 "src/main.vala"
				_g_free0 (arg);
#line 2150 "main.c"
			}
		}
	}
#line 323 "src/main.vala"
	_tmp168_ = lastflag;
#line 323 "src/main.vala"
	lastflag = _tmp168_ | FLAGS_NEED_RESYNC;
#line 326 "src/main.vala"
	last_bp = NULL;
#line 327 "src/main.vala"
	files = 0;
#line 2162 "main.c"
	{
		Buffer* bp = NULL;
		Buffer* _tmp169_;
		Buffer* _tmp170_;
#line 328 "src/main.vala"
		_tmp169_ = head_bp;
#line 328 "src/main.vala"
		_tmp170_ = _buffer_ref0 (_tmp169_);
#line 328 "src/main.vala"
		bp = _tmp170_;
#line 2173 "main.c"
		{
			gboolean _tmp171_ = FALSE;
#line 328 "src/main.vala"
			_tmp171_ = TRUE;
#line 328 "src/main.vala"
			while (TRUE) {
#line 2180 "main.c"
				Buffer* _tmp175_;
				gboolean _tmp176_ = FALSE;
				Buffer* _tmp177_;
				Buffer* _tmp178_;
				gint _tmp184_;
#line 328 "src/main.vala"
				if (!_tmp171_) {
#line 2188 "main.c"
					Buffer* _tmp172_;
					Buffer* _tmp173_;
					Buffer* _tmp174_;
#line 328 "src/main.vala"
					_tmp172_ = bp;
#line 328 "src/main.vala"
					_tmp173_ = _tmp172_->next;
#line 328 "src/main.vala"
					_tmp174_ = _buffer_ref0 (_tmp173_);
#line 328 "src/main.vala"
					_buffer_unref0 (bp);
#line 328 "src/main.vala"
					bp = _tmp174_;
#line 2202 "main.c"
				}
#line 328 "src/main.vala"
				_tmp171_ = FALSE;
#line 328 "src/main.vala"
				_tmp175_ = bp;
#line 328 "src/main.vala"
				if (!(_tmp175_ != NULL)) {
#line 328 "src/main.vala"
					break;
#line 2212 "main.c"
				}
#line 330 "src/main.vala"
				_tmp177_ = bp;
#line 330 "src/main.vala"
				_tmp178_ = _tmp177_->next;
#line 330 "src/main.vala"
				if (_tmp178_ != NULL) {
#line 2220 "main.c"
					Buffer* _tmp179_;
					Buffer* _tmp180_;
					Buffer* _tmp181_;
#line 330 "src/main.vala"
					_tmp179_ = bp;
#line 330 "src/main.vala"
					_tmp180_ = _tmp179_->next;
#line 330 "src/main.vala"
					_tmp181_ = _tmp180_->next;
#line 330 "src/main.vala"
					_tmp176_ = _tmp181_ == NULL;
#line 2232 "main.c"
				} else {
#line 330 "src/main.vala"
					_tmp176_ = FALSE;
#line 2236 "main.c"
				}
#line 330 "src/main.vala"
				if (_tmp176_) {
#line 2240 "main.c"
					Buffer* _tmp182_;
					Buffer* _tmp183_;
#line 331 "src/main.vala"
					_tmp182_ = bp;
#line 331 "src/main.vala"
					_tmp183_ = _buffer_ref0 (_tmp182_);
#line 331 "src/main.vala"
					_buffer_unref0 (last_bp);
#line 331 "src/main.vala"
					last_bp = _tmp183_;
#line 2251 "main.c"
				}
#line 332 "src/main.vala"
				_tmp184_ = files;
#line 332 "src/main.vala"
				files = _tmp184_ + 1;
#line 2257 "main.c"
			}
		}
#line 328 "src/main.vala"
		_buffer_unref0 (bp);
#line 2262 "main.c"
	}
#line 334 "src/main.vala"
	if (files == 3) {
#line 2266 "main.c"
		Buffer* _tmp185_;
#line 335 "src/main.vala"
		funcall ("split-window", NULL);
#line 336 "src/main.vala"
		_tmp185_ = last_bp;
#line 336 "src/main.vala"
		buffer_switch_to (_tmp185_);
#line 337 "src/main.vala"
		funcall ("other-window", NULL);
#line 2276 "main.c"
	} else {
#line 338 "src/main.vala"
		if (files > 3) {
#line 339 "src/main.vala"
			funcall ("list-buffers", NULL);
#line 2282 "main.c"
		}
	}
#line 342 "src/main.vala"
	_tmp186_ = scratch_bp;
#line 342 "src/main.vala"
	buffer_init (_tmp186_);
#line 346 "src/main.vala"
	minibuf_refresh ();
#line 349 "src/main.vala"
	while (TRUE) {
#line 2293 "main.c"
		Flags _tmp187_;
#line 350 "src/main.vala"
		_tmp187_ = lastflag;
#line 350 "src/main.vala"
		if ((_tmp187_ & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 2299 "main.c"
			Window* _tmp188_;
#line 351 "src/main.vala"
			_tmp188_ = cur_wp;
#line 351 "src/main.vala"
			window_resync (_tmp188_);
#line 2305 "main.c"
		}
#line 352 "src/main.vala"
		get_and_run_command ();
#line 2309 "main.c"
	}
#line 95 "src/main.vala"
	_buffer_unref0 (last_bp);
#line 95 "src/main.vala"
	_buffer_unref0 (scratch_bp);
#line 95 "src/main.vala"
	(arg_line == NULL) ? NULL : (arg_line = (_g_list_free__g_free0_ (arg_line), NULL));
#line 95 "src/main.vala"
	(arg_arg == NULL) ? NULL : (arg_arg = (_g_list_free__g_free0_ (arg_arg), NULL));
#line 95 "src/main.vala"
	(arg_type == NULL) ? NULL : (arg_type = (g_list_free (arg_type), NULL));
#line 95 "src/main.vala"
	_g_free0 (splash_str);
#line 95 "src/main.vala"
	longopts = (g_free (longopts), NULL);
#line 2325 "main.c"
}

int
main (int argc,
      char ** argv)
{
#line 95 "src/main.vala"
	return _vala_main (argv, argc);
#line 2334 "main.c"
}

