/* keycode.c generated by valac 0.50.1.44-10688, the Vala compiler
 * generated from keycode.vala, do not modify */

/* Key encoding and decoding functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KBD_NOKEY G_MAXINT
#define KBD_CTRL 01000
#define KBD_META 02000
#define KBD_CANCEL (KBD_CTRL | 'g')
#define KBD_TAB 00402
#define KBD_RET 00403
#define KBD_PGUP 00404
#define KBD_PGDN 00405
#define KBD_HOME 00406
#define KBD_END 00407
#define KBD_DEL 00410
#define KBD_BS 00411
#define KBD_INS 00412
#define KBD_LEFT 00413
#define KBD_RIGHT 00414
#define KBD_UP 00415
#define KBD_DOWN 00416
#define KBD_F1 00420
#define KBD_F2 00421
#define KBD_F3 00422
#define KBD_F4 00423
#define KBD_F5 00424
#define KBD_F6 00425
#define KBD_F7 00426
#define KBD_F8 00427
#define KBD_F9 00430
#define KBD_F10 00431
#define KBD_F11 00432
#define KBD_F12 00433
gchar* chordtodesc (gsize key);
guint strtokey (const gchar* buf,
                guint* len);
guint strtochord (const gchar* buf,
                  guint* len);
GeeList* keystrtovec (const gchar* key);
gchar* keyvectodesc (GeeList* keys);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const gchar* keyname[34] = {"\\BACKSPACE", "\\C-", "\\DELETE", "\\DOWN", "\\e", "\\END", "\\F1", "\\F10", "\\F11", "\\F12", "\\F2", "\\F3", "\\F4", "\\F5", "\\F6", "\\F7", "\\F8", "\\F9", "\\HOME", "\\INSERT", "\\LEFT", "\\M-", "\\NEXT", "\\PAGEDOWN", "\\PAGEUP", "\\PRIOR", "\\r", "\\RET", "\\RIGHT", "\\SPC", "\\t", "\\TAB", "\\UP", "\\\\"};
const gint keycode[34] = {KBD_BS, KBD_CTRL, KBD_DEL, KBD_DOWN, 033, KBD_END, KBD_F1, KBD_F10, KBD_F11, KBD_F12, KBD_F2, KBD_F3, KBD_F4, KBD_F5, KBD_F6, KBD_F7, KBD_F8, KBD_F9, KBD_HOME, KBD_INS, KBD_LEFT, KBD_META, KBD_PGDN, KBD_PGDN, KBD_PGUP, KBD_PGUP, KBD_RET, KBD_RET, KBD_RIGHT, (gint) ' ', KBD_TAB, KBD_TAB, KBD_UP, (gint) '\\'};

gchar*
chordtodesc (gsize key)
{
	gchar* a = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 61 "src/keycode.vala"
	_tmp0_ = g_strdup ("");
#line 61 "src/keycode.vala"
	a = _tmp0_;
#line 63 "src/keycode.vala"
	if ((key & KBD_CTRL) != ((gsize) 0)) {
#line 95 "keycode.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 64 "src/keycode.vala"
		_tmp1_ = a;
#line 64 "src/keycode.vala"
		_tmp2_ = g_strconcat (_tmp1_, "C-", NULL);
#line 64 "src/keycode.vala"
		_g_free0 (a);
#line 64 "src/keycode.vala"
		a = _tmp2_;
#line 106 "keycode.c"
	}
#line 65 "src/keycode.vala"
	if ((key & KBD_META) != ((gsize) 0)) {
#line 110 "keycode.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 66 "src/keycode.vala"
		_tmp3_ = a;
#line 66 "src/keycode.vala"
		_tmp4_ = g_strconcat (_tmp3_, "M-", NULL);
#line 66 "src/keycode.vala"
		_g_free0 (a);
#line 66 "src/keycode.vala"
		a = _tmp4_;
#line 121 "keycode.c"
	}
#line 67 "src/keycode.vala"
	key = key & (~(KBD_CTRL | KBD_META));
#line 69 "src/keycode.vala"
	switch (key) {
#line 69 "src/keycode.vala"
		case KBD_PGUP:
#line 129 "keycode.c"
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 71 "src/keycode.vala"
			_tmp5_ = a;
#line 71 "src/keycode.vala"
			_tmp6_ = g_strconcat (_tmp5_, "<prior>", NULL);
#line 71 "src/keycode.vala"
			_g_free0 (a);
#line 71 "src/keycode.vala"
			a = _tmp6_;
#line 72 "src/keycode.vala"
			break;
#line 143 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_PGDN:
#line 147 "keycode.c"
		{
			const gchar* _tmp7_;
			gchar* _tmp8_;
#line 74 "src/keycode.vala"
			_tmp7_ = a;
#line 74 "src/keycode.vala"
			_tmp8_ = g_strconcat (_tmp7_, "<next>", NULL);
#line 74 "src/keycode.vala"
			_g_free0 (a);
#line 74 "src/keycode.vala"
			a = _tmp8_;
#line 75 "src/keycode.vala"
			break;
#line 161 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_HOME:
#line 165 "keycode.c"
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
#line 77 "src/keycode.vala"
			_tmp9_ = a;
#line 77 "src/keycode.vala"
			_tmp10_ = g_strconcat (_tmp9_, "<home>", NULL);
#line 77 "src/keycode.vala"
			_g_free0 (a);
#line 77 "src/keycode.vala"
			a = _tmp10_;
#line 78 "src/keycode.vala"
			break;
#line 179 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_END:
#line 183 "keycode.c"
		{
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 80 "src/keycode.vala"
			_tmp11_ = a;
#line 80 "src/keycode.vala"
			_tmp12_ = g_strconcat (_tmp11_, "<end>", NULL);
#line 80 "src/keycode.vala"
			_g_free0 (a);
#line 80 "src/keycode.vala"
			a = _tmp12_;
#line 81 "src/keycode.vala"
			break;
#line 197 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_DEL:
#line 201 "keycode.c"
		{
			const gchar* _tmp13_;
			gchar* _tmp14_;
#line 83 "src/keycode.vala"
			_tmp13_ = a;
#line 83 "src/keycode.vala"
			_tmp14_ = g_strconcat (_tmp13_, "<delete>", NULL);
#line 83 "src/keycode.vala"
			_g_free0 (a);
#line 83 "src/keycode.vala"
			a = _tmp14_;
#line 84 "src/keycode.vala"
			break;
#line 215 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_BS:
#line 219 "keycode.c"
		{
			const gchar* _tmp15_;
			gchar* _tmp16_;
#line 86 "src/keycode.vala"
			_tmp15_ = a;
#line 86 "src/keycode.vala"
			_tmp16_ = g_strconcat (_tmp15_, "<backspace>", NULL);
#line 86 "src/keycode.vala"
			_g_free0 (a);
#line 86 "src/keycode.vala"
			a = _tmp16_;
#line 87 "src/keycode.vala"
			break;
#line 233 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_INS:
#line 237 "keycode.c"
		{
			const gchar* _tmp17_;
			gchar* _tmp18_;
#line 89 "src/keycode.vala"
			_tmp17_ = a;
#line 89 "src/keycode.vala"
			_tmp18_ = g_strconcat (_tmp17_, "<insert>", NULL);
#line 89 "src/keycode.vala"
			_g_free0 (a);
#line 89 "src/keycode.vala"
			a = _tmp18_;
#line 90 "src/keycode.vala"
			break;
#line 251 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_LEFT:
#line 255 "keycode.c"
		{
			const gchar* _tmp19_;
			gchar* _tmp20_;
#line 92 "src/keycode.vala"
			_tmp19_ = a;
#line 92 "src/keycode.vala"
			_tmp20_ = g_strconcat (_tmp19_, "<left>", NULL);
#line 92 "src/keycode.vala"
			_g_free0 (a);
#line 92 "src/keycode.vala"
			a = _tmp20_;
#line 93 "src/keycode.vala"
			break;
#line 269 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_RIGHT:
#line 273 "keycode.c"
		{
			const gchar* _tmp21_;
			gchar* _tmp22_;
#line 95 "src/keycode.vala"
			_tmp21_ = a;
#line 95 "src/keycode.vala"
			_tmp22_ = g_strconcat (_tmp21_, "<right>", NULL);
#line 95 "src/keycode.vala"
			_g_free0 (a);
#line 95 "src/keycode.vala"
			a = _tmp22_;
#line 96 "src/keycode.vala"
			break;
#line 287 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_UP:
#line 291 "keycode.c"
		{
			const gchar* _tmp23_;
			gchar* _tmp24_;
#line 98 "src/keycode.vala"
			_tmp23_ = a;
#line 98 "src/keycode.vala"
			_tmp24_ = g_strconcat (_tmp23_, "<up>", NULL);
#line 98 "src/keycode.vala"
			_g_free0 (a);
#line 98 "src/keycode.vala"
			a = _tmp24_;
#line 99 "src/keycode.vala"
			break;
#line 305 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_DOWN:
#line 309 "keycode.c"
		{
			const gchar* _tmp25_;
			gchar* _tmp26_;
#line 101 "src/keycode.vala"
			_tmp25_ = a;
#line 101 "src/keycode.vala"
			_tmp26_ = g_strconcat (_tmp25_, "<down>", NULL);
#line 101 "src/keycode.vala"
			_g_free0 (a);
#line 101 "src/keycode.vala"
			a = _tmp26_;
#line 102 "src/keycode.vala"
			break;
#line 323 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_RET:
#line 327 "keycode.c"
		{
			const gchar* _tmp27_;
			gchar* _tmp28_;
#line 104 "src/keycode.vala"
			_tmp27_ = a;
#line 104 "src/keycode.vala"
			_tmp28_ = g_strconcat (_tmp27_, "<RET>", NULL);
#line 104 "src/keycode.vala"
			_g_free0 (a);
#line 104 "src/keycode.vala"
			a = _tmp28_;
#line 105 "src/keycode.vala"
			break;
#line 341 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_TAB:
#line 345 "keycode.c"
		{
			const gchar* _tmp29_;
			gchar* _tmp30_;
#line 107 "src/keycode.vala"
			_tmp29_ = a;
#line 107 "src/keycode.vala"
			_tmp30_ = g_strconcat (_tmp29_, "<TAB>", NULL);
#line 107 "src/keycode.vala"
			_g_free0 (a);
#line 107 "src/keycode.vala"
			a = _tmp30_;
#line 108 "src/keycode.vala"
			break;
#line 359 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F1:
#line 363 "keycode.c"
		{
			const gchar* _tmp31_;
			gchar* _tmp32_;
#line 110 "src/keycode.vala"
			_tmp31_ = a;
#line 110 "src/keycode.vala"
			_tmp32_ = g_strconcat (_tmp31_, "<f1>", NULL);
#line 110 "src/keycode.vala"
			_g_free0 (a);
#line 110 "src/keycode.vala"
			a = _tmp32_;
#line 111 "src/keycode.vala"
			break;
#line 377 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F2:
#line 381 "keycode.c"
		{
			const gchar* _tmp33_;
			gchar* _tmp34_;
#line 113 "src/keycode.vala"
			_tmp33_ = a;
#line 113 "src/keycode.vala"
			_tmp34_ = g_strconcat (_tmp33_, "<f2>", NULL);
#line 113 "src/keycode.vala"
			_g_free0 (a);
#line 113 "src/keycode.vala"
			a = _tmp34_;
#line 114 "src/keycode.vala"
			break;
#line 395 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F3:
#line 399 "keycode.c"
		{
			const gchar* _tmp35_;
			gchar* _tmp36_;
#line 116 "src/keycode.vala"
			_tmp35_ = a;
#line 116 "src/keycode.vala"
			_tmp36_ = g_strconcat (_tmp35_, "<f3>", NULL);
#line 116 "src/keycode.vala"
			_g_free0 (a);
#line 116 "src/keycode.vala"
			a = _tmp36_;
#line 117 "src/keycode.vala"
			break;
#line 413 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F4:
#line 417 "keycode.c"
		{
			const gchar* _tmp37_;
			gchar* _tmp38_;
#line 119 "src/keycode.vala"
			_tmp37_ = a;
#line 119 "src/keycode.vala"
			_tmp38_ = g_strconcat (_tmp37_, "<f4>", NULL);
#line 119 "src/keycode.vala"
			_g_free0 (a);
#line 119 "src/keycode.vala"
			a = _tmp38_;
#line 120 "src/keycode.vala"
			break;
#line 431 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F5:
#line 435 "keycode.c"
		{
			const gchar* _tmp39_;
			gchar* _tmp40_;
#line 122 "src/keycode.vala"
			_tmp39_ = a;
#line 122 "src/keycode.vala"
			_tmp40_ = g_strconcat (_tmp39_, "<f5>", NULL);
#line 122 "src/keycode.vala"
			_g_free0 (a);
#line 122 "src/keycode.vala"
			a = _tmp40_;
#line 123 "src/keycode.vala"
			break;
#line 449 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F6:
#line 453 "keycode.c"
		{
			const gchar* _tmp41_;
			gchar* _tmp42_;
#line 125 "src/keycode.vala"
			_tmp41_ = a;
#line 125 "src/keycode.vala"
			_tmp42_ = g_strconcat (_tmp41_, "<f6>", NULL);
#line 125 "src/keycode.vala"
			_g_free0 (a);
#line 125 "src/keycode.vala"
			a = _tmp42_;
#line 126 "src/keycode.vala"
			break;
#line 467 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F7:
#line 471 "keycode.c"
		{
			const gchar* _tmp43_;
			gchar* _tmp44_;
#line 128 "src/keycode.vala"
			_tmp43_ = a;
#line 128 "src/keycode.vala"
			_tmp44_ = g_strconcat (_tmp43_, "<f7>", NULL);
#line 128 "src/keycode.vala"
			_g_free0 (a);
#line 128 "src/keycode.vala"
			a = _tmp44_;
#line 129 "src/keycode.vala"
			break;
#line 485 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F8:
#line 489 "keycode.c"
		{
			const gchar* _tmp45_;
			gchar* _tmp46_;
#line 131 "src/keycode.vala"
			_tmp45_ = a;
#line 131 "src/keycode.vala"
			_tmp46_ = g_strconcat (_tmp45_, "<f8>", NULL);
#line 131 "src/keycode.vala"
			_g_free0 (a);
#line 131 "src/keycode.vala"
			a = _tmp46_;
#line 132 "src/keycode.vala"
			break;
#line 503 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F9:
#line 507 "keycode.c"
		{
			const gchar* _tmp47_;
			gchar* _tmp48_;
#line 134 "src/keycode.vala"
			_tmp47_ = a;
#line 134 "src/keycode.vala"
			_tmp48_ = g_strconcat (_tmp47_, "<f9>", NULL);
#line 134 "src/keycode.vala"
			_g_free0 (a);
#line 134 "src/keycode.vala"
			a = _tmp48_;
#line 135 "src/keycode.vala"
			break;
#line 521 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F10:
#line 525 "keycode.c"
		{
			const gchar* _tmp49_;
			gchar* _tmp50_;
#line 137 "src/keycode.vala"
			_tmp49_ = a;
#line 137 "src/keycode.vala"
			_tmp50_ = g_strconcat (_tmp49_, "<f10>", NULL);
#line 137 "src/keycode.vala"
			_g_free0 (a);
#line 137 "src/keycode.vala"
			a = _tmp50_;
#line 138 "src/keycode.vala"
			break;
#line 539 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F11:
#line 543 "keycode.c"
		{
			const gchar* _tmp51_;
			gchar* _tmp52_;
#line 140 "src/keycode.vala"
			_tmp51_ = a;
#line 140 "src/keycode.vala"
			_tmp52_ = g_strconcat (_tmp51_, "<f11>", NULL);
#line 140 "src/keycode.vala"
			_g_free0 (a);
#line 140 "src/keycode.vala"
			a = _tmp52_;
#line 141 "src/keycode.vala"
			break;
#line 557 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case KBD_F12:
#line 561 "keycode.c"
		{
			const gchar* _tmp53_;
			gchar* _tmp54_;
#line 143 "src/keycode.vala"
			_tmp53_ = a;
#line 143 "src/keycode.vala"
			_tmp54_ = g_strconcat (_tmp53_, "<f12>", NULL);
#line 143 "src/keycode.vala"
			_g_free0 (a);
#line 143 "src/keycode.vala"
			a = _tmp54_;
#line 144 "src/keycode.vala"
			break;
#line 575 "keycode.c"
		}
#line 69 "src/keycode.vala"
		case ' ':
#line 579 "keycode.c"
		{
			const gchar* _tmp55_;
			gchar* _tmp56_;
#line 146 "src/keycode.vala"
			_tmp55_ = a;
#line 146 "src/keycode.vala"
			_tmp56_ = g_strconcat (_tmp55_, "SPC", NULL);
#line 146 "src/keycode.vala"
			_g_free0 (a);
#line 146 "src/keycode.vala"
			a = _tmp56_;
#line 147 "src/keycode.vala"
			break;
#line 593 "keycode.c"
		}
		default:
		{
			gboolean _tmp57_ = FALSE;
#line 149 "src/keycode.vala"
			if (key <= ((gsize) 0xff)) {
#line 149 "src/keycode.vala"
				_tmp57_ = g_ascii_isgraph ((gchar) key);
#line 602 "keycode.c"
			} else {
#line 149 "src/keycode.vala"
				_tmp57_ = FALSE;
#line 606 "keycode.c"
			}
#line 149 "src/keycode.vala"
			if (_tmp57_) {
#line 610 "keycode.c"
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
#line 150 "src/keycode.vala"
				_tmp58_ = a;
#line 150 "src/keycode.vala"
				_tmp59_ = g_strdup_printf ("%c", (gchar) key);
#line 150 "src/keycode.vala"
				_tmp60_ = _tmp59_;
#line 150 "src/keycode.vala"
				_tmp61_ = g_strconcat (_tmp58_, _tmp60_, NULL);
#line 150 "src/keycode.vala"
				_g_free0 (a);
#line 150 "src/keycode.vala"
				a = _tmp61_;
#line 150 "src/keycode.vala"
				_g_free0 (_tmp60_);
#line 629 "keycode.c"
			} else {
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
#line 152 "src/keycode.vala"
				_tmp62_ = a;
#line 152 "src/keycode.vala"
				_tmp63_ = g_strdup_printf ("<%zx>", key);
#line 152 "src/keycode.vala"
				_tmp64_ = _tmp63_;
#line 152 "src/keycode.vala"
				_tmp65_ = g_strconcat (_tmp62_, _tmp64_, NULL);
#line 152 "src/keycode.vala"
				_g_free0 (a);
#line 152 "src/keycode.vala"
				a = _tmp65_;
#line 152 "src/keycode.vala"
				_g_free0 (_tmp64_);
#line 649 "keycode.c"
			}
#line 153 "src/keycode.vala"
			break;
#line 653 "keycode.c"
		}
	}
#line 156 "src/keycode.vala"
	result = a;
#line 156 "src/keycode.vala"
	return result;
#line 660 "keycode.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 677 "keycode.c"
}

guint
strtokey (const gchar* buf,
          guint* len)
{
	guint _vala_len = 0U;
	guint result = 0U;
#line 242 "src/keycode.vala"
	g_return_val_if_fail (buf != NULL, 0U);
#line 243 "src/keycode.vala"
	if (string_get (buf, (glong) 0) == '\\') {
#line 690 "keycode.c"
		{
			guint i = 0U;
#line 244 "src/keycode.vala"
			i = (guint) 0;
#line 695 "keycode.c"
			{
				gboolean _tmp0_ = FALSE;
#line 244 "src/keycode.vala"
				_tmp0_ = TRUE;
#line 244 "src/keycode.vala"
				while (TRUE) {
#line 702 "keycode.c"
					const gchar* _tmp2_;
#line 244 "src/keycode.vala"
					if (!_tmp0_) {
#line 706 "keycode.c"
						guint _tmp1_;
#line 244 "src/keycode.vala"
						_tmp1_ = i;
#line 244 "src/keycode.vala"
						i = _tmp1_ + 1;
#line 712 "keycode.c"
					}
#line 244 "src/keycode.vala"
					_tmp0_ = FALSE;
#line 244 "src/keycode.vala"
					if (!(i < ((guint) G_N_ELEMENTS (keyname)))) {
#line 244 "src/keycode.vala"
						break;
#line 720 "keycode.c"
					}
#line 245 "src/keycode.vala"
					_tmp2_ = keyname[i];
#line 245 "src/keycode.vala"
					if (g_str_has_prefix (buf, _tmp2_)) {
#line 726 "keycode.c"
						const gchar* _tmp3_;
						gint _tmp4_;
						gint _tmp5_;
						gint _tmp6_;
#line 246 "src/keycode.vala"
						_tmp3_ = keyname[i];
#line 246 "src/keycode.vala"
						_tmp4_ = strlen (_tmp3_);
#line 246 "src/keycode.vala"
						_tmp5_ = _tmp4_;
#line 246 "src/keycode.vala"
						_vala_len = (guint) _tmp5_;
#line 247 "src/keycode.vala"
						_tmp6_ = keycode[i];
#line 247 "src/keycode.vala"
						result = (guint) _tmp6_;
#line 247 "src/keycode.vala"
						if (len) {
#line 247 "src/keycode.vala"
							*len = _vala_len;
#line 747 "keycode.c"
						}
#line 247 "src/keycode.vala"
						return result;
#line 751 "keycode.c"
					}
				}
			}
		}
#line 249 "src/keycode.vala"
		_vala_len = (guint) 0;
#line 250 "src/keycode.vala"
		result = (guint) KBD_NOKEY;
#line 250 "src/keycode.vala"
		if (len) {
#line 250 "src/keycode.vala"
			*len = _vala_len;
#line 764 "keycode.c"
		}
#line 250 "src/keycode.vala"
		return result;
#line 768 "keycode.c"
	} else {
#line 252 "src/keycode.vala"
		_vala_len = (guint) 1;
#line 253 "src/keycode.vala"
		result = (guint) string_get (buf, (glong) 0);
#line 253 "src/keycode.vala"
		if (len) {
#line 253 "src/keycode.vala"
			*len = _vala_len;
#line 778 "keycode.c"
		}
#line 253 "src/keycode.vala"
		return result;
#line 782 "keycode.c"
	}
#line 242 "src/keycode.vala"
	if (len) {
#line 242 "src/keycode.vala"
		*len = _vala_len;
#line 788 "keycode.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 812 "keycode.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 821 "keycode.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 840 "keycode.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 844 "keycode.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 850 "keycode.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 860 "keycode.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 868 "keycode.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 872 "keycode.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 878 "keycode.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 888 "keycode.c"
}

guint
strtochord (const gchar* buf,
            guint* len)
{
	guint _vala_len = 0U;
	guint key = 0U;
	guint k = 0U;
	guint result = 0U;
#line 260 "src/keycode.vala"
	g_return_val_if_fail (buf != NULL, 0U);
#line 261 "src/keycode.vala"
	key = (guint) 0;
#line 261 "src/keycode.vala"
	k = (guint) 0;
#line 263 "src/keycode.vala"
	_vala_len = (guint) 0;
#line 907 "keycode.c"
	{
		gboolean _tmp0_ = FALSE;
#line 264 "src/keycode.vala"
		_tmp0_ = TRUE;
#line 264 "src/keycode.vala"
		while (TRUE) {
#line 914 "keycode.c"
			guint l = 0U;
			gchar* _tmp2_;
			gchar* _tmp3_;
			guint _tmp4_ = 0U;
			guint _tmp5_;
#line 264 "src/keycode.vala"
			if (!_tmp0_) {
#line 922 "keycode.c"
				gboolean _tmp1_ = FALSE;
#line 274 "src/keycode.vala"
				if (k == ((guint) KBD_CTRL)) {
#line 274 "src/keycode.vala"
					_tmp1_ = TRUE;
#line 928 "keycode.c"
				} else {
#line 274 "src/keycode.vala"
					_tmp1_ = k == ((guint) KBD_META);
#line 932 "keycode.c"
				}
#line 274 "src/keycode.vala"
				if (!_tmp1_) {
#line 274 "src/keycode.vala"
					break;
#line 938 "keycode.c"
				}
			}
#line 264 "src/keycode.vala"
			_tmp0_ = FALSE;
#line 267 "src/keycode.vala"
			_tmp2_ = string_substring (buf, (glong) _vala_len, (glong) -1);
#line 267 "src/keycode.vala"
			_tmp3_ = _tmp2_;
#line 267 "src/keycode.vala"
			_tmp5_ = strtokey (_tmp3_, &_tmp4_);
#line 267 "src/keycode.vala"
			l = _tmp4_;
#line 267 "src/keycode.vala"
			k = _tmp5_;
#line 267 "src/keycode.vala"
			_g_free0 (_tmp3_);
#line 268 "src/keycode.vala"
			if (k == ((guint) KBD_NOKEY)) {
#line 269 "src/keycode.vala"
				_vala_len = (guint) 0;
#line 270 "src/keycode.vala"
				result = (guint) KBD_NOKEY;
#line 270 "src/keycode.vala"
				if (len) {
#line 270 "src/keycode.vala"
					*len = _vala_len;
#line 965 "keycode.c"
				}
#line 270 "src/keycode.vala"
				return result;
#line 969 "keycode.c"
			}
#line 272 "src/keycode.vala"
			_vala_len = _vala_len + l;
#line 273 "src/keycode.vala"
			key |= k;
#line 975 "keycode.c"
		}
	}
#line 276 "src/keycode.vala"
	result = key;
#line 276 "src/keycode.vala"
	if (len) {
#line 276 "src/keycode.vala"
		*len = _vala_len;
#line 984 "keycode.c"
	}
#line 276 "src/keycode.vala"
	return result;
#line 988 "keycode.c"
}

GeeList*
keystrtovec (const gchar* key)
{
	GeeArrayList* keys = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result = NULL;
#line 283 "src/keycode.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 285 "src/keycode.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 285 "src/keycode.vala"
	keys = _tmp0_;
#line 1003 "keycode.c"
	{
		guint i = 0U;
		guint len = 0U;
#line 286 "src/keycode.vala"
		i = (guint) 0;
#line 286 "src/keycode.vala"
		len = (guint) 0;
#line 1011 "keycode.c"
		{
			gboolean _tmp1_ = FALSE;
#line 286 "src/keycode.vala"
			_tmp1_ = TRUE;
#line 286 "src/keycode.vala"
			while (TRUE) {
#line 1018 "keycode.c"
				gint _tmp2_;
				gint _tmp3_;
				guint code = 0U;
				gchar* _tmp4_;
				gchar* _tmp5_;
				guint _tmp6_ = 0U;
				guint _tmp7_;
				guint _tmp8_;
				GeeArrayList* _tmp9_;
#line 286 "src/keycode.vala"
				if (!_tmp1_) {
#line 286 "src/keycode.vala"
					i += len;
#line 1032 "keycode.c"
				}
#line 286 "src/keycode.vala"
				_tmp1_ = FALSE;
#line 286 "src/keycode.vala"
				_tmp2_ = strlen (key);
#line 286 "src/keycode.vala"
				_tmp3_ = _tmp2_;
#line 286 "src/keycode.vala"
				if (!(i < ((guint) _tmp3_))) {
#line 286 "src/keycode.vala"
					break;
#line 1044 "keycode.c"
				}
#line 287 "src/keycode.vala"
				_tmp4_ = string_substring (key, (glong) i, (glong) -1);
#line 287 "src/keycode.vala"
				_tmp5_ = _tmp4_;
#line 287 "src/keycode.vala"
				_tmp7_ = strtochord (_tmp5_, &_tmp6_);
#line 287 "src/keycode.vala"
				len = _tmp6_;
#line 287 "src/keycode.vala"
				_tmp8_ = _tmp7_;
#line 287 "src/keycode.vala"
				_g_free0 (_tmp5_);
#line 287 "src/keycode.vala"
				code = _tmp8_;
#line 288 "src/keycode.vala"
				if (code == ((guint) KBD_NOKEY)) {
#line 289 "src/keycode.vala"
					result = NULL;
#line 289 "src/keycode.vala"
					_g_object_unref0 (keys);
#line 289 "src/keycode.vala"
					return result;
#line 1068 "keycode.c"
				}
#line 290 "src/keycode.vala"
				_tmp9_ = keys;
#line 290 "src/keycode.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((guintptr) code));
#line 1074 "keycode.c"
			}
		}
	}
#line 293 "src/keycode.vala"
	result = (GeeList*) keys;
#line 293 "src/keycode.vala"
	return result;
#line 1082 "keycode.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 302 "src/keycode.vala"
	if ((*length) == (*size)) {
#line 302 "src/keycode.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 302 "src/keycode.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1097 "keycode.c"
	}
#line 302 "src/keycode.vala"
	(*array)[(*length)++] = value;
#line 302 "src/keycode.vala"
	(*array)[*length] = NULL;
#line 1103 "keycode.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 1117 "keycode.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 1121 "keycode.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 1127 "keycode.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 1132 "keycode.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 1138 "keycode.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 1142 "keycode.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1146 "keycode.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1150 "keycode.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1154 "keycode.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1158 "keycode.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1172 "keycode.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 1181 "keycode.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1188 "keycode.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1194 "keycode.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1202 "keycode.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1206 "keycode.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1212 "keycode.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1217 "keycode.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1223 "keycode.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1227 "keycode.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1231 "keycode.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 1237 "keycode.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1243 "keycode.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1255 "keycode.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1259 "keycode.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1263 "keycode.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 1268 "keycode.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 1276 "keycode.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 1298 "keycode.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 1307 "keycode.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 1316 "keycode.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 1322 "keycode.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 1330 "keycode.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 1342 "keycode.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 1348 "keycode.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 1352 "keycode.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 1360 "keycode.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 1371 "keycode.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 1380 "keycode.c"
	}
}

gchar*
keyvectodesc (GeeList* keys)
{
	gchar** key_strings = NULL;
	gchar** _tmp0_;
	gint key_strings_length1;
	gint _key_strings_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar* result = NULL;
#line 299 "src/keycode.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 300 "src/keycode.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 300 "src/keycode.vala"
	key_strings = _tmp0_;
#line 300 "src/keycode.vala"
	key_strings_length1 = 0;
#line 300 "src/keycode.vala"
	_key_strings_size_ = key_strings_length1;
#line 1405 "keycode.c"
	{
		GeeList* _keycode_list = NULL;
		gint _keycode_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _keycode_index = 0;
#line 301 "src/keycode.vala"
		_keycode_list = keys;
#line 301 "src/keycode.vala"
		_tmp1_ = _keycode_list;
#line 301 "src/keycode.vala"
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 301 "src/keycode.vala"
		_tmp3_ = _tmp2_;
#line 301 "src/keycode.vala"
		_keycode_size = _tmp3_;
#line 301 "src/keycode.vala"
		_keycode_index = -1;
#line 301 "src/keycode.vala"
		while (TRUE) {
#line 1427 "keycode.c"
			gint _tmp4_;
			gint _tmp5_;
			guint keycode = 0U;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gchar* _tmp8_;
#line 301 "src/keycode.vala"
			_keycode_index = _keycode_index + 1;
#line 301 "src/keycode.vala"
			_tmp4_ = _keycode_index;
#line 301 "src/keycode.vala"
			_tmp5_ = _keycode_size;
#line 301 "src/keycode.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 301 "src/keycode.vala"
				break;
#line 1444 "keycode.c"
			}
#line 301 "src/keycode.vala"
			_tmp6_ = _keycode_list;
#line 301 "src/keycode.vala"
			_tmp7_ = gee_list_get (_tmp6_, _keycode_index);
#line 301 "src/keycode.vala"
			keycode = (guint) ((guintptr) _tmp7_);
#line 302 "src/keycode.vala"
			_tmp8_ = chordtodesc ((gsize) keycode);
#line 302 "src/keycode.vala"
			_vala_array_add1 (&key_strings, &key_strings_length1, &_key_strings_size_, _tmp8_);
#line 1456 "keycode.c"
		}
	}
#line 303 "src/keycode.vala"
	_tmp9_ = key_strings;
#line 303 "src/keycode.vala"
	_tmp9__length1 = key_strings_length1;
#line 303 "src/keycode.vala"
	_tmp10_ = _vala_g_strjoinv (" ", _tmp9_, (gint) _tmp9__length1);
#line 303 "src/keycode.vala"
	result = _tmp10_;
#line 303 "src/keycode.vala"
	key_strings = (_vala_array_free (key_strings, key_strings_length1, (GDestroyNotify) g_free), NULL);
#line 303 "src/keycode.vala"
	return result;
#line 1471 "keycode.c"
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

