/** @file shisa_cmd.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef SHISA_CMD_H
#define SHISA_CMD_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name */
#define CMDLINE_PARSER_PACKAGE "shisa"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  const char *add_help; /**< @brief Add realm or principal to database. help description.  */
  const char *dump_help; /**< @brief Dump entries in database. help description.  */
  const char *key_add_help; /**< @brief Add new key to a principal in database. help description.  */
  const char *key_remove_help; /**< @brief Remove a key from a principal in database. help description.  */
  const char *list_help; /**< @brief List entries in database. help description.  */
  const char *modify_help; /**< @brief Modify principal entry in database. help description.  */
  const char *remove_help; /**< @brief Remove realm or principal from database. help description.  */
  int force_flag;	/**< @brief Allow removal of non-empty realms.\n (default=off).  */
  const char *force_help; /**< @brief Allow removal of non-empty realms.\n help description.  */
  int enabled_flag;	/**< @brief Only dump or list enabled principals.\n (default=off).  */
  const char *enabled_help; /**< @brief Only dump or list enabled principals.\n help description.  */
  int disabled_flag;	/**< @brief Only dump or list disabled principals.\n (default=off).  */
  const char *disabled_help; /**< @brief Only dump or list disabled principals.\n help description.  */
  int keys_flag;	/**< @brief Print cryptographic key and password in hostkey format. (default=off).  */
  const char *keys_help; /**< @brief Print cryptographic key and password in hostkey format. help description.  */
  char * encryption_type_arg;	/**< @brief Override default key encryption type.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
  char * encryption_type_orig;	/**< @brief Override default key encryption type.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'. original value given at command line.  */
  const char *encryption_type_help; /**< @brief Override default key encryption type.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'. help description.  */
  long key_version_arg;	/**< @brief Version of key..  */
  char * key_version_orig;	/**< @brief Version of key. original value given at command line.  */
  const char *key_version_help; /**< @brief Version of key. help description.  */
  char * password_arg;	/**< @brief Derive key from this password..  */
  char * password_orig;	/**< @brief Derive key from this password. original value given at command line.  */
  const char *password_help; /**< @brief Derive key from this password. help description.  */
  long priority_arg;	/**< @brief Specify key priority, used to differentiate between keys when multiple keys are eligible for use.  Higher value means higher priority.  (default is 0, which mean a random key of the best etype is chosen).  */
  char * priority_orig;	/**< @brief Specify key priority, used to differentiate between keys when multiple keys are eligible for use.  Higher value means higher priority.  (default is 0, which mean a random key of the best etype is chosen) original value given at command line.  */
  const char *priority_help; /**< @brief Specify key priority, used to differentiate between keys when multiple keys are eligible for use.  Higher value means higher priority.  (default is 0, which mean a random key of the best etype is chosen) help description.  */
  const char *random_help; /**< @brief Use a random key.  (default) help description.  */
  char * salt_arg;	/**< @brief Use specified salt for deriving key.  Defaults to concatenation of realm and (unwrapped) principal name..  */
  char * salt_orig;	/**< @brief Use specified salt for deriving key.  Defaults to concatenation of realm and (unwrapped) principal name. original value given at command line.  */
  const char *salt_help; /**< @brief Use specified salt for deriving key.  Defaults to concatenation of realm and (unwrapped) principal name. help description.  */
  char * string_to_key_parameter_arg;	/**< @brief Encryption algorithm specific parameter for password derivation.  Currently only the AES algorithm can utilize this, where it is interpreted as the iteration count of the PKCS#5 PBKDF2 key deriver..  */
  char * string_to_key_parameter_orig;	/**< @brief Encryption algorithm specific parameter for password derivation.  Currently only the AES algorithm can utilize this, where it is interpreted as the iteration count of the PKCS#5 PBKDF2 key deriver. original value given at command line.  */
  const char *string_to_key_parameter_help; /**< @brief Encryption algorithm specific parameter for password derivation.  Currently only the AES algorithm can utilize this, where it is interpreted as the iteration count of the PKCS#5 PBKDF2 key deriver. help description.  */
  char * configuration_file_arg;	/**< @brief Use specified configuration file..  */
  char * configuration_file_orig;	/**< @brief Use specified configuration file. original value given at command line.  */
  const char *configuration_file_help; /**< @brief Use specified configuration file. help description.  */
  char * library_options_arg;	/**< @brief Parse string as configuration file statement..  */
  char * library_options_orig;	/**< @brief Parse string as configuration file statement. original value given at command line.  */
  const char *library_options_help; /**< @brief Parse string as configuration file statement. help description.  */
  int verbose_flag;	/**< @brief Produce verbose output.\n (default=off).  */
  const char *verbose_help; /**< @brief Produce verbose output.\n help description.  */
  int quiet_flag;	/**< @brief Don't produce any diagnostic output.\n (default=off).  */
  const char *quiet_help; /**< @brief Don't produce any diagnostic output.\n help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int add_given ;	/**< @brief Whether add was given.  */
  unsigned int dump_given ;	/**< @brief Whether dump was given.  */
  unsigned int key_add_given ;	/**< @brief Whether key-add was given.  */
  unsigned int key_remove_given ;	/**< @brief Whether key-remove was given.  */
  unsigned int list_given ;	/**< @brief Whether list was given.  */
  unsigned int modify_given ;	/**< @brief Whether modify was given.  */
  unsigned int remove_given ;	/**< @brief Whether remove was given.  */
  unsigned int force_given ;	/**< @brief Whether force was given.  */
  unsigned int enabled_given ;	/**< @brief Whether enabled was given.  */
  unsigned int disabled_given ;	/**< @brief Whether disabled was given.  */
  unsigned int keys_given ;	/**< @brief Whether keys was given.  */
  unsigned int encryption_type_given ;	/**< @brief Whether encryption-type was given.  */
  unsigned int key_version_given ;	/**< @brief Whether key-version was given.  */
  unsigned int password_given ;	/**< @brief Whether password was given.  */
  unsigned int priority_given ;	/**< @brief Whether priority was given.  */
  unsigned int random_given ;	/**< @brief Whether random was given.  */
  unsigned int salt_given ;	/**< @brief Whether salt was given.  */
  unsigned int string_to_key_parameter_given ;	/**< @brief Whether string-to-key-parameter was given.  */
  unsigned int configuration_file_given ;	/**< @brief Whether configuration-file was given.  */
  unsigned int library_options_given ;	/**< @brief Whether library-options was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* SHISA_CMD_H */
