/*
  File autogenerated by gengetopt version 2.12rc
  generated with the following command:
  gengetopt --unamed-opts=CLIENT [SERVER] --no-handle-help --no-handle-error --input shishi.ggo --file-name shishi_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "shishi_cmd.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->destroy_given = 0 ;
  args_info->list_given = 0 ;
  args_info->renew_given = 0 ;
  args_info->forwardable_given = 0 ;
  args_info->forwarded_given = 0 ;
  args_info->proxiable_given = 0 ;
  args_info->proxy_given = 0 ;
  args_info->renewable_given = 0 ;
  args_info->client_name_given = 0 ;
  args_info->encryption_type_given = 0 ;
  args_info->endtime_given = 0 ;
  args_info->realm_given = 0 ;
  args_info->renew_till_given = 0 ;
  args_info->server_name_given = 0 ;
  args_info->starttime_given = 0 ;
  args_info->ticket_granter_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->ticket_file_given = 0 ;
  args_info->library_options_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->system_configuration_file_given = 0 ;
  args_info->ticket_write_file_given = 0 ;
  args_info->verbose_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->destroy_flag = 0;
  args_info->list_flag = 0;
  args_info->renew_flag = 0;
  args_info->forwardable_flag = 0;
  args_info->forwarded_flag = 0;
  args_info->proxiable_flag = 0;
  args_info->proxy_flag = 0;
  args_info->renewable_flag = 0;
  args_info->client_name_arg = NULL;
  args_info->encryption_type_arg = NULL;
  args_info->endtime_arg = NULL;
  args_info->realm_arg = NULL;
  args_info->renew_till_arg = NULL;
  args_info->server_name_arg = NULL;
  args_info->starttime_arg = NULL;
  args_info->ticket_granter_arg = NULL;
  args_info->configuration_file_arg = NULL;
  args_info->ticket_file_arg = NULL;
  args_info->library_options_arg = NULL;
  args_info->quiet_flag = 0;
  args_info->system_configuration_file_arg = NULL;
  args_info->ticket_write_file_arg = NULL;
  args_info->verbose_flag = 0;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Kerberos 5 client.  If no command is given, Shishi acquire or\n"
  "  list a valid ticket for you, identified by CLIENT (if empty, default\n"
  "  username in default realm), for the service SERVER (if empty, ticket\n"
  "  granting ticket for client realm).\n"
  "\n"
  "Usage: %s [OPTIONS]... [CLIENT [SERVER]]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("  -h, --help                              Print help and exit\n");
  printf("  -V, --version                           Print version and exit\n");
  printf("\nCommands:\n");
  printf("  -d, --destroy                           Destroy tickets in local cache, \n                                            limited by any --client-name or \n                                            --server-name.  (default=off)\n");
  printf("  -l, --list                              List tickets in local cache, limited \n                                            by any --client-name and \n                                            --server-name.  (default=off)\n");
  printf("  -r, --renew                             Renew ticket.  Use --server-name to \n                                            specify ticket, default is the \n                                            most recent renewable ticket \n                                            granting ticket for the default \n                                            realm.  (default=off)\n");
  printf("\nFlags:\n");
  printf("      --forwardable                       Get a forwardable ticket, i.e., one \n                                            that can be used to get forwarded \n                                            tickets.  (default=off)\n");
  printf("      --forwarded                         Get a forwarded ticket.  (default=\n                                            off)\n");
  printf("      --proxiable                         Get a proxiable ticket, i.e., one \n                                            that can be used to get proxy \n                                            tickets.  (default=off)\n");
  printf("      --proxy                             Get a proxy ticket.  (default=off)\n");
  printf("      --renewable                         Get a renewable ticket.  (default=\n                                            off)\n");
  printf("\nOptions:\n");
  printf("      --client-name=NAME                  Client name. Default is login \n                                            username.\n");
  printf("  -E, --encryption-type=ETYPE,[ETYPE...]  Encryption types to use.  ETYPE is \n                                            either registered name or integer. \n                                             Valid values include 'aes128', \n                                            'aes256', 'aes' (same as \n                                            'aes256'), '3des', 'des-md5', \n                                            'des-md4', 'des-crc', 'des' (same \n                                            as 'des-md5'), and 'arcfour'.\n");
  printf("  -e, --endtime=STRING                    Specify when ticket validity should \n                                            expire.  The time syntax may be \n                                            relative (to the start time), such \n                                            as '20 hours', or absolute, such \n                                            as '2001-02-03 04:05:06 CET'. The \n                                            default is 8 hours after the start \n                                            time.\n");
  printf("      --realm=STRING                      Set default realm.\n");
  printf("      --renew-till=STRING                 Specify renewable life of ticket.  \n                                            Implies --renewable.  Accepts same \n                                            time syntax as --endtime.  If \n                                            --renewable is specified, the \n                                            default is 1 week after the start \n                                            time.\n");
  printf("      --server-name=NAME                  Server name. Default is \n                                            'krbtgt/REALM' where REALM is \n                                            client realm.\n");
  printf("  -s, --starttime=STRING                  Specify when ticket should start to \n                                            be valid.  Accepts same time \n                                            syntax as --endtime. The default \n                                            is to become valid immediately.\n");
  printf("      --ticket-granter=NAME               Service name in ticket to use for \n                                            authenticating request. Only for \n                                            TGS. Defaults to \n                                            'krbtgt/REALM@REALM' where REALM \n                                            is client realm.\n");
  printf("\nOther options:\n");
  printf("      --configuration-file=FILE           Read user configuration from FILE.\n");
  printf("  -c, --ticket-file=FILE                  Read tickets from FILE.\n");
  printf("  -o, --library-options=STRING            Parse STRING as a configuration file \n                                            statement.\n");
  printf("  -q, --quiet                             Don't produce any diagnostic output.\n                                              (default=off)\n");
  printf("      --system-configuration-file=FILE    Read system configuration from FILE.\n");
  printf("      --ticket-write-file=FILE            Write tickets from FILE.  Default is \n                                            to write them back to where they \n                                            were read from.\n");
  printf("  -v, --verbose                           Produce verbose output.\n                                              (default=off)\n");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  int i;
  if (args_info->client_name_arg)
    {
      free (args_info->client_name_arg); /* free copied argument */
      args_info->client_name_arg = 0;
    }
  if (args_info->encryption_type_arg)
    {
      free (args_info->encryption_type_arg); /* free copied argument */
      args_info->encryption_type_arg = 0;
    }
  if (args_info->endtime_arg)
    {
      free (args_info->endtime_arg); /* free copied argument */
      args_info->endtime_arg = 0;
    }
  if (args_info->realm_arg)
    {
      free (args_info->realm_arg); /* free copied argument */
      args_info->realm_arg = 0;
    }
  if (args_info->renew_till_arg)
    {
      free (args_info->renew_till_arg); /* free copied argument */
      args_info->renew_till_arg = 0;
    }
  if (args_info->server_name_arg)
    {
      free (args_info->server_name_arg); /* free copied argument */
      args_info->server_name_arg = 0;
    }
  if (args_info->starttime_arg)
    {
      free (args_info->starttime_arg); /* free copied argument */
      args_info->starttime_arg = 0;
    }
  if (args_info->ticket_granter_arg)
    {
      free (args_info->ticket_granter_arg); /* free copied argument */
      args_info->ticket_granter_arg = 0;
    }
  if (args_info->configuration_file_arg)
    {
      free (args_info->configuration_file_arg); /* free copied argument */
      args_info->configuration_file_arg = 0;
    }
  if (args_info->ticket_file_arg)
    {
      free (args_info->ticket_file_arg); /* free copied argument */
      args_info->ticket_file_arg = 0;
    }
  if (args_info->library_options_arg)
    {
      free (args_info->library_options_arg); /* free copied argument */
      args_info->library_options_arg = 0;
    }
  if (args_info->system_configuration_file_arg)
    {
      free (args_info->system_configuration_file_arg); /* free copied argument */
      args_info->system_configuration_file_arg = 0;
    }
  if (args_info->ticket_write_file_arg)
    {
      free (args_info->ticket_write_file_arg); /* free copied argument */
      args_info->ticket_write_file_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  cmdline_parser_init (args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "destroy",	0, NULL, 'd' },
        { "list",	0, NULL, 'l' },
        { "renew",	0, NULL, 'r' },
        { "forwardable",	0, NULL, 0 },
        { "forwarded",	0, NULL, 0 },
        { "proxiable",	0, NULL, 0 },
        { "proxy",	0, NULL, 0 },
        { "renewable",	0, NULL, 0 },
        { "client-name",	1, NULL, 0 },
        { "encryption-type",	1, NULL, 'E' },
        { "endtime",	1, NULL, 'e' },
        { "realm",	1, NULL, 0 },
        { "renew-till",	1, NULL, 0 },
        { "server-name",	1, NULL, 0 },
        { "starttime",	1, NULL, 's' },
        { "ticket-granter",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 0 },
        { "ticket-file",	1, NULL, 'c' },
        { "library-options",	1, NULL, 'o' },
        { "quiet",	0, NULL, 'q' },
        { "system-configuration-file",	1, NULL, 0 },
        { "ticket-write-file",	1, NULL, 0 },
        { "verbose",	0, NULL, 'v' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVdlrE:e:s:c:o:qv", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'd':	/* Destroy tickets in local cache, limited by any --client-name or --server-name..  */
          if (args_info->destroy_given)
            {
              fprintf (stderr, "%s: `--destroy' (`-d') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->destroy_given = 1;
          args_info->destroy_flag = !(args_info->destroy_flag);
          break;

        case 'l':	/* List tickets in local cache, limited by any --client-name and --server-name..  */
          if (args_info->list_given)
            {
              fprintf (stderr, "%s: `--list' (`-l') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->list_given = 1;
          args_info->list_flag = !(args_info->list_flag);
          break;

        case 'r':	/* Renew ticket.  Use --server-name to specify ticket, default is the most recent renewable ticket granting ticket for the default realm..  */
          if (args_info->renew_given)
            {
              fprintf (stderr, "%s: `--renew' (`-r') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->renew_given = 1;
          args_info->renew_flag = !(args_info->renew_flag);
          break;

        case 'E':	/* Encryption types to use.  ETYPE is either registered name or integer.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
          if (args_info->encryption_type_given)
            {
              fprintf (stderr, "%s: `--encryption-type' (`-E') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->encryption_type_given = 1;
          args_info->encryption_type_arg = gengetopt_strdup (optarg);
          break;

        case 'e':	/* Specify when ticket validity should expire.  The time syntax may be relative (to the start time), such as '20 hours', or absolute, such as '2001-02-03 04:05:06 CET'. The default is 8 hours after the start time..  */
          if (args_info->endtime_given)
            {
              fprintf (stderr, "%s: `--endtime' (`-e') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->endtime_given = 1;
          args_info->endtime_arg = gengetopt_strdup (optarg);
          break;

        case 's':	/* Specify when ticket should start to be valid.  Accepts same time syntax as --endtime. The default is to become valid immediately..  */
          if (args_info->starttime_given)
            {
              fprintf (stderr, "%s: `--starttime' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->starttime_given = 1;
          args_info->starttime_arg = gengetopt_strdup (optarg);
          break;

        case 'c':	/* Read tickets from FILE..  */
          if (args_info->ticket_file_given)
            {
              fprintf (stderr, "%s: `--ticket-file' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->ticket_file_given = 1;
          args_info->ticket_file_arg = gengetopt_strdup (optarg);
          break;

        case 'o':	/* Parse STRING as a configuration file statement..  */
          if (args_info->library_options_given)
            {
              fprintf (stderr, "%s: `--library-options' (`-o') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->library_options_given = 1;
          args_info->library_options_arg = gengetopt_strdup (optarg);
          break;

        case 'q':	/* Don't produce any diagnostic output.\n.  */
          if (args_info->quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->quiet_given = 1;
          args_info->quiet_flag = !(args_info->quiet_flag);
          break;

        case 'v':	/* Produce verbose output.\n.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              return (EXIT_FAILURE);
            }
          args_info->verbose_given = 1;
          args_info->verbose_flag = !(args_info->verbose_flag);
          break;


        case 0:	/* Long option with no short option */
          /* Get a forwardable ticket, i.e., one that can be used to get forwarded tickets..  */
          if (strcmp (long_options[option_index].name, "forwardable") == 0)
          {
            if (args_info->forwardable_given)
              {
                fprintf (stderr, "%s: `--forwardable' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->forwardable_given = 1;
            args_info->forwardable_flag = !(args_info->forwardable_flag);
            break;
          }
          
          /* Get a forwarded ticket..  */
          else if (strcmp (long_options[option_index].name, "forwarded") == 0)
          {
            if (args_info->forwarded_given)
              {
                fprintf (stderr, "%s: `--forwarded' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->forwarded_given = 1;
            args_info->forwarded_flag = !(args_info->forwarded_flag);
            break;
          }
          
          /* Get a proxiable ticket, i.e., one that can be used to get proxy tickets..  */
          else if (strcmp (long_options[option_index].name, "proxiable") == 0)
          {
            if (args_info->proxiable_given)
              {
                fprintf (stderr, "%s: `--proxiable' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->proxiable_given = 1;
            args_info->proxiable_flag = !(args_info->proxiable_flag);
            break;
          }
          
          /* Get a proxy ticket..  */
          else if (strcmp (long_options[option_index].name, "proxy") == 0)
          {
            if (args_info->proxy_given)
              {
                fprintf (stderr, "%s: `--proxy' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->proxy_given = 1;
            args_info->proxy_flag = !(args_info->proxy_flag);
            break;
          }
          
          /* Get a renewable ticket..  */
          else if (strcmp (long_options[option_index].name, "renewable") == 0)
          {
            if (args_info->renewable_given)
              {
                fprintf (stderr, "%s: `--renewable' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->renewable_given = 1;
            args_info->renewable_flag = !(args_info->renewable_flag);
            break;
          }
          
          /* Client name. Default is login username..  */
          else if (strcmp (long_options[option_index].name, "client-name") == 0)
          {
            if (args_info->client_name_given)
              {
                fprintf (stderr, "%s: `--client-name' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->client_name_given = 1;
            args_info->client_name_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Set default realm..  */
          else if (strcmp (long_options[option_index].name, "realm") == 0)
          {
            if (args_info->realm_given)
              {
                fprintf (stderr, "%s: `--realm' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->realm_given = 1;
            args_info->realm_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Specify renewable life of ticket.  Implies --renewable.  Accepts same time syntax as --endtime.  If --renewable is specified, the default is 1 week after the start time..  */
          else if (strcmp (long_options[option_index].name, "renew-till") == 0)
          {
            if (args_info->renew_till_given)
              {
                fprintf (stderr, "%s: `--renew-till' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->renew_till_given = 1;
            args_info->renew_till_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Server name. Default is 'krbtgt/REALM' where REALM is client realm..  */
          else if (strcmp (long_options[option_index].name, "server-name") == 0)
          {
            if (args_info->server_name_given)
              {
                fprintf (stderr, "%s: `--server-name' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->server_name_given = 1;
            args_info->server_name_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Service name in ticket to use for authenticating request. Only for TGS. Defaults to 'krbtgt/REALM@REALM' where REALM is client realm..  */
          else if (strcmp (long_options[option_index].name, "ticket-granter") == 0)
          {
            if (args_info->ticket_granter_given)
              {
                fprintf (stderr, "%s: `--ticket-granter' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->ticket_granter_given = 1;
            args_info->ticket_granter_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Read user configuration from FILE..  */
          else if (strcmp (long_options[option_index].name, "configuration-file") == 0)
          {
            if (args_info->configuration_file_given)
              {
                fprintf (stderr, "%s: `--configuration-file' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->configuration_file_given = 1;
            args_info->configuration_file_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Read system configuration from FILE..  */
          else if (strcmp (long_options[option_index].name, "system-configuration-file") == 0)
          {
            if (args_info->system_configuration_file_given)
              {
                fprintf (stderr, "%s: `--system-configuration-file' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->system_configuration_file_given = 1;
            args_info->system_configuration_file_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Write tickets from FILE.  Default is to write them back to where they were read from..  */
          else if (strcmp (long_options[option_index].name, "ticket-write-file") == 0)
          {
            if (args_info->ticket_write_file_given)
              {
                fprintf (stderr, "%s: `--ticket-write-file' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                return (EXIT_FAILURE);
              }
            args_info->ticket_write_file_given = 1;
            args_info->ticket_write_file_arg = gengetopt_strdup (optarg);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          return (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;
}
