/* This code is machine-generated.  See its source for license
   information. This software is derived from software
   distributed under the GNU GPL version 3 or later. */

/* User-specified code, initial vm2 part: beginning. */
#line 163 "../../libpoke/pvm.jitter"
#line 163 "../../libpoke/pvm.jitter"

#   include <config.h>
  
/* User-specified code, initial vm2 part: end */

/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE pvm
#define JITTER_VM_PREFIX_UPPER_CASE PVM

//#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Early C code from the user. */
#line 169 "../../libpoke/pvm.jitter"
#line 169 "../../libpoke/pvm.jitter"

#   include <config.h>
#   include <stdlib.h>
#   include <string.h>
#   include <assert.h>
#   include "xalloc.h"
#   include "timespec.h"

#   include "pvm-alloc.h"
  /* End of the early C code from the user. */

#include <jitter/jitter.h>
#include <jitter/jitter-instruction.h>

#define JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H
#include <jitter/jitter-executor.h>

#ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-machine-common.h>
#include <jitter/machine/jitter-machine.h>
#endif // #ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-malloc.h>

#include "pvm-vm.h"
//#include "pvm-meta-instructions.h"
//#include "pvm-specialized-instructions.h"
//#include "pvm-state.h"

/* Include stack data structure support. */
#include <jitter/jitter-stack.h>

/* Include patch-in definitions, only if patch-in is enabled.  We knoe whether it is
   by checking JITTER_HAVE_PATCH_IN , defined in jitter/jitter-patch-in.h . */
#include <jitter/jitter-patch-in.h>
#ifdef JITTER_HAVE_PATCH_IN
# include <jitter/jitter-fast-branch.h>

  JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(pvm);
  JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(pvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

/* Always include fast-branch definitions, which use patch-ins where possible
   or consist in fallback definitions otherwise. */
#include <jitter/jitter-fast-branch.h>

#define JITTER_FAST_BRANCH_PREFIX pvm_

/* Most of the needed macros are in jitter-executor.h .  This however
   needs to be here, as it relies on a prefix to be substituted. */
#define JITTER_STATE_BACKING  \
  (jitter_original_state->pvm_state_backing)
/* Expand to an l-value evaluating to the pending_notification field for
   the current state. */
#define JITTER_PENDING_NOTIFICATIONS  \
  (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_notifications)
/* Expand to an l-value evaluating to the pending field of the struct
   jitter_signal_notification element for the given signal, for the
   current state. */
#define JITTER_PENDING_SIGNAL_NOTIFICATION(signal_id)  \
  ((PVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_signal_notifications + (signal_id))->pending)

/* Expand to the i-th fast register as an lvalue.  This is used internally,
   always with a literal index . */
#define JITTER_FAST_REGISTER(class, index)                             \
  (JITTER_CONCATENATE_FOUR(jitter_state_runtime.jitter_fast_register_, \
                           class, _, index))

/* Expand to a slow register lvalue, given an offset in bytes from the base. */
#define JITTER_SLOW_REGISTER_FROM_OFFSET(c, offset)               \
  (* ((JITTER_CONCATENATE_TWO(pvm_register_, c) * restrict)  \
      (((char *) jitter_array_base) + offset)))

/* Expand to the i-th register, which must be a slow register, as an lvalue.
   The given index must be a register index counting from 0 and including fast
   regusters as well, if there are any.  For example if an r class had 3 fast
   registers then the first slow register would be %r3, to be accessed as
   JITTER_SLOW_REGISTER(r, 3).  It would be invalid to access %r0, %r1 and
   %r2 which this macro, as %r0, %r1 and %r2 would be fast. */
#define JITTER_SLOW_REGISTER(c, i)                                          \
  JITTER_SLOW_REGISTER_FROM_OFFSET(c, PVM_SLOW_REGISTER_OFFSET(c, i))

/* It's not possible to have a single macro JITTER_REGISTER taking an index and
   expanding to either a fast or a slow register lvalue, due to CPP conditional
   limitations.  This restriction is unfortunate, but we have to live with it
   as long as we don't switch to a different preprocessor.
   What we can have is a set of zero-argument macros each expanding to a register
   lvalue, for *a limited number* of registers.  Here we define access macros for
   every fast register plus a reasonable number (currently 32) of slow registers,
   per class. */
#define JITTER_REGISTER_r_0    JITTER_SLOW_REGISTER(r, 0)
#define JITTER_REGISTER_r_1    JITTER_SLOW_REGISTER(r, 1)
#define JITTER_REGISTER_r_2    JITTER_SLOW_REGISTER(r, 2)
#define JITTER_REGISTER_r_3    JITTER_SLOW_REGISTER(r, 3)
#define JITTER_REGISTER_r_4    JITTER_SLOW_REGISTER(r, 4)
#define JITTER_REGISTER_r_5    JITTER_SLOW_REGISTER(r, 5)
#define JITTER_REGISTER_r_6    JITTER_SLOW_REGISTER(r, 6)
#define JITTER_REGISTER_r_7    JITTER_SLOW_REGISTER(r, 7)
#define JITTER_REGISTER_r_8    JITTER_SLOW_REGISTER(r, 8)
#define JITTER_REGISTER_r_9    JITTER_SLOW_REGISTER(r, 9)
#define JITTER_REGISTER_r_10   JITTER_SLOW_REGISTER(r, 10)
#define JITTER_REGISTER_r_11   JITTER_SLOW_REGISTER(r, 11)
#define JITTER_REGISTER_r_12   JITTER_SLOW_REGISTER(r, 12)
#define JITTER_REGISTER_r_13   JITTER_SLOW_REGISTER(r, 13)
#define JITTER_REGISTER_r_14   JITTER_SLOW_REGISTER(r, 14)
#define JITTER_REGISTER_r_15   JITTER_SLOW_REGISTER(r, 15)
#define JITTER_REGISTER_r_16   JITTER_SLOW_REGISTER(r, 16)
#define JITTER_REGISTER_r_17   JITTER_SLOW_REGISTER(r, 17)
#define JITTER_REGISTER_r_18   JITTER_SLOW_REGISTER(r, 18)
#define JITTER_REGISTER_r_19   JITTER_SLOW_REGISTER(r, 19)
#define JITTER_REGISTER_r_20   JITTER_SLOW_REGISTER(r, 20)
#define JITTER_REGISTER_r_21   JITTER_SLOW_REGISTER(r, 21)
#define JITTER_REGISTER_r_22   JITTER_SLOW_REGISTER(r, 22)
#define JITTER_REGISTER_r_23   JITTER_SLOW_REGISTER(r, 23)
#define JITTER_REGISTER_r_24   JITTER_SLOW_REGISTER(r, 24)
#define JITTER_REGISTER_r_25   JITTER_SLOW_REGISTER(r, 25)
#define JITTER_REGISTER_r_26   JITTER_SLOW_REGISTER(r, 26)
#define JITTER_REGISTER_r_27   JITTER_SLOW_REGISTER(r, 27)
#define JITTER_REGISTER_r_28   JITTER_SLOW_REGISTER(r, 28)
#define JITTER_REGISTER_r_29   JITTER_SLOW_REGISTER(r, 29)
#define JITTER_REGISTER_r_30   JITTER_SLOW_REGISTER(r, 30)
#define JITTER_REGISTER_r_31   JITTER_SLOW_REGISTER(r, 31)


#ifdef JITTER_DISPATCH_NO_THREADING

/* Reserve the scratch register, if any. */
#ifdef JITTER_SCRATCH_REGISTER
  register union jitter_word
  jitter_residual_argument_scratch_register_variable asm (JITTER_STRINGIFY(JITTER_SCRATCH_REGISTER));
#endif // #ifdef JITTER_SCRATCH_REGISTER

/* Reserve The Array base register. */
#ifndef JITTER_BASE_REGISTER
# error "the machine does not define JITTER_BASE_REGISTER"
#else
register char * restrict
pvm_array_base_register_variable asm (JITTER_STRINGIFY(JITTER_BASE_REGISTER));
#endif // #ifndef JITTER_BASE_REGISTER

/* Reserve registers for our 3 residual arguments.  If this particular VM doesn't
   need all of those supported by the assembly machine then reserve only the first
   ones.  If, on the other hand, we need more residual arguments than we have
   available registers, use CPP macros to map the remaining residual arguments
   to memory locations relative to the base, with constant offsets. */

/* Define a macro for the 0-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_0_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_0));
# define JITTER_RESIDUAL_ARGUMENT_0               \
    jitter_residual_argument_0_register_variable
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_0_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_0  \
    (* (union jitter_word *)                 \
       (jitter_array_base + PVM_RESIDUAL_OFFSET(0)))
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_0)
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 1-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_1_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_1));
# define JITTER_RESIDUAL_ARGUMENT_1               \
    jitter_residual_argument_1_register_variable
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_1_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_1  \
    (* (union jitter_word *)                 \
       (jitter_array_base + PVM_RESIDUAL_OFFSET(1)))
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_1)
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 2-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_2_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_2));
# define JITTER_RESIDUAL_ARGUMENT_2               \
    jitter_residual_argument_2_register_variable
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_2_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_2  \
    (* (union jitter_word *)                 \
       (jitter_array_base + PVM_RESIDUAL_OFFSET(2)))
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_2)
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)

/* The global register values we reserve in this compilation unit are
   callee-save: the called function is supposed to save them before
   setting them, and restore them to their previous value before
   returning to the caller.  Of course this is not done automatically
   in this compilation unit, so we have to do it by hand.  Notice that
   every variable allocated to a register by GCC will not use the
   registers we reserved, so we can be sure that, if we save our
   global register variables before setting them for the first time,
   their values will be the ones we want to retain. */

/* The buffer where I keep the original register values needs to hold
   every residual register, plus possibly the scratch register and the
   residual base; those two registers are not always used, but allocating
   just two words more costs essentially nothing and lets me simplify
   the code a little.  The two words are not written or read unless
   needed. */
#define PVM_REGISTER_BUFFER_ELEMENT_NO (JITTER_RESIDUAL_REGISTER_NO + 2)
__attribute__ ((noinline, cold))

static void
pvm_save_registers (union jitter_word *buffer)
{
  buffer [0].pointer = (union jitter_word*) pvm_array_base_register_variable;
#ifdef JITTER_SCRATCH_REGISTER
  buffer [1] = jitter_residual_argument_scratch_register_variable;
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [0 + 2] = JITTER_RESIDUAL_ARGUMENT_0;
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [1 + 2] = JITTER_RESIDUAL_ARGUMENT_1;
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [2 + 2] = JITTER_RESIDUAL_ARGUMENT_2;
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
}

__attribute__ ((noinline, cold))
static void
pvm_restore_registers (const union jitter_word *buffer)
{
  pvm_array_base_register_variable = (char *) buffer [0].pointer;
#ifdef JITTER_SCRATCH_REGISTER
  jitter_residual_argument_scratch_register_variable = buffer [1];
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_0 = buffer [0 + 2];
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_1 = buffer [1 + 2];
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_2 = buffer [2 + 2];
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
}

#endif // #ifdef JITTER_DISPATCH_NO_THREADING


/* Wrapper definition of the top operation for the TOS-optimized stack "stack". */
#define JITTER_TOP_STACK()  \
  JITTER_STACK_TOS_TOP(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the under_top operation for the TOS-optimized stack "stack". */
#define JITTER_UNDER_TOP_STACK()  \
  JITTER_STACK_TOS_UNDER_TOP(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the at_depth operation for the TOS-optimized stack "stack". */
#define JITTER_AT_DEPTH_STACK(x0)  \
  JITTER_STACK_TOS_AT_DEPTH(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the at_nonzero_depth operation for the TOS-optimized stack "stack". */
#define JITTER_AT_NONZERO_DEPTH_STACK(x0)  \
  JITTER_STACK_TOS_AT_NONZERO_DEPTH(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the set_at_depth operation for the TOS-optimized stack "stack". */
#define JITTER_SET_AT_DEPTH_STACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_DEPTH(pvm_val, jitter_state_runtime. , stack, x0, x1)

/* Wrapper definition of the set_at_nonzero_depth operation for the TOS-optimized stack "stack". */
#define JITTER_SET_AT_NONZERO_DEPTH_STACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_NONZERO_DEPTH(pvm_val, jitter_state_runtime. , stack, x0, x1)

/* Wrapper definition of the push_unspecified operation for the TOS-optimized stack "stack". */
#define JITTER_PUSH_UNSPECIFIED_STACK()  \
  JITTER_STACK_TOS_PUSH_UNSPECIFIED(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the push operation for the TOS-optimized stack "stack". */
#define JITTER_PUSH_STACK(x0)  \
  JITTER_STACK_TOS_PUSH(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the drop operation for the TOS-optimized stack "stack". */
#define JITTER_DROP_STACK()  \
  JITTER_STACK_TOS_DROP(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the dup operation for the TOS-optimized stack "stack". */
#define JITTER_DUP_STACK()  \
  JITTER_STACK_TOS_DUP(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the swap operation for the TOS-optimized stack "stack". */
#define JITTER_SWAP_STACK()  \
  JITTER_STACK_TOS_SWAP(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the quake operation for the TOS-optimized stack "stack". */
#define JITTER_QUAKE_STACK()  \
  JITTER_STACK_TOS_QUAKE(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the over operation for the TOS-optimized stack "stack". */
#define JITTER_OVER_STACK()  \
  JITTER_STACK_TOS_OVER(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the tuck operation for the TOS-optimized stack "stack". */
#define JITTER_TUCK_STACK()  \
  JITTER_STACK_TOS_TUCK(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the nip operation for the TOS-optimized stack "stack". */
#define JITTER_NIP_STACK()  \
  JITTER_STACK_TOS_NIP(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the rot operation for the TOS-optimized stack "stack". */
#define JITTER_ROT_STACK()  \
  JITTER_STACK_TOS_ROT(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the mrot operation for the TOS-optimized stack "stack". */
#define JITTER_MROT_STACK()  \
  JITTER_STACK_TOS_MROT(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the roll operation for the TOS-optimized stack "stack". */
#define JITTER_ROLL_STACK(x0)  \
  JITTER_STACK_TOS_ROLL(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the mroll operation for the TOS-optimized stack "stack". */
#define JITTER_MROLL_STACK(x0)  \
  JITTER_STACK_TOS_MROLL(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the slide operation for the TOS-optimized stack "stack". */
#define JITTER_SLIDE_STACK(x0, x1)  \
  JITTER_STACK_TOS_SLIDE(pvm_val, jitter_state_runtime. , stack, x0, x1)

/* Wrapper definition of the whirl operation for the TOS-optimized stack "stack". */
#define JITTER_WHIRL_STACK(x0)  \
  JITTER_STACK_TOS_WHIRL(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the bulge operation for the TOS-optimized stack "stack". */
#define JITTER_BULGE_STACK(x0)  \
  JITTER_STACK_TOS_BULGE(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the height operation for the TOS-optimized stack "stack". */
#define JITTER_HEIGHT_STACK()  \
  JITTER_STACK_TOS_HEIGHT(pvm_val, jitter_state_runtime. , stack)

/* Wrapper definition of the set_height operation for the TOS-optimized stack "stack". */
#define JITTER_SET_HEIGHT_STACK(x0)  \
  JITTER_STACK_TOS_SET_HEIGHT(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the reverse operation for the TOS-optimized stack "stack". */
#define JITTER_REVERSE_STACK(x0)  \
  JITTER_STACK_TOS_REVERSE(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the unary operation for the TOS-optimized stack "stack". */
#define JITTER_UNARY_STACK(x0)  \
  JITTER_STACK_TOS_UNARY(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the binary operation for the TOS-optimized stack "stack". */
#define JITTER_BINARY_STACK(x0)  \
  JITTER_STACK_TOS_BINARY(pvm_val, jitter_state_runtime. , stack, x0)

/* Wrapper definition of the top operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_TOP_RETURNSTACK()  \
  JITTER_STACK_NTOS_TOP(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the under_top operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_UNDER_TOP_RETURNSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the at_depth operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_AT_DEPTH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_AT_DEPTH(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the at_nonzero_depth operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_AT_NONZERO_DEPTH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_AT_NONZERO_DEPTH(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the set_at_depth operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_SET_AT_DEPTH_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_DEPTH(pvm_val, jitter_state_runtime. , returnstack, x0, x1)

/* Wrapper definition of the set_at_nonzero_depth operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_NONZERO_DEPTH(pvm_val, jitter_state_runtime. , returnstack, x0, x1)

/* Wrapper definition of the push_unspecified operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_PUSH_UNSPECIFIED_RETURNSTACK()  \
  JITTER_STACK_NTOS_PUSH_UNSPECIFIED(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the push operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_PUSH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_PUSH(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the drop operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_DROP_RETURNSTACK()  \
  JITTER_STACK_NTOS_DROP(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the dup operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_DUP_RETURNSTACK()  \
  JITTER_STACK_NTOS_DUP(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the swap operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_SWAP_RETURNSTACK()  \
  JITTER_STACK_NTOS_SWAP(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the quake operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_QUAKE_RETURNSTACK()  \
  JITTER_STACK_NTOS_QUAKE(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the over operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_OVER_RETURNSTACK()  \
  JITTER_STACK_NTOS_OVER(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the tuck operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_TUCK_RETURNSTACK()  \
  JITTER_STACK_NTOS_TUCK(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the nip operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_NIP_RETURNSTACK()  \
  JITTER_STACK_NTOS_NIP(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the rot operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_ROT_RETURNSTACK()  \
  JITTER_STACK_NTOS_ROT(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the mrot operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_MROT_RETURNSTACK()  \
  JITTER_STACK_NTOS_MROT(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the roll operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_ROLL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_ROLL(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the mroll operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_MROLL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_MROLL(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the slide operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_SLIDE_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SLIDE(pvm_val, jitter_state_runtime. , returnstack, x0, x1)

/* Wrapper definition of the whirl operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_WHIRL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_WHIRL(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the bulge operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_BULGE_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_BULGE(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the height operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_HEIGHT_RETURNSTACK()  \
  JITTER_STACK_NTOS_HEIGHT(pvm_val, jitter_state_runtime. , returnstack)

/* Wrapper definition of the set_height operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_SET_HEIGHT_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_SET_HEIGHT(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the reverse operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_REVERSE_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_REVERSE(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the unary operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_UNARY_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_UNARY(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the binary operation for the non-TOS-optimized stack "returnstack". */
#define JITTER_BINARY_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_BINARY(pvm_val, jitter_state_runtime. , returnstack, x0)

/* Wrapper definition of the top operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_TOP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_TOP(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the under_top operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_UNDER_TOP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the at_depth operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_AT_DEPTH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_AT_DEPTH(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the at_nonzero_depth operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_AT_NONZERO_DEPTH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_AT_NONZERO_DEPTH(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the set_at_depth operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_SET_AT_DEPTH_EXCEPTIONSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_DEPTH(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0, x1)

/* Wrapper definition of the set_at_nonzero_depth operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_SET_AT_NONZERO_DEPTH_EXCEPTIONSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_NONZERO_DEPTH(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0, x1)

/* Wrapper definition of the push_unspecified operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_PUSH_UNSPECIFIED_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_PUSH_UNSPECIFIED(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the push operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_PUSH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_PUSH(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the drop operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_DROP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_DROP(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the dup operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_DUP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_DUP(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the swap operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_SWAP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_SWAP(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the quake operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_QUAKE_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_QUAKE(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the over operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_OVER_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_OVER(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the tuck operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_TUCK_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_TUCK(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the nip operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_NIP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_NIP(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the rot operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_ROT_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_ROT(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the mrot operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_MROT_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_MROT(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the roll operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_ROLL_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_ROLL(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the mroll operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_MROLL_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_MROLL(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the slide operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_SLIDE_EXCEPTIONSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SLIDE(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0, x1)

/* Wrapper definition of the whirl operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_WHIRL_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_WHIRL(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the bulge operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_BULGE_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_BULGE(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the height operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_HEIGHT_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_HEIGHT(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack)

/* Wrapper definition of the set_height operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_SET_HEIGHT_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_SET_HEIGHT(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the reverse operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_REVERSE_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_REVERSE(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the unary operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_UNARY_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_UNARY(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Wrapper definition of the binary operation for the non-TOS-optimized stack "exceptionstack". */
#define JITTER_BINARY_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_BINARY(struct pvm_exception_handler, jitter_state_runtime. , exceptionstack, x0)

/* Late C code from the user. */
#line 529 "../../libpoke/pvm.jitter"
#line 529 "../../libpoke/pvm.jitter"

    void
    pvm_handle_signal (int signal_number)
    {
      struct pvm_state *s;

      /* For every state... */
      PVM_FOR_EACH_STATE (s)
      {
        /* ...Mark the signal signal_number as pending... */
        PVM_STATE_AND_SIGNAL_TO_PENDING_SIGNAL_NOTIFICATION
           (s, signal_number) = true;
        /* ...And record the fact that there is at least one notification to
           handle. */
        PVM_STATE_TO_PENDING_NOTIFICATIONS (s) = true;
      }
    }
  /* End of the late C code from the user. */

/* The definition of this is machine-generated in pvm-vm2.c , and the
   function is not intended for the user.  If initializing then set
   structuredvm_threads and structuredvm_thread_sizes and just return, ignoring
   the other fieldsp and s.  If not initializing then actually enter VM code
   starting from the given program point in the pointed state. */
static void
pvm_execute_or_initialize (bool jitter_initialize,
                                pvm_program_point jitter_initial_program_point,
                                struct pvm_state * const jitter_original_state)
  __attribute__ ((noclone, noinline));

void
pvm_execute_executable_routine (const struct jitter_executable_routine *er,
                                     struct pvm_state *s)
{
  pvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
  jitter_program_point initial_program_point
    = PVM_EXECUTABLE_ROUTINE_BEGINNING (er);
  pvm_execute_or_initialize (false, initial_program_point, s);
}


/* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
const jitter_thread *
pvm_threads;

const jitter_thread *
pvm_thread_ends;

const long *
pvm_thread_sizes;
#endif // #ifndef JITTER_DISPATCH_SWITCH

void
pvm_initialize_threads (void)
{
  pvm_execute_or_initialize (true, NULL, NULL);
}

void
pvm_branch_to_program_point (pvm_program_point p, struct pvm_state *s)
{
  pvm_execute_or_initialize (false, p, s);
}

static void
pvm_execute_or_initialize (bool jitter_initialize,
                                pvm_program_point jitter_initial_program_point,
                                struct pvm_state * const jitter_original_state)
{
#ifdef JITTER_DISPATCH_NO_THREADING
  /* Save the values in the registers we reserved as global variables,
     since from the point of view of the other C compilation units such
     registers are callee-save.  FIXME: this is not really needed when
     initializing, if I've been careful; but for the time being I want
     to play it safe. */
  union jitter_word jitter_register_buffer [PVM_REGISTER_BUFFER_ELEMENT_NO];
  pvm_save_registers (jitter_register_buffer);
#endif // #ifdef JITTER_DISPATCH_NO_THREADING

#ifdef JITTER_HAVE_PATCH_IN
  /* Generate the single patch-in header for this executor as a
     global asm statement.  This expands into a global definition in
     assembly in a separate subsection, and relies on toplevel C
     definitions not being reordered: pvm_execute_or_initialize
     will add to the same global.  Do the same for defects. */
  JITTER_DEFECT_HEADER(pvm);
  JITTER_PATCH_IN_HEADER(pvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifndef JITTER_DISPATCH_SWITCH
  JITTER_DATA_LOCATION_HEADER(pvm);
#endif // #ifndef JITTER_DISPATCH_SWITCH

  /* Initialization.  This is only called once at startup. */
  if (__builtin_expect (jitter_initialize, false))
    {
      /* Make sure that vm1 and vm2 were macroexpanded consistently
         with respect to instrumentation macros.  This relies on the
         enum values for each feature working as individual bits in a
         bitmask: see the comment in jitter/jitter-vm.h . */
      enum jitter_vm_instrumentation correct_instrumentation
        = jitter_vm_instrumentation_none;
#if defined (JITTER_PROFILE_COUNT)
      correct_instrumentation |= jitter_vm_instrumentation_count;
#endif
#if defined (JITTER_PROFILE_SAMPLE)
      correct_instrumentation |= jitter_vm_instrumentation_sample;
#endif
      if (pvm_vm_configuration->instrumentation != correct_instrumentation)
        jitter_fatal ("vm1 and vm2 were compiled with different profiling "
                      "instrumentation macros.  Please recompile with coherent "
                      "CPPFLAGS");

#if defined (JITTER_PROFILE_SAMPLE)
    /* Initialise the sample-profile subsystem, once and for all. */
    pvm_profile_sample_initialize ();
#endif // #if defined (JITTER_PROFILE_SAMPLE)

#ifndef JITTER_DISPATCH_SWITCH
      /* FIXME: I can do this with only one relocation, by keeping
         a pointer to the first VM instruction beginning in a static
         variable, and then having a static vector of offsets with
         respect to the first pointer.  This will slightly complicate
         my initialization code, but should make startup faster.
         FIXME: that won't work on AVR, according to the GCC
         documentation.  Do I care?  Probably not, since AVRs can't
         address more than 2^16 bytes, which is too little to run my
         VMs. */
      static const jitter_thread pvm_the_threads []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ains),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(and),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arefo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arem),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aset),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(asettb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(atr),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ba__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beghl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(begsc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnoti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bori),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(boriu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsli),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsliu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsll),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsllu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsri),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsriu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxori),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxoriu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(canary),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(close),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ctos),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(disas),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(diviu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(duc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endhl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endsc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eql),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqs),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exit),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(flush),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fromr),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gei),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(geiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gelu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ges),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(getenv),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gts),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(indent),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iogetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosize),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isa),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lei),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(leiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lelu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(les),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lts),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(map),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgeto),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgets),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetw),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mka),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mko),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mksct),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktya),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyany),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktys),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktysct),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyv),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mseto),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msets),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetw),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muli),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muliu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mull),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mullu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muls),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neglu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nei),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nelu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nes),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nnn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(not),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(note__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nrot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetbt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(open),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(or),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(osetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(over),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pec),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeki__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekl__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeklu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeks),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokediu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokei__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokeiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokel__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokelu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokes),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pope),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popend),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoac),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popob),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popobc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popod),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popom),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popopp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prints),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prolog),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushe__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushend),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushhi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushhi__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushlo__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushlo__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoac),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushob),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushobc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushod),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushom),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushopp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushtopvar__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(quake),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rand),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(regvar),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reloc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(restorer___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(return),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(saver___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sconc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(setr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(siz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(smodi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefia),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefio),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefmnt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefnt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sset),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strace__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sublu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(substr),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swap),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sync),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(time),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tor),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tuck),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagett),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyissct),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(typof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unmap),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ureloc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(write__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Aba__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abn__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnn__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzi__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnziu__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzl__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzlu__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzi__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abziu__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzl__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches)
          };
      static const jitter_thread pvm_the_thread_ends []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ains),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(and),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(aref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(arefo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(arem),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(aset),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(asettb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(atr),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ba__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beghl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(begsc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnoti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bori),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(boriu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(borl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(borlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsli),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsliu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsll),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsllu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsri),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsriu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsrl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsrlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxori),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxoriu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxorl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxorlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(canary),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(close),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ctos),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(disas),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(diviu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(duc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endhl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endsc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eql),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqs),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exit),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(flush),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fromr),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gei),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(geiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gelu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ges),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(getenv),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gts),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(indent),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iogetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iosetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iosize),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isa),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lei),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(leiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lelu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(les),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lts),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(map),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgeto),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgets),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetw),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mka),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mko),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mksct),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktya),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyany),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktys),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktysct),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyv),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mseto),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msets),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetw),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muli),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muliu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mull),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mullu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muls),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neglu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nei),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nelu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nes),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nnn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(not),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(note__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nrot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetbt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(open),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(or),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(osetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(over),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pec),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeki__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekl__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeklu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeks),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokediu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokei__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokeiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokel__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokelu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokes),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pope),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popend),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoac),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popob),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popobc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popod),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popom),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popopp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(prints),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(prolog),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushe__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushend),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushhi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushhi__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushlo__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushlo__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoac),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushob),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushobc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushod),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushom),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushopp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushtopvar__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(quake),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rand),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(regvar),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reloc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(restorer___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(return),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(saver___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sconc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(setr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(siz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(smodi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefia),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefio),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefmnt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefnt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sset),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strace__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sublu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(substr),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swap),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sync),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(time),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tor),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tuck),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyagetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyagett),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyissct),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(typof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unmap),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ureloc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(write__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Aba__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abn__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnn__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnzi__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnziu__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnzl__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnzlu__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzi__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abziu__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzl__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches)
          };
      static const long
      pvm_the_thread_sizes [PVM_SPECIALIZED_INSTRUCTION_NO]
        = {
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ains))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ains))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(and))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(and))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(aref))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aref))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(arefo))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arefo))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(arem))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arem))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(aset))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aset))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(asettb))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(asettb))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(atr))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(atr))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ba__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ba__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beghl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beghl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(begsc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(begsc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bn__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bn__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnn__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnn__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnoti))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnoti))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzi__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzi__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnziu__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnziu__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzl__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzl__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzlu__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzlu__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bori))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bori))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(boriu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(boriu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(borl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(borlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsli))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsli))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsliu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsliu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsll))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsll))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsllu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsllu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsri))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsri))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsriu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsriu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsrl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsrlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxori))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxori))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxoriu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxoriu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxorl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxorlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzi__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzi__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bziu__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bziu__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzl__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzl__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzlu__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzlu__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(canary))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(canary))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(close))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(close))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ctos))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ctos))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(disas))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(disas))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(diviu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(diviu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop3))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop3))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop4))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop4))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(duc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(duc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endhl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endhl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endsc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endsc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eql))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eql))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqs))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqs))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exit))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exit))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(flush))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(flush))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fromr))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fromr))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gei))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gei))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(geiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(geiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gel))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gel))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gelu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gelu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ges))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ges))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(getenv))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(getenv))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gti))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gti))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gts))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gts))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(indent))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(indent))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iogetb))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iogetb))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iosetb))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosetb))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iosize))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosize))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isa))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isa))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itoi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itoiu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoiu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itol__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itol__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itolu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itolu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutoi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutoiu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoiu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutol__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutol__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutolu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutolu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lei))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lei))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(leiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(leiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lel))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lel))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lelu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lelu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(les))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(les))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lti))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lti))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltoi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltoiu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoiu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltol__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltol__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltolu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltolu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lts))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lts))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutoi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutoiu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoiu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutol__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutol__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutolu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutolu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(map))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(map))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetios))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetios))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgeto))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgeto))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgets))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgets))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetsel))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsel))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetsiz))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsiz))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetw))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetw))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mka))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mka))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mko))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mko))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mksct))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mksct))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktya))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktya))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyany))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyany))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyo))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyo))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktys))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktys))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktysct))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktysct))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyv))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyv))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetios))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetios))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mseto))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mseto))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msets))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msets))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetsel))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsel))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetsiz))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsiz))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetw))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetw))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muli))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muli))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muliu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muliu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mull))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mull))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mullu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mullu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muls))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muls))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neglu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neglu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nei))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nei))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nel))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nel))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nelu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nelu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nes))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nes))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip3))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip3))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nn))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nn))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nnn))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nnn))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nop))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nop))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(not))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(not))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(note__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(note__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nrot))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nrot))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetbt))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetbt))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(open))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(open))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(or))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(or))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(osetm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(osetm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(over))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(over))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pec))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pec))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdiu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdiu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdl__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdl__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdlu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdlu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeki__nR__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeki__nR__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekiu__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekiu__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekl__nR__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekl__nR__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeklu__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeklu__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeks))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeks))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokediu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokediu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedl__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedl__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedlu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedlu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokei__nR__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokei__nR__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokeiu__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokeiu__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokel__nR__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokel__nR__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokelu__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokelu__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokes))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokes))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pope))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pope))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popend))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popend))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popf__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popf__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popios))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popios))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoac))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoac))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popob))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popob))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popobc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popobc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popod))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popod))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popom))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popom))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoo))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoo))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popopp))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popopp))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popr___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popr___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popvar__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popvar__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printiu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printiu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printl__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printl__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printlu__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printlu__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(prints))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prints))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(prolog))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prolog))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push__lR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__lR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__lR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__lR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushe__lR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushe__lR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushend))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushend))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushf__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushf__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushhi__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushhi__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushhi__lR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushhi__lR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushios))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushios))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushlo__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushlo__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushlo__lR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushlo__lR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoac))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoac))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushob))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushob))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushobc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushobc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushod))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushod))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushom))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushom))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoo))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoo))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushopp))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushopp))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushtopvar__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushtopvar__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n3))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n3))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n4))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n4))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n5))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n5))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n3))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n3))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n4))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n4))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n5))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n5))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(quake))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(quake))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rand))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rand))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(regvar))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(regvar))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reloc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reloc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(restorer___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(restorer___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(return))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(return))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__n3))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n3))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__n4))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n4))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rot))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rot))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(saver___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(saver___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sconc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sconc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sel))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sel))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(setr___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(setr___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(siz))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(siz))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(smodi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(smodi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sref))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sref))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefia))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefia))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefio))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefio))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefmnt))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefmnt))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefnt))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefnt))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefo))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefo))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sset))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sset))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strace__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strace__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strref))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strref))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subi))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subi))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sublu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sublu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(substr))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(substr))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swap))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swap))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgti))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgti))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtiu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtiu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtl))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtl))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtlu))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtlu))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sync))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sync))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(time))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(time))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tor))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tor))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tuck))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tuck))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyagetb))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagetb))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyagett))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagett))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyissct))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyissct))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(typof))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(typof))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctn))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctn))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unmap))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unmap))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ureloc))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ureloc))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(write__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(write__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Aba__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Aba__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abn__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abn__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnn__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnn__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnzi__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzi__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnziu__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnziu__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnzl__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzl__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abnzlu__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzlu__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzi__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzi__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abziu__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abziu__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzl__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzl__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches)))
          };
      pvm_thread_sizes = pvm_the_thread_sizes;
      pvm_threads = pvm_the_threads;
      pvm_thread_ends = pvm_the_thread_ends;
#ifdef JITTER_PROFILE
      fprintf (stderr, "VM instruction range: ");
      fprintf (stderr, "[%p, ", && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID));
      fprintf (stderr, "%p)", && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches));
      fprintf (stderr, "\n");
#endif // #ifdef JITTER_PROFILE
#endif // #ifndef JITTER_DISPATCH_SWITCH

      /* Back to regular C, without our reserved registers if any; I can share
         the end code with the non-initialization case. */
#ifdef JITTER_HAVE_PATCH_IN
      //JITTER_DUMP_PATCH_IN_DESCRIPTORS(pvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN
      goto jitter_possibly_restore_registers_and_return_label;
    }


  /* Here is the actual *executor* initialization, to be run before
     actually running the code. */

/* Selectively suppress suprious -Wmaybe-uninitialized .
   The indirect jump hack I use in profiling mode in order to
   have a large gap inside a function introduced by assembler without
   being restricted by jump offset limits (intentionally) tricks GCC
   into believing that the indirect jump may reach any instruction label;
   GCC would then warn that some locals might be used uninitialized,
   by skipping over their initialization.  This however is not possible,
   and I want to selectively silence the warning for the variables in
   question. */
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

  /* Wrap functions and globals used within VM instructions, if needed.
     This is a trick to keep instructions readable while avoiding PC-relative
     addressing, which would mess up replicated code. */
#ifdef JITTER_REPLICATE

  /* Protect the C globals used in VM instructions so that they are always
     referred thru a pointer (from a register or the stack) set in the
     non-replicated part.  This is necessary on architectures where I can't
     force global references to pass thru a GOT.
     [FIXME: possibly don't do this on architectures that don't need it.] */

  typeof (pvm_states) * volatile _my_volatile_pointer_to_pvm_states = & pvm_states;
  typeof (pvm_states) * const restrict _my_pointer_to_pvm_states __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_states;
# undef pvm_states
# define pvm_states (* _my_pointer_to_pvm_states)

  /* Similarly, wrap the C functions used in VM instructions, so that they are
     always called thru a function pointer.  This is necessary on architectures
     where call instructions represent the callee as a PC-relative address.
     Unfortunately C has a special quirky syntax for function pointers, so I
     can't just use the code above.  [FIXME: don't do this on architectures
     that don't need it.] */
  typeof (gettime) * volatile _my_volatile_pointer_to_gettime = & gettime;
  typeof (gettime) * const _my_gettime __attribute__ ((unused))
     = * _my_volatile_pointer_to_gettime;
# undef gettime
# define gettime _my_gettime

  typeof (secure_getenv) * volatile _my_volatile_pointer_to_secure_getenv = & secure_getenv;
  typeof (secure_getenv) * const _my_secure_getenv __attribute__ ((unused))
     = * _my_volatile_pointer_to_secure_getenv;
# undef secure_getenv
# define secure_getenv _my_secure_getenv

  typeof (srandom) * volatile _my_volatile_pointer_to_srandom = & srandom;
  typeof (srandom) * const _my_srandom __attribute__ ((unused))
     = * _my_volatile_pointer_to_srandom;
# undef srandom
# define srandom _my_srandom

  typeof (random) * volatile _my_volatile_pointer_to_random = & random;
  typeof (random) * const _my_random __attribute__ ((unused))
     = * _my_volatile_pointer_to_random;
# undef random
# define random _my_random

  typeof (ios_write_string) * volatile _my_volatile_pointer_to_ios_write_string = & ios_write_string;
  typeof (ios_write_string) * const _my_ios_write_string __attribute__ ((unused))
     = * _my_volatile_pointer_to_ios_write_string;
# undef ios_write_string
# define ios_write_string _my_ios_write_string

  typeof (ios_read_string) * volatile _my_volatile_pointer_to_ios_read_string = & ios_read_string;
  typeof (ios_read_string) * const _my_ios_read_string __attribute__ ((unused))
     = * _my_volatile_pointer_to_ios_read_string;
# undef ios_read_string
# define ios_read_string _my_ios_read_string

  typeof (ios_read_uint) * volatile _my_volatile_pointer_to_ios_read_uint = & ios_read_uint;
  typeof (ios_read_uint) * const _my_ios_read_uint __attribute__ ((unused))
     = * _my_volatile_pointer_to_ios_read_uint;
# undef ios_read_uint
# define ios_read_uint _my_ios_read_uint

  typeof (ios_read_int) * volatile _my_volatile_pointer_to_ios_read_int = & ios_read_int;
  typeof (ios_read_int) * const _my_ios_read_int __attribute__ ((unused))
     = * _my_volatile_pointer_to_ios_read_int;
# undef ios_read_int
# define ios_read_int _my_ios_read_int

  typeof (ios_cur) * volatile _my_volatile_pointer_to_ios_cur = & ios_cur;
  typeof (ios_cur) * const _my_ios_cur __attribute__ ((unused))
     = * _my_volatile_pointer_to_ios_cur;
# undef ios_cur
# define ios_cur _my_ios_cur

  typeof (pvm_val_ureloc) * volatile _my_volatile_pointer_to_pvm_val_ureloc = & pvm_val_ureloc;
  typeof (pvm_val_ureloc) * const _my_pvm_val_ureloc __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_val_ureloc;
# undef pvm_val_ureloc
# define pvm_val_ureloc _my_pvm_val_ureloc

  typeof (pvm_val_unmap) * volatile _my_volatile_pointer_to_pvm_val_unmap = & pvm_val_unmap;
  typeof (pvm_val_unmap) * const _my_pvm_val_unmap __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_val_unmap;
# undef pvm_val_unmap
# define pvm_val_unmap _my_pvm_val_unmap

  typeof (pvm_val_reloc) * volatile _my_volatile_pointer_to_pvm_val_reloc = & pvm_val_reloc;
  typeof (pvm_val_reloc) * const _my_pvm_val_reloc __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_val_reloc;
# undef pvm_val_reloc
# define pvm_val_reloc _my_pvm_val_reloc

  typeof (pvm_set_struct) * volatile _my_volatile_pointer_to_pvm_set_struct = & pvm_set_struct;
  typeof (pvm_set_struct) * const _my_pvm_set_struct __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_set_struct;
# undef pvm_set_struct
# define pvm_set_struct _my_pvm_set_struct

  typeof (pvm_ref_struct_cstr) * volatile _my_volatile_pointer_to_pvm_ref_struct_cstr = & pvm_ref_struct_cstr;
  typeof (pvm_ref_struct_cstr) * const _my_pvm_ref_struct_cstr __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_ref_struct_cstr;
# undef pvm_ref_struct_cstr
# define pvm_ref_struct_cstr _my_pvm_ref_struct_cstr

  typeof (pvm_ref_struct) * volatile _my_volatile_pointer_to_pvm_ref_struct = & pvm_ref_struct;
  typeof (pvm_ref_struct) * const _my_pvm_ref_struct __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_ref_struct;
# undef pvm_ref_struct
# define pvm_ref_struct _my_pvm_ref_struct

  typeof (pvm_type_equal_p) * volatile _my_volatile_pointer_to_pvm_type_equal_p = & pvm_type_equal_p;
  typeof (pvm_type_equal_p) * const _my_pvm_type_equal_p __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_type_equal_p;
# undef pvm_type_equal_p
# define pvm_type_equal_p _my_pvm_type_equal_p

  typeof (pvm_typeof) * volatile _my_volatile_pointer_to_pvm_typeof = & pvm_typeof;
  typeof (pvm_typeof) * const _my_pvm_typeof __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_typeof;
# undef pvm_typeof
# define pvm_typeof _my_pvm_typeof

  typeof (pvm_make_struct_type) * volatile _my_volatile_pointer_to_pvm_make_struct_type = & pvm_make_struct_type;
  typeof (pvm_make_struct_type) * const _my_pvm_make_struct_type __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_struct_type;
# undef pvm_make_struct_type
# define pvm_make_struct_type _my_pvm_make_struct_type

  typeof (pvm_allocate_struct_attrs) * volatile _my_volatile_pointer_to_pvm_allocate_struct_attrs = & pvm_allocate_struct_attrs;
  typeof (pvm_allocate_struct_attrs) * const _my_pvm_allocate_struct_attrs __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_allocate_struct_attrs;
# undef pvm_allocate_struct_attrs
# define pvm_allocate_struct_attrs _my_pvm_allocate_struct_attrs

  typeof (pvm_make_array_type) * volatile _my_volatile_pointer_to_pvm_make_array_type = & pvm_make_array_type;
  typeof (pvm_make_array_type) * const _my_pvm_make_array_type __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_array_type;
# undef pvm_make_array_type
# define pvm_make_array_type _my_pvm_make_array_type

  typeof (pvm_make_offset_type) * volatile _my_volatile_pointer_to_pvm_make_offset_type = & pvm_make_offset_type;
  typeof (pvm_make_offset_type) * const _my_pvm_make_offset_type __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_offset_type;
# undef pvm_make_offset_type
# define pvm_make_offset_type _my_pvm_make_offset_type

  typeof (pvm_make_string_type) * volatile _my_volatile_pointer_to_pvm_make_string_type = & pvm_make_string_type;
  typeof (pvm_make_string_type) * const _my_pvm_make_string_type __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_string_type;
# undef pvm_make_string_type
# define pvm_make_string_type _my_pvm_make_string_type

  typeof (pvm_make_integral_type) * volatile _my_volatile_pointer_to_pvm_make_integral_type = & pvm_make_integral_type;
  typeof (pvm_make_integral_type) * const _my_pvm_make_integral_type __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_integral_type;
# undef pvm_make_integral_type
# define pvm_make_integral_type _my_pvm_make_integral_type

  typeof (pvm_make_offset) * volatile _my_volatile_pointer_to_pvm_make_offset = & pvm_make_offset;
  typeof (pvm_make_offset) * const _my_pvm_make_offset __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_offset;
# undef pvm_make_offset
# define pvm_make_offset _my_pvm_make_offset

  typeof (pvm_make_struct) * volatile _my_volatile_pointer_to_pvm_make_struct = & pvm_make_struct;
  typeof (pvm_make_struct) * const _my_pvm_make_struct __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_struct;
# undef pvm_make_struct
# define pvm_make_struct _my_pvm_make_struct

  typeof (pvm_make_array) * volatile _my_volatile_pointer_to_pvm_make_array = & pvm_make_array;
  typeof (pvm_make_array) * const _my_pvm_make_array __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_array;
# undef pvm_make_array
# define pvm_make_array _my_pvm_make_array

  typeof (pvm_make_string) * volatile _my_volatile_pointer_to_pvm_make_string = & pvm_make_string;
  typeof (pvm_make_string) * const _my_pvm_make_string __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_make_string;
# undef pvm_make_string
# define pvm_make_string _my_pvm_make_string

  typeof (pvm_env_toplevel) * volatile _my_volatile_pointer_to_pvm_env_toplevel = & pvm_env_toplevel;
  typeof (pvm_env_toplevel) * const _my_pvm_env_toplevel __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_env_toplevel;
# undef pvm_env_toplevel
# define pvm_env_toplevel _my_pvm_env_toplevel

  typeof (pvm_env_push_frame) * volatile _my_volatile_pointer_to_pvm_env_push_frame = & pvm_env_push_frame;
  typeof (pvm_env_push_frame) * const _my_pvm_env_push_frame __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_env_push_frame;
# undef pvm_env_push_frame
# define pvm_env_push_frame _my_pvm_env_push_frame

  typeof (pvm_env_pop_frame) * volatile _my_volatile_pointer_to_pvm_env_pop_frame = & pvm_env_pop_frame;
  typeof (pvm_env_pop_frame) * const _my_pvm_env_pop_frame __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_env_pop_frame;
# undef pvm_env_pop_frame
# define pvm_env_pop_frame _my_pvm_env_pop_frame

  typeof (pvm_env_register) * volatile _my_volatile_pointer_to_pvm_env_register = & pvm_env_register;
  typeof (pvm_env_register) * const _my_pvm_env_register __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_env_register;
# undef pvm_env_register
# define pvm_env_register _my_pvm_env_register

  typeof (pvm_env_lookup) * volatile _my_volatile_pointer_to_pvm_env_lookup = & pvm_env_lookup;
  typeof (pvm_env_lookup) * const _my_pvm_env_lookup __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_env_lookup;
# undef pvm_env_lookup
# define pvm_env_lookup _my_pvm_env_lookup

  typeof (pvm_assert) * volatile _my_volatile_pointer_to_pvm_assert = & pvm_assert;
  typeof (pvm_assert) * const _my_pvm_assert __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_assert;
# undef pvm_assert
# define pvm_assert _my_pvm_assert

  typeof (pvm_array_set) * volatile _my_volatile_pointer_to_pvm_array_set = & pvm_array_set;
  typeof (pvm_array_set) * const _my_pvm_array_set __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_array_set;
# undef pvm_array_set
# define pvm_array_set _my_pvm_array_set

  typeof (pvm_array_insert) * volatile _my_volatile_pointer_to_pvm_array_insert = & pvm_array_insert;
  typeof (pvm_array_insert) * const _my_pvm_array_insert __attribute__ ((unused))
     = * _my_volatile_pointer_to_pvm_array_insert;
# undef pvm_array_insert
# define pvm_array_insert _my_pvm_array_insert

  typeof (printf) * volatile _my_volatile_pointer_to_printf = & printf;
  typeof (printf) * const _my_printf __attribute__ ((unused))
     = * _my_volatile_pointer_to_printf;
# undef printf
# define printf _my_printf

  typeof (pk_printf) * volatile _my_volatile_pointer_to_pk_printf = & pk_printf;
  typeof (pk_printf) * const _my_pk_printf __attribute__ ((unused))
     = * _my_volatile_pointer_to_pk_printf;
# undef pk_printf
# define pk_printf _my_pk_printf

  typeof (pk_term_end_class) * volatile _my_volatile_pointer_to_pk_term_end_class = & pk_term_end_class;
  typeof (pk_term_end_class) * const _my_pk_term_end_class __attribute__ ((unused))
     = * _my_volatile_pointer_to_pk_term_end_class;
# undef pk_term_end_class
# define pk_term_end_class _my_pk_term_end_class

  typeof (pk_term_class) * volatile _my_volatile_pointer_to_pk_term_class = & pk_term_class;
  typeof (pk_term_class) * const _my_pk_term_class __attribute__ ((unused))
     = * _my_volatile_pointer_to_pk_term_class;
# undef pk_term_class
# define pk_term_class _my_pk_term_class

/* See the comment above about spurious -Wmaybe-uninitialized warnings. */
#pragma GCC diagnostic pop
#endif // #ifdef JITTER_REPLICATE


  /* Make an automatic struct holding a copy of the state whose pointer was given.
     The idea is that the copy should be in registers, as far as possible. */
  struct pvm_state_runtime jitter_state_runtime
    = jitter_original_state->pvm_state_runtime;

  /* Initialize a pointer to The Array base.  This pointer will be in a
     global register variable with no-threading dispatch, and with
     other dispatches in an automatic variable, still hopefully kept
     in a register. */
/* About the pragma, look for "-Wmaybe-uninitialized" in the comments above. FIXME: this is to avoid a GCC warning with profiling.  Check with profiling on. */
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#ifdef JITTER_DISPATCH_NO_THREADING
# define jitter_array_base pvm_array_base_register_variable
#else
  char * restrict jitter_array_base __attribute__ ((unused));
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#pragma GCC diagnostic pop
  jitter_array_base
    = (((char *) jitter_original_state->pvm_state_backing.jitter_array)
       + JITTER_ARRAY_BIAS);

  /* Declare the instruction pointer from the thread array, unless the dispatching
     model is no-threading, in which case no thread array even exists. */
  pvm_program_point jitter_ip = NULL; /* Invalidate to catch errors. */
  /* Save an instruction address within this function, to jump to at VM exit
     time; that way we can be sure that at exit time we are back to
     non-replicated code, and stuff like PC-relative addressing work again
     without special tricks.  This variable may safely (and actually should,
     for performance) be kept on the stack.  We need it to be volatile to
     prevent the compiler from being too clever and jump to it using a
     PC-relative displacement from replicated code.   It must not be static,
     since non-automatic variables are problematic to access from replicated
     code, which might use PC-relative addressing. */
  volatile typeof (&& jitter_exit_vm_label) restrict
  jitter_saved_exit_non_replicated_code_pointer = &&jitter_exit_vm_label;
  JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(jitter_saved_exit_non_replicated_code_pointer);


#ifdef JITTER_REPLICATE
  /* FIXME: comment. */
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Aba__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Aba__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Aba__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Aba__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abn__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abn__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abn__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abn__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnn__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abnn__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnn__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnn__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzi__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abnzi__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzi__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzi__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnziu__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abnziu__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnziu__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnziu__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzl__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abnzl__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzl__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzl__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzlu__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abnzlu__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzlu__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abnzlu__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzi__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abzi__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzi__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzi__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abziu__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abziu__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abziu__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abziu__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzl__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abzl__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzl__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzl__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzlu__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzlu__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abzlu__fR_A_mno_mfast_mbranches)));
#endif // #ifdef JITTER_REPLICATE
  /* Initialization C code from the user */
  /* End of the initialization C code from the user */


  /* Execute architecture-specific execution-beginning code, if any.
     Make sure it is safe to expand the macro without do..while
     (false). */
  {}; JITTER_EXECUTION_BEGINNING_; {};

#if defined (JITTER_PROFILE_SAMPLE)
    /* Start sample-profiling: this starts the periodic timer signal,
       whose handler will look at the current instruction field within
       the special-purpose struct in the Array. */
    pvm_profile_sample_start (PVM_OWN_STATE);
#endif // #if defined (JITTER_PROFILE_SAMPLE)

  /* Jump to the first instruction.  If replication is enabled this point
     marks the boundary between the ordinary world of C compiled code and
     the more fragile replicated code, where PC-relative address does
     not work as intended (which prevents the use of global and static
     variables, string literals and possibly large literal constants), and
     GDB gets easily confused. */
  jitter_ip = jitter_initial_program_point;

  /* This is the actual jump to the first instruction: it's not an
     inline asm constraint lie like below. */

# if   defined(JITTER_DISPATCH_SWITCH)
    goto jitter_dispatching_switch_label;
# elif (defined(JITTER_DISPATCH_DIRECT_THREADING)  \
        || defined(JITTER_DISPATCH_MINIMAL_THREADING))
    goto * (jitter_ip->label);
# elif defined(JITTER_DISPATCH_NO_THREADING)
    /* On no-threading we only use jitter_ip for the first instruction.
       Make it an alias for the base, which will be enough to satisfy
       inline assembly code which pretends to alter the instruction
       pointer in ways invisible to the compiler.
       At least in my tests this trick frees up one hardware register,
       which is not surprising. */
    goto * jitter_ip;
#   define jitter_ip pvm_array_base_register_variable
# else
#   error "unknown dispatch"
# endif // if ... dispatch
  /* FIXME: comment: this is the fake dispatch routine. */
 /* The label is unused (from the compiler's point of view) for simple
    dispatches when not profiling.  (In reality it is always unused.)
    FIXME: comment. */
 jitter_dispatch_label: __attribute__ ((hot, unused))
#if   defined(JITTER_DISPATCH_SWITCH)
  /* This code is unreachable, but the compiler does not know it.  FIXME: comment. */
  goto jitter_dispatching_switch_label;
#elif defined(JITTER_DISPATCH_DIRECT_THREADING)
  /* Again this code is unreachable, but the compiler does not know it.  FIXME: comment. */
  goto * jitter_ip;
#endif
#ifdef JITTER_REPLICATE
  asm volatile ("\njitter_dispatch_label_asm:\n" :);
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ains));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(and));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aref));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arefo));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arem));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aset));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(asettb));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(atr));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ba__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beghl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(begsc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bn__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnn__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnoti));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzi__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnziu__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzl__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzlu__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bori));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(boriu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsli));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsliu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsll));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsllu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsri));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsriu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxori));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxoriu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzi__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bziu__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzl__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzlu__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(canary));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(close));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ctos));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(disas));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(diviu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop3));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop4));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(duc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endhl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endsc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eql));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqs));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exit));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(flush));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fromr));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gei));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(geiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gel));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gelu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ges));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(getenv));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gti));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gts));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(indent));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iogetb));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosetb));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosize));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isa));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoiu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itol__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itolu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoiu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutol__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutolu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lei));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(leiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lel));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lelu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(les));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lti));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoiu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltol__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltolu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lts));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoiu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutol__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutolu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(map));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetios));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgeto));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgets));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsel));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsiz));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetw));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mka));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mko));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mksct));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktya));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyany));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyo));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktys));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktysct));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyv));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetios));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mseto));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msets));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsel));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsiz));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetw));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muli));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muliu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mull));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mullu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muls));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neglu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nei));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nel));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nelu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nes));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip3));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nn));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nnn));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nop));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(not));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(note__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nrot));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetbt));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(open));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(or));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(osetm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(over));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pec));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdiu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdl__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdlu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeki__nR__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekiu__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekl__nR__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeklu__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeks));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokediu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedl__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedlu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokei__nR__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokeiu__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokel__nR__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokelu__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokes));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pope));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popend));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popf__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popios));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoac));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popob));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popobc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popod));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popom));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoo));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popopp));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popr___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popvar__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printiu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printl__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printlu__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prints));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prolog));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__lR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__lR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushe__lR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushend));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushf__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushhi__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushhi__lR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushios));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushlo__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushlo__lR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoac));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushob));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushobc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushod));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushom));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoo));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushopp));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushtopvar__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n3));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n4));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n5));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n3));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n4));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n5));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(quake));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rand));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(regvar));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reloc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(restorer___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(return));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n3));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n4));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rot));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(saver___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sconc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sel));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(setr___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(siz));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(smodi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sref));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefia));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefio));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefmnt));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefnt));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefo));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sset));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strace__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strref));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subi));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sublu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(substr));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swap));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgti));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtiu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtl));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtlu));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sync));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(time));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tor));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tuck));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagetb));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagett));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyissct));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(typof));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctn));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unmap));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ureloc));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(write__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Aba__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abn__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnn__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzi__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnziu__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzl__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abnzlu__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzi__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abziu__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzl__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abzlu__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(jitter_exit_vm_label);
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(jitter_possibly_restore_registers_and_return_label);
  goto jitter_dispatch_label;
#endif // #ifdef JITTER_REPLICATE

#ifdef JITTER_DISPATCH_SWITCH
  /* This is the dispatching switch.  At the beginning of the first VM
     VM instruction and at the end of each other, control jumps here. */
 jitter_dispatching_switch_label:
  switch (jitter_ip->fixnum)
    {
#endif // #ifdef JITTER_DISPATCH_SWITCH

JITTER_INSTRUCTION_PROLOG_(!INVALID, _eINVALID, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  0
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !INVALID
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eINVALID
{

jitter_fatal ("reached the !INVALID instruction");
}
JITTER_INSTRUCTION_EPILOG_(!INVALID, _eINVALID, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, hot)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  1
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !BEGINBASICBLOCK
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eBEGINBASICBLOCK
{

#ifdef JITTER_DISPATCH_MINIMAL_THREADING
  JITTER_SET_IP (jitter_ip + 1);
#endif // #ifdef JITTER_DISPATCH_MINIMAL_THREADING

}
JITTER_INSTRUCTION_EPILOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!EXITVM, _eEXITVM, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  2
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !EXITVM
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eEXITVM
{

JITTER_EXIT();
}
JITTER_INSTRUCTION_EPILOG_(!EXITVM, _eEXITVM, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!DATALOCATIONS, _eDATALOCATIONS, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  3
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !DATALOCATIONS
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eDATALOCATIONS
{
#ifndef JITTER_DISPATCH_SWITCH
#ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("instruction pointer", jitter_ip);
#endif // #ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("base", jitter_array_base);
#ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_SCRATCH_REGISTER
  JITTER_DATA_LOCATION_DATUM ("scratch", jitter_residual_argument_scratch_register_variable);
#endif // #ifdef JITTER_SCRATCH_REGISTER

#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_DISPATCH_NO_THREADING
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 0", jitter_residual_argument_0_register_variable);
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 1", jitter_residual_argument_1_register_variable);
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 2", jitter_residual_argument_2_register_variable);
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#if    defined(JITTER_DISPATCH_SWITCH)                    \
    || defined(JITTER_DISPATCH_DIRECT_THREADING)          \
    || defined(JITTER_DISPATCH_MINIMAL_THREADING)         \
    || (   defined(JITTER_DISPATCH_NO_THREADING)          \
        && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE))

  JITTER_DATA_LOCATION_DATUM ("link register", jitter_state_runtime._jitter_link);
#endif // link register
  JITTER_DATA_LOCATION_DATUM ("stack top", 
     JITTER_STACK_TOS_TOP_NAME (whatever, jitter_state_runtime., stack));
  JITTER_DATA_LOCATION_DATUM ("stack undertop ptr", 
     JITTER_STACK_TOS_UNDER_TOP_POINTER_NAME (whatever, jitter_state_runtime., stack));
  JITTER_DATA_LOCATION_DATUM ("returnstack top ptr", 
     JITTER_STACK_NTOS_TOP_POINTER_NAME (whatever, jitter_state_runtime., returnstack));
  JITTER_DATA_LOCATION_DATUM ("exceptionstack top ptr", 
     JITTER_STACK_NTOS_TOP_POINTER_NAME (whatever, jitter_state_runtime., exceptionstack));
#endif // #ifndef JITTER_DISPATCH_SWITCH
}
JITTER_INSTRUCTION_EPILOG_(!DATALOCATIONS, _eDATALOCATIONS, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!NOP, _eNOP, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  4
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !NOP
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eNOP
{

  /* Do nothing. */;
}
JITTER_INSTRUCTION_EPILOG_(!NOP, _eNOP, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE0, _eUNREACHABLE0, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  5
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE0
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE0
{

jitter_fatal ("reached the !UNREACHABLE0 instruction");
}
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE0, _eUNREACHABLE0, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE1, _eUNREACHABLE1, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  6
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE1
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE1
{

jitter_fatal ("reached the !UNREACHABLE1 instruction");
}
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE1, _eUNREACHABLE1, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE2, _eUNREACHABLE2, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  7
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE2
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE2
{

jitter_fatal ("reached the !UNREACHABLE2 instruction");
}
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE2, _eUNREACHABLE2, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  /* Ordinary specialized instructions. */
  JITTER_INSTRUCTION_PROLOG_(addi, addi, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       8
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addi

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addi

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for addi . */
#line 2138 "../../libpoke/pvm.jitter"

    PVM_BINOP (INT, INT, INT, +);
  
    /* End of the user code for addi . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the addi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(addi, addi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(addiu, addiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       9
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for addiu . */
#line 2151 "../../libpoke/pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, +);
  
    /* End of the user code for addiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the addiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(addiu, addiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(addl, addl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       10
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for addl . */
#line 2163 "../../libpoke/pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, +);
  
    /* End of the user code for addl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the addl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(addl, addl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(addlu, addlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       11
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for addlu . */
#line 2176 "../../libpoke/pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, +);
  
    /* End of the user code for addlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the addlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(addlu, addlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ains, ains, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       12
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ains

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ains

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ains . */
#line 3976 "../../libpoke/pvm.jitter"

    pvm_val val = JITTER_TOP_STACK ();
    pvm_val idx = JITTER_UNDER_TOP_STACK ();
    pvm_val arr;

    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();
    arr = JITTER_TOP_STACK ();

    if (PVM_VAL_ULONG (idx) < PVM_VAL_ULONG (PVM_VAL_ARR_NELEM (arr)))
      /* Note that pvm_array_set can't return 0 here due
         to the index check.  */
      pvm_array_set (arr, idx, val);
    else
    {
      if (!pvm_array_insert (arr, idx, val))
        PVM_RAISE_DFL (PVM_E_INVAL);
    }
  
    /* End of the user code for ains . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ains argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ains, ains, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(and, and, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       13
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         and

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME and

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for and . */
#line 2981 "../../libpoke/pvm.jitter"

    PVM_BOOL_BINOP (INT, &&);
  
    /* End of the user code for and . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the and argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(and, and, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(aref, aref, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       14
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         aref

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME aref

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for aref . */
#line 4099 "../../libpoke/pvm.jitter"

    pvm_val array = JITTER_UNDER_TOP_STACK ();
    pvm_val index = JITTER_TOP_STACK ();

    if ((PVM_VAL_ULONG (index) >=
            PVM_VAL_INTEGRAL (PVM_VAL_ARR_NELEM (array))))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    JITTER_PUSH_STACK (PVM_VAL_ARR_ELEM_VALUE (array,
                                               PVM_VAL_ULONG (index)));
  
    /* End of the user code for aref . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the aref argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(aref, aref, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(arefo, arefo, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       15
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         arefo

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME arefo

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for arefo . */
#line 4124 "../../libpoke/pvm.jitter"

    pvm_val array = JITTER_UNDER_TOP_STACK ();
    pvm_val index = JITTER_TOP_STACK ();

    if (PVM_VAL_ULONG (index) < 0
        || (PVM_VAL_ULONG (index) >=
            PVM_VAL_INTEGRAL (PVM_VAL_ARR_NELEM (array))))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    JITTER_PUSH_STACK (PVM_VAL_ARR_ELEM_OFFSET (array,
                                                PVM_VAL_ULONG (index)));
  
    /* End of the user code for arefo . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the arefo argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(arefo, arefo, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(arem, arem, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       16
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         arem

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME arem

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for arem . */
#line 4009 "../../libpoke/pvm.jitter"

    pvm_val arr = JITTER_UNDER_TOP_STACK ();
    pvm_val idx = JITTER_TOP_STACK ();

    if (PVM_VAL_ULONG (idx) >= PVM_VAL_ULONG (PVM_VAL_ARR_NELEM (arr)))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    /* This call can't fail (return 0) due to the index check above.  */
    (void) pvm_array_rem (arr, idx);
    JITTER_DROP_STACK ();
  
    /* End of the user code for arem . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the arem argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(arem, arem, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(aset, aset, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       17
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         aset

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME aset

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for aset . */
#line 4036 "../../libpoke/pvm.jitter"

    pvm_val idx;
    pvm_val val;
    pvm_val arr;
    pvm_val array_type, bound;
    size_t index;

    val= JITTER_TOP_STACK ();
    idx = JITTER_UNDER_TOP_STACK ();
    index = PVM_VAL_ULONG (idx);
    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();

    arr = JITTER_TOP_STACK ();

    if (index >= PVM_VAL_INTEGRAL (PVM_VAL_ARR_NELEM (arr)))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    /* If the array is bounded by size, check whether the new value
       results in a different size.  */
    array_type = PVM_VAL_ARR_TYPE (arr);
    bound = PVM_VAL_TYP_A_BOUND (array_type);

    if (PVM_IS_OFF (bound))
      {
        pvm_val oval = PVM_VAL_ARR_ELEM_VALUE (arr, index);
        uint64_t old_size_bits;
        uint64_t new_size_bits;

        PVM_VAL_ARR_ELEM_VALUE (arr, index) = val;

        old_size_bits = (PVM_VAL_INTEGRAL (PVM_VAL_OFF_MAGNITUDE (bound))
                         * PVM_VAL_INTEGRAL (PVM_VAL_OFF_UNIT (bound)));
        new_size_bits = pvm_sizeof (arr);

        if (new_size_bits != old_size_bits)
         {
           PVM_VAL_ARR_ELEM_VALUE (arr, index) = oval;
           PVM_RAISE_DFL (PVM_E_CONV);
         }
      }
   else
      {
        /* Note that pvm_aray_set cannot fail here, due to the check
           on index above.  This is done like this in order to avoid
           checking the bound by size if the index is out of bounds.  */
         pvm_array_set (arr, idx, val);
      }
  
    /* End of the user code for aset . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the aset argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(aset, aset, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(asettb, asettb, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       18
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         asettb

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME asettb

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for asettb . */
#line 4147 "../../libpoke/pvm.jitter"

    pvm_val type = PVM_VAL_ARR_TYPE (JITTER_UNDER_TOP_STACK ());

    PVM_VAL_TYP_A_BOUND (type) = JITTER_TOP_STACK ();
    JITTER_DROP_STACK ();
  
    /* End of the user code for asettb . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the asettb argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(asettb, asettb, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(atr, atr, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       19
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         atr

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME atr

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for atr . */
#line 2120 "../../libpoke/pvm.jitter"

    JITTER_PUSH_STACK (JITTER_TOP_RETURNSTACK ());
  
    /* End of the user code for atr . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the atr argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(atr, atr, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ba/fR, ba__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       20
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ba/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ba__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for ba/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ba/fR . */
#line 3428 "../../libpoke/pvm.jitter"

    JITTER_BRANCH_FAST(JITTER_ARGF0);
  
    /* End of the user code for ba/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ba/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ba/fR, ba__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bandi, bandi, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       21
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandi

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandi

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bandi . */
#line 3122 "../../libpoke/pvm.jitter"

    PVM_BINOP (INT, INT, INT, &);
  
    /* End of the user code for bandi . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bandi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bandi, bandi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bandiu, bandiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       22
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bandiu . */
#line 3135 "../../libpoke/pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, &);
  
    /* End of the user code for bandiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bandiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bandiu, bandiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bandl, bandl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       23
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bandl . */
#line 3147 "../../libpoke/pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, &);
  
    /* End of the user code for bandl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bandl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bandl, bandl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bandlu, bandlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       24
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bandlu . */
#line 3160 "../../libpoke/pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, &);
  
    /* End of the user code for bandlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bandlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bandlu, bandlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beghl, beghl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       25
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beghl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beghl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beghl . */
#line 1690 "../../libpoke/pvm.jitter"

    char *url = PVM_VAL_STR (JITTER_UNDER_TOP_STACK ());
    char *id = PVM_VAL_STR (JITTER_TOP_STACK ());

    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();
    pk_term_hyperlink (url, id);
  
    /* End of the user code for beghl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beghl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beghl, beghl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(begsc, begsc, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       26
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         begsc

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME begsc

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for begsc . */
#line 1728 "../../libpoke/pvm.jitter"

    pk_term_class (PVM_VAL_STR (JITTER_TOP_STACK ()));
    JITTER_DROP_STACK ();
  
    /* End of the user code for begsc . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the begsc argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(begsc, begsc, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bn/fR, bn__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       27
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bn/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bn__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bn/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bn/fR . */
#line 3441 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (tmp != PVM_NULL, JITTER_ARGF0);
  
    /* End of the user code for bn/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bn/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bn/fR, bn__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnn/fR, bnn__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       28
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnn/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnn__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnn/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnn/fR . */
#line 3455 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (tmp == PVM_NULL, JITTER_ARGF0);
  
    /* End of the user code for bnn/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnn/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnn/fR, bnn__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnoti, bnoti, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       29
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnoti

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnoti

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnoti . */
#line 3172 "../../libpoke/pvm.jitter"

    PVM_UNOP (INT, INT, int, ~);
  
    /* End of the user code for bnoti . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnoti argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnoti, bnoti, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnotiu, bnotiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       30
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnotiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnotiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnotiu . */
#line 3185 "../../libpoke/pvm.jitter"

    PVM_UNOP (UINT, UINT, uint, ~);
  
    /* End of the user code for bnotiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnotiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnotiu, bnotiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnotl, bnotl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       31
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnotl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnotl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnotl . */
#line 3197 "../../libpoke/pvm.jitter"

    PVM_UNOP (LONG, LONG, long, ~);
  
    /* End of the user code for bnotl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnotl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnotl, bnotl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnotlu, bnotlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       32
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnotlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnotlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnotlu . */
#line 3209 "../../libpoke/pvm.jitter"

    PVM_UNOP (ULONG, ULONG, ulong, ~);
  
    /* End of the user code for bnotlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnotlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnotlu, bnotlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnzi/fR, bnzi__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       33
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnzi/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnzi__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnzi/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnzi/fR . */
#line 3525 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_NONZERO (PVM_VAL_INT (tmp), JITTER_ARGF0);
  
    /* End of the user code for bnzi/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnzi/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnzi/fR, bnzi__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnziu/fR, bnziu__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       34
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnziu/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnziu__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnziu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnziu/fR . */
#line 3539 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_NONZERO (PVM_VAL_UINT (tmp), JITTER_ARGF0);
  
    /* End of the user code for bnziu/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnziu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnziu/fR, bnziu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnzl/fR, bnzl__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       35
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnzl/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnzl__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnzl/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnzl/fR . */
#line 3553 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_NONZERO (PVM_VAL_LONG (tmp), JITTER_ARGF0);
  
    /* End of the user code for bnzl/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnzl/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnzl/fR, bnzl__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bnzlu/fR, bnzlu__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       36
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnzlu/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnzlu__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnzlu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bnzlu/fR . */
#line 3567 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_NONZERO (PVM_VAL_ULONG (tmp), JITTER_ARGF0);
  
    /* End of the user code for bnzlu/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bnzlu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bnzlu/fR, bnzlu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bori, bori, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       37
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bori

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bori

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bori . */
#line 3073 "../../libpoke/pvm.jitter"

    PVM_BINOP (INT, INT, INT, |);
  
    /* End of the user code for bori . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bori argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bori, bori, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(boriu, boriu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       38
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         boriu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME boriu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for boriu . */
#line 3086 "../../libpoke/pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, |);
  
    /* End of the user code for boriu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the boriu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(boriu, boriu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(borl, borl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       39
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         borl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME borl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for borl . */
#line 3098 "../../libpoke/pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, |);
  
    /* End of the user code for borl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the borl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(borl, borl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(borlu, borlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       40
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         borlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME borlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for borlu . */
#line 3110 "../../libpoke/pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, |);
  
    /* End of the user code for borlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the borlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(borlu, borlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsli, bsli, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       41
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsli

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsli

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsli . */
#line 3229 "../../libpoke/pvm.jitter"

    PVM_BINOP_SL (INT, UINT, INT, <<);
  
    /* End of the user code for bsli . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsli argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsli, bsli, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsliu, bsliu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       42
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsliu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsliu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsliu . */
#line 3247 "../../libpoke/pvm.jitter"

    PVM_BINOP_SL (UINT, UINT, UINT, <<);
  
    /* End of the user code for bsliu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsliu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsliu, bsliu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsll, bsll, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       43
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsll

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsll

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsll . */
#line 3264 "../../libpoke/pvm.jitter"

    PVM_BINOP_SL (LONG, UINT, LONG, <<);
  
    /* End of the user code for bsll . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsll argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsll, bsll, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsllu, bsllu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       44
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsllu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsllu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsllu . */
#line 3282 "../../libpoke/pvm.jitter"

    PVM_BINOP_SL (ULONG, UINT, ULONG, <<);
  
    /* End of the user code for bsllu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsllu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsllu, bsllu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsri, bsri, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       45
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsri

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsri

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsri . */
#line 3295 "../../libpoke/pvm.jitter"

    PVM_BINOP (INT, UINT, INT, >>);
  
    /* End of the user code for bsri . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsri argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsri, bsri, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsriu, bsriu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       46
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsriu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsriu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsriu . */
#line 3308 "../../libpoke/pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, >>);
  
    /* End of the user code for bsriu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsriu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsriu, bsriu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsrl, bsrl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       47
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsrl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsrl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsrl . */
#line 3321 "../../libpoke/pvm.jitter"

    PVM_BINOP (LONG, UINT, LONG, >>);
  
    /* End of the user code for bsrl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsrl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsrl, bsrl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bsrlu, bsrlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       48
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsrlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsrlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bsrlu . */
#line 3334 "../../libpoke/pvm.jitter"

    PVM_BINOP (ULONG, UINT, ULONG, >>);
  
    /* End of the user code for bsrlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bsrlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bsrlu, bsrlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bxori, bxori, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       49
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxori

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxori

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bxori . */
#line 3022 "../../libpoke/pvm.jitter"

    PVM_BINOP (INT, INT, INT, ^);
  
    /* End of the user code for bxori . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bxori argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bxori, bxori, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bxoriu, bxoriu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       50
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxoriu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxoriu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bxoriu . */
#line 3035 "../../libpoke/pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, ^);
  
    /* End of the user code for bxoriu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bxoriu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bxoriu, bxoriu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bxorl, bxorl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       51
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxorl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxorl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bxorl . */
#line 3048 "../../libpoke/pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, ^);
  
    /* End of the user code for bxorl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bxorl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bxorl, bxorl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bxorlu, bxorlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       52
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxorlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxorlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bxorlu . */
#line 3061 "../../libpoke/pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, ^);
  
    /* End of the user code for bxorlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bxorlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bxorlu, bxorlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bzi/fR, bzi__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       53
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bzi/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bzi__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bzi/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bzi/fR . */
#line 3469 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (PVM_VAL_INT (tmp), JITTER_ARGF0);
  
    /* End of the user code for bzi/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bzi/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bzi/fR, bzi__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bziu/fR, bziu__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       54
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bziu/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bziu__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bziu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bziu/fR . */
#line 3483 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (PVM_VAL_UINT (tmp), JITTER_ARGF0);
  
    /* End of the user code for bziu/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bziu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bziu/fR, bziu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bzl/fR, bzl__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       55
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bzl/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bzl__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bzl/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bzl/fR . */
#line 3497 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (PVM_VAL_LONG (tmp), JITTER_ARGF0);
  
    /* End of the user code for bzl/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bzl/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bzl/fR, bzl__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bzlu/fR, bzlu__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       56
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bzlu/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bzlu__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bzlu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bzlu/fR . */
#line 3511 "../../libpoke/pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (PVM_VAL_ULONG (tmp), JITTER_ARGF0);
  
    /* End of the user code for bzlu/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bzlu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bzlu/fR, bzlu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(call/retR, call__retR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a caller.
       Its 0-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
#   define JITTER_BRANCH_AND_LINK      JITTER_BRANCH_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK JITTER_BRANCH_FAST_AND_LINK_INTERNAL

#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       57
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/retR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__retR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
  /* We use the implicit atgument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * _jitter_return_pointer = JITTER_ARGP0;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for call/retR . */
#line 1394 "../../libpoke/pvm.jitter"

    pvm_val closure = JITTER_TOP_STACK ();

    assert (PVM_VAL_CLS_ENV (closure) != NULL);
    JITTER_DROP_STACK ();
    PVM_CALL (closure);
  
    /* End of the user code for call/retR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine macros only visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* Undefine the call/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef JITTER_RETURN_ADDRESS
#endif

 JITTER_INSTRUCTION_EPILOG_(call/retR, call__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(canary, canary, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       58
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         canary

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME canary

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for canary . */
#line 720 "../../libpoke/pvm.jitter"

     JITTER_STATE_BACKING_FIELD (canary) = JITTER_HEIGHT_STACK ();
  
    /* End of the user code for canary . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the canary argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(canary, canary, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(close, close, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       59
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         close

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME close

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for close . */
#line 1225 "../../libpoke/pvm.jitter"

    int io_id = PVM_VAL_INT (JITTER_TOP_STACK ());
    ios io = ios_search_by_id (io_id);

    if (io == NULL)
      PVM_RAISE_DFL (PVM_E_IO);

    ios_close (io);
    JITTER_DROP_STACK ();
  
    /* End of the user code for close . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the close argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(close, close, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ctos, ctos, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       60
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ctos

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ctos

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ctos . */
#line 3584 "../../libpoke/pvm.jitter"

    uint8_t c = PVM_VAL_UINT (JITTER_TOP_STACK ());
    char *str = pvm_alloc (2);
    str[0] = c;
    str[1] = '\0';

    JITTER_PUSH_STACK (pvm_make_string (str));
  
    /* End of the user code for ctos . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ctos argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ctos, ctos, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(disas, disas, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       61
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         disas

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME disas

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for disas . */
#line 5491 "../../libpoke/pvm.jitter"

    pvm_val cls = JITTER_TOP_STACK ();
    pvm_disassemble_program (PVM_VAL_CLS_PROGRAM (cls));
  
    /* End of the user code for disas . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the disas argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(disas, disas, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(divi, divi, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       62
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divi

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divi

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for divi . */
#line 2295 "../../libpoke/pvm.jitter"

    PVM_CHECKED_BINOP (INT, INT, INT, /);
  
    /* End of the user code for divi . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the divi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(divi, divi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(diviu, diviu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       63
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         diviu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME diviu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for diviu . */
#line 2310 "../../libpoke/pvm.jitter"

    PVM_CHECKED_BINOP (UINT, UINT, UINT, /);
  
    /* End of the user code for diviu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the diviu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(diviu, diviu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(divl, divl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       64
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for divl . */
#line 2324 "../../libpoke/pvm.jitter"

    PVM_CHECKED_BINOP (LONG, LONG, LONG, /);
  
    /* End of the user code for divl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the divl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(divl, divl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(divlu, divlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       65
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for divlu . */
#line 2339 "../../libpoke/pvm.jitter"

    PVM_CHECKED_BINOP (ULONG, ULONG, ULONG, /);
  
    /* End of the user code for divlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the divlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(divlu, divlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(drop, drop, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       66
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for drop . */
#line 1774 "../../libpoke/pvm.jitter"

    JITTER_DROP_STACK();
  
    /* End of the user code for drop . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the drop argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(drop, drop, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(drop2, drop2, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       67
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop2

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop2

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for drop2 . */
#line 1786 "../../libpoke/pvm.jitter"

    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
  
    /* End of the user code for drop2 . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the drop2 argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(drop2, drop2, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(drop3, drop3, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       68
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop3

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop3

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for drop3 . */
#line 1799 "../../libpoke/pvm.jitter"

    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
  
    /* End of the user code for drop3 . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the drop3 argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(drop3, drop3, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(drop4, drop4, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       69
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop4

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop4

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for drop4 . */
#line 1813 "../../libpoke/pvm.jitter"

    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
  
    /* End of the user code for drop4 . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the drop4 argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(drop4, drop4, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(duc, duc, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       70
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         duc

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME duc

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for duc . */
#line 1561 "../../libpoke/pvm.jitter"

    pvm_val cls = JITTER_TOP_STACK ();
    pvm_val new_cls = pvm_make_cls (PVM_VAL_CLS_PROGRAM (cls));

    JITTER_DROP_STACK ();
    JITTER_PUSH_STACK (new_cls);
  
    /* End of the user code for duc . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the duc argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(duc, duc, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(dup, dup, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       71
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         dup

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME dup

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for dup . */
#line 1881 "../../libpoke/pvm.jitter"

    JITTER_DUP_STACK ();
  
    /* End of the user code for dup . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the dup argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(dup, dup, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(endhl, endhl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       72
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         endhl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME endhl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for endhl . */
#line 1711 "../../libpoke/pvm.jitter"

    if (!pk_term_end_hyperlink ())
      PVM_RAISE (PVM_E_GENERIC,
                 "no current hyperlink",
                 PVM_E_GENERIC_ESTATUS);
  
    /* End of the user code for endhl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the endhl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(endhl, endhl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(endsc, endsc, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       73
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         endsc

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME endsc

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for endsc . */
#line 1742 "../../libpoke/pvm.jitter"

    if (!pk_term_end_class (PVM_VAL_STR (JITTER_TOP_STACK ())))
      PVM_RAISE (PVM_E_INVAL,
                 "invalid class",
                 PVM_E_INVAL_ESTATUS);
    JITTER_DROP_STACK ();
  
    /* End of the user code for endsc . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the endsc argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(endsc, endsc, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(eqi, eqi, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       74
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqi

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqi

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for eqi . */
#line 2520 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (INT, ==);
  
    /* End of the user code for eqi . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the eqi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(eqi, eqi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(eqiu, eqiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       75
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for eqiu . */
#line 2533 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (UINT, ==);
  
    /* End of the user code for eqiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the eqiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(eqiu, eqiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(eql, eql, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       76
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eql

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eql

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for eql . */
#line 2546 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (LONG, ==);
  
    /* End of the user code for eql . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the eql argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(eql, eql, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(eqlu, eqlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       77
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for eqlu . */
#line 2559 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (ULONG, ==);
  
    /* End of the user code for eqlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the eqlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(eqlu, eqlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(eqs, eqs, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       78
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqs

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqs

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for eqs . */
#line 2572 "../../libpoke/pvm.jitter"

    pvm_val res = PVM_MAKE_INT (STREQ (PVM_VAL_STR (JITTER_UNDER_TOP_STACK ()),
                                       PVM_VAL_STR (JITTER_TOP_STACK ())),
                                32);
    JITTER_PUSH_STACK (res);
  
    /* End of the user code for eqs . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the eqs argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(eqs, eqs, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(exit, exit, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       79
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         exit

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME exit

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for exit . */
#line 733 "../../libpoke/pvm.jitter"

    /* The element at the top of the stack is the exit
       code to report to the PVM caller.  */
    JITTER_STATE_BACKING_FIELD (exit_code)
      = PVM_VAL_INT (JITTER_TOP_STACK());

    JITTER_DROP_STACK ();

    /* Get the result of the execution, if any.  */
    JITTER_STATE_BACKING_FIELD (result_value)
                = JITTER_TOP_STACK();
    JITTER_DROP_STACK ();

    /* Check for the stack centinel, but only if it was
       installed.  */
    if (JITTER_STATE_BACKING_FIELD (canary) != NULL)
      assert (JITTER_STATE_BACKING_FIELD (canary)
              == JITTER_HEIGHT_STACK ());

    /* Clear pending signals.  */
    {
      int i;
      for (i = 0; i < JITTER_SIGNAL_NO; i ++)
        if (JITTER_PENDING_SIGNAL_NOTIFICATION (i))
          JITTER_PENDING_SIGNAL_NOTIFICATION (i) = false;
      JITTER_PENDING_NOTIFICATIONS = false;
    }

    JITTER_EXIT ();
  
    /* End of the user code for exit . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the exit argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(exit, exit, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(exitvm, exitvm, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       80
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         exitvm

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME exitvm

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for exitvm . */
JITTER_EXIT();
    /* End of the user code for exitvm . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the exitvm argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(exitvm, exitvm, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(flush, flush, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       81
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         flush

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME flush

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for flush . */
#line 1250 "../../libpoke/pvm.jitter"

    ios_off offset = PVM_VAL_ULONG (JITTER_TOP_STACK ());
    int io_id = PVM_VAL_INT (JITTER_UNDER_TOP_STACK ());
    ios io = ios_search_by_id (io_id);

    if (io == NULL)
      PVM_RAISE_DFL (PVM_E_IO);

    if (ios_flush (io, offset) != IOS_OK)
      PVM_RAISE_DFL (PVM_E_IO);

    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();
  
    /* End of the user code for flush . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the flush argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(flush, flush, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(fromr, fromr, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       82
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         fromr

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME fromr

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for fromr . */
#line 2106 "../../libpoke/pvm.jitter"

    JITTER_PUSH_STACK (JITTER_TOP_RETURNSTACK ());
    JITTER_DROP_RETURNSTACK ();
  
    /* End of the user code for fromr . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the fromr argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(fromr, fromr, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gei, gei, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       83
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gei

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gei

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gei . */
#line 2840 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (INT, >=);
  
    /* End of the user code for gei . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gei argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gei, gei, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(geiu, geiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       84
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         geiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME geiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for geiu . */
#line 2854 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (UINT, >=);
  
    /* End of the user code for geiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the geiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(geiu, geiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gel, gel, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       85
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gel

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gel

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gel . */
#line 2867 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (LONG, >=);
  
    /* End of the user code for gel . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gel argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gel, gel, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gelu, gelu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       86
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gelu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gelu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gelu . */
#line 2880 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (ULONG, >=);
  
    /* End of the user code for gelu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gelu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gelu, gelu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ges, ges, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       87
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ges

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ges

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ges . */
#line 2924 "../../libpoke/pvm.jitter"

    pvm_val res = PVM_MAKE_INT (strcmp (PVM_VAL_STR (JITTER_UNDER_TOP_STACK ()),
                                        PVM_VAL_STR (JITTER_TOP_STACK ())) >= 0, 32);
    JITTER_PUSH_STACK (res);
  
    /* End of the user code for ges . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ges argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ges, ges, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(getenv, getenv, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       88
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         getenv

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME getenv

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for getenv . */
#line 5525 "../../libpoke/pvm.jitter"

    const char *varname = PVM_VAL_STR (JITTER_TOP_STACK ());
    char *value = secure_getenv (varname);

    if (value == NULL)
      JITTER_PUSH_STACK (PVM_NULL);
    else
      JITTER_PUSH_STACK (pvm_make_string (value));
  
    /* End of the user code for getenv . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the getenv argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(getenv, getenv, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gti, gti, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       89
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gti

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gti

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gti . */
#line 2788 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (INT, >);
  
    /* End of the user code for gti . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gti argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gti, gti, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gtiu, gtiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       90
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gtiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gtiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gtiu . */
#line 2801 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (UINT, >);
  
    /* End of the user code for gtiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gtiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gtiu, gtiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gtl, gtl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       91
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gtl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gtl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gtl . */
#line 2814 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (LONG, >);
  
    /* End of the user code for gtl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gtl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gtl, gtl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gtlu, gtlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       92
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gtlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gtlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gtlu . */
#line 2827 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (ULONG, >);
  
    /* End of the user code for gtlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gtlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gtlu, gtlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(gts, gts, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       93
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         gts

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME gts

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for gts . */
#line 2908 "../../libpoke/pvm.jitter"

    pvm_val res = PVM_MAKE_INT (strcmp (PVM_VAL_STR (JITTER_UNDER_TOP_STACK ()),
                                        PVM_VAL_STR (JITTER_TOP_STACK ())) > 0, 32);
    JITTER_PUSH_STACK (res);
  
    /* End of the user code for gts . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the gts argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(gts, gts, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(indent, indent, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       94
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         indent

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME indent

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for indent . */
#line 1606 "../../libpoke/pvm.jitter"

    pk_term_indent (PVM_VAL_INT (JITTER_UNDER_TOP_STACK ()),
                    PVM_VAL_INT (JITTER_TOP_STACK ()));
    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();
  
    /* End of the user code for indent . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the indent argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(indent, indent, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iogetb, iogetb, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       95
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iogetb

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iogetb

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iogetb . */
#line 1341 "../../libpoke/pvm.jitter"

    ios io = ios_search_by_id (PVM_VAL_INT (JITTER_TOP_STACK ()));

    if (io == NULL)
      PVM_RAISE_DFL (PVM_E_NO_IOS);

    JITTER_PUSH_STACK (pvm_make_offset (PVM_MAKE_ULONG (ios_get_bias (io), 64),
                                        PVM_MAKE_ULONG (1, 64)));
  
    /* End of the user code for iogetb . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iogetb argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iogetb, iogetb, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iosetb, iosetb, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       96
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iosetb

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iosetb

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iosetb . */
#line 1366 "../../libpoke/pvm.jitter"

    pvm_val bias = JITTER_TOP_STACK();
    ios io = ios_search_by_id (PVM_VAL_INT (JITTER_UNDER_TOP_STACK ()));

    JITTER_DROP_STACK ();

    if (io == NULL)
      PVM_RAISE_DFL (PVM_E_NO_IOS);

    ios_set_bias (io,
                  (PVM_VAL_INTEGRAL (PVM_VAL_OFF_MAGNITUDE (bias))
                   * PVM_VAL_INTEGRAL (PVM_VAL_OFF_UNIT (bias))));
  
    /* End of the user code for iosetb . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iosetb argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iosetb, iosetb, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iosize, iosize, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       97
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iosize

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iosize

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iosize . */
#line 1315 "../../libpoke/pvm.jitter"

    ios io = ios_search_by_id (PVM_VAL_INT (JITTER_TOP_STACK ()));

    if (io == NULL)
      PVM_RAISE_DFL (PVM_E_NO_IOS);

    JITTER_PUSH_STACK (pvm_make_offset (PVM_MAKE_ULONG (ios_size (io), 64),
                                        PVM_MAKE_ULONG (1, 64)));
  
    /* End of the user code for iosize . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iosize argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iosize, iosize, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(isa, isa, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       98
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         isa

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME isa

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for isa . */
#line 4815 "../../libpoke/pvm.jitter"

    pvm_val type = JITTER_TOP_STACK ();
    pvm_val val = JITTER_UNDER_TOP_STACK ();
    pvm_val val_type = pvm_typeof (val);

    JITTER_PUSH_STACK (PVM_MAKE_INT (pvm_type_equal_p (type, val_type),
                                     32));
  
    /* End of the user code for isa . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the isa argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(isa, isa, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(itoi/nR, itoi__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       99
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         itoi/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME itoi__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for itoi/nR . */
#line 3604 "../../libpoke/pvm.jitter"

    PVM_CONVOP (INT, int32_t, int, int32_t);
  
    /* End of the user code for itoi/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the itoi/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(itoi/nR, itoi__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(itoiu/nR, itoiu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       100
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         itoiu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME itoiu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for itoiu/nR . */
#line 3619 "../../libpoke/pvm.jitter"

    PVM_CONVOP (INT, int32_t, uint, uint32_t);
  
    /* End of the user code for itoiu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the itoiu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(itoiu/nR, itoiu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(itol/nR, itol__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       101
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         itol/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME itol__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for itol/nR . */
#line 3634 "../../libpoke/pvm.jitter"

    PVM_CONVOP (INT, int32_t, long, int64_t);
  
    /* End of the user code for itol/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the itol/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(itol/nR, itol__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(itolu/nR, itolu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       102
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         itolu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME itolu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for itolu/nR . */
#line 3649 "../../libpoke/pvm.jitter"

    PVM_CONVOP (INT, int32_t, ulong, uint64_t);
  
    /* End of the user code for itolu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the itolu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(itolu/nR, itolu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iutoi/nR, iutoi__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       103
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iutoi/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iutoi__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iutoi/nR . */
#line 3664 "../../libpoke/pvm.jitter"

    PVM_CONVOP (UINT, uint32_t, int, int32_t);
  
    /* End of the user code for iutoi/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iutoi/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iutoi/nR, iutoi__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iutoiu/nR, iutoiu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       104
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iutoiu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iutoiu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iutoiu/nR . */
#line 3679 "../../libpoke/pvm.jitter"

    PVM_CONVOP (UINT, uint32_t, uint, uint32_t);
  
    /* End of the user code for iutoiu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iutoiu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iutoiu/nR, iutoiu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iutol/nR, iutol__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       105
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iutol/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iutol__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iutol/nR . */
#line 3694 "../../libpoke/pvm.jitter"

    PVM_CONVOP (UINT, uint32_t, long, int64_t);
  
    /* End of the user code for iutol/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iutol/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iutol/nR, iutol__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(iutolu/nR, iutolu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       106
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         iutolu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME iutolu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for iutolu/nR . */
#line 3709 "../../libpoke/pvm.jitter"

    PVM_CONVOP (UINT, uint32_t, ulong, uint64_t);
  
    /* End of the user code for iutolu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the iutolu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(iutolu/nR, iutolu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lei, lei, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       107
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lei

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lei

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lei . */
#line 2736 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (INT, <=);
  
    /* End of the user code for lei . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lei argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lei, lei, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(leiu, leiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       108
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         leiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME leiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for leiu . */
#line 2749 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (UINT, <=);
  
    /* End of the user code for leiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the leiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(leiu, leiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lel, lel, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       109
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lel

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lel

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lel . */
#line 2762 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (LONG, <=);
  
    /* End of the user code for lel . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lel argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lel, lel, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lelu, lelu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       110
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lelu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lelu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lelu . */
#line 2775 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (ULONG, <=);
  
    /* End of the user code for lelu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lelu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lelu, lelu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(les, les, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       111
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         les

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME les

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for les . */
#line 2940 "../../libpoke/pvm.jitter"

    pvm_val res = PVM_MAKE_INT (strcmp (PVM_VAL_STR (JITTER_UNDER_TOP_STACK ()),
                                        PVM_VAL_STR (JITTER_TOP_STACK ())) <= 0, 32);
    JITTER_PUSH_STACK (res);
  
    /* End of the user code for les . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the les argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(les, les, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lti, lti, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       112
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lti

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lti

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lti . */
#line 2684 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (INT, <);
  
    /* End of the user code for lti . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lti argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lti, lti, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltiu, ltiu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       113
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltiu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltiu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltiu . */
#line 2697 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (UINT, <);
  
    /* End of the user code for ltiu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltiu, ltiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltl, ltl, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       114
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltl

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltl

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltl . */
#line 2710 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (LONG, <);
  
    /* End of the user code for ltl . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltl, ltl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltlu, ltlu, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       115
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltlu

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltlu

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltlu . */
#line 2723 "../../libpoke/pvm.jitter"

     PVM_BOOL_BINOP (ULONG, <);
  
    /* End of the user code for ltlu . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltlu, ltlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltoi/nR, ltoi__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       116
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltoi/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltoi__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltoi/nR . */
#line 3724 "../../libpoke/pvm.jitter"

    PVM_CONVOP (LONG, int64_t, int, int32_t);
  
    /* End of the user code for ltoi/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltoi/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltoi/nR, ltoi__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltoiu/nR, ltoiu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       117
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltoiu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltoiu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltoiu/nR . */
#line 3739 "../../libpoke/pvm.jitter"

    PVM_CONVOP (LONG, int64_t, uint, uint32_t);
  
    /* End of the user code for ltoiu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltoiu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltoiu/nR, ltoiu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltol/nR, ltol__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       118
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltol/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltol__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltol/nR . */
#line 3754 "../../libpoke/pvm.jitter"

    PVM_CONVOP (LONG, int64_t, long, int64_t);
  
    /* End of the user code for ltol/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltol/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltol/nR, ltol__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(ltolu/nR, ltolu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       119
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ltolu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ltolu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for ltolu/nR . */
#line 3769 "../../libpoke/pvm.jitter"

    PVM_CONVOP (LONG, int64_t, ulong, uint64_t);
  
    /* End of the user code for ltolu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the ltolu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(ltolu/nR, ltolu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lts, lts, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       120
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lts

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lts

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lts . */
#line 2893 "../../libpoke/pvm.jitter"

    pvm_val res = PVM_MAKE_INT (strcmp (PVM_VAL_STR (JITTER_UNDER_TOP_STACK ()),
                                        PVM_VAL_STR (JITTER_TOP_STACK ())) < 0, 32);
    JITTER_PUSH_STACK (res);
  
    /* End of the user code for lts . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lts argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lts, lts, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lutoi/nR, lutoi__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       121
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lutoi/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lutoi__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lutoi/nR . */
#line 3784 "../../libpoke/pvm.jitter"

    PVM_CONVOP (ULONG, uint64_t, int, int32_t);
  
    /* End of the user code for lutoi/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lutoi/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lutoi/nR, lutoi__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lutoiu/nR, lutoiu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       122
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lutoiu/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lutoiu__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lutoiu/nR . */
#line 3799 "../../libpoke/pvm.jitter"

    PVM_CONVOP (ULONG, uint64_t, uint, uint32_t);
  
    /* End of the user code for lutoiu/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lutoiu/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lutoiu/nR, lutoiu__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lutol/nR, lutol__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       123
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         lutol/nR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME lutol__nR

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for lutol/nR . */
#line 3812 "../../libpoke/pvm.jitter"

    PVM_CONVOP (ULONG, uint64_t, long, int64_t);
  
    /* End of the user code for lutol/nR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the lutol/nR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(lutol/nR, lutol__nR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(lutolu/nR, lutolu__nR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITT