/* jitter/jitter-config.h.  Generated from jitter-config.h.in by configure.  */
/* Jitter: host configuration header to install.

   Copyright (C) 2017, 2019, 2020 Luca Saiu
   Written by Luca Saiu

   This file is part of Jitter.

   Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jitter.  If not, see <http://www.gnu.org/licenses/>. */


#ifndef JITTER_CONFIG_H_
#define JITTER_CONFIG_H_

/* This host-dependent file is installed and used in the definition of some
   fundamental types or features.  Macro names have a JITTER_ prefix in order to
   be safe for user code and prevent clashes.

   All of this is particularly useful for generated C code and templates, which
   must rely on information from an installed header rather than a configuration
   script.

   This file is included from both C and assembly, so it must contain only
   whitespace and preprocessor directives.  In particular, differenly from the
   purely C source files in Jitter, it does not use "" characters for
   sectioning. */


/* Data representation.
 * ************************************************************************** */

/* #undef JITTER_WORDS_BIGENDIAN */


/* C types and data representation: type availability, size, alignment.
 * ************************************************************************** */

#define JITTER_HAVE_LONG_LONG_INT 1
#define JITTER_HAVE_UNSIGNED_LONG_LONG_INT 1
#define JITTER_HAVE_LONG_DOUBLE 1

#define JITTER_SIZEOF_VOID_P 8
#define JITTER_SIZEOF_SHORT 2
#define JITTER_SIZEOF_INT 4
#define JITTER_SIZEOF_LONG 8
#define JITTER_SIZEOF_LONG_LONG 8

#define JITTER_SIZEOF_FLOAT 4
#define JITTER_SIZEOF_DOUBLE 8
#define JITTER_SIZEOF_LONG_DOUBLE 16

#define JITTER_ALIGNOF_VOID_P 8
#define JITTER_ALIGNOF_VOID_P_P 8
#define JITTER_ALIGNOF_SHORT 2
#define JITTER_ALIGNOF_INT 4
#define JITTER_ALIGNOF_LONG 8
#define JITTER_ALIGNOF_LONG_LONG 8

#define JITTER_ALIGNOF_FLOAT 4
#define JITTER_ALIGNOF_DOUBLE 8
#define JITTER_ALIGNOF_LONG_DOUBLE 16


/* Machine features.
 * ************************************************************************** */

#define JITTER_HAVE_ASSEMBLY 1
/* #undef JITTER_ENABLE_ASSEMBLY */

/* Define if we know how to do things like switching sections and defining
   globals from inline assembly for this configuration. */
#define JITTER_HAVE_KNOWN_BINARY_FORMAT 1

/* It is convenient to let C code access the architecture name. */
#define JITTER_ASSEMBLY_SUBDIRECTORY "x86_64"


/* CPU architecture.
 * ************************************************************************** */

/* Define a CPU (architecture)-specific macro if the CPU is known and the
   user did not disable assembly support.  Not every architecture mentioned
   here has specific support, but this is still useful even for user code
   when deciding whether to enable optional optimisations, which can be
   achieved without need for configuration facilities other than what
   Jitter already provides.
   Where an architecture has 32-bit and 64-bit variants one macro is defined
   for both when the 64-bit variant is a very similar clean extension, as
   is the case for example with RISC-V, MIPS and PowerPC; the user may then
   conditionalise on JITTER_BYTES_PER_WORD (which is a CPP-time constant) if
   needed. 
   When the two variants of an architecture are radically different and
   incompatible two different macros are used here. */

/* Define if the CPU is Aarch64. */
/* #undef JITTER_HOST_CPU_IS_AARCH64 */

/* Define if the CPU is Alpha. */
/* #undef JITTER_HOST_CPU_IS_ALPHA */

/* Define if the CPU is a 32-bit ARM.  The 64-bit version, Aarch64, is so
   different that it would make little sense to define one macro for both. */
/* #undef JITTER_HOST_CPU_IS_ARM */

/* Define if the CPU is i386.  This is for 32-bit configurations only. */
/* #undef JITTER_HOST_CPU_IS_I386 */

/* Define if the CPU is some m68k variant. */
/* #undef JITTER_HOST_CPU_IS_M68K */

/* Define if the CPU is a MIPS, either 32-bit or 64-bit. */
/* #undef JITTER_HOST_CPU_IS_MIPS */

/* Define if the CPU is a MIPS, either 32-bit or 64-bit, release 6 or later.
   Release 6 introduces many useful but incompatible changes. */
/* #undef JITTER_HOST_CPU_IS_MIPS_R6_OR_LATER */

/* Define if the CPU is a PA-RISC, either 32-bit or 64-bit. */
/* #undef JITTER_HOST_CPU_IS_PARISC */

/* Define if the CPU is some POWER or PowerPC variant, either 32-bit or
   64-bit. */
/* #undef JITTER_HOST_CPU_IS_POWERPC */

/* Define if the CPU is RISC-V, either 32-bit or 64-bit. */
/* #undef JITTER_HOST_CPU_IS_RISCV */

/* Define if the CPU is any variant of S390. */
/* #undef JITTER_HOST_CPU_IS_S390 */

/* Define if the CPU is some SH variant. */
/* #undef JITTER_HOST_CPU_IS_SH */

/* Define if the CPU is some SPARC variant, either 32-bit or 64-bit. */
/* #undef JITTER_HOST_CPU_IS_SPARC */

/* Define if the CPU is x86_64. */
#define JITTER_HOST_CPU_IS_X86_64 1


/* Operating system features.
 * ************************************************************************** */

/* System triplets. */
#define JITTER_HOST_TRIPLET "x86_64-pc-linux-gnu"
#define JITTER_BUILD_TRIPLET "x86_64-pc-linux-gnu"

#define JITTER_HOST_OS_IS_GNU 1
/* #undef JITTER_HOST_OS_IS_GNU_HURD */
/* #undef JITTER_HOST_OS_IS_GNU_LINUX */
/* #undef JITTER_HOST_OS_IS_FREEBSD */
/* #undef JITTER_HOST_OS_IS_NETBSD */
/* #undef JITTER_HOST_OS_IS_OPENBSD */
/* #undef JITTER_HOST_OS_IS_WINDOWS */

/* Binary format.  ELF support may be disabled even on ELF systems, if the
   tools are old enough not to support .pushsection / .popsection with
   subsection numbers. */
#define JITTER_HOST_OS_IS_ELF 1
/* #undef JITTER_HOST_OS_IS_COFF */
/* #undef JITTER_HOST_OS_IS_MACHO */
#define JITTER_HAVE_SECTION_NOTE_GNU_STACK 1

/* Assembler flavor. */
#define JITTER_HOST_ASSEMBLER_IS_GNU 1


/* Libc features.
 * ************************************************************************** */

/* See configure.ac for the meaning of each macro. */

/* C functions or features. */
#define JITTER_HAVE_MMAP_ANONYMOUS 1
#define JITTER_HAVE_MPROTECT 1
#define JITTER_HAVE_SETRLIMIT 1
#define JITTER_HAVE_ALARM 1
#define JITTER_HAVE_ALIGNED_ALLOC 1
#define JITTER_HAVE_POSIX_MEMALIGN 1
#define JITTER_HAVE_FLOCKFILE 1
#define JITTER_HAVE_POPEN 1
#define JITTER_HAVE_SIGACTION 1
#define JITTER_HAVE_CLOCK_GETTIME 1
#define JITTER_HAVE_SETITIMER 1
#define JITTER_HAVE_SYSCONF 1
#define JITTER_HAVE_GETPAGESIZE 1

/* Arguments for sysconf. */
#define JITTER_HAVE__SC_PAGESIZE 1
#define JITTER_HAVE__SC_PHYS_PAGES 1
#define JITTER_HAVE__SC_AVPHYS_PAGES 1
#define JITTER_HAVE__SC_NPROCESSORS_CONF 1
#define JITTER_HAVE__SC_NPROCESSORS_ONLN 1
#define JITTER_HAVE__SC_LEVEL1_ICACHE_SIZE 1
#define JITTER_HAVE__SC_LEVEL1_DCACHE_SIZE 1
#define JITTER_HAVE__SC_LEVEL2_CACHE_SIZE 1
#define JITTER_HAVE__SC_LEVEL3_CACHE_SIZE 1
#define JITTER_HAVE__SC_LEVEL4_CACHE_SIZE 1


/* External library availability.
 * ************************************************************************** */

/* This macro is defined iff GNU Readline is available, in which case the
   separate library libjitter-readline will be a wrapper using the actual
   library and depending on it; otherwise the wrapper library will use its own
   compatible but crude replacement.
   The convenient way of linking libjitter-readline (along with the actual GNU
   Readline library, when used) is by using
     jitter-config
   or the substitutions defined by AC_JITTER and AC_JITTER_SUBPACKAGE . */
#define JITTER_HAVE_READLINE 1

/* This macro is defined iff GNU Libtextstyle is available, in which case the
   separate wrapper library libjitter-libtextstyle is also built.  However,
   since Libtextstyle is a large library and its usage should remain optional,
   having JITTER_HAVE_LIBTEXTSTYLE defined is not enough to actually enable
   its functionality.
   The user should define
     JITTER_WITH_LIBTEXTSTYLE
   on the command line *and* have JITTER_HAVE_LIBTEXTSTYLE defined in order for
   the functionality to be actually used. The convenient way of doing this is
   by using
     jitter-config
   or the substitutions defined by AC_JITTER and AC_JITTER_SUBPACKAGE . 
   User code should conditionalise using only JITTER_WITH_LIBTEXTSTYLE : it is
   the build system's responsibility to define
     JITTER_WITH_LIBTEXTSTYLE
   on the command line only when the configuration supports it. */
#define JITTER_HAVE_LIBTEXTSTYLE 1


/* External utility availability, features and options.
 * ************************************************************************** */

#define JITTER_OBJDUMP "/usr/bin/objdump"
#define JITTER_CROSS_OBJDUMP "objdump"
#define JITTER_OBJDUMP_OPTIONS "--architecture=i386:x86-64 --disassembler-options=x86-64,att,suffix"


/* Jitter feature selection.
 * ************************************************************************** */

/* What the best dispatch is. */
/* #undef JITTER_BEST_DISPATCHING_MODEL_IS_SWITCH */
#define JITTER_BEST_DISPATCHING_MODEL_IS_DIRECT_THREADING 1
/* #undef JITTER_BEST_DISPATCHING_MODEL_IS_MINIMAL_THREADING */
/* #undef JITTER_BEST_DISPATCHING_MODEL_IS_NO_THREADING */


/* Versioning.
 * ************************************************************************** */

/* Information about Jitter, to be printed out to the user. */
#define JITTER_PACKAGE_NAME "Jitter"
#define JITTER_PACKAGE_VERSION "0.9.251"
#define JITTER_PACKAGE_BUGREPORT "bug-epsilon@gnu.org"

/* Notice that JITTER_DISPATCH_NAME_STRING , not defined here but available from
   jitter/jitter.h , will also be appropriate to print, particularly for user
   bug reports. */


/* Availability of GNU C features.
 * ************************************************************************** */

/* Define if the compiler is actually GCC, rather then some other compiler
   falsely claiming compatibility. */
#define JITTER_HAVE_ACTUAL_GCC 1

/* Define to the GCC version, when GCC is being used. */
#define JITTER_GCC_MAJOR_VERSION 6
#define JITTER_GCC_MINOR_VERSION 3
#define JITTER_GCC_PATCHLEVEL_VERSION 0
#define JITTER_GCC_COMBINED_VERSION 60300

/* Define if the compiler is clang.  Notice that we discourage the use of clang
   as a non-copylefted project with a copyleft alternative.  Jitter recommends
   GCC, which will be the only compiler supporting advanced dispatches. */
/* #undef JITTER_HAVE_CLANG */

/* Define to the clang version, when clang is being used. */
/* #undef JITTER_CLANG_MAJOR_VERSION */
/* #undef JITTER_CLANG_MINOR_VERSION */
/* #undef JITTER_CLANG_PATCHLEVEL_VERSION */
/* #undef JITTER_CLANG_COMBINED_VERSION */

/* Define if the language supports mixing declarations and statements, as
   standard in C since 1999 and widely supported even earlier.  If this is not
   defined I expect major problems, and the compiler will not be supported.
   This is mostly intended to be checked in bug reports. */
#define JITTER_HAVE_MIXED_DECLARATIONS_AND_STATEMENTS 1

/* Define if the language supports statement expressions in the style of GNU C. */
#define JITTER_HAVE_GNU_C_STATEMENT_EXPRESSIONS 1

/* Define if the language supports computed goto in the style of GNU C. */
#define JITTER_HAVE_GNU_C_COMPUTED_GOTO 1

/* Define if the language supports GNU C's inline asm, including the modern
   syntax for named operands. */
#define JITTER_HAVE_GNU_C_INLINE_ASM 1

/* Define if the language supports asm goto in the style of GNU C. */
#define JITTER_HAVE_GNU_C_ASM_GOTO 1

/* Define if the compiler supports alignas. */
#define JITTER_HAVE_ALIGNAS 1

/* Define if the library/compiler supports offsetof. */
#define JITTER_HAVE_OFFSETOF 1

/* Define if the builtins for handling overflow are available. */
/* #undef JITTER_HAVE_GCC_OVERFLOW_CHECKING */

/* Define if __builtin_constant_p is available. */
#define JITTER_HAVE_GCC_BUILTIN_CONSTANT_P 1

/* Define if __builtin_expect is available. */
#define JITTER_HAVE_GCC_BUILTIN_EXPECT 1

/* Define if __builtin_unreachable is available. */
#define JITTER_HAVE_GCC_BUILTIN_UNREACHABLE 1

/* Define if the C compilers supports GNU C attributes. */
#define JITTER_HAVE_GNU_C_ATTRIBUTE 1

/* Define for specific GNU C attributes. */
#define JITTER_HAVE_ATTRIBUTE_RETURNS_NONNULL 1


/* Optimization: machine-specific alternatives.
 * ************************************************************************** */

/* Define if a conditional expression based on the negative sign can be compiled
   more efficiently without branches. */
/* #undef JITTER_HAVE_FAST_STRAIGHT_LINE_NEGATIVITY */

/* Define if there is an efficient way of masking off low-order bits by and-ing
   with a sign-extended immediate, or another one-instruction equivalent
   operation. */
#define JITTER_HAVE_FAST_MASK_OFF 1

#endif // #ifndef JITTER_CONFIG_H_
