## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, ...
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the sunspots dataset from R’s datasets package

classdef sunspots < octave.internal.dataset

  methods

    function this = sunspots
      this.name = "sunspots";
      this.summary = "Monthly Sunspot Numbers, 1749-1983";
    endfunction

    function out = load (this)
      month = [datetime(1749, 1, 1):calmonths(1):datetime(1983, 12, 1)]';
      sunspots = [58, 62.6, 70, 55.7, 85, 83.5, 94.8, 66.3, 75.9, 75.5, ...
        158.6, 85.2, 73.3, 75.9, 89.2, 88.3, 90, 100, 85.4, 103, 91.2, ...
        65.7, 63.3, 75.4, 70, 43.5, 45.3, 56.4, 60.7, 50.7, 66.3, 59.8, ...
        23.5, 23.2, 28.5, 44, 35, 50, 71, 59.3, 59.7, 39.6, 78.4, 29.3, ...
        27.1, 46.6, 37.6, 40, 44, 32, 45.7, 38, 36, 31.7, 22.2, 39, 28, ...
        25, 20, 6.7, 0, 3, 1.7, 13.7, 20.7, 26.7, 18.8, 12.3, 8.2, 24.1, ...
        13.2, 4.2, 10.2, 11.2, 6.8, 6.5, 0, 0, 8.6, 3.2, 17.8, 23.7, ...
        6.8, 20, 12.5, 7.1, 5.4, 9.4, 12.5, 12.9, 3.6, 6.4, 11.8, 14.3, ...
        17, 9.4, 14.1, 21.2, 26.2, 30, 38.1, 12.8, 25, 51.3, 39.7, 32.5, ...
        64.7, 33.5, 37.6, 52, 49, 72.3, 46.4, 45, 44, 38.7, 62.5, 37.7, ...
        43, 43, 48.3, 44, 46.8, 47, 49, 50, 51, 71.3, 77.2, 59.7, 46.3, ...
        57, 67.3, 59.5, 74.7, 58.3, 72, 48.3, 66, 75.6, 61.3, 50.6, 59.7, ...
        61, 70, 91, 80.7, 71.7, 107.2, 99.3, 94.1, 91.1, 100.7, 88.7, ...
        89.7, 46, 43.8, 72.8, 45.7, 60.2, 39.9, 77.1, 33.8, 67.7, 68.5, ...
        69.3, 77.8, 77.2, 56.5, 31.9, 34.2, 32.9, 32.7, 35.8, 54.2, 26.5, ...
        68.1, 46.3, 60.9, 61.4, 59.7, 59.7, 40.2, 34.4, 44.3, 30, 30, ...
        30, 28.2, 28, 26, 25.7, 24, 26, 25, 22, 20.2, 20, 27, 29.7, 16, ...
        14, 14, 13, 12, 11, 36.6, 6, 26.8, 3, 3.3, 4, 4.3, 5, 5.7, 19.2, ...
        27.4, 30, 43, 32.9, 29.8, 33.3, 21.9, 40.8, 42.7, 44.1, 54.7, ...
        53.3, 53.5, 66.1, 46.3, 42.7, 77.7, 77.4, 52.6, 66.8, 74.8, 77.8, ...
        90.6, 111.8, 73.9, 64.2, 64.3, 96.7, 73.6, 94.4, 118.6, 120.3, ...
        148.8, 158.2, 148.1, 112, 104, 142.5, 80.1, 51, 70.1, 83.3, 109.8, ...
        126.3, 104.4, 103.6, 132.2, 102.3, 36, 46.2, 46.7, 64.9, 152.7, ...
        119.5, 67.7, 58.5, 101.4, 90, 99.7, 95.7, 100.9, 90.8, 31.1, ...
        92.2, 38, 57, 77.3, 56.2, 50.5, 78.6, 61.3, 64, 54.6, 29, 51.2, ...
        32.9, 41.1, 28.4, 27.7, 12.7, 29.3, 26.3, 40.9, 43.2, 46.8, 65.4, ...
        55.7, 43.8, 51.3, 28.5, 17.5, 6.6, 7.9, 14, 17.7, 12.2, 4.4, ...
        0, 11.6, 11.2, 3.9, 12.3, 1, 7.9, 3.2, 5.6, 15.1, 7.9, 21.7, ...
        11.6, 6.3, 21.8, 11.2, 19, 1, 24.2, 16, 30, 35, 40, 45, 36.5, ...
        39, 95.5, 80.3, 80.7, 95, 112, 116.2, 106.5, 146, 157.3, 177.3, ...
        109.3, 134, 145, 238.9, 171.6, 153, 140, 171.7, 156.3, 150.3, ...
        105, 114.7, 165.7, 118, 145, 140, 113.7, 143, 112, 111, 124, ...
        114, 110, 70, 98, 98, 95, 107.2, 88, 86, 86, 93.7, 77, 60, 58.7, ...
        98.7, 74.7, 53, 68.3, 104.7, 97.7, 73.5, 66, 51, 27.3, 67, 35.2, ...
        54, 37.5, 37, 41, 54.3, 38, 37, 44, 34, 23.2, 31.5, 30, 28, 38.7, ...
        26.7, 28.3, 23, 25.2, 32.2, 20, 18, 8, 15, 10.5, 13, 8, 11, 10, ...
        6, 9, 6, 10, 10, 8, 17, 14, 6.5, 8, 9, 15.7, 20.7, 26.3, 36.3, ...
        20, 32, 47.2, 40.2, 27.3, 37.2, 47.6, 47.7, 85.4, 92.3, 59, 83, ...
        89.7, 111.5, 112.3, 116, 112.7, 134.7, 106, 87.4, 127.2, 134.8, ...
        99.2, 128, 137.2, 157.3, 157, 141.5, 174, 138, 129.2, 143.3, ...
        108.5, 113, 154.2, 141.5, 136, 141, 142, 94.7, 129.5, 114, 125.3, ...
        120, 123.3, 123.5, 120, 117, 103, 112, 89.7, 134, 135.5, 103, ...
        127.5, 96.3, 94, 93, 91, 69.3, 87, 77.3, 84.3, 82, 74, 72.7, ...
        62, 74, 77.2, 73.7, 64.2, 71, 43, 66.5, 61.7, 67, 66, 58, 64, ...
        63, 75.7, 62, 61, 45.8, 60, 59, 59, 57, 56, 56, 55, 55.5, 53, ...
        52.3, 51, 50, 29.3, 24, 47, 44, 45.7, 45, 44, 38, 28.4, 55.7, ...
        41.5, 41, 40, 11.1, 28.5, 67.4, 51.4, 21.4, 39.9, 12.6, 18.6, ...
        31, 17.1, 12.9, 25.7, 13.5, 19.5, 25, 18, 22, 23.8, 15.7, 31.7, ...
        21, 6.7, 26.9, 1.5, 18.4, 11, 8.4, 5.1, 14.4, 4.2, 4, 4, 7.3, ...
        11.1, 4.3, 6, 5.7, 6.9, 5.8, 3, 2, 4, 12.4, 1.1, 0, 0, 0, 3, ...
        2.4, 1.5, 12.5, 9.9, 1.6, 12.6, 21.7, 8.4, 8.2, 10.6, 2.1, 0, ...
        0, 4.6, 2.7, 8.6, 6.9, 9.3, 13.9, 0, 5, 23.7, 21, 19.5, 11.5, ...
        12.3, 10.5, 40.1, 27, 29, 30, 31, 32, 31.2, 35, 38.7, 33.5, 32.6, ...
        39.8, 48.2, 47.8, 47, 40.8, 42, 44, 46, 48, 50, 51.8, 38.5, 34.5, ...
        50, 50, 50.8, 29.5, 25, 44.3, 36, 48.3, 34.1, 45.3, 54.3, 51, ...
        48, 45.3, 48.3, 48, 50.6, 33.4, 34.8, 29.8, 43.1, 53, 62.3, 61, ...
        60, 61, 44.1, 51.4, 37.5, 39, 40.5, 37.6, 42.7, 44.4, 29.4, 41, ...
        38.3, 39, 29.6, 32.7, 27.7, 26.4, 25.6, 30, 26.3, 24, 27, 25, ...
        24, 12, 12.2, 9.6, 23.8, 10, 12, 12.7, 12, 5.7, 8, 2.6, 0, 0, ...
        4.5, 0, 12.3, 13.5, 13.5, 6.7, 8, 11.7, 4.7, 10.5, 12.3, 7.2, ...
        9.2, 0.9, 2.5, 2, 7.7, 0.3, 0.2, 0.4, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.6, 0, 2.4, 6.1, 0.8, ...
        1.1, 11.3, 1.9, 0.7, 0, 1, 1.3, 0.5, 15.6, 5.2, 3.9, 7.9, 10.1, ...
        0, 10.3, 1.9, 16.6, 5.5, 11.2, 18.3, 8.4, 15.3, 27.8, 16.7, 14.3, ...
        22.2, 12, 5.7, 23.8, 5.8, 14.9, 18.5, 2.3, 8.1, 19.3, 14.5, 20.1, ...
        19.2, 32.2, 26.2, 31.6, 9.8, 55.9, 35.5, 47.2, 31.5, 33.5, 37.2, ...
        65, 26.3, 68.8, 73.7, 58.8, 44.3, 43.6, 38.8, 23.2, 47.8, 56.4, ...
        38.1, 29.9, 36.4, 57.9, 96.2, 26.4, 21.2, 40, 50, 45, 36.7, 25.6, ...
        28.9, 28.4, 34.9, 22.4, 25.4, 34.5, 53.1, 36.4, 28, 31.5, 26.1, ...
        31.7, 10.9, 25.8, 32.5, 20.7, 3.7, 20.2, 19.6, 35, 31.4, 26.1, ...
        14.9, 27.5, 25.1, 30.6, 19.2, 26.6, 4.5, 19.4, 29.3, 10.8, 20.6, ...
        25.9, 5.2, 9, 7.9, 9.7, 21.5, 4.3, 5.7, 9.2, 1.7, 1.8, 2.5, 4.8, ...
        4.4, 18.8, 4.4, 0, 0, 0.9, 16.1, 13.5, 1.5, 5.6, 7.9, 2.1, 0, ...
        0.4, 0, 0, 0, 0, 0.6, 0, 0, 0, 0.5, 0, 0, 0, 0, 20.4, 21.6, 10.8, ...
        0, 19.4, 2.8, 0, 0, 1.4, 20.5, 25.2, 0, 0.8, 5, 15.5, 22.4, 3.8, ...
        15.4, 15.4, 30.9, 25.4, 15.7, 15.6, 11.7, 22, 17.7, 18.2, 36.7, ...
        24, 32.4, 37.1, 52.5, 39.6, 18.9, 50.6, 39.5, 68.1, 34.6, 47.4, ...
        57.8, 46, 56.3, 56.7, 42.9, 53.7, 49.6, 57.2, 48.2, 46.1, 52.8, ...
        64.4, 65, 61.1, 89.1, 98, 54.3, 76.4, 50.4, 54.7, 57, 46.6, 43, ...
        49.4, 72.3, 95, 67.5, 73.9, 90.8, 78.3, 52.8, 57.2, 67.6, 56.5, ...
        52.2, 72.1, 84.6, 107.1, 66.3, 65.1, 43.9, 50.7, 62.1, 84.4, ...
        81.2, 82.1, 47.5, 50.1, 93.4, 54.6, 38.1, 33.4, 45.2, 54.9, 37.9, ...
        46.2, 43.5, 28.9, 30.9, 55.5, 55.1, 26.9, 41.3, 26.7, 13.9, 8.9, ...
        8.2, 21.1, 14.3, 27.5, 11.3, 14.9, 11.8, 2.8, 12.9, 1, 7, 5.7, ...
        11.6, 7.5, 5.9, 9.9, 4.9, 18.1, 3.9, 1.4, 8.8, 7.8, 8.7, 4, 11.5, ...
        24.8, 30.5, 34.5, 7.5, 24.5, 19.7, 61.5, 43.6, 33.2, 59.8, 59, ...
        100.8, 95.2, 100, 77.5, 88.6, 107.6, 98.1, 142.9, 111.4, 124.7, ...
        116.7, 107.8, 95.1, 137.4, 120.9, 206.2, 188, 175.6, 134.6, 138.2, ...
        111.3, 158, 162.8, 134, 96.3, 123.7, 107, 129.8, 144.9, 84.8, ...
        140.8, 126.6, 137.6, 94.5, 108.2, 78.8, 73.6, 90.8, 77.4, 79.8, ...
        107.6, 102.5, 77.7, 61.8, 53.8, 54.6, 84.7, 131.2, 132.7, 90.8, ...
        68.8, 63.6, 81.2, 87.7, 55.5, 65.9, 69.2, 48.5, 60.7, 57.8, 74, ...
        49.8, 54.3, 53.7, 24, 29.9, 29.7, 42.6, 67.4, 55.7, 30.8, 39.3, ...
        35.1, 28.5, 19.8, 38.8, 20.4, 22.1, 21.7, 26.9, 24.9, 20.5, 12.6, ...
        26.5, 18.5, 38.1, 40.5, 17.6, 13.3, 3.5, 8.3, 8.8, 21.1, 10.5, ...
        9.5, 11.8, 4.2, 5.3, 19.1, 12.7, 9.4, 14.7, 13.6, 20.8, 12, 3.7, ...
        21.2, 23.9, 6.9, 21.5, 10.7, 21.6, 25.7, 43.6, 43.3, 56.9, 47.8, ...
        31.1, 30.6, 32.3, 29.6, 40.7, 39.4, 59.7, 38.7, 51, 63.9, 69.2, ...
        59.9, 65.1, 46.5, 54.8, 107.1, 55.9, 60.4, 65.5, 62.6, 44.9, ...
        85.7, 44.7, 75.4, 85.3, 52.2, 140.6, 161.2, 180.4, 138.9, 109.6, ...
        159.1, 111.8, 108.9, 107.1, 102.2, 123.8, 139.2, 132.5, 100.3, ...
        132.4, 114.6, 159.9, 156.7, 131.7, 96.5, 102.5, 80.6, 81.2, 78, ...
        61.3, 93.7, 71.5, 99.7, 97, 78, 89.4, 82.6, 44.1, 61.6, 70, 39.1, ...
        61.6, 86.2, 71, 54.8, 60, 75.5, 105.4, 64.6, 56.5, 62.6, 63.2, ...
        36.1, 57.4, 67.9, 62.5, 50.9, 71.4, 68.4, 67.5, 61.2, 65.4, 54.9, ...
        46.9, 42, 39.7, 37.5, 67.3, 54.3, 45.4, 41.1, 42.9, 37.7, 47.6, ...
        34.7, 40, 45.9, 50.4, 33.5, 42.3, 28.8, 23.4, 15.4, 20, 20.7, ...
        26.4, 24, 21.1, 18.7, 15.8, 22.4, 12.7, 28.2, 21.4, 12.3, 11.4, ...
        17.4, 4.4, 9.1, 5.3, 0.4, 3.1, 0, 9.7, 4.3, 3.1, 0.5, 4.9, 0.4, ...
        6.5, 0, 5, 4.6, 5.9, 4.4, 4.5, 7.7, 7.2, 13.7, 7.4, 5.2, 11.1, ...
        29.2, 16, 22.2, 16.9, 42.4, 40.6, 31.4, 37.2, 39, 34.9, 57.5, ...
        38.3, 41.4, 44.5, 56.7, 55.3, 80.1, 91.2, 51.9, 66.9, 83.7, 87.6, ...
        90.3, 85.7, 91, 87.1, 95.2, 106.8, 105.8, 114.6, 97.2, 81, 81.5, ...
        88, 98.9, 71.4, 107.1, 108.6, 116.7, 100.3, 92.2, 90.1, 97.9, ...
        95.6, 62.3, 77.8, 101, 98.5, 56.8, 87.8, 78, 82.5, 79.9, 67.2, ...
        53.7, 80.5, 63.1, 64.5, 43.6, 53.7, 64.4, 84, 73.4, 62.5, 66.6, ...
        42, 50.6, 40.9, 48.3, 56.7, 66.4, 40.6, 53.8, 40.8, 32.7, 48.1, ...
        22, 39.9, 37.7, 41.2, 57.7, 47.1, 66.3, 35.8, 40.6, 57.8, 54.7, ...
        54.8, 28.5, 33.9, 57.6, 28.6, 48.7, 39.3, 39.5, 29.4, 34.5, 33.6, ...
        26.8, 37.8, 21.6, 17.1, 24.6, 12.8, 31.6, 38.4, 24.6, 17.6, 12.9, ...
        16.5, 9.3, 12.7, 7.3, 14.1, 9, 1.5, 0, 0.7, 9.2, 5.1, 2.9, 1.5, ...
        5, 4.9, 9.8, 13.5, 9.3, 25.2, 15.6, 15.8, 26.5, 36.6, 26.7, 31.1, ...
        28.6, 34.4, 43.8, 61.7, 59.1, 67.6, 60.9, 59.3, 52.7, 41, 104, ...
        108.4, 59.2, 79.6, 80.6, 59.4, 77.4, 104.3, 77.3, 114.9, 159.4, ...
        160, 176, 135.6, 132.4, 153.8, 136, 146.4, 147.5, 130, 88.3, ...
        125.3, 143.2, 162.4, 145.5, 91.7, 103, 110, 80.3, 89, 105.4, ...
        90.3, 79.5, 120.1, 88.4, 102.1, 107.6, 109.9, 105.5, 92.9, 114.6, ...
        103.5, 112, 83.9, 86.7, 107, 98.3, 76.2, 47.9, 44.8, 66.9, 68.2, ...
        47.5, 47.4, 55.4, 49.2, 60.8, 64.2, 46.4, 32, 44.6, 38.2, 67.8, ...
        61.3, 28, 34.3, 28.9, 29.3, 14.6, 22.2, 33.8, 29.1, 11.5, 23.9, ...
        12.5, 14.6, 2.4, 12.7, 17.7, 9.9, 14.3, 15, 31.2, 2.3, 5.1, 1.6, ...
        15.2, 8.8, 9.9, 14.3, 9.9, 8.2, 24.4, 8.7, 11.7, 15.8, 21.2, ...
        13.4, 5.9, 6.3, 16.4, 6.7, 14.5, 2.3, 3.3, 6, 7.8, 0.1, 5.8, ...
        6.4, 0.1, 0, 5.3, 1.1, 4.1, 0.5, 0.8, 0.6, 0, 6.2, 2.4, 4.8, ...
        7.5, 10.7, 6.1, 12.3, 12.9, 7.2, 24, 27.5, 19.5, 19.3, 23.5, ...
        34.1, 21.9, 48.1, 66, 43, 30.7, 29.6, 36.4, 53.2, 51.5, 51.7, ...
        43.5, 60.5, 76.9, 58, 53.2, 64, 54.8, 47.3, 45, 69.3, 67.5, 95.8, ...
        64.1, 45.2, 45.4, 40.4, 57.7, 59.2, 84.4, 41.8, 60.6, 46.9, 42.8, ...
        82.1, 32.1, 76.5, 80.6, 46, 52.6, 83.8, 84.5, 75.9, 91.5, 86.9, ...
        86.8, 76.1, 66.5, 51.2, 53.1, 55.8, 61.9, 47.8, 36.6, 47.2, 42.8, ...
        71.8, 49.8, 55, 73, 83.7, 66.5, 50, 39.6, 38.7, 33.3, 21.7, 29.9, ...
        25.9, 57.3, 43.7, 30.7, 27.1, 30.3, 16.9, 21.4, 8.6, 0.3, 12.4, ...
        10.3, 13.2, 4.2, 6.9, 20, 15.7, 23.3, 21.4, 7.4, 6.6, 6.9, 20.7, ...
        12.7, 7.1, 7.8, 5.1, 7, 7.1, 3.1, 2.8, 8.8, 2.1, 10.7, 6.7, 0.8, ...
        8.5, 7, 4.3, 2.4, 6.4, 9.7, 20.6, 6.5, 2.1, 0.2, 6.7, 5.3, 0.6, ...
        5.1, 1.6, 4.8, 1.3, 11.6, 8.5, 17.2, 11.2, 9.6, 7.8, 13.5, 22.2, ...
        10.4, 20.5, 41.1, 48.3, 58.8, 33.2, 53.8, 51.5, 41.9, 32.3, 69.1, ...
        75.6, 49.9, 69.6, 79.6, 76.3, 76.8, 101.4, 62.8, 70.5, 65.4, ...
        78.6, 75, 73, 65.7, 88.1, 84.7, 88.2, 88.8, 129.2, 77.9, 79.7, ...
        75.1, 93.8, 83.2, 84.6, 52.3, 81.6, 101.2, 98.9, 106, 70.3, 65.9, ...
        75.5, 56.6, 60, 63.3, 67.2, 61, 76.9, 67.5, 71.5, 47.8, 68.9, ...
        57.7, 67.9, 47.2, 70.7, 29, 57.4, 52, 43.8, 27.7, 49, 45, 27.2, ...
        61.3, 28.4, 38, 42.6, 40.6, 29.4, 29.1, 31, 20, 11.3, 27.6, 21.8, ...
        48.1, 14.3, 8.4, 33.3, 30.2, 36.4, 38.3, 14.5, 25.8, 22.3, 9, ...
        31.4, 34.8, 34.4, 30.9, 12.6, 19.5, 9.2, 18.1, 14.2, 7.7, 20.5, ...
        13.5, 2.9, 8.4, 13, 7.8, 10.5, 9.4, 13.6, 8.6, 16, 15.2, 12.1, ...
        8.3, 4.3, 8.3, 12.9, 4.5, 0.3, 0.2, 2.4, 4.5, 0, 10.2, 5.8, 0.7, ...
        1, 0.6, 3.7, 3.8, 0, 5.2, 0, 12.4, 0, 2.8, 1.4, 0.9, 2.3, 7.6, ...
        16.3, 10.3, 1.1, 8.3, 17, 13.5, 26.1, 14.6, 16.3, 27.9, 28.8, ...
        11.1, 38.9, 44.5, 45.6, 31.6, 24.5, 37.2, 43, 39.5, 41.9, 50.6, ...
        58.2, 30.1, 54.2, 38, 54.6, 54.8, 85.8, 56.5, 39.3, 48, 49, 73, ...
        58.8, 55, 78.7, 107.2, 55.5, 45.5, 31.3, 64.5, 55.3, 57.7, 63.2, ...
        103.6, 47.7, 56.1, 17.8, 38.9, 64.7, 76.4, 108.2, 60.7, 52.6, ...
        42.9, 40.4, 49.7, 54.3, 85, 65.4, 61.5, 47.3, 39.2, 33.9, 28.7, ...
        57.6, 40.8, 48.1, 39.5, 90.5, 86.9, 32.3, 45.5, 39.5, 56.7, 46.6, ...
        66.3, 32.3, 36, 22.6, 35.8, 23.1, 38.8, 58.4, 55.8, 54.2, 26.4, ...
        31.5, 21.4, 8.4, 22.2, 12.3, 14.1, 11.5, 26.2, 38.3, 4.9, 5.8, ...
        3.4, 9, 7.8, 16.5, 9, 2.2, 3.5, 4, 4, 2.6, 4.2, 2.2, 0.3, 0, ...
        4.9, 4.5, 4.4, 4.1, 3, 0.3, 9.5, 4.6, 1.1, 6.4, 2.3, 2.9, 0.5, ...
        0.9, 0, 0, 1.7, 0.2, 1.2, 3.1, 0.7, 3.8, 2.8, 2.6, 3.1, 17.3, ...
        5.2, 11.4, 5.4, 7.7, 12.7, 8.2, 16.4, 22.3, 23, 42.3, 38.8, 41.3, ...
        33, 68.8, 71.6, 69.6, 49.5, 53.5, 42.5, 34.5, 45.3, 55.4, 67, ...
        71.8, 74.5, 67.7, 53.5, 35.2, 45.1, 50.7, 65.6, 53, 74.7, 71.9, ...
        94.8, 74.7, 114.1, 114.9, 119.8, 154.5, 129.4, 72.2, 96.4, 129.3, ...
        96, 65.3, 72.2, 80.5, 76.7, 59.4, 107.6, 101.7, 79.9, 85, 83.4, ...
        59.2, 48.1, 79.5, 66.5, 51.8, 88.1, 111.2, 64.7, 69, 54.7, 52.8, ...
        42, 34.9, 51.1, 53.9, 70.2, 14.8, 33.3, 38.7, 27.5, 19.2, 36.3, ...
        49.6, 27.2, 29.9, 31.5, 28.3, 26.7, 32.4, 22.2, 33.7, 41.9, 22.8, ...
        17.8, 18.2, 17.8, 20.3, 11.8, 26.4, 54.7, 11, 8, 5.8, 10.9, 6.5, ...
        4.7, 6.2, 7.4, 17.5, 4.5, 1.5, 3.3, 6.1, 3.2, 9.1, 3.5, 0.5, ...
        13.2, 11.6, 10, 2.8, 0.5, 5.1, 1.8, 11.3, 20.8, 24, 28.1, 19.3, ...
        25.1, 25.6, 22.5, 16.5, 5.5, 23.2, 18, 31.7, 42.8, 47.5, 38.5, ...
        37.9, 60.2, 69.2, 58.6, 98.6, 71.8, 70, 62.5, 38.5, 64.3, 73.5, ...
        52.3, 61.6, 60.8, 71.5, 60.5, 79.4, 81.6, 93, 69.6, 93.5, 79.1, ...
        59.1, 54.9, 53.8, 68.4, 63.1, 67.2, 45.2, 83.5, 73.5, 85.4, 80.6, ...
        76.9, 91.4, 98, 83.8, 89.7, 61.4, 50.3, 59, 68.9, 64.1, 50.2, ...
        52.8, 58.2, 71.9, 70.2, 65.8, 34.4, 54, 81.1, 108, 65.3, 49.2, ...
        35, 38.2, 36.8, 28.8, 21.9, 24.9, 32.1, 34.4, 35.6, 25.8, 14.6, ...
        43.1, 30, 31.2, 24.6, 15.3, 17.4, 13, 19, 10, 18.7, 17.8, 12.1, ...
        10.6, 11.2, 11.2, 17.9, 22.2, 9.6, 6.8, 4, 8.9, 8.2, 11, 12.3, ...
        22.2, 10.1, 2.9, 3.2, 5.2, 2.8, 0.2, 5.1, 3, 0.6, 0.3, 3.4, 7.8, ...
        4.3, 11.3, 19.7, 6.7, 9.3, 8.3, 4, 5.7, 8.7, 15.4, 18.9, 20.5, ...
        23.1, 12.2, 27.3, 45.7, 33.9, 30.1, 42.1, 53.2, 64.2, 61.5, 62.8, ...
        74.3, 77.1, 74.9, 54.6, 70, 52.3, 87, 76, 89, 115.4, 123.4, 132.5, ...
        128.5, 83.9, 109.3, 116.7, 130.3, 145.1, 137.7, 100.7, 124.9, ...
        74.4, 88.8, 98.4, 119.2, 86.5, 101, 127.4, 97.5, 165.3, 115.7, ...
        89.6, 99.1, 122.2, 92.7, 80.3, 77.4, 64.6, 109.1, 118.3, 101, ...
        97.6, 105.8, 112.6, 88.1, 68.1, 42.1, 50.5, 59.4, 83.3, 60.7, ...
        54.4, 83.9, 67.5, 105.5, 66.5, 55, 58.4, 68.3, 45.6, 44.5, 46.4, ...
        32.8, 29.5, 59.8, 66.9, 60, 65.9, 46.3, 38.3, 33.7, 35.6, 52.8, ...
        54.2, 60.7, 25, 11.4, 17.7, 20.2, 17.2, 19.2, 30.7, 22.5, 12.4, ...
        28.9, 27.4, 26.1, 14.1, 7.6, 13.2, 19.4, 10, 7.8, 10.2, 18.8, ...
        3.7, 0.5, 11, 0.3, 2.5, 5, 5, 16.7, 14.3, 16.9, 10.8, 28.4, 18.5, ...
        12.7, 21.5, 32, 30.6, 36.2, 42.6, 25.9, 34.9, 68.8, 46, 27.4, ...
        47.6, 86.2, 76.6, 75.7, 84.9, 73.5, 116.2, 107.2, 94.4, 102.3, ...
        123.8, 121.7, 115.7, 113.4, 129.8, 149.8, 201.3, 163.9, 157.9, ...
        188.8, 169.4, 163.6, 128, 116.5, 108.5, 86.1, 94.8, 189.7, 174, ...
        167.8, 142.2, 157.9, 143.3, 136.3, 95.8, 138, 119.1, 182.3, 157.5, ...
        147, 106.2, 121.7, 125.8, 123.8, 145.3, 131.6, 143.5, 117.6, ...
        101.6, 94.8, 109.7, 113.4, 106.2, 83.6, 91, 85.2, 51.3, 61.4, ...
        54.8, 54.1, 59.9, 59.9, 59.9, 92.9, 108.5, 100.6, 61.5, 61, 83.1, ...
        51.6, 52.4, 45.8, 40.7, 22.7, 22, 29.1, 23.4, 36.4, 39.3, 54.9, ...
        28.2, 23.8, 22.1, 34.3, 26.5, 3.9, 10, 27.8, 12.5, 21.8, 8.6, ...
        23.5, 19.3, 8.2, 1.6, 2.5, 0.2, 0.5, 10.9, 1.8, 0.8, 0.2, 4.8, ...
        8.4, 1.5, 7, 9.2, 7.6, 23.1, 20.8, 4.9, 11.3, 28.9, 31.7, 26.7, ...
        40.7, 42.7, 58.5, 89.2, 76.9, 73.6, 124, 118.4, 110.7, 136.6, ...
        116.6, 129.1, 169.6, 173.2, 155.3, 201.3, 192.1, 165, 130.2, ...
        157.4, 175.2, 164.6, 200.7, 187.2, 158, 235.8, 253.8, 210.9, ...
        239.4, 202.5, 164.9, 190.7, 196, 175.3, 171.5, 191.4, 200.2, ...
        201.2, 181.5, 152.3, 187.6, 217.4, 143.1, 185.7, 163.3, 172, ...
        168.7, 149.6, 199.6, 145.2, 111.4, 124, 125, 146.3, 106, 102.2, ...
        122, 119.6, 110.2, 121.7, 134.1, 127.2, 82.8, 89.6, 85.6, 57.9, ...
        46.1, 53, 61.4, 51, 77.4, 70.2, 55.9, 63.6, 37.7, 32.6, 40, 38.7, ...
        50.3, 45.6, 46.4, 43.7, 42, 21.8, 21.8, 51.3, 39.5, 26.9, 23.2, ...
        19.8, 24.4, 17.1, 29.3, 43, 35.9, 19.6, 33.2, 38.8, 35.3, 23.4, ...
        14.9, 15.3, 17.7, 16.5, 8.6, 9.5, 9.1, 3.1, 9.3, 4.7, 6.1, 7.4, ...
        15.1, 17.5, 14.2, 11.7, 6.8, 24.1, 15.9, 11.9, 8.9, 16.8, 20.1, ...
        15.8, 17, 28.2, 24.4, 25.3, 48.7, 45.3, 47.7, 56.7, 51.2, 50.2, ...
        57.2, 57.2, 70.4, 110.9, 93.6, 111.8, 69.5, 86.5, 67.3, 91.5, ...
        107.2, 76.8, 88.2, 94.3, 126.4, 121.8, 111.9, 92.2, 81.2, 127.2, ...
        110.3, 96.1, 109.3, 117.2, 107.7, 86, 109.8, 104.4, 120.5, 135.8, ...
        106.8, 120, 106, 96.8, 98, 91.3, 95.7, 93.5, 97.9, 111.5, 127.8, ...
        102.9, 109.5, 127.5, 106.8, 112.5, 93, 99.5, 86.6, 95.2, 83.5, ...
        91.3, 79, 60.7, 71.8, 57.5, 49.8, 81, 61.4, 50.2, 51.7, 63.2, ...
        82.2, 61.5, 88.4, 80.1, 63.2, 80.5, 88, 76.5, 76.8, 64, 61.3, ...
        41.6, 45.3, 43.4, 42.9, 46, 57.7, 42.4, 39.5, 23.1, 25.6, 59.3, ...
        30.7, 23.9, 23.3, 27.6, 26, 21.3, 40.3, 39.5, 36, 55.8, 33.6, ...
        40.2, 47.1, 25, 20.5, 18.9, 11.5, 11.5, 5.1, 9, 11.4, 28.2, 39.7, ...
        13.9, 9.1, 19.4, 7.8, 8.1, 4.3, 21.9, 18.8, 12.4, 12.2, 1.9, ...
        16.4, 13.5, 20.6, 5.2, 15.3, 16.4, 23.1, 8.7, 12.9, 18.6, 38.5, ...
        21.4, 30.1, 44, 43.8, 29.1, 43.2, 51.9, 93.6, 76.5, 99.7, 82.7, ...
        95.1, 70.4, 58.1, 138.2, 125.1, 97.9, 122.7, 166.6, 137.5, 138, ...
        101.5, 134.4, 149.5, 159.4, 142.2, 188.4, 186.2, 183.3, 176.3, ...
        159.6, 155, 126.2, 164.1, 179.9, 157.3, 136.3, 135.4, 155, 164.7, ...
        147.9, 174.4, 114, 141.3, 135.5, 156.4, 127.5, 90, 143.8, 158.7, ...
        167.3, 162.4, 137.5, 150.1, 111.2, 163.6, 153.8, 122, 82.2, 110.4, ...
        106.1, 107.6, 118.8, 94.7, 98.1, 127, 84.3, 51, 66.5, 80.7, 99.2, ...
        91.1, 82.2, 71.8, 50.3, 55.8, 33.3, 33.4]';
      out = table (month, sunspots);
    endfunction

  endmethods

endclassdef