## DO NOT EDIT!  Generated automatically from test/fi_lib.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/2a470183a9e0f89ca0473055147b340a7a715b8c
##
## Copyright 1997-2000 Institut fuer Wissenschaftliches Rechnen
##                     und Mathematische Modellbildung (IWRMM)
##                                      and
##                     Institut fuer Angewandte Mathematik
##                     Universitaet Karlsruhe, Germany
##           2000-2005 Wiss. Rechnen/Softwaretechnologie
##                     Universitaet Wuppertal, Germany
## Copyright 2015 Oliver Heimlich
## 
## Original authors: Werner Hofschuster and Walter Kraemer
##                   (unit tests in FI_LIB version 1.2, original license: LGPLv2+)
## Converted into portable ITL format by Oliver Heimlich.
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%!#Test library imports

%!#Arithmetic library imports
pkg load interval

%!#Preamble

try; error ("__FILE__"); catch
    test (lasterror.stack.file, "quiet", stdout);
end_try_catch;

%!function assert_warn (observed_value, expected_value)
%!    if (not (isequal (observed_value, expected_value)))
%!        observed_expression = regexprep (argn(1, :), '\s+$', '');
%!        expected_expression = regexprep (argn(2, :), '\s+$', '');
%!        observed_as_char = disp (observed_value)(1 : end - 1);
%!        expected_as_char = disp(expected_value)(1 : end - 1);
%!        warning ([observed_expression, " != ", expected_expression, ...
%!                 "\n         ", observed_as_char, " != ", expected_as_char]);
%!    endif
%!endfunction

## FI_LIB.addii

%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) + infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (plus (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) + infsup (2.000000000000000000e+00, 2.000000000000000000e+00), infsup (3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (plus (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (2.000000000000000000e+00, 2.000000000000000000e+00)), infsup (3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) + infsup (-2.000000000000000000e+00, -2.000000000000000000e+00), infsup (-3.000000000000000000e+00, -3.000000000000000000e+00)));
%! assert (isequal (plus (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-2.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-3.000000000000000000e+00, -3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) + infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (plus (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) + infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (plus (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) + infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (1.999977734365366011e-320, 1.999977734365366011e-320)));
%! assert (isequal (plus (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)), infsup (1.999977734365366011e-320, 1.999977734365366011e-320)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) + infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%! assert (isequal (plus (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) + infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (-1.999977734365366011e-320, -1.999977734365366011e-320)));
%! assert (isequal (plus (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)), infsup (-1.999977734365366011e-320, -1.999977734365366011e-320)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) + infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%! assert (isequal (plus (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.797693134862315708e+308, 1.797693134862315708e+308) + infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.797693134862315509e+308, 1.797693134862315708e+308)));
%! assert (isequal (plus (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (1.797693134862315509e+308, 1.797693134862315708e+308)));
%!test
%! assert (isequal (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308) + infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.797693134862315708e+308, -1.797693134862315509e+308)));
%! assert (isequal (plus (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-1.797693134862315708e+308, -1.797693134862315509e+308)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 1.000000000000000000e+00) + infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (1.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (plus (infsup (0.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (1.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 2.000000000000000000e+00) + infsup (0.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (plus (infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 2.000000000000000000e+00) + infsup (3.000000000000000000e+00, 4.000000000000000000e+00), infsup (4.000000000000000000e+00, 6.000000000000000000e+00)));
%! assert (isequal (plus (infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (3.000000000000000000e+00, 4.000000000000000000e+00)), infsup (4.000000000000000000e+00, 6.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (3.000000000000000000e+00, 4.000000000000000000e+00) + infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (4.000000000000000000e+00, 6.000000000000000000e+00)));
%! assert (isequal (plus (infsup (3.000000000000000000e+00, 4.000000000000000000e+00), infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (4.000000000000000000e+00, 6.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 0.000000000000000000e+00) + infsup (-4.000000000000000000e+00, -3.000000000000000000e+00), infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)));
%! assert (isequal (plus (infsup (-1.000000000000000000e+00, 0.000000000000000000e+00), infsup (-4.000000000000000000e+00, -3.000000000000000000e+00)), infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-4.000000000000000000e+00, -3.000000000000000000e+00) + infsup (-1.000000000000000000e+00, 0.000000000000000000e+00), infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)));
%! assert (isequal (plus (infsup (-4.000000000000000000e+00, -3.000000000000000000e+00), infsup (-1.000000000000000000e+00, 0.000000000000000000e+00)), infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-5.000000000000000000e+00, -4.000000000000000000e+00) + infsup (4.000000000000000000e+00, 5.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (plus (infsup (-5.000000000000000000e+00, -4.000000000000000000e+00), infsup (4.000000000000000000e+00, 5.000000000000000000e+00)), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (4.000000000000000000e+00, 5.000000000000000000e+00) + infsup (-5.000000000000000000e+00, -4.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (plus (infsup (4.000000000000000000e+00, 5.000000000000000000e+00), infsup (-5.000000000000000000e+00, -4.000000000000000000e+00)), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));

## FI_LIB.subii

%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) - infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (minus (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) - infsup (2.000000000000000000e+00, 2.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%! assert (isequal (minus (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (2.000000000000000000e+00, 2.000000000000000000e+00)), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) - infsup (-2.000000000000000000e+00, -2.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-2.000000000000000000e+00, -2.000000000000000000e+00)), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) - infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (2.000000000000000000e+00, 2.000000000000000000e+00)));
%! assert (isequal (minus (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (2.000000000000000000e+00, 2.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) - infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-2.000000000000000000e+00, -2.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-2.000000000000000000e+00, -2.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) - infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (minus (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) - infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -9.999999999999998890e-01)));
%! assert (isequal (minus (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-1.000000000000000000e+00, -9.999999999999998890e-01)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) - infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) - infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000222e+00, -1.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-1.000000000000000222e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.797693134862315708e+308, 1.797693134862315708e+308) - infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.797693134862315509e+308, 1.797693134862315708e+308)));
%! assert (isequal (minus (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (1.797693134862315509e+308, 1.797693134862315708e+308)));
%!test
%! assert (isequal (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308) - infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-1.797693134862315708e+308, -1.797693134862315509e+308)));
%! assert (isequal (minus (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (-1.797693134862315708e+308, -1.797693134862315509e+308)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 1.000000000000000000e+00) - infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (-2.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (minus (infsup (0.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (-2.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 2.000000000000000000e+00) - infsup (0.000000000000000000e+00, 1.000000000000000000e+00), infsup (0.000000000000000000e+00, 2.000000000000000000e+00)));
%! assert (isequal (minus (infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 2.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 2.000000000000000000e+00) - infsup (3.000000000000000000e+00, 4.000000000000000000e+00), infsup (-3.000000000000000000e+00, -1.000000000000000000e+00)));
%! assert (isequal (minus (infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (3.000000000000000000e+00, 4.000000000000000000e+00)), infsup (-3.000000000000000000e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (3.000000000000000000e+00, 4.000000000000000000e+00) - infsup (1.000000000000000000e+00, 2.000000000000000000e+00), infsup (1.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (minus (infsup (3.000000000000000000e+00, 4.000000000000000000e+00), infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (1.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 0.000000000000000000e+00) - infsup (-4.000000000000000000e+00, -3.000000000000000000e+00), infsup (2.000000000000000000e+00, 4.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-1.000000000000000000e+00, 0.000000000000000000e+00), infsup (-4.000000000000000000e+00, -3.000000000000000000e+00)), infsup (2.000000000000000000e+00, 4.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-4.000000000000000000e+00, -3.000000000000000000e+00) - infsup (-1.000000000000000000e+00, 0.000000000000000000e+00), infsup (-4.000000000000000000e+00, -2.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-4.000000000000000000e+00, -3.000000000000000000e+00), infsup (-1.000000000000000000e+00, 0.000000000000000000e+00)), infsup (-4.000000000000000000e+00, -2.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-5.000000000000000000e+00, -4.000000000000000000e+00) - infsup (4.000000000000000000e+00, 5.000000000000000000e+00), infsup (-1.000000000000000000e+01, -8.000000000000000000e+00)));
%! assert (isequal (minus (infsup (-5.000000000000000000e+00, -4.000000000000000000e+00), infsup (4.000000000000000000e+00, 5.000000000000000000e+00)), infsup (-1.000000000000000000e+01, -8.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (4.000000000000000000e+00, 5.000000000000000000e+00) - infsup (-5.000000000000000000e+00, -4.000000000000000000e+00), infsup (8.000000000000000000e+00, 1.000000000000000000e+01)));
%! assert (isequal (minus (infsup (4.000000000000000000e+00, 5.000000000000000000e+00), infsup (-5.000000000000000000e+00, -4.000000000000000000e+00)), infsup (8.000000000000000000e+00, 1.000000000000000000e+01)));

## FI_LIB.mulii

%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) .* infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) .* infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) .* infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) .* infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%! assert (isequal (times (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (times (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.797693134862315708e+308, 1.797693134862315708e+308) .* infsup (5.000000000000000000e-01, 5.000000000000000000e-01), infsup (8.988465674311578541e+307, 8.988465674311578541e+307)));
%! assert (isequal (times (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (5.000000000000000000e-01, 5.000000000000000000e-01)), infsup (8.988465674311578541e+307, 8.988465674311578541e+307)));
%!test
%! assert (isequal (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308) .* infsup (5.000000000000000000e-01, 5.000000000000000000e-01), infsup (-8.988465674311578541e+307, -8.988465674311578541e+307)));
%! assert (isequal (times (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308), infsup (5.000000000000000000e-01, 5.000000000000000000e-01)), infsup (-8.988465674311578541e+307, -8.988465674311578541e+307)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) .* infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%! assert (isequal (times (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) .* infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)));
%! assert (isequal (times (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) .* infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)));
%! assert (isequal (times (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (4.000000000000000000e+00, 9.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (4.000000000000000000e+00, 9.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) .* infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-9.000000000000000000e+00, -4.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-9.000000000000000000e+00, -4.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-9.000000000000000000e+00, -4.000000000000000000e+00)));
%! assert (isequal (times (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-9.000000000000000000e+00, -4.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (4.000000000000000000e+00, 9.000000000000000000e+00)));
%! assert (isequal (times (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (4.000000000000000000e+00, 9.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-5.000000000000000000e+00, 2.000000000000000000e+00) .* infsup (-4.000000000000000000e+00, 3.000000000000000000e+00), infsup (-1.500000000000000000e+01, 2.000000000000000000e+01)));
%! assert (isequal (times (infsup (-5.000000000000000000e+00, 2.000000000000000000e+00), infsup (-4.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-1.500000000000000000e+01, 2.000000000000000000e+01)));
%!test
%! assert (isequal (infsup (-5.000000000000000000e+00, 2.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, 8.000000000000000000e+00), infsup (-4.000000000000000000e+01, 1.600000000000000000e+01)));
%! assert (isequal (times (infsup (-5.000000000000000000e+00, 2.000000000000000000e+00), infsup (-3.000000000000000000e+00, 8.000000000000000000e+00)), infsup (-4.000000000000000000e+01, 1.600000000000000000e+01)));
%!test
%! assert (isequal (infsup (-2.000000000000000000e+00, 5.000000000000000000e+00) .* infsup (-4.000000000000000000e+00, 3.000000000000000000e+00), infsup (-2.000000000000000000e+01, 1.500000000000000000e+01)));
%! assert (isequal (times (infsup (-2.000000000000000000e+00, 5.000000000000000000e+00), infsup (-4.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-2.000000000000000000e+01, 1.500000000000000000e+01)));
%!test
%! assert (isequal (infsup (-4.000000000000000000e+00, 5.000000000000000000e+00) .* infsup (-4.000000000000000000e+00, 3.000000000000000000e+00), infsup (-2.000000000000000000e+01, 1.600000000000000000e+01)));
%! assert (isequal (times (infsup (-4.000000000000000000e+00, 5.000000000000000000e+00), infsup (-4.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-2.000000000000000000e+01, 1.600000000000000000e+01)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (0.000000000000000000e+00, 9.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (0.000000000000000000e+00, 9.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00) .* infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 9.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-3.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 9.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) .* infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (0.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, 0.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) .* infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (0.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-3.000000000000000000e+00, 3.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (0.000000000000000000e+00, 9.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (0.000000000000000000e+00, 9.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, 0.000000000000000000e+00)), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, 0.000000000000000000e+00)), infsup (-9.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 2.000000000000000000e+00) .* infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-6.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (0.000000000000000000e+00, 2.000000000000000000e+00), infsup (-3.000000000000000000e+00, 0.000000000000000000e+00)), infsup (-6.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) .* infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%! assert (isequal (times (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) .* infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)));
%! assert (isequal (times (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) .* infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)));
%! assert (isequal (times (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) .* infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (-4.940656458412465442e-324, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)), infsup (-4.940656458412465442e-324, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321) .* infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (-9.999888671826830054e-321, -9.999888671826830054e-321), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) .* infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (times (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));

## FI_LIB.divii

%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) ./ infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00) ./ infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) ./ infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 0.000000000000000000e+00) ./ infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (0.000000000000000000e+00, 0.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (0.000000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) ./ infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.000000000000000000e+00, 1.000000000000000000e+00) ./ infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (1.797693134862315708e+308, 1.797693134862315708e+308) ./ infsup (2.000000000000000000e+00, 2.000000000000000000e+00), infsup (8.988465674311578541e+307, 8.988465674311578541e+307)));
%! assert (isequal (rdivide (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (2.000000000000000000e+00, 2.000000000000000000e+00)), infsup (8.988465674311578541e+307, 8.988465674311578541e+307)));
%!test
%! assert (isequal (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308) ./ infsup (2.000000000000000000e+00, 2.000000000000000000e+00), infsup (-8.988465674311578541e+307, -8.988465674311578541e+307)));
%! assert (isequal (rdivide (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308), infsup (2.000000000000000000e+00, 2.000000000000000000e+00)), infsup (-8.988465674311578541e+307, -8.988465674311578541e+307)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) ./ infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) ./ infsup (1.000000000000000000e+00, 1.000000000000000000e+00), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)));
%! assert (isequal (rdivide (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (1.000000000000000000e+00, 1.000000000000000000e+00)), infsup (9.999888671826830054e-321, 9.999888671826830054e-321)));
%!test
%! assert (isequal (infsup (9.999888671826830054e-321, 9.999888671826830054e-321) ./ infsup (-1.000000000000000000e+00, -1.000000000000000000e+00), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)));
%! assert (isequal (rdivide (infsup (9.999888671826830054e-321, 9.999888671826830054e-321), infsup (-1.000000000000000000e+00, -1.000000000000000000e+00)), infsup (-9.999888671826830054e-321, -9.999888671826830054e-321)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) ./ infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (6.666666666666666297e-01, 1.500000000000000000e+00)));
%! assert (isequal (rdivide (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (6.666666666666666297e-01, 1.500000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00) ./ infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-1.500000000000000000e+00, -6.666666666666666297e-01)));
%! assert (isequal (rdivide (infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-1.500000000000000000e+00, -6.666666666666666297e-01)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) ./ infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-5.000000000000000000e-01, 5.000000000000000000e-01)));
%! assert (isequal (rdivide (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-5.000000000000000000e-01, 5.000000000000000000e-01)));
%!test
%! assert (isequal (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00) ./ infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-5.000000000000000000e-01, 5.000000000000000000e-01)));
%! assert (isequal (rdivide (infsup (-1.000000000000000000e+00, 1.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-5.000000000000000000e-01, 5.000000000000000000e-01)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) ./ infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-1.500000000000000000e+00, -6.666666666666666297e-01)));
%! assert (isequal (rdivide (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-1.500000000000000000e+00, -6.666666666666666297e-01)));
%!test
%! assert (isequal (infsup (2.000000000000000000e+00, 3.000000000000000000e+00) ./ infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (6.666666666666666297e-01, 1.500000000000000000e+00)));
%! assert (isequal (rdivide (infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (6.666666666666666297e-01, 1.500000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00) ./ infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (0.000000000000000000e+00, 1.500000000000000000e+00)));
%! assert (isequal (rdivide (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (0.000000000000000000e+00, 1.500000000000000000e+00)));
%!test
%! assert (isequal (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00) ./ infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (-1.500000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (-3.000000000000000000e+00, 0.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (-1.500000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 3.000000000000000000e+00) ./ infsup (-3.000000000000000000e+00, -2.000000000000000000e+00), infsup (-1.500000000000000000e+00, 0.000000000000000000e+00)));
%! assert (isequal (rdivide (infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (-3.000000000000000000e+00, -2.000000000000000000e+00)), infsup (-1.500000000000000000e+00, 0.000000000000000000e+00)));
%!test
%! assert (isequal (infsup (0.000000000000000000e+00, 3.000000000000000000e+00) ./ infsup (2.000000000000000000e+00, 3.000000000000000000e+00), infsup (0.000000000000000000e+00, 1.500000000000000000e+00)));
%! assert (isequal (rdivide (infsup (0.000000000000000000e+00, 3.000000000000000000e+00), infsup (2.000000000000000000e+00, 3.000000000000000000e+00)), infsup (0.000000000000000000e+00, 1.500000000000000000e+00)));

## FI_LIB.unary_functions

%!test
%! assert (isequal (exp (infsup (-5.654676730021285758e+33, -2.467054147405823936e-70)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-1.339988487076310626e-66, -3.142176739251405931e-153)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-1.559745526584455293e+82, -8.494812002392629213e-61)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-1.215647583031333080e-125, -2.146363543986120533e-137)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp [-0X6.FF424CB26239CP+292, -0X2.89F6682121BA8P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (exp (infsup (-7.439842988767636755e+100, -1.769170660676674389e+00)), infsup (0.000000000000000000e+00, 1.704743112651300185e-01)));
%!test
%! assert (isequal (exp (infsup (-7.499234869798133827e+71, -1.740341118088671732e-132)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-2.932406654409041728e+52, -5.352481974657761661e-104)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-5.017847776764403958e-87, -2.227977792271395082e-227)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-1.827668734769395026e-22, -1.326175859067188756e-169)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp [-0X1.582D3AFB2C63DP+312, -0X5.08DC843E57ED4P+180] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (exp (infsup (-5.423963041733560701e+77, -2.059305088062927775e-14)), infsup (0.000000000000000000e+00, 9.999999999999794609e-01)));
%!test
%! assert (isequal (exp (infsup (-3.360610542799653195e+197, -5.874775479904158146e+02)), infsup (0.000000000000000000e+00, 7.273486979199256744e-256)));
%!#exp [-0X3.2FD3FDE325402P+688, -0X2.738623C238270P+48] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (exp (infsup (-3.249456070719769514e+02, -3.915939161035242553e-52)), infsup (7.549460722130907947e-142, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-6.756234292039407244e+297, -1.232680690145569154e-163)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-3.768432504481998329e-45, -1.425448715493971452e-132)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-6.868984884638793653e+105, -1.124545542537290068e-153)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!#exp [-0XD.F2552B8F60978P+236, -0X7.FBDBC320979A4P+188] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (exp (infsup (-4.825221040561267626e-72, -3.741418656433786262e-95)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (2.718281828459045091e+00, 7.389056098930650407e+00)));
%!test
%! assert (isequal (exp (infsup (-1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (3.678794411714422785e-01, 7.389056098930650407e+00)));
%!test
%! assert (isequal (exp (infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)), infsup (6.737946999085467001e-03, 4.978706836786394446e-02)));
%!test
%! assert (isequal (exp (infsup (-2.000000000000000000e+00, 5.999999999999999778e-01)), infsup (1.353352832366126746e-01, 1.822118800390509108e+00)));
%!test
%! assert (isequal (exp (infsup (4.940656458412465442e-324, 5.526030376261632760e-318)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (exp (infsup (2.158572806680406152e-320, 1.000000000000000000e+00)), infsup (1.000000000000000000e+00, 2.718281828459045535e+00)));
%!test
%! assert (isequal (exp (infsup (-3.453765897253233967e-319, 3.453765897253233967e-319)), infsup (9.999999999999998890e-01, 1.000000000000000222e+00)));
%!test
%! assert (isequal (exp (infsup (-1.348799213146603066e-321, 1.999755859375000000e+00)), infsup (9.999999999999998890e-01, 7.387252350349609920e+00)));
%!test
%! assert (isequal (exp (infsup (-1.999984741210937500e+00, -1.768329819216851651e-316)), infsup (1.353373483049074844e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (exp (infsup (-1.999999996274709702e+00, 4.668945501635218808e-314)), infsup (1.353352837407758857e-01, 1.000000000000000222e+00)));
%!test
%! assert (isequal (pow2 (infsup (-5.654676730021285758e+33, -2.467054147405823936e-70)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.339988487076310626e-66, -3.142176739251405931e-153)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.559745526584455293e+82, -8.494812002392629213e-61)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.215647583031333080e-125, -2.146363543986120533e-137)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp2 [-0X6.FF424CB26239CP+292, -0X2.89F6682121BA8P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow2 (infsup (-7.439842988767636755e+100, -1.769170660676674389e+00)), infsup (0.000000000000000000e+00, 2.933773380418803201e-01)));
%!test
%! assert (isequal (pow2 (infsup (-7.499234869798133827e+71, -1.740341118088671732e-132)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-2.932406654409041728e+52, -5.352481974657761661e-104)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-5.017847776764403958e-87, -2.227977792271395082e-227)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.827668734769395026e-22, -1.326175859067188756e-169)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp2 [-0X1.582D3AFB2C63DP+312, -0X5.08DC843E57ED4P+180] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow2 (infsup (-5.423963041733560701e+77, -2.059305088062927775e-14)), infsup (0.000000000000000000e+00, 9.999999999999857891e-01)));
%!test
%! assert (isequal (pow2 (infsup (-3.360610542799653195e+197, -5.874775479904158146e+02)), infsup (0.000000000000000000e+00, 1.417869550014210814e-177)));
%!#exp2 [-0X3.2FD3FDE325402P+688, -0X2.738623C238270P+48] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow2 (infsup (-3.249456070719769514e+02, -3.915939161035242553e-52)), infsup (1.519236241890019241e-98, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-6.756234292039407244e+297, -1.232680690145569154e-163)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-3.768432504481998329e-45, -1.425448715493971452e-132)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-6.868984884638793653e+105, -1.124545542537290068e-153)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!#exp2 [-0XD.F2552B8F60978P+236, -0X7.FBDBC320979A4P+188] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow2 (infsup (-4.825221040561267626e-72, -3.741418656433786262e-95)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (2.000000000000000000e+00, 4.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (5.000000000000000000e-01, 4.000000000000000000e+00)));
%!test
%! assert (isequal (pow2 (infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)), infsup (3.125000000000000000e-02, 1.250000000000000000e-01)));
%!test
%! assert (isequal (pow2 (infsup (-2.000000000000000000e+00, 5.999999999999999778e-01)), infsup (2.500000000000000000e-01, 1.515716566510398211e+00)));
%!test
%! assert (isequal (pow2 (infsup (1.348799213146603066e-321, 8.878353726979450304e-317)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (pow2 (infsup (-3.862967879279826753e-313, 1.508953107040180465e-315)), infsup (9.999999999999998890e-01, 1.000000000000000222e+00)));
%!test
%! assert (isequal (pow2 (infsup (6.914171912282031536e-314, 1.000000194699774969e+00)), infsup (1.000000000000000000e+00, 2.000000269911218709e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.110510763557203341e-312, 1.508971911178661183e-315)), infsup (9.999999999999998890e-01, 1.000000000000000222e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.508974781700063520e-315, 1.999999942630529270e+00)), infsup (9.999999999999998890e-01, 3.999999840938055939e+00)));
%!test
%! assert (isequal (pow2 (infsup (-1.999999999999999778e+00, 9.177083518333092811e-314)), infsup (2.500000000000000000e-01, 1.000000000000000222e+00)));
%!test
%! assert (isequal (pow10 (infsup (-1.306882282121512488e+34, -2.142051668986572426e-70)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-3.574174482995173238e-66, -4.502612523763230139e-153)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-1.977283881120209920e+82, -5.495270555084999106e-61)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-6.394132238750145602e-126, -1.090326174415294200e-137)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp10 [-0X2.7C064F6929234P+292, -0X1.5444E676976F1P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow10 (infsup (-4.308666602899711518e+100, -1.226586363793985335e+00)), infsup (0.000000000000000000e+00, 5.934903149808178069e-02)));
%!test
%! assert (isequal (pow10 (infsup (-7.949640211843924994e+71, -7.928935505948560140e-133)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-3.784447147395508652e+52, -3.876504952447015518e-104)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-2.524795598203051262e-87, -1.735629038886541013e-227)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-5.840571936196232559e-23, -1.237297234801419434e-169)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp10 [-0X1.F0D19ADCB5D74P+312, -0X1.BA04D452BBB35P+180] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow10 (infsup (-3.330274496326268835e+77, -8.586668885039760719e-15)), infsup (0.000000000000000000e+00, 9.999999999999802380e-01)));
%!test
%! assert (isequal (pow10 (infsup (-2.654076110524515271e+197, -2.089478911258004246e+03)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!#exp10 [-0X2.A69A969772FDEP+688, -0X3.436DFE8F08194P+48] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow10 (infsup (-3.786643969857242382e+02, -1.042970653496689987e-51)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-6.699078654119896870e+297, -1.159254403776913034e-163)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-7.532163773886162862e-45, -9.621666972390800389e-133)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-1.485368733580681843e+106, -9.139956432627538486e-154)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!#exp10 [-0XD.5E2045CEE9720P+236, -0X6.6978492A3064CP+188] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow10 (infsup (-1.230428274874167409e-71, -5.894957732633465837e-95)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp10 [-0XB.A944253373080P+564, -0XD.05E9CCF66CF58P+424] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow10 (infsup (-1.376904412228828177e+51, -8.878766165166293762e-17)), infsup (0.000000000000000000e+00, 9.999999999999998890e-01)));
%!test
%! assert (isequal (pow10 (infsup (-3.440680160407877302e-20, -1.442483959041155224e-103)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-7.528651283167650945e+03, -5.626945812397601245e-71)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-8.697059728957016802e+39, -6.144581905264969684e-145)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-2.952069202447659552e+66, -1.163046489009897174e-57)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-4.997184174270236677e-42, -7.340119470601840050e-203)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!#exp10 [-0XB.24D19E00C8460P+324, -0X1.D283CF8F05665P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
%!test
%! assert (isequal (pow10 (infsup (-1.845313858239065767e+196, -1.061757227068338186e-97)), infsup (0.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (pow10 (infsup (-4.488799649180782136e-36, -7.269525029365293208e-38)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (log (infsup (4.147420261371489825e-79, 5.379571027897612396e+28)), infsup (-1.804817358293410905e+02, 6.615499124023648392e+01)));
%!test
%! assert (isequal (log (infsup (1.110880646187224313e-155, 2.373351651082584966e-67)), infsup (-3.567955363383649683e+02, -1.534088980757222771e+02)));
%!test
%! assert (isequal (log (infsup (5.129079157666995424e-72, 1.751070362531829627e+71)), infsup (-1.641512005539303800e+02, 1.640437688392722464e+02)));
%!test
%! assert (isequal (log (infsup (6.948997631311531055e-148, 2.928301646694579776e-136)), infsup (-3.388439963396542112e+02, -3.120771500349853795e+02)));
%!test
%! assert (isequal (log (infsup (1.228976222624138207e+59, 2.234162998792154053e+68)), infsup (1.360587019701163172e+02, 1.573796529843343421e+02)));
%!test
%! assert (isequal (log (infsup (3.765881959744468747e-13, 4.282127607174989696e+83)), infsup (-2.860762412284734779e+01, 1.925690127090641397e+02)));
%!test
%! assert (isequal (log (infsup (6.336975772360046338e-144, 9.158993707856365702e+59)), infsup (-3.297258517440119476e+02, 1.380672568020790720e+02)));
%!test
%! assert (isequal (log (infsup (5.364761505213512494e-113, 4.082352475280499044e+42)), infsup (-2.585122635870604881e+02, 9.811524731508208674e+01)));
%!test
%! assert (isequal (log (infsup (7.550677903404239041e-232, 3.224750948704370352e-99)), infsup (-5.321781042268580677e+02, -2.267850684843527347e+02)));
%!test
%! assert (isequal (log (infsup (1.225297990074229138e-174, 4.817234909117431242e-40)), infsup (-4.004466221093460945e+02, -9.053120362661866238e+01)));
%!test
%! assert (isequal (log (infsup (2.170435512584716658e+35, 4.550722777302786970e+83)), infsup (8.136540609925064871e+01, 1.926298487910074471e+02)));
%!test
%! assert (isequal (log (infsup (2.535659632151250680e-30, 4.662866785261630365e+61)), infsup (-6.814709897670536520e+01, 1.419973211215928757e+02)));
%!test
%! assert (isequal (log (infsup (7.582817216007211414e+01, 2.533325420226928244e+179)), infsup (4.328469887979126796e+00, 4.130922644809588746e+02)));
%!test
%! assert (isequal (log (infsup (2.679384856388388202e+06, 3.456099944072672956e+189)), infsup (1.480109779494235944e+01, 4.364287233454008401e+02)));
%!test
%! assert (isequal (log (infsup (2.298466163925377139e-53, 3.422642591789022920e-07)), infsup (-1.212047679134660427e+02, -1.488768271059561599e+01)));
%!test
%! assert (isequal (log (infsup (8.331537116545182766e-169, 1.276575089856515728e+278)), infsup (-3.870168327490416118e+02, 6.403628366331134885e+02)));
%!test
%! assert (isequal (log (infsup (3.718156390017819207e-141, 1.084633607212178861e-48)), infsup (-3.233512701608040061e+02, -1.104428422229569691e+02)));
%!test
%! assert (isequal (log (infsup (3.157294329035461405e-160, 9.898300388558577825e+97)), infsup (-3.672638994432072650e+02, 2.256431170849012631e+02)));
%!test
%! assert (isequal (log (infsup (1.083356361649631714e+44, 3.415036575780023082e+59)), infsup (1.013938080560929649e+02, 1.370807086899449985e+02)));
%!test
%! assert (isequal (log (infsup (8.455584990678977241e-99, 6.051563441903092353e-73)), infsup (-2.258210970377273554e+02, -1.662883951297580438e+02)));
%!test
%! assert (isequal (log (infsup (2.360349141715971707e+109, 8.567792987486366378e+158)), infsup (2.518405846858512973e+02, 3.659564548647884408e+02)));
%!test
%! assert (isequal (log (infsup (2.012916824299288793e-32, 2.822293342336804668e+41)), infsup (-7.298313814928054910e+01, 9.544353860916723420e+01)));
%!test
%! assert (isequal (log (infsup (4.831139778854605785e-107, 2.083134309679031648e-23)), infsup (-2.448015225314781844e+02, -5.222558349970032054e+01)));
%!test
%! assert (isequal (log (infsup (8.466268199564697371e-76, 1.680782691923963737e-10)), infsup (-1.728603772463421535e+02, -2.250659135696745139e+01)));
%!test
%! assert (isequal (log (infsup (2.283702426861795342e-151, 2.158830003381976904e+22)), infsup (-3.468645510447575475e+02, 5.142643845571060979e+01)));
%!test
%! assert (isequal (log (infsup (1.114428406645123204e-64, 1.137441975089809242e+58)), infsup (-1.472571043179317201e+02, 1.336787172532864645e+02)));
%!test
%! assert (isequal (log (infsup (1.463767593806767211e-207, 3.684178239990781413e-44)), infsup (-4.762541005942298398e+02, -1.000096965923245591e+02)));
%!test
%! assert (isequal (log (infsup (1.806590984564742948e+58, 4.476357965164357790e+78)), infsup (1.341413770290983223e+02, 1.811004470151316070e+02)));
%!test
%! assert (isequal (log (infsup (2.504949335867761681e-102, 4.444462712533866271e+177)), infsup (-2.339454109762628775e+02, 4.090492204470355091e+02)));
%!test
%! assert (isequal (log (infsup (1.027829701532525701e-53, 1.755408547816880709e-45)), infsup (-1.220095604353624026e+02, -1.030536275641269413e+02)));
%!test
%! assert (isequal (log2 (infsup (4.147420261371489825e-79, 5.379571027897612396e+28)), infsup (-2.603801052520223038e+02, 9.544147779234198481e+01)));
%!test
%! assert (isequal (log2 (infsup (1.110880646187224313e-155, 2.373351651082584966e-67)), infsup (-5.147471508866771046e+02, -2.213222564820849811e+02)));
%!test
%! assert (isequal (log2 (infsup (5.129079157666995424e-72, 1.751070362531829627e+71)), infsup (-2.368201229951249900e+02, 2.366651317931535345e+02)));
%!test
%! assert (isequal (log2 (infsup (6.948997631311531055e-148, 2.928301646694579776e-136)), infsup (-4.888485531542171429e+02, -4.502321567302344079e+02)));
%!test
%! assert (isequal (log2 (infsup (1.228976222624138207e+59, 2.234162998792154053e+68)), infsup (1.962912146020762520e+02, 2.270508448973251063e+02)));
%!test
%! assert (isequal (log2 (infsup (3.765881959744468747e-13, 4.282127607174989696e+83)), infsup (-4.127207745364734848e+01, 2.778183596642506359e+02)));
%!test
%! assert (isequal (log2 (infsup (6.336975772360046338e-144, 9.158993707856365702e+59)), infsup (-4.756938511639755802e+02, 1.991889466975024732e+02)));
%!test
%! assert (isequal (log2 (infsup (5.364761505213512494e-113, 4.082352475280499044e+42)), infsup (-3.729543606860327145e+02, 1.415503807370631080e+02)));
%!test
%! assert (isequal (log2 (infsup (7.550677903404239041e-232, 3.224750948704370352e-99)), infsup (-7.677707118377780944e+02, -3.271816936500396196e+02)));
%!test
%! assert (isequal (log2 (infsup (1.225297990074229138e-174, 4.817234909117431242e-40)), infsup (-5.777223558578903067e+02, -1.306089185178316825e+02)));
%!test
%! assert (isequal (log2 (infsup (2.170435512584716658e+35, 4.550722777302786970e+83)), infsup (1.173854678793055371e+02, 2.779061275779773723e+02)));
%!test
%! assert (isequal (log2 (infsup (2.535659632151250680e-30, 4.662866785261630365e+61)), infsup (-9.831548174466217915e+01, 2.048588310016397145e+02)));
%!test
%! assert (isequal (log2 (infsup (7.582817216007211414e+01, 2.533325420226928244e+179)), infsup (6.244662042024692994e+00, 5.959661613962714455e+02)));
%!test
%! assert (isequal (log2 (infsup (2.679384856388388202e+06, 3.456099944072672956e+189)), infsup (2.135347038847591250e+01, 6.296335548719112012e+02)));
%!test
%! assert (isequal (log2 (infsup (2.298466163925377139e-53, 3.422642591789022920e-07)), infsup (-1.748615176008552226e+02, -2.147838601690465765e+01)));
%!test
%! assert (isequal (log2 (infsup (8.331537116545182766e-169, 1.276575089856515728e+278)), infsup (-5.583472653475956804e+02, 9.238482887801823153e+02)));
%!test
%! assert (isequal (log2 (infsup (3.718156390017819207e-141, 1.084633607212178861e-48)), infsup (-4.664972739261393144e+02, -1.593353407767422425e+02)));
%!test
%! assert (isequal (log2 (infsup (3.157294329035461405e-160, 9.898300388558577825e+97)), infsup (-5.298498064242580767e+02, 3.255342060291147845e+02)));
%!test
%! assert (isequal (log2 (infsup (1.083356361649631714e+44, 3.415036575780023082e+59)), infsup (1.462803440593727373e+02, 1.977656586285282856e+02)));
%!test
%! assert (isequal (log2 (infsup (8.455584990678977241e-99, 6.051563441903092353e-73)), infsup (-3.257909768244346083e+02, -2.399034430110863809e+02)));
%!test
%! assert (isequal (log2 (infsup (2.360349141715971707e+109, 8.567792987486366378e+158)), infsup (3.633291626208546745e+02, 5.279635626147360199e+02)));
%!test
%! assert (isequal (log2 (infsup (2.012916824299288793e-32, 2.822293342336804668e+41)), infsup (-1.052924114764811634e+02, 1.376959198363398968e+02)));
%!test
%! assert (isequal (log2 (infsup (4.831139778854605785e-107, 2.083134309679031648e-23)), infsup (-3.531739425582314311e+02, -7.534559032255012312e+01)));
%!test
%! assert (isequal (log2 (infsup (8.466268199564697371e-76, 1.680782691923963737e-10)), infsup (-2.493848090194932183e+02, -3.247014773801134879e+01)));
%!test
%! assert (isequal (log2 (infsup (2.283702426861795342e-151, 2.158830003381976904e+22)), infsup (-5.004197676524483995e+02, 7.419266773063517917e+01)));
%!test
%! assert (isequal (log2 (infsup (1.114428406645123204e-64, 1.137441975089809242e+58)), infsup (-2.124470941351488307e+02, 1.928576224537142991e+02)));
%!test
%! assert (isequal (log2 (infsup (1.463767593806767211e-207, 3.684178239990781413e-44)), infsup (-6.870894291303288810e+02, -1.442834933145564946e+02)));
%!test
%! assert (isequal (log2 (infsup (1.806590984564742948e+58, 4.476357965164357790e+78)), infsup (1.935250994178968824e+02, 2.612727168115048926e+02)));
%!test
%! assert (isequal (log2 (infsup (2.504949335867761681e-102, 4.444462712533866271e+177)), infsup (-3.375118842541849062e+02, 5.901332818184345115e+02)));
%!test
%! assert (isequal (log2 (infsup (1.027829701532525701e-53, 1.755408547816880709e-45)), infsup (-1.760225877811396060e+02, -1.486749574323841045e+02)));
%!test
%! assert (isequal (log10 (infsup (4.147420261371489825e-79, 5.379571027897612396e+28)), infsup (-7.838222195500324574e+01, 2.873074764599266473e+01)));
%!test
%! assert (isequal (log10 (infsup (1.110880646187224313e-155, 2.373351651082584966e-67)), infsup (-1.549543325994630720e+02, -6.662463790914456752e+01)));
%!test
%! assert (isequal (log10 (infsup (5.129079157666995424e-72, 1.751070362531829627e+71)), infsup (-7.128996059836597965e+01, 7.124330359750855735e+01)));
%!test
%! assert (isequal (log10 (infsup (6.948997631311531055e-148, 2.928301646694579776e-136)), infsup (-1.471580778363574780e+02, -1.355333841882873571e+02)));
%!test
%! assert (isequal (log10 (infsup (1.228976222624138207e+59, 2.234162998792154053e+68)), infsup (5.908954348054061967e+01, 6.834911485494504291e+01)));
%!test
%! assert (isequal (log10 (infsup (3.765881959744468747e-13, 4.282127607174989696e+83)), infsup (-1.242413329691495782e+01, 8.363165960510373509e+01)));
%!test
%! assert (isequal (log10 (infsup (6.336975772360046338e-144, 9.158993707856365702e+59)), infsup (-1.431981179532740782e+02, 5.996184776066215250e+01)));
%!test
%! assert (isequal (log10 (infsup (5.364761505213512494e-113, 4.082352475280499044e+42)), infsup (-1.122704495801793030e+02, 4.261091049951299681e+01)));
%!test
%! assert (isequal (log10 (infsup (7.550677903404239041e-232, 3.224750948704370352e-99)), infsup (-2.311220140554580951e+02, -9.849150382080546251e+01)));
%!test
%! assert (isequal (log10 (infsup (1.225297990074229138e-174, 4.817234909117431242e-40)), infsup (-1.739117582788857135e+02, -3.931720217510014947e+01)));
%!test
%! assert (isequal (log10 (infsup (2.170435512584716658e+35, 4.550722777302786970e+83)), infsup (3.533654688672174871e+01, 8.365808037979232381e+01)));
%!test
%! assert (isequal (log10 (infsup (2.535659632151250680e-30, 4.662866785261630365e+61)), infsup (-2.959590904329787620e+01, 6.166865300815185691e+01)));
%!test
%! assert (isequal (log10 (infsup (7.582817216007211414e+01, 2.533325420226928244e+179)), infsup (1.879830587433721334e+00, 1.794036909809991016e+02)));
%!test
%! assert (isequal (log10 (infsup (2.679384856388388202e+06, 3.456099944072672956e+189)), infsup (6.428035098453854346e+00, 1.895385862929884695e+02)));
%!test
%! assert (isequal (log10 (infsup (2.298466163925377139e-53, 3.422642591789022920e-07)), infsup (-5.263856188518261803e+01, -6.465638449538123389e+00)));
%!test
%! assert (isequal (log10 (infsup (8.331537116545182766e-169, 1.276575089856515728e+278)), infsup (-1.680792748665824945e+02, 2.781060463656747288e+02)));
%!test
%! assert (isequal (log10 (infsup (3.718156390017819207e-141, 1.084633607212178861e-48)), infsup (-1.404296723472447752e+02, -4.796471694314168133e+01)));
%!test
%! assert (isequal (log10 (infsup (3.157294329035461405e-160, 9.898300388558577825e+97)), infsup (-1.595006849304556908e+02, 9.799556062942198764e+01)));
%!test
%! assert (isequal (log10 (infsup (1.083356361649631714e+44, 3.415036575780023082e+59)), infsup (4.403477133791865583e+01, 5.953339535943025851e+01)));
%!test
%! assert (isequal (log10 (infsup (8.455584990678977241e-99, 6.051563441903092353e-73)), infsup (-9.807285634082376191e+01, -7.221813240940149115e+01)));
%!test
%! assert (isequal (log10 (infsup (2.360349141715971707e+109, 8.567792987486366378e+158)), infsup (1.093729762483538082e+02, 1.589328689646540624e+02)));
%!test
%! assert (isequal (log10 (infsup (2.012916824299288793e-32, 2.822293342336804668e+41)), infsup (-3.169617417021524730e+01, 4.145060215128129499e+01)));
%!test
%! assert (isequal (log10 (infsup (4.831139778854605785e-107, 2.083134309679031648e-23)), infsup (-1.063159503969355484e+02, -2.268128272809736856e+01)));
%!test
%! assert (isequal (log10 (infsup (8.466268199564697371e-76, 1.680782691923963737e-10)), infsup (-7.507230797780081843e+01, -9.774488432782383995e+00)));
%!test
%! assert (isequal (log10 (infsup (2.283702426861795342e-151, 2.158830003381976904e+22)), infsup (-1.506413604865870184e+02, 2.233421844525230426e+01)));
%!test
%! assert (isequal (log10 (infsup (1.114428406645123204e-64, 1.137441975089809242e+58)), infsup (-6.395294782632925745e+01, 5.805592925100733481e+01)));
%!test
%! assert (isequal (log10 (infsup (1.463767593806767211e-207, 3.684178239990781413e-44)), infsup (-2.068345278718702218e+02, -4.343365936686500106e+01)));
%!test
%! assert (isequal (log10 (infsup (1.806590984564742948e+58, 4.476357965164357790e+78)), infsup (5.825685983864102724e+01, 7.865092480888390014e+01)));
%!test
%! assert (isequal (log10 (infsup (2.504949335867761681e-102, 4.444462712533866271e+177)), infsup (-1.016012010535794019e+02, 1.776478192669743237e+02)));
%!test
%! assert (isequal (log10 (infsup (1.027829701532525701e-53, 1.755408547816880709e-45)), infsup (-5.298807883651920747e+01, -4.475562179121317996e+01)));
%!test
%! assert (isequal (sin (infsup (-1.820250631842705497e-45, -9.117403206523163851e-284)), infsup (-1.820250631842705497e-45, -9.117403206523162656e-284)));
%!test
%! assert (isequal (sin (infsup (-9.132843019095516065e-132, -9.836586939929288236e-188)), infsup (-9.132843019095516065e-132, -9.836586939929286960e-188)));
%!test
%! assert (isequal (sin (infsup (-8.631384205445317548e+01, -2.269091389186822222e-289)), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (sin (infsup (-1.654017949299359065e-112, 1.159376035639006975e-176)), infsup (-1.654017949299359065e-112, 1.159376035639006975e-176)));
%!test
%! assert (isequal (sin (infsup (-2.261578927830210317e-107, -2.921845682025291002e-170)), infsup (-2.261578927830210317e-107, -2.921845682025290634e-170)));
%!test
%! assert (isequal (sin (infsup (-1.469458391712281360e-99, -1.976254011990074054e-124)), infsup (-1.469458391712281360e-99, -1.976254011990073634e-124)));
%!test
%! assert (isequal (sin (infsup (-1.088588131986426258e-12, -3.239993862505298994e-238)), infsup (-1.088588131986426258e-12, -3.239993862505298312e-238)));
%!test
%! assert (isequal (sin (infsup (-3.114600191344484305e-60, -1.151057432815240852e-61)), infsup (-3.114600191344484305e-60, -1.151057432815240680e-61)));
%!test
%! assert (isequal (sin (infsup (3.215755734598088570e-80, 2.860247434645490115e-24)), infsup (3.215755734598088196e-80, 2.860247434645490115e-24)));
%!test
%! assert (isequal (sin (infsup (-7.599545156767026148e-113, -3.620806299549831939e-276)), infsup (-7.599545156767026148e-113, -3.620806299549831137e-276)));
%!test
%! assert (isequal (sin (infsup (-8.378054792460110690e-178, 2.171929406448802147e-04)), infsup (-8.378054792460110690e-178, 2.171929389372813358e-04)));
%!test
%! assert (isequal (sin (infsup (-6.977305240208117095e-101, -5.652987073406890307e-174)), infsup (-6.977305240208117095e-101, -5.652987073406889409e-174)));
%!test
%! assert (isequal (sin (infsup (-5.464129729164141708e-282, 9.669182275976748412e-117)), infsup (-5.464129729164141708e-282, 9.669182275976748412e-117)));
%!test
%! assert (isequal (sin (infsup (-2.609094333453398954e-148, 5.011306988287881225e-06)), infsup (-2.609094333453398954e-148, 5.011306988266906995e-06)));
%!test
%! assert (isequal (sin (infsup (-2.520164184091732485e-91, -6.923225182185906259e-252)), infsup (-2.520164184091732485e-91, -6.923225182185905290e-252)));
%!test
%! assert (isequal (sin (infsup (-2.058411222963202619e-150, -1.691080271454051769e-229)), infsup (-2.058411222963202619e-150, -1.691080271454051403e-229)));
%!test
%! assert (isequal (sin (infsup (-1.194912260770650641e-171, -3.063641562993914407e-235)), infsup (-1.194912260770650641e-171, -3.063641562993914058e-235)));
%!test
%! assert (isequal (sin (infsup (-1.410213021759318257e-164, 2.113307206456483530e-235)), infsup (-1.410213021759318257e-164, 2.113307206456483530e-235)));
%!test
%! assert (isequal (sin (infsup (-2.734402476279937437e-15, 2.214286456252711975e-200)), infsup (-2.734402476279937437e-15, 2.214286456252711975e-200)));
%!test
%! assert (isequal (sin (infsup (-4.736813689297963792e-37, -3.757820326147841254e-165)), infsup (-4.736813689297963792e-37, -3.757820326147840772e-165)));
%!test
%! assert (isequal (sin (infsup (-1.178872317111653867e-269, -3.697079530478824433e-304)), infsup (-1.178872317111653867e-269, -3.697079530478823624e-304)));
%!test
%! assert (isequal (sin (infsup (-3.170977600535302060e-50, 1.773732353250808790e-223)), infsup (-3.170977600535302060e-50, 1.773732353250808790e-223)));
%!test
%! assert (isequal (sin (infsup (-9.582715182984806788e-234, -6.481946913158783102e-280)), infsup (-9.582715182984806788e-234, -6.481946913158782124e-280)));
%!test
%! assert (isequal (sin (infsup (1.510030059283921314e-212, 1.357381528725581723e-08)), infsup (1.510030059283921050e-212, 1.357381528725581723e-08)));
%!test
%! assert (isequal (sin (infsup (-1.323507196051687166e-113, 8.782017701712098963e-233)), infsup (-1.323507196051687166e-113, 8.782017701712098963e-233)));
%!test
%! assert (isequal (sin (infsup (-7.715995104235895070e-26, -1.871718785128404206e-162)), infsup (-7.715995104235895070e-26, -1.871718785128403959e-162)));
%!test
%! assert (isequal (sin (infsup (-3.395185885371617857e-83, -1.892322506995032646e-149)), infsup (-3.395185885371617857e-83, -1.892322506995032429e-149)));
%!test
%! assert (isequal (sin (infsup (-1.449285613317172764e-98, -5.707789272110613126e-264)), infsup (-1.449285613317172764e-98, -5.707789272110612244e-264)));
%!test
%! assert (isequal (sin (infsup (-1.045711771041448932e-76, 2.500374714085601101e-183)), infsup (-1.045711771041448932e-76, 2.500374714085601101e-183)));
%!test
%! assert (isequal (sin (infsup (-1.069106323474023944e-70, -1.300019611184126890e-129)), infsup (-1.069106323474023944e-70, -1.300019611184126730e-129)));
%!test
%! assert (isequal (cos (infsup (-1.820250631842705497e-45, -9.117403206523163851e-284)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-9.132843019095516065e-132, -9.836586939929288236e-188)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-8.631384205445317548e+01, -2.269091389186822222e-289)), infsup (-1.000000000000000000e+00, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.654017949299359065e-112, 1.159376035639006975e-176)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-2.261578927830210317e-107, -2.921845682025291002e-170)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.469458391712281360e-99, -1.976254011990074054e-124)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.088588131986426258e-12, -3.239993862505298994e-238)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-3.114600191344484305e-60, -1.151057432815240852e-61)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (3.215755734598088570e-80, 2.860247434645490115e-24)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-7.599545156767026148e-113, -3.620806299549831939e-276)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-8.378054792460110690e-178, 2.171929406448802147e-04)), infsup (9.999999764136132674e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-6.977305240208117095e-101, -5.652987073406890307e-174)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-5.464129729164141708e-282, 9.669182275976748412e-117)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-2.609094333453398954e-148, 5.011306988287881225e-06)), infsup (9.999999999874433776e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-2.520164184091732485e-91, -6.923225182185906259e-252)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-2.058411222963202619e-150, -1.691080271454051769e-229)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.194912260770650641e-171, -3.063641562993914407e-235)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.410213021759318257e-164, 2.113307206456483530e-235)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-2.734402476279937437e-15, 2.214286456252711975e-200)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-4.736813689297963792e-37, -3.757820326147841254e-165)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.178872317111653867e-269, -3.697079530478824433e-304)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-3.170977600535302060e-50, 1.773732353250808790e-223)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-9.582715182984806788e-234, -6.481946913158783102e-280)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (1.510030059283921314e-212, 1.357381528725581723e-08)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.323507196051687166e-113, 8.782017701712098963e-233)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-7.715995104235895070e-26, -1.871718785128404206e-162)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-3.395185885371617857e-83, -1.892322506995032646e-149)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.449285613317172764e-98, -5.707789272110613126e-264)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.045711771041448932e-76, 2.500374714085601101e-183)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (cos (infsup (-1.069106323474023944e-70, -1.300019611184126890e-129)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tan (infsup (7.068583836474448390e+01, 7.075330512586873510e+01)), infsup (-2.733006473448547767e+05, -1.479881285214991671e+01)));
%!test
%! assert (isequal (tan (infsup (1.555088363530945514e+02, 1.555132637869551502e+02)), infsup (-2.501337356624831200e+09, -2.258629732531564116e+02)));
%!test
%! assert (isequal (tan (infsup (1.413716780550254626e+01, 1.413722739196949441e+01)), infsup (-1.156940779064804548e+06, -1.654237402347945317e+04)));
%!test
%! assert (isequal (tan (infsup (5.811952623508042848e+01, 5.812260122540014606e+01)), infsup (-1.609174370815468137e+04, -3.187612397101500505e+02)));
%!test
%! assert (isequal (tan (infsup (1.104269817737113499e+03, 1.104269843933251650e+03)), infsup (-3.320322546736923695e+09, -3.817312678644171683e+04)));
%!test
%! assert (isequal (tan (infsup (7.853981742281575862e+00, 1.079991165038144985e+01)), infsup (-9.233005655163565651e+06, 5.045449840129903940e+00)));
%!test
%! assert (isequal (tan (infsup (5.239391148189279193e+04, 5.239399492445894430e+04)), infsup (-6.064225515766228782e+05, -1.195622657457963633e+01)));
%!test
%! assert (isequal (tan (infsup (7.586946266951879352e+02, 7.586949897443035979e+02)), infsup (-1.171985512609519530e+06, -2.747989687166772001e+03)));
%!test
%! assert (isequal (tan (infsup (3.011216624054200111e+03, 3.011217034712601162e+03)), infsup (-1.524660234605764526e+04, -2.099751551658140215e+03)));
%!test
%! assert (isequal (tan (infsup (4.712389001448225478e+00, 4.712393345839713810e+00)), infsup (-4.747541049162796140e+07, -2.290711952149188728e+05)));
%!test
%! assert (isequal (tan (infsup (9.660397409977252892e+02, 9.660408736798588052e+02)), infsup (-5.301139629714514315e+07, -8.828451415145300416e+02)));
%!test
%! assert (isequal (tan (infsup (7.853981635987763887e+00, 7.854153626675180355e+00)), infsup (-4.967017041818811297e+08, -5.814200172946292696e+03)));
%!test
%! assert (isequal (tan (infsup (5.811946410445683142e+01, 5.821150187298621859e+01)), infsup (-7.665386554086588323e+07, -1.083440665308985906e+01)));
%!test
%! assert (isequal (tan (infsup (7.853981655490968272e+00, 8.893108173179410159e+00)), infsup (-4.647599232951004803e+07, -5.881622348891323293e-01)));
%!test
%! assert (isequal (tan (infsup (1.352469666641228059e+03, 1.352470270671131857e+03)), infsup (-7.127486560119896808e+01, -6.833240428001097655e+01)));
%!test
%! assert (isequal (tan (infsup (2.670354408912840682e+01, 2.672430666491903750e+01)), infsup (-1.530546221103163844e+05, -4.814150626430674151e+01)));
%!test
%! assert (isequal (tan (infsup (1.003220490034101676e+05, 1.003220547796015017e+05)), infsup (-1.979169548332780600e+09, -1.731225184926742315e+02)));
%!test
%! assert (isequal (tan (infsup (1.545333850137601839e+05, 1.545336486881895107e+05)), infsup (-7.586811168897187940e+01, -3.519246594516249438e+00)));
%!test
%! assert (isequal (tan (infsup (4.256858100226353940e+02, 4.256861391324387682e+02)), infsup (-1.831093219268073444e+05, -2.988901899973172021e+03)));
%!test
%! assert (isequal (tan (infsup (1.892809573788563739e+03, 1.892817290399498461e+03)), infsup (-1.401909320127509832e+09, -1.295879845757753230e+02)));
%!test
%! assert (isequal (tan (infsup (2.673196896903307643e+05, 2.673216347431440372e+05)), infsup (-2.063441696743329614e+07, 3.927681680442902667e-01)));
%!test
%! assert (isequal (tan (infsup (3.926990817370413822e+01, 3.926991071421139168e+01)), infsup (-2.609792168562986851e+08, -3.930293916624513222e+05)));
%!test
%! assert (isequal (tan (infsup (2.984513044884169730e+01, 2.984607373920065143e+01)), infsup (-4.171208738684172742e+06, -1.059849289150749428e+03)));
%!test
%! assert (isequal (tan (infsup (2.670353946608568307e+01, 2.736226360891474840e+01)), infsup (-5.234033417295927648e+05, -1.291880114820135095e+00)));
%!test
%! assert (isequal (tan (infsup (4.500331685768444004e+03, 4.500332498243393275e+03)), infsup (-4.773245350635401337e+03, -9.784962051021077514e+02)));
%!test
%! assert (isequal (tan (infsup (1.220508745920102228e+03, 1.220511210335735768e+03)), infsup (-2.138784586246906519e+09, -4.057748101491103512e+02)));
%!test
%! assert (isequal (tan (infsup (2.984514872583801903e+01, 2.984530664322180371e+01)), infsup (-5.400520128356148052e+04, -5.667837925038271351e+03)));
%!test
%! assert (isequal (tan (infsup (1.944567312807089183e+05, 1.944582117162205104e+05)), infsup (-1.947536722055554565e+05, -9.060237858764001728e-02)));
%!test
%! assert (isequal (tan (infsup (2.356194490664901053e+01, 2.356194490664901053e+01)), infsup (-2.116150755620213449e+08, -2.116150755620213151e+08)));
%!test
%! assert (isequal (tan (infsup (2.356194490664901053e+01, 2.357580376726279070e+01)), infsup (-2.116150755620213449e+08, -7.215135957959719804e+01)));
%!test
%! assert (isequal (cot (infsup (6.911504203794957846e+01, 6.918250879907382966e+01)), infsup (1.479881285215185649e+01, 2.733006480036904104e+05)));
%!test
%! assert (isequal (cot (infsup (1.539380400262996602e+02, 1.539424674601602590e+02)), infsup (2.258629732528814316e+02, 2.501303631633254051e+09)));
%!test
%! assert (isequal (cot (infsup (1.256637147870764970e+01, 1.256643106517459785e+01)), infsup (1.654237402346269664e+04, 1.156940778982844437e+06)));
%!test
%! assert (isequal (cot (infsup (5.654872990828553725e+01, 5.655180489860525483e+01)), infsup (3.187612397096023642e+02, 1.609174370675889440e+04)));
%!test
%! assert (isequal (cot (infsup (1.102699021410318664e+03, 1.102699047606456816e+03)), infsup (3.817312669575550535e+04, 3.319636590212901592e+09)));
%!test
%! assert (isequal (cot (infsup (6.283185415486680192e+00, 9.229115323586553288e+00)), infsup (-5.045449840129905716e+00, 9.233005574227824807e+06)));
%!test
%! assert (isequal (cot (infsup (5.239234068556599232e+04, 5.239242412813214469e+04)), infsup (1.195622657525802346e+01, 6.064242846372171771e+05)));
%!test
%! assert (isequal (cot (infsup (7.571238303683931008e+02, 7.571241934175087636e+02)), infsup (2.747989686696816989e+03, 1.171985427128394833e+06)));
%!test
%! assert (isequal (cot (infsup (3.009645827727405049e+03, 3.009646238385806100e+03)), infsup (2.099751552386235289e+03, 1.524660238444589413e+04)));
%!test
%! assert (isequal (cot (infsup (3.141592674653329809e+00, 3.141597019044817252e+00)), infsup (2.290711952117057808e+05, 4.747540835173728317e+07)));
%!test
%! assert (isequal (cot (infsup (9.644689446709303411e+02, 9.644700773530638571e+02)), infsup (8.828451415546335284e+02, 5.301154089150482416e+07)));
%!test
%! assert (isequal (cot (infsup (6.283185309192868218e+00, 6.283357299880284685e+00)), infsup (5.814200172914197537e+03, 4.967014699504108429e+08)));
%!test
%! assert (isequal (cot (infsup (5.654866777766194019e+01, 5.664070554619132736e+01)), infsup (1.083440665308922135e+01, 7.665383386845602095e+07)));
%!test
%! assert (isequal (cot (infsup (6.283185328696072602e+00, 7.322311846384514489e+00)), infsup (5.881622348891311081e-01, 4.647599027876593918e+07)));
%!test
%! assert (isequal (cot (infsup (1.350898870314433225e+03, 1.350899474344337023e+03)), infsup (6.833240427972033615e+01, 7.127486560088274814e+01)));
%!test
%! assert (isequal (cot (infsup (2.513274776233351204e+01, 2.515351033812414272e+01)), infsup (4.814150626430247826e+01, 1.530546220672695199e+05)));
%!test
%! assert (isequal (cot (infsup (1.003204782070833753e+05, 1.003204839832747093e+05)), infsup (1.731225184158446382e+02, 1.969179325263058186e+09)));
%!test
%! assert (isequal (cot (infsup (1.545318142174333916e+05, 1.545320778918627184e+05)), infsup (3.519246594481938661e+00, 7.586811167421478785e+01)));
%!test
%! assert (isequal (cot (infsup (4.241150136958405028e+02, 4.241153428056438770e+02)), infsup (2.988901899925017460e+03, 1.831093217460757296e+05)));
%!test
%! assert (isequal (cot (infsup (1.891238777461768905e+03, 1.891246494072703626e+03)), infsup (1.295879845747301715e+02, 1.401787019768815756e+09)));
%!test
%! assert (isequal (cot (infsup (2.673181188940039719e+05, 2.673200639468172449e+05)), infsup (-3.927681680472490666e-01, 2.063332560662991926e+07)));
%!test
%! assert (isequal (cot (infsup (3.769911184690924699e+01, 3.769911438741650045e+01)), infsup (3.930293908297998714e+05, 2.609788497224701643e+08)));
%!test
%! assert (isequal (cot (infsup (2.827433412204680252e+01, 2.827527741240575665e+01)), infsup (1.059849289148685102e+03, 4.171208706711991224e+06)));
%!test
%! assert (isequal (cot (infsup (2.513274313929078829e+01, 2.579146728211985362e+01)), infsup (1.291880114820130210e+00, 5.234033412261832273e+05)));
%!test
%! assert (isequal (cot (infsup (4.498760889441648942e+03, 4.498761701916598213e+03)), infsup (9.784962052602219273e+02, 4.773245354397929077e+03)));
%!test
%! assert (isequal (cot (infsup (1.218937949593307394e+03, 1.218940414008940934e+03)), infsup (4.057748101388633017e+02, 2.138499942228402615e+09)));
%!test
%! assert (isequal (cot (infsup (2.827435239904312425e+01, 2.827451031642690893e+01)), infsup (5.667837924979239688e+03, 5.400520127820203925e+04)));
%!test
%! assert (isequal (cot (infsup (1.944551604843821260e+05, 1.944566409198937181e+05)), infsup (9.060237858505562625e-02, 1.947535749805420055e+05)));
%!test
%! assert (isequal (cot (infsup (8.230986922511164039e+02, 8.231133959538416320e+02)), infsup (6.202662085179850493e+01, 7.057105552665587993e+02)));
%!test
%! assert (isequal (cot (infsup (2.199114857985411220e+01, 2.200500744046789237e+01)), infsup (7.215135957960613666e+01, 2.116151523669368625e+08)));
%!test
%! assert (isequal (asin (infsup (-1.312389047028587488e-49, -2.435356662074063942e-204)), infsup (-1.312389047028587678e-49, -2.435356662074063942e-204)));
%!test
%! assert (isequal (asin (infsup (-2.826769732140076133e-84, -5.561386920473982459e-193)), infsup (-2.826769732140076591e-84, -5.561386920473982459e-193)));
%!test
%! assert (isequal (asin (infsup (-1.165983769138532228e-88, -1.428974577546032222e-230)), infsup (-1.165983769138532367e-88, -1.428974577546032222e-230)));
%!test
%! assert (isequal (asin (infsup (-9.442195953730013721e-285, -2.740460328962132443e-294)), infsup (-9.442195953730015214e-285, -2.740460328962132443e-294)));
%!test
%! assert (isequal (asin (infsup (2.046759423140378801e-219, 9.256656556116300803e-185)), infsup (2.046759423140378801e-219, 9.256656556116302109e-185)));
%!test
%! assert (isequal (asin (infsup (-3.808509373683396527e-193, 7.757841386304002834e-162)), infsup (-3.808509373683397013e-193, 7.757841386304003821e-162)));
%!test
%! assert (isequal (asin (infsup (-1.187397361107265637e-112, -2.668312821848315349e-303)), infsup (-1.187397361107265868e-112, -2.668312821848315349e-303)));
%!test
%! assert (isequal (asin (infsup (-1.263586867414290315e-101, -2.961257846195185529e-240)), infsup (-1.263586867414290474e-101, -2.961257846195185529e-240)));
%!test
%! assert (isequal (asin (infsup (-3.901714394731276617e-270, -3.330134658353580222e-294)), infsup (-3.901714394731277458e-270, -3.330134658353580222e-294)));
%!test
%! assert (isequal (asin (infsup (-2.366650777764918445e-246, 1.071483042175132919e-285)), infsup (-2.366650777764918953e-246, 1.071483042175133106e-285)));
%!test
%! assert (isequal (asin (infsup (-4.636590066075016366e-69, 5.524052139366596165e-240)), infsup (-4.636590066075017395e-69, 5.524052139366597231e-240)));
%!test
%! assert (isequal (asin (infsup (1.178822725995249352e-253, 3.080763910515160059e-167)), infsup (1.178822725995249352e-253, 3.080763910515160435e-167)));
%!test
%! assert (isequal (asin (infsup (-1.102346734829299702e-19, 6.850446591467340374e-81)), infsup (-1.102346734829299943e-19, 6.850446591467341310e-81)));
%!test
%! assert (isequal (asin (infsup (-3.809307924483539467e-117, 2.162545233549648523e-70)), infsup (-3.809307924483540172e-117, 2.162545233549648845e-70)));
%!test
%! assert (isequal (asin (infsup (-3.325515536019971910e-77, -2.504008447335657004e-137)), infsup (-3.325515536019972294e-77, -2.504008447335657004e-137)));
%!test
%! assert (isequal (asin (infsup (-1.559805661433223275e-242, 7.909368633706727513e-07)), infsup (-1.559805661433223483e-242, 7.909368633707552311e-07)));
%!test
%! assert (isequal (asin (infsup (-5.969914231928147727e-104, -6.050096414444652455e-262)), infsup (-5.969914231928148967e-104, -6.050096414444652455e-262)));
%!test
%! assert (isequal (asin (infsup (-1.312550047541150255e-20, -6.354261176220087715e-253)), infsup (-1.312550047541150406e-20, -6.354261176220087715e-253)));
%!test
%! assert (isequal (asin (infsup (4.567490786574823890e-149, 4.198196690886986340e-123)), infsup (4.567490786574823890e-149, 4.198196690886987012e-123)));
%!test
%! assert (isequal (asin (infsup (-9.884682253430382309e-92, -5.579479013164953220e-154)), infsup (-9.884682253430383672e-92, -5.579479013164953220e-154)));
%!test
%! assert (isequal (asin (infsup (-1.522662321416928111e-13, 2.644958365616577639e-170)), infsup (-1.522662321416928363e-13, 2.644958365616578006e-170)));
%!test
%! assert (isequal (asin (infsup (-8.948553501584778180e-99, 2.114326410545258721e-257)), infsup (-8.948553501584779804e-99, 2.114326410545259090e-257)));
%!test
%! assert (isequal (asin (infsup (-9.422591232382868792e-70, -6.531943700592087501e-157)), infsup (-9.422591232382870079e-70, -6.531943700592087501e-157)));
%!test
%! assert (isequal (asin (infsup (-4.183491534989001599e-145, 7.226922481530353777e-207)), infsup (-4.183491534989002310e-145, 7.226922481530355161e-207)));
%!test
%! assert (isequal (asin (infsup (-1.261760095202863281e-243, 1.140396740717171993e-231)), infsup (-1.261760095202863541e-243, 1.140396740717172136e-231)));
%!test
%! assert (isequal (asin (infsup (-6.921640701718756344e-64, -1.404179941832861768e-165)), infsup (-6.921640701718757694e-64, -1.404179941832861768e-165)));
%!test
%! assert (isequal (asin (infsup (-7.429895589392232365e-75, -7.756983358701570246e-275)), infsup (-7.429895589392233347e-75, -7.756983358701570246e-275)));
%!test
%! assert (isequal (asin (infsup (6.867158476684655683e-209, 1.563441271274809437e-199)), infsup (6.867158476684655683e-209, 1.563441271274809669e-199)));
%!test
%! assert (isequal (asin (infsup (-9.032911858299409062e-169, 3.060735534879519294e-91)), infsup (-9.032911858299410238e-169, 3.060735534879519839e-91)));
%!test
%! assert (isequal (asin (infsup (-5.007253407091102708e-155, 2.431811725358315428e-307)), infsup (-5.007253407091103536e-155, 2.431811725358315824e-307)));
%!test
%! assert (isequal (acos (infsup (-1.312389047028587488e-49, -2.435356662074063942e-204)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-2.826769732140076133e-84, -5.561386920473982459e-193)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.165983769138532228e-88, -1.428974577546032222e-230)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-9.442195953730013721e-285, -2.740460328962132443e-294)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (2.046759423140378801e-219, 9.256656556116300803e-185)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-3.808509373683396527e-193, 7.757841386304002834e-162)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.187397361107265637e-112, -2.668312821848315349e-303)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.263586867414290315e-101, -2.961257846195185529e-240)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-3.901714394731276617e-270, -3.330134658353580222e-294)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-2.366650777764918445e-246, 1.071483042175132919e-285)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-4.636590066075016366e-69, 5.524052139366596165e-240)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (1.178822725995249352e-253, 3.080763910515160059e-167)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.102346734829299702e-19, 6.850446591467340374e-81)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-3.809307924483539467e-117, 2.162545233549648523e-70)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-3.325515536019971910e-77, -2.504008447335657004e-137)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.559805661433223275e-242, 7.909368633706727513e-07)), infsup (1.570795535858033221e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-5.969914231928147727e-104, -6.050096414444652455e-262)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.312550047541150255e-20, -6.354261176220087715e-253)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (4.567490786574823890e-149, 4.198196690886986340e-123)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-9.884682253430382309e-92, -5.579479013164953220e-154)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.522662321416928111e-13, 2.644958365616577639e-170)), infsup (1.570796326794896558e+00, 1.570796326795049103e+00)));
%!test
%! assert (isequal (acos (infsup (-8.948553501584778180e-99, 2.114326410545258721e-257)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-9.422591232382868792e-70, -6.531943700592087501e-157)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-4.183491534989001599e-145, 7.226922481530353777e-207)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-1.261760095202863281e-243, 1.140396740717171993e-231)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-6.921640701718756344e-64, -1.404179941832861768e-165)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-7.429895589392232365e-75, -7.756983358701570246e-275)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (6.867158476684655683e-209, 1.563441271274809437e-199)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-9.032911858299409062e-169, 3.060735534879519294e-91)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (acos (infsup (-5.007253407091102708e-155, 2.431811725358315428e-307)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (2.142051668986572426e-70, 1.306882282121512488e+34)), infsup (2.142051668986572104e-70, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (4.502612523763230139e-153, 3.574174482995173238e-66)), infsup (4.502612523763229609e-153, 3.574174482995173238e-66)));
%!test
%! assert (isequal (atan (infsup (5.495270555084999106e-61, 1.977283881120209920e+82)), infsup (5.495270555084998415e-61, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.090326174415294200e-137, 6.394132238750145602e-126)), infsup (1.090326174415293961e-137, 6.394132238750145602e-126)));
%!test
%! assert (isequal (atan (infsup (9.619256544849800952e+75, 1.976936481141943109e+88)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.226586363793985335e+00, 4.308666602899711518e+100)), infsup (8.868130567036106582e-01, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (7.928935505948560140e-133, 7.949640211843924994e+71)), infsup (7.928935505948558576e-133, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (3.876504952447015518e-104, 3.784447147395508652e+52)), infsup (3.876504952447014898e-104, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.735629038886541013e-227, 2.524795598203051262e-87)), infsup (1.735629038886540779e-227, 2.524795598203051262e-87)));
%!test
%! assert (isequal (atan (infsup (1.237297234801419434e-169, 5.840571936196232559e-23)), infsup (1.237297234801419286e-169, 5.840571936196232559e-23)));
%!test
%! assert (isequal (atan (infsup (2.646062262797938974e+54, 1.619260330717682242e+94)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (8.586668885039760719e-15, 3.330274496326268835e+77)), infsup (8.586668885039759141e-15, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (2.089478911258004246e+03, 2.654076110524515271e+197)), infsup (1.570317738608022262e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (9.185646314148092500e+14, 3.404186753017747637e+207)), infsup (1.570796326794895448e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.042970653496689987e-51, 3.786643969857242382e+02)), infsup (1.042970653496689839e-51, 1.568155472034706621e+00)));
%!test
%! assert (isequal (atan (infsup (1.159254403776913034e-163, 6.699078654119896870e+297)), infsup (1.159254403776912880e-163, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (9.621666972390800389e-133, 7.532163773886162862e-45)), infsup (9.621666972390798825e-133, 7.532163773886162862e-45)));
%!test
%! assert (isequal (atan (infsup (9.139956432627538486e-154, 1.485368733580681843e+106)), infsup (9.139956432627537161e-154, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (2.515545250733326100e+57, 1.476165379292337505e+72)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (5.894957732633465837e-95, 1.230428274874167409e-71)), infsup (5.894957732633465172e-95, 1.230428274874167409e-71)));
%!test
%! assert (isequal (atan (infsup (5.641992385637192390e+128, 7.041426524450171694e+170)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (8.878766165166293762e-17, 1.376904412228828177e+51)), infsup (8.878766165166292529e-17, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.442483959041155224e-103, 3.440680160407877302e-20)), infsup (1.442483959041154976e-103, 3.440680160407877302e-20)));
%!test
%! assert (isequal (atan (infsup (5.626945812397601245e-71, 7.528651283167650945e+03)), infsup (5.626945812397600441e-71, 1.570663500880067120e+00)));
%!test
%! assert (isequal (atan (infsup (6.144581905264969684e-145, 8.697059728957016802e+39)), infsup (6.144581905264968972e-145, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.163046489009897174e-57, 2.952069202447659552e+66)), infsup (1.163046489009897032e-57, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (7.340119470601840050e-203, 4.997184174270236677e-42)), infsup (7.340119470601838917e-203, 4.997184174270236677e-42)));
%!test
%! assert (isequal (atan (infsup (1.318816730766393217e+76, 3.808490005836893230e+98)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (1.061757227068338186e-97, 1.845313858239065767e+196)), infsup (1.061757227068338056e-97, 1.570796326794896780e+00)));
%!test
%! assert (isequal (atan (infsup (7.269525029365293208e-38, 4.488799649180782136e-36)), infsup (7.269525029365292164e-38, 4.488799649180782136e-36)));
%!test
%! assert (isequal (sinh (infsup (-2.276825735402380789e-48, -1.247591758624133168e-288)), infsup (-2.276825735402381093e-48, -1.247591758624133168e-288)));
%!test
%! assert (isequal (sinh (infsup (-1.555899708023971053e-136, -2.066488754605661877e-191)), infsup (-1.555899708023971244e-136, -2.066488754605661877e-191)));
%!test
%! assert (isequal (sinh (infsup (-1.013218050883979648e+00, -8.114288896805143833e-293)), infsup (-1.195700971165398974e+00, -8.114288896805143833e-293)));
%!test
%! assert (isequal (sinh (infsup (-5.223236923356957882e-115, 2.450356733437761473e-182)), infsup (-5.223236923356958784e-115, 2.450356733437761807e-182)));
%!test
%! assert (isequal (sinh (infsup (-4.510932062945640269e-111, -9.719284552905501027e-172)), infsup (-4.510932062945641008e-111, -9.719284552905501027e-172)));
%!test
%! assert (isequal (sinh (infsup (-5.243225148031154877e-101, -2.926946402493516021e-125)), infsup (-5.243225148031155512e-101, -2.926946402493516021e-125)));
%!test
%! assert (isequal (sinh (infsup (-3.572423176829176112e-14, -6.433836389930062741e-244)), infsup (-3.572423176829176744e-14, -6.433836389930062741e-244)));
%!test
%! assert (isequal (sinh (infsup (-2.694213038264476014e-63, -7.562777816273446350e-67)), infsup (-2.694213038264476553e-63, -7.562777816273446350e-67)));
%!test
%! assert (isequal (sinh (infsup (1.088038949658882158e-80, 1.955415113914635483e-29)), infsup (1.088038949658882158e-80, 1.955415113914635764e-29)));
%!test
%! assert (isequal (sinh (infsup (-7.367961367144991472e-116, -3.479600132086108765e-281)), infsup (-7.367961367144992599e-116, -3.479600132086108765e-281)));
%!test
%! assert (isequal (sinh (infsup (-8.240014447403598921e-179, 4.244031804302998196e-06)), infsup (-8.240014447403600291e-179, 4.244031804315739266e-06)));
%!test
%! assert (isequal (sinh (infsup (-4.940835347719680012e-103, -3.209929124440609153e-180)), infsup (-4.940835347719681003e-103, -3.209929124440609153e-180)));
%!test
%! assert (isequal (sinh (infsup (-1.085358240794141589e-286, 3.362095038805252608e-121)), infsup (-1.085358240794141823e-286, 3.362095038805253038e-121)));
%!test
%! assert (isequal (sinh (infsup (-2.773142512496348467e-152, 5.052868105777038456e-09)), infsup (-2.773142512496348891e-152, 5.052868105777039283e-09)));
%!test
%! assert (isequal (sinh (infsup (-1.515739064210033408e-96, -4.584256552639734730e-257)), infsup (-1.515739064210033616e-96, -4.584256552639734730e-257)));
%!test
%! assert (isequal (sinh (infsup (-5.745505217333493514e-155, -4.839121225948962742e-233)), infsup (-5.745505217333494342e-155, -4.839121225948962742e-233)));
%!test
%! assert (isequal (sinh (infsup (-5.901539399340708264e-177, -4.071613085569532874e-241)), infsup (-5.901539399340709140e-177, -4.071613085569532874e-241)));
%!test
%! assert (isequal (sinh (infsup (-2.800078795581776764e-165, 3.959032834373606979e-236)), infsup (-2.800078795581777246e-165, 3.959032834373607852e-236)));
%!test
%! assert (isequal (sinh (infsup (-5.299801768007807772e-20, 2.412268889562441467e-206)), infsup (-5.299801768007808374e-20, 2.412268889562441744e-206)));
%!test
%! assert (isequal (sinh (infsup (-4.504594176548485258e-37, -1.093025376211848040e-167)), infsup (-4.504594176548486093e-37, -1.093025376211848040e-167)));
%!test
%! assert (isequal (sinh (infsup (-1.148387419014246691e-274, -5.607529106307211921e-306)), infsup (-1.148387419014246819e-274, -5.607529106307211921e-306)));
%!test
%! assert (isequal (sinh (infsup (-8.179611867336581810e-53, 3.261973107060699204e-227)), infsup (-8.179611867336582738e-53, 3.261973107060699673e-227)));
%!test
%! assert (isequal (sinh (infsup (-5.612415357146817830e-236, -1.379963883993877056e-283)), infsup (-5.612415357146818703e-236, -1.379963883993877056e-283)));
%!test
%! assert (isequal (sinh (infsup (6.353125060297895407e-217, 1.401675477619655357e-13)), infsup (6.353125060297895407e-217, 1.401675477619655609e-13)));
%!test
%! assert (isequal (sinh (infsup (-5.247726734531364136e-115, 1.461755126469774210e-238)), infsup (-5.247726734531365037e-115, 1.461755126469774380e-238)));
%!test
%! assert (isequal (sinh (infsup (-1.600607820612694866e-27, -1.050621484395105629e-166)), infsup (-1.600607820612695045e-27, -1.050621484395105629e-166)));
%!test
%! assert (isequal (sinh (infsup (-1.052337857345041679e-89, -1.584198096209285781e-155)), infsup (-1.052337857345041853e-89, -1.584198096209285781e-155)));
%!test
%! assert (isequal (sinh (infsup (-2.798033560470428915e-102, -9.926975697028544915e-270)), infsup (-2.798033560470429312e-102, -9.926975697028544915e-270)));
%!test
%! assert (isequal (sinh (infsup (-1.807789234464845648e-80, 1.364469289790188620e-184)), infsup (-1.807789234464846022e-80, 1.364469289790188881e-184)));
%!test
%! assert (isequal (sinh (infsup (-1.581262363552952774e-73, -1.558035095719158102e-130)), infsup (-1.581262363552953088e-73, -1.558035095719158102e-130)));
%!test
%! assert (isequal (cosh (infsup (-2.276825735402380789e-48, -1.247591758624133168e-288)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.555899708023971053e-136, -2.066488754605661877e-191)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.013218050883979648e+00, -8.114288896805143833e-293)), infsup (1.000000000000000000e+00, 1.558749759405235080e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.223236923356957882e-115, 2.450356733437761473e-182)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-4.510932062945640269e-111, -9.719284552905501027e-172)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.243225148031154877e-101, -2.926946402493516021e-125)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-3.572423176829176112e-14, -6.433836389930062741e-244)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-2.694213038264476014e-63, -7.562777816273446350e-67)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (1.088038949658882158e-80, 1.955415113914635483e-29)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-7.367961367144991472e-116, -3.479600132086108765e-281)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-8.240014447403598921e-179, 4.244031804302998196e-06)), infsup (1.000000000000000000e+00, 1.000000000009005907e+00)));
%!test
%! assert (isequal (cosh (infsup (-4.940835347719680012e-103, -3.209929124440609153e-180)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.085358240794141589e-286, 3.362095038805252608e-121)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-2.773142512496348467e-152, 5.052868105777038456e-09)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.515739064210033408e-96, -4.584256552639734730e-257)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.745505217333493514e-155, -4.839121225948962742e-233)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.901539399340708264e-177, -4.071613085569532874e-241)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-2.800078795581776764e-165, 3.959032834373606979e-236)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.299801768007807772e-20, 2.412268889562441467e-206)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-4.504594176548485258e-37, -1.093025376211848040e-167)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.148387419014246691e-274, -5.607529106307211921e-306)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-8.179611867336581810e-53, 3.261973107060699204e-227)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.612415357146817830e-236, -1.379963883993877056e-283)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (6.353125060297895407e-217, 1.401675477619655357e-13)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-5.247726734531364136e-115, 1.461755126469774210e-238)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.600607820612694866e-27, -1.050621484395105629e-166)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.052337857345041679e-89, -1.584198096209285781e-155)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-2.798033560470428915e-102, -9.926975697028544915e-270)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.807789234464845648e-80, 1.364469289790188620e-184)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (cosh (infsup (-1.581262363552952774e-73, -1.558035095719158102e-130)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (tanh (infsup (2.142051668986572426e-70, 1.306882282121512488e+34)), infsup (2.142051668986572104e-70, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (4.502612523763230139e-153, 3.574174482995173238e-66)), infsup (4.502612523763229609e-153, 3.574174482995173238e-66)));
%!test
%! assert (isequal (tanh (infsup (5.495270555084999106e-61, 1.977283881120209920e+82)), infsup (5.495270555084998415e-61, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.090326174415294200e-137, 6.394132238750145602e-126)), infsup (1.090326174415293961e-137, 6.394132238750145602e-126)));
%!test
%! assert (isequal (tanh (infsup (9.619256544849800952e+75, 1.976936481141943109e+88)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.226586363793985335e+00, 4.308666602899711518e+100)), infsup (8.415863137654880921e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (7.928935505948560140e-133, 7.949640211843924994e+71)), infsup (7.928935505948558576e-133, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (3.876504952447015518e-104, 3.784447147395508652e+52)), infsup (3.876504952447014898e-104, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.735629038886541013e-227, 2.524795598203051262e-87)), infsup (1.735629038886540779e-227, 2.524795598203051262e-87)));
%!test
%! assert (isequal (tanh (infsup (1.237297234801419434e-169, 5.840571936196232559e-23)), infsup (1.237297234801419286e-169, 5.840571936196232559e-23)));
%!test
%! assert (isequal (tanh (infsup (2.646062262797938974e+54, 1.619260330717682242e+94)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (8.586668885039760719e-15, 3.330274496326268835e+77)), infsup (8.586668885039759141e-15, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (2.089478911258004246e+03, 2.654076110524515271e+197)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (9.185646314148092500e+14, 3.404186753017747637e+207)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.042970653496689987e-51, 3.786643969857242382e+02)), infsup (1.042970653496689839e-51, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.159254403776913034e-163, 6.699078654119896870e+297)), infsup (1.159254403776912880e-163, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (9.621666972390800389e-133, 7.532163773886162862e-45)), infsup (9.621666972390798825e-133, 7.532163773886162862e-45)));
%!test
%! assert (isequal (tanh (infsup (9.139956432627538486e-154, 1.485368733580681843e+106)), infsup (9.139956432627537161e-154, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (2.515545250733326100e+57, 1.476165379292337505e+72)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (5.894957732633465837e-95, 1.230428274874167409e-71)), infsup (5.894957732633465172e-95, 1.230428274874167409e-71)));
%!test
%! assert (isequal (tanh (infsup (5.641992385637192390e+128, 7.041426524450171694e+170)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (8.878766165166293762e-17, 1.376904412228828177e+51)), infsup (8.878766165166292529e-17, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.442483959041155224e-103, 3.440680160407877302e-20)), infsup (1.442483959041154976e-103, 3.440680160407877302e-20)));
%!test
%! assert (isequal (tanh (infsup (5.626945812397601245e-71, 7.528651283167650945e+03)), infsup (5.626945812397600441e-71, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (6.144581905264969684e-145, 8.697059728957016802e+39)), infsup (6.144581905264968972e-145, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.163046489009897174e-57, 2.952069202447659552e+66)), infsup (1.163046489009897032e-57, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (7.340119470601840050e-203, 4.997184174270236677e-42)), infsup (7.340119470601838917e-203, 4.997184174270236677e-42)));
%!test
%! assert (isequal (tanh (infsup (1.318816730766393217e+76, 3.808490005836893230e+98)), infsup (9.999999999999998890e-01, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (1.061757227068338186e-97, 1.845313858239065767e+196)), infsup (1.061757227068338056e-97, 1.000000000000000000e+00)));
%!test
%! assert (isequal (tanh (infsup (7.269525029365293208e-38, 4.488799649180782136e-36)), infsup (7.269525029365292164e-38, 4.488799649180782136e-36)));
%!test
%! assert (isequal (coth (infsup (1.894295696760237533e-79, 1.950216651182638040e+28)), infsup (1.000000000000000000e+00, 5.279006871579093604e+78)));
%!test
%! assert (isequal (coth (infsup (-1.950216651182638040e+28, -1.894295696760237533e-79)), infsup (-5.279006871579093604e+78, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (3.320841342139927716e-156, 6.424290443627079857e-68)), infsup (1.556592138501464494e+67, 3.011285084025142904e+155)));
%!test
%! assert (isequal (coth (infsup (-6.424290443627079857e-68, -3.320841342139927716e-156)), infsup (-3.011285084025142904e+155, -1.556592138501464494e+67)));
%!test
%! assert (isequal (coth (infsup (2.751499933051732237e-72, 9.408527432646626663e+70)), infsup (1.000000000000000000e+00, 3.634381335022909468e+71)));
%!test
%! assert (isequal (coth (infsup (-9.408527432646626663e+70, -2.751499933051732237e-72)), infsup (-3.634381335022909468e+71, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (3.517997538706998525e-148, 1.497328258663174781e-136)), infsup (6.678562260574758313e+135, 2.842526150167629525e+147)));
%!test
%! assert (isequal (coth (infsup (-1.497328258663174781e-136, -3.517997538706998525e-148)), infsup (-2.842526150167629525e+147, -6.678562260574758313e+135)));
%!test
%! assert (isequal (coth (infsup (9.905525909214206329e+58, 2.225938119842340464e+68)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (coth (infsup (-2.225938119842340464e+68, -9.905525909214206329e+58)), infsup (-1.000000000000000222e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (2.239285535837240642e-13, 3.477625899530847479e+83)), infsup (1.000000000000000000e+00, 4.465710084739652344e+12)));
%!test
%! assert (isequal (coth (infsup (-3.477625899530847479e+83, -2.239285535837240642e-13)), infsup (-4.465710084739652344e+12, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (3.415418494751353181e-144, 5.233267885617046715e+59)), infsup (1.000000000000000000e+00, 2.927898884241420862e+143)));
%!test
%! assert (isequal (coth (infsup (-5.233267885617046715e+59, -3.415418494751353181e-144)), infsup (-2.927898884241420862e+143, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (2.475241261380885882e-113, 2.034195705081105309e+42)), infsup (1.000000000000000000e+00, 4.040010222850441763e+112)));
%!test
%! assert (isequal (coth (infsup (-2.034195705081105309e+42, -2.475241261380885882e-113)), infsup (-4.040010222850441763e+112, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (2.549437728230459203e-232, 1.836840579504975127e-99)), infsup (5.444130596622043095e+98, 3.922433519072814253e+231)));
%!test
%! assert (isequal (coth (infsup (-1.836840579504975127e-99, -2.549437728230459203e-232)), infsup (-3.922433519072814253e+231, -5.444130596622043095e+98)));
%!test
%! assert (isequal (coth (infsup (4.325945854917056393e-175, 3.934256418924328452e-40)), infsup (2.541776370217911761e+39, 2.311633186216043598e+174)));
%!test
%! assert (isequal (coth (infsup (-3.934256418924328452e-40, -4.325945854917056393e-175)), infsup (-2.311633186216043598e+174, -2.541776370217911761e+39)));
%!test
%! assert (isequal (coth (infsup (2.036990759412397446e+35, 2.361435323577135193e+83)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (coth (infsup (-2.361435323577135193e+83, -2.036990759412397446e+35)), infsup (-1.000000000000000222e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (1.859092626033397846e-30, 3.496514376215051672e+61)), infsup (1.000000000000000000e+00, 5.378968137448980910e+29)));
%!test
%! assert (isequal (coth (infsup (-3.496514376215051672e+61, -1.859092626033397846e-30)), infsup (-5.378968137448980910e+29, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (2.090285002199718534e+01, 2.207982549862724136e+179)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (coth (infsup (-2.207982549862724136e+179, -2.090285002199718534e+01)), infsup (-1.000000000000000222e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (1.208755205351178767e+06, 3.006650875502725685e+189)), infsup (1.000000000000000000e+00, 1.000000000000000222e+00)));
%!test
%! assert (isequal (coth (infsup (-3.006650875502725685e+189, -1.208755205351178767e+06)), infsup (-1.000000000000000222e+00, -1.000000000000000000e+00)));
%!test
%! assert (isequal (coth (infsup (6.431982815787139811e-54, 1.599583732850823968e-07)), infsup (6.251626466704432853e+06, 1.554730521893692440e+53)));
%!test
%! assert (isequal (coth (infsup (-1.599583732850823968e-07, -6.431982815787139811e-54)), infsup (-1.554730521893692440e+53, -6.251626466704432853e+06)));
%!test
%! assert (isequal (asinh (infsup (2.142051668986572426e-70, 1.306882282121512488e+34)), infsup (2.142051668986572104e-70, 7.924868470570649492e+01)));
%!test
%! assert (isequal (asinh (infsup (4.502612523763230139e-153, 3.574174482995173238e-66)), infsup (4.502612523763229609e-153, 3.574174482995173238e-66)));
%!test
%! assert (isequal (asinh (infsup (5.495270555084999106e-61, 1.977283881120209920e+82)), infsup (5.495270555084998415e-61, 1.901868489318184174e+02)));
%!test
%! assert (isequal (asinh (infsup (1.090326174415294200e-137, 6.394132238750145602e-126)), infsup (1.090326174415293961e-137, 6.394132238750145602e-126)));
%!test
%! assert (isequal (asinh (infsup (9.619256544849800952e+75, 1.976936481141943109e+88)), infsup (1.756507961345643878e+02, 2.040021837787967911e+02)));
%!test
%! assert (isequal (asinh (infsup (1.226586363793985335e+00, 4.308666602899711518e+100)), infsup (1.032882671369447447e+00, 2.324122849633374130e+02)));
%!test
%! assert (isequal (asinh (infsup (7.928935505948560140e-133, 7.949640211843924994e+71)), infsup (7.928935505948558576e-133, 1.662498154544074964e+02)));
%!test
%! assert (isequal (asinh (infsup (3.876504952447015518e-104, 3.784447147395508652e+52)), infsup (3.876504952447014898e-104, 1.217584718283750362e+02)));
%!test
%! assert (isequal (asinh (infsup (1.735629038886541013e-227, 2.524795598203051262e-87)), infsup (1.735629038886540779e-227, 2.524795598203051262e-87)));
%!test
%! assert (isequal (asinh (infsup (1.237297234801419434e-169, 5.840571936196232559e-23)), infsup (1.237297234801419286e-169, 5.840571936196232559e-23)));
%!test
%! assert (isequal (asinh (infsup (2.646062262797938974e+54, 1.619260330717682242e+94)), infsup (1.260058147985681245e+02, 2.176181153810006776e+02)));
%!test
%! assert (isequal (asinh (infsup (8.586668885039760719e-15, 3.330274496326268835e+77)), infsup (8.586668885039759141e-15, 1.791952540730257510e+02)));
%!#asinh [0X8.297A99ED9ED08P+8, 0XE.33C49CF5B8790P+652] = [0X8.567B3095B8380P+0, 0X1.C7474C3E00682P+8];
%!#asinh [0X3.436DFE8F08194P+48, 0X2.A69A969772FDEP+688] = [0X2.325A084AF897EP+4, 0X1.DE8DA2F064858P+8];
%!test
%! assert (isequal (asinh (infsup (1.042970653496689987e-51, 3.786643969857242382e+02)), infsup (1.042970653496689839e-51, 6.629799240811253824e+00)));
%!test
%! assert (isequal (asinh (infsup (1.159254403776913034e-163, 6.699078654119896870e+297)), infsup (1.159254403776912880e-163, 6.864628898024220689e+02)));
%!test
%! assert (isequal (asinh (infsup (9.621666972390800389e-133, 7.532163773886162862e-45)), infsup (9.621666972390798825e-133, 7.532163773886162862e-45)));
%!test
%! assert (isequal (asinh (infsup (9.139956432627538486e-154, 1.485368733580681843e+106)), infsup (9.139956432627537161e-154, 2.451628300848022946e+02)));
%!test
%! assert (isequal (asinh (infsup (2.515545250733326100e+57, 1.476165379292337505e+72)), infsup (1.328629870607709620e+02, 1.668687216416238925e+02)));
%!test
%! assert (isequal (asinh (infsup (5.894957732633465837e-95, 1.230428274874167409e-71)), infsup (5.894957732633465172e-95, 1.230428274874167409e-71)));
%!#asinh [0XD.05E9CCF66CF58P+424, 0XB.A944253373080P+564] = [0X1.29277EA798036P+8, 0X1.8A159CCBD552AP+8];
%!test
%! assert (isequal (asinh (infsup (8.878766165166293762e-17, 1.376904412228828177e+51)), infsup (8.878766165166292529e-17, 1.184448247231850360e+02)));
%!test
%! assert (isequal (asinh (infsup (1.442483959041155224e-103, 3.440680160407877302e-20)), infsup (1.442483959041154976e-103, 3.440680160407877302e-20)));
%!test
%! assert (isequal (asinh (infsup (5.626945812397601245e-71, 7.528651283167650945e+03)), infsup (5.626945812397600441e-71, 9.619618377260879427e+00)));
%!test
%! assert (isequal (asinh (infsup (6.144581905264969684e-145, 8.697059728957016802e+39)), infsup (6.144581905264968972e-145, 9.265695081367732655e+01)));
%!test
%! assert (isequal (asinh (infsup (1.163046489009897174e-57, 2.952069202447659552e+66)), infsup (1.163046489009897032e-57, 1.537462696671939852e+02)));
%!test
%! assert (isequal (asinh (infsup (7.340119470601840050e-203, 4.997184174270236677e-42)), infsup (7.340119470601838917e-203, 4.997184174270236677e-42)));
%!test
%! assert (isequal (asinh (infsup (1.318816730766393217e+76, 3.808490005836893230e+98)), infsup (1.759663491665984338e+02, 2.276837190806306239e+02)));
%!#asinh [0X3.A0EE84451C92CP-324, 0XF.CC937FA330E40P+648] = [0X3.A0EE84451C92AP-324, 0X1.C49CCB25BBD50P+8];
%!test
%! assert (isequal (asinh (infsup (7.269525029365293208e-38, 4.488799649180782136e-36)), infsup (7.269525029365292164e-38, 4.488799649180782136e-36)));
%!test
%! assert (isequal (acosh (infsup (4.308689365264194681e+82, 1.870190767041050574e+259)), infsup (1.909657585723560658e+02, 5.976887267061416651e+02)));
%!test
%! assert (isequal (acosh (infsup (1.663490370649616415e+104, 1.013015541347756766e+134)), infsup (2.406709148797917237e+02, 3.092524812088139470e+02)));
%!test
%! assert (isequal (acosh (infsup (4.740352466070305280e+17, 3.416343854883929839e+224)), infsup (4.139320525433158338e+01, 5.177007789421815005e+02)));
%!test
%! assert (isequal (acosh (infsup (5.649987645498339448e+39, 4.009451878894758553e+115)), infsup (9.222561916584621144e+01, 2.668790874182960238e+02)));
%!test
%! assert (isequal (acosh (infsup (8.616687911287559235e+77, 5.944690784478971107e+169)), infsup (1.801459001189113280e+02, 3.916125264126404204e+02)));
%!test
%! assert (isequal (acosh (infsup (1.337707751915661292e+170, 1.380110451090683299e+220)), infsup (3.924235705058085273e+02, 5.075840311722385536e+02)));
%!test
%! assert (isequal (acosh (infsup (1.220751226792469375e+14, 7.832127768107454054e+156)), infsup (3.312880491138550809e+01, 3.619546559063252289e+02)));
%!test
%! assert (isequal (acosh (infsup (4.401102955082982275e+23, 1.287462777714444441e+159)), infsup (5.513445950054409650e+01, 3.670568504092379953e+02)));
%!test
%! assert (isequal (acosh (infsup (1.301393744352418326e+89, 2.720259598242152528e+307)), infsup (2.058866562582371955e+02, 7.085874980460159804e+02)));
%!test
%! assert (isequal (acosh (infsup (6.939444977341106986e+123, 1.984966170027903415e+260)), infsup (2.858483354157015697e+02, 6.000508732301987038e+02)));
%!test
%! assert (isequal (acosh (infsup (6.485225963939702296e+146, 9.590094226342687312e+261)), infsup (3.387400974189444014e+02, 6.039285871663319085e+02)));
%!test
%! assert (isequal (acosh (infsup (2.743579466422469183e+115, 4.645309981121623107e+192)), infsup (2.664996963173169888e+02, 4.443253431398200632e+02)));
%!test
%! assert (isequal (acosh (infsup (6.315691036069834079e+183, 1.254000664372473335e+196)), infsup (4.239092563760087842e+02, 4.522261643794061001e+02)));
%!test
%! assert (isequal (acosh (infsup (1.138781729534858459e+05, 6.522252952647259925e+170)), infsup (1.233603167819211954e+01, 3.940078328506839398e+02)));
%!test
%! assert (isequal (acosh (infsup (1.705317527179950542e+68, 1.807502842596086102e+136)), infsup (1.578026848305014198e+02, 3.144366660754669738e+02)));
%!test
%! assert (isequal (acosh (infsup (2.320700483702952407e+153, 1.406262907030544946e+207)), infsup (3.538305354813851977e+02, 4.776691971955887084e+02)));
%!test
%! assert (isequal (acosh (infsup (1.484021313157366875e+14, 6.690353456676457891e+66)), infsup (3.332409398908451692e+01, 1.545644300244953797e+02)));
%!test
%! assert (isequal (acosh (infsup (1.949448535585448881e+38, 1.286062297009824876e+183)), infsup (8.885892724464935100e+01, 4.223178042655773083e+02)));
%!test
%! assert (isequal (acosh (infsup (1.323970487459108229e+62, 5.603597588316931976e+76)), infsup (1.437340581130183921e+02, 1.774130230660661312e+02)));
%!test
%! assert (isequal (acosh (infsup (4.971908888084823723e+22, 1.705737433846073186e+263)), infsup (5.295382307490645246e+01, 6.068070241677426111e+02)));
%!test
%! assert (isequal (acosh (infsup (3.185265905903948048e+68, 1.396714687103404512e+294)), infsup (1.584274692766343264e+02, 6.779872873476585937e+02)));
%!test
%! assert (isequal (acosh (infsup (2.419365169286764294e+162, 6.023839510485900011e+239)), infsup (3.745954374246092016e+02, 5.528067092545940113e+02)));
%!test
%! assert (isequal (acosh (infsup (6.369713416360370450e+54, 1.746916684461024567e+239)), infsup (1.268842966812280508e+02, 5.515688367455168191e+02)));
%!test
%! assert (isequal (acosh (infsup (2.510121874915821578e+141, 1.760590294900778378e+244)), infsup (3.262779766004285875e+02, 5.630895590187549260e+02)));
%!test
%! assert (isequal (acosh (infsup (8.413476455681521536e+227, 4.905680962443388553e+277)), infsup (5.255097980504410771e+02, 6.400996118535556434e+02)));
%!test
%! assert (isequal (acosh (infsup (5.329335402634341777e+21, 1.810944547265758752e+289)), infsup (5.072066067390094446e+01, 6.667340876143190371e+02)));
%!test
%! assert (isequal (acosh (infsup (2.791850949318598675e+238, 1.892476551972181292e+277)), infsup (5.497351041117033219e+02, 6.391471042561882996e+02)));
%!test
%! assert (isequal (acosh (infsup (1.811273674489520570e+131, 3.937972452864056384e+191)), infsup (3.029258246481488754e+02, 4.418575659274054033e+02)));
%!test
%! assert (isequal (acosh (infsup (1.297701720686003170e+139, 2.351832189572987335e+171)), infsup (3.210130698994429395e+02, 3.952903927620620834e+02)));
%!test
%! assert (isequal (acosh (infsup (1.177543487203761135e+25, 4.156461555557113578e+231)), infsup (5.842120498344542057e+01, 5.340149677868963636e+02)));
%!test
%! assert (isequal (atanh (infsup (-1.312389047028587488e-49, -2.435356662074063942e-204)), infsup (-1.312389047028587678e-49, -2.435356662074063942e-204)));
%!test
%! assert (isequal (atanh (infsup (-2.826769732140076133e-84, -5.561386920473982459e-193)), infsup (-2.826769732140076591e-84, -5.561386920473982459e-193)));
%!test
%! assert (isequal (atanh (infsup (-1.165983769138532228e-88, -1.428974577546032222e-230)), infsup (-1.165983769138532367e-88, -1.428974577546032222e-230)));
%!test
%! assert (isequal (atanh (infsup (-9.442195953730013721e-285, -2.740460328962132443e-294)), infsup (-9.442195953730015214e-285, -2.740460328962132443e-294)));
%!test
%! assert (isequal (atanh (infsup (2.046759423140378801e-219, 9.256656556116300803e-185)), infsup (2.046759423140378801e-219, 9.256656556116302109e-185)));
%!test
%! assert (isequal (atanh (infsup (-3.808509373683396527e-193, 7.757841386304002834e-162)), infsup (-3.808509373683397013e-193, 7.757841386304003821e-162)));
%!test
%! assert (isequal (atanh (infsup (-1.187397361107265637e-112, -2.668312821848315349e-303)), infsup (-1.187397361107265868e-112, -2.668312821848315349e-303)));
%!test
%! assert (isequal (atanh (infsup (-1.263586867414290315e-101, -2.961257846195185529e-240)), infsup (-1.263586867414290474e-101, -2.961257846195185529e-240)));
%!test
%! assert (isequal (atanh (infsup (-3.901714394731276617e-270, -3.330134658353580222e-294)), infsup (-3.901714394731277458e-270, -3.330134658353580222e-294)));
%!test
%! assert (isequal (atanh (infsup (-2.366650777764918445e-246, 1.071483042175132919e-285)), infsup (-2.366650777764918953e-246, 1.071483042175133106e-285)));
%!test
%! assert (isequal (atanh (infsup (-4.636590066075016366e-69, 5.524052139366596165e-240)), infsup (-4.636590066075017395e-69, 5.524052139366597231e-240)));
%!test
%! assert (isequal (atanh (infsup (1.178822725995249352e-253, 3.080763910515160059e-167)), infsup (1.178822725995249352e-253, 3.080763910515160435e-167)));
%!test
%! assert (isequal (atanh (infsup (-1.102346734829299702e-19, 6.850446591467340374e-81)), infsup (-1.102346734829299943e-19, 6.850446591467341310e-81)));
%!test
%! assert (isequal (atanh (infsup (-3.809307924483539467e-117, 2.162545233549648523e-70)), infsup (-3.809307924483540172e-117, 2.162545233549648845e-70)));
%!test
%! assert (isequal (atanh (infsup (-3.325515536019971910e-77, -2.504008447335657004e-137)), infsup (-3.325515536019972294e-77, -2.504008447335657004e-137)));
%!test
%! assert (isequal (atanh (infsup (-1.559805661433223275e-242, 7.909368633706727513e-07)), infsup (-1.559805661433223483e-242, 7.909368633708377109e-07)));
%!test
%! assert (isequal (atanh (infsup (-5.969914231928147727e-104, -6.050096414444652455e-262)), infsup (-5.969914231928148967e-104, -6.050096414444652455e-262)));
%!test
%! assert (isequal (atanh (infsup (-1.312550047541150255e-20, -6.354261176220087715e-253)), infsup (-1.312550047541150406e-20, -6.354261176220087715e-253)));
%!test
%! assert (isequal (atanh (infsup (4.567490786574823890e-149, 4.198196690886986340e-123)), infsup (4.567490786574823890e-149, 4.198196690886987012e-123)));
%!test
%! assert (isequal (atanh (infsup (-9.884682253430382309e-92, -5.579479013164953220e-154)), infsup (-9.884682253430383672e-92, -5.579479013164953220e-154)));
%!test
%! assert (isequal (atanh (infsup (-1.522662321416928111e-13, 2.644958365616577639e-170)), infsup (-1.522662321416928363e-13, 2.644958365616578006e-170)));
%!test
%! assert (isequal (atanh (infsup (-8.948553501584778180e-99, 2.114326410545258721e-257)), infsup (-8.948553501584779804e-99, 2.114326410545259090e-257)));
%!test
%! assert (isequal (atanh (infsup (-9.422591232382868792e-70, -6.531943700592087501e-157)), infsup (-9.422591232382870079e-70, -6.531943700592087501e-157)));
%!test
%! assert (isequal (atanh (infsup (-4.183491534989001599e-145, 7.226922481530353777e-207)), infsup (-4.183491534989002310e-145, 7.226922481530355161e-207)));
%!test
%! assert (isequal (atanh (infsup (-1.261760095202863281e-243, 1.140396740717171993e-231)), infsup (-1.261760095202863541e-243, 1.140396740717172136e-231)));
%!test
%! assert (isequal (atanh (infsup (-6.921640701718756344e-64, -1.404179941832861768e-165)), infsup (-6.921640701718757694e-64, -1.404179941832861768e-165)));
%!test
%! assert (isequal (atanh (infsup (-7.429895589392232365e-75, -7.756983358701570246e-275)), infsup (-7.429895589392233347e-75, -7.756983358701570246e-275)));
%!test
%! assert (isequal (atanh (infsup (6.867158476684655683e-209, 1.563441271274809437e-199)), infsup (6.867158476684655683e-209, 1.563441271274809669e-199)));
%!test
%! assert (isequal (atanh (infsup (-9.032911858299409062e-169, 3.060735534879519294e-91)), infsup (-9.032911858299410238e-169, 3.060735534879519839e-91)));
%!test
%! assert (isequal (atanh (infsup (-5.007253407091102708e-155, 2.431811725358315428e-307)), infsup (-5.007253407091103536e-155, 2.431811725358315824e-307)));
%!test
%! assert (isequal (expm1 (infsup (-5.654676730021285758e+33, -2.467054147405823936e-70)), infsup (-1.000000000000000000e+00, -2.467054147405823614e-70)));
%!test
%! assert (isequal (expm1 (infsup (-1.339988487076310626e-66, -3.142176739251405931e-153)), infsup (-1.339988487076310626e-66, -3.142176739251405401e-153)));
%!test
%! assert (isequal (expm1 (infsup (-1.559745526584455293e+82, -8.494812002392629213e-61)), infsup (-1.000000000000000000e+00, -8.494812002392627831e-61)));
%!test
%! assert (isequal (expm1 (infsup (-1.215647583031333080e-125, -2.146363543986120533e-137)), infsup (-1.215647583031333080e-125, -2.146363543986120294e-137)));
%!#expm1 [-0X6.FF424CB26239CP+292, -0X2.89F6682121BA8P+252] = [-0X1.0000000000000P+0, -0X1.0000000000000P+0];
%!test
%! assert (isequal (expm1 (infsup (-7.439842988767636755e+100, -1.769170660676674389e+00)), infsup (-1.000000000000000000e+00, -8.295256887348699815e-01)));
%!test
%! assert (isequal (expm1 (infsup (-7.499234869798133827e+71, -1.740341118088671732e-132)), infsup (-1.000000000000000000e+00, -1.740341118088671419e-132)));
%!test
%! assert (isequal (expm1 (infsup (-2.932406654409041728e+52, -5.352481974657761661e-104)), infsup (-1.000000000000000000e+00, -5.352481974657761041e-104)));
%!test
%! assert (isequal (expm1 (infsup (-5.017847776764403958e-87, -2.227977792271395082e-227)), infsup (-5.017847776764403958e-87, -2.227977792271394613e-227)));
%!test
%! assert (isequal (expm1 (infsup (-1.827668734769395026e-22, -1.326175859067188756e-169)), infsup (-1.827668734769395026e-22, -1.326175859067188461e-169)));
%!#expm1 [-0X1.582D3AFB2C63DP+312, -0X5.08DC843E57ED4P+180] = [-0X1.0000000000000P+0, -0X1.0000000000000P+0];
%!test
%! assert (isequal (expm1 (infsup (-5.423963041733560701e+77, -2.059305088062927775e-14)), infsup (-1.000000000000000000e+00, -2.059305088062906318e-14)));
%!test
%! assert (isequal (expm1 (infsup (-3.360610542799653195e+197, -5.874775479904158146e+02)), infsup (-1.000000000000000000e+00, -9.999999999999998890e-01)));
%!#expm1 [-0X3.2FD3FDE325402P+688, -0X2.738623C238270P+48] = [-0X1.0000000000000P+0, -0X1.0000000000000P+0];
%!test
%! assert (isequal (expm1 (infsup (-3.249456070719769514e+02, -3.915939161035242553e-52)), infsup (-1.000000000000000000e+00, -3.915939161035241811e-52)));
%!test
%! assert (isequal (expm1 (infsup (-6.756234292039407244e+297, -1.232680690145569154e-163)), infsup (-1.000000000000000000e+00, -1.232680690145569000e-163)));
%!test
%! assert (isequal (expm1 (infsup (-3.768432504481998329e-45, -1.425448715493971452e-132)), infsup (-3.768432504481998329e-45, -1.425448715493971139e-132)));
%!test
%! assert (isequal (expm1 (infsup (-6.868984884638793653e+105, -1.124545542537290068e-153)), infsup (-1.000000000000000000e+00, -1.124545542537289935e-153)));
%!#expm1 [-0XD.F2552B8F60978P+236, -0X7.FBDBC320979A4P+188] = [-0X1.0000000000000P+0, -0X1.0000000000000P+0];
%!test
%! assert (isequal (expm1 (infsup (-4.825221040561267626e-72, -3.741418656433786262e-95)), infsup (-4.825221040561267626e-72, -3.741418656433785596e-95)));
%!test
%! assert (isequal (expm1 (infsup (1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (1.718281828459045091e+00, 6.389056098930650407e+00)));
%!test
%! assert (isequal (expm1 (infsup (-1.000000000000000000e+00, 2.000000000000000000e+00)), infsup (-6.321205588285577770e-01, 6.389056098930650407e+00)));
%!test
%! assert (isequal (expm1 (infsup (-5.000000000000000000e+00, -3.000000000000000000e+00)), infsup (-9.932620530009146353e-01, -9.502129316321360486e-01)));
%!test
%! assert (isequal (expm1 (infsup (-2.000000000000000000e+00, 5.999999999999999778e-01)), infsup (-8.646647167633874087e-01, 8.221188003905089969e-01)));
%!test
%! assert (isequal (expm1 (infsup (4.940656458412465442e-324, 5.526030376261632760e-318)), infsup (4.940656458412465442e-324, 5.526035316918091172e-318)));
%!test
%! assert (isequal (expm1 (infsup (2.158572806680406152e-320, 1.000000000000000000e+00)), infsup (2.158572806680406152e-320, 1.718281828459045313e+00)));
%!test
%! assert (isequal (expm1 (infsup (-3.453765897253233967e-319, 3.453765897253233967e-319)), infsup (-3.453765897253233967e-319, 3.453815303817818092e-319)));
%!test
%! assert (isequal (expm1 (infsup (-1.348799213146603066e-321, 1.999755859375000000e+00)), infsup (-1.348799213146603066e-321, 6.387252350349609920e+00)));
%!test
%! assert (isequal (expm1 (infsup (-1.999984741210937500e+00, -1.768329819216851651e-316)), infsup (-8.646626516950925989e-01, -1.768329769810287067e-316)));
%!test
%! assert (isequal (expm1 (infsup (-1.999999996274709702e+00, 4.668945501635218808e-314)), infsup (-8.646647162592241420e-01, 4.668945502129284454e-314)));
%!test
%! assert (isequal (log1p (infsup (4.147420261371489825e-79, 5.379571027897612396e+28)), infsup (4.147420261371489226e-79, 6.615499124023648392e+01)));
%!test
%! assert (isequal (log1p (infsup (1.110880646187224313e-155, 2.373351651082584966e-67)), infsup (1.110880646187224105e-155, 2.373351651082584966e-67)));
%!test
%! assert (isequal (log1p (infsup (5.129079157666995424e-72, 1.751070362531829627e+71)), infsup (5.129079157666994419e-72, 1.640437688392722464e+02)));
%!test
%! assert (isequal (log1p (infsup (6.948997631311531055e-148, 2.928301646694579776e-136)), infsup (6.948997631311529665e-148, 2.928301646694579776e-136)));
%!test
%! assert (isequal (log1p (infsup (1.228976222624138207e+59, 2.234162998792154053e+68)), infsup (1.360587019701163172e+02, 1.573796529843343421e+02)));
%!test
%! assert (isequal (log1p (infsup (3.765881959744468747e-13, 4.282127607174989696e+83)), infsup (3.765881959743759404e-13, 1.925690127090641397e+02)));
%!test
%! assert (isequal (log1p (infsup (6.336975772360046338e-144, 9.158993707856365702e+59)), infsup (6.336975772360045200e-144, 1.380672568020790720e+02)));
%!test
%! assert (isequal (log1p (infsup (5.364761505213512494e-113, 4.082352475280499044e+42)), infsup (5.364761505213511340e-113, 9.811524731508208674e+01)));
%!test
%! assert (isequal (log1p (infsup (7.550677903404239041e-232, 3.224750948704370352e-99)), infsup (7.550677903404237611e-232, 3.224750948704370352e-99)));
%!test
%! assert (isequal (log1p (infsup (1.225297990074229138e-174, 4.817234909117431242e-40)), infsup (1.225297990074228914e-174, 4.817234909117431242e-40)));
%!test
%! assert (isequal (log1p (infsup (2.170435512584716658e+35, 4.550722777302786970e+83)), infsup (8.136540609925064871e+01, 1.926298487910074471e+02)));
%!test
%! assert (isequal (log1p (infsup (2.535659632151250680e-30, 4.662866785261630365e+61)), infsup (2.535659632151250329e-30, 1.419973211215928757e+02)));
%!test
%! assert (isequal (log1p (infsup (7.582817216007211414e+01, 2.533325420226928244e+179)), infsup (4.341571397890723105e+00, 4.130922644809588746e+02)));
%!test
%! assert (isequal (log1p (infsup (2.679384856388388202e+06, 3.456099944072672956e+189)), infsup (1.480109816816228374e+01, 4.364287233454008401e+02)));
%!test
%! assert (isequal (log1p (infsup (2.298466163925377139e-53, 3.422642591789022920e-07)), infsup (2.298466163925376675e-53, 3.422642006065041091e-07)));
%!test
%! assert (isequal (log1p (infsup (8.331537116545182766e-169, 1.276575089856515728e+278)), infsup (8.331537116545181589e-169, 6.403628366331134885e+02)));
%!test
%! assert (isequal (log1p (infsup (3.718156390017819207e-141, 1.084633607212178861e-48)), infsup (3.718156390017818625e-141, 1.084633607212178861e-48)));
%!test
%! assert (isequal (log1p (infsup (3.157294329035461405e-160, 9.898300388558577825e+97)), infsup (3.157294329035460773e-160, 2.256431170849012631e+02)));
%!test
%! assert (isequal (log1p (infsup (1.083356361649631714e+44, 3.415036575780023082e+59)), infsup (1.013938080560929649e+02, 1.370807086899449985e+02)));
%!test
%! assert (isequal (log1p (infsup (8.455584990678977241e-99, 6.051563441903092353e-73)), infsup (8.455584990678975617e-99, 6.051563441903092353e-73)));
%!test
%! assert (isequal (log1p (infsup (2.360349141715971707e+109, 8.567792987486366378e+158)), infsup (2.518405846858512973e+02, 3.659564548647884408e+02)));
%!test
%! assert (isequal (log1p (infsup (2.012916824299288793e-32, 2.822293342336804668e+41)), infsup (2.012916824299288519e-32, 9.544353860916723420e+01)));
%!test
%! assert (isequal (log1p (infsup (4.831139778854605785e-107, 2.083134309679031648e-23)), infsup (4.831139778854605180e-107, 2.083134309679031648e-23)));
%!test
%! assert (isequal (log1p (infsup (8.466268199564697371e-76, 1.680782691923963737e-10)), infsup (8.466268199564696144e-76, 1.680782691782712307e-10)));
%!test
%! assert (isequal (log1p (infsup (2.283702426861795342e-151, 2.158830003381976904e+22)), infsup (2.283702426861795002e-151, 5.142643845571060979e+01)));
%!test
%! assert (isequal (log1p (infsup (1.114428406645123204e-64, 1.137441975089809242e+58)), infsup (1.114428406645123036e-64, 1.336787172532864645e+02)));
%!test
%! assert (isequal (log1p (infsup (1.463767593806767211e-207, 3.684178239990781413e-44)), infsup (1.463767593806767038e-207, 3.684178239990781413e-44)));
%!test
%! assert (isequal (log1p (infsup (1.806590984564742948e+58, 4.476357965164357790e+78)), infsup (1.341413770290983223e+02, 1.811004470151316070e+02)));
%!test
%! assert (isequal (log1p (infsup (2.504949335867761681e-102, 4.444462712533866271e+177)), infsup (2.504949335867761285e-102, 4.090492204470355091e+02)));
%!test
%! assert (isequal (log1p (infsup (1.027829701532525701e-53, 1.755408547816880709e-45)), infsup (1.027829701532525585e-53, 1.755408547816880709e-45)));
%!test
%! assert (isequal (realsqrt (infsup (4.147420261371489825e-79, 5.379571027897612396e+28)), infsup (6.440046786609154008e-40, 2.319390227602421562e+14)));
%!test
%! assert (isequal (realsqrt (infsup (1.110880646187224313e-155, 2.373351651082584966e-67)), infsup (3.332987618019641001e-78, 4.871705708561002190e-34)));
%!test
%! assert (isequal (realsqrt (infsup (5.129079157666995424e-72, 1.751070362531829627e+71)), infsup (2.264747040547132332e-36, 4.184579265029914561e+35)));
%!test
%! assert (isequal (realsqrt (infsup (6.948997631311531055e-148, 2.928301646694579776e-136)), infsup (2.636095148379802032e-74, 1.711228110654620020e-68)));
%!test
%! assert (isequal (realsqrt (infsup (1.228976222624138207e+59, 2.234162998792154053e+68)), infsup (3.505675716069781836e+29, 1.494711677479022891e+34)));
%!test
%! assert (isequal (realsqrt (infsup (3.765881959744468747e-13, 4.282127607174989696e+83)), infsup (6.136678221761727970e-07, 6.543796762717337107e+41)));
%!test
%! assert (isequal (realsqrt (infsup (6.336975772360046338e-144, 9.158993707856365702e+59)), infsup (2.517335053654964799e-72, 9.570263166630459163e+29)));
%!test
%! assert (isequal (realsqrt (infsup (5.364761505213512494e-113, 4.082352475280499044e+42)), infsup (7.324453225472541740e-57, 2.020483228161149501e+21)));
%!test
%! assert (isequal (realsqrt (infsup (7.550677903404239041e-232, 3.224750948704370352e-99)), infsup (2.747849687192557654e-116, 5.678689064127715303e-50)));
%!test
%! assert (isequal (realsqrt (infsup (1.225297990074229138e-174, 4.817234909117431242e-40)), infsup (1.106931791066743519e-87, 2.194820017476930231e-20)));
%!test
%! assert (isequal (realsqrt (infsup (2.170435512584716658e+35, 4.550722777302786970e+83)), infsup (4.658793312205121280e+17, 6.745904518522914642e+41)));
%!test
%! assert (isequal (realsqrt (infsup (2.535659632151250680e-30, 4.662866785261630365e+61)), infsup (1.592375468333787993e-15, 6.828518715842866868e+30)));
%!test
%! assert (isequal (realsqrt (infsup (7.582817216007211414e+01, 2.533325420226928244e+179)), infsup (8.707937308000792243e+00, 5.033215095966919400e+89)));
%!test
%! assert (isequal (realsqrt (infsup (2.679384856388388202e+06, 3.456099944072672956e+189)), infsup (1.636882664209132599e+03, 5.878860386225099984e+94)));
%!test
%! assert (isequal (realsqrt (infsup (2.298466163925377139e-53, 3.422642591789022920e-07)), infsup (4.794232121962157468e-27, 5.850335538914860564e-04)));
%!test
%! assert (isequal (realsqrt (infsup (8.331537116545182766e-169, 1.276575089856515728e+278)), infsup (9.127725410278938219e-85, 1.129856225303253353e+139)));
%!test
%! assert (isequal (realsqrt (infsup (3.718156390017819207e-141, 1.084633607212178861e-48)), infsup (6.097668726667445732e-71, 1.041457443783556123e-24)));
%!test
%! assert (isequal (realsqrt (infsup (3.157294329035461405e-160, 9.898300388558577825e+97)), infsup (1.776877691073716194e-80, 9.949020247521149013e+48)));
%!test
%! assert (isequal (realsqrt (infsup (1.083356361649631714e+44, 3.415036575780023082e+59)), infsup (1.040844062119600901e+22, 5.843831427907570747e+29)));
%!test
%! assert (isequal (realsqrt (infsup (8.455584990678977241e-99, 6.051563441903092353e-73)), infsup (9.195425488077740187e-50, 7.779179546650850484e-37)));
%!test
%! assert (isequal (realsqrt (infsup (2.360349141715971707e+109, 8.567792987486366378e+158)), infsup (4.858342455731143318e+54, 2.927079258832320626e+79)));
%!test
%! assert (isequal (realsqrt (infsup (2.012916824299288793e-32, 2.822293342336804668e+41)), infsup (1.418772999566628592e-16, 5.312526086841179177e+20)));
%!test
%! assert (isequal (realsqrt (infsup (4.831139778854605785e-107, 2.083134309679031648e-23)), infsup (6.950640099195617068e-54, 4.564136621179335194e-12)));
%!test
%! assert (isequal (realsqrt (infsup (8.466268199564697371e-76, 1.680782691923963737e-10)), infsup (2.909685240634233473e-38, 1.296450034488010588e-05)));
%!test
%! assert (isequal (realsqrt (infsup (2.283702426861795342e-151, 2.158830003381976904e+22)), infsup (4.778809921792030281e-76, 1.469295750821452942e+11)));
%!test
%! assert (isequal (realsqrt (infsup (1.114428406645123204e-64, 1.137441975089809242e+58)), infsup (1.055664912102852335e-32, 1.066509247540690319e+29)));
%!test
%! assert (isequal (realsqrt (infsup (1.463767593806767211e-207, 3.684178239990781413e-44)), infsup (3.825921580229744811e-104, 1.919421329461247340e-22)));
%!test
%! assert (isequal (realsqrt (infsup (1.806590984564742948e+58, 4.476357965164357790e+78)), infsup (1.344094856981732069e+29, 2.115740524063468000e+39)));
%!test
%! assert (isequal (realsqrt (infsup (2.504949335867761681e-102, 4.444462712533866271e+177)), infsup (1.582703173645570547e-51, 6.666680367719655103e+88)));
%!test
%! assert (isequal (realsqrt (infsup (1.027829701532525701e-53, 1.755408547816880709e-45)), infsup (3.205978324213258952e-27, 4.189759596703468421e-23)));
%!test
%! assert (isequal (sqr (infsup (-1.820250631842705497e-45, -9.117403206523163851e-284)), infsup (0.000000000000000000e+00, 3.313312362723768996e-90)));
%!test
%! assert (isequal (sqr (infsup (-9.132843019095516065e-132, -9.836586939929288236e-188)), infsup (0.000000000000000000e+00, 8.340882161144170744e-263)));
%!test
%! assert (isequal (sqr (infsup (-8.631384205445317548e+01, -2.269091389186822222e-289)), infsup (0.000000000000000000e+00, 7.450079330201089761e+03)));
%!test
%! assert (isequal (sqr (infsup (-1.654017949299359065e-112, 1.159376035639006975e-176)), infsup (0.000000000000000000e+00, 2.735775376604457287e-224)));
%!test
%! assert (isequal (sqr (infsup (-2.261578927830210317e-107, -2.921845682025291002e-170)), infsup (0.000000000000000000e+00, 5.114739246805643826e-214)));
%!test
%! assert (isequal (sqr (infsup (-1.469458391712281360e-99, -1.976254011990074054e-124)), infsup (3.905579919906863034e-248, 2.159307964973644752e-198)));
%!test
%! assert (isequal (sqr (infsup (-1.088588131986426258e-12, -3.239993862505298994e-238)), infsup (0.000000000000000000e+00, 1.185024121101697110e-24)));
%!test
%! assert (isequal (sqr (infsup (-3.114600191344484305e-60, -1.151057432815240852e-61)), infsup (1.324933213639212643e-122, 9.700734351923098806e-120)));
%!test
%! assert (isequal (sqr (infsup (3.215755734598088570e-80, 2.860247434645490115e-24)), infsup (1.034108494460049166e-159, 8.181015387396108212e-48)));
%!test
%! assert (isequal (sqr (infsup (-7.599545156767026148e-113, -3.620806299549831939e-276)), infsup (0.000000000000000000e+00, 5.775308658974116928e-225)));
%!test
%! assert (isequal (sqr (infsup (-8.378054792460110690e-178, 2.171929406448802147e-04)), infsup (0.000000000000000000e+00, 4.717277346597046512e-08)));
%!test
%! assert (isequal (sqr (infsup (-6.977305240208117095e-101, -5.652987073406890307e-174)), infsup (0.000000000000000000e+00, 4.868278841503565141e-201)));
%!test
%! assert (isequal (sqr (infsup (-5.464129729164141708e-282, 9.669182275976748412e-117)), infsup (0.000000000000000000e+00, 9.349308588606289563e-233)));
%!test
%! assert (isequal (sqr (infsup (-2.609094333453398954e-148, 5.011306988287881225e-06)), infsup (0.000000000000000000e+00, 2.511319773086295719e-11)));
%!test
%! assert (isequal (sqr (infsup (-2.520164184091732485e-91, -6.923225182185906259e-252)), infsup (0.000000000000000000e+00, 6.351227514778747876e-182)));
%!test
%! assert (isequal (sqr (infsup (-2.058411222963202619e-150, -1.691080271454051769e-229)), infsup (0.000000000000000000e+00, 4.237056762820867958e-300)));
%!test
%! assert (isequal (sqr (infsup (-1.194912260770650641e-171, -3.063641562993914407e-235)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!test
%! assert (isequal (sqr (infsup (-1.410213021759318257e-164, 2.113307206456483530e-235)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!test
%! assert (isequal (sqr (infsup (-2.734402476279937437e-15, 2.214286456252711975e-200)), infsup (0.000000000000000000e+00, 7.476956902285853824e-30)));
%!test
%! assert (isequal (sqr (infsup (-4.736813689297963792e-37, -3.757820326147841254e-165)), infsup (0.000000000000000000e+00, 2.243740392712058757e-73)));
%!test
%! assert (isequal (sqr (infsup (-1.178872317111653867e-269, -3.697079530478824433e-304)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!test
%! assert (isequal (sqr (infsup (-3.170977600535302060e-50, 1.773732353250808790e-223)), infsup (0.000000000000000000e+00, 1.005509894309662304e-99)));
%!test
%! assert (isequal (sqr (infsup (-9.582715182984806788e-234, -6.481946913158783102e-280)), infsup (0.000000000000000000e+00, 4.940656458412465442e-324)));
%!test
%! assert (isequal (sqr (infsup (1.510030059283921314e-212, 1.357381528725581723e-08)), infsup (0.000000000000000000e+00, 1.842484614525397339e-16)));
%!test
%! assert (isequal (sqr (infsup (-1.323507196051687166e-113, 8.782017701712098963e-233)), infsup (0.000000000000000000e+00, 1.751671298000599397e-226)));
%!test
%! assert (isequal (sqr (infsup (-7.715995104235895070e-26, -1.871718785128404206e-162)), infsup (0.000000000000000000e+00, 5.953658044859230885e-51)));
%!test
%! assert (isequal (sqr (infsup (-3.395185885371617857e-83, -1.892322506995032646e-149)), infsup (3.580884470479965241e-298, 1.152728719622665870e-165)));
%!test
%! assert (isequal (sqr (infsup (-1.449285613317172764e-98, -5.707789272110613126e-264)), infsup (0.000000000000000000e+00, 2.100428788968133734e-196)));
%!test
%! assert (isequal (sqr (infsup (-1.045711771041448932e-76, 2.500374714085601101e-183)), infsup (0.000000000000000000e+00, 1.093513108094643860e-152)));
%!test
%! assert (isequal (sqr (infsup (-1.069106323474023944e-70, -1.300019611184126890e-129)), infsup (1.690050989463328240e-258, 1.142988330892144404e-140)));
