#!/usr/bin/perl -w # -*- mode: perl -*-

#
# Wrapper for XML::Handler::EasyTree
# to be as compatible with the GNU stuff
# as possible
#

package XML::Handler::EasyTree::Builder;
require Exporter;
use XML::Parser;
use XML::Parser::PerlSAX;
use XML::Handler::Trees;
use IO::Handle;

@ISA= qw(Exporter);
@EXPORT_OK= qw(new
	       stringToTree
	       fileToTree
	       streamToTree);
	    
#
# create a new easy tree builder
#
sub new( ){
  my $class = shift;
  my $self = {};
  bless $self, $class;

  $self->initialize();
  return $self;
}

#
# make a parser
#
sub initialize(){
  my$self=shift;
  $self->{parser}=new XML::Parser::PerlSAX;
}

#
# parse a string
#
sub stringToTree( $ ){
  my $self=shift;

  my $inString=shift;

  my $lHandler=XML::Handler::EasyTree->new(Noempty=>1);
 $self->{tree}=$self->{parser}->parse(Handler=>$lHandler,
				      Source=>{String=>$inString});
                                                                            
  return $self->{tree};
}

#
# give back a file
#
sub fileToTree( $ ){
  my $self=shift;

  my $fileName=shift;

  $self->{stack}=[];
  
  my $lHandler=XML::Handler::EasyTree->new(Noempty=>1);
  $self->{tree}=$self->{parser}->parse(Handler=>$lHandler,
				       Source=>{SystemID=>$fileName});
  
  return $self->{tree};
}

#
# give back a file
#
sub streamToTree( $ ){
  my $self=shift;

  my $fileName=shift;

  $self->{stack}=[];
  
  my $lHandler=XML::Handler::EasyTree->new(Noempty=>1);
  $self->{tree}=$self->{parser}->parse(Handler=>$lHandler,
				       Source=>{ByteStream=>$fileName});
  
  return $self->{tree};
}


package main;
