#! /usr/bin/perl -w

############################################################
#
# This code is GPL|Artistic dual licensed.
#
# See either Artistic.html or COPYING for the exact conditions.
# Choose among Artistic.html and COPYING the license you prefer.
#
# THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# (C) 2001 Centre Universitaire d'Informatique, University of Geneva
#
# Author: Wolfgang M&uuml;ller  <Wolfgang.MUELLER@cui.unige.ch>

use XML::Writer;

require Exporter;

use MRML::Client::Base;
package main;

=pod

=head1 NAME

TestingClient.pl - a minimal client for testing MRML servers

=head1 SYNOPSIS

  TestingClient.pl host.some.where:10101

=head1 DESCRIPTION

THIS VERSION IS OUTDATED BUT FUNCTIONAL. 
A NEW ONE WILL BE RELEASED WITH 
BenchathlonStarterPackage 0.06


This MRML client opens a connection to the host and port given in
the parameter. It opens an MRML session, configures it (algorithm: adefault,
collection: cdefault), queries it twice, and exits. 

The first query is a query for random images, the second queries for a 
given image.

After each step, the query results are shown using Data::Dumper;

=head1 SEE

 MRML::Client::Base
 Data::Dumper

=cut


use strict;
use vars qw($VERSION $g_client);
use Data::Dumper;

$VERSION="0.01";


my $lWriter=XML::Writer->new();

my $l_host=(shift || "localhost:10101");
print "Host: $l_host\n";
local $g_client=new MRML::Client::Base(address=>$l_host);
sub open_session{
    $g_client->open_session('user-name'=>"muellerw",
			    "session-name"=>"a-new-session");
}
eval "print Dumper(open_session)";
sub configure_session{
    $g_client->configure_session( "collection-id"=>"cdefault", 
				  "algorithm-id"=> "adefault");
}
eval "print Dumper(configure_session)";
sub send_message{
    $g_client->send_message(tree=>$g_client->generate_query_step('algorithm-id'=> 'adefault',
								 'result-size'=> 20,
								 'result-cutoff'=> 0,
								 tree=>[])
			    );
}
eval "print Dumper(send_message)";
sub send_message_second{
    $g_client->send_message(tree=>$g_client->generate_query_step('algorithm-id'=> 'adefault',
								 'result-size'=> 20,
								 'result-cutoff'=> 0,
								 tree=>[{
								     type=>'e',
								     name=>'user-relevance-element-list',
								     attrib=>{},
								     content=>[{
									 type=>'e',
									 name=>'user-relevance-element',
									 attrib=>{
									     'user-relevance'=>"1",
									     'image-location'=>"http://www.benchathlon.net/img/done/128x192/3328_2013/0519/0011.jpeg"
									     }
								     }]
								     }])
			    );
}
print Dumper(send_message_second);

#  $g_client->send_message(tree=>$g_client->generate_query_step('algorithm-id'=> 'adefault',
#  						       'result-size'=> 20,
#  						       'result-cutoff'=> 0,
#  						       tree=>[{
#  							       type=>'e',
#  							       name=>'cui-text-query',
#  							       attrib=>{'query-string'=>"honig"},
#  							       content=>[]
#  							      }])
#  		       );



















