/*
 * Copyright (C) 2003-2013 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_FRU_DIMMSPD_RECORD_FORMAT_H
#define IPMI_FRU_DIMMSPD_RECORD_FORMAT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <freeipmi/fiid/fiid.h>

/* 
 * see freeipmi/templates/ for template definitions 
 */

/* From "Annex K: Serial Presence Detect (SPD) for DDR3 SDRAM Modules"
 * 
 * Released by JEDEC
 */

#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_128       0x1
#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_176       0x2
#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_256       0x3

#define IPMI_FRU_DIMMSPD_SPD_BYTES_TOTAL_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_SPD_BYTES_TOTAL_256       0x1

#define IPMI_FRU_DIMMSPD_CRC_COVERAGE_0_TO_125     0x0
#define IPMI_FRU_DIMMSPD_CRC_COVERAGE_0_TO_116     0x1

#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_RESERVED                 0x00
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_STANDARD_FPM_DRAM        0x01
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_EDO                      0x02
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_PIPELINED_NIBBLE         0x03
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_SDRAM                    0x04
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_ROM                      0x05
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR_SGRAM                0x06
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR_SDRAM                0x07
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR2_SDRAM               0x08
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR2_SDRAM_FB_DIMM       0x09
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR2_SDRAM_FB_DIMM_PROBE 0x0A
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR3_SDRAM               0x0B

/* RDIMM - Registered Dual In-Line Memory Module 
 * LRDIMM - Load Reduction DIMM 
 * UDIMM - Unbuffered DIMM
 * SO-DIMM - Unbuffered 64-bit Small Outline DIMM 
 * Micro-DIMM - Micro DIMM 
 * Mini-RDIMM - Mini RDIMM
 * Mini-UDIMM - Mini UDIMM
 * Mini-CDIMM - Clocked 72-bit Mini DIMM
 * 72b-SO-UDIMM - Unbuffered 72-bit SO-DIMM
 * 72b-SO-RDIMM - Registered 72-bit SO-DIMM
 * 72b-SO-CDIMM - Clocked 72-bit SO-DIMM
 * 16b-SO-DIMM - Unbuffered 16-bit SO-DIMM
 * 32b-SO-DIMM - Unbuffered 32-bit SO-DIMM
 */
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_UNDEFINED
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_RDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_UDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_SO_DIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MICRO_DIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MINI_RDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MINI_UDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MINI_CDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_72B_SO_UDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_72B_SO_RDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_72B_SO_CDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_LRDIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_16B_SO_DIMM
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_32B_SO_DIMM

/* In megabits / gigabits */
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_256_MB 0x0
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_512_MB 0x1
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_1_GB   0x2
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_2_GB   0x3
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_4_GB   0x4
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_8_GB   0x5
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_16_GB  0x6

#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_3 0x0 /* 8 banks */
#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_4 0x1 /* 16 banks */
#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_5 0x2 /* 32 banks */
#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_6 0x3 /* 64 banks */

#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_9  0x0
#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_10 0x1
#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_11 0x2
#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_12 0x3

#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_12    0x0
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_13    0x1
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_14    0x2
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_15    0x3
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_16    0x4

/* Yes, flags are opposite of normal logic for 1.5V */
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_5_OPERABLE     0x0
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_5_NOT_OPERABLE 0x1

#define IPMI_FRU_DIMMSPD_VOLTAGE_1_35_OPERABLE     0x1
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_35_NOT_OPERABLE 0x0

#define IPMI_FRU_DIMMSPD_VOLTAGE_1_25_OPERABLE     0x1
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_25_NOT_OPERABLE 0x0

#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_4_BITS  0x0
#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_8_BITS  0x1
#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_16_BITS 0x2
#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_32_BITS 0x3

#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_1    0x0
#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_2    0x1
#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_3    0x2
#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_4    0x3

#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_8_BITS  0x0
#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_16_BITS 0x1
#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_32_BITS 0x2
#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_64_BITS 0x3

#define IPMI_FRU_DIMMSPD_BUS_WIDTH_EXTENSION_0_BITS 0x0
#define IPMI_FRU_DIMMSPD_BUS_WIDTH_EXTENSION_8_BITS 0x1

#define IPMI_FRU_DIMMSPD_CAS_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_CAS_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_RZQ_6_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_RZQ_6_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_RZQ_7_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_RZQ_7_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_DLL_OFF_MODE_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_DLL_OFF_MODE_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_NORMAL_RANGE              0x0 /* 0-85 C */
#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_NORMAL_AND_EXTENDED_RANGE 0x1 /* 0-95 C */

#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_REFRESH_RATE_2X 0x0
#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_REFRESH_RATE_1X 0x1

#define IPMI_FRU_DIMMSPD_AUTO_SELF_REFRESH_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_AUTO_SELF_REFRESH_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_ON_DIE_THERMAL_SENSOR_READOUT_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_ON_DIE_THERMAL_SENSOR_READOUT_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_PARTIAL_ARRAY_SELF_REFRESH_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_PARTIAL_ARRAY_SELF_REFRESH_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_THERMAL_SENSOR_NOT_INCORPORATED 0x0
#define IPMI_FRU_DIMMSPD_THERMAL_SENSOR_INCORPORATED     0x1

#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_NOT_SPECIFIED     0x0
#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_MULTI_LOAD_STACK  0x1
#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_SINGLE_LOAD_STACK 0x2
#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_RESERVED          0x3

#define IPMI_FRU_DIMMSPD_DIE_COUNT_NOT_SPECIFIED     0x0
#define IPMI_FRU_DIMMSPD_DIE_COUNT_SINGLE_DIE        0x1
#define IPMI_FRU_DIMMSPD_DIE_COUNT_2_DIE             0x2
#define IPMI_FRU_DIMMSPD_DIE_COUNT_4_DIE             0x3
#define IPMI_FRU_DIMMSPD_DIE_COUNT_8_DIE             0x4

#define IPMI_FRU_DIMMSPD_SDRAM_DEVICE_TYPE_STANDARD_MONOLITHIC_DRAM_DEVICE 0x0
#define IPMI_FRU_DIMMSPD_SDRAM_DEVICE_TYPE_NON_STANDARD_DEVICE             0x1

extern fiid_template_t tmpl_fru_dimm_spd_ddr3_record;

#ifdef __cplusplus
}
#endif

#endif /* IPMI_FRU_DIMMSPD_RECORD_FORMAT_H */
