m4_dnl                                                  -*- m4 -*-
m4_dnl  fhp.m4 -- Main macros of GNU fhp
m4_dnl
m4_dnl  Copyright (C) 2002 Christian Neukirchen
m4_dnl
m4_dnl  This program is free software; you can redistribute it and/or modify
m4_dnl  it under the terms of the GNU General Public License as published by
m4_dnl  the Free Software Foundation; either version 2, or (at your option)
m4_dnl  any later version.
m4_dnl
m4_dnl  This program is distributed in the hope that it will be useful,
m4_dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
m4_dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
m4_dnl  GNU General Public License for more details.
m4_dnl
m4_dnl  You should have received a copy of the GNU General Public License
m4_dnl  along with this program; if not, write to the Free Software
m4_dnl  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
m4_dnl  02111-1307, USA.
m4_dnl
m4_dnl  Don't touch the next three lines!
m4_divert(-1)
m4_changequote([[, ]])
m4_changecom()

m4_define(_DefineInit_, [[m4_define([[_$1_Init_]], [[$2
m4_dnl  The `output file' is the filename with `.fhp' stripped.
m4_dnl  (It removes the language extension, too!)
m4_define(_fhp_output_file_, m4_patsubst(m4___file__, [[\.\([^\.]\|..\)*$]]))
]])m4_divert(-1)]])

m4_define(_GNU_, [[<A HREF="http://www.gnu.org/">GNU</A>]])

m4_dnl  $1: Macroname, $2: Name, $3: Mail, $4: Homepage
m4_define(_DefineHuman_,
[[m4_define($1, <A HREF="$4">$2</A> <A HREF="mailto:$3">&lt;$3&gt;</A>)]])

m4_dnl  $1: Title
m4_define(_SetTitle_, [[m4_define(_fhp_title_, [[$1]])]])

m4_dnl  $1: Name, $2: Mail
m4_define(_SetAuthor_, [[m4_define(_fhp_author_, $1)
                         m4_define(_fhp_author_mail_, $2)
                       ]])

m4_dnl  $1: Copyright holder, $2: Copyright years, $3: Copyright text
m4_define(_SetCopyright_, [[m4_define(_fhp_copyright_holder_, [[$1]])
                            m4_define(_fhp_copyright_years_, [[$2]])
                            m4_define(_fhp_copyright_text_, [[$3]])
                          ]])

m4_define(_Language_, [[
m4_divert(2)   | <A HREF="_fhp_output_file_.$1.html">$2</A>
m4_divert(3)   | <A HREF="_fhp_output_file_.$1.html">$2</A>
m4_divert(-1)]])

m4_define(_DefineStart_, [[
  m4_define(_Start_, [[m4_divert(0)$1 m4_divert(1)]])

]])
m4_define(_DefineEnd_, [[
  m4_define(_End_, [[$1]]m4_divert(-1))
]])

m4_define(_DefineHeading_, [[m4_define(_fhp_pre_toc_heading_, $1)
                             m4_define(_fhp_post_toc_heading_, $2)
                             m4_define(_fhp_pre_heading_, $3)
                             m4_define(_fhp_post_heading_, $4)]])

m4_define(_Heading_,
[[m4_divert(0)m4_dnl
m4_dnl  Define the ToC label as the title without special chars.
m4_define([[_fhp_body_label_]],
          [[m4_patsubst([[$1]], [[[^A-Za-z]]], [[]])]])m4_dnl
m4_define([[_fhp_toc_label_]],
          [[TOC[[]]m4_patsubst([[$1]], [[[^A-Za-z]]], [[]])]])m4_dnl
_fhp_pre_toc_heading_[[$1]]_fhp_post_toc_heading_
m4_divert(1)m4_dnl
_fhp_pre_heading_[[$1]]_fhp_post_heading_]])

m4_define(_DefineHeading2_, [[m4_define(_fhp_pre_heading2_, $1)
                             m4_define(_fhp_post_heading2_, $2)]])
m4_define(_Heading2_,
[[m4_dnl  Define the label as the title without special chars.
m4_define([[_fhp_body_label_]],
          [[m4_patsubst([[$1]], [[[^A-Za-z]]], [[]])]])m4_dnl
_fhp_pre_heading2_[[$1]]_fhp_post_heading2_]])

m4_define(_LinkToSec_,
[[<A HREF="#m4_patsubst([[$1]], [[[^A-Za-z]]], [[]])">$2</A>]])

m4_define(_LinkToExtSec_,
[[<A HREF="$1#m4_patsubst([[$2]], [[[^A-Za-z]]], [[]])">$3</A>]])

m4_sinclude([[./fhp_styles.m4]])
m4_sinclude([[./fhp_persons.m4]])
