/* Automatically generated file.  Do not edit directly. */

/* This file is part of The New Aspell
 * Copyright (C) 2001-2002 by Kevin Atkinson under the GNU LGPL
 * license version 2.0 or 2.1.  You should have received a copy of the
 * LGPL license along with this library if you did not you can find it
 * at http://www.gnu.org/.                                              */

#include "checker.hpp"
#include "error.hpp"
#include "posib_err.hpp"

namespace aspell {

class CanHaveError;
class Checker;
struct CheckerToken;
struct Error;
class Speller;

extern "C" CanHaveError * new_aspell_checker(Speller * speller)
{
  PosibErr<Checker *> ret = new_checker(speller);
  if (ret.has_err()) {
    return new CanHaveError(ret.release_err());
  } else {
    return ret;
  }
}

extern "C" Checker * to_aspell_checker(CanHaveError * obj)
{
  return static_cast<Checker *>(obj);
}

extern "C" void delete_aspell_checker(Checker * ths)
{
  delete ths;
}

extern "C" unsigned int aspell_checker_error_number(const Checker * ths)
{
  return ths->err_ == 0 ? 0 : 1;
}

extern "C" const char * aspell_checker_error_message(const Checker * ths)
{
  return ths->err_ ? ths->err_->mesg : "";
}

extern "C" const Error * aspell_checker_error(const Checker * ths)
{
  return ths->err_;
}

extern "C" void aspell_checker_reset(Checker * ths)
{
  ths->reset();
}

extern "C" void aspell_checker_process(Checker * ths, const char * str, unsigned int size, unsigned int ignore, void * which)
{
  ths->process(str, size, ignore, which);
}

extern "C" void aspell_checker_add_separator(Checker * ths)
{
  ths->add_separator();
}

extern "C" void aspell_checker_replace(Checker * ths, const char * str, unsigned int size)
{
  ths->replace(str, size);
}

extern "C" const CheckerToken * aspell_checker_next(Checker * ths)
{
  return ths->next();
}

extern "C" const CheckerToken * aspell_checker_next_misspelling(Checker * ths)
{
  return ths->next_misspelling();
}

extern "C" const CheckerToken * aspell_checker_cur(const Checker * ths)
{
  return ths->cur();
}

extern "C" void aspell_checker_set_more_data_callback(Checker * ths, MoreDataCallback * callback, void * callback_data)
{
  ths->set_more_data_callback(callback, callback_data);
}

extern "C" void aspell_checker_set_string_freed_callback(Checker * ths, StringFreedCallback * callback, void * callback_data)
{
  ths->set_string_freed_callback(callback, callback_data);
}

extern "C" void aspell_checker_set_span_strings(Checker * ths, int value)
{
  ths->set_span_strings(value);
}



}

