if(NOT DEFINED TEST_EXE OR NOT DEFINED OUT_FILE)
# noqa: spellcheck off
  message(FATAL_ERROR "simpletest_discover: need -DTEST_EXE and -DOUT_FILE")
# noqa: spellcheck on
endif()

execute_process(
  COMMAND ${TEST_EXE} --list
  RESULT_VARIABLE _rc
  OUTPUT_VARIABLE _out
  ERROR_VARIABLE _err
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

if(NOT _rc EQUAL 0)
  file(WRITE ${OUT_FILE} "# simpletest: --list failed (rc=${_rc})\n")
  message(FATAL_ERROR "simpletest_discover: '${TEST_EXE} --list' failed (${_rc})\n${_err}")
endif()

if(_out STREQUAL "")
  file(WRITE ${OUT_FILE} "# simpletest: no tests\n")
  return()
endif()

string(REPLACE "," ";" _names "${_out}")

file(WRITE ${OUT_FILE} "# Auto-generated by simpletest_discover_impl.cmake\n")
foreach(_name IN LISTS _names)
  file(APPEND ${OUT_FILE}
    "add_test([=[${_name}]=] \"${TEST_EXE}\" \"--test\" \"${_name}\")\n"
  )
endforeach()
